/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.analysiscolumn;

import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class RatePopoInfo {
    private BigDecimal fenmu = null;
    private BigDecimal fenzi = null;
    private BigDecimal result = null;
    private int scale = 8;
    private int roundingMode = 4;
    private boolean isReInitInfo = false;
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final BigDecimal HUNDREDE = new BigDecimal("100");
    public static final RatePopoInfo ZEOR_RATE_INFO = new RatePopoInfo(new BigDecimal("0.00"), new BigDecimal("1.00"), ZERO);

    public RatePopoInfo(BigDecimal fenzi, BigDecimal fenmu) {
        this.fenmu = fenmu;
        this.fenzi = fenzi;
    }

    public RatePopoInfo(BigDecimal fenzi, BigDecimal fenmu, BigDecimal result) {
        this.fenmu = fenmu;
        this.fenzi = fenzi;
        this.result = result;
    }

    public RatePopoInfo(BigDecimal fenzi, BigDecimal fenmu, BigDecimal result, int scale, int roundingMode) {
        this.fenmu = fenmu;
        this.fenzi = fenzi;
        this.result = result;
        this.scale = scale;
        this.roundingMode = roundingMode;
    }

    public boolean isFenmuZero() {
        return this.fenmu == null || this.fenmu.compareTo(ZERO) == 0;
    }

    public BigDecimal getFenmu() {
        return this.fenmu;
    }

    public void setFenmu(BigDecimal fenmu) {
        this.fenmu = fenmu;
    }

    public BigDecimal getFenzi() {
        return this.fenzi;
    }

    public void setFenzi(BigDecimal fenzi) {
        this.fenzi = fenzi;
    }

    public BigDecimal getResult() {
        return this.result;
    }

    public BigDecimal getResult1() {
        if (this.getResult() != null) {
            return this.getResult().divide(HUNDREDE, 8, this.roundingMode);
        }
        return null;
    }

    public void setResult(BigDecimal result) {
        this.result = result;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void initReuslt() {
        if (this.result == null) {
            this.result = this.fenzi != null && this.fenmu != null && this.fenmu.compareTo(ZERO) != 0 ? this.fenzi.multiply(HUNDREDE).divide(this.fenmu, this.scale, this.roundingMode) : ZERO;
        }
    }

    public void resetFenmuForAdjustAnalyse() {
        this.fenmu = this.fenmu.subtract(this.fenzi);
        this.result = null;
        this.initReuslt();
    }

    public String toString() {
        if (this.fenmu.compareTo(ZERO) == 0) {
            return "";
        }
        if (this.isReInitInfo) {
            String numberFormat = "#,##0.";
            for (int i = 0; i < this.scale; ++i) {
                numberFormat = numberFormat + "0";
            }
            DecimalFormat decFormat = new DecimalFormat(numberFormat, BgNationalFormatUIUtil.getDecimalFormatSymbols());
            return decFormat.format(this.result) + "%";
        }
        return this.result.toString() + "%";
    }

    public String getNumberFormat() {
        StringBuffer numberFormat = new StringBuffer("#,##0.");
        for (int i = 0; i < this.scale; ++i) {
            numberFormat.append("0");
        }
        numberFormat.append("%");
        return numberFormat.toString();
    }

    public String getNumberFormat(CurrencyInfo currency) {
        int prec = 2;
        if (currency != null) {
            prec = currency.getPrecision();
        }
        StringBuffer sb = new StringBuffer("#,##0.");
        for (int i = 0; i < prec; ++i) {
            sb.append("0");
        }
        sb.append("%");
        return sb.toString();
    }

    public RatePopoInfo getHeji() {
        RatePopoInfo heji = new RatePopoInfo(this.fenzi, this.fenmu);
        heji.setScale(this.scale);
        heji.initReuslt();
        return heji;
    }

    public boolean isReInitInfo() {
        return this.isReInitInfo;
    }

    public void setReInitInfo(boolean isReInitInfo) {
        this.isReInitInfo = isReInitInfo;
    }

    public static RatePopoInfo getZeroByFormat(int scale, boolean isFenmuIsZero) {
        RatePopoInfo info = new RatePopoInfo(new BigDecimal("0.00"), new BigDecimal("1.00"), ZERO);
        if (isFenmuIsZero) {
            info.setFenmu(ZERO);
        }
        info.setScale(scale);
        info.setReInitInfo(true);
        return info;
    }
}

