/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.analysiscolumn.impls;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgCompareAndAnalysisBgFormulaObjInfo;
import com.kingdee.eas.ma.budget.BgCompareAndAnalysisForBgFormulaFacadeFactory;
import com.kingdee.eas.ma.budget.IBgCompareAndAnalysisForBgFormulaFacade;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.analysiscolumn.DataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.RatePopoInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FetchStandardDataForBgFormulaFactory {
    private static Logger logger = Logger.getLogger((String)FetchStandardDataForBgFormulaFactory.class.getName());
    IBgCompareAndAnalysisForBgFormulaFacade remoteIntance;
    private static List BASEDATA_LIST = Collections.unmodifiableList(Arrays.asList("col0", "col1", "col2", "col3", "col4", "col5", "col6"));
    private Map BASEDATA_Map;
    private static List LAST_YEAR_DATA_LIST = Collections.unmodifiableList(Arrays.asList("col7", "col8", "col9", "col10"));
    private Map LAST_YEAR_DATA_Map;
    private static List THIS_YEAR_DATA_LIST = Collections.unmodifiableList(Arrays.asList("col13", "col14"));
    private Map THIS_YEAR_DATA_Map;
    private static List SUM_DATA_LIST = Collections.unmodifiableList(Arrays.asList("col11", "col12"));
    private Map SUM_DATA_Map;
    private static List BALANCE_DATA_LIST = Collections.unmodifiableList(Arrays.asList("col15"));
    private Map BALANCE_DATA_MAP;
    private static List THE_LAST_ACTUAL_DATA_LIST = Collections.unmodifiableList(Arrays.asList("col16"));
    private Map THE_LAST_ACTUAL_DATA_MAP;

    public void initDataFactory(String bgFormula, NewBgCompareAndAnalysisFilterParam filter1Params, NewBgCompareAndAnalysisFilterParam filter2Params) throws EASBizException, BOSException {
        logger.info((Object)"FetchStandardDataForBgFormulaFactory.initDataFactory invoke");
        List analysisColIndexList = filter2Params.getAnalysisElement();
        int num = analysisColIndexList.size();
        for (int i = 0; i < num; ++i) {
            String proName = analysisColIndexList.get(i).toString();
            if (BASEDATA_LIST.indexOf(proName) != -1) {
                this.getData(null, bgFormula, filter1Params);
            }
            if (LAST_YEAR_DATA_LIST.indexOf(proName) != -1) {
                this.getLastYearData(null, bgFormula, filter1Params);
                if (proName.equals("col9") || proName.equals("col10")) {
                    this.getData(null, bgFormula, filter1Params);
                }
            }
            if (THIS_YEAR_DATA_LIST.indexOf(proName) != -1) {
                this.getThisYearData(null, bgFormula, filter1Params);
            }
            if (SUM_DATA_LIST.indexOf(proName) != -1) {
                this.getSumData(null, bgFormula, filter1Params);
            }
            if (BALANCE_DATA_LIST.indexOf(proName) != -1) {
                this.getBalanceData(null, bgFormula, filter1Params);
            }
            if (THE_LAST_ACTUAL_DATA_LIST.indexOf(proName) == -1) continue;
            this.getTheLastActualData(null, bgFormula, filter1Params);
        }
    }

    private void getTheLastActualData(Context ctx, String bgFormula, NewBgCompareAndAnalysisFilterParam filter1Params) throws EASBizException {
        try {
            if (this.THE_LAST_ACTUAL_DATA_MAP == null) {
                this.THE_LAST_ACTUAL_DATA_MAP = this.getRemoteInstance(ctx).getThisYearData(bgFormula);
            } else if (!this.THE_LAST_ACTUAL_DATA_MAP.containsKey(bgFormula)) {
                Map map = this.getRemoteInstance(ctx).getThisYearData(bgFormula);
                this.THE_LAST_ACTUAL_DATA_MAP.putAll(map);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
    }

    public Object getDataFactory(String formula, String colKey, String orgUnitId, BigDecimal amountUnit) {
        Class<?> cls = this.getClass();
        Method method = null;
        try {
            method = cls.getMethod(colKey + "ValueMethod", String.class, String.class, BigDecimal.class);
        }
        catch (SecurityException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            return "";
        }
        Object obj = null;
        try {
            if (method != null) {
                obj = method.invoke((Object)this, formula, orgUnitId, amountUnit);
            }
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        if (obj instanceof String) {
            return obj;
        }
        if (obj instanceof RatePopoInfo) {
            return obj;
        }
        return DataDealCenter.decFormat.format(obj);
    }

    public void clearAllCache() {
        if (this.BASEDATA_Map != null) {
            this.BASEDATA_Map.clear();
        }
        if (this.LAST_YEAR_DATA_Map != null) {
            this.LAST_YEAR_DATA_Map.clear();
        }
        if (this.THIS_YEAR_DATA_Map != null) {
            this.THIS_YEAR_DATA_Map.clear();
        }
        if (this.SUM_DATA_Map != null) {
            this.SUM_DATA_Map.clear();
        }
        if (this.BALANCE_DATA_MAP != null) {
            this.BALANCE_DATA_MAP.clear();
        }
        if (this.THE_LAST_ACTUAL_DATA_MAP != null) {
            this.THE_LAST_ACTUAL_DATA_MAP.clear();
        }
    }

    private void getBalanceData(Context ctx, String bgFormula, NewBgCompareAndAnalysisFilterParam filter1Params) throws EASBizException {
        try {
            if (this.BALANCE_DATA_MAP == null) {
                this.BALANCE_DATA_MAP = this.getRemoteInstance(ctx).getBalanceData(bgFormula);
            } else if (!this.BALANCE_DATA_MAP.containsKey(bgFormula)) {
                Map map = this.getRemoteInstance(ctx).getBalanceData(bgFormula);
                this.BALANCE_DATA_MAP.putAll(map);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
    }

    private void getData(Context ctx, String bgFormula, NewBgCompareAndAnalysisFilterParam filter1Params) throws EASBizException {
        try {
            if (this.BASEDATA_Map == null) {
                this.BASEDATA_Map = this.getRemoteInstance(ctx).getData(bgFormula);
            } else if (!this.BASEDATA_Map.containsKey(bgFormula)) {
                Map map = this.getRemoteInstance(ctx).getData(bgFormula);
                this.BASEDATA_Map.putAll(map);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
    }

    private void getThisYearData(Context ctx, String bgFormula, NewBgCompareAndAnalysisFilterParam filter1Params) throws EASBizException, BOSException {
        if (this.THIS_YEAR_DATA_Map == null) {
            this.THIS_YEAR_DATA_Map = this.getRemoteInstance(ctx).getThisYearData(bgFormula);
        } else if (!this.THIS_YEAR_DATA_Map.containsKey(bgFormula)) {
            Map map = this.getRemoteInstance(ctx).getThisYearData(bgFormula);
            this.THIS_YEAR_DATA_Map.putAll(map);
        }
    }

    private void getSumData(Context ctx, String bgFormula, NewBgCompareAndAnalysisFilterParam filter1Params) throws EASBizException, BOSException {
        if (this.SUM_DATA_Map == null) {
            this.SUM_DATA_Map = this.getRemoteInstance(ctx).getSumData(bgFormula, filter1Params);
        } else if (!this.SUM_DATA_Map.containsKey(bgFormula)) {
            Map map = this.getRemoteInstance(ctx).getSumData(bgFormula, filter1Params);
            this.SUM_DATA_Map.putAll(map);
        }
    }

    private void getLastYearData(Context ctx, String bgFormula, NewBgCompareAndAnalysisFilterParam filter1Params) throws EASBizException, BOSException {
        if (this.LAST_YEAR_DATA_Map == null) {
            this.LAST_YEAR_DATA_Map = this.getRemoteInstance(ctx).getLastYearData(bgFormula);
        } else if (!this.LAST_YEAR_DATA_Map.containsKey(bgFormula)) {
            Map map = this.getRemoteInstance(ctx).getLastYearData(bgFormula);
            this.LAST_YEAR_DATA_Map.putAll(map);
        }
    }

    public BigDecimal col0ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.getBASEDATA_MAP() == null || this.getBASEDATA_MAP().size() == 0) {
            return new BigDecimal("0.00");
        }
        Object obj = this.getBASEDATA_MAP().get(formula);
        BigDecimal actualVal = DataDealCenter.ZERO;
        if (obj != null) {
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = (BgCompareAndAnalysisBgFormulaObjInfo)obj;
            actualVal = objInfo.getActualVal();
        }
        actualVal = actualVal.divide(amountUnit, 2, 4);
        return actualVal;
    }

    public RatePopoInfo col1ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        BigDecimal sumActualVal = this.col0ValueMethod(formula, orgUnitId, amountUnit);
        BigDecimal sumBudgetVal = this.col4ValueMethod(formula, orgUnitId, amountUnit);
        if (sumBudgetVal.compareTo(DataDealCenter.ZERO) == 0) {
            return RatePopoInfo.getZeroByFormat(2, true);
        }
        RatePopoInfo rateInfo = new RatePopoInfo(sumActualVal, sumBudgetVal);
        rateInfo.initReuslt();
        return rateInfo;
    }

    public BigDecimal col2ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        BigDecimal sumActualVal = this.col0ValueMethod(formula, orgUnitId, amountUnit);
        BigDecimal sumBudgetVal = this.col4ValueMethod(formula, orgUnitId, amountUnit);
        BigDecimal val = sumBudgetVal.subtract(sumActualVal);
        return val;
    }

    public RatePopoInfo col3ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        BigDecimal sumActualVal = this.col0ValueMethod(formula, orgUnitId, amountUnit);
        BigDecimal sumBudgetVal = this.col4ValueMethod(formula, orgUnitId, amountUnit);
        BigDecimal val = sumBudgetVal.subtract(sumActualVal);
        if (sumBudgetVal.compareTo(DataDealCenter.ZERO) == 0) {
            return RatePopoInfo.getZeroByFormat(2, true);
        }
        RatePopoInfo rateInfo = new RatePopoInfo(val, sumBudgetVal);
        rateInfo.initReuslt();
        return rateInfo;
    }

    public BigDecimal col4ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.getBASEDATA_MAP() == null || this.getBASEDATA_MAP().size() == 0) {
            return new BigDecimal("0.00");
        }
        Object obj = this.getBASEDATA_MAP().get(formula);
        BigDecimal budgetVal = DataDealCenter.ZERO;
        if (obj != null) {
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = (BgCompareAndAnalysisBgFormulaObjInfo)obj;
            budgetVal = objInfo.getBudgetVal();
        }
        budgetVal = budgetVal.divide(amountUnit, 2, 4);
        return budgetVal;
    }

    public BigDecimal col5ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        BigDecimal budgetVal = this.col4ValueMethod(formula, orgUnitId, amountUnit);
        BigDecimal pastVal = this.col6ValueMethod(formula, orgUnitId, amountUnit);
        return budgetVal.subtract(pastVal);
    }

    public BigDecimal col6ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.getBASEDATA_MAP() == null || this.getBASEDATA_MAP().size() == 0) {
            return new BigDecimal("0.00");
        }
        Object obj = this.getBASEDATA_MAP().get(formula);
        BigDecimal pastVal = DataDealCenter.ZERO;
        if (obj != null) {
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = (BgCompareAndAnalysisBgFormulaObjInfo)obj;
            pastVal = objInfo.getPastVal();
        }
        pastVal = pastVal.divide(amountUnit, 2, 4);
        return pastVal;
    }

    public BigDecimal col7ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.getLAST_YEAR_DATA_MAP() == null || this.getLAST_YEAR_DATA_MAP().size() == 0) {
            return new BigDecimal("0.00");
        }
        Object obj = this.getLAST_YEAR_DATA_MAP().get(formula);
        BigDecimal budgetVal = DataDealCenter.ZERO;
        if (obj != null) {
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = (BgCompareAndAnalysisBgFormulaObjInfo)obj;
            budgetVal = objInfo.getBudgetVal();
        }
        budgetVal = budgetVal.divide(amountUnit, 2, 4);
        return budgetVal;
    }

    public BigDecimal col8ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.getLAST_YEAR_DATA_MAP() == null || this.getLAST_YEAR_DATA_MAP().size() == 0) {
            return new BigDecimal("0.00");
        }
        Object obj = this.getLAST_YEAR_DATA_MAP().get(formula);
        BigDecimal actualVal = DataDealCenter.ZERO;
        if (obj != null) {
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = (BgCompareAndAnalysisBgFormulaObjInfo)obj;
            actualVal = objInfo.getActualVal();
        }
        actualVal = actualVal.divide(amountUnit, 2, 4);
        return actualVal;
    }

    public RatePopoInfo col9ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.getLAST_YEAR_DATA_MAP() == null || this.getBASEDATA_MAP() == null || this.getLAST_YEAR_DATA_MAP().size() == 0 || this.getBASEDATA_MAP().size() == 0) {
            return RatePopoInfo.getZeroByFormat(2, false);
        }
        Object lastObj = this.getLAST_YEAR_DATA_MAP().get(formula);
        BigDecimal lastYearBudgetVal = DataDealCenter.ZERO;
        if (lastObj != null) {
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = (BgCompareAndAnalysisBgFormulaObjInfo)lastObj;
            lastYearBudgetVal = objInfo.getBudgetVal();
        }
        Object baseObjInfo = this.getBASEDATA_MAP().get(formula);
        BigDecimal budgetVal = DataDealCenter.ZERO;
        if (baseObjInfo != null) {
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = (BgCompareAndAnalysisBgFormulaObjInfo)baseObjInfo;
            budgetVal = objInfo.getBudgetVal();
        }
        if (lastYearBudgetVal.compareTo(DataDealCenter.ZERO) == 0) {
            return RatePopoInfo.getZeroByFormat(2, true);
        }
        lastYearBudgetVal = lastYearBudgetVal.divide(amountUnit, 2, 4);
        budgetVal = budgetVal.divide(amountUnit, 2, 4);
        BigDecimal val = budgetVal.subtract(lastYearBudgetVal);
        RatePopoInfo rateInfo = new RatePopoInfo(val, lastYearBudgetVal);
        rateInfo.initReuslt();
        return rateInfo;
    }

    public RatePopoInfo col10ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.getLAST_YEAR_DATA_MAP() == null || this.getBASEDATA_MAP() == null || this.getLAST_YEAR_DATA_MAP().size() == 0 || this.getBASEDATA_MAP().size() == 0) {
            return RatePopoInfo.getZeroByFormat(2, false);
        }
        Object lastObj = this.getLAST_YEAR_DATA_MAP().get(formula);
        BigDecimal lastYearActualVal = DataDealCenter.ZERO;
        if (lastObj != null) {
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = (BgCompareAndAnalysisBgFormulaObjInfo)lastObj;
            lastYearActualVal = objInfo.getActualVal();
        }
        Object baseObjInfo = this.getBASEDATA_MAP().get(formula);
        BigDecimal actualVal = DataDealCenter.ZERO;
        if (baseObjInfo != null) {
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = (BgCompareAndAnalysisBgFormulaObjInfo)baseObjInfo;
            actualVal = objInfo.getActualVal();
        }
        if (lastYearActualVal.compareTo(DataDealCenter.ZERO) == 0) {
            return RatePopoInfo.getZeroByFormat(2, true);
        }
        lastYearActualVal = lastYearActualVal.divide(amountUnit, 2, 4);
        actualVal = actualVal.divide(amountUnit, 2, 4);
        BigDecimal val = actualVal.subtract(lastYearActualVal);
        RatePopoInfo rateInfo = new RatePopoInfo(val, lastYearActualVal);
        rateInfo.initReuslt();
        return rateInfo;
    }

    public BigDecimal col13ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.getTHIS_YEAR_DATA_MAP() == null || this.getTHIS_YEAR_DATA_MAP().size() == 0) {
            return new BigDecimal("0.00");
        }
        Object obj = this.getTHIS_YEAR_DATA_MAP().get(formula);
        BigDecimal budgetVal = DataDealCenter.ZERO;
        if (obj != null) {
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = (BgCompareAndAnalysisBgFormulaObjInfo)obj;
            budgetVal = objInfo.getBudgetVal();
        }
        budgetVal = budgetVal.divide(amountUnit, 2, 4);
        return budgetVal;
    }

    public BigDecimal col14ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.getTHIS_YEAR_DATA_MAP() == null || this.getTHIS_YEAR_DATA_MAP().size() == 0) {
            return new BigDecimal("0.00");
        }
        Object obj = this.getTHIS_YEAR_DATA_MAP().get(formula);
        BigDecimal actualVal = DataDealCenter.ZERO;
        if (obj != null) {
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = (BgCompareAndAnalysisBgFormulaObjInfo)obj;
            actualVal = objInfo.getActualVal();
        }
        actualVal = actualVal.divide(amountUnit, 2, 4);
        return actualVal;
    }

    public BigDecimal col11ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.getSUM_DATA_MAP() == null || this.getSUM_DATA_MAP().size() == 0) {
            return new BigDecimal("0.00");
        }
        Object obj = this.getSUM_DATA_MAP().get(formula);
        BigDecimal budgetVal = DataDealCenter.ZERO;
        if (obj != null) {
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = (BgCompareAndAnalysisBgFormulaObjInfo)obj;
            budgetVal = objInfo.getBudgetVal();
        }
        budgetVal = budgetVal.divide(amountUnit, 2, 4);
        return budgetVal;
    }

    public BigDecimal col12ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.getSUM_DATA_MAP() == null || this.getSUM_DATA_MAP().size() == 0) {
            return new BigDecimal("0.00");
        }
        Object obj = this.getSUM_DATA_MAP().get(formula);
        BigDecimal actualVal = DataDealCenter.ZERO;
        if (obj != null) {
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = (BgCompareAndAnalysisBgFormulaObjInfo)obj;
            actualVal = objInfo.getActualVal();
        }
        actualVal = actualVal.divide(amountUnit, 2, 4);
        return actualVal;
    }

    public BigDecimal col17ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        BgCompareAndAnalysisBgFormulaObjInfo info;
        if (this.getLAST_YEAR_DATA_MAP() == null || this.getBASEDATA_MAP() == null || this.getLAST_YEAR_DATA_MAP().size() == 0 || this.getBASEDATA_MAP().size() == 0) {
            return DataDealCenter.ZERO;
        }
        BigDecimal actualVal = null;
        BigDecimal lastYearActualVal = null;
        if (this.getLAST_YEAR_DATA_MAP().containsKey(formula)) {
            info = (BgCompareAndAnalysisBgFormulaObjInfo)this.getLAST_YEAR_DATA_MAP().get(formula);
            lastYearActualVal = info == null ? DataDealCenter.ZERO : info.getActualVal();
        }
        if (lastYearActualVal == null) {
            return DataDealCenter.ZERO;
        }
        if (this.getBASEDATA_MAP().containsKey(formula)) {
            info = (BgCompareAndAnalysisBgFormulaObjInfo)this.getBASEDATA_MAP().get(formula);
            if (info == null) {
                return DataDealCenter.ZERO;
            }
            actualVal = info.getActualVal();
        }
        if (actualVal == null) {
            return DataDealCenter.ZERO;
        }
        lastYearActualVal = lastYearActualVal.divide(amountUnit, 2, 4);
        actualVal = actualVal.divide(amountUnit, 2, 4);
        BigDecimal val = actualVal.subtract(lastYearActualVal);
        return val;
    }

    public BigDecimal col18ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        BgCompareAndAnalysisBgFormulaObjInfo info;
        if (this.getLAST_YEAR_DATA_MAP() == null || this.getBASEDATA_MAP() == null || this.getLAST_YEAR_DATA_MAP().size() == 0 || this.getBASEDATA_MAP().size() == 0) {
            return DataDealCenter.ZERO;
        }
        BigDecimal actualVal = null;
        BigDecimal lastYearActualVal = null;
        if (this.getLAST_YEAR_DATA_MAP().containsKey(formula)) {
            info = (BgCompareAndAnalysisBgFormulaObjInfo)this.getLAST_YEAR_DATA_MAP().get(formula);
            lastYearActualVal = info == null ? DataDealCenter.ZERO : info.getBudgetVal();
        }
        if (lastYearActualVal == null) {
            return DataDealCenter.ZERO;
        }
        if (this.getBASEDATA_MAP().containsKey(formula)) {
            info = (BgCompareAndAnalysisBgFormulaObjInfo)this.getBASEDATA_MAP().get(formula);
            if (info == null) {
                return DataDealCenter.ZERO;
            }
            actualVal = info.getBudgetVal();
        }
        if (actualVal == null) {
            return DataDealCenter.ZERO;
        }
        lastYearActualVal = lastYearActualVal.divide(amountUnit, 2, 4);
        actualVal = actualVal.divide(amountUnit, 2, 4);
        BigDecimal val = actualVal.subtract(lastYearActualVal);
        return val;
    }

    public RatePopoInfo col19ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.getBASEDATA_MAP() == null || this.getBASEDATA_MAP().size() == 0) {
            return RatePopoInfo.getZeroByFormat(2, false);
        }
        BigDecimal pastVal = this.col6ValueMethod(formula, orgUnitId, amountUnit);
        if (pastVal == null || pastVal.compareTo(DataDealCenter.ZERO) == 0) {
            return RatePopoInfo.getZeroByFormat(2, false);
        }
        BigDecimal budgetVal = this.col4ValueMethod(formula, orgUnitId, amountUnit);
        if (budgetVal == null || budgetVal.compareTo(DataDealCenter.ZERO) == 0) {
            return RatePopoInfo.getZeroByFormat(2, true);
        }
        RatePopoInfo rateInfo = new RatePopoInfo(pastVal, budgetVal);
        rateInfo.initReuslt();
        return rateInfo;
    }

    public BigDecimal col15ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.getBALANCE_DATA_MAP() == null || this.getBALANCE_DATA_MAP().size() == 0) {
            return new BigDecimal("0.00");
        }
        Object obj = this.getBALANCE_DATA_MAP().get(formula);
        BigDecimal balanceVal = DataDealCenter.ZERO;
        if (obj != null) {
            BgCompareAndAnalysisBgFormulaObjInfo objInfo = (BgCompareAndAnalysisBgFormulaObjInfo)obj;
            balanceVal = objInfo.getBalanceVal();
        }
        if (balanceVal == null) {
            return DataDealCenter.ZERO;
        }
        balanceVal = balanceVal.divide(amountUnit, 2, 4);
        return balanceVal;
    }

    public BigDecimal col16ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.getTHE_LAST_ACTUAL_DATA_MAP() == null || this.getTHE_LAST_ACTUAL_DATA_MAP().size() == 0) {
            return new BigDecimal("0.00");
        }
        if (this.getTHE_LAST_ACTUAL_DATA_MAP().containsKey(formula)) {
            BgCompareAndAnalysisBgFormulaObjInfo info = (BgCompareAndAnalysisBgFormulaObjInfo)this.getTHE_LAST_ACTUAL_DATA_MAP().get(formula);
            if (info == null) {
                return new BigDecimal("0.00");
            }
            return info.getActualVal();
        }
        return DataDealCenter.ZERO;
    }

    public Map getBASEDATA_MAP() {
        return this.BASEDATA_Map;
    }

    public Map getLAST_YEAR_DATA_MAP() {
        return this.LAST_YEAR_DATA_Map;
    }

    public Map getSUM_DATA_MAP() {
        return this.SUM_DATA_Map;
    }

    public Map getTHIS_YEAR_DATA_MAP() {
        return this.THIS_YEAR_DATA_Map;
    }

    public Map getBALANCE_DATA_MAP() {
        return this.BALANCE_DATA_MAP;
    }

    public void setBALANCE_DATA_MAP(Map balance_data_map) {
        this.BALANCE_DATA_MAP = balance_data_map;
    }

    public Map getTHE_LAST_ACTUAL_DATA_MAP() {
        return this.THE_LAST_ACTUAL_DATA_MAP;
    }

    public void setTHE_LAST_ACTUAL_DATA_MAP(Map the_last_actual_data_map) {
        this.THE_LAST_ACTUAL_DATA_MAP = the_last_actual_data_map;
    }

    public void initDataFactory(Context ctx, String bgFormula, NewBgCompareAndAnalysisFilterParam filter1Params, NewBgCompareAndAnalysisFilterParam filter2Params) throws EASBizException, BOSException {
        logger.info((Object)"FetchStandardDataForBgFormulaFactory.initDataFactory invoke");
        List analysisColIndexList = filter2Params.getAnalysisElement();
        int num = analysisColIndexList.size();
        for (int i = 0; i < num; ++i) {
            String proName = analysisColIndexList.get(i).toString();
            if (BASEDATA_LIST.indexOf(proName) != -1) {
                this.getData(ctx, bgFormula, filter1Params);
            }
            if (LAST_YEAR_DATA_LIST.indexOf(proName) != -1) {
                this.getLastYearData(ctx, bgFormula, filter1Params);
                if (proName.equals("col9") || proName.equals("col10")) {
                    this.getData(ctx, bgFormula, filter1Params);
                }
            }
            if (THIS_YEAR_DATA_LIST.indexOf(proName) != -1) {
                this.getThisYearData(ctx, bgFormula, filter1Params);
            }
            if (SUM_DATA_LIST.indexOf(proName) != -1) {
                this.getSumData(ctx, bgFormula, filter1Params);
            }
            if (BALANCE_DATA_LIST.indexOf(proName) != -1) {
                this.getBalanceData(ctx, bgFormula, filter1Params);
            }
            if (THE_LAST_ACTUAL_DATA_LIST.indexOf(proName) == -1) continue;
            this.getTheLastActualData(ctx, bgFormula, filter1Params);
        }
    }

    private IBgCompareAndAnalysisForBgFormulaFacade getRemoteInstance(Context ctx) throws BOSException {
        if (ctx != null) {
            this.remoteIntance = BgCompareAndAnalysisForBgFormulaFacadeFactory.getLocalInstance(ctx);
            return this.remoteIntance;
        }
        this.remoteIntance = BgCompareAndAnalysisForBgFormulaFacadeFactory.getRemoteInstance();
        return this.remoteIntance;
    }

    public void initDataFactory(Context ctx, List formulaS, NewBgCompareAndAnalysisFilterParam filter1Params, NewBgCompareAndAnalysisFilterParam filter2Params) throws EASBizException, BOSException {
        logger.info((Object)"FetchStandardDataForBgFormulaFactory.initDataFactory invoke");
        List analysisColIndexList = filter2Params.getAnalysisElement();
        int num = analysisColIndexList.size();
        for (int i = 0; i < num; ++i) {
            String proName = analysisColIndexList.get(i).toString();
            if (BASEDATA_LIST.indexOf(proName) != -1) {
                this.getData(ctx, formulaS, filter1Params);
            }
            if (LAST_YEAR_DATA_LIST.indexOf(proName) != -1) {
                this.getLastYearData(ctx, formulaS, filter1Params);
                if (proName.equals("col9") || proName.equals("col10")) {
                    this.getData(ctx, formulaS, filter1Params);
                }
            }
            if (THIS_YEAR_DATA_LIST.indexOf(proName) != -1) {
                this.getThisYearData(ctx, formulaS, filter1Params);
            }
            if (SUM_DATA_LIST.indexOf(proName) != -1) {
                this.getSumData(ctx, formulaS, filter1Params);
            }
            if (BALANCE_DATA_LIST.indexOf(proName) != -1) {
                this.getBalanceData(ctx, formulaS, filter1Params);
            }
            if (THE_LAST_ACTUAL_DATA_LIST.indexOf(proName) == -1) continue;
            this.getTheLastActualData(ctx, formulaS, filter1Params);
        }
    }

    private void getBalanceData(Context ctx, List formulaS, NewBgCompareAndAnalysisFilterParam filter1Params) throws EASBizException {
        try {
            if (this.BALANCE_DATA_MAP == null) {
                this.BALANCE_DATA_MAP = this.getRemoteInstance(ctx).getBalanceData(formulaS);
            } else {
                Map map = this.getRemoteInstance(ctx).getBalanceData(formulaS);
                this.BALANCE_DATA_MAP.putAll(map);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
    }

    private void getData(Context ctx, List formulaS, NewBgCompareAndAnalysisFilterParam filter1Params) throws EASBizException {
        try {
            if (this.BASEDATA_Map == null) {
                this.BASEDATA_Map = this.getRemoteInstance(ctx).getData(formulaS);
            } else {
                Map map = this.getRemoteInstance(ctx).getData(formulaS);
                this.BASEDATA_Map.putAll(map);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
    }

    private void getThisYearData(Context ctx, List formulaS, NewBgCompareAndAnalysisFilterParam filter1Params) throws EASBizException, BOSException {
        if (this.THIS_YEAR_DATA_Map == null) {
            this.THIS_YEAR_DATA_Map = this.getRemoteInstance(ctx).getThisYearData(formulaS);
        } else {
            Map map = this.getRemoteInstance(ctx).getThisYearData(formulaS);
            this.THIS_YEAR_DATA_Map.putAll(map);
        }
    }

    private void getSumData(Context ctx, List formulaS, NewBgCompareAndAnalysisFilterParam filter1Params) throws EASBizException, BOSException {
        if (this.SUM_DATA_Map == null) {
            this.SUM_DATA_Map = this.getRemoteInstance(ctx).getSumData(formulaS, filter1Params);
        } else {
            Map map = this.getRemoteInstance(ctx).getSumData(formulaS, filter1Params);
            this.SUM_DATA_Map.putAll(map);
        }
    }

    private void getLastYearData(Context ctx, List formulaS, NewBgCompareAndAnalysisFilterParam filter1Params) throws EASBizException, BOSException {
        if (this.LAST_YEAR_DATA_Map == null) {
            this.LAST_YEAR_DATA_Map = this.getRemoteInstance(ctx).getLastYearData(formulaS);
        } else {
            Map map = this.getRemoteInstance(ctx).getLastYearData(formulaS);
            this.LAST_YEAR_DATA_Map.putAll(map);
        }
    }

    private void getTheLastActualData(Context ctx, List formulaS, NewBgCompareAndAnalysisFilterParam filter1Params) throws EASBizException {
        try {
            if (this.THE_LAST_ACTUAL_DATA_MAP == null) {
                this.THE_LAST_ACTUAL_DATA_MAP = this.getRemoteInstance(ctx).getThisYearData(formulaS);
            } else {
                Map map = this.getRemoteInstance(ctx).getThisYearData(formulaS);
                this.THE_LAST_ACTUAL_DATA_MAP.putAll(map);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
    }
}

