/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.analysiscolumn.impls;

import com.kingdee.eas.ma.budget.BgTendencyAnalysisObjInfo;
import com.kingdee.eas.ma.budget.analysiscolumn.DataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.FetchDataFactory;
import com.kingdee.eas.ma.budget.analysiscolumn.RatePopoInfo;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.FetchTendencyDataFactory;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.log4j.Logger;

public class TendencyDataDealCenter
extends DataDealCenter {
    private static Logger logger = Logger.getLogger((String)TendencyDataDealCenter.class.getName());
    private FetchTendencyDataFactory instance = new FetchTendencyDataFactory();
    private boolean isBudgetVal;
    private boolean isBaseAnalysisWay;

    public TendencyDataDealCenter(boolean isBudgetVal, boolean isBaseAnalysisWay) throws ClassNotFoundException {
        logger.info((Object)"TendencyDataDealCenter instance is create ");
        this.isBudgetVal = isBudgetVal;
        this.isBaseAnalysisWay = isBaseAnalysisWay;
    }

    @Override
    public FetchDataFactory getFetchDataFactory() {
        logger.info((Object)"TendencyDataDealCenter instance is create ");
        return this.instance;
    }

    public BigDecimal col6ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.instance.getBASEDATA_MAP() == null || this.instance.getBASEDATA_MAP().size() == 0) {
            return ZERO;
        }
        BigDecimal curtVal = ZERO;
        if (this.instance.getBASEDATA_MAP().containsKey(formula)) {
            BgTendencyAnalysisObjInfo info = (BgTendencyAnalysisObjInfo)this.instance.getBASEDATA_MAP().get(formula);
            Map map = info.getOrgUnitIdMap();
            BgTendencyAnalysisObjInfo.DataObj dataObj = (BgTendencyAnalysisObjInfo.DataObj)map.get(orgUnitId);
            if (dataObj == null) {
                return ZERO;
            }
            curtVal = this.isBudgetVal() ? dataObj.getBudgetVal() : dataObj.getActualVal();
            String baseFormula = info.getComparedBgItem();
            BigDecimal baseVal = this.getBaseBgItemVal(baseFormula, orgUnitId, this.instance.getBASEDATA_MAP(), amountUnit);
            curtVal = curtVal.subtract(baseVal);
        }
        if (curtVal == null || ZERO.compareTo(curtVal) == 0) {
            return ZERO;
        }
        curtVal = curtVal.divide(amountUnit, 2, 4);
        return curtVal;
    }

    public RatePopoInfo col7ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.instance.getBASEDATA_MAP() == null || this.instance.getBASEDATA_MAP().size() == 0) {
            return RatePopoInfo.getZeroByFormat(2, false);
        }
        BigDecimal curtVal = ZERO;
        BigDecimal baseVal = ZERO;
        if (this.instance.getBASEDATA_MAP().containsKey(formula)) {
            BgTendencyAnalysisObjInfo info = (BgTendencyAnalysisObjInfo)this.instance.getBASEDATA_MAP().get(formula);
            Map map = info.getOrgUnitIdMap();
            BgTendencyAnalysisObjInfo.DataObj dataObj = (BgTendencyAnalysisObjInfo.DataObj)map.get(orgUnitId);
            if (dataObj == null) {
                return RatePopoInfo.getZeroByFormat(2, false);
            }
            curtVal = this.isBudgetVal() ? dataObj.getBudgetVal() : dataObj.getActualVal();
            String baseFormula = info.getComparedBgItem();
            baseVal = this.getBaseBgItemVal(baseFormula, orgUnitId, this.instance.getBASEDATA_MAP(), amountUnit);
        }
        if (baseVal == null || ZERO.compareTo(baseVal) == 0) {
            return RatePopoInfo.getZeroByFormat(2, true);
        }
        BigDecimal difVal = curtVal.subtract(baseVal);
        if (difVal == null || ZERO.compareTo(difVal) == 0) {
            return RatePopoInfo.getZeroByFormat(2, false);
        }
        BigDecimal result = difVal.divide(amountUnit, 4, 4);
        RatePopoInfo rateInfo = new RatePopoInfo(result, baseVal);
        rateInfo.setScale(2);
        rateInfo.initReuslt();
        return rateInfo;
    }

    public BigDecimal col8ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.instance.getCIRCLEDATA_MAP() == null || this.instance.getCIRCLEDATA_MAP().size() == 0) {
            return ZERO;
        }
        BigDecimal curtVal = ZERO;
        if (this.instance.getCIRCLEDATA_MAP().containsKey(formula)) {
            BgTendencyAnalysisObjInfo info = (BgTendencyAnalysisObjInfo)this.instance.getCIRCLEDATA_MAP().get(formula);
            Map map = info.getOrgUnitIdMap();
            BgTendencyAnalysisObjInfo.DataObj dataObj = (BgTendencyAnalysisObjInfo.DataObj)map.get(orgUnitId);
            if (dataObj == null) {
                return ZERO;
            }
            curtVal = this.isBudgetVal() ? dataObj.getBudgetVal() : dataObj.getActualVal();
            String theLastFormula = info.getComparedBgItem();
            BigDecimal baseVal = this.getBaseBgItemVal(theLastFormula, orgUnitId, this.instance.getCIRCLEDATA_MAP(), amountUnit);
            curtVal = curtVal.subtract(baseVal);
        }
        if (curtVal == null || ZERO.compareTo(curtVal) == 0) {
            return ZERO;
        }
        curtVal = curtVal.divide(amountUnit, 2, 4);
        return curtVal;
    }

    public RatePopoInfo col9ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        if (this.instance.getCIRCLEDATA_MAP() == null || this.instance.getCIRCLEDATA_MAP().size() == 0) {
            return RatePopoInfo.getZeroByFormat(2, false);
        }
        BigDecimal curtVal = ZERO;
        BigDecimal baseVal = ZERO;
        if (this.instance.getCIRCLEDATA_MAP().containsKey(formula)) {
            BgTendencyAnalysisObjInfo info = (BgTendencyAnalysisObjInfo)this.instance.getCIRCLEDATA_MAP().get(formula);
            Map map = info.getOrgUnitIdMap();
            BgTendencyAnalysisObjInfo.DataObj dataObj = (BgTendencyAnalysisObjInfo.DataObj)map.get(orgUnitId);
            if (dataObj == null) {
                return RatePopoInfo.getZeroByFormat(2, false);
            }
            curtVal = this.isBudgetVal() ? dataObj.getBudgetVal() : dataObj.getActualVal();
            String baseFormula = info.getComparedBgItem();
            baseVal = this.getBaseBgItemVal(baseFormula, orgUnitId, this.instance.getCIRCLEDATA_MAP(), amountUnit);
        }
        if (baseVal == null || ZERO.compareTo(baseVal) == 0) {
            return RatePopoInfo.getZeroByFormat(2, true);
        }
        BigDecimal difVal = curtVal.subtract(baseVal);
        if (difVal == null || ZERO.compareTo(difVal) == 0) {
            return RatePopoInfo.getZeroByFormat(2, false);
        }
        RatePopoInfo rateInfo = new RatePopoInfo(difVal, baseVal);
        rateInfo.setScale(2);
        rateInfo.initReuslt();
        return rateInfo;
    }

    public BigDecimal col10ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        Map dataMap = null;
        dataMap = this.isBaseAnalysisWay() ? this.instance.getBASEDATA_MAP() : this.instance.getCIRCLEDATA_MAP();
        if (dataMap == null || dataMap.size() == 0) {
            return ZERO;
        }
        BigDecimal curtVal = ZERO;
        if (dataMap.containsKey(formula)) {
            BgTendencyAnalysisObjInfo info = (BgTendencyAnalysisObjInfo)dataMap.get(formula);
            Map map = info.getOrgUnitIdMap();
            BgTendencyAnalysisObjInfo.DataObj dataObj = (BgTendencyAnalysisObjInfo.DataObj)map.get(orgUnitId);
            if (dataObj == null) {
                return ZERO;
            }
            curtVal = dataObj.getBudgetVal();
        }
        if (curtVal == null || ZERO.compareTo(curtVal) == 0) {
            return ZERO;
        }
        curtVal = curtVal.divide(amountUnit, 2, 4);
        return curtVal;
    }

    public BigDecimal col11ValueMethod(String formula, String orgUnitId, BigDecimal amountUnit) {
        Map dataMap = null;
        dataMap = this.isBaseAnalysisWay() ? this.instance.getBASEDATA_MAP() : this.instance.getCIRCLEDATA_MAP();
        if (dataMap == null || dataMap.size() == 0) {
            return ZERO;
        }
        BigDecimal curtVal = ZERO;
        if (dataMap.containsKey(formula)) {
            BgTendencyAnalysisObjInfo info = (BgTendencyAnalysisObjInfo)dataMap.get(formula);
            Map map = info.getOrgUnitIdMap();
            BgTendencyAnalysisObjInfo.DataObj dataObj = (BgTendencyAnalysisObjInfo.DataObj)map.get(orgUnitId);
            if (dataObj == null) {
                return ZERO;
            }
            curtVal = dataObj.getActualVal();
        }
        if (curtVal == null || ZERO.compareTo(curtVal) == 0) {
            return ZERO;
        }
        curtVal = curtVal.divide(amountUnit, 2, 4);
        return curtVal;
    }

    private BigDecimal getBaseBgItemVal(String formula, String orgUnitId, Map dataMap, BigDecimal amountUnit) {
        BigDecimal val = ZERO;
        if (dataMap.containsKey(formula)) {
            BgTendencyAnalysisObjInfo info = (BgTendencyAnalysisObjInfo)dataMap.get(formula);
            Map map = info.getOrgUnitIdMap();
            BgTendencyAnalysisObjInfo.DataObj dataObj = (BgTendencyAnalysisObjInfo.DataObj)map.get(orgUnitId);
            if (dataObj == null) {
                return ZERO;
            }
            val = this.isBudgetVal() ? dataObj.getBudgetVal() : dataObj.getActualVal();
        }
        if (val == null) {
            return ZERO;
        }
        val = val.divide(amountUnit, 2, 4);
        return val;
    }

    private boolean isBudgetVal() {
        return this.isBudgetVal;
    }

    private boolean isBaseAnalysisWay() {
        return this.isBaseAnalysisWay;
    }
}

