/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.analysiscolumn.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.budget.BgFillHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class AnalysisColumnTool {
    public static String getProValByProName(String proName, Class analysisElementClass) throws IllegalArgumentException, IllegalAccessException {
        Field[] fs = analysisElementClass.getFields();
        List<Field> proNameList = Arrays.asList(fs);
        int index = -1;
        int num = proNameList.size();
        for (int i = 0; i < num; ++i) {
            Field field = proNameList.get(i);
            if (!field.getName().equals(proName)) continue;
            index = i;
            break;
        }
        String proVal = "";
        if (index != -1) {
            Field field = proNameList.get(index);
            proVal = field.get(proName).toString();
            proVal = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgFormAnalyseLableResource", (String)proVal, (Locale)ContextUtils.getLocaleFromEnv());
        }
        return proVal;
    }

    public static String[] parseBgFormula(String[] bgFormulaAry, BgPeriodCollection cols) {
        String sPeriodNum = bgFormulaAry[5];
        String ePeriodNum = bgFormulaAry[6];
        if (!sPeriodNum.equals(ePeriodNum)) {
            int num = cols.size();
            String[] rtnAry = new String[num];
            for (int i = 0; i < num; ++i) {
                rtnAry[i] = AnalysisColumnTool.buildBgItem(bgFormulaAry, cols.get(i).getNumber());
            }
            return rtnAry;
        }
        return new String[]{AnalysisColumnTool.buildBgItem(bgFormulaAry, sPeriodNum)};
    }

    public static String buildBgItem(String[] formulaParamArray, String periodNum) {
        return "=BgItem(\"" + formulaParamArray[3] + "\",\"" + periodNum + "\",\"" + formulaParamArray[2] + "\",\"BgData\",true,\"" + formulaParamArray[4] + "\")";
    }

    public static String rebuildFormulaWithPeriodParamNull(String[] formulaParamArray) {
        return "=BgItem(\"" + formulaParamArray[0] + "\",\"\",\"" + formulaParamArray[2] + "\",\"" + formulaParamArray[3] + "\",true,\"" + formulaParamArray[5] + "\")";
    }

    public static String rebuildFormulaWithPeriodParam(String[] formulaParamArray, String periodNum) {
        return "=BgItem(\"" + formulaParamArray[0] + "\",\"" + periodNum + "\",\"" + formulaParamArray[2] + "\",\"" + formulaParamArray[3] + "\",true,\"" + formulaParamArray[5] + "\")";
    }

    public static String changeBgFormulaToBgItem(String bgFormula) {
        String ePeriodNum;
        if (bgFormula == null) {
            return "";
        }
        String validateBgFormula = bgFormula.toLowerCase(Locale.ENGLISH);
        if (!validateBgFormula.startsWith("=bgformula")) {
            return "";
        }
        String[] formulas = bgFormula.split("\\+");
        if (formulas.length > 1) {
            return "";
        }
        String[] bgFormulaAry = BgFillHelper.parseStrFormulaToArray(bgFormula);
        String sPeriodNum = bgFormulaAry[5];
        if (!sPeriodNum.equals(ePeriodNum = bgFormulaAry[6])) {
            return "";
        }
        return "=BgItem(\"" + bgFormulaAry[3] + "\",\"" + bgFormulaAry[5] + "\",\"" + bgFormulaAry[2] + "\",\"BgData\",true,\"" + bgFormulaAry[4] + "\")";
    }

    public static boolean isDelete(Context ctx) {
        String paramValue = null;
        try {
            paramValue = ctx == null ? ParamManager.getParamValue(null, null, (String)"BG023") : ParamManager.getParamValue((Context)ctx, null, (String)"BG023");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return StringUtils.isEmpty(paramValue) ? false : Boolean.valueOf(paramValue);
    }

    public static Map dealWithOrgUnit(OrgUnitInfo[] array) {
        int level;
        int i;
        int size = array.length;
        String[] aryLN = new String[size];
        HashMap<String, SubNode> map = new HashMap<String, SubNode>();
        final HashMap<String, Integer> helperMap = new HashMap<String, Integer>();
        for (i = 0; i < size; ++i) {
            String tempLN = array[i].getLongNumber();
            level = array[i].getLevel();
            aryLN[i] = tempLN;
            helperMap.put(tempLN, new Integer(level));
        }
        Arrays.sort(aryLN, new Comparator(){

            public int compare(Object o1, Object o2) {
                int objInt1 = Integer.valueOf(helperMap.get(o1).toString());
                int objInt2 = Integer.valueOf(helperMap.get(o2).toString());
                return objInt1 - objInt2;
            }
        });
        block1: for (i = 0; i < size; ++i) {
            String lnVal = aryLN[i];
            level = Integer.valueOf(helperMap.get(lnVal).toString());
            for (int j = i; j < size; ++j) {
                Object obj;
                String comparedVal = aryLN[j];
                int comparedlevel = Integer.valueOf(helperMap.get(comparedVal).toString());
                if (comparedlevel - 1 == level && comparedVal.startsWith(lnVal.concat("!"))) {
                    SubNode node;
                    obj = map.get(lnVal);
                    if (obj != null) {
                        node = (SubNode)obj;
                        node.addSubNode(comparedVal);
                        continue;
                    }
                    node = new SubNode();
                    node.addSubNode(comparedVal);
                    map.put(lnVal, node);
                    continue;
                }
                if (j == size - 1) {
                    obj = map.get(lnVal);
                    if (obj != null) continue;
                    map.put(lnVal, (SubNode)obj);
                    continue;
                }
                if (comparedlevel - 2 == level) continue block1;
            }
        }
        return map;
    }

    public static class SubNode {
        List subNodeList;

        public void addSubNode(String subNode) {
            if (this.subNodeList == null) {
                this.subNodeList = new ArrayList();
            }
            this.subNodeList.add(subNode);
        }

        public List getSubNodeList() {
            return this.subNodeList;
        }
    }
}

