/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgActualException;
import com.kingdee.eas.ma.budget.BgActualRecordFacadeFactory;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgCtrlRecordInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTraceTypeEnum;
import com.kingdee.eas.ma.budget.IBgActualRecord;
import com.kingdee.eas.ma.budget.IBgActualRecordFacade;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.app.AbstractBgActualFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgActualFacadeControllerBean
extends AbstractBgActualFacadeControllerBean {
    private static final long serialVersionUID = 7622661975780157154L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgActualFacadeControllerBean");

    @Override
    protected void _processDataWithSchemes(Context ctx, Map parameter) throws BOSException, EASBizException {
        if (parameter == null || parameter.isEmpty()) {
            throw new BgActualException(BgActualException.PARAMETERISNULL);
        }
        BigDecimal rateValue = null;
        String bgSSchemeId = null;
        String bgTSchemeId = null;
        String bgSSchemeRootId = null;
        String bgTSchemeRootId = null;
        String tarOrgId2 = null;
        HashMap dataMap = new HashMap();
        BgSchemeInfo bgSSchemeInfo = null;
        BgSchemeInfo bgTSchemeInfo = null;
        Connection conn = null;
        OrgUnitInfo[] orgUnits = (OrgUnitInfo[])parameter.get("BgOrgUnit");
        bgSSchemeRootId = (String)parameter.get("Source_BgScheme");
        bgTSchemeRootId = (String)parameter.get("Target_BgScheme");
        rateValue = (BigDecimal)parameter.get("RateValue");
        rateValue = rateValue.divide(BgConstants.HUNDRED, 8, 4);
        Map srcSchemeIdMap = this.getSchemeIdFromRootId(ctx, orgUnits, bgSSchemeRootId);
        Map tarSchemeIdMap = this.getSchemeIdFromRootId(ctx, orgUnits, bgTSchemeRootId);
        try {
            conn = this.getConnection(ctx);
            for (String tarOrgId2 : tarSchemeIdMap.keySet()) {
                bgTSchemeId = (String)tarSchemeIdMap.get(tarOrgId2);
                if (!srcSchemeIdMap.containsKey(tarOrgId2) || StringUtils.isEmpty((String)(bgSSchemeId = (String)srcSchemeIdMap.get(tarOrgId2))) || StringUtils.isEmpty((String)bgTSchemeId)) continue;
                bgSSchemeInfo = BgFSHelper.getBgSchemeInfo(ctx, conn, BOSUuid.read((String)bgSSchemeId));
                bgTSchemeInfo = BgFSHelper.getBgSchemeInfo(ctx, conn, BOSUuid.read((String)bgTSchemeId));
                this.builderInitActualCtrlRecord(ctx, conn, bgSSchemeInfo, bgTSchemeInfo, rateValue, dataMap);
                this.builderAddActualCtrlRecord(ctx, conn, bgSSchemeInfo, bgTSchemeInfo, rateValue, dataMap);
                this.builderBillActualCtrlRecord(ctx, conn, bgSSchemeInfo, bgTSchemeInfo, rateValue, dataMap);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void builderInitActualCtrlRecord(Context ctx, Connection conn, BgSchemeInfo bgSSchemeInfo, BgSchemeInfo bgTSchemeInfo, BigDecimal rateValue, Map dataMap) throws BOSException, EASBizException {
        String bgFormId;
        HashMap<String, BigDecimal> formulaMap;
        ArrayList<String> bgFormIdList;
        Book _book;
        IBgFormFacade ibgFormFacade;
        IBgForm ibgForm;
        BgFormInfo bgFormInfo;
        ResultSet rst;
        PreparedStatement pstmt;
        block17: {
            StringBuffer sqlData;
            StringBuffer sqlUpdate;
            String fid;
            String formulaString;
            BigDecimal value;
            block16: {
                if (conn == null) return;
                if (bgSSchemeInfo == null) return;
                if (bgTSchemeInfo == null) return;
                if (dataMap == null) {
                    return;
                }
                pstmt = null;
                rst = null;
                bgFormInfo = null;
                ibgForm = null;
                ibgFormFacade = null;
                _book = null;
                bgFormIdList = new ArrayList<String>();
                formulaMap = new HashMap<String, BigDecimal>();
                value = null;
                formulaString = null;
                bgFormId = null;
                fid = null;
                StringBuffer sqlForm = new StringBuffer();
                sqlUpdate = new StringBuffer();
                sqlData = new StringBuffer();
                sqlForm.append("select FID from T_BG_BgForm where FBgSchemeId = ? and FState NOT IN (4,15,5)");
                sqlUpdate.append("select d.FID, d.FFormula ").append("from T_BG_BgCtrlRecord t ").append("join T_BG_BgData d on t.FBgDataId = d.FID ").append("where d.FOrgUnitId = ? and d.FBgSchemeId = ? ").append("group by d.fid, d.fformula");
                sqlData.append("select d.FID, d.FFormula, t.FActualAmount from T_BG_BgCtrlRecord t join T_BG_BgData d on t.FBgDataId = d.FID where t.FBgTraceType = 1 and t.FBillId in (select FID from T_BG_BgForm where FBgSchemeId = ?) and d.FOrgUnitId = ? and d.FBgSchemeId = ?");
                pstmt = conn.prepareStatement(sqlForm.toString());
                pstmt.setString(1, bgTSchemeInfo.getId().toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgFormIdList.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (!bgFormIdList.isEmpty()) break block16;
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                return;
            }
            pstmt = conn.prepareStatement(sqlUpdate.toString());
            pstmt.setString(1, bgSSchemeInfo.getOrgUnit().getId().toString());
            pstmt.setString(2, bgSSchemeInfo.getId().toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                fid = rst.getString(1);
                formulaString = rst.getString(2);
                formulaMap.put(formulaString, BgNConstants.ZERO);
                dataMap.put(formulaString, fid);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            pstmt = conn.prepareStatement(sqlData.toString());
            pstmt.setString(1, bgSSchemeInfo.getId().toString());
            pstmt.setString(2, bgSSchemeInfo.getOrgUnit().getId().toString());
            pstmt.setString(3, bgSSchemeInfo.getId().toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                fid = rst.getString(1);
                formulaString = rst.getString(2);
                value = rst.getBigDecimal(3);
                formulaMap.put(formulaString, value);
                dataMap.put(formulaString, fid);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!formulaMap.isEmpty()) break block17;
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            return;
        }
        try {
            ibgForm = BgFormFactory.getLocalInstance(ctx);
            ibgFormFacade = BgFormFacadeFactory.getLocalInstance(ctx);
            if (ibgForm == null) throw new BgException(BgException.NOINSTANCE);
            if (ibgFormFacade == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            int in = bgFormIdList.size();
            for (int i = 0; i < in; ++i) {
                bgFormId = (String)bgFormIdList.get(i);
                bgFormInfo = BgFSHelper.getBgFormInfo(conn, BOSUuid.read((String)bgFormId), true);
                if (bgFormInfo.getZipData() != null && bgFormInfo.getZipData().length > 0) {
                    _book = bgFormInfo.getBook();
                    BgNFSHelper.disableUndo((Book)_book);
                    BgNFSHelper.disableCal((Book)_book);
                    if (_book != null) {
                        this.dealUpdateInitActualOfSheet(conn, bgTSchemeInfo, _book, formulaMap, rateValue);
                        bgFormInfo.setBook(_book);
                        BgNFSHelper.setActual((IObjectValue)bgFormInfo);
                        ibgForm.save((CoreBaseInfo)bgFormInfo);
                    }
                }
                if (!BgFormStateEnum.Approved.equals((Object)bgFormInfo.getState())) continue;
                DbUtil.execute((Context)ctx, (String)"update T_BG_BgData set FBizActual = FBgActual where FBgFormId = ?", (Object[])new String[]{bgFormId});
                ibgFormFacade.writeBgCtrlRecord(bgFormId);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
                catch (Exception ex3) {
                    logger.error((Object)ex3);
                    throw new BgException(BgException.UNSERIALIZABLEERROR, new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return;
    }

    protected void dealUpdateInitActualOfSheet(Connection conn, BgSchemeInfo bgSchemeInfo, Book book, Map formulaMap, BigDecimal rateValue) throws EASBizException {
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        int rowCount = 0;
        int rowIndex = 0;
        int colCount = 0;
        int colIndex = 0;
        String formulaString = null;
        BigDecimal value = null;
        HashMap<String, BigDecimal> updateMap = new HashMap<String, BigDecimal>();
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_cell)) continue;
                    formulaString = BgNFSHelper.getFormulaOfCell((Cell)_cell);
                    if (formulaMap.containsKey(formulaString)) {
                        value = (BigDecimal)formulaMap.get(formulaString);
                        value = value.multiply(rateValue);
                        BgNFSHelper.setActualValue((Cell)_cell, (BigDecimal)value);
                    } else {
                        try {
                            value = BgNFSHelper.getActualValue((Cell)_cell);
                            value = value.multiply(rateValue);
                        }
                        catch (Exception ex) {
                            value = BgConstants.BIGZERO;
                        }
                    }
                    updateMap.put(formulaString, value);
                }
            }
        }
        if (!updateMap.isEmpty()) {
            this.dealUpdateInitActualData(conn, bgSchemeInfo, updateMap);
        }
    }

    protected void dealUpdateInitActualData(Connection conn, BgSchemeInfo bgSchemeInfo, Map updateMap) throws EASBizException {
        PreparedStatement pstmt = null;
        String formulaString2 = null;
        BigDecimal value = null;
        int batchSize = 200;
        int batchIndex = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgData set FBizActual = ? where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (String formulaString2 : updateMap.keySet()) {
                value = (BigDecimal)updateMap.get(formulaString2);
                pstmt.setBigDecimal(1, value);
                pstmt.setString(2, bgSchemeInfo.getOrgUnit().getId().toString());
                pstmt.setString(3, bgSchemeInfo.getId().toString());
                pstmt.setString(4, formulaString2);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void builderAddActualCtrlRecord(Context ctx, Connection conn, BgSchemeInfo bgSSchemeInfo, BgSchemeInfo bgTSchemeInfo, BigDecimal rateValue, Map dataMap) throws BOSException, EASBizException {
        String bgFormAddId;
        String bgPeriodId222222;
        Map<String, BigDecimal> formulaMap;
        HashMap bgPeriodMap;
        ArrayList<String> bgActualAddIdList;
        IBgActualRecordFacade iActualFacade;
        IBgActualRecord iActualRecord;
        BgActualRecordInfo bgActualInfo;
        Book book;
        ResultSet rst;
        PreparedStatement pstmt;
        block19: {
            StringBuffer sqlAdd;
            block18: {
                if (conn == null) return;
                if (bgSSchemeInfo == null) return;
                if (bgTSchemeInfo == null) return;
                if (dataMap == null) {
                    return;
                }
                pstmt = null;
                rst = null;
                book = null;
                bgActualInfo = null;
                iActualRecord = null;
                iActualFacade = null;
                bgActualAddIdList = new ArrayList<String>();
                bgPeriodMap = new HashMap();
                formulaMap = new HashMap();
                bgPeriodId222222 = null;
                bgFormAddId = null;
                sqlAdd = new StringBuffer();
                StringBuffer sqlData = new StringBuffer();
                sqlData.append("select r.FBgPeriodId, t.FFormula, t.FBizActual from T_BG_BgActualData t left join T_BG_BgActualRecord r on t.FBgActualRecordId = r.FID where t.FOrgUnitId = ? and t.FBgSchemeId = ?");
                pstmt = conn.prepareStatement(sqlData.toString());
                pstmt.setString(1, bgSSchemeInfo.getOrgUnit().getId().toString());
                pstmt.setString(2, bgSSchemeInfo.getId().toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgPeriodId222222 = rst.getString(1);
                    if (bgPeriodMap.containsKey(bgPeriodId222222)) {
                        formulaMap = (Map)bgPeriodMap.get(bgPeriodId222222);
                    } else {
                        formulaMap = new HashMap();
                        bgPeriodMap.put(bgPeriodId222222, formulaMap);
                    }
                    formulaMap.put(rst.getString(2), rst.getBigDecimal(3));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (!bgPeriodMap.isEmpty()) break block18;
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                return;
            }
            ArrayList<String> _tmpList = new ArrayList<String>();
            sqlAdd.append("select t.FID from T_BG_BgActualRecord t left join T_BG_BgForm f on f.FID = t.FBgFormId where f.FBgSchemeId = ?");
            if (!bgPeriodMap.isEmpty()) {
                sqlAdd.append(" and t.FBgPeriodId IN (");
                for (String bgPeriodId222222 : bgPeriodMap.keySet()) {
                    sqlAdd.append("?,");
                    _tmpList.add(bgPeriodId222222);
                }
                sqlAdd.delete(sqlAdd.length() - 1, sqlAdd.length());
                sqlAdd.append(")");
            }
            pstmt = conn.prepareStatement(sqlAdd.toString());
            pstmt.setString(1, bgTSchemeInfo.getId().toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList, (int)2);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgActualAddIdList.add(rst.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!bgActualAddIdList.isEmpty()) break block19;
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            return;
        }
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("data");
            sic.add("state");
            sic.add("bgPeriod.id");
            sic.add("bgForm.id");
            iActualRecord = BgActualRecordFactory.getLocalInstance(ctx);
            iActualFacade = BgActualRecordFacadeFactory.getLocalInstance(ctx);
            if (iActualRecord == null) throw new BgException(BgException.NOINSTANCE);
            if (iActualFacade == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            int in = bgActualAddIdList.size();
            for (int i = 0; i < in; ++i) {
                bgFormAddId = (String)bgActualAddIdList.get(i);
                bgActualInfo = iActualRecord.getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(bgFormAddId), sic);
                bgPeriodId222222 = bgActualInfo.getBgPeriod().getId().toString();
                if (!bgPeriodMap.containsKey(bgPeriodId222222)) continue;
                formulaMap = (Map)bgPeriodMap.get(bgPeriodId222222);
                if (bgActualInfo.getZipData() == null || bgActualInfo.getZipData().length <= 0) continue;
                book = bgActualInfo.getBook();
                BgNFSHelper.disableCal((Book)book);
                BgNFSHelper.disableUndo((Book)book);
                if (book == null) continue;
                this.dealUpdateAddActualOfSheet(conn, bgTSchemeInfo, bgActualInfo, book, formulaMap, dataMap, rateValue);
                bgActualInfo.setBook(book);
                iActualRecord.save((CoreBaseInfo)bgActualInfo);
                if (bgActualInfo.getState().getValue() != 1) {
                    DbUtil.execute((Context)ctx, (String)"delete from T_BG_BgCtrlRecord where FBillId = ?", (Object[])new String[]{bgFormAddId});
                    iActualFacade.writeBgCtrlRecord(bgActualInfo.getId().toString());
                }
                book = null;
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (Exception ex3) {
                    logger.error((Object)ex3);
                    throw new BgException(BgException.UNSERIALIZABLEERROR, new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return;
    }

    protected void dealUpdateAddActualOfSheet(Connection conn, BgSchemeInfo bgSchemeInfo, BgActualRecordInfo bgActualRecordInfo, Book book, Map formulaMap, Map dataMap, BigDecimal rateValue) throws EASBizException {
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        int rowCount = 0;
        int rowIndex = 0;
        int colCount = 0;
        int colIndex = 0;
        String formulaString = null;
        BigDecimal value = null;
        HashMap<String, BigDecimal> updateMap = new HashMap<String, BigDecimal>();
        BgNFSHelper.disableUndo((Book)book);
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_cell) || !formulaMap.containsKey(formulaString = BgNFSHelper.getFormulaOfCell((Cell)_cell))) continue;
                    value = (BigDecimal)formulaMap.get(formulaString);
                    value = value.multiply(rateValue);
                    BgNFSHelper.setValue((Cell)_cell, (Object)value);
                    updateMap.put(formulaString, value);
                }
            }
        }
        if (!updateMap.isEmpty()) {
            this.dealUpdateAddActualData(conn, bgSchemeInfo, bgActualRecordInfo, updateMap, dataMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dealUpdateAddActualData(Connection conn, BgSchemeInfo bgSchemeInfo, BgActualRecordInfo bgActualRecordInfo, Map updateMap, Map dataMap) throws EASBizException {
        ResultSet rst;
        PreparedStatement inpst;
        Statement pstmt1;
        PreparedStatement pstmt;
        block30: {
            pstmt = null;
            pstmt1 = null;
            inpst = null;
            rst = null;
            String id = null;
            String formulaString2 = null;
            String key = null;
            BigDecimal value = null;
            BigDecimal tmpValue = null;
            ActualValue actualValue = null;
            HashMap<String, BigDecimal> formulaMap = new HashMap<String, BigDecimal>();
            HashMap<String, ActualValue> valueMap = new HashMap<String, ActualValue>();
            ArrayList<String> formulaList = new ArrayList<String>();
            int batchSize = 200;
            int updateIndex = 0;
            int instIndex = 0;
            int size = updateMap.size();
            int count = (size - 1) / batchSize + 1;
            int pos = 0;
            for (String formulaString2 : updateMap.keySet()) {
                formulaList.add(formulaString2);
            }
            StringBuffer bgsql = new StringBuffer();
            StringBuffer sql = new StringBuffer();
            StringBuffer sqlData = new StringBuffer();
            StringBuffer search = new StringBuffer();
            StringBuffer insert = new StringBuffer();
            bgsql.append("select t.FID, t.FFormula, b.FKey from T_BG_BgData t left join T_BG_BgItemCombination b on b.FID = t.FBgItemCombinid where t.FOrgUnitId = ? and t.FBgSchemeId = ? and t.FFormula in (");
            int in = batchSize;
            for (int i = 1; i < in; ++i) {
                bgsql.append("?,");
            }
            bgsql.append("?)");
            sql.append("update T_BG_BgData set FBizActual = FBizActual + ? where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula = ?");
            sqlData.append("update T_BG_BgActualData set FBizActual = ? where FBgActualRecordId = ? and FFormula = ?");
            search.append("select FFormula, FBizActual from T_BG_BgActualData where FBgActualRecordid = ?");
            insert.append("Insert Into T_BG_BgActualData (FID, FOrgUnitId, FBgSchemeId, FBgActualRecordId, FBizActual, FFormula, FBgDataId, FBgItemName, FBgPeriodId) Values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            try {
                if (bgActualRecordInfo.getState().getValue() != 1) {
                    pstmt = conn.prepareStatement(bgsql.toString());
                    for (int x = 0; x < count; ++x) {
                        pstmt.setString(1, bgSchemeInfo.getOrgUnit().getId().toString());
                        pstmt.setString(2, bgSchemeInfo.getId().toString());
                        int y = 3;
                        while (y <= batchSize + 2) {
                            if (pos < size) {
                                pstmt.setString(y, (String)formulaList.get(pos));
                            } else {
                                pstmt.setString(y, "#");
                            }
                            ++y;
                            ++pos;
                        }
                        try {
                            rst = pstmt.executeQuery();
                            while (rst.next()) {
                                id = rst.getString(1);
                                formulaString2 = rst.getString(2);
                                key = rst.getString(3).replaceAll("_", ",");
                                actualValue = new ActualValue();
                                actualValue.setFid(id);
                                actualValue.setFormula(formulaString2);
                                actualValue.setBgItemName(key);
                                valueMap.put(formulaString2, actualValue);
                            }
                            continue;
                        }
                        finally {
                            SQLUtils.cleanup((ResultSet)rst);
                        }
                    }
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                }
                try {
                    pstmt = conn.prepareStatement(search.toString());
                    pstmt.setString(1, bgActualRecordInfo.getId().toString());
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        formulaString2 = rst.getString(1);
                        value = rst.getBigDecimal(2);
                        formulaMap.put(formulaString2, value);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                pstmt = conn.prepareStatement(sqlData.toString());
                inpst = conn.prepareStatement(insert.toString());
                for (String formulaString2 : updateMap.keySet()) {
                    value = (BigDecimal)updateMap.get(formulaString2);
                    if (formulaMap.containsKey(formulaString2)) {
                        pstmt.setBigDecimal(1, value);
                        pstmt.setString(2, bgActualRecordInfo.getId().toString());
                        pstmt.setString(3, formulaString2);
                        pstmt.addBatch();
                        ++updateIndex;
                    } else {
                        inpst.setString(1, BOSUuid.create((String)"BgActual").toString());
                        inpst.setString(2, bgSchemeInfo.getOrgUnit().getId().toString());
                        inpst.setString(3, bgSchemeInfo.getId().toString());
                        inpst.setString(4, bgActualRecordInfo.getId().toString());
                        inpst.setBigDecimal(5, value);
                        inpst.setString(6, formulaString2);
                        if (valueMap.containsKey(formulaString2)) {
                            actualValue = (ActualValue)valueMap.get(formulaString2);
                            inpst.setString(7, actualValue.getFid());
                            inpst.setString(8, actualValue.getBgItemName());
                        } else {
                            inpst.setString(7, null);
                            inpst.setString(8, null);
                        }
                        inpst.setString(9, bgActualRecordInfo.getBgPeriod().getId().toString());
                        inpst.addBatch();
                        ++instIndex;
                    }
                    if (updateIndex >= batchSize) {
                        pstmt.executeBatch();
                        updateIndex = 0;
                    }
                    if (instIndex < batchSize) continue;
                    inpst.executeBatch();
                    instIndex = 0;
                }
                if (updateIndex != 0) {
                    pstmt.executeBatch();
                }
                if (instIndex != 0) {
                    inpst.executeBatch();
                }
                SQLUtils.cleanup((Statement)pstmt);
                SQLUtils.cleanup((Statement)inpst);
                if (bgActualRecordInfo.getState().getValue() == 1) break block30;
                updateIndex = 0;
                pstmt = conn.prepareStatement(sql.toString());
                for (String formulaString2 : updateMap.keySet()) {
                    value = (BigDecimal)updateMap.get(formulaString2);
                    if (!dataMap.containsKey(formulaString2) && formulaMap.containsKey(formulaString2)) {
                        tmpValue = (BigDecimal)formulaMap.get(formulaString2);
                        value = value.subtract(tmpValue);
                        pstmt.setBigDecimal(1, value);
                    } else {
                        pstmt.setBigDecimal(1, value);
                    }
                    pstmt.setString(2, bgSchemeInfo.getOrgUnit().getId().toString());
                    pstmt.setString(3, bgSchemeInfo.getId().toString());
                    pstmt.setString(4, formulaString2);
                    pstmt.addBatch();
                    if (++updateIndex < batchSize) continue;
                    pstmt.executeBatch();
                    updateIndex = 0;
                }
                if (updateIndex != 0) {
                    pstmt.executeBatch();
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt);
                    SQLUtils.cleanup(pstmt1);
                    SQLUtils.cleanup(inpst);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        SQLUtils.cleanup(pstmt1);
        SQLUtils.cleanup((Statement)inpst);
    }

    protected void builderBillActualCtrlRecord(Context ctx, Connection conn, BgSchemeInfo bgSSchemeInfo, BgSchemeInfo bgTSchemeInfo, BigDecimal rateValue, Map dataMap) throws EASBizException {
        if (conn == null || bgSSchemeInfo == null || bgTSchemeInfo == null || dataMap == null) {
            return;
        }
        if (!bgTSchemeInfo.isIsFormal()) {
            if (this.checkHasCtrlRecord(conn, bgTSchemeInfo, dataMap)) {
                this.removeCtrlRecord(conn, bgTSchemeInfo, dataMap);
            }
            this.builderBillCtrlRecord(ctx, conn, bgSSchemeInfo, bgTSchemeInfo, rateValue);
        } else {
            this.builderAddBillCtrlRecord(conn, bgTSchemeInfo, dataMap);
        }
    }

    protected boolean checkHasCtrlRecord(Connection conn, BgSchemeInfo bgSchemeInfo, Map dataMap) throws EASBizException {
        boolean re = false;
        if (conn == null || bgSchemeInfo == null) {
            return re;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BigDecimal value = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select count(t.FID) from T_BG_BgCtrlRecord t join T_BG_BgData d on t.FBgDataId = d.FID where d.FOrgUnitId = ? and d.FBgSchemeId = ? and (t.FBgTraceType = 3 or t.FBgTraceType = 5 or t.FBgTraceType = 4)");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgSchemeInfo.getOrgUnit().getId().toString());
            pstmt.setString(2, bgSchemeInfo.getId().toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                value = rst.getBigDecimal(1);
                re = value != null && value.compareTo(BgConstants.BIGZERO) == 0;
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return re;
    }

    protected void removeCtrlRecord(Connection conn, BgSchemeInfo bgSchemeInfo, Map dataMap) throws EASBizException {
        if (conn == null || bgSchemeInfo == null) {
            return;
        }
        HashMap<String, String> idMap = new HashMap<String, String>();
        int batchSize = 200;
        int batchIndex = 0;
        PreparedStatement pstmt = null;
        PreparedStatement upstmt = null;
        ResultSet rst = null;
        BigDecimal value = null;
        String formulaStr2 = null;
        String fid = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer update = new StringBuffer();
        sql.append("select t.FBgDataID, t.FActualAmount from T_BG_BgCtrlRecord t join T_BG_BgData d on t.FBgDataId = d.FID where d.FOrgUnitId = ? and d.FBgSchemeId = ? and (t.FBgTraceType = 3 or t.FBgTraceType = 5 or t.FBgTraceType = 4)");
        update.append("update T_BG_BgData set FBizActual = FBizActual - ? where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula = ?");
        for (String formulaStr2 : dataMap.keySet()) {
            fid = (String)dataMap.get(formulaStr2);
            idMap.put(fid, formulaStr2);
        }
        try {
            upstmt = conn.prepareStatement(update.toString());
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgSchemeInfo.getOrgUnit().getId().toString());
            pstmt.setString(2, bgSchemeInfo.getId().toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                fid = rst.getString(1);
                value = rst.getBigDecimal(2);
                if (idMap.containsKey(fid)) continue;
                formulaStr2 = (String)idMap.get(fid);
                upstmt.setBigDecimal(1, value);
                upstmt.setString(2, bgSchemeInfo.getOrgUnit().getId().toString());
                upstmt.setString(3, bgSchemeInfo.getId().toString());
                upstmt.setString(4, formulaStr2);
                upstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                upstmt.executeBatch();
                batchIndex = 0;
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (batchIndex != 0) {
                upstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                SQLUtils.cleanup((Statement)upstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        SQLUtils.cleanup((Statement)upstmt);
    }

    protected void builderBillCtrlRecord(Context ctx, Connection conn, BgSchemeInfo bgSSchemeInfo, BgSchemeInfo bgTSchemeInfo, BigDecimal rateValue) throws EASBizException {
        StringBuffer update;
        StringBuffer insert;
        StringBuffer sqlData;
        String noFindStr;
        String Id;
        String formulaStr2;
        BigDecimal value;
        int pos;
        int count;
        int size;
        int batchNum;
        int index;
        int batchIndex;
        int batchSize;
        ActualValue actualValue;
        HashMap<String, BigDecimal> updateMap;
        HashMap<String, String> ActualMap;
        HashMap<String, ActualValue> formulaMap;
        ArrayList<String> formulaList;
        BgCtrlRecordInfo bgCtrlRecordInfo;
        CtrlUnitInfo cu;
        UserInfo user;
        ResultSet rst;
        PreparedStatement pstmt;
        block20: {
            if (conn == null || bgSSchemeInfo == null || bgTSchemeInfo == null || rateValue == null) {
                return;
            }
            pstmt = null;
            rst = null;
            user = null;
            cu = null;
            bgCtrlRecordInfo = null;
            formulaList = new ArrayList<String>();
            formulaMap = new HashMap<String, ActualValue>();
            ActualMap = new HashMap<String, String>();
            updateMap = new HashMap<String, BigDecimal>();
            actualValue = null;
            batchSize = 200;
            batchIndex = 0;
            index = 0;
            batchNum = 100;
            size = 0;
            count = 0;
            pos = 0;
            value = null;
            formulaStr2 = null;
            Id = null;
            String bgItemName = null;
            String bgPeriodName = null;
            noFindStr = "#";
            StringBuffer sql = new StringBuffer();
            sqlData = new StringBuffer();
            insert = new StringBuffer();
            update = new StringBuffer();
            StringBuffer delete = new StringBuffer();
            sql.append("select d.FFormula, sum(t.FActualAmount), t.FItemName, t.FBgPeriodId from T_BG_BgCtrlRecord t join T_BG_BgData d on t.FBgDataId = d.FID where d.FOrgUnitId = ? and d.FBgSchemeId = ? and (t.FBgTraceType = 3 or t.FBgTraceType = 5 or t.FBgTraceType = 6 or t.FBgTraceType = 7 or t.FBgTraceType = 4) group by d.FFormula, t.FItemName, t.FBgPeriodId");
            sqlData.append("select FID, FFormula from T_BG_BgData where FOrgUnitId = ? and FBgSchemeId = ? and FFormula IN (");
            int in = batchNum;
            for (int i = 1; i < in; ++i) {
                sqlData.append("?,");
            }
            sqlData.append("?)");
            insert.append("INSERT INTO T_BG_BgCtrlRecord(FID, FCREATORID, FCREATETIME, FCONTROLUNITID, FBGDATAID, FBILLTYPE, FBIZDATE, FACTUALAMOUNT, FBGPERIODID, FITEMNAME, FBGTRACETYPE) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            update.append("update T_BG_BgData set FBizActual = FBizActual + ? where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula = ?");
            delete.append("delete from T_BG_BgCtrlRecord where FBgDataId in (select FID from T_BG_BgData d where FOrgUnitId = ? and FBgSchemeId = ?) and (FBgTraceType = 3 or FBgTraceType = 5 or FBgTraceType = 6 or FBgTraceType = 7 or FBgTraceType = 4)");
            pstmt = conn.prepareStatement(delete.toString());
            pstmt.setString(1, bgTSchemeInfo.getOrgUnit().getId().toString());
            pstmt.setString(2, bgTSchemeInfo.getId().toString());
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgSSchemeInfo.getOrgUnit().getId().toString());
            pstmt.setString(2, bgSSchemeInfo.getId().toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                formulaStr2 = rst.getString(1);
                value = rst.getBigDecimal(2);
                bgItemName = rst.getString(3);
                bgPeriodName = rst.getString(4);
                if (formulaMap.containsKey(formulaStr2)) {
                    actualValue = (ActualValue)formulaMap.get(formulaStr2);
                    actualValue.setActualValue(actualValue.getActualValue().add(value));
                    continue;
                }
                actualValue = new ActualValue();
                actualValue.setActualValue(value);
                actualValue.setBgItemName(bgItemName);
                actualValue.setBgPeriodName(bgPeriodName);
                formulaMap.put(formulaStr2, actualValue);
                formulaList.add(formulaStr2);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!formulaMap.isEmpty()) break block20;
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            return;
        }
        try {
            pos = 0;
            size = formulaList.size();
            count = (size - 1) / batchNum + 1;
            pstmt = conn.prepareStatement(sqlData.toString());
            for (index = 0; index < count; ++index) {
                pstmt.setString(1, bgTSchemeInfo.getOrgUnit().getId().toString());
                pstmt.setString(2, bgTSchemeInfo.getId().toString());
                int k = 3;
                while (k <= batchNum + 2) {
                    if (pos < size) {
                        pstmt.setString(k, (String)formulaList.get(pos));
                    } else {
                        pstmt.setString(k, noFindStr);
                    }
                    ++k;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    Id = rst.getString(1);
                    formulaStr2 = rst.getString(2);
                    ActualMap.put(formulaStr2, Id);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement(insert.toString());
            batchIndex = 0;
            bgCtrlRecordInfo = new BgCtrlRecordInfo();
            user = ContextUtil.getCurrentUserInfo((Context)ctx);
            cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            for (String formulaStr2 : formulaMap.keySet()) {
                actualValue = (ActualValue)formulaMap.get(formulaStr2);
                value = actualValue.getActualValue().multiply(rateValue);
                pstmt.setString(1, BOSUuid.create((BOSObjectType)bgCtrlRecordInfo.getBOSType()).toString());
                pstmt.setString(2, user.getId().toString());
                pstmt.setTimestamp(3, timestamp);
                pstmt.setString(4, cu.getId().toString());
                if (ActualMap.containsKey(formulaStr2)) {
                    Id = (String)ActualMap.get(formulaStr2);
                    pstmt.setString(5, BOSUuid.read((String)Id).toString());
                    updateMap.put(formulaStr2, value);
                } else {
                    pstmt.setString(5, null);
                }
                pstmt.setString(6, BgTraceTypeEnum.SCHEME.getAlias());
                pstmt.setTimestamp(7, timestamp);
                pstmt.setBigDecimal(8, value);
                pstmt.setString(9, actualValue.getBgPeriodName());
                pstmt.setString(10, actualValue.getBgItemName());
                pstmt.setInt(11, 5);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
            SQLUtils.cleanup((Statement)pstmt);
            batchIndex = 0;
            pstmt = conn.prepareStatement(update.toString());
            for (String formulaStr2 : updateMap.keySet()) {
                value = (BigDecimal)updateMap.get(formulaStr2);
                pstmt.setBigDecimal(1, value);
                pstmt.setString(2, bgTSchemeInfo.getOrgUnit().getId().toString());
                pstmt.setString(3, bgTSchemeInfo.getId().toString());
                pstmt.setString(4, formulaStr2);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
            SQLUtils.cleanup((Statement)pstmt);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
    }

    protected void builderAddBillCtrlRecord(Connection conn, BgSchemeInfo bgSchemeInfo, Map dataMap) throws EASBizException {
        if (conn == null || bgSchemeInfo == null || dataMap.isEmpty()) {
            return;
        }
        PreparedStatement pstmt = null;
        PreparedStatement upstmt = null;
        ResultSet rst = null;
        int batchSize = 200;
        int batchIndex = 0;
        String formulaStr = null;
        String _orgUnitId = bgSchemeInfo.getOrgUnit().getId().toString();
        String _bgSchemeId = bgSchemeInfo.getId().toString();
        BigDecimal value = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer update = new StringBuffer();
        sql.append("select t.FActualAmount, d.FFormula from T_BG_BgCtrlRecord t left join T_BG_BgData d on d.FID = t.FBgDataId where d.forgunitid = ? and d.fbgschemeid = ? and (t.FBgTraceType = 3 or t.FBgTraceType = 5 or t.FBgTraceType = 4)");
        update.append("update T_BG_BgData set FBizActual = FBizActual + ? where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, _orgUnitId);
            pstmt.setString(2, _bgSchemeId);
            rst = pstmt.executeQuery();
            upstmt = conn.prepareStatement(update.toString());
            while (rst.next()) {
                value = rst.getBigDecimal(1);
                formulaStr = rst.getString(2);
                if (!dataMap.containsKey(formulaStr)) continue;
                upstmt.setBigDecimal(1, value);
                upstmt.setString(2, _orgUnitId);
                upstmt.setString(3, _bgSchemeId);
                upstmt.setString(4, formulaStr);
                upstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                upstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                upstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                SQLUtils.cleanup(upstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        SQLUtils.cleanup((Statement)upstmt);
    }

    private Map getSchemeIdFromRootId(Context ctx, OrgUnitInfo[] orgUnits, String bgSchemeRootId) throws BOSException {
        if (StringUtils.isEmpty((String)bgSchemeRootId) || orgUnits == null || orgUnits.length <= 0) {
            return null;
        }
        HashMap<String, String> returnMap = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select fOrgUnitid, fid from t_bg_bgScheme ");
        sql.append("where FRootId = ? ");
        sql.append("and FOrgUnitID in (");
        for (int i = 1; i < orgUnits.length; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgSchemeRootId);
            for (int i = 0; i < orgUnits.length; ++i) {
                pstmt.setString(2 + i, orgUnits[i].getId().toString());
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                returnMap.put(rst.getString("fOrgUnitid"), rst.getString("fid"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return returnMap;
    }

    class ActualValue {
        private String fid = null;
        private String formula = null;
        private BigDecimal ActualValue = null;
        private BigDecimal initValue = null;
        private BigDecimal addValue = null;
        private BigDecimal billValue = null;
        private String bgItemName = null;
        private String bgPeriodName = null;

        ActualValue() {
        }

        public String getFid() {
            return this.fid;
        }

        public void setFid(String fid) {
            this.fid = fid;
        }

        public String getFormula() {
            return this.formula;
        }

        public void setFormula(String formula) {
            this.formula = formula;
        }

        public BigDecimal getActualValue() {
            return this.ActualValue;
        }

        public void setActualValue(BigDecimal actualValue) {
            this.ActualValue = actualValue;
        }

        public BigDecimal getInitValue() {
            return this.initValue;
        }

        public void setInitValue(BigDecimal initValue) {
            this.initValue = initValue;
        }

        public BigDecimal getAddValue() {
            return this.addValue;
        }

        public void setAddValue(BigDecimal addValue) {
            this.addValue = addValue;
        }

        public BigDecimal getBillValue() {
            return this.billValue;
        }

        public void setBillValue(BigDecimal billValue) {
            this.billValue = billValue;
        }

        public String getBgItemName() {
            return this.bgItemName;
        }

        public void setBgItemName(String bgItemName) {
            this.bgItemName = bgItemName;
        }

        public String getBgPeriodName() {
            return this.bgPeriodName;
        }

        public void setBgPeriodName(String bgPeriodName) {
            this.bgPeriodName = bgPeriodName;
        }
    }
}

