/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgActualRecordInfo;
import com.kingdee.eas.ma.budget.BgSchemeAssignException;
import com.kingdee.eas.ma.budget.IBgActualRecord;
import com.kingdee.eas.ma.budget.app.AbstractBgActualRecordNewFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BgActualRecordNewFacadeControllerBean
extends AbstractBgActualRecordNewFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgActualRecordNewFacadeControllerBean");

    @Override
    protected void _periodDeco(Context ctx, String sourceID, List idList) throws BOSException, EASBizException {
        StringBuffer sql1 = new StringBuffer("select fid,fname from T_BG_BgActualRecord ");
        Object[] sql1Param = new String[idList.size() + 1];
        sql1.append(" where fid = ? ");
        sql1Param[0] = sourceID;
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            sql1.append(" or fid = ? ");
            sql1Param[i + 1] = (String)idList.get(i);
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql1.toString(), (Object[])sql1Param);
        HashMap<String, String> mapForLog = new HashMap<String, String>();
        try {
            while (rowSet.next()) {
                mapForLog.put(rowSet.getString("fid"), rowSet.getString("fname"));
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, sqle);
        }
        String logName = "";
        BgActualRecordInfo bgActualRecord = BgActualRecordFactory.getLocalInstance(ctx).getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(sourceID));
        logName = bgActualRecord.getNumber() + " " + bgActualRecord.getName();
        IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)"_periodDeco", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgActualRecode_periodGather");
        if (idList == null || idList.isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer("select FFormula,FBizActual from T_BG_BgActualData ");
        int size2 = idList.size();
        for (int i = 0; i < size2; ++i) {
            if (i == 0) {
                sql.append(" where FBgActualRecordID = ? ");
                continue;
            }
            sql.append(" or FBgActualRecordID = ? ");
        }
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])idList.toArray());
        String formula = null;
        HashMap<String, BigDecimal> formulaDataMap = new HashMap<String, BigDecimal>();
        BigDecimal value = null;
        String[] param = null;
        HashMap mapTem = new HashMap();
        try {
            while (rowSet.next()) {
                formula = rowSet.getString("FFormula");
                value = rowSet.getBigDecimal("FBizActual");
                param = BgNFSHelper.parseFormulaPara(mapTem, (String)formula);
                if (param.length == 4) {
                    formula = param[0] + "," + param[2] + "," + param[3];
                } else if (param.length == 6) {
                    formula = param[0] + "," + param[2] + "," + param[5];
                } else {
                    logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"4_BgActualRecordNewFacadeControllerBean", (Locale)ctx.getLocale()));
                    continue;
                }
                if (formulaDataMap.containsKey(formula)) {
                    value = value.add((BigDecimal)formulaDataMap.get(formula));
                    formulaDataMap.put(formula, value);
                    continue;
                }
                formulaDataMap.put(formula, value);
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, sqle);
        }
        BgActualRecordInfo recordInfo = (BgActualRecordInfo)BgActualRecordFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(sourceID));
        Book book = null;
        try {
            book = recordInfo.getBook();
        }
        catch (Exception e) {
            logger.equals(e);
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, e);
        }
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        boolean isChangeValue = false;
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            sheet = book.getSheet(i);
            int maxRowCount = sheet.getMaxRowIndex() + 1;
            int maxColCount = sheet.getMaxColIndex() + 1;
            for (int j = 0; j < maxRowCount; ++j) {
                row = sheet.getRow(j, false);
                if (row == null) continue;
                for (int q = 0; q < maxColCount; ++q) {
                    cell = row.getCell(q, false);
                    if (cell == null || StringUtils.isEmpty((String)(formula = BgNFSHelper.getFormulaOfCell((Cell)cell)))) continue;
                    param = BgNFSHelper.parseFormulaPara(mapTem, (String)formula);
                    if (param.length == 4) {
                        formula = param[0] + "," + param[2] + "," + param[3];
                    } else if (param.length == 6) {
                        formula = param[0] + "," + param[2] + "," + param[5];
                    } else {
                        logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"4_BgActualRecordNewFacadeControllerBean", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!formulaDataMap.containsKey(formula)) continue;
                    value = (BigDecimal)formulaDataMap.get(formula);
                    BgNFSHelper.setValue((Cell)cell, (Object)value);
                    isChangeValue = true;
                }
            }
        }
        if (isChangeValue) {
            byte[] data = null;
            try {
                data = IOHelper.packBook((Book)book);
            }
            catch (IOException e) {
                logger.equals(e);
                throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, e);
            }
            this.insertMapData(ctx, sourceID, data, "t_bg_Bgactualrecord");
        }
        IBgActualRecord iBgActu = BgActualRecordFactory.getLocalInstance(ctx);
        BgActualRecordInfo info = iBgActu.getBgActualRecordInfo((IObjectPK)new ObjectUuidPK(sourceID));
        try {
            info.setBook(book);
        }
        catch (IOException e) {
            logger.equals(e);
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, e);
        }
        iBgActu.saveFromPeriodDeco((IObjectValue)info);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
    }

    private void insertMapData(Context ctx, String id, byte[] data, String table) throws BOSException, EASBizException {
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(400);
            strBuffer.append("update " + table + " set fdata = ? where fid = ? ");
            ps = connection.prepareStatement(strBuffer.toString());
            if (data == null) {
                ps.setBytes(1, null);
            } else {
                BgInfoHelper.setBytes((PreparedStatement)ps, (int)1, (byte[])data);
            }
            ps.setString(2, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }
}

