/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgAdjustBillCollection;
import com.kingdee.eas.ma.budget.BgAdjustBillEntryCollection;
import com.kingdee.eas.ma.budget.BgAdjustBillEntryInfo;
import com.kingdee.eas.ma.budget.BgAdjustBillFactory;
import com.kingdee.eas.ma.budget.BgAdjustBillInfo;
import com.kingdee.eas.ma.budget.BgAdjustException;
import com.kingdee.eas.ma.budget.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.budget.BgAdjustStateEnum;
import com.kingdee.eas.ma.budget.BgAdjustTypeEnum;
import com.kingdee.eas.ma.budget.BgCollectFormFactory;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgCtrlTypeEnum;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgExamineFacadeFactory;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormAdjustData;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPastSourceEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.IBgAdjustBill;
import com.kingdee.eas.ma.budget.IBgExamineFacade;
import com.kingdee.eas.ma.budget.IBgFacade;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.VisualItemCollection;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.app.AbstractBgAdjustBillControllerBean;
import com.kingdee.eas.ma.nbudget.BgCalculateSchemeFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgFacadeHelper;
import com.kingdee.eas.ma.nbudget.BgNAdjHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.IBgCalculateSchemeFacade;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgAdjustBillControllerBean
extends AbstractBgAdjustBillControllerBean {
    private static final long serialVersionUID = 4373246010198735874L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgAdjustBillControllerBean");

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("creator"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("bgScheme.name"));
        sic.add(new SelectorItemInfo("bgScheme.number"));
        sic.add(new SelectorItemInfo("bgScheme.rootId"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("entry.formula"));
        sic.add(new SelectorItemInfo("entry.bgItemId"));
        sic.add(new SelectorItemInfo("entry.adjustBefore"));
        sic.add(new SelectorItemInfo("entry.adjustApply"));
        sic.add(new SelectorItemInfo("entry.adjustPass"));
        sic.add(new SelectorItemInfo("entry.adjustAfter"));
        sic.add(new SelectorItemInfo("entry.adjustGroup"));
        sic.add(new SelectorItemInfo("entry.adjustCause"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.number"));
        sic.add(new SelectorItemInfo("entry.adjustType"));
        sic.add(new SelectorItemInfo("entry.orgUnit.id"));
        sic.add(new SelectorItemInfo("entry.orgUnit.name"));
        sic.add(new SelectorItemInfo("entry.orgUnit.number"));
        sic.add(new SelectorItemInfo("entry.bgScheme.id"));
        sic.add(new SelectorItemInfo("entry.bgScheme.name"));
        sic.add(new SelectorItemInfo("entry.bgScheme.number"));
        sic.add(new SelectorItemInfo("entry.bgForm.id"));
        sic.add(new SelectorItemInfo("entry.bgForm.name"));
        sic.add(new SelectorItemInfo("entry.bgForm.number"));
        sic.add(new SelectorItemInfo("entry.bgPeriod.id"));
        sic.add(new SelectorItemInfo("entry.bgPeriod.name"));
        sic.add(new SelectorItemInfo("entry.bgPeriod.number"));
        sic.add(new SelectorItemInfo("entry.bgElement.id"));
        sic.add(new SelectorItemInfo("entry.bgElement.name"));
        sic.add(new SelectorItemInfo("entry.bgElement.number"));
        sic.add(new SelectorItemInfo("entry.currency.id"));
        sic.add(new SelectorItemInfo("entry.currency.name"));
        sic.add(new SelectorItemInfo("entry.currency.number"));
        sic.add(new SelectorItemInfo("entry.currency.precision"));
        return sic;
    }

    protected SelectorItemCollection getStateSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("auditor"));
        return sic;
    }

    @Override
    protected void _createTmpData(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return;
        }
        BgAdjustBillInfo billInfo = (BgAdjustBillInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(billId));
        this.createTmpData(ctx, (IObjectValue)billInfo);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.createTmpData(ctx, model);
        return super._save(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (BgNSHelper.checkInProInst((Context)ctx, (String)pk.toString())) {
            throw new BgAdjustException(BgAdjustException.REMOVEERROROFREFERWORKING);
        }
        IBgAdjustBill ibgab = BgAdjustBillFactory.getLocalInstance(ctx);
        BgAdjustBillInfo info = ibgab.getBgAdjustBillInfo(pk);
        BgHelper.recycleNumber(ctx, (CoreBaseInfo)info, info.getOrgUnit().getId().toString());
        this.clearTmpData(ctx, pk);
        super._delete(ctx, pk);
    }

    private void createTmpData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgAdjustBillInfo billInfo = (BgAdjustBillInfo)model;
        if (billInfo.getEntry() != null && !billInfo.getEntry().isEmpty()) {
            HashMap<BOSUuid, Map<String, BgAdjustFormDiversityData>> bgFormMap = new HashMap<BOSUuid, Map<String, BgAdjustFormDiversityData>>();
            Map<String, BgAdjustFormDiversityData> adjustMap = null;
            BgAdjustFormDiversityData divData = null;
            BOSUuid bgFormId2 = null;
            BgFormInfo bgFormInfo = null;
            BgAdjustBillEntryInfo entry = null;
            BgAdjustBillEntryCollection entrys = null;
            entrys = billInfo.getEntry();
            int n = entrys.size();
            for (int i = 0; i < n; ++i) {
                entry = entrys.get(i);
                bgFormInfo = entry.getBgForm();
                if (bgFormMap.containsKey(bgFormInfo.getId())) {
                    adjustMap = (Map)bgFormMap.get(bgFormInfo.getId());
                } else {
                    adjustMap = new HashMap();
                    bgFormMap.put(bgFormInfo.getId(), adjustMap);
                }
                if (adjustMap.get(entry.getFormula()) instanceof BgAdjustFormDiversityData) {
                    divData = (BgAdjustFormDiversityData)adjustMap.get(entry.getFormula());
                } else {
                    divData = new BgAdjustFormDiversityData();
                    adjustMap.put(entry.getFormula(), divData);
                }
                divData.setFormula(entry.getFormula());
                divData.setOldValue(entry.getAdjustBefore());
                divData.setNewValue(entry.getAdjustAfter());
                divData.setAdjustReson(entry.getAdjustCause());
            }
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                for (BOSUuid bgFormId2 : bgFormMap.keySet()) {
                    adjustMap = (Map)bgFormMap.get(bgFormId2);
                    bgFormInfo = BgFSHelper.getBgFormInfo(conn, bgFormId2, false);
                    String[] formulaInfo = BgFacadeHelper.checkFormulaIsEctypeInTmpData((Connection)conn, (BOSUuid)bgFormInfo.getOrgUnit().getId(), (BOSUuid)bgFormInfo.getBgScheme().getId(), (BOSUuid)bgFormInfo.getAdjust().getId(), new ArrayList(adjustMap.keySet()));
                    if (formulaInfo != null) {
                        throw new BgFormException(BgFormException.EXISTADJUSTFORMULA, new String[]{formulaInfo[0].replaceAll(",\"BgData\",true", ""), formulaInfo[1]});
                    }
                    BgNAdjHelper.createTmpDataOfFormula((Context)ctx, (Connection)conn, (BOSUuid)bgFormInfo.getOrgUnit().getId(), (BOSUuid)bgFormInfo.getBgScheme().getId(), (BOSUuid)bgFormInfo.getBgTemplate().getId(), (BOSUuid)bgFormInfo.getId(), adjustMap);
                }
            }
            catch (BOSException ex) {
                throw ex;
            }
            catch (EASBizException ex) {
                throw ex;
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }

    private void clearTmpData(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.clearTmpData(ctx, (IObjectValue)this.getValue(ctx, pk));
    }

    private void clearTmpData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgAdjustBillInfo billInfo = (BgAdjustBillInfo)model;
        if (billInfo.getEntry() != null && !billInfo.getEntry().isEmpty()) {
            HashMap bgFormMap = new HashMap();
            BOSUuid bgFormId2 = null;
            BgAdjustBillEntryInfo entry = null;
            BgAdjustBillEntryCollection entrys = null;
            entrys = billInfo.getEntry();
            int n = entrys.size();
            for (int i = 0; i < n; ++i) {
                entry = entrys.get(i);
                bgFormId2 = entry.getBgForm().getId();
                if (bgFormMap.containsKey(bgFormId2)) continue;
                bgFormMap.put(bgFormId2, null);
            }
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                for (BOSUuid bgFormId2 : bgFormMap.keySet()) {
                    SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + bgFormId2.toString() + "'"));
                }
            }
            catch (SQLException ex) {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (BOSException ex) {
                throw ex;
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IBgFacade ibgFacade = BgFacadeFactory.getLocalInstance(ctx);
        ibgFacade.checkIsCanAdjustBill((BgAdjustBillInfo)model);
        BgAdjustBillInfo info = (BgAdjustBillInfo)model;
        if (info.getEntry() != null && !info.getEntry().isEmpty()) {
            String sql = "select bgdata.FBgValue bgvalue from t_bg_bgdata bgdata where bgdata.fbgformid = ? and bgdata.fformula = ?";
            Connection conn = null;
            PreparedStatement pst = null;
            ResultSet res = null;
            BgAdjustBillEntryInfo entry = null;
            try {
                conn = this.getConnection(ctx);
                pst = conn.prepareStatement(sql);
                for (int i = 0; i < info.getEntry().size(); ++i) {
                    entry = info.getEntry().get(i);
                    pst.setString(1, entry.getBgForm().getId().toString());
                    pst.setString(2, entry.getFormula());
                    res = pst.executeQuery();
                    if (res.next()) {
                        entry.setAdjustBefore(res.getBigDecimal("bgvalue"));
                        entry.setAdjustAfter(entry.getAdjustBefore().add(entry.getAdjustPass()));
                    }
                    SQLUtils.cleanup((ResultSet)res);
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, pst, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(res, (Statement)pst, (Connection)conn);
        }
        if (info.getCU() == null) {
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (info.getNumber() == null || info.getNumber().trim().length() == 0) {
            BgHelper.setSNumber(ctx, info.getOrgUnit().getId().toString(), (CoreBaseInfo)info);
        }
        if (info.getNumber() == null || info.getNumber().length() == 0) {
            throw new BgAdjustException(BgAdjustException.NUMBERISNULL);
        }
        this.checkAdjustBillNumber(ctx, info);
        return super._addnew(ctx, model);
    }

    protected void checkAdjustBillNumber(Context ctx, BgAdjustBillInfo model) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection item = filter.getFilterItems();
        item.add(new FilterItemInfo("number", (Object)model.getNumber(), CompareType.EQUALS));
        item.add(new FilterItemInfo("orgUnit", (Object)model.getOrgUnit().getId(), CompareType.EQUALS));
        if (model.getId() != null) {
            item.add(new FilterItemInfo("id", (Object)model.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 AND #1 AND #2");
        } else {
            filter.setMaskString("#0 AND #1 ");
        }
        IBgAdjustBill ibgAdjust = BgAdjustBillFactory.getLocalInstance(ctx);
        if (ibgAdjust.exists(filter)) {
            throw new BgAdjustException(BgAdjustException.NUMBERREPEAT, new String[]{model.getNumber()});
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        IBgFacade ibgFacade = BgFacadeFactory.getLocalInstance(ctx);
        ibgFacade.checkIsCanAdjustBill((BgAdjustBillInfo)model);
        super._update(ctx, pk, model);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectValue _getBudgetData(Context ctx, BOSUuid orgUnit, BOSUuid bgScheme, BOSUuid bgForm, String formula) throws BOSException, EASBizException {
        BgDataInfo data = null;
        BigDecimal value = BgConstants.BIGZERO;
        if (orgUnit == null) return data;
        if (bgScheme == null) return data;
        if (formula == null) {
            return data;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            BgFormInfo bgFormInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo("select id, bgTemplate.id, bgTemplate.formType where id = '" + bgForm + "'");
            StringBuffer sql = new StringBuffer("select bgData.FBgValue ,bgData.fiscontrol,bgData.fisflexible,bgData.fflexparam,bgData.fctrltype,bgData.fisgroupctrl, bgData.fgroupno, bgData.fIsAllowAccess  from T_BG_BgData bgData ");
            if (BgTemFormTypeEnum.VIEWFORM.equals((Object)bgFormInfo.getBgTemplate().getFormType())) {
                sql.append(" join T_Bg_BgDataEntry dataEntry on dataEntry.FBgDataId = bgData.FID ");
                sql.append(" where bgData.FOrgUnitId = ? and bgData.FBgSchemeId = ? and dataEntry.FBgFormId = ? and bgData.FFormula = ?");
            } else {
                sql.append(" where bgData.FOrgUnitId = ? and bgData.FBgSchemeId = ? and bgData.FBgFormId = ? and bgData.FFormula = ?");
            }
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgUnit.toString());
            pstmt.setString(2, bgScheme.toString());
            pstmt.setString(3, bgForm.toString());
            pstmt.setString(4, formula);
            rst = pstmt.executeQuery();
            if (!rst.next()) {
                throw new BgAdjustException(BgAdjustException.NOFORMULA, new String[]{formula});
            }
            value = rst.getBigDecimal(1);
            boolean isControl = rst.getBoolean(2);
            boolean isFlexible = rst.getBoolean(3);
            BigDecimal flexParam = rst.getBigDecimal(4) == null ? new BigDecimal(1.0) : rst.getBigDecimal(4);
            BgCtrlTypeEnum ctrlType = BgCtrlTypeEnum.getEnum(rst.getInt(5));
            boolean isGroupCtrl = rst.getBoolean(6);
            String groupNo = rst.getString(7) == null ? "-1" : rst.getString(7);
            boolean isAllowAccess = rst.getBoolean(8);
            data = new BgDataInfo();
            data.setBgValue(value);
            data.setIsControl(isControl);
            data.setIsFlexible(isFlexible);
            data.setFlexParam(flexParam);
            data.setCtrlType(ctrlType);
            data.setIsGroupCtrl(isGroupCtrl);
            data.setGroupNo(groupNo);
            data.setIsAllowAccess(isAllowAccess);
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
                catch (BOSException ex3) {
                    logger.error((Object)ex3.getMessage());
                    throw ex3;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return data;
    }

    @Override
    protected boolean _submitRefer(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        return true;
    }

    @Override
    protected boolean _submitAudit(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        block14: {
            if (id == null) {
                throw new BgException(BgException.NOOBJECT, new String[]{""});
            }
            BOSUuid bgFormId2 = null;
            ObjectUuidPK pk = null;
            BgAdjustBillInfo info = null;
            BgAdjustBillEntryInfo entry = null;
            BgAdjustBillEntryCollection entrys = null;
            String formulaString = null;
            BgAdjustFormDiversityData divData = null;
            HashMap<BOSUuid, HashMap> useBgForm = new HashMap<BOSUuid, HashMap>();
            HashMap divDataMap = null;
            try {
                pk = new ObjectUuidPK(id);
                if (this._exists(ctx, (IObjectPK)pk)) {
                    info = (BgAdjustBillInfo)this._getValue(ctx, (IObjectPK)pk, this.getSelectors());
                    entrys = info.getEntry();
                    if (entrys != null && !entrys.isEmpty()) {
                        IBgFormFacade ibgFormFacade = BgFormFacadeFactory.getLocalInstance(ctx);
                        if (ibgFormFacade == null) {
                            throw new BgException(BgException.NOINSTANCE);
                        }
                        Iterator iter = entrys.iterator();
                        while (iter.hasNext()) {
                            entry = (BgAdjustBillEntryInfo)iter.next();
                            bgFormId2 = entry.getBgForm().getId();
                            formulaString = entry.getFormula();
                            divData = new BgAdjustFormDiversityData();
                            divData.setFormula(formulaString);
                            divData.setOldValue(entry.getAdjustBefore());
                            divData.setNewValue(entry.getAdjustAfter());
                            divData.setAdjustor(info.getCreator().getId().toString());
                            divData.setAdjustTime(new Timestamp(System.currentTimeMillis()));
                            divData.setAdjustReson(entry.getAdjustCause());
                            if (useBgForm.containsKey(bgFormId2)) {
                                divDataMap = (HashMap)useBgForm.get(bgFormId2);
                            } else {
                                divDataMap = new HashMap();
                                useBgForm.put(bgFormId2, divDataMap);
                            }
                            if (divDataMap.containsKey(formulaString)) continue;
                            divDataMap.put(formulaString, divData);
                        }
                        for (BOSUuid bgFormId2 : useBgForm.keySet()) {
                            divDataMap = (HashMap)useBgForm.get(bgFormId2);
                            if (divDataMap == null || divDataMap.isEmpty()) continue;
                            ibgFormFacade.auditFormBill(bgFormId2, divDataMap, null, BgPastSourceEnum.ADJUSTBILL);
                        }
                    }
                    this._auditApproved(ctx, id);
                    this.clearTmpData(ctx, (IObjectValue)info);
                    this.updateBgcalcOrg(ctx, info.getOrgUnit().getId().toString());
                    boolean isReCalculateAfterBillAudit = BgNSHelper.isReCalculateAfterBillAudit((Context)ctx);
                    if (isReCalculateAfterBillAudit) {
                        IBgCalculateSchemeFacade iBgCalcFacade = BgCalculateSchemeFacadeFactory.getLocalInstance((Context)ctx);
                        iBgCalcFacade.reCalculateAfterBillAudit((Object)info);
                    }
                    break block14;
                }
                throw new BgException(BgException.NOOBJECT, new String[]{""});
            }
            catch (BOSException ex) {
                throw ex;
            }
            catch (EASBizException ex) {
                throw ex;
            }
        }
        return true;
    }

    private void updateBgcalcOrg(Context ctx, String orgUnitId) throws EASBizException {
        if (ctx == null || orgUnitId == null) {
            return;
        }
        String id = BOSUuid.create((String)"12345678").toString();
        int state = 0;
        Timestamp time = new Timestamp(System.currentTimeMillis());
        StringBuffer insertsql = new StringBuffer("insert into T_BG_BgCalculateOrgUnit(FID,FOrgUnitId,FState,FCreateTime,FLastUpdateTime) values (?,?,?,?,?)");
        PreparedStatement pstmt = null;
        Connection conn = null;
        Object rst = null;
        boolean isAdjust = false;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(insertsql.toString());
            pstmt.setString(1, id);
            pstmt.setString(2, orgUnitId.toString());
            pstmt.setInt(3, state);
            pstmt.setTimestamp(4, time);
            pstmt.setTimestamp(5, time);
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BgException(BgException.DATABASEERROR, new String[]{e.getMessage()});
        }
        catch (SQLDataException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected void _auditAdjust(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IBgAdjustBill iAdjustBill = BgAdjustBillFactory.getLocalInstance(ctx);
        if (!iAdjustBill.exists((IObjectPK)pk)) {
            throw new BgAdjustException(BgAdjustException.NOMODEL);
        }
        BgAdjustBillInfo adjustBillInfo = iAdjustBill.getBgAdjustBillInfo((IObjectPK)pk, this.getStateSelectors());
        adjustBillInfo.setState(BgAdjustStateEnum.ADJUST);
        adjustBillInfo.setBizDate(new Date());
        adjustBillInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        super._updatePartial(ctx, (IObjectValue)adjustBillInfo, this.getStateSelectors());
    }

    @Override
    protected void _auditRefferring(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IBgAdjustBill iAdjustBill = BgAdjustBillFactory.getLocalInstance(ctx);
        if (!iAdjustBill.exists((IObjectPK)pk)) {
            throw new BgAdjustException(BgAdjustException.NOMODEL);
        }
        BgAdjustBillInfo adjustBillInfo = iAdjustBill.getBgAdjustBillInfo((IObjectPK)pk, this.getStateSelectors());
        adjustBillInfo.setState(BgAdjustStateEnum.REFERRING);
        super._updatePartial(ctx, (IObjectValue)adjustBillInfo, this.getStateSelectors());
    }

    @Override
    protected void _auditApproved(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IBgAdjustBill iAdjustBill = BgAdjustBillFactory.getLocalInstance(ctx);
        if (!iAdjustBill.exists((IObjectPK)pk)) {
            throw new BgAdjustException(BgAdjustException.NOMODEL);
        }
        BgAdjustBillInfo adjustBillInfo = iAdjustBill.getBgAdjustBillInfo((IObjectPK)pk, this.getStateSelectors());
        adjustBillInfo.setState(BgAdjustStateEnum.APPROVED);
        adjustBillInfo.setBizDate(new Date());
        adjustBillInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        super._updatePartial(ctx, (IObjectValue)adjustBillInfo, this.getStateSelectors());
    }

    @Override
    protected void _auditApproving(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IBgAdjustBill iAdjustBill = BgAdjustBillFactory.getLocalInstance(ctx);
        if (!iAdjustBill.exists((IObjectPK)pk)) {
            throw new BgAdjustException(BgAdjustException.NOMODEL);
        }
        BgAdjustBillInfo adjustBillInfo = iAdjustBill.getBgAdjustBillInfo((IObjectPK)pk, this.getStateSelectors());
        adjustBillInfo.setState(BgAdjustStateEnum.APPROVING);
        adjustBillInfo.setBizDate(new Date());
        adjustBillInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        super._updatePartial(ctx, (IObjectValue)adjustBillInfo, this.getStateSelectors());
    }

    @Override
    protected boolean _applyValue(Context ctx, BOSUuid orgUnitId, BOSUuid bgSchemeId, Map applyInfo) throws BOSException, EASBizException {
        boolean re = false;
        Map budgetMap = null;
        try {
            budgetMap = this.checkApplyValue(ctx, orgUnitId, bgSchemeId, applyInfo);
            re = this.applyNewAdjustBill(ctx, orgUnitId, bgSchemeId, budgetMap);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return re;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map checkApplyValue(Context ctx, BOSUuid orgUnitId, BOSUuid bgSchemeId, Map applyInfo) throws BOSException, EASBizException {
        if (orgUnitId == null) throw new BgAdjustException(BgAdjustException.APPLYVALUEPARAMETERERROR);
        if (bgSchemeId == null) throw new BgAdjustException(BgAdjustException.APPLYVALUEPARAMETERERROR);
        if (applyInfo == null) throw new BgAdjustException(BgAdjustException.APPLYVALUEPARAMETERERROR);
        if (applyInfo.isEmpty()) {
            throw new BgAdjustException(BgAdjustException.APPLYVALUEPARAMETERERROR);
        }
        HashMap<String, BgAdjustBillEntryInfo> budgetMap = new HashMap<String, BgAdjustBillEntryInfo>();
        ArrayList<String> formulas = new ArrayList<String>();
        String orgUnitName = null;
        String bgSchemeName = null;
        String noFindStr = "#";
        String formulaString2222 = null;
        BgAdjustBillEntryInfo entry = null;
        FullOrgUnitInfo orgUnitInfo = null;
        BgSchemeInfo bgSchemeInfo = null;
        BgFormInfo bgFormInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 50;
        int size = applyInfo.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        for (String formulaString2222 : applyInfo.keySet()) {
            formulas.add(formulaString2222);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FBGVALUE, t.FBGFORMID, t,FFORMULA, u.FNAME_" + ctx.getLocale() + ", s.FNAME_" + ctx.getLocale() + " from T_BG_BgData t left outer join T_ORG_BaseUnit u on u.FID = t.FORGUNITID left outer join T_BG_BgScheme s on s.FID = t.FBGSCHEMEIDwhere (t.FORGUNITID = '" + orgUnitId + "') and (t.FBGSCHEMEID = '" + bgSchemeId + "') and (t.FFORMULA in (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?, ");
        }
        sql.append("?))");
        orgUnitInfo = new FullOrgUnitInfo();
        orgUnitInfo.setId(orgUnitId);
        bgSchemeInfo = new BgSchemeInfo();
        bgSchemeInfo.setId(bgSchemeId);
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int k = 1; k <= batchNum; ++k, ++pos) {
                    if (pos < size) {
                        pstmt.setString(k, (String)formulas.get(pos));
                        continue;
                    }
                    pstmt.setString(k, noFindStr);
                }
                rst = pstmt.executeQuery();
                if (rst.next() && applyInfo.containsKey(formulaString2222)) {
                    orgUnitName = rst.getString(4);
                    bgSchemeName = rst.getString(5);
                    entry = new BgAdjustBillEntryInfo();
                    entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
                    entry.setAdjustGroup(0);
                    entry.setAdjustBefore(rst.getBigDecimal(1));
                    entry.setAdjustApply((BigDecimal)applyInfo.get(formulaString2222));
                    entry.setAdjustPass(entry.getAdjustApply());
                    entry.setAdjustAfter(entry.getAdjustBefore().add(entry.getAdjustPass()));
                    entry.setAdjustType(BgAdjustTypeEnum.VALUEADD);
                    entry.setOrgUnit(orgUnitInfo);
                    entry.setBgScheme(bgSchemeInfo);
                    bgFormInfo = new BgFormInfo();
                    bgFormInfo.setId(BOSUuid.read((String)rst.getString(2)));
                    entry.setBgForm(bgFormInfo);
                    entry.setFormula(rst.getString(3));
                    budgetMap.put(formulaString2222, entry);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            if (applyInfo.size() != budgetMap.size()) {
                for (String formulaString2222 : applyInfo.keySet()) {
                    if (budgetMap.containsKey(formulaString2222)) continue;
                    throw new BgAdjustException(BgAdjustException.APPLYVALUENOFIND, new String[]{orgUnitName, bgSchemeName, formulaString2222});
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (EASBizException ex3) {
                    throw ex3;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return budgetMap;
    }

    private boolean applyNewAdjustBill(Context ctx, BOSUuid orgUnitId, BOSUuid bgSchemeId, Map budgetMap) throws BOSException, EASBizException {
        FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
        orgUnitInfo.setId(orgUnitId);
        BgSchemeInfo bgSchemeInfo = new BgSchemeInfo();
        bgSchemeInfo.setId(bgSchemeId);
        String formulaString2 = null;
        String[] parameter = null;
        HashMap formulaMap = new HashMap();
        HashMap getItemsMap = new HashMap();
        HashMap<String, VisualItemInfo> visItemsMap = new HashMap<String, VisualItemInfo>();
        HashMap getPeriodMap = new HashMap();
        Map bgPeriodMap = null;
        HashMap getElemetMap = new HashMap();
        Map bgElementMap = null;
        HashMap getCurrencyMap = new HashMap();
        Map currencyMap = null;
        BgAdjustBillInfo billInfo = new BgAdjustBillInfo();
        billInfo.setId(BOSUuid.create((BOSObjectType)billInfo.getBOSType()));
        billInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        billInfo.setOrgUnit(orgUnitInfo);
        billInfo.setState(BgAdjustStateEnum.ADJUST);
        billInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        billInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        BgAdjustBillEntryInfo entry = null;
        for (String formulaString2 : budgetMap.keySet()) {
            entry = (BgAdjustBillEntryInfo)budgetMap.get(formulaString2);
            parameter = BgSHelper.getFormulaInfo(formulaMap, formulaString2);
            if (parameter != null) {
                if (parameter[BgSHelper.paraItem] != null && !getItemsMap.containsKey(parameter[BgSHelper.paraItem])) {
                    getItemsMap.put(parameter[BgSHelper.paraItem], null);
                }
                if (parameter[BgSHelper.paraPeriod] != null && !getPeriodMap.containsKey(parameter[BgSHelper.paraPeriod])) {
                    getPeriodMap.put(parameter[BgSHelper.paraPeriod], null);
                }
                if (parameter[BgSHelper.paraElement] != null && !getElemetMap.containsKey(parameter[BgSHelper.paraElement])) {
                    getElemetMap.put(parameter[BgSHelper.paraElement], null);
                }
                if (parameter[BgSHelper.paraCurrency] != null && !getCurrencyMap.containsKey(parameter[BgSHelper.paraCurrency])) {
                    getCurrencyMap.put(parameter[BgSHelper.paraCurrency], null);
                }
            }
            billInfo.getEntry().add(entry);
        }
        VisualItemInfo visItemInfo = null;
        VisualItemCollection visCol = null;
        try {
            IBgFacade ibgFacade = BgFacadeFactory.getLocalInstance(ctx);
            if (ibgFacade == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            visCol = ibgFacade.getVisualItemCollection(getItemsMap, orgUnitId.toString());
            Iterator iter = visCol.iterator();
            while (iter.hasNext()) {
                visItemInfo = (VisualItemInfo)iter.next();
                if (visItemsMap.containsKey(visItemInfo.getNumber())) continue;
                visItemsMap.put(visItemInfo.getNumber(), visItemInfo);
            }
            bgPeriodMap = BgSHelper.getBgPeriodInfo(ctx, getPeriodMap, null, null);
            bgElementMap = BgSHelper.getBgElementInfo(ctx, getElemetMap, null, null);
            currencyMap = BgSHelper.getCurrencyInfo(ctx, getCurrencyMap, null);
            iter = billInfo.getEntry().iterator();
            while (iter.hasNext()) {
                entry = (BgAdjustBillEntryInfo)iter.next();
                parameter = BgSHelper.getFormulaInfo(formulaMap, formulaString2);
                if (parameter == null) continue;
                if (parameter[BgSHelper.paraItem] != null && visItemsMap.containsKey(parameter[BgSHelper.paraItem])) {
                    entry.setBgItemId(((VisualItemInfo)visItemsMap.get(parameter[BgSHelper.paraItem])).getId().toString());
                }
                if (parameter[BgSHelper.paraPeriod] != null && bgPeriodMap.containsKey(parameter[BgSHelper.paraPeriod])) {
                    entry.setBgPeriod((BgPeriodInfo)bgPeriodMap.get(parameter[BgSHelper.paraPeriod]));
                }
                if (parameter[BgSHelper.paraElement] != null && bgElementMap.containsKey(parameter[BgSHelper.paraElement])) {
                    entry.setBgElement((BgElementInfo)bgElementMap.get(parameter[BgSHelper.paraElement]));
                }
                if (parameter[BgSHelper.paraCurrency] == null || !currencyMap.containsKey(parameter[BgSHelper.paraCurrency])) continue;
                entry.setCurrency((CurrencyInfo)currencyMap.get(parameter[BgSHelper.paraCurrency]));
            }
            this._addnew(ctx, (IObjectValue)billInfo);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return true;
    }

    @Override
    protected boolean _submitFPRefer(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        return this._submitRefer(ctx, id);
    }

    @Override
    protected BOSUuid[] _getBgFormIds(Context ctx, BOSUuid[] bgAdjustBillIds) throws BOSException, EASBizException {
        if (bgAdjustBillIds == null || bgAdjustBillIds.length == 0) {
            return null;
        }
        int index = 0;
        BOSUuid billId2 = null;
        BOSUuid[] bgFormIds = null;
        ObjectUuidPK pk = null;
        HashSet<BOSUuid> bgFormSet = new HashSet<BOSUuid>();
        BgAdjustBillInfo billInfo = null;
        BgAdjustBillEntryInfo entry = null;
        BgAdjustBillEntryCollection entrys = null;
        try {
            for (BOSUuid billId2 : bgAdjustBillIds) {
                if (billId2 == null || !this._exists(ctx, (IObjectPK)(pk = new ObjectUuidPK(billId2)))) continue;
                billInfo = (BgAdjustBillInfo)this._getValue(ctx, (IObjectPK)pk);
                entrys = billInfo.getEntry();
                Iterator iter = entrys.iterator();
                while (iter.hasNext()) {
                    entry = (BgAdjustBillEntryInfo)iter.next();
                    bgFormSet.add(entry.getBgForm().getId());
                }
            }
            bgFormIds = new BOSUuid[bgFormSet.size()];
            for (BOSUuid billId2 : bgFormSet) {
                bgFormIds[index++] = billId2;
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return bgFormIds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean _submitCheck(Context ctx, BOSUuid bgAdjustBillId) throws BOSException, EASBizException {
        BOSUuid[] bgFormIds;
        String X;
        IBgExamineFacade iExamine;
        boolean re;
        block10: {
            if (bgAdjustBillId == null) {
                return false;
            }
            re = false;
            IBgForm ibgForm = null;
            iExamine = null;
            X = null;
            ibgForm = BgFormFactory.getLocalInstance(ctx);
            if (ibgForm == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            List check = null;
            BOSUuid[] billIds = null;
            bgFormIds = null;
            billIds = new BOSUuid[]{bgAdjustBillId};
            check = ibgForm.reportCheck(billIds, BgAdjustBillInfo.class.getName());
            if (!Boolean.TRUE.equals(check.get(0))) return true;
            bgFormIds = this._getBgFormIds(ctx, billIds);
            iExamine = BgExamineFacadeFactory.getLocalInstance(ctx);
            if (iExamine == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            if (!iExamine.canExamine(bgFormIds) || !iExamine.examineHadX(bgFormIds)) break block10;
            BgAdjustBillCollection col = null;
            col = BgAdjustBillFactory.getLocalInstance(ctx).getBgAdjustBillCollection("where id = '" + bgAdjustBillId.toString() + "'");
            if (col.size() > 0) {
                X = col.get(0).getExamineX();
            }
            if (X != null) break block10;
            return false;
        }
        try {
            Object[] obj = iExamine.examines(bgFormIds, X);
            if (obj[0] == null) return re;
            if (!(obj[0] instanceof Boolean)) return re;
            Boolean bgExCheck = (Boolean)obj[0];
            if (bgExCheck == false) return re;
            return true;
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
    }

    @Override
    protected boolean _checkAdjustData(Context ctx, String schemeStr, String orgUnitStr, String itemStr, String periodStr, String elementStr, String currencyStr, String applyDataStr) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        boolean isValid;
        block13: {
            int i;
            isValid = true;
            String yearFormula = null;
            String[] monthPeriodStr = new String[12];
            String[] tempFormula = new String[12];
            String[] orgunits = new String[12];
            String[] schemes = new String[12];
            String[] formulas = new String[12];
            for (int i2 = 0; i2 < 12; ++i2) {
                tempFormula[i2] = new String();
            }
            String yearPeriodStr = periodStr.substring(0, 5);
            monthPeriodStr[0] = yearPeriodStr + ".01M";
            monthPeriodStr[1] = yearPeriodStr + ".02M";
            monthPeriodStr[2] = yearPeriodStr + ".03M";
            monthPeriodStr[3] = yearPeriodStr + ".04M";
            monthPeriodStr[4] = yearPeriodStr + ".05M";
            monthPeriodStr[5] = yearPeriodStr + ".06M";
            monthPeriodStr[6] = yearPeriodStr + ".07M";
            monthPeriodStr[7] = yearPeriodStr + ".08M";
            monthPeriodStr[8] = yearPeriodStr + ".09M";
            monthPeriodStr[9] = yearPeriodStr + ".10M";
            monthPeriodStr[10] = yearPeriodStr + ".11M";
            monthPeriodStr[11] = yearPeriodStr + ".12M";
            for (i = 0; i < 12; ++i) {
                tempFormula[i] = "=BgItem(\"" + itemStr + "\",\"" + monthPeriodStr[i] + "\",\"" + elementStr + "\",\"BgData\",true,\"" + currencyStr + "\")";
            }
            yearFormula = "=BgItem(\"" + itemStr + "\",\"" + yearPeriodStr + "\",\"" + elementStr + "\",\"BgData\",true,\"" + currencyStr + "\")";
            for (i = 0; i < 12; ++i) {
                orgunits[i] = orgUnitStr;
                schemes[i] = schemeStr;
                formulas[i] = tempFormula[i];
            }
            StringBuffer yearSql = new StringBuffer();
            yearSql.append("select fbgvalue from t_bg_bgdata where fformula =? and forgunitid=?");
            conn = null;
            pstmt = null;
            rs = null;
            Vector<BigDecimal> data = new Vector<BigDecimal>();
            Vector<BigDecimal> yearData = new Vector<BigDecimal>();
            BigDecimal value = null;
            BigDecimal tempValue = null;
            BigDecimal yearValue = null;
            value = BgNConstants.ZERO;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement("select fbgvalue from t_bg_bgdata where forgunitid= ? and fbgschemeid = ? and fformula=?");
                for (int i3 = 0; i3 < 12; ++i3) {
                    pstmt.setString(1, orgunits[i3]);
                    pstmt.setString(2, orgunits[i3]);
                    pstmt.setString(3, orgunits[i3]);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        data.add(rs.getBigDecimal("fbgvalue"));
                    }
                    tempValue = new BigDecimal(data.get(i3).toString());
                    value = value.add(tempValue);
                }
                SQLUtils.cleanup(rs, (Statement)pstmt);
                pstmt = conn.prepareStatement(yearSql.toString());
                pstmt.setString(1, yearFormula);
                pstmt.setString(2, orgUnitStr);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    yearData.add(rs.getBigDecimal("fbgvalue"));
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                if (yearData.size() <= 0) break block13;
                yearValue = new BigDecimal(yearData.get(0).toString());
                if ((float)value.subtract(yearValue).longValue() > 0.0f) {
                    isValid = false;
                } else if ((float)value.subtract(yearValue).longValue() <= 0.0f) {
                    isValid = true;
                }
            }
            catch (Exception ex) {
                try {
                    logger.error((Object)"budget error:", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return isValid;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _deleteTmpData(Context ctx, BOSUuid bgFormId, String formula) throws BOSException, EASBizException {
        if (bgFormId == null) return;
        if (formula == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("delete from T_BG_BgTmpData where FBgFormId = ? and FFormula = ?");
            pstmt.setString(1, bgFormId.toString());
            pstmt.setString(2, formula);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _inputExanimeX(Context ctx, String billID, String inputX) throws BOSException, EASBizException {
        if (billID == null) return;
        if (inputX == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgAdjustBill set FExamineX = ? where fid  = ? ");
            pstmt.setString(1, inputX);
            pstmt.setString(2, billID);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected String _adjustCheck(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            throw new BgException(BgException.NOOBJECT, new String[]{""});
        }
        boolean needAdjustCheck = BgSHelper.isAdjustCheckRequired(ctx);
        if (!needAdjustCheck) {
            return "pass";
        }
        ObjectUuidPK pk = null;
        BgAdjustBillInfo info = null;
        BgCollectFormFactory.getLocalInstance(ctx);
        String SOURCE_STR = "com.kingdee.eas.ma.budget.BgAdjustCheckResource";
        String org = ResourceBase.getString((String)SOURCE_STR, (String)"org", (Locale)ContextUtils.getLocaleFromEnv());
        String bgForm = ResourceBase.getString((String)SOURCE_STR, (String)"bgform", (Locale)ContextUtils.getLocaleFromEnv());
        String itemNumber = ResourceBase.getString((String)SOURCE_STR, (String)"itemnumber", (Locale)ContextUtils.getLocaleFromEnv());
        String element = ResourceBase.getString((String)SOURCE_STR, (String)"element", (Locale)ContextUtils.getLocaleFromEnv());
        String currency = ResourceBase.getString((String)SOURCE_STR, (String)"currency", (Locale)ContextUtils.getLocaleFromEnv());
        String period = ResourceBase.getString((String)SOURCE_STR, (String)"period", (Locale)ContextUtils.getLocaleFromEnv());
        String balance = ResourceBase.getString((String)SOURCE_STR, (String)"balance", (Locale)ContextUtils.getLocaleFromEnv());
        StringBuffer error = null;
        try {
            List list;
            pk = new ObjectUuidPK(billId);
            if (this._exists(ctx, (IObjectPK)pk)) {
                info = (BgAdjustBillInfo)this._getValue(ctx, (IObjectPK)pk, this.getSelectors());
                list = BgCollectFormFactory.getLocalInstance(ctx).getAllNegativeAdjustCheckData(this.getAdjustMap(info));
                if (list != null && list.size() > 0) {
                    error = new StringBuffer("\r\n " + org + " | " + bgForm + " | " + itemNumber + " | " + element + " | " + currency + " | " + period + " | " + balance + " \r\n");
                    int size = list.size();
                    for (int i = 0; i < size; ++i) {
                        BgFormAdjustData data = (BgFormAdjustData)list.get(i);
                        error.append(data.getOrgName() + " | ").append(data.getBgFormName() + " | ").append(data.getItemNumber() + " | ").append(data.getElement() + " | ").append(data.getCurrency() + " | ").append(data.getPeriod() + " | ");
                        if (data.getBadFunction().trim().length() > 0) {
                            error.append(data.getBadFunction() + "\r\n");
                            continue;
                        }
                        error.append(data.getAdjustBalance() + "\r\n");
                    }
                }
            } else {
                throw new BgException(BgException.NOOBJECT, new String[]{""});
            }
            list.clear();
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return error == null ? "pass" : error.toString();
    }

    private Map getAdjustMap(BgAdjustBillInfo info) {
        HashMap<BOSUuid, Map<String, BgFormDiversityData>> adjustMap = new HashMap<BOSUuid, Map<String, BgFormDiversityData>>();
        if (info == null) {
            return adjustMap;
        }
        BgAdjustBillEntryCollection col = info.getEntry();
        if (col == null) {
            return adjustMap;
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            BigDecimal newValue;
            BigDecimal oldValue;
            BgFormDiversityData data;
            Map<String, BgFormDiversityData> dataMap;
            BgAdjustBillEntryInfo entry = col.get(i);
            if (adjustMap.containsKey(entry.getBgForm().getId())) {
                dataMap = (Map)adjustMap.get(entry.getBgForm().getId());
                if (dataMap == null) {
                    dataMap = new HashMap();
                }
                data = new BgFormDiversityData();
                oldValue = entry.getAdjustBefore();
                newValue = entry.getAdjustAfter();
                data.setFormula(entry.getFormula());
                data.setNewValue(newValue);
                data.setOldValue(oldValue);
                dataMap.put(entry.getFormula(), data);
                continue;
            }
            dataMap = new HashMap();
            data = new BgFormDiversityData();
            oldValue = entry.getAdjustBefore();
            newValue = entry.getAdjustAfter();
            data.setFormula(entry.getFormula());
            data.setNewValue(newValue);
            data.setOldValue(oldValue);
            dataMap.put(entry.getFormula(), data);
            adjustMap.put(entry.getBgForm().getId(), dataMap);
        }
        return adjustMap;
    }

    @Override
    protected Map _getRPCDataMap(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (params.get("useItemsId") instanceof Hashtable) {
            Hashtable useItemsId = (Hashtable)params.get("useItemsId");
            String orgUnitId = (String)params.get("orgUnitId");
            VisualItemCollection visItemCol = BgFacadeFactory.getLocalInstance(ctx).getVisualItemCollection(useItemsId, orgUnitId);
            resultMap.put("visItemCol", (Object)visItemCol);
        }
        Map paramValue = BgNSHelper.getAllParamValue((Context)ctx);
        resultMap.put("paramValue", paramValue);
        if (params.get("bgAdjustBillId") instanceof String) {
            boolean inProInst = false;
            ProcessInstInfo[] procInsts = EnactmentServiceFactory.createEnactService((Context)ctx).getProcessInstanceByHoldedObjectId(params.get("bgAdjustBillId").toString());
            for (int i = 0; i < procInsts.length; ++i) {
                if (!procInsts[i].getState().startsWith("open")) continue;
                inProInst = true;
                break;
            }
            resultMap.put("inProInst", inProInst);
        }
        if (params.get("billInfo") instanceof BgAdjustBillInfo && params.get("orgId") instanceof String) {
            BgAdjustBillInfo billInfo = (BgAdjustBillInfo)params.get("billInfo");
            String cuid = params.get("orgId").toString();
            boolean hasCodeRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist((IObjectValue)billInfo, cuid);
            resultMap.put("hasCodeRule", hasCodeRule);
        }
        return resultMap;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgAdjustBillInfo bgAdjustInfo = (BgAdjustBillInfo)super._getValue(ctx, pk, this.getSelector());
        return bgAdjustInfo.getNumber();
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("number");
        return selector;
    }

    @Override
    protected void _checkNumber(Context ctx, BgAdjustBillInfo info) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String sql = "select FID from T_BG_BgAdjustBill where FNumber = ? and FOrgUnitID = ?";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, info.getNumber());
            pstmt.setString(2, info.getOrgUnit().getId().toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                throw new BOSException();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }
}

