/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.budget.AbstractBgPeriodInfo;
import com.kingdee.eas.ma.budget.AbstractVisualItemInfo;
import com.kingdee.eas.ma.budget.BgAnalyseContInfo;
import com.kingdee.eas.ma.budget.BgAnalyseContrastFilterParam;
import com.kingdee.eas.ma.budget.BgAnalyseDiffFilterParam;
import com.kingdee.eas.ma.budget.BgAnalyseFacadeFactory;
import com.kingdee.eas.ma.budget.BgAnalyseFilterParam;
import com.kingdee.eas.ma.budget.BgAnalyseFormQueryParam;
import com.kingdee.eas.ma.budget.BgAnalyseInfo;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFillHelper;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemAnalyseInfo;
import com.kingdee.eas.ma.budget.BgItemAnalyseParam;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgItemReqUseAnalyseInfo;
import com.kingdee.eas.ma.budget.BgMeasureUnitCollection;
import com.kingdee.eas.ma.budget.BgMeasureUnitFactory;
import com.kingdee.eas.ma.budget.BgMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgPermissionFactory;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgMeasureUnit;
import com.kingdee.eas.ma.budget.IBgPermission;
import com.kingdee.eas.ma.budget.PrintConfigInfo;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.app.AbstractBgAnalyseFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgComparator;
import com.kingdee.eas.ma.nbudget.BgExecuteAnalyseBillInfo;
import com.kingdee.eas.ma.nbudget.BgExecuteAnalyseInfo;
import com.kingdee.eas.ma.nbudget.BgExecuteFilterParam;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.BgSpecialAnalysisFilterParam;
import com.kingdee.eas.ma.nbudget.BgSpecialData;
import com.kingdee.eas.ma.nbudget.app.formula.BgCalculatorFactory;
import com.kingdee.eas.ma.nbudget.app.formula.BgCalculatorProcess;
import com.kingdee.eas.ma.nbudget.app.formula.IProcess;
import com.kingdee.eas.ma.view.util.BgViewCommonHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sm.pur.PurContractFactory;
import com.kingdee.eas.scm.sm.pur.PurContractInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgAnalyseFacadeControllerBean
extends AbstractBgAnalyseFacadeControllerBean {
    private static final long serialVersionUID = 7650251146258712287L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgAnalyseFacadeControllerBean");

    @Override
    protected IObjectCollection _getCommonBgScheme(Context ctx, BOSUuid currOrgUnitId, Set orgUnitIds, boolean hasUseFund, boolean isFund, boolean isFiling) throws BOSException, EASBizException {
        if (currOrgUnitId == null) {
            return new BgSchemeCollection();
        }
        BgSchemeCollection bgSchemeCol = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            bgSchemeCol = this.getBgSchemeByOrgUnit(ctx, conn, currOrgUnitId, hasUseFund, isFund, isFiling);
            if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
                bgSchemeCol = this.filterBgSchemeByOrgUnit(ctx, conn, bgSchemeCol, orgUnitIds, hasUseFund, isFund);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return bgSchemeCol;
    }

    @Override
    protected IObjectCollection _getCommonBgScheme(Context ctx, BOSUuid currOrgUnitId, Set orgUnitIds, boolean isFiling) throws BOSException, EASBizException {
        if (currOrgUnitId == null) {
            return new BgSchemeCollection();
        }
        BgSchemeCollection bgSchemeCol = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            bgSchemeCol = this.getBgSchemeByOrgUnit(ctx, conn, currOrgUnitId, false, false, isFiling);
            if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
                bgSchemeCol = this.filterBgSchemeByOrgUnit(ctx, conn, bgSchemeCol, orgUnitIds, false, false);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return bgSchemeCol;
    }

    private BgSchemeCollection getBgSchemeByOrgUnit(Context ctx, Connection conn, BOSUuid orgUnitId, boolean hasUseFund, boolean isFund, boolean isFiling) throws BOSException, EASBizException {
        BgSchemeCollection bgSchemeCol = new BgSchemeCollection();
        if (ctx == null || conn == null || orgUnitId == null) {
            return bgSchemeCol;
        }
        BgSchemeInfo bgSchemeInfo = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        if (isFiling) {
            sql.append("select FID, FName_" + ctx.getLocale() + ", FNumber, FIsFormal, FRootID , FPeriod, FDateFrom, FDateTo, FIsFiling from T_BG_BgScheme where FOrgUnitID = ? ");
        } else {
            sql.append("select FID, FName_" + ctx.getLocale() + ", FNumber, FIsFormal, FRootID , FPeriod, FDateFrom, FDateTo, FIsFiling from T_BG_BgScheme where FOrgUnitID = ? and fisfiling=0");
        }
        ArrayList<String> _tmpList = new ArrayList<String>();
        _tmpList.add(orgUnitId.toString());
        if (BgSHelper.isBgPermissionUsed(ctx)) {
            HashSet<String> orgSet = new HashSet<String>();
            orgSet.add(orgUnitId.toString());
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            HashSet<String> schPer = BgPermissionFactory.getLocalInstance(ctx).getBgSchemePermission(userId, orgSet);
            if (schPer == null || schPer.isEmpty()) {
                schPer = new HashSet<String>();
                schPer.add("111");
            }
            sql.append(" and (fid in (" + BgNSQLHelper.getParamSizeString(schPer) + ")");
            sql.append(" or fcreatorid = ?)");
            _tmpList.addAll(schPer);
            _tmpList.add(userId);
        }
        sql.append(" order by FNumber");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgSchemeInfo = new BgSchemeInfo();
                bgSchemeInfo.setId(BOSUuid.read((String)rst.getString(1)));
                bgSchemeInfo.setName(rst.getString(2));
                bgSchemeInfo.setNumber(rst.getString(3));
                bgSchemeInfo.setIsFormal(rst.getBoolean(4));
                bgSchemeInfo.setRootId(BOSUuid.read((String)rst.getString(5)));
                bgSchemeInfo.setPeriod(BgPeriodEnum.getEnum(rst.getInt(6)));
                bgSchemeInfo.setDateFrom(rst.getDate("FDateFrom"));
                bgSchemeInfo.setDateTo(rst.getDate("FDateTo"));
                bgSchemeInfo.setIsFiling(rst.getBoolean("FIsFiling"));
                bgSchemeCol.add(bgSchemeInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"getBgSchemeByOrgUnit: ", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgSchemeCol;
    }

    private BgSchemeCollection filterBgSchemeByOrgUnit(Context ctx, Connection conn, BgSchemeCollection bgSchemeCol, Set subOrgUnits, boolean hasUseFund, boolean isFund) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeCol == null || subOrgUnits == null || subOrgUnits.isEmpty()) {
            return bgSchemeCol;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgSchemeInfo bgSchemeInfo = null;
        BgSchemeCollection commBgSchemeCol = new BgSchemeCollection();
        Iterator iter = null;
        Iterator orgs = null;
        String orgUnitIdStr = null;
        BOSUuid orgUnitId2 = null;
        boolean isCommon = false;
        HashSet<String> hasOrgUnitSet = new HashSet<String>();
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FOrgUnitID from T_BG_BgScheme where (FRootId = ?) and (FOrgUnitID in (");
        HashSet<String> orgUntis = new HashSet<String>();
        iter = subOrgUnits.iterator();
        while (iter.hasNext()) {
            String num1 = iter.next().toString();
            sql.append("?,");
            orgUntis.add(num1);
            _tmpList.add(num1);
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append("))");
        if (BgSHelper.isBgPermissionUsed(ctx)) {
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            HashSet<String> schPer = BgPermissionFactory.getLocalInstance(ctx).getBgSchemePermission(userId, orgUntis);
            if (schPer == null || schPer.isEmpty()) {
                schPer = new HashSet<String>();
                schPer.add("111");
            }
            sql.append(" and (fid in (" + BgNSQLHelper.getParamSizeString(schPer) + ")");
            sql.append(" or fcreatorid = ?)");
            _tmpList.addAll(schPer);
            _tmpList.add(userId);
        }
        sql.append(" order by fnumber");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            iter = bgSchemeCol.iterator();
            while (iter.hasNext()) {
                bgSchemeInfo = (BgSchemeInfo)iter.next();
                pstmt.setString(1, bgSchemeInfo.getRootId().toString());
                BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList, (int)2);
                rst = pstmt.executeQuery();
                hasOrgUnitSet.clear();
                while (rst.next()) {
                    orgUnitIdStr = rst.getString(2);
                    hasOrgUnitSet.add(orgUnitIdStr);
                }
                SQLUtils.cleanup((ResultSet)rst);
                for (BOSUuid orgUnitId2 : subOrgUnits) {
                    if (hasOrgUnitSet.contains(orgUnitId2.toString())) {
                        isCommon = true;
                        continue;
                    }
                    isCommon = false;
                    break;
                }
                if (!isCommon) continue;
                commBgSchemeCol.add(bgSchemeInfo);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"filterBgSchemeByOrgUnit \uff1a", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return commBgSchemeCol;
    }

    @Override
    protected IObjectCollection _getCommonBgForm(Context ctx, BOSUuid bgSchemeId, Set orgUnitIds, boolean hasUseFund, boolean isFund, boolean isFiling) throws BOSException, EASBizException {
        if (bgSchemeId == null) {
            return new BgFormCollection();
        }
        BgFormCollection bgFormCol = null;
        try {
            bgFormCol = this.getBgFormByBgScheme(ctx, bgSchemeId, hasUseFund, isFund, orgUnitIds);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return bgFormCol;
    }

    private BgFormCollection getBgFormByBgScheme(Context ctx, BOSUuid bgSchemeId, boolean hasUseFund, boolean isFund, Set orgUnitIds) throws BOSException, EASBizException {
        BgFormCollection bgFormCol = new BgFormCollection();
        if (ctx == null || bgSchemeId == null) {
            return bgFormCol;
        }
        BgFormInfo bgFormInfo = null;
        ArrayList<Object> _tmpList = new ArrayList<Object>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select f.FID, f.FName, f.FNumber, f.FCurrencyID,f.FBgItemGroupId,f.FBgItemID, bgTemplate.FID bgTemplate_FID, bgTemplate.FFormType bgTemplate_FFormType from T_BG_BgForm f left outer join T_BG_BgPeriod p on f.FBgPeriodId = p.FID left join T_Bg_BgTemplate bgTemplate on bgTemplate.FID = f.FBgTemplateId  where f.FBgSchemeID = ?");
        _tmpList.add(bgSchemeId.toString());
        sql.append(" and (FState <> ? and FState <> ? and FState <> ?)");
        _tmpList.add(new Integer(4));
        _tmpList.add(new Integer(15));
        _tmpList.add(new Integer(5));
        if (BgSHelper.isBgPermissionUsed(ctx)) {
            Set temType;
            HashSet<String> temPer;
            HashSet<String> orgUntis = new HashSet<String>();
            Iterator iter = orgUnitIds.iterator();
            while (iter.hasNext()) {
                String num1 = iter.next().toString();
                orgUntis.add(num1);
            }
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            IBgPermission iBgPer = BgPermissionFactory.getLocalInstance(ctx);
            Set schPer = iBgPer.getBgSchemePermission(userId, orgUntis);
            sql.append(" and ((");
            if (schPer != null && !schPer.isEmpty()) {
                sql.append(" f.fbgschemeid in (" + BgNSQLHelper.getParamSizeString((Collection)schPer) + ")");
                _tmpList.addAll(schPer);
            }
            if ((temPer = iBgPer.getBgTemplatePermission(userId, orgUntis)) != null && !temPer.isEmpty()) {
                if (schPer != null && !schPer.isEmpty()) {
                    sql.append(" and f.fbgTemplateid in (" + BgNSQLHelper.getParamSizeString((Collection)temPer) + ")");
                } else {
                    sql.append(" f.fbgTemplateid in (" + BgNSQLHelper.getParamSizeString((Collection)temPer) + ")");
                }
                _tmpList.addAll(temPer);
            }
            if ((temType = iBgPer.getBgTemplateTypePermisson(userId, orgUntis)) != null && !temType.isEmpty()) {
                if (temPer != null && !temPer.isEmpty() || schPer != null && !schPer.isEmpty()) {
                    sql.append(" and f.fbgTypeid in (" + BgNSQLHelper.getParamSizeString((Collection)temType) + ")");
                } else {
                    sql.append(" f.fbgTypeid in (" + BgNSQLHelper.getParamSizeString((Collection)temType) + ")");
                }
                _tmpList.addAll(temType);
            }
            if (!(schPer != null && !schPer.isEmpty() || temPer != null && !temPer.isEmpty() || temType != null && !temType.isEmpty())) {
                temPer = new HashSet<String>();
                temPer.add("111");
                sql.append(" f.fbgTemplateid in (" + BgNSQLHelper.getParamSizeString(temPer) + ")");
                _tmpList.addAll(temPer);
            }
            sql.append(") or f.fcreatorid = ? )");
            _tmpList.add(userId);
        }
        sql.append(" and f.fbgtemplateid not in (select fid from t_bg_bgtemplate where FBgTypeID = ? or FFormType = ?)");
        sql.append(" order by f.FNumber");
        _tmpList.add("BV/FQwEUEADgABtLwKgSXv9s2OA=");
        _tmpList.add(new Integer(2));
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            BgItemGroupInfo info = null;
            BgItemInfo bgItemInfo = null;
            String groupId = null;
            String bgItemId = null;
            while (rst.next()) {
                bgFormInfo = new BgFormInfo();
                bgFormInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                groupId = rst.getString("FBgItemGroupId");
                if (groupId != null) {
                    info = new BgItemGroupInfo();
                    info.setId(BOSUuid.read((String)groupId));
                    bgFormInfo.setBgItemGroup(info);
                }
                if ((bgItemId = rst.getString("FBgItemID")) != null) {
                    bgItemInfo = new BgItemInfo();
                    bgItemInfo.setId(BOSUuid.read((String)bgItemId));
                    bgFormInfo.setBgItem(bgItemInfo);
                }
                bgFormInfo.setBgTemplate(new BgTemplateInfo());
                bgFormInfo.getBgTemplate().setId(BOSUuid.read((String)rst.getString("bgTemplate_FID")));
                bgFormInfo.getBgTemplate().setFormType(BgTemFormTypeEnum.getEnum(rst.getInt("bgTemplate_FFormType")));
                bgFormInfo.setNumber(rst.getString("FNumber"));
                bgFormInfo.setName(rst.getString("FName"));
                CurrencyInfo cuInfo = new CurrencyInfo();
                cuInfo.setId(BOSUuid.read((String)rst.getString("FCurrencyID")));
                bgFormInfo.setCurrency(cuInfo);
                bgFormCol.add(bgFormInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"getBgFormByBgScheme\uff1a", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgFormCol;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IObjectCollection getBgFormBySchemeAndTemplate(Context ctx, Map bgSchemeMap, BgTemplateInfo templateInfo) throws BOSException, EASBizException {
        if (ctx == null) return new BgFormCollection();
        if (bgSchemeMap == null) return new BgFormCollection();
        if (bgSchemeMap.isEmpty()) return new BgFormCollection();
        if (templateInfo == null) {
            return new BgFormCollection();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 50;
        int size = bgSchemeMap.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        Map.Entry _entry2222222 = null;
        ArrayList _orgUnitId = new ArrayList();
        ArrayList _schemeId = new ArrayList();
        for (Map.Entry _entry2222222 : bgSchemeMap.entrySet()) {
            _orgUnitId.add(_entry2222222.getKey());
            _schemeId.add(_entry2222222.getValue());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select f.FID, f.FOrgUnitId, f.FBgItemGroupId, f.FBgItemId, p.FNumber, p.FName_" + ctx.getLocale() + " as FName from T_BG_BgForm f left join T_BG_BgItemGroup p on f.FBgItemGroupId = p.fid Where (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("(f.FOrgUnitId = ? and f.FBgSchemeId = ?) or ");
        }
        sql.append("(f.FOrgUnitId = ? and f.FBgSchemeId = ?)) ");
        sql.append(" and f.FBgTemplateId IN (Select FID from T_BG_BgTemplate where FRootId = ?) and f.FBgItemGroupId is not null");
        BgFormInfo formInfo = null;
        BgFormCollection _bgForms = new BgFormCollection();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int k = 1; k <= batchNum * 2; k += 2, ++pos) {
                    if (pos < size) {
                        pstmt.setString(k, (String)_orgUnitId.get(pos));
                        pstmt.setString(k + 1, (String)_schemeId.get(pos));
                        continue;
                    }
                    pstmt.setString(k, "#");
                    pstmt.setString(k + 1, "#");
                }
                pstmt.setString(batchNum * 2 + 1, templateInfo.getRootId().toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    formInfo = new BgFormInfo();
                    formInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                    formInfo.setOrgUnit(new FullOrgUnitInfo());
                    formInfo.getOrgUnit().setId(BOSUuid.read((String)rst.getString("FOrgUnitId")));
                    formInfo.setBgItemGroup(new BgItemGroupInfo());
                    formInfo.getBgItemGroup().setId(BOSUuid.read((String)rst.getString("FBgItemGroupId")));
                    formInfo.getBgItemGroup().setNumber(rst.getString("FNumber"));
                    formInfo.getBgItemGroup().setName(rst.getString("FName"));
                    formInfo.setBgItem(new BgItemInfo());
                    formInfo.getBgItem().setId(BOSUuid.read((String)rst.getString("FBgItemId")));
                    _bgForms.add(formInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"error\uff1a", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return _bgForms;
    }

    @Override
    protected IObjectCollection _getCommonBgTemplate(Context ctx, BOSUuid[] bgSchemeIds, boolean hasUseFund, boolean isFund) throws BOSException, EASBizException {
        if (bgSchemeIds == null || bgSchemeIds.length == 0) {
            return new BgTemplateCollection();
        }
        Connection conn = null;
        BOSUuid _bgSchemeId = null;
        BgTemplateCollection bgTemplateCol = null;
        try {
            conn = this.getConnection(ctx);
            _bgSchemeId = bgSchemeIds.length == 1 ? bgSchemeIds[0] : this.getBgSchemeHasMinBgTemplate(conn, bgSchemeIds);
            bgTemplateCol = this.getBgTemplateByBgScheme(conn, _bgSchemeId);
            if (bgSchemeIds.length > 1) {
                bgTemplateCol = this.getFilterBgTemplate(conn, _bgSchemeId, bgSchemeIds, bgTemplateCol);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bgTemplateCol;
    }

    private BOSUuid getBgSchemeHasMinBgTemplate(Connection conn, BOSUuid[] bgSchemeIds) throws EASBizException {
        if (conn == null) {
            return null;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        BOSUuid _bgSchemeIdOfMin = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 n.FBgSchemeId, count(n.FBgTemplateId) as FCount from T_BG_BgSchemeNode n  where n.FBgSchemeId in (");
        int in = bgSchemeIds.length;
        for (int i = 0; i < in; ++i) {
            sql.append("?,");
            _tmpList.add(bgSchemeIds[i].toString());
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(") group by n.FBgSchemeId order by FCount");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            _bgSchemeIdOfMin = rst.next() ? BOSUuid.read((String)rst.getString(1)) : bgSchemeIds[0];
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return _bgSchemeIdOfMin;
    }

    private BgTemplateCollection getBgTemplateByBgScheme(Connection conn, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        if (conn == null || bgSchemeId == null) {
            return new BgTemplateCollection();
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FID, t.FName, t.FNumber, t.FRootId  from T_BG_BgTemplate t where t.FID in (select n.FBgTemplateId  from T_BG_BgSchemeNode n  where n.FBgSchemeId = ?)");
        sql.append(" order by t.FNumber");
        BgTemplateInfo bgTemplateInfo = null;
        BgTemplateCollection bgTemplateCol = new BgTemplateCollection();
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgSchemeId.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgTemplateInfo = new BgTemplateInfo();
                bgTemplateInfo.setId(BOSUuid.read((String)rst.getString(1)));
                bgTemplateInfo.setName(rst.getString(2));
                bgTemplateInfo.setNumber(rst.getString(3));
                bgTemplateInfo.setRootId(BOSUuid.read((String)rst.getString(4)));
                bgTemplateCol.add(bgTemplateInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"getBgSchemeHasMinBgTemplate:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgTemplateCol;
    }

    private BgTemplateCollection getBgTemplateByBgScheme(Context ctx, BOSUuid bgSchemeId, BOSUuid[] orgUnitIds) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null) {
            return new BgTemplateCollection();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<Object> _tmpList = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FID, t.FName, t.FNumber, t.FRootId, t.FFormtype  from T_BG_BgTemplate t where t.FID in (select n.FBgTemplateId  from T_BG_BgSchemeNode n  where n.FBgSchemeId = ?)");
        _tmpList.add(bgSchemeId.toString());
        if (BgSHelper.isBgPermissionUsed(ctx)) {
            Set temType;
            HashSet<String> temPer;
            HashSet<String> orgUntis = new HashSet<String>();
            for (int i = 0; i < orgUnitIds.length; ++i) {
                String num1 = orgUnitIds[i].toString();
                orgUntis.add(num1);
            }
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            IBgPermission iBgPer = BgPermissionFactory.getLocalInstance(ctx);
            Set schPer = iBgPer.getBgSchemePermission(userId, orgUntis);
            sql.append(" and ((");
            if (schPer != null && !schPer.isEmpty()) {
                sql.append(" t.FID in (select m.FBgTemplateId from T_BG_BgSchemeNode m where m.fbgschemeid in (" + BgNSQLHelper.getParamSizeString((Collection)schPer)).append("))");
                _tmpList.addAll(schPer);
            }
            if ((temPer = iBgPer.getBgTemplatePermission(userId, orgUntis)) != null && !temPer.isEmpty()) {
                if (schPer != null && !schPer.isEmpty()) {
                    sql.append(" and t.fid in (" + BgNSQLHelper.getParamSizeString((Collection)temPer)).append(")");
                    _tmpList.addAll(temPer);
                } else {
                    sql.append(" t.fid in (" + BgNSQLHelper.getParamSizeString((Collection)temPer)).append(")");
                    _tmpList.addAll(temPer);
                }
            }
            if ((temType = iBgPer.getBgTemplateTypePermisson(userId, orgUntis)) != null && !temType.isEmpty()) {
                if (temPer != null && !temPer.isEmpty() || schPer != null && !schPer.isEmpty()) {
                    sql.append(" and t.fbgTypeid in (" + BgNSQLHelper.getParamSizeString((Collection)temType)).append(")");
                    _tmpList.addAll(temType);
                } else {
                    sql.append(" t.fbgTypeid in (" + BgNSQLHelper.getParamSizeString((Collection)temType)).append(")");
                    _tmpList.addAll(temType);
                }
            }
            if (!(schPer != null && !schPer.isEmpty() || temPer != null && !temPer.isEmpty() || temType != null && !temType.isEmpty())) {
                temPer = new HashSet<String>();
                temPer.add("#");
                sql.append(" t.fid in (" + BgNSQLHelper.getParamSizeString(temPer)).append(")");
                _tmpList.addAll(temPer);
            }
            sql.append(") or t.fcreatorid = ? )");
            _tmpList.add(userId.toString());
        }
        sql.append(" and t.fid not in (select fid from t_bg_bgtemplate where FBgTypeID = 'BV/FQwEUEADgABtLwKgSXv9s2OA=' or FFormType = ?)");
        sql.append(" order by t.FNumber");
        _tmpList.add(new Integer(2));
        BgTemplateInfo bgTemplateInfo = null;
        BgTemplateCollection bgTemplateCol = new BgTemplateCollection();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgTemplateInfo = new BgTemplateInfo();
                bgTemplateInfo.setId(BOSUuid.read((String)rst.getString(1)));
                bgTemplateInfo.setName(rst.getString(2));
                bgTemplateInfo.setNumber(rst.getString(3));
                bgTemplateInfo.setRootId(BOSUuid.read((String)rst.getString(4)));
                bgTemplateInfo.setFormType(BgTemFormTypeEnum.getEnum(rst.getInt(5)));
                bgTemplateCol.add(bgTemplateInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"getBgTemplateByBgScheme: ", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgTemplateCol;
    }

    private BgTemplateCollection getFilterBgTemplate(Connection conn, BOSUuid bgSchemeId, BOSUuid[] bgSchemeIds, BgTemplateCollection bgTemplateCol) throws BOSException, EASBizException {
        if (conn == null || bgSchemeId == null || bgTemplateCol.isEmpty()) {
            return bgTemplateCol;
        }
        BOSUuid _bgSchemeId2 = null;
        BOSUuid _bgTemplateRootId = null;
        BgTemplateInfo bgTemplateInfo = null;
        BgTemplateInfo _bgTemplateInfo2 = null;
        BgTemplateCollection _bgTemplateCol = null;
        ArrayList<BgTemplateInfo> bgTemplateList = new ArrayList<BgTemplateInfo>();
        HashMap bgTemplateMap = new HashMap();
        HashMap _hasMap = new HashMap();
        Iterator iter = bgTemplateCol.iterator();
        while (iter.hasNext()) {
            bgTemplateInfo = (BgTemplateInfo)iter.next();
            bgTemplateMap.put(bgTemplateInfo.getRootId(), null);
            bgTemplateList.add(bgTemplateInfo);
        }
        try {
            for (BOSUuid _bgSchemeId2 : bgSchemeIds) {
                if (_bgSchemeId2.equals((Object)bgSchemeId)) continue;
                _bgTemplateCol = this.getBgTemplateByBgScheme(conn, _bgSchemeId2);
                _hasMap.clear();
                Iterator iter2 = _bgTemplateCol.iterator();
                while (iter2.hasNext()) {
                    _bgTemplateInfo2 = (BgTemplateInfo)iter2.next();
                    if (!bgTemplateMap.containsKey(_bgTemplateInfo2.getRootId())) continue;
                    _hasMap.put(_bgTemplateInfo2.getRootId(), null);
                }
                Iterator key = bgTemplateMap.keySet().iterator();
                while (key.hasNext()) {
                    _bgTemplateRootId = (BOSUuid)key.next();
                    if (_hasMap.containsKey(_bgTemplateRootId)) continue;
                    key.remove();
                }
            }
            bgTemplateCol.clear();
            for (BgTemplateInfo _bgTemplateInfo2 : bgTemplateList) {
                if (!bgTemplateMap.containsKey(_bgTemplateInfo2.getRootId())) continue;
                bgTemplateCol.add(_bgTemplateInfo2);
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        return bgTemplateCol;
    }

    @Override
    protected IObjectCollection _getCommonBgTemplate(Context ctx, BOSUuid bgSchemeId, BOSUuid[] orgUnitIds) throws BOSException, EASBizException {
        if (bgSchemeId == null) {
            return new BgTemplateCollection();
        }
        BgTemplateCollection bgTemplateCol = null;
        try {
            bgTemplateCol = this.getBgTemplateByBgScheme(ctx, bgSchemeId, orgUnitIds);
            bgTemplateCol = this.filterBgTemplateCollection(ctx, bgSchemeId, orgUnitIds, (IObjectCollection)bgTemplateCol);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return bgTemplateCol;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IObjectCollection filterBgTemplateCollection(Context ctx, BOSUuid bgSchemeId, BOSUuid[] orgUnitIds, IObjectCollection bgTemplateCol) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block17: {
            if (ctx == null) return bgTemplateCol;
            if (orgUnitIds == null) return bgTemplateCol;
            if (orgUnitIds.length == 0) return bgTemplateCol;
            if (bgTemplateCol.isEmpty()) {
                return bgTemplateCol;
            }
            HashMap orgUnitMap = new HashMap();
            HashMap<String, BgTemplateInfo> bgTemplateMap = new HashMap<String, BgTemplateInfo>();
            Set<String> rootIdSet = null;
            String _orgUnitId = null;
            String _rooId2 = null;
            String _bgSchemeRootId = null;
            BgTemplateInfo _bgTemplateInfo2 = null;
            ArrayList<String> _tmpList = new ArrayList<String>();
            conn = null;
            pstmt = null;
            rst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("select t.FID, t.FOrgUnitId, t.FRootId from T_BG_BgTemplate t left join T_BG_BgSchemeNode n on t.FID = n.FBgTemplateId left join T_BG_BgScheme s on n.FBgSchemeId = s.FID where s.FRootId = ? and t.FOrgUnitId in (");
            int in = orgUnitIds.length;
            for (int i = 0; i < in; ++i) {
                sql.append("?,");
                _tmpList.add(orgUnitIds[i].toString());
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(") and t.FRootId in (");
            for (BgTemplateInfo _bgTemplateInfo2 : bgTemplateCol) {
                bgTemplateMap.put(_bgTemplateInfo2.getRootId().toString(), _bgTemplateInfo2);
                sql.append("?,");
                _tmpList.add(_bgTemplateInfo2.getRootId().toString());
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement("select FRootId from T_BG_BgScheme where FID = ?");
                pstmt.setString(1, bgSchemeId.toString());
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    _bgSchemeRootId = rst.getString(1);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (_bgSchemeRootId == null) {
                    bgTemplateCol.clear();
                    break block17;
                }
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, _bgSchemeRootId);
                BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList, (int)2);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _orgUnitId = rst.getString(2);
                    _rooId2 = rst.getString(3);
                    if (orgUnitMap.containsKey(_orgUnitId)) {
                        rootIdSet = (Set)orgUnitMap.get(_orgUnitId);
                    } else {
                        rootIdSet = new HashSet();
                        orgUnitMap.put(_orgUnitId, rootIdSet);
                    }
                    rootIdSet.add(_rooId2);
                }
                in = orgUnitIds.length;
                for (int i = 0; i < in; ++i) {
                    _orgUnitId = orgUnitIds[i].toString();
                    rootIdSet = (Set)orgUnitMap.get(_orgUnitId);
                    if (rootIdSet == null || rootIdSet.isEmpty()) {
                        bgTemplateCol.clear();
                        IObjectCollection iObjectCollection = bgTemplateCol;
                        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
                        return iObjectCollection;
                    }
                    Iterator iter = bgTemplateMap.keySet().iterator();
                    while (iter.hasNext()) {
                        _rooId2 = (String)iter.next();
                        if (rootIdSet.contains(_rooId2)) continue;
                        iter.remove();
                    }
                }
                bgTemplateCol.clear();
                for (String _rooId2 : bgTemplateMap.keySet()) {
                    _bgTemplateInfo2 = (BgTemplateInfo)bgTemplateMap.get(_rooId2);
                    bgTemplateCol.addObject((IObjectValue)_bgTemplateInfo2);
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"filterBgTemplateCollection: ", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgTemplateCol;
    }

    @Override
    protected List _getDiffData(Context ctx, BOSUuid orgUnitId, Object filterParam) throws BOSException, EASBizException {
        if (filterParam == null || !(filterParam instanceof BgAnalyseDiffFilterParam)) {
            return new ArrayList();
        }
        BgAnalyseDiffFilterParam _filterParam = (BgAnalyseDiffFilterParam)filterParam;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        ArrayList<BgAnalyseInfo> diffList = new ArrayList<BgAnalyseInfo>();
        BgAnalyseInfo analyse = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer where = new StringBuffer();
        StringBuffer group = new StringBuffer();
        try {
            int i;
            Serializable _end;
            Serializable _begin;
            conn = this.getConnection(ctx);
            sql.append("select d.FOrgUnitId, d.FBgSchemeId, d.FFormula,  sum(case r.FPASTSOURCE when 6 then t.fadjvalue else t.fpastvalue end ) FValue, d.FBgItemCombinId, i.FKey, d.FBgPeriodId, p.FName_" + ctx.getLocale() + ", d.FBgElementId, d.FCurrencyId from T_BG_BgPastData t left outer join T_BG_BgPastRecord r on r.FID = t.FPastRecordId left outer join T_BG_BgData d on r.FBgFormId = d.FBgFormId and t.FFormula = d.FFormula left outer join T_BG_BgItemCombination i on d.FBgItemCombinId = i.FID left outer join T_BG_BgPeriod p on p.FID = d.FBgPeriodId");
            group.append(" group by d.FOrgUnitId, d.FBgSchemeId, d.FFormula, d.FBgItemCombinId, i.FKey, d.FBgPeriodId, p.FName_" + ctx.getLocale() + ", d.FBgElementId, d.FCurrencyId");
            where.append(" where ");
            if (orgUnitId != null) {
                where.append(" (d.FOrgUnitId = ?)");
                _tmpList.add(orgUnitId.toString());
            } else {
                OrgUnitInfo orgUnitInfo = _filterParam.getOrgUnits()[0];
                if (orgUnitInfo != null) {
                    where.append(" (d.FOrgUnitId = ?)");
                    _tmpList.add(orgUnitInfo.getId().toString());
                    orgUnitId = orgUnitInfo.getId();
                } else {
                    where.append(" (d.FOrgUnitId <> '')");
                }
            }
            if (_filterParam.getBgScheme() != null) {
                BgSchemeInfo bgSchemeInfo = BgFSHelper.getBgSchemeInfo(ctx, conn, _filterParam.getBgScheme().getId());
                BOSUuid bgSchemeId = this.getBgSchemeByOrgUnitInfo(conn, orgUnitId, bgSchemeInfo.getRootId());
                where.append(" and (d.FBgSchemeId = ?)");
                _tmpList.add(bgSchemeId != null ? bgSchemeId.toString() : bgSchemeInfo.getId().toString());
            }
            if (_filterParam.getBgPeriodBegin() != null && _filterParam.getBgPeriodEnd() != null) {
                _begin = null;
                _end = null;
                BgPeriodInfo _tmp = null;
                BgPeriodCollection _bgPeriodCol = null;
                _begin = _filterParam.getBgPeriodBegin();
                _end = _filterParam.getBgPeriodEnd();
                if (((AbstractBgPeriodInfo)_begin).getPeriodType().getValue() == 8) {
                    where.append(" and (d.FBgPeriodId in (?))");
                    _tmpList.add(_begin.getId().toString());
                } else {
                    _bgPeriodCol = BgPeriodHelper.getPeriodColInfo(ctx, ((AbstractBgPeriodInfo)_begin).getBeginDate(), ((AbstractBgPeriodInfo)_end).getEndDate(), ((AbstractBgPeriodInfo)_begin).getPeriodType().getValue());
                    if (_bgPeriodCol != null && !_bgPeriodCol.isEmpty()) {
                        where.append(" and (d.FBgPeriodId in (");
                        int n = _bgPeriodCol.size();
                        for (i = 0; i < n; ++i) {
                            _tmp = _bgPeriodCol.get(i);
                            if (i < n - 1) {
                                where.append("?,");
                            } else {
                                where.append("?))");
                            }
                            _tmpList.add(_tmp.getId().toString());
                        }
                    }
                }
            }
            if (_filterParam.getBgItemBegin() != null && _filterParam.getBgItemEnd() != null) {
                _begin = null;
                _end = null;
                _begin = _filterParam.getBgItemBegin();
                _end = _filterParam.getBgItemEnd();
                where.append(" and (i.Fkey >= ? and i.Fkey <= ?)");
                _tmpList.add(((AbstractVisualItemInfo)_begin).getNumber().replaceAll(",", "_"));
                _tmpList.add(((AbstractVisualItemInfo)_end).getNumber().replaceAll(",", "_"));
            }
            if (_filterParam.getElementMap() != null && _filterParam.getElementMap().size() > 0) {
                where.append(" and (d.FBgElementId in (");
                Iterator it = _filterParam.getElementMap().keySet().iterator();
                while (it.hasNext()) {
                    BgElementInfo _bgElement = null;
                    String id = null;
                    int n = _filterParam.getElementMap().size();
                    for (i = 0; i < n; ++i) {
                        _bgElement = (BgElementInfo)it.next();
                        id = "";
                        if (_bgElement != null) {
                            id = _bgElement.getId().toString();
                        }
                        if (i < n - 1) {
                            where.append("?,");
                        } else {
                            where.append("?))");
                        }
                        _tmpList.add(id);
                    }
                }
            }
            if (_filterParam.getCurrency() != null) {
                CurrencyInfo currencyInfo = _filterParam.getCurrency();
                where.append(" and (d.FCurrencyId = ?)");
                _tmpList.add(currencyInfo.getId().toString());
            }
            sql.append(where);
            sql.append(group);
            sql.append(" order by p.FName_" + ctx.getLocale() + ", i.Fkey");
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                analyse = new BgAnalyseInfo();
                analyse.setCostCenterOrgUnitId(rst.getString("FOrgUnitId"));
                analyse.setBgSchemeId(rst.getString("FBgSchemeId"));
                analyse.setFormula(rst.getString("FFormula"));
                analyse.setValue(rst.getBigDecimal("FValue"));
                analyse.setBgItemCombinId(rst.getString("FBgItemCombinId"));
                analyse.setBgItemNumber(rst.getString("FKey").replaceAll("_", ","));
                analyse.setBgPeriodId(rst.getString("FBgPeriodId"));
                analyse.setBgPeriodName(rst.getString("FName_" + ctx.getLocale()));
                analyse.setBgElementId(rst.getString("FBgElementId"));
                analyse.setCurrencyId(rst.getString("FCurrencyId"));
                diffList.add(analyse);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"_getDiffData: ", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return diffList;
    }

    @Override
    protected List _getContData(Context ctx, BOSUuid orgUnitId, Object filterParam) throws BOSException, EASBizException {
        if (orgUnitId == null && filterParam == null && !(filterParam instanceof BgAnalyseContrastFilterParam)) {
            return new ArrayList();
        }
        BgAnalyseContrastFilterParam _filterParam = (BgAnalyseContrastFilterParam)filterParam;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        ArrayList<BgAnalyseContInfo> diffList = new ArrayList<BgAnalyseContInfo>();
        BgAnalyseContInfo analyse = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer where = new StringBuffer();
        try {
            Serializable _end;
            Serializable _begin;
            conn = this.getConnection(ctx);
            sql.append("SELECT c.FKey \t\t\tBgItemCombinNumber, t.FBgItemCombinId \tBgItemCombinId, t.FOrgUnitId \t\t\tOrgUnitId, t.FBgSchemeId \t\tBgSchemeId, t.FBgPeriodId \t\tBgPeriodId, p.FName_" + ctx.getLocale() + " BgPeriodName, sum(t.FBgValue)       BgValue, sum(t.FBizActual) \tAcValue FROM T_BG_BgData t LEFT OUTER JOIN T_BG_BgItemCombination c ON t.FBgItemCombinId = c.FID LEFT OUTER JOIN T_BG_BgPeriod p ON t.FBgPeriodId = p.FID");
            where.append(" WHERE t.FOrgUnitId = ?");
            _tmpList.add(orgUnitId.toString());
            if (_filterParam.getBgScheme() != null) {
                BgSchemeInfo bgSchemeInfo = BgFSHelper.getBgSchemeInfo(ctx, conn, _filterParam.getBgScheme().getId());
                BOSUuid bgSchemeId = this.getBgSchemeByOrgUnitInfo(conn, orgUnitId, bgSchemeInfo.getRootId());
                where.append(" and (t.FBgSchemeId = ?)");
                _tmpList.add(bgSchemeId != null ? bgSchemeId.toString() : bgSchemeInfo.getId().toString());
            }
            if (_filterParam.getBgTemplateInfo() != null) {
                BgTemplateInfo bgTemplateInfo = BgFSHelper.getBgTemplateInfo(conn, _filterParam.getBgTemplateInfo().getId(), false);
                BOSUuid bgTemplateId = this.getBgTemplateByOrgUnitInfo(conn, orgUnitId, bgTemplateInfo.getRootId());
                where.append(" and (t.FBgTemplateId = ?)");
                _tmpList.add(bgTemplateId != null ? bgTemplateId.toString() : bgTemplateInfo.getId().toString());
            }
            if (_filterParam.getBgPeriodBegin() != null && _filterParam.getBgPeriodEnd() != null) {
                _begin = null;
                _end = null;
                BgPeriodInfo _tmp = null;
                BgPeriodCollection _bgPeriodCol = null;
                _begin = _filterParam.getBgPeriodBegin();
                _end = _filterParam.getBgPeriodEnd();
                _bgPeriodCol = BgPeriodHelper.getPeriodColInfo(ctx, ((AbstractBgPeriodInfo)_begin).getBeginDate(), ((AbstractBgPeriodInfo)_end).getEndDate(), ((AbstractBgPeriodInfo)_begin).getPeriodType().getValue());
                if (_bgPeriodCol != null && !_bgPeriodCol.isEmpty()) {
                    where.append(" and (t.FBgPeriodId in (");
                    int n = _bgPeriodCol.size();
                    for (int i = 0; i < n; ++i) {
                        _tmp = _bgPeriodCol.get(i);
                        if (i < n - 1) {
                            where.append("?,");
                        } else {
                            where.append("?))");
                        }
                        _tmpList.add(_tmp.getId().toString());
                    }
                }
            }
            if (_filterParam.getBgItemBegin() != null && _filterParam.getBgItemEnd() != null) {
                _begin = null;
                _end = null;
                _begin = _filterParam.getBgItemBegin();
                _end = _filterParam.getBgItemEnd();
                where.append(" and (c.Fkey >= ? and c.Fkey <= ?)");
                _tmpList.add(((AbstractVisualItemInfo)_begin).getNumber());
                _tmpList.add(((AbstractVisualItemInfo)_end).getNumber());
            }
            if (_filterParam.getBgElements() != null && _filterParam.getBgElements().length > 0 && _filterParam.getBgElements()[0] != null) {
                BgElementInfo _bgElement = null;
                Object[] _bgElements = _filterParam.getBgElements();
                where.append(" and (t.FBgElementId in (");
                int n = _bgElements.length;
                for (int i = 0; i < n; ++i) {
                    _bgElement = (BgElementInfo)_bgElements[i];
                    if (i < n - 1) {
                        where.append("?,");
                    } else {
                        where.append("?))");
                    }
                    _tmpList.add(_bgElement.getId().toString());
                }
            }
            if (_filterParam.getCurrency() != null) {
                CurrencyInfo currencyInfo = _filterParam.getCurrency();
                where.append(" and (t.FCurrencyId = ?)");
                _tmpList.add(currencyInfo.getId().toString());
            }
            sql.append(where);
            sql.append(" group by c.FKey, t.FBgItemCombinId, t.FOrgUnitId, t.FBgSchemeId, t.FBgSchemeId, t.FBgPeriodId, p.FName_" + ctx.getLocale());
            sql.append(" order by Fkey, BgPeriodName");
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                analyse = new BgAnalyseContInfo();
                analyse.setBgItemNumber(rst.getString("BgItemCombinNumber").replaceAll("_", ","));
                analyse.setBgItemCombinId(rst.getString("BgItemCombinId"));
                analyse.setCostCenterOrgUnitId(rst.getString("OrgUnitId"));
                analyse.setBgSchemeId(rst.getString("BgSchemeId"));
                analyse.setBgPeriodId(rst.getString("BgPeriodId"));
                analyse.setBgPeriodName(rst.getString("BgPeriodName"));
                analyse.setValue(rst.getBigDecimal("BgValue"));
                analyse.setAValue(rst.getBigDecimal("AcValue"));
                diffList.add(analyse);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"_getContData\uff1a", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return diffList;
    }

    @Override
    protected List _getContData(Context ctx, Object filterParam) throws BOSException, EASBizException {
        if (filterParam == null && !(filterParam instanceof BgAnalyseContrastFilterParam)) {
            return new ArrayList();
        }
        BgAnalyseContrastFilterParam _filterParam = (BgAnalyseContrastFilterParam)filterParam;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        ArrayList<BgAnalyseContInfo> diffList = new ArrayList<BgAnalyseContInfo>();
        BgAnalyseContInfo analyse = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer where = new StringBuffer();
        try {
            Serializable _end;
            Serializable _begin;
            int i;
            int in;
            conn = this.getConnection(ctx);
            sql.append("SELECT c.FKey \t\t\tBgItemCombinNumber, t.FBgItemCombinId \tBgItemCombinId, t.FBgPeriodId \t\tBgPeriodId, p.FName_" + ctx.getLocale() + " BgPeriodName, sum(t.FBgValue)      \tBgValue, sum(t.FBizActual)    \tAcValue FROM T_BG_BgData t LEFT OUTER JOIN T_BG_BgItemCombination c ON t.FBgItemCombinId = c.FID LEFT OUTER JOIN T_BG_BgPeriod p ON t.FBgPeriodId = p.FID");
            where.append(" WHERE 1 = 1");
            if (_filterParam.getBgScheme() != null) {
                BgSchemeInfo bgSchemeInfo = BgFSHelper.getBgSchemeInfo(ctx, conn, _filterParam.getBgScheme().getId());
                BOSUuid[] bgSchemeIds = this.getBgSchemeByOrgUnitInfo(conn, _filterParam.getCurrOrgUnitInfo(), _filterParam.getOrgUnits(), bgSchemeInfo.getRootId(), _filterParam.getIsGather());
                if (bgSchemeIds != null && bgSchemeIds.length > 0) {
                    where.append(" and (t.FBgSchemeId in (");
                    in = bgSchemeIds.length;
                    for (i = 0; i < in; ++i) {
                        where.append("?,");
                        _tmpList.add(bgSchemeIds[i].toString());
                    }
                    where.delete(where.length() - 1, where.length());
                    where.append("))");
                }
            }
            if (_filterParam.getBgTemplateInfo() != null) {
                BgTemplateInfo bgTemplateInfo = BgFSHelper.getBgTemplateInfo(conn, _filterParam.getBgTemplateInfo().getId(), false);
                BOSUuid[] bgTemplateIds = this.getBgTemplateByOrgUnitInfo(conn, _filterParam.getOrgUnits(), bgTemplateInfo.getRootId());
                if (bgTemplateIds != null && bgTemplateIds.length > 0) {
                    where.append(" and (t.FBgTemplateId in (");
                    in = bgTemplateIds.length;
                    for (i = 0; i < in; ++i) {
                        where.append("?,");
                        _tmpList.add(bgTemplateIds[i].toString());
                    }
                    where.delete(where.length() - 1, where.length());
                    where.append("))");
                }
            }
            if (_filterParam.getBgPeriodBegin() != null && _filterParam.getBgPeriodEnd() != null) {
                _begin = null;
                _end = null;
                BgPeriodInfo _tmp = null;
                BgPeriodCollection _bgPeriodCol = null;
                _begin = _filterParam.getBgPeriodBegin();
                _end = _filterParam.getBgPeriodEnd();
                _bgPeriodCol = BgPeriodHelper.getPeriodColInfo(ctx, ((AbstractBgPeriodInfo)_begin).getBeginDate(), ((AbstractBgPeriodInfo)_end).getEndDate(), ((AbstractBgPeriodInfo)_begin).getPeriodType().getValue());
                if (_bgPeriodCol != null && !_bgPeriodCol.isEmpty()) {
                    where.append(" and (t.FBgPeriodId in (");
                    int n = _bgPeriodCol.size();
                    for (int i2 = 0; i2 < n; ++i2) {
                        _tmp = _bgPeriodCol.get(i2);
                        if (i2 < n - 1) {
                            where.append("?,");
                        } else {
                            where.append("?))");
                        }
                        _tmpList.add(_tmp.getId().toString());
                    }
                }
            }
            if (_filterParam.getBgItemBegin() != null && _filterParam.getBgItemEnd() != null) {
                _begin = null;
                _end = null;
                _begin = _filterParam.getBgItemBegin();
                _end = _filterParam.getBgItemEnd();
                where.append(" and (c.Fkey >= ? and c.Fkey <= ?)");
                _tmpList.add(((AbstractVisualItemInfo)_begin).getNumber());
                _tmpList.add(((AbstractVisualItemInfo)_end).getNumber());
            }
            if (_filterParam.getBgElements() != null && _filterParam.getBgElements().length > 0 && _filterParam.getBgElements()[0] != null) {
                BgElementInfo _bgElement = null;
                Object[] _bgElements = _filterParam.getBgElements();
                where.append(" and (t.FBgElementId in (");
                int n = _bgElements.length;
                for (int i3 = 0; i3 < n; ++i3) {
                    _bgElement = (BgElementInfo)_bgElements[i3];
                    if (i3 < n - 1) {
                        where.append("?,");
                    } else {
                        where.append("?))");
                    }
                    _tmpList.add(_bgElement.getId().toString());
                }
            }
            if (_filterParam.getCurrency() != null) {
                CurrencyInfo currencyInfo = _filterParam.getCurrency();
                where.append(" and (t.FCurrencyId = ?)");
                _tmpList.add(currencyInfo.getId().toString());
            }
            sql.append(where);
            sql.append(" group by c.FKey, t.FBgItemCombinId, t.FBgPeriodId, p.FName_" + ctx.getLocale());
            sql.append(" order by Fkey, BgPeriodName");
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                analyse = new BgAnalyseContInfo();
                analyse.setBgItemCombinId(rst.getString("BgItemCombinId"));
                analyse.setBgItemNumber(rst.getString("BgItemCombinNumber").replaceAll("_", ","));
                analyse.setBgPeriodId(rst.getString("BgPeriodId"));
                analyse.setBgPeriodName(rst.getString("BgPeriodName"));
                analyse.setValue(rst.getBigDecimal("BgValue"));
                analyse.setAValue(rst.getBigDecimal("AcValue"));
                diffList.add(analyse);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return diffList;
    }

    @Override
    protected List _getContBatchData(Context ctx, Object filterParam) throws BOSException, EASBizException {
        if (filterParam == null && !(filterParam instanceof BgAnalyseContrastFilterParam)) {
            return new ArrayList();
        }
        BgAnalyseContrastFilterParam _filterParam = (BgAnalyseContrastFilterParam)filterParam;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        ArrayList<BgAnalyseContInfo> diffList = new ArrayList<BgAnalyseContInfo>();
        BgAnalyseContInfo analyse = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer where = new StringBuffer();
        try {
            Serializable _end;
            Serializable _begin;
            BgSchemeInfo[] bgSchemes;
            conn = this.getConnection(ctx);
            sql.append("SELECT t.FBgSchemeId\tBgSchemeId, c.FKey \t\t\t\tBgItemCombinNumber, t.FBgItemCombinId \tBgItemCombinId, t.FBgPeriodId \t\tBgPeriodId, p.FName_" + ctx.getLocale() + " BgPeriodName, sum(t.FBgValue)      \tBgValue FROM T_BG_BgData t LEFT OUTER JOIN T_BG_BgItemCombination c ON t.FBgItemCombinId = c.FID LEFT OUTER JOIN T_BG_BgPeriod p ON t.FBgPeriodId = p.FID");
            where.append(" WHERE 1 = 1");
            if (_filterParam.getBgSchemes() != null && (bgSchemes = _filterParam.getBgSchemes()) != null && bgSchemes.length == 2) {
                where.append(" and (t.FBgSchemeId in (?, ?))");
                _tmpList.add(bgSchemes[0].getId().toString());
                _tmpList.add(bgSchemes[1].getId().toString());
            }
            if (_filterParam.getBgTemplateInfo() != null) {
                where.append(" and (t.FBgTemplateId = ?)");
                _tmpList.add(_filterParam.getBgTemplateInfo().getId().toString());
            }
            if (_filterParam.getBgPeriodBegin() != null && _filterParam.getBgPeriodEnd() != null) {
                _begin = null;
                _end = null;
                BgPeriodInfo _tmp = null;
                BgPeriodCollection _bgPeriodCol = null;
                _begin = _filterParam.getBgPeriodBegin();
                _end = _filterParam.getBgPeriodEnd();
                _bgPeriodCol = BgPeriodHelper.getPeriodColInfo(ctx, ((AbstractBgPeriodInfo)_begin).getBeginDate(), ((AbstractBgPeriodInfo)_end).getEndDate(), ((AbstractBgPeriodInfo)_begin).getPeriodType().getValue());
                if (_bgPeriodCol != null && !_bgPeriodCol.isEmpty()) {
                    where.append(" and (t.FBgPeriodId in (");
                    int n = _bgPeriodCol.size();
                    for (int i = 0; i < n; ++i) {
                        _tmp = _bgPeriodCol.get(i);
                        if (i < n - 1) {
                            where.append("?,");
                        } else {
                            where.append("?))");
                        }
                        _tmpList.add(_tmp.getId().toString());
                    }
                }
            }
            if (_filterParam.getBgItemBegin() != null && _filterParam.getBgItemEnd() != null) {
                _begin = null;
                _end = null;
                _begin = _filterParam.getBgItemBegin();
                _end = _filterParam.getBgItemEnd();
                where.append(" and (c.Fkey >= ? and c.Fkey <= ?)");
                _tmpList.add(((AbstractVisualItemInfo)_begin).getNumber());
                _tmpList.add(((AbstractVisualItemInfo)_end).getNumber());
            }
            if (_filterParam.getBgElements() != null && _filterParam.getBgElements().length > 0 && _filterParam.getBgElements()[0] != null) {
                BgElementInfo _bgElement = null;
                Object[] _bgElements = _filterParam.getBgElements();
                where.append(" and (t.FBgElementId in (");
                int n = _bgElements.length;
                for (int i = 0; i < n; ++i) {
                    _bgElement = (BgElementInfo)_bgElements[i];
                    if (i < n - 1) {
                        where.append("?,");
                    } else {
                        where.append("?))");
                    }
                    _tmpList.add(_bgElement.getId().toString());
                }
            }
            if (_filterParam.getCurrency() != null) {
                CurrencyInfo currencyInfo = _filterParam.getCurrency();
                where.append(" and (t.FCurrencyId = ?)");
                _tmpList.add(currencyInfo.getId().toString());
            }
            sql.append(where);
            sql.append(" group by t.FBgSchemeId, c.FKey, t.FBgItemCombinId, t.FBgPeriodId, p.FName_" + ctx.getLocale());
            sql.append(" order by Fkey, BgPeriodName");
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                analyse = new BgAnalyseContInfo();
                analyse.setBgSchemeId(rst.getString("BgSchemeId"));
                analyse.setBgItemCombinId(rst.getString("BgItemCombinId"));
                analyse.setBgItemNumber(rst.getString("BgItemCombinNumber").replaceAll("_", ","));
                analyse.setBgPeriodId(rst.getString("BgPeriodId"));
                analyse.setBgPeriodName(rst.getString("BgPeriodName"));
                analyse.setValue(rst.getBigDecimal("BgValue"));
                diffList.add(analyse);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return diffList;
    }

    private BOSUuid getBgSchemeByOrgUnitInfo(Connection conn, BOSUuid orgUnitId, BOSUuid bgSchemeRootId) throws EASBizException {
        if (conn == null || orgUnitId == null || bgSchemeRootId == null) {
            return null;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BOSUuid bgSchemeId = null;
        try {
            pstmt = conn.prepareStatement("select FID from T_BG_BgScheme where FOrgUnitID = ? and FRootID = ?");
            pstmt.setString(1, orgUnitId.toString());
            pstmt.setString(2, bgSchemeRootId.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                bgSchemeId = BOSUuid.read((String)rst.getString(1));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgSchemeId;
    }

    private BOSUuid[] getBgSchemeByOrgUnitInfo(Connection conn, OrgUnitInfo currOrgUnitInfo, OrgUnitInfo[] orgUnits, BOSUuid bgSchemeRootId, boolean isGather) throws EASBizException {
        if (conn == null || orgUnits == null || bgSchemeRootId == null) {
            return null;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<BOSUuid> bgSchemeList = new ArrayList<BOSUuid>();
        HashMap<String, BOSUuid> numbrMap = new HashMap<String, BOSUuid>();
        String longnumber = null;
        String tmpNumber2 = null;
        BOSUuid orgUnitId = null;
        BOSUuid[] bgSchemeIds = null;
        OrgUnitInfo orgUnitInfo2 = null;
        for (OrgUnitInfo orgUnitInfo2 : orgUnits) {
            longnumber = orgUnitInfo2.getLongNumber();
            numbrMap.put(longnumber, orgUnitInfo2.getId());
        }
        for (OrgUnitInfo orgUnitInfo2 : orgUnits) {
            longnumber = orgUnitInfo2.getLongNumber();
            Iterator iter = numbrMap.keySet().iterator();
            while (iter.hasNext()) {
                tmpNumber2 = (String)iter.next();
                if (!longnumber.startsWith(tmpNumber2 + "!")) continue;
                iter.remove();
            }
        }
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_BG_BgScheme where FRootID = ?");
        _tmpList.add(bgSchemeRootId.toString());
        if (!numbrMap.isEmpty()) {
            sql.append(" and FOrgUnitID in (");
            for (String tmpNumber2 : numbrMap.keySet()) {
                orgUnitId = (BOSUuid)numbrMap.get(tmpNumber2);
                sql.append("?,");
                _tmpList.add(orgUnitId.toString());
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        try {
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgSchemeList.add(BOSUuid.read((String)rst.getString(1)));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        bgSchemeIds = new BOSUuid[bgSchemeList.size()];
        int in = bgSchemeList.size();
        for (int i = 0; i < in; ++i) {
            bgSchemeIds[i] = (BOSUuid)bgSchemeList.get(i);
        }
        return bgSchemeIds;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map getBgSchemeByOrgUnitInfo(Context ctx, OrgUnitInfo[] orgUnits, BOSUuid bgSchemeRootId) throws BOSException, EASBizException {
        if (orgUnits == null || bgSchemeRootId == null) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FOrgUnitID from T_BG_BgScheme where FRootID = '" + bgSchemeRootId + "'");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                tmpMap.put(rst.getString("FOrgUnitID"), rst.getString("FID"));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"error", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        OrgUnitInfo _unitInfo = null;
        int i = 0;
        int in = orgUnits.length;
        while (i < in) {
            String _id;
            _unitInfo = orgUnits[i];
            if (_unitInfo != null && !tmpMap.containsKey(_id = _unitInfo.getId().toString())) {
                tmpMap.remove(_id);
            }
            ++i;
        }
        return tmpMap;
    }

    private BOSUuid getBgTemplateByOrgUnitInfo(Connection conn, BOSUuid orgUnitId, BOSUuid bgTemplateRootId) throws EASBizException {
        if (conn == null || orgUnitId == null || bgTemplateRootId == null) {
            return null;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BOSUuid bgTemplateId = null;
        try {
            pstmt = conn.prepareStatement("select FID from T_BG_BgTemplate where FOrgUnitID = ? and FRootID = ?");
            pstmt.setString(1, orgUnitId.toString());
            pstmt.setString(2, bgTemplateRootId.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                bgTemplateId = BOSUuid.read((String)rst.getString(1));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgTemplateId;
    }

    private BOSUuid[] getBgTemplateByOrgUnitInfo(Connection conn, OrgUnitInfo[] orgUnits, BOSUuid bgTemplateRootId) throws EASBizException {
        if (conn == null || orgUnits == null || bgTemplateRootId == null) {
            return null;
        }
        ArrayList<Object> _tmpList = new ArrayList<Object>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<BOSUuid> bgTemplateIdList = new ArrayList<BOSUuid>();
        BOSUuid[] bgTemplateIds = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_BG_BgTemplate where FRootID = ? and FOrgUnitID in (");
        _tmpList.add(bgTemplateRootId);
        if (orgUnits.length > 0) {
            OrgUnitInfo orgUnitInfo2 = null;
            for (OrgUnitInfo orgUnitInfo2 : orgUnits) {
                sql.append("?,");
                _tmpList.add(orgUnitInfo2.getId().toString());
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        try {
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgTemplateIdList.add(BOSUuid.read((String)rst.getString(1)));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        bgTemplateIds = new BOSUuid[bgTemplateIdList.size()];
        int in = bgTemplateIdList.size();
        for (int i = 0; i < in; ++i) {
            bgTemplateIds[i] = (BOSUuid)bgTemplateIdList.get(i);
        }
        return bgTemplateIds;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object _getPrintConfig(Context ctx, String solutionId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)solutionId)) {
            return null;
        }
        PrintConfigInfo configInfo = new PrintConfigInfo();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("SELECT PrintConfig FROM T_BG_BgAnalyseConfig WHERE FID = ?");
            pstmt.setString(1, solutionId);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                configInfo.setData(BgInfoHelper.getBytes((ResultSet)rst, (int)1));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (IOException ex3) {
                    logger.error((Object)ex3);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return configInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _setPrintConfig(Context ctx, String solutionId, Object model) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block13: {
            if (StringUtils.isEmpty((String)solutionId)) return;
            if (model == null) {
                return;
            }
            byte[] data = ((PrintConfigInfo)model).getData();
            if (data == null) return;
            if (data.length <= 0) return;
            conn = null;
            pstmt = null;
            PreparedStatement pstUp = null;
            PreparedStatement pstInt = null;
            rst = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement("SELECT FID FROM T_BG_BgAnalyseConfig WHERE FID = ?");
                pstmt.setString(1, solutionId);
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    try {
                        pstUp = conn.prepareStatement("UPDATE T_BG_BgAnalyseConfig SET PrintConfig = ? WHERE FID = ?");
                        pstUp.setBytes(1, data);
                        pstUp.setString(2, solutionId);
                        pstUp.executeUpdate();
                        break block13;
                    }
                    finally {
                        SQLUtils.cleanup((Statement)pstUp);
                    }
                }
                try {
                    pstInt = conn.prepareStatement("INSERT INTO T_BG_BgAnalyseConfig(FID, PrintConfig) VALUES(?, ?)");
                    pstInt.setString(1, solutionId);
                    pstInt.setBytes(2, data);
                    pstInt.executeUpdate();
                }
                finally {
                    SQLUtils.cleanup((Statement)pstInt);
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                    catch (BOSException ex2) {
                        throw ex2;
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected OrgUnitInfo[] _getHaveFormOrg(Context ctx, Object BgFormAnalyseParam) throws BOSException, EASBizException {
        if (BgFormAnalyseParam == null) {
            return null;
        }
        if (BgFormAnalyseParam instanceof BgAnalyseFilterParam) {
            BgAnalyseFilterParam bgAnalyseParam = (BgAnalyseFilterParam)BgFormAnalyseParam;
            OrgUnitInfo[] orgCol = new OrgUnitInfo[bgAnalyseParam.getOrgUnits().length];
            Map orgUnitIds = new HashMap();
            try {
                if (orgUnitIds == null || orgUnitIds.size() < 1) {
                    orgUnitIds = this.getHaveFormOrgIdsWithBgFormIdsBgPeriod(ctx, bgAnalyseParam, orgUnitIds);
                }
            }
            catch (Exception e) {
                throw new BgException(BgException.DATABASEERROR, new String[]{e.getMessage()});
            }
            if (orgUnitIds.size() > 0) {
                for (int i = 0; i < bgAnalyseParam.getOrgUnits().length; ++i) {
                    if (!orgUnitIds.containsKey(bgAnalyseParam.getOrgUnits()[i].getId().toString())) continue;
                    orgCol[i] = bgAnalyseParam.getOrgUnits()[i];
                }
                return orgCol;
            }
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getHaveFormOrgIdsWithBgFormIdsBgPeriod(Context ctx, BgAnalyseFilterParam bgAnalyseParam, Map orgUnitIds) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        String[] oldOrgUnitIds = new String[bgAnalyseParam.getOrgUnits().length];
        for (int i = 0; i < bgAnalyseParam.getOrgUnits().length; ++i) {
            oldOrgUnitIds[i] = bgAnalyseParam.getOrgUnits()[i].getId().toString();
            _tmpList.add(oldOrgUnitIds[i]);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select forgUnitId from t_bg_bgform where forgUnitid in (");
        sql.append(BgNSQLHelper.getParamSizeString((int)oldOrgUnitIds.length));
        sql.append(") and fbgschemeid in (select fid from t_bg_bgscheme where frootid = ?)");
        _tmpList.add(bgAnalyseParam.getBgScheme().getRootId().toString());
        if (bgAnalyseParam instanceof BgAnalyseFormQueryParam) {
            String[] filter = new String[4];
            filter = this.getBgSchemeAndBgTemplate(ctx, (BgAnalyseFormQueryParam)bgAnalyseParam, filter);
            sql.append(" and fbgtemplateid in (select fid from t_bg_bgtemplate where frootId = ?)");
            BgAnalyseFormQueryParam bfq = (BgAnalyseFormQueryParam)bgAnalyseParam;
            IBgForm ibg = BgFormFactory.getLocalInstance(ctx);
            ObjectStringPK iopk = new ObjectStringPK(bfq.getBgFormInfo().getId().toString());
            BgFormInfo bf = ibg.getBgFormInfo((IObjectPK)iopk);
            sql.append(" and fbgperiodid = ?");
            _tmpList.add(filter[1]);
            _tmpList.add(bf.getBgPeriod().getId().toString());
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                if (orgUnitIds.containsKey(rst.getString(1))) continue;
                orgUnitIds.put(rst.getString(1), null);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return orgUnitIds;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getHaveFormOrgIds(Context ctx, BgAnalyseFilterParam bgAnalyseParam, Map orgUnitIds) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        String[] oldOrgUnitIds = new String[bgAnalyseParam.getOrgUnits().length];
        for (int i = 0; i < bgAnalyseParam.getOrgUnits().length; ++i) {
            oldOrgUnitIds[i] = bgAnalyseParam.getOrgUnits()[i].getId().toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select forgUnitId from t_bg_bgform where forgUnitid in (").append(BgNSQLHelper.getParamSizeString((int)oldOrgUnitIds.length)).append(") ");
        int in = oldOrgUnitIds.length;
        for (int i = 0; i < in; ++i) {
            _tmpList.add(oldOrgUnitIds[i]);
        }
        sql.append(" and fbgschemeid in (select fid from t_bg_bgscheme where frootid = ?)");
        _tmpList.add(bgAnalyseParam.getBgScheme().getRootId().toString());
        if (bgAnalyseParam instanceof BgAnalyseFormQueryParam) {
            String[] filter = new String[4];
            filter = this.getBgSchemeAndBgTemplate(ctx, (BgAnalyseFormQueryParam)bgAnalyseParam, filter);
            sql.append(" and fbgtemplateid in (select fid from t_bg_bgtemplate where frootId = ?)");
            _tmpList.add(filter[1]);
        }
        sql = this.addBgPeriod(ctx, sql, bgAnalyseParam, _tmpList);
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                if (orgUnitIds.containsKey(rst.getString(1))) continue;
                orgUnitIds.put(rst.getString(1), null);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return orgUnitIds;
    }

    private StringBuffer addBgPeriod(Context ctx, StringBuffer sql, BgAnalyseFilterParam bgAnalyseParam, List _tmpList) throws Exception {
        if (bgAnalyseParam.getBgPeriodBegin() != null && bgAnalyseParam.getBgPeriodEnd() != null) {
            BgPeriodInfo _begin = null;
            BgPeriodInfo _end = null;
            BgPeriodInfo _tmp = null;
            BgPeriodCollection _bgPeriodCol = null;
            _begin = bgAnalyseParam.getBgPeriodBegin();
            _end = bgAnalyseParam.getBgPeriodEnd();
            _bgPeriodCol = BgPeriodHelper.getPeriodColInfo(ctx, _begin.getBeginDate(), _end.getEndDate(), _begin.getPeriodType().getValue());
            if (_bgPeriodCol != null && !_bgPeriodCol.isEmpty()) {
                sql.append(" and (FBgPeriodId in (");
                int n = _bgPeriodCol.size();
                for (int i = 0; i < n; ++i) {
                    _tmp = _bgPeriodCol.get(i);
                    if (i < n - 1) {
                        sql.append("?,");
                    } else {
                        sql.append("?))");
                    }
                    _tmpList.add(_tmp.getId().toString());
                }
            }
        }
        return sql;
    }

    private StringBuffer addBgPeriods(Context ctx, StringBuffer sql, BgAnalyseFilterParam bgAnalyseParam) throws Exception {
        if (bgAnalyseParam.getBgPeriodBegin() != null && bgAnalyseParam.getBgPeriodEnd() != null) {
            BgPeriodInfo _begin = null;
            BgPeriodInfo _end = null;
            BgPeriodInfo _tmp = null;
            BgPeriodCollection _bgPeriodCol = null;
            _begin = bgAnalyseParam.getBgPeriodBegin();
            _end = bgAnalyseParam.getBgPeriodEnd();
            _bgPeriodCol = BgPeriodHelper.getPeriodColInfo(ctx, _begin.getBeginDate(), _end.getEndDate(), _begin.getPeriodType().getValue());
            if (_bgPeriodCol != null && !_bgPeriodCol.isEmpty()) {
                sql.append(" and (FBgPeriodId in (");
                int n = _bgPeriodCol.size();
                for (int i = 0; i < n; ++i) {
                    _tmp = _bgPeriodCol.get(i);
                    if (i < n - 1) {
                        sql.append("'" + _tmp.getId() + "',");
                        continue;
                    }
                    sql.append("'" + _tmp.getId() + "'))");
                }
            }
        } else if (bgAnalyseParam instanceof BgAnalyseFormQueryParam) {
            BgAnalyseFormQueryParam bgafqp = (BgAnalyseFormQueryParam)bgAnalyseParam;
            sql.append(" AND fformula in (select fformula from  T_bg_bgdata where fbgformid = '" + bgafqp.getBgFormInfo().getId().toString() + "')");
        }
        return sql;
    }

    protected Map _getBgFormItemValues(Context ctx, Map orgs, Object bgAnalyseParam, boolean isFiling) throws BOSException, EASBizException {
        Map itemValue = new HashMap();
        if (orgs == null || orgs.size() < 1 || bgAnalyseParam == null) {
            return null;
        }
        BgAnalyseFormQueryParam bgFormQueryParam = null;
        if (bgAnalyseParam instanceof BgAnalyseFormQueryParam) {
            bgFormQueryParam = (BgAnalyseFormQueryParam)bgAnalyseParam;
            String[] org = new String[orgs.size()];
            int n = 0;
            Iterator keyIteraotr = orgs.keySet().iterator();
            while (keyIteraotr.hasNext()) {
                org[n] = (String)keyIteraotr.next();
                ++n;
            }
            itemValue = this.getBgItemValue(ctx, org, bgFormQueryParam);
        }
        return itemValue;
    }

    @Override
    protected Map _getBgFormItemValues(Context ctx, Map orgs, Object bgAnalyseParam) throws BOSException, EASBizException {
        Map itemValue = new HashMap();
        if (orgs == null || orgs.size() < 1 || bgAnalyseParam == null) {
            return null;
        }
        BgAnalyseFormQueryParam bgFormQueryParam = null;
        if (bgAnalyseParam instanceof BgAnalyseFormQueryParam) {
            bgFormQueryParam = (BgAnalyseFormQueryParam)bgAnalyseParam;
            String[] org = new String[orgs.size()];
            int n = 0;
            Iterator keyIteraotr = orgs.keySet().iterator();
            while (keyIteraotr.hasNext()) {
                org[n] = (String)keyIteraotr.next();
                ++n;
            }
            itemValue = this.getBgItemValue(ctx, org, bgFormQueryParam);
        }
        return itemValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getBgItemValue(Context ctx, String[] orgIds, BgAnalyseFormQueryParam bgFormQueryParam) throws BgException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        String[] filter;
        HashMap<String, BigDecimal> itemNValues;
        HashMap<String, BigDecimal> itemValues;
        block16: {
            itemValues = new HashMap<String, BigDecimal>();
            itemNValues = new HashMap<String, BigDecimal>();
            filter = new String[4];
            conn = null;
            pstmt = null;
            rst = null;
            filter = this.getBgSchemeAndBgTemplate(ctx, bgFormQueryParam, filter);
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select fformula from T_BG_Bgdata where FBgSchemeID in (select fid from t_bg_bgscheme where frootid = ?) AND FBgTemplateID in (select fid from t_bg_bgtemplate where frootid = ? ) and forgunitid in " + BgHelper.tranArray2StringExcept(orgIds) + " " + this.addBgPeriods(ctx, new StringBuffer(" "), bgFormQueryParam).toString());
            pstmt.setString(1, filter[0]);
            pstmt.setString(2, filter[1]);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                itemValues.put((String)rst.getObject("fformula"), new BigDecimal("0"));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (itemValues.size() >= 1) break block16;
            HashMap<String, BigDecimal> hashMap = itemValues;
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return hashMap;
        }
        try {
            String[] formulasCut = null;
            int itemN = itemValues.size();
            int n = 0;
            while (n * 500 - 1 <= itemN) {
                rst = null;
                formulasCut = new String[500];
                formulasCut = this.mapToString(itemValues, n);
                try {
                    pstmt = conn.prepareStatement("select fformula, fbgvalue, forgunitid from T_BG_Bgdata where FBgSchemeID in (select fid from t_bg_bgscheme where frootid = ?)   and forgunitid in " + BgHelper.tranArray2StringExcept(orgIds) + " " + this.addBgPeriods(ctx, new StringBuffer(" "), bgFormQueryParam).toString() + " and fformula in " + BgHelper.tranArray2StringExcept(formulasCut));
                    pstmt.setString(1, filter[0]);
                    rst = pstmt.executeQuery();
                    if (bgFormQueryParam.isCol()) {
                        while (rst.next()) {
                            if (itemNValues.containsKey((String)rst.getObject("fformula"))) {
                                itemNValues.put((String)rst.getObject("fformula"), ((BigDecimal)itemNValues.get((String)rst.getObject("fformula"))).add((BigDecimal)rst.getObject("fbgvalue")));
                                continue;
                            }
                            itemNValues.put((String)rst.getObject("fformula"), (BigDecimal)rst.getObject("fbgvalue"));
                        }
                    } else {
                        while (rst.next()) {
                            if (itemNValues.containsKey((String)rst.getObject("fformula") + "!" + (String)rst.getObject("forgunitid"))) {
                                itemNValues.put((String)rst.getObject("fformula") + "!" + (String)rst.getObject("forgunitid"), ((BigDecimal)itemNValues.get((String)rst.getObject("fformula") + "!" + (String)rst.getObject("forgunitid"))).add((BigDecimal)rst.getObject("fbgvalue")));
                                continue;
                            }
                            itemNValues.put((String)rst.getObject("fformula") + "!" + (String)rst.getObject("forgunitid"), (BigDecimal)rst.getObject("fbgvalue"));
                        }
                    }
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                }
                ++n;
            }
        }
        catch (Exception ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return itemNValues;
    }

    private String[] mapToString(Map itemValues, int n) {
        String[] formulas = new String[500];
        Iterator iter = itemValues.keySet().iterator();
        for (int i = 0; iter.hasNext() && i < 500; ++i) {
            formulas[i] = (String)iter.next();
        }
        for (int m = 0; m < 500; ++m) {
            if (formulas[m] == null) continue;
            itemValues.remove(formulas[m]);
        }
        return formulas;
    }

    private String[] getBgSchemeAndBgTemplate(Context ctx, BgAnalyseFormQueryParam bgFormQueryParam, String[] filter) throws BOSException, EASBizException {
        String bgFormId = bgFormQueryParam.getBgFormInfo().getId().toString();
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        BgFormInfo info = iBgForm.getBgFormInfo("select bgScheme.rootId, bgScheme.id, bgTemplate.rootId, bgTemplate.id where id = '" + bgFormId + "'");
        filter[0] = info.getBgScheme().getRootId().toString();
        filter[1] = info.getBgTemplate().getRootId().toString();
        filter[2] = info.getBgScheme().getId().toString();
        filter[3] = info.getBgTemplate().getId().toString();
        return filter;
    }

    @Override
    protected Map _getTableWithOrgs(Context ctx, Object bgAnalyseParam, Map tables, boolean isCol) throws BOSException, EASBizException {
        if (bgAnalyseParam == null) {
            return null;
        }
        boolean isHaveUserPeriod = true;
        BgAnalyseFormQueryParam bgFormQueryParam = null;
        if (bgAnalyseParam instanceof BgAnalyseFormQueryParam) {
            bgFormQueryParam = (BgAnalyseFormQueryParam)bgAnalyseParam;
            if (bgFormQueryParam.getBgPeriodBegin() == null && bgFormQueryParam.getBgPeriodEnd() == null) {
                BgFormInfo info;
                isHaveUserPeriod = false;
                if (bgFormQueryParam.getBgFormInfo().getBgPeriod() == null && (info = BgFormFactory.getLocalInstance(ctx).getBgFormInfo("select bgPeriod.* where id = '" + bgFormQueryParam.getBgFormInfo().getId() + "'")) != null) {
                    bgFormQueryParam.getBgFormInfo().setBgPeriod(info.getBgPeriod());
                }
                bgFormQueryParam.setBgPeriodBegin(bgFormQueryParam.getBgFormInfo().getBgPeriod());
                bgFormQueryParam.setBgPeriodEnd(bgFormQueryParam.getBgFormInfo().getBgPeriod());
            } else {
                isHaveUserPeriod = true;
            }
            String[] org = new String[1];
            Iterator keyIteraotr = tables.keySet().iterator();
            while (keyIteraotr.hasNext()) {
                org[0] = ((String)keyIteraotr.next()).replaceAll("Collect", "");
            }
            tables = this.getBgTableValue(ctx, org, bgFormQueryParam, isCol, isHaveUserPeriod);
        }
        return tables;
    }

    private Map getBgTableValue(Context ctx, String[] org, BgAnalyseFormQueryParam bgFormQueryParam, boolean isCol, boolean isHaveUserPeriod) throws BgException {
        Map<String, Book> tables = new HashMap();
        String[] filter = new String[4];
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String bgFormId = bgFormQueryParam.getBgFormInfo().getId().toString();
        try {
            StringBuffer sql;
            int in;
            ArrayList<Object> _tmpList;
            conn = this.getConnection(ctx);
            filter = this.getBgSchemeAndBgTemplate(ctx, bgFormQueryParam, filter);
            Map orgUnitIds = new HashMap();
            orgUnitIds = this.getHaveFormOrgIdsWithBgFormIdsBgPeriod(ctx, bgFormQueryParam, orgUnitIds);
            BgAnalyseFormQueryParam bfq = bgFormQueryParam;
            IBgForm ibg = BgFormFactory.getLocalInstance(ctx);
            ObjectStringPK iopk = new ObjectStringPK(bfq.getBgFormInfo().getId().toString());
            BgFormInfo bf = ibg.getBgFormInfo((IObjectPK)iopk);
            String bgItemGroupID = null;
            String bgItemID = null;
            boolean isSpecialForm = false;
            if (bf.getBgItemGroup() != null && bf.getBgItem() != null && bf.getBgItemGroup().getId() != null && bf.getBgItem().getId() != null) {
                isSpecialForm = true;
                bgItemGroupID = bf.getBgItemGroup().getId().toString();
                bgItemID = bf.getBgItem().getId().toString();
            }
            if (orgUnitIds.isEmpty() || orgUnitIds.size() < 0) {
                _tmpList = new ArrayList<Object>();
                _tmpList.add(filter[0]);
                _tmpList.add(filter[1]);
                in = org.length;
                for (int i = 0; i < in; ++i) {
                    _tmpList.add(org[i]);
                }
                _tmpList.add(bf.getBgPeriod().getId().toString());
                _tmpList.add(bgFormQueryParam.getBgFormInfo().getCurrency().getId().toString());
                _tmpList.add(new Integer(4));
                _tmpList.add(new Integer(15));
                _tmpList.add(new Integer(5));
                sql = new StringBuffer("select FCreatorID, fid, fdata, forgunitid, FMeasureUnitID, fbgSchemeid,fbgtemplateid from t_bg_bgform where FBgSchemeID in (select fid from t_bg_bgscheme where frootid = ?) AND FBgTemplateID in (select fid from t_bg_bgtemplate where frootid = ? ) and forgunitid in (" + BgNSQLHelper.getParamSizeString((int)org.length) + ")  and fbgperiodid = ?  and fCurrencyid = ?  and (FState <> ?  and FState <> ? and FState <> ?)");
                if (isSpecialForm) {
                    sql.append(" and FBgItemGroupID = ? and FBgItemID = ? ");
                    _tmpList.add(bgItemGroupID);
                    _tmpList.add(bgItemID);
                }
                sql.append(" order by fversionno desc");
                pstmt = conn.prepareStatement(sql.toString());
                BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            } else {
                _tmpList = new ArrayList();
                _tmpList.add(filter[0]);
                _tmpList.add(filter[1]);
                in = org.length;
                for (int i = 0; i < in; ++i) {
                    _tmpList.add(org[i]);
                }
                sql = new StringBuffer("select FCreatorID,fid, fdata, forgunitid, FMeasureUnitID, fbgSchemeid,fbgtemplateid from t_bg_bgform where FBgSchemeID in (select fid from t_bg_bgscheme where frootid = ?) AND FBgTemplateID in (select fid from t_bg_bgtemplate where frootid = ? ) and forgunitid in (" + BgNSQLHelper.getParamSizeString((int)org.length) + ")  and fbgperiodid = ? and fCurrencyid = ?  and (FState <> ? and FState <> ? and FState <> ?)");
                _tmpList.add(bf.getBgPeriod().getId().toString());
                _tmpList.add(bgFormQueryParam.getBgFormInfo().getCurrency().getId().toString());
                _tmpList.add(new Integer(4));
                _tmpList.add(new Integer(15));
                _tmpList.add(new Integer(5));
                if (isSpecialForm) {
                    sql.append(" and FBgItemGroupID = ? and FBgItemID = ? ");
                    _tmpList.add(bgItemGroupID);
                    _tmpList.add(bgItemID);
                }
                sql.append(" order by fversionno desc");
                pstmt = conn.prepareStatement(sql.toString());
                BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            }
            rst = pstmt.executeQuery();
            Book book = null;
            SimpleTimer time = new SimpleTimer();
            String oneFormId = null;
            String orgId = null;
            HashMap queryOrg = new HashMap();
            String oneTemplateId = null;
            String oneSchemeId = null;
            String formCreatId = null;
            while (rst.next()) {
                oneFormId = rst.getString("fid");
                orgId = rst.getString("forgunitid");
                oneSchemeId = rst.getString("fbgschemeid");
                oneTemplateId = rst.getString("fbgtemplateid");
                formCreatId = rst.getString("FCreatorID");
                if (tables.containsKey(orgId) || tables.containsKey(orgId + "Collect")) continue;
                if (isCol && filter[2].equals(oneSchemeId) && filter[3].equals(oneTemplateId)) {
                    if (!oneFormId.equals(bgFormId)) continue;
                    book = this.inputDataToTable(ctx, bgFormId, bgFormQueryParam, rst.getBytes("fdata"), queryOrg);
                    tables.put(orgId + "Collect", book);
                    continue;
                }
                HashMap<String, BigDecimal> measMap = new HashMap<String, BigDecimal>();
                BigDecimal measCoef = new BigDecimal("1");
                IBgMeasureUnit ibgMeas = BgMeasureUnitFactory.getLocalInstance(ctx);
                BgMeasureUnitCollection measrue = ibgMeas.getBgMeasureUnitCollection("where bgForm.id = '" + oneFormId + "'");
                IMeasureUnit iMeas = MeasureUnitFactory.getLocalInstance((Context)ctx);
                MeasureUnitInfo meas = iMeas.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)rst.getString("FMeasureUnitID"))));
                for (int m = 0; m < measrue.size(); ++m) {
                    measMap.put(measrue.get(m).getBgElement().getNumber(), measrue.get(m).getMeasureUnit().getCoefficient());
                }
                if (meas != null) {
                    measCoef = meas.getCoefficient();
                }
                book = null;
                book = this.dealStyleOfTable(ctx, rst.getBytes("fdata"), bgFormQueryParam, orgId, measMap, measCoef, isHaveUserPeriod, oneFormId);
                Sheet _sheet = null;
                boolean isSheetPer = BgSHelper.isBgSheetPermissionUsed(ctx);
                Map sheetPer = null;
                if (isSheetPer) {
                    sheetPer = this.addBgSheetPermission(ctx, rst.getString("fbgtemplateid"));
                }
                String user = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                boolean isShowSheet = false;
                if (book != null) {
                    int sheetIndex = 0;
                    int sheetSize = book.getSheetCount();
                    for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                        _sheet = book.getSheet(sheetIndex);
                        if (isSheetPer) {
                            if (!isShowSheet) {
                                isShowSheet = this.hideSheet(ctx, _sheet, sheetPer, user, formCreatId);
                                continue;
                            }
                            this.hideSheet(ctx, _sheet, sheetPer, user, formCreatId);
                            continue;
                        }
                        _sheet.setHide(false);
                    }
                }
                if (isSheetPer && !isShowSheet) {
                    book = null;
                }
                tables.put(orgId, book);
            }
            tables = this.zipDataToTables(ctx, tables, bgFormQueryParam);
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"getBgTableValue :", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return tables;
    }

    private Map getBgFormValues(Context ctx, String bgFormId) throws SQLException, BOSException {
        if (StringUtils.isEmpty((String)bgFormId)) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(bgFormId);
        Map map = this.getBgFormValues(ctx, list);
        return (Map)map.get(bgFormId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getBgFormValues(Context ctx, List bgFormIdList) throws SQLException, BOSException {
        if (bgFormIdList == null || bgFormIdList.isEmpty()) {
            return null;
        }
        Object[] bgFormIds = bgFormIdList.toArray();
        HashMap bgFormIdDatas = new HashMap();
        int batchCount = BgNSQLHelper.getBatchCount((Object[])bgFormIds);
        StringBuffer sql = new StringBuffer();
        sql.append("Select FBgFormId, FFormula, FBgValue From t_bg_bgdata Where FBgFormId in (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql).append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < batchCount; ++i) {
                BgNSQLHelper.setParam4BatchDefCount((PreparedStatement)pstmt, (int)1, (int)i, (Object[])bgFormIds);
                res = pstmt.executeQuery();
                while (res.next()) {
                    String bgFormId = res.getString("FBgFormId");
                    String formula = res.getString("FFormula");
                    BigDecimal value = res.getBigDecimal("FBgValue");
                    BgViewCommonHelper.getSubMap(bgFormIdDatas, (String)bgFormId, (boolean)true).put(formula, value);
                }
                SQLUtils.cleanup((ResultSet)res);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(res, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        return bgFormIdDatas;
    }

    private boolean hideSheet(Context ctx, Sheet _sheet, Map sheetPer, String user, String formCreatId) {
        return BgFSHelper.hideSheet(ctx, _sheet, sheetPer, user, formCreatId);
    }

    private Map addBgSheetPermission(Context ctx, String temId) {
        if (temId == null) {
            return null;
        }
        Map hasPer = new HashMap<String, Object>();
        Map sheetPer = new HashMap();
        try {
            hasPer.put(temId, null);
            hasPer = BgPermissionHelper.getBgTemplateSheetPermission((Context)ctx, hasPer);
            if (hasPer != null && hasPer.get(temId) != null) {
                sheetPer = (Map)hasPer.get(temId);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return sheetPer;
    }

    private Book inputDataToTable(Context ctx, String bgformid, BgAnalyseFormQueryParam bgFormQueryParam, byte[] bs, Map queryOrg) throws Exception {
        int i;
        String decFormat = null;
        Map itemDatas = new HashMap();
        HashMap itemFormulas = new HashMap();
        Book book = IOHelper.unpackBook((byte[])bs);
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        HashMap<String, String> decFormatMap = new HashMap<String, String>();
        OrgUnitInfo[] orgUnits = null;
        ICurrency iCu = null;
        CurrencyInfo currInfo3 = null;
        CurrencyInfo currInfo2 = null;
        CurrencyCollection col = null;
        Sheet sheet = null;
        Cell cell = null;
        String formulaString = null;
        String[] formulaParamArray = null;
        orgUnits = BgAnalyseFacadeFactory.getLocalInstance(ctx).getHaveFormOrg(bgFormQueryParam);
        orgUnits = this.withoutMidOrg(orgUnits, bgFormQueryParam);
        orgUnits = this.withoutNull(orgUnits);
        bgFormQueryParam.setOrgUnits(orgUnits);
        try {
            StyleAttributes sa = Styles.getEmptySA();
            sa.setLocked(true);
            sa.setBackground(Color.WHITE);
            String currencyNumber = bgFormQueryParam.getCurrency().getNumber();
            for (i = 0; i < orgUnits.length; ++i) {
                itemDatas.put(orgUnits[i].getId().toString(), null);
                queryOrg.put(orgUnits[i].getId().toString(), null);
            }
            itemDatas = BgAnalyseFacadeFactory.getLocalInstance(ctx).getBgFormItemValues(itemDatas, bgFormQueryParam);
            if (bgFormQueryParam.getBgPeriodBegin() != null && bgFormQueryParam.getBgPeriodEnd() != null) {
                this.collectItems(itemDatas, itemFormulas, currencyNumber);
            }
            iCu = CurrencyFactory.getLocalInstance((Context)ctx);
            currInfo2 = iCu.getCurrencyInfo((IObjectPK)new ObjectUuidPK(bgFormQueryParam.getCurrency().getId()));
            for (int n = 0; n < book.getSheetCount(); ++n) {
                sheet = book.getSheet(n);
                if (sheet == null) continue;
                StyleAttributes cellSa = Styles.getEmptySA();
                cellSa.setLocked(true);
                for (int i2 = sheet.getMaxColIndex(); i2 >= 0; --i2) {
                    for (int j = sheet.getMaxRowIndex(); j >= 0; --j) {
                        cell = sheet.getCell(j, i2, false);
                        if (BgNFSHelper.checkHasExpression((Cell)cell) && !BgNFSHelper.isSimpleExpression((Cell)cell, (String)cell.getFormula())) {
                            Variant value = cell.getValue();
                            BgNFSHelper.clearExpression((Cell)cell, (int)0);
                            BgNFSHelper.clearExpression((Cell)cell);
                            BgNFSHelper.setValue((Cell)cell, (Object)value);
                        }
                        if ((formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell)) != null && itemFormulas.containsKey(formulaString)) {
                            BgNFSHelper.setValue((Cell)cell, (Object)((BigDecimal)itemFormulas.get(formulaString)));
                        }
                        if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                            formulaParamArray = BgFillHelper.parseStrFormulaToArray(formulaString);
                            if (!decFormatMap.containsKey(formulaParamArray[5])) {
                                col = iCu.getCurrencyCollection(true);
                                if (col != null) {
                                    for (CurrencyInfo currInfo3 : col) {
                                        decFormat = "#,##0." + BgAnalyseFacadeControllerBean.getNumberFormat("0", currInfo3.getPrecision());
                                        decFormatMap.put(currInfo3.getNumber(), decFormat);
                                    }
                                }
                            } else {
                                decFormat = (String)decFormatMap.get(formulaParamArray[5]);
                            }
                            cellSa.setNumberFormat(decFormat);
                            cell.getSheet().getRange(cell).setStyle(cellSa, Styles.getEmptySA());
                            if (bgFormQueryParam.getBgPeriodBegin() != null && bgFormQueryParam.getBgPeriodEnd() != null) {
                                BgNFSHelper.setValue((Cell)cell, (Object)((BigDecimal)itemFormulas.get(this.formulaWithoutPeriod(formulaString, currencyNumber))));
                                continue;
                            }
                            if (!itemDatas.containsKey(formulaString)) continue;
                            BgNFSHelper.setValue((Cell)cell, (Object)((BigDecimal)itemDatas.get(formulaString)));
                            continue;
                        }
                        if (BgNFSHelper.checkIsNumericOfCell((Cell)cell) && cell.getValue() != null) {
                            decFormat = "#,##0." + BgAnalyseFacadeControllerBean.getNumberFormat("0", currInfo2.getPrecision());
                            try {
                                BgNFSHelper.setValue((Cell)cell, (Object)((BigDecimal)BgNFSHelper.getValue((Cell)cell)));
                                cellSa.setNumberFormat(decFormat);
                                cell.getSheet().getRange(cell).setStyle(cellSa, Styles.getEmptySA());
                            }
                            catch (Exception e) {
                                BgNFSHelper.setValue((Cell)cell, (Object)BgNFSHelper.getValue((Cell)cell));
                            }
                            continue;
                        }
                        BgNFSHelper.setValue((Cell)cell, (Object)BgNFSHelper.getValue((Cell)cell));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BgException(BgException.DATABASEERROR, new String[]{e.getMessage()});
        }
        finally {
            if (bgFormQueryParam.getBgPeriodBegin() != null && bgFormQueryParam.getBgPeriodEnd() != null) {
                itemDatas.clear();
            }
        }
        if (book != null) {
            book.calc();
            for (int n = 0; n < book.getSheetCount(); ++n) {
                sheet = book.getSheet(n);
                if (sheet == null) continue;
                StyleAttributes cellSa = Styles.getEmptySA();
                cellSa.setLocked(true);
                for (i = sheet.getMaxColIndex(); i >= 0; --i) {
                    for (int j = sheet.getMaxRowIndex(); j >= 0; --j) {
                        cell = sheet.getCell(j, i, false);
                        if (BgNFSHelper.checkHasExpression((Cell)cell) && !BgNFSHelper.isSimpleExpression((Cell)cell, (String)cell.getFormula())) {
                            Variant value = cell.getValue();
                            BgNFSHelper.clearExpression((Cell)cell, (int)0);
                            BgNFSHelper.clearExpression((Cell)cell);
                            BgNFSHelper.setValue((Cell)cell, (Object)value);
                        }
                        if ((formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell)) != null && itemFormulas.containsKey(formulaString)) {
                            BgNFSHelper.setValue((Cell)cell, (Object)((BigDecimal)itemFormulas.get(formulaString)));
                        }
                        if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                            formulaParamArray = BgFillHelper.parseStrFormulaToArray(formulaString);
                            if (!decFormatMap.containsKey(formulaParamArray[5])) {
                                col = iCu.getCurrencyCollection(true);
                                if (col != null) {
                                    for (CurrencyInfo currInfo3 : col) {
                                        decFormat = "#,##0." + BgAnalyseFacadeControllerBean.getNumberFormat("0", currInfo3.getPrecision());
                                        decFormatMap.put(currInfo3.getNumber(), decFormat);
                                    }
                                }
                            } else {
                                decFormat = (String)decFormatMap.get(formulaParamArray[5]);
                            }
                            cellSa.setNumberFormat(decFormat);
                            cell.getSheet().getRange(cell).setStyle(cellSa, Styles.getEmptySA());
                            String currencyNumber = bgFormQueryParam.getCurrency().getNumber();
                            if (bgFormQueryParam.getBgPeriodBegin() != null && bgFormQueryParam.getBgPeriodEnd() != null) {
                                BgNFSHelper.setValue((Cell)cell, (Object)((BigDecimal)itemFormulas.get(this.formulaWithoutPeriod(formulaString, currencyNumber))));
                                continue;
                            }
                            BgNFSHelper.setValue((Cell)cell, (Object)((BigDecimal)itemDatas.get(formulaString)));
                            continue;
                        }
                        if (BgNFSHelper.checkIsNumericOfCell((Cell)cell) && cell.getValue() != null) {
                            decFormat = "#,##0." + BgAnalyseFacadeControllerBean.getNumberFormat("0", currInfo2.getPrecision());
                            try {
                                BgNFSHelper.setValue((Cell)cell, (Object)((BigDecimal)BgNFSHelper.getValue((Cell)cell)));
                                cellSa.setNumberFormat(decFormat);
                                cell.getSheet().getRange(cell).setStyle(cellSa, Styles.getEmptySA());
                            }
                            catch (Exception e) {
                                BgNFSHelper.setValue((Cell)cell, (Object)BgNFSHelper.getValue((Cell)cell));
                            }
                            continue;
                        }
                        BgNFSHelper.setValue((Cell)cell, (Object)BgNFSHelper.getValue((Cell)cell));
                    }
                }
            }
        }
        return book;
    }

    private String formulaWithoutPeriod(String formulaString, String currencyNumber) {
        String itemString = this.rebuildFormula(BgFillHelper.parseStrFormulaToArray(formulaString), currencyNumber, "%");
        return itemString;
    }

    private void collectItems(Map itemDatas, Map itemFormulas, String currencyNumber) {
        for (String formulaString : itemDatas.keySet()) {
            String itemString = this.rebuildFormula(BgFillHelper.parseStrFormulaToArray(formulaString), currencyNumber, "%");
            if (itemFormulas.containsKey(itemString)) {
                itemFormulas.put(itemString, ((BigDecimal)itemFormulas.get(itemString)).add((BigDecimal)itemDatas.get(formulaString)));
                continue;
            }
            itemFormulas.put(itemString, (BigDecimal)itemDatas.get(formulaString));
        }
    }

    private OrgUnitInfo[] withoutMidOrg(OrgUnitInfo[] org, BgAnalyseFormQueryParam bgFormQueryParam) {
        String longNum;
        int i;
        String orgNum = "";
        org = (OrgUnitInfo[])bgFormQueryParam.getOrgUnits().clone();
        for (i = org.length - 1; i >= 0; --i) {
            longNum = org[i].getLongNumber();
            if (orgNum.lastIndexOf(longNum + "!") >= 0) continue;
            orgNum = orgNum + longNum;
        }
        for (i = org.length - 1; i >= 0; --i) {
            longNum = org[i].getLongNumber();
            if (orgNum.lastIndexOf(longNum + "!") < 0) continue;
            org[i] = null;
        }
        return org;
    }

    private OrgUnitInfo[] withoutNull(OrgUnitInfo[] orgCol) {
        Vector<OrgUnitInfo> orgs = new Vector<OrgUnitInfo>();
        OrgUnitInfo[] orgInfos = null;
        for (int i = 0; i < orgCol.length; ++i) {
            if (orgCol[i] == null) continue;
            orgs.add(orgCol[i]);
        }
        if (orgs.size() > 0) {
            orgInfos = new OrgUnitInfo[orgs.size()];
            for (int j = 0; j < orgs.size(); ++j) {
                orgInfos[j] = (OrgUnitInfo)orgs.get(j);
            }
        }
        return orgInfos;
    }

    private Map zipDataToTables(Context ctx, Map tables, BgAnalyseFormQueryParam bgFormQueryParam) throws EASBizException, BOSException {
        for (String orgId : tables.keySet()) {
            Book table = (Book)tables.get(orgId);
            if (table == null) {
                throw new BgException(BgException.DATABASEERROR, new String[]{"table is null;"});
            }
            try {
                byte[] tableBytes = IOHelper.packBook((Book)table);
                tables.put(orgId, tableBytes);
            }
            catch (IOException e) {
                throw new BgException(BgException.DATABASEERROR, new String[]{e.getMessage()});
            }
        }
        return tables;
    }

    private Book dealStyleOfTable(Context ctx, byte[] data, BgAnalyseFormQueryParam bgFormQueryParam, String orgUnitId, Map measMap1, BigDecimal measCoef, boolean isHaveUserPeriod, String bgFormId) throws Exception {
        ICurrency iCu = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo currInfo = null;
        String decFormat = null;
        HashMap<String, String> decFormapMap = new HashMap<String, String>();
        String orgId = orgUnitId;
        HashMap<String, Object> orgs = new HashMap<String, Object>();
        orgs.put(orgId, null);
        Map itemValue = this._getBgFormItemValues(ctx, orgs, bgFormQueryParam, false);
        Map bgFormValue = null;
        if (!isHaveUserPeriod) {
            bgFormValue = this.getBgFormValues(ctx, bgFormId);
        }
        Map itemFormulas = null;
        itemFormulas = bgFormQueryParam.getBgPeriodBegin() != null && bgFormQueryParam.getBgPeriodEnd() != null ? this.collectItems(itemValue, bgFormQueryParam) : itemValue;
        Book book = IOHelper.unpackBook((byte[])data);
        book.setCalculate(false);
        Sheet[] sheet = null;
        if (book != null) {
            sheet = new Sheet[book.getSheetCount()];
            int n = book.getSheetCount();
            for (int i = 0; i < n; ++i) {
                sheet[i] = book.getSheet(i);
            }
        }
        if (sheet == null) {
            return null;
        }
        for (int n = 0; n < sheet.length; ++n) {
            if (sheet[n] == null) continue;
            StyleAttributes sa = Styles.getEmptySA();
            sa.setLocked(true);
            Cell cell = null;
            sheet[n].getSheetRange().setStyle(sa, Styles.getEmptySA());
            StyleAttributes cellSa = Styles.getEmptySA();
            cellSa.setLocked(true);
            String currencyNumber = bgFormQueryParam.getCurrency().getNumber();
            String itemFormula = null;
            for (int i = 0; i <= sheet[n].getMaxRowIndex(); ++i) {
                for (int j = 0; j <= sheet[n].getMaxColIndex(); ++j) {
                    BigDecimal num;
                    cell = sheet[n].getCell(i, j, false);
                    if (cell == null) continue;
                    String[] formulaParamArray = null;
                    if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                        String formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell);
                        formulaParamArray = BgFillHelper.parseStrFormulaToArray(formulaString);
                        if (isHaveUserPeriod) {
                            itemFormula = this.rebuildFormula(formulaParamArray, currencyNumber, "%");
                            BgNFSHelper.setFormulaOfCell((Cell)cell, (String)itemFormula);
                        }
                        if (formulaParamArray != null && formulaParamArray[5] != null) {
                            if (!decFormapMap.containsKey(formulaParamArray[5])) {
                                CurrencyCollection col = iCu.getCurrencyCollection("where number = '" + formulaParamArray[5] + "'");
                                if (col != null && col.get(0) != null) {
                                    currInfo = col.get(0);
                                }
                                if (currInfo != null) {
                                    decFormat = "#,##0." + BgAnalyseFacadeControllerBean.getNumberFormat("0", currInfo.getPrecision());
                                    decFormapMap.put(currInfo.getNumber(), decFormat);
                                }
                            }
                            decFormat = (String)decFormapMap.get(formulaParamArray[5]);
                        } else {
                            currInfo = iCu.getCurrencyInfo((IObjectPK)new ObjectUuidPK(bgFormQueryParam.getCurrency().getId()));
                            if (!decFormapMap.containsKey(currInfo.getNumber())) {
                                decFormat = "#,##0." + BgAnalyseFacadeControllerBean.getNumberFormat("0", currInfo.getPrecision());
                                decFormapMap.put(currInfo.getNumber(), decFormat);
                            }
                            decFormat = (String)decFormapMap.get(currInfo.getNumber());
                        }
                    }
                    if (decFormat != null && cellSa != null && cell.getStyle().getNumberFormat().indexOf("%") < 0) {
                        cellSa.setNumberFormat(decFormat);
                    } else if (cell.getStyle().getNumberFormat().indexOf("%") >= 0) {
                        cellSa.setNumberFormat(cell.getStyle().getNumberFormat());
                    }
                    String dataFormula = BgNFSHelper.getFormulaOfCell((Cell)cell);
                    if (dataFormula != null) {
                        cell.getSheet().getRange(cell).setStyle(cellSa, Styles.getEmptySA());
                        if (isHaveUserPeriod && itemFormulas.containsKey(dataFormula)) {
                            try {
                                if (!isHaveUserPeriod) continue;
                                num = new BigDecimal(itemFormulas.get(dataFormula).toString());
                                BgNFSHelper.setValue((Cell)cell, (Object)num);
                            }
                            catch (Exception e) {
                                BgNFSHelper.setValue((Cell)cell, null);
                            }
                            continue;
                        }
                        if (!isHaveUserPeriod && bgFormValue != null && bgFormValue.containsKey(dataFormula)) {
                            BgNFSHelper.setValue((Cell)cell, bgFormValue.get(dataFormula));
                            continue;
                        }
                        BgNFSHelper.setValue((Cell)cell, (Object)BgConstants.BIGZERO);
                        continue;
                    }
                    if (BgNFSHelper.checkHasTextOfCell((Cell)cell)) continue;
                    if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell) && cell.getValue() != Variant.nullVariant) {
                        try {
                            cell.getSheet().getRange(cell).setStyle(cellSa, Styles.getEmptySA());
                            num = new BigDecimal(cell.getValue().toString());
                            BgNFSHelper.setValue((Cell)cell, (Object)num);
                        }
                        catch (Exception e) {
                            BgNFSHelper.setValue((Cell)cell, null);
                        }
                        continue;
                    }
                    if (BgNFSHelper.checkIsNumericOfCell((Cell)cell) && cell.getValue() != Variant.nullVariant) {
                        try {
                            try {
                                num = new BigDecimal(BgNFSHelper.getValue((Cell)cell).toString());
                                BgNFSHelper.setValue((Cell)cell, (Object)num);
                            }
                            catch (Exception e) {
                                BgNFSHelper.setValue((Cell)cell, (Object)BgNFSHelper.getValue((Cell)cell));
                            }
                        }
                        catch (Exception e) {
                            BgNFSHelper.setValue((Cell)cell, null);
                        }
                        continue;
                    }
                    if (cell.getValue() != Variant.nullVariant) continue;
                    BgNFSHelper.setValue((Cell)cell, null);
                }
            }
        }
        return book;
    }

    private String rebuildFormula(String[] formulaParamArray, String currencyNumber, String tempPeriodNumber) {
        if (formulaParamArray[5] != null) {
            currencyNumber = formulaParamArray[5];
        }
        return "=BgItem(\"" + formulaParamArray[0] + "\",\"" + tempPeriodNumber + "\",\"" + formulaParamArray[2] + "\",\"" + formulaParamArray[3] + "\",true,\"" + currencyNumber + "\")";
    }

    private Map collectItems(Map itemDatas, BgAnalyseFormQueryParam bgFormQueryParam) {
        HashMap<String, BigDecimal> itemFormulas = new HashMap<String, BigDecimal>();
        String currencyNumber = bgFormQueryParam.getCurrency().getNumber();
        String formulaString = null;
        String[] itemS = null;
        String itemString = null;
        Iterator keyIteraotr = itemDatas.keySet().iterator();
        while (keyIteraotr.hasNext()) {
            formulaString = null;
            itemS = null;
            itemString = null;
            formulaString = (String)keyIteraotr.next();
            itemS = BgFillHelper.parseStrFormulaToArray(formulaString);
            itemString = this.rebuildFormula(itemS, currencyNumber, "%");
            if (itemFormulas.containsKey(itemString)) {
                itemFormulas.put(itemString, ((BigDecimal)itemFormulas.get(itemString)).add((BigDecimal)itemDatas.get(formulaString)));
                continue;
            }
            itemFormulas.put(itemString, (BigDecimal)itemDatas.get(formulaString));
        }
        return itemFormulas;
    }

    public static String getNumberFormat(String str, int number) {
        if (str == null || number <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < number; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    protected BigDecimal convertValue(Map measureMap, Map currencyMap, String formulaStr, BigDecimal value) {
        if (measureMap == null || measureMap.isEmpty() || currencyMap == null || currencyMap.isEmpty()) {
            return value;
        }
        String[] parameter = null;
        if (formulaStr.indexOf("!") != -1) {
            formulaStr = formulaStr.split("\\!")[0];
        }
        parameter = BgNFSHelper.parseFormulaPara(null, (String)formulaStr);
        BigDecimal coefficient = null;
        int precision = -1;
        CurrencyInfo currencyInfo = null;
        if (parameter != null) {
            coefficient = !StringUtils.isEmpty((String)parameter[2]) && measureMap.containsKey(parameter[2]) ? (BigDecimal)measureMap.get(parameter[2]) : (BigDecimal)measureMap.get("DEFAULT_FORM");
            if (!StringUtils.isEmpty((String)parameter[5]) && currencyMap.containsKey(parameter[5])) {
                currencyInfo = (CurrencyInfo)currencyMap.get(parameter[5]);
                precision = currencyInfo.getPrecision();
            }
        }
        String valueStr = null;
        valueStr = this.getDisplayValue(value, coefficient, precision);
        if (valueStr != null) {
            return new BigDecimal(valueStr.replaceAll(",", ""));
        }
        return new BigDecimal("0");
    }

    protected Map getMeasureUnitMap(Context ctx, BgAnalyseFormQueryParam bgAnalyseParam) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> measureMap = new HashMap<String, BigDecimal>();
        BgMeasureUnitCollection col = null;
        BgFormInfo bgFormInfo = null;
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        bgFormInfo = iBgForm.getBgFormInfo("select measureUnit.coefficient where id = '" + bgAnalyseParam.getBgFormInfo().getId().toString() + "'");
        IBgMeasureUnit iBgMeasureUnit = BgMeasureUnitFactory.getLocalInstance(ctx);
        col = iBgMeasureUnit.getBgMeasureUnitCollection("select bgElement.number,bgElement.dataType,measureUnit.coefficient where bgForm.id = '" + bgAnalyseParam.getBgFormInfo().getId().toString() + "'");
        if (bgFormInfo == null) {
            throw new BgFormException(BgFormException.NOINSTANCE);
        }
        measureMap.put("DEFAULT_FORM", bgFormInfo.getMeasureUnit().getCoefficient());
        if (col != null) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                BgMeasureUnitInfo info = col.get(i);
                measureMap.put(info.getBgElement().getNumber(), info.getMeasureUnit().getCoefficient());
            }
        }
        return measureMap;
    }

    protected Map getCurrencyMap(Context ctx) throws BOSException, EASBizException {
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        CurrencyInfo currencyInfo2 = null;
        CurrencyCollection currencyCol = null;
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        if (iCurrency != null) {
            currencyCol = iCurrency.getCurrencyCollection();
            for (CurrencyInfo currencyInfo2 : currencyCol) {
                currencyMap.put(currencyInfo2.getNumber(), currencyInfo2);
            }
        } else {
            throw new BgFormException(BgFormException.NOINSTANCE);
        }
        return currencyMap;
    }

    protected String getDisplayValue(Object obj, BigDecimal coefficient, int precision) {
        String _text = null;
        BigDecimal _value = null;
        DecimalFormat _decFormat = null;
        try {
            _value = new BigDecimal(obj.toString().trim().replaceAll(",", "")).divide(coefficient, precision, 4);
            _decFormat = precision != 0 ? new DecimalFormat("#,##0." + BgNFSHelper.getNumberFormat((String)"0", (int)precision)) : new DecimalFormat("#,##0");
            _text = _decFormat.format(_value.doubleValue());
        }
        catch (Exception ex) {
            _text = obj.toString();
        }
        return _text;
    }

    @Override
    protected Map _queryBgItemData(Context ctx, BOSUuid orgUnitId, Object filterParam) throws BOSException, EASBizException {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (filterParam == null || !(filterParam instanceof BgItemAnalyseParam)) {
            return dataMap;
        }
        boolean hasBgItem = false;
        String _name = "FName_" + ctx.getLocale();
        String _key = null;
        String _orgUnitId = null;
        String _bgItemNumber = null;
        String _bgPeriodName = null;
        String _bgElementNumber = null;
        BigDecimal _bValue = null;
        BigDecimal _aValue = null;
        BigDecimal _sValue = null;
        List bgItemList = null;
        List<BgItemAnalyseInfo> tmpList = null;
        HashMap<String, Object> queryBgItemMap = new HashMap<String, Object>();
        HashMap tmpMap = new HashMap();
        OrgUnitInfo unitInfo2 = null;
        OrgUnitInfo[] unitInfos = null;
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodColl = null;
        BgItemAnalyseInfo info = null;
        BgItemAnalyseParam itemAnalyseParam = (BgItemAnalyseParam)filterParam;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        if (itemAnalyseParam.getBeginBgItem() != null && itemAnalyseParam.getEndBgItem() != null) {
            hasBgItem = true;
        }
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        StringBuffer tmpStr = null;
        sql.append("select d.FOrgUnitId, p." + _name + ", d.FBgValue, d.FBizActual, d.FBgActual, i.FKey, e.FNumber from T_BG_BgData d ");
        sql.append("left join T_BG_BgItemCombination i on d.FBgItemCombinId = i.FID ");
        sql.append("left join T_BG_BgPeriod p on d.FBgPeriodId = p.FID ");
        sql.append("left join T_BG_BgElement e on d.FBgElementId = e.FID ");
        sql.append("where ");
        if (orgUnitId != null) {
            sql.append("d.FOrgUnitId = ?");
            _tmpList.add(orgUnitId.toString());
        } else {
            sql.append("d.FOrgUnitId IN (");
            unitInfos = itemAnalyseParam.getOrgUnits();
            if (unitInfos != null) {
                for (OrgUnitInfo unitInfo2 : unitInfos) {
                    sql.append("?,");
                    _tmpList.add(unitInfo2.getId().toString());
                }
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (itemAnalyseParam.getBgScheme() != null) {
            sql.append(" and d.FBgSchemeId IN (select FID from T_BG_BgScheme where FRootId = ?)");
            _tmpList.add(itemAnalyseParam.getBgScheme().getRootId().toString());
        }
        if (itemAnalyseParam.getBgTemplateInfo() != null) {
            sql.append(" and d.FBgTemplateId IN (select FID from T_BG_BgTemplate where FRootId = ?)");
            _tmpList.add(itemAnalyseParam.getBgTemplateInfo().getRootId().toString());
        }
        if (itemAnalyseParam.getBgPeriodBegin() != null && itemAnalyseParam.getBgPeriodEnd() != null && (bgPeriodColl = BgPeriodHelper.getPeriodColInfo(ctx, itemAnalyseParam.getBgPeriodBegin().getBeginDate(), itemAnalyseParam.getBgPeriodEnd().getEndDate(), itemAnalyseParam.getBgPeriodBegin().getPeriodType().getValue())) != null) {
            sql.append(" and d.FBgPeriodId IN (");
            tmpStr = new StringBuffer();
            int in = bgPeriodColl.size();
            for (int i = 0; i < in; ++i) {
                bgPeriodInfo = bgPeriodColl.get(i);
                tmpStr.append("?,");
                _tmpList.add(bgPeriodInfo.getId().toString());
            }
            if (tmpStr.length() > 0) {
                tmpStr.delete(tmpStr.length() - 1, tmpStr.length());
            }
            sql.append(tmpStr).append(")");
        }
        if (itemAnalyseParam.getCurrency() != null) {
            sql.append(" and d.FCurrencyId = ?");
            _tmpList.add(itemAnalyseParam.getCurrency().getId().toString());
        }
        if (hasBgItem) {
            sql.append(" and i.FKey >= ?");
            sql.append(" and i.FKey <= ?");
            _tmpList.add(itemAnalyseParam.getBeginBgItem().getNumber().replaceAll(",", "_"));
            _tmpList.add(itemAnalyseParam.getEndBgItem().getNumber().replaceAll(",", "_"));
        }
        sql.append(" order by d.FOrgUnitId, p.FNumber, i.FKey, e.FNumber");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _orgUnitId = rst.getString("FOrgUnitId");
                _bgPeriodName = rst.getString(_name);
                _bValue = rst.getBigDecimal("FBgValue");
                _aValue = rst.getBigDecimal("FBgActual");
                _sValue = rst.getBigDecimal("FBizActual");
                _bgItemNumber = rst.getString("FKey").replaceAll("_", ",");
                _bgElementNumber = rst.getString("FNumber");
                queryBgItemMap.put(_bgItemNumber, null);
                if (dataMap.containsKey(_orgUnitId)) {
                    bgItemList = (List)dataMap.get(_orgUnitId);
                } else {
                    bgItemList = new ArrayList();
                    dataMap.put(_orgUnitId, bgItemList);
                    tmpMap.clear();
                }
                _key = _bgPeriodName + "_" + _bgItemNumber;
                if (tmpMap.containsKey(_key)) {
                    tmpList = (List)tmpMap.get(_key);
                } else {
                    tmpList = new ArrayList();
                    tmpMap.put(_key, tmpList);
                    bgItemList.add(tmpList);
                }
                info = new BgItemAnalyseInfo();
                info.setBgItemNumber(_bgItemNumber);
                info.setBgPeriodName(_bgPeriodName);
                info.setBgElementNumber(_bgElementNumber);
                info.setBValue(_bValue);
                info.setAValue(_aValue);
                info.setSValue(_sValue);
                tmpList.add(info);
            }
            dataMap.put("BGITEM_INFO", BgSHelper.getBgItemsInfo(ctx, queryBgItemMap, null, null, itemAnalyseParam.getOrgUnits()[0].getId().toString()));
            dataMap.put("BGELEMENT_INFO", BgSHelper.getBgElementInfo(ctx, null, null, null));
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"_queryBgItemData: ", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return dataMap;
    }

    @Override
    protected Map _queryExecuteData(Context ctx, String orgUnitId, Object filterParam) throws BOSException, EASBizException {
        if (orgUnitId == null || !(filterParam instanceof BgExecuteFilterParam)) {
            return new HashMap();
        }
        Map _dataMap = new HashMap();
        BgExecuteFilterParam _filterParam = (BgExecuteFilterParam)filterParam;
        _dataMap = this.queryBgDataInfo(ctx, orgUnitId, _filterParam);
        this.clearCtrlRecordInfo(_dataMap);
        this.calculator(ctx, _dataMap);
        return _dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void queryCtrlRecordInfoByBillSource(Context ctx, List bgAnalayseList, List queryBgDataList, String orgUnitId) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (bgAnalayseList == null) return;
        if (bgAnalayseList.isEmpty()) return;
        if (queryBgDataList == null) return;
        if (queryBgDataList.isEmpty()) {
            return;
        }
        BgExecuteAnalyseInfo info = null;
        BgExecuteAnalyseBillInfo billInfo = null;
        HashMap<String, BgExecuteAnalyseInfo> tmpMap = new HashMap<String, BgExecuteAnalyseInfo>();
        int in = bgAnalayseList.size();
        for (int i = 0; i < in; ++i) {
            info = (BgExecuteAnalyseInfo)bgAnalayseList.get(i);
            tmpMap.put(info.getBgDataId(), info);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchSize = 200;
        int size = queryBgDataList.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        String _key = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FCreateTime, FBgDataId, FBillId, FBillName, FBillNumber, FBillType, FBizDate, FActualAmount, FBgTraceType, FActualType ,FBillSourceOrgunitID   from T_BG_BgCtrlRecord where FBgDataId IN (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?) ");
        sql.append(" and FBillSourceOrgunitID = ? ");
        sql.append(" and FBgTraceType not in (4,6,7) ");
        sql.append(" order by FBizDate, FBillNumber, FBillType  ");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, (String)queryBgDataList.get(pos));
                        continue;
                    }
                    pstmt.setString(x, "#");
                }
                pstmt.setString(batchSize + 1, orgUnitId);
                try {
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _key = rst.getString("FBgDataId");
                        if (!tmpMap.containsKey(_key)) continue;
                        info = (BgExecuteAnalyseInfo)tmpMap.get(_key);
                        billInfo = new BgExecuteAnalyseBillInfo();
                        billInfo.setBillId(rst.getString("FBillId"));
                        billInfo.setBillName(rst.getString("FBillName"));
                        billInfo.setBillNumber(rst.getString("FBillNumber"));
                        billInfo.setBillType(rst.getString("FBillType"));
                        billInfo.setBusTime(rst.getTimestamp("FBizDate"));
                        billInfo.setProcTime(rst.getTimestamp("FCreateTime"));
                        billInfo.setValue(rst.getBigDecimal("FActualAmount"));
                        billInfo.setBillTypeEnum(rst.getInt("FBgTraceType"));
                        billInfo.setActualTypeEnum(rst.getInt("FActualType"));
                        billInfo.setBillSourceOrgunitID(rst.getString("FBillSourceOrgunitID"));
                        info.setBillSourceOrgunitID(rst.getString("FBillSourceOrgunitID"));
                        info.addBillInfo(billInfo);
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)"queryCtrlRecordInfo\uff1a ", (Throwable)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"queryCtrlRecordInfo\uff1a ", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map queryBgDataInfo(Context ctx, String orgUnitId, BgExecuteFilterParam filterParam) throws BOSException, EASBizException {
        HashMap<String, Object> _dataMap = new HashMap<String, Object>();
        if (ctx == null) return _dataMap;
        if (filterParam == null) {
            return _dataMap;
        }
        boolean isByBillSourceOrg = filterParam.isByBillSourceOrgunitQuery();
        HashSet<String> _bgItemSet = new HashSet<String>();
        HashSet<String> _bgPeriodSet = new HashSet<String>();
        HashSet<String> _bgElementSet = new HashSet<String>();
        HashSet<String> _currencySet = new HashSet<String>();
        HashSet<String> _bgDataIdSet = new HashSet<String>();
        HashSet<String> _groupNoSet = new HashSet<String>();
        ArrayList<BgExecuteAnalyseInfo> _tmpList = new ArrayList<BgExecuteAnalyseInfo>();
        ArrayList<String> sqlist = new ArrayList<String>();
        ArrayList<String> _bgDataId = new ArrayList<String>();
        ArrayList<BgExecuteAnalyseInfo> _InfoList = new ArrayList<BgExecuteAnalyseInfo>();
        BgSchemeInfo _bgSchemeInfo = filterParam.getBgScheme();
        BgFormInfo _bgFormInfo = filterParam.getBgFormInfo();
        BgPeriodInfo _beginPeriod = filterParam.getBgPeriodBegin();
        BgPeriodInfo _endPeriod = filterParam.getBgPeriodEnd();
        VisualItemInfo _beginItem = filterParam.getBeginBgItem();
        VisualItemInfo _endItem = filterParam.getEndBgItem();
        BgElementInfo _bgElementInfo = filterParam.getBgElementInfo();
        CurrencyInfo _currency = filterParam.getCurrency();
        String _bgFormula = filterParam.getBgFormula();
        boolean isView = false;
        if (_bgFormInfo != null) {
            BgTemplateInfo _temp = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateInfo("select fid, formType where id = '" + _bgFormInfo.getBgTemplate().getId() + "'");
            _bgFormInfo.getBgTemplate().setFormType(_temp.getFormType());
            isView = BgTemFormTypeEnum.VIEWFORM.equals((Object)_bgFormInfo.getBgTemplate().getFormType());
        }
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodColl = null;
        BgExecuteAnalyseInfo info = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer tmpSql = null;
        sql.append("select t.FID, t.FFormula, t.FOrgUnitId, cc.FNumber, t.FBgPeriodId, t.FBgElementId, t.FCurrencyId, i.FKey, t.FIsGroupCtrl, t.FGroupNo, cy.FPrecision from T_BG_BgData t join T_BG_BgItemcombination i on t.FBgItemCombinId = i.FID join T_ORG_CostCenter cc on t.FOrgUnitId = cc.FID join T_BD_Currency cy on t.FCurrencyId = cy.FID ");
        if (isView) {
            sql.append("join T_Bg_BgDataEntry dataEntry on dataEntry.FBgDataId = t.FID ").append("join T_Bg_BgForm entryForm on entryForm.FID = dataEntry.FBgFormId ").append("join T_Bg_BgTemplate entryTemp on entryTemp.FID = entryForm.FBgTemplateId ");
        }
        sql.append("where ");
        sql.append(" t.FOrgUnitId = ? ");
        sqlist.add(orgUnitId.toString());
        if (_bgSchemeInfo != null) {
            if (isByBillSourceOrg) {
                sql.append(" and t.FBgSchemeId IN (select FID from T_BG_BgScheme where FRootID = ?) ");
                sqlist.add(_bgSchemeInfo.getRootId().toString());
            } else {
                sql.append(" and t.FBgSchemeId IN (select FID from T_BG_BgScheme where FRootID = ?) ");
                sqlist.add(_bgSchemeInfo.getRootId().toString());
            }
        }
        if (_bgFormInfo != null) {
            if (isView) {
                sql.append(" and entryTemp.FRootId = ?");
                sqlist.add(_bgFormInfo.getBgTemplate().getRootId().toString());
            } else {
                sql.append(" and t.FBgTemplateId IN (select FID from T_BG_BgTemplate where FRootID = ?) ");
                sqlist.add(_bgFormInfo.getBgTemplate().getRootId().toString());
            }
        }
        if (_beginPeriod != null && _endPeriod != null && (bgPeriodColl = BgPeriodHelper.getPeriodColInfo(ctx, _beginPeriod.getBeginDate(), _endPeriod.getEndDate(), _beginPeriod.getPeriodType().getValue())) != null) {
            tmpSql = new StringBuffer(" and t.FBgPeriodId IN (");
            int in = bgPeriodColl.size();
            for (int i = 0; i < in; ++i) {
                bgPeriodInfo = bgPeriodColl.get(i);
                tmpSql.append("?,");
                sqlist.add(bgPeriodInfo.getId().toString());
            }
            if (tmpSql.length() > 0) {
                tmpSql.delete(tmpSql.length() - 1, tmpSql.length());
            }
            sql.append(tmpSql).append(")");
        }
        if (_beginItem != null) {
            sql.append(" and (i.FKey >= ?)");
            sqlist.add(_beginItem.getNumber().replaceAll(",", "_"));
        }
        if (_endItem != null) {
            sql.append(" and (i.FKey <= ?)");
            sqlist.add(_endItem.getNumber().replaceAll(",", "_"));
        }
        if (_bgElementInfo != null) {
            sql.append(" and (t.FBgElementId = ?)");
            sqlist.add(_bgElementInfo.getId().toString());
        }
        if (_currency != null) {
            sql.append(" and (t.FCurrencyId = ?)");
            sqlist.add(_currency.getId().toString());
        }
        if (!StringUtils.isEmpty((String)_bgFormula)) {
            sql.append(" and t.FFormula like ?");
            sqlist.add(_bgFormula);
        }
        sql.append(" order by t.FFormula");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, sqlist);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                info = new BgExecuteAnalyseInfo();
                info.setBgDataId(rst.getString("FID"));
                info.setFormula(rst.getString("FFormula"));
                info.setOrgUnitNumber(rst.getString("FNumber"));
                info.setBgSchemeNumber(_bgSchemeInfo.getNumber());
                info.setBgPeriodId(rst.getString("FBgPeriodId"));
                info.setBgElementId(rst.getString("FBgElementId"));
                info.setCurrencyId(rst.getString("FCurrencyId"));
                info.setPrecision(rst.getInt("FPrecision"));
                info.setBgItemNumber(rst.getString("FKey").replaceAll("_", ","));
                info.setHasGroupCtrl(rst.getBoolean("FIsGroupCtrl"));
                if (info.isHasGroupCtrl()) {
                    info.setGroupCtrlNo(rst.getString("FGroupNo"));
                    _groupNoSet.add(info.getGroupCtrlNo());
                }
                _tmpList.add(info);
                _InfoList.add(info);
                _bgDataIdSet.add(info.getBgDataId());
                _bgDataId.add(info.getBgDataId());
                _bgItemSet.add(info.getBgItemNumber());
                _bgPeriodSet.add(info.getBgPeriodId());
                _bgElementSet.add(info.getBgElementId());
                _currencySet.add(info.getCurrencyId());
            }
            _dataMap.put(orgUnitId, _tmpList);
            if (!_groupNoSet.isEmpty()) {
                List _groupInfoList = this.queryGroupBgdataInfo(ctx, orgUnitId, filterParam, _groupNoSet);
                int in = _groupInfoList.size();
                for (int i = 0; i < in; ++i) {
                    info = (BgExecuteAnalyseInfo)_groupInfoList.get(i);
                    if (_bgDataIdSet.contains(info.getBgDataId())) continue;
                    _tmpList.add(info);
                    _InfoList.add(info);
                    _bgDataId.add(info.getBgDataId());
                    _bgItemSet.add(info.getBgItemNumber());
                    _bgPeriodSet.add(info.getBgPeriodId());
                    _bgElementSet.add(info.getBgElementId());
                    _currencySet.add(info.getCurrencyId());
                }
                _dataMap.put("HAS_GROUPCTRL", BgNConstants.TRUE_STE);
            } else {
                _dataMap.put("HAS_GROUPCTRL", BgNConstants.FALSE_STR);
            }
            if (isByBillSourceOrg) {
                this.queryCtrlRecordInfoByBillSource(ctx, _InfoList, _bgDataId, orgUnitId);
            } else {
                this.queryCtrlRecordInfo(ctx, _InfoList, _bgDataId);
            }
            _dataMap.put("BGITEM_INFO", BgInfoHelper.getBgItemsInfo((Context)ctx, _bgItemSet, null, null, (String)orgUnitId));
            _dataMap.put("BGPERIOD_INFO", BgInfoHelper.getBgPeriodInfo((Context)ctx, _bgPeriodSet, null, null));
            _dataMap.put("BGELEMENT_INFO", BgInfoHelper.getBgElementInfo((Context)ctx, _bgElementSet, null, null));
            _dataMap.put("CURRENCY_INFO", BgInfoHelper.getCurrencyInfo((Context)ctx, _currencySet, null, null));
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"queryBgDataInfo: ", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _dataMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List queryGroupBgdataInfo(Context ctx, String orgUnitId, BgExecuteFilterParam filterParam, Set groupSet) throws BOSException, EASBizException {
        int i;
        int in;
        if (ctx == null) return null;
        if (orgUnitId == null) return null;
        if (filterParam == null) {
            return null;
        }
        ArrayList groupList = new ArrayList();
        ArrayList<String> sqllist = new ArrayList<String>();
        ArrayList<BgExecuteAnalyseInfo> groupInfoList = new ArrayList<BgExecuteAnalyseInfo>();
        groupList.addAll(groupSet);
        BgSchemeInfo _bgSchemeInfo = filterParam.getBgScheme();
        BgFormInfo _bgFormInfo = filterParam.getBgFormInfo();
        BgPeriodInfo _beginPeriod = filterParam.getBgPeriodBegin();
        BgPeriodInfo _endPeriod = filterParam.getBgPeriodEnd();
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodColl = null;
        BgExecuteAnalyseInfo info = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer tmpSql = null;
        sql.append("select t.FID, t.FFormula, t.FOrgUnitId, cc.FNumber, t.FBgPeriodId, t.FBgElementId, t.FCurrencyId, i.FKey, t.FIsGroupCtrl, t.FGroupNo, cy.FPrecision from T_BG_BgData t join T_BG_BgItemcombination i on t.FBgItemCombinId = i.FID join T_ORG_CostCenter cc on t.FOrgUnitId = cc.FID join T_BD_Currency cy on t.FCurrencyId = cy.FID where ");
        if (orgUnitId != null) {
            sql.append(" t.FOrgUnitId = ? ");
            sqllist.add(orgUnitId);
        }
        if (_bgSchemeInfo != null) {
            sql.append(" and t.FBgSchemeId IN (select FID from T_BG_BgScheme where FRootID = ?) ");
            sqllist.add(_bgSchemeInfo.getRootId().toString());
        }
        if (_bgFormInfo != null) {
            sql.append(" and t.FBgTemplateId IN (select FID from T_BG_BgTemplate where FRootID = ?) ");
            sqllist.add(_bgFormInfo.getBgTemplate().getRootId().toString());
        }
        if (_beginPeriod != null && _endPeriod != null && (bgPeriodColl = BgPeriodHelper.getPeriodColInfo(ctx, _beginPeriod.getBeginDate(), _endPeriod.getEndDate(), _beginPeriod.getPeriodType().getValue())) != null) {
            tmpSql = new StringBuffer(" and t.FBgPeriodId IN (");
            in = bgPeriodColl.size();
            for (i = 0; i < in; ++i) {
                bgPeriodInfo = bgPeriodColl.get(i);
                tmpSql.append("?,");
                sqllist.add(bgPeriodInfo.getId().toString());
            }
            if (tmpSql.length() > 0) {
                tmpSql.delete(tmpSql.length() - 1, tmpSql.length());
            }
            sql.append(tmpSql).append(")");
        }
        sql.append(" and t.FGroupNo IN (");
        in = groupList.size();
        for (i = 0; i < in; ++i) {
            sql.append("?,");
            sqllist.add(groupList.get(i).toString());
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(")");
        sql.append(" order by t.FFormula");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, sqllist);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                info = new BgExecuteAnalyseInfo();
                info.setHasShowInfo(false);
                info.setBgDataId(rst.getString("FID"));
                info.setFormula(rst.getString("FFormula"));
                info.setOrgUnitId(rst.getString("FOrgUnitId"));
                info.setOrgUnitNumber(rst.getString("FNumber"));
                info.setBgSchemeNumber(_bgSchemeInfo.getNumber());
                info.setBgPeriodId(rst.getString("FBgPeriodId"));
                info.setBgElementId(rst.getString("FBgElementId"));
                info.setCurrencyId(rst.getString("FCurrencyId"));
                info.setPrecision(rst.getInt("FPrecision"));
                info.setBgItemNumber(rst.getString("FKey").replaceAll("_", ","));
                info.setHasGroupCtrl(rst.getBoolean("FIsGroupCtrl"));
                info.setGroupCtrlNo(rst.getString("FGroupNo"));
                groupInfoList.add(info);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"queryGroupBgdataInfo\uff1a", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return groupInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void queryCtrlRecordInfo(Context ctx, List bgAnalayseList, List queryBgDataList) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (bgAnalayseList == null) return;
        if (bgAnalayseList.isEmpty()) return;
        if (queryBgDataList == null) return;
        if (queryBgDataList.isEmpty()) {
            return;
        }
        BgExecuteAnalyseInfo info = null;
        BgExecuteAnalyseBillInfo billInfo = null;
        HashMap<String, BgExecuteAnalyseInfo> tmpMap = new HashMap<String, BgExecuteAnalyseInfo>();
        int in = bgAnalayseList.size();
        for (int i = 0; i < in; ++i) {
            info = (BgExecuteAnalyseInfo)bgAnalayseList.get(i);
            tmpMap.put(info.getBgDataId(), info);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchSize = 200;
        int size = queryBgDataList.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        String _key = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FCreateTime, FBgDataId, FBillId, FBillName, FBillNumber, FBillType, FBizDate, FActualAmount, FBgTraceType, FActualType ,FBillSourceOrgunitID   from T_BG_BgCtrlRecord where FBgDataId IN (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?) ");
        sql.append("order by FBizDate, FBillNumber, FBillType  ");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, (String)queryBgDataList.get(pos));
                        continue;
                    }
                    pstmt.setString(x, "#");
                }
                try {
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _key = rst.getString("FBgDataId");
                        if (!tmpMap.containsKey(_key)) continue;
                        info = (BgExecuteAnalyseInfo)tmpMap.get(_key);
                        billInfo = new BgExecuteAnalyseBillInfo();
                        billInfo.setBillId(rst.getString("FBillId"));
                        billInfo.setBillName(rst.getString("FBillName"));
                        billInfo.setBillNumber(rst.getString("FBillNumber"));
                        billInfo.setBillType(rst.getString("FBillType"));
                        billInfo.setBusTime(rst.getTimestamp("FBizDate"));
                        billInfo.setProcTime(rst.getTimestamp("FCreateTime"));
                        billInfo.setValue(rst.getBigDecimal("FActualAmount"));
                        billInfo.setBillTypeEnum(rst.getInt("FBgTraceType"));
                        billInfo.setActualTypeEnum(rst.getInt("FActualType"));
                        billInfo.setBillSourceOrgunitID(rst.getString("FBillSourceOrgunitID"));
                        info.addBillInfo(billInfo);
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)"queryCtrlRecordInfo\uff1a ", (Throwable)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"queryCtrlRecordInfo\uff1a ", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    private void clearCtrlRecordInfo(Map dataMap) {
        if (dataMap == null || dataMap.isEmpty()) {
            return;
        }
        HashMap groupMap = new HashMap();
        String _key = null;
        Map.Entry entry2 = null;
        List _tmpList = null;
        List<BgExecuteAnalyseInfo> _groupList = null;
        BgExecuteAnalyseInfo info = null;
        for (Map.Entry entry2 : dataMap.entrySet()) {
            if (!(entry2.getValue() instanceof List) || (_tmpList = (List)entry2.getValue()) == null) continue;
            int in = _tmpList.size();
            for (int i = 0; i < in; ++i) {
                info = (BgExecuteAnalyseInfo)_tmpList.get(i);
                if (!info.isHasGroupCtrl()) continue;
                _key = info.getGroupCtrlNo() + "_" + info.getBgPeriodNumber();
                if (groupMap.containsKey(_key)) {
                    _groupList = (List)groupMap.get(_key);
                } else {
                    _groupList = new ArrayList();
                    groupMap.put(_key, _groupList);
                }
                _groupList.add(info);
            }
            Iterator tmp = _tmpList.iterator();
            while (tmp.hasNext()) {
                info = (BgExecuteAnalyseInfo)tmp.next();
                if (info.getBillInfos() != null && !info.getBillInfos().isEmpty()) continue;
                if (info.isHasGroupCtrl()) {
                    _key = info.getGroupCtrlNo() + "_" + info.getBgPeriodNumber();
                    if (groupMap.containsKey(_key)) {
                        _groupList = (List)groupMap.get(_key);
                        boolean hasData = false;
                        int in2 = _groupList.size();
                        for (int i = 0; i < in2; ++i) {
                            info = (BgExecuteAnalyseInfo)_groupList.get(i);
                            if (info.getBillInfos() == null || info.getBillInfos().isEmpty()) continue;
                            hasData = true;
                            break;
                        }
                        if (hasData) continue;
                        groupMap.remove(_key);
                        tmp.remove();
                        continue;
                    }
                    tmp.remove();
                    continue;
                }
                tmp.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculator(Context ctx, Map dataMap) {
        if (ctx == null || dataMap == null) {
            return;
        }
        BgCalculatorProcess process = null;
        BgCalculatorFactory factory = null;
        SortedParameterArray params = null;
        Parameter parameter = null;
        Object[] _objs = null;
        String[] _strs = null;
        Map.Entry entry2 = null;
        List _tmpList = null;
        HashMap<BgExecuteAnalyseInfo, Parameter> _tmpMap = new HashMap<BgExecuteAnalyseInfo, Parameter>();
        BgExecuteAnalyseInfo info = null;
        params = new SortedParameterArray();
        for (Map.Entry entry2 : dataMap.entrySet()) {
            if (!(entry2.getValue() instanceof List) || (_tmpList = (List)entry2.getValue()) == null) continue;
            int in = _tmpList.size();
            for (int i = 0; i < in; ++i) {
                info = (BgExecuteAnalyseInfo)_tmpList.get(i);
                if (!info.isHasShowInfo()) continue;
                _strs = BgNFSHelper.parseFormulaPara((String)info.getFormula());
                _objs = new Object[]{new Variant((Object)info.getOrgUnitNumber()), new Variant((Object)info.getBgSchemeNumber()), new Variant((Object)_strs[2]), new Variant((Object)_strs[0]), new Variant((Object)_strs[5]), new Variant((Object)_strs[1])};
                parameter = new Parameter(_objs, null);
                params.insert((Object)parameter);
                _tmpMap.put(info, parameter);
            }
        }
        try {
            process = new BgCalculatorProcess();
            process.setContext(ctx);
            process.setMethodName("bgExecuteAnalyse");
            process.setParams(params);
            factory = new BgCalculatorFactory((IProcess)process);
            factory.process();
        }
        finally {
            for (Map.Entry entry2 : _tmpMap.entrySet()) {
                info = (BgExecuteAnalyseInfo)entry2.getKey();
                parameter = (Parameter)entry2.getValue();
                Object obj = null;
                obj = parameter.getValue();
                if (obj instanceof BigDecimal) {
                    info.setValue((BigDecimal)obj);
                    continue;
                }
                info.setValue(null);
            }
        }
    }

    @Override
    protected Map _queryBgItemReqUse(Context ctx, BOSUuid orgUnitId, Object filterParam) throws BOSException, EASBizException {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (filterParam == null || !(filterParam instanceof BgItemAnalyseParam)) {
            return dataMap;
        }
        boolean hasBgItem = false;
        String _name = "FName_" + ctx.getLocale();
        String _key = null;
        String bgReqEntryId = null;
        String _orgUnitId = null;
        String _bgItemNumber = null;
        String _bgPeriodName = null;
        Object bgList = null;
        List<BgItemReqUseAnalyseInfo> bgReqList = null;
        List<String> periodList = null;
        Object bgReqEntryList = null;
        List bgItemList = null;
        List<BgItemReqUseAnalyseInfo> tmpList = null;
        HashMap<String, Object> queryBgItemMap = new HashMap<String, Object>();
        HashMap tmpMap = new HashMap();
        OrgUnitInfo unitInfo2 = null;
        OrgUnitInfo[] unitInfos = null;
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodColl = null;
        BgItemReqUseAnalyseInfo info = null;
        BgItemAnalyseParam itemAnalyseParam = (BgItemAnalyseParam)filterParam;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        if (itemAnalyseParam.getBeginBgItem() != null && itemAnalyseParam.getEndBgItem() != null) {
            hasBgItem = true;
        }
        StringBuffer sql = new StringBuffer();
        StringBuffer tmpStr = null;
        StringBuffer sqlBg = new StringBuffer();
        StringBuffer sqlBgReq = new StringBuffer();
        sqlBg.append("select d.FOrgUnitId, p." + _name + ", d.FBgValue, i.FKey, e.FNumber from T_BG_BgData d ");
        sqlBg.append("left join T_BG_BgItemCombination i on d.FBgItemCombinId = i.FID ");
        sqlBg.append("left join T_BG_BgPeriod p on d.FBgPeriodId = p.FID ");
        sqlBg.append("left join T_BG_BgElement e on d.FBgElementId = e.FID where ");
        if (orgUnitId != null) {
            sql.append("d.FOrgUnitId = '").append(orgUnitId.toString()).append("'");
        } else {
            sql.append("d.FOrgUnitId IN (");
            unitInfos = itemAnalyseParam.getOrgUnits();
            if (unitInfos != null) {
                for (OrgUnitInfo unitInfo2 : unitInfos) {
                    sql.append("'").append(unitInfo2.getId().toString()).append("',");
                }
            }
            sql.append("'')");
        }
        if (itemAnalyseParam.getBgScheme() != null) {
            sql.append(" and d.FBgSchemeId IN (select FID from T_BG_BgScheme where FRootId = '");
            sql.append(itemAnalyseParam.getBgScheme().getRootId().toString()).append("')");
        }
        if (itemAnalyseParam.getBgTemplateInfo() != null) {
            sql.append(" and d.FBgTemplateId IN (select FID from T_BG_BgTemplate where FRootId = '");
            sql.append(itemAnalyseParam.getBgTemplateInfo().getRootId().toString()).append("')");
        }
        if (itemAnalyseParam.getBgPeriodBegin() != null && itemAnalyseParam.getBgPeriodEnd() != null && (bgPeriodColl = BgPeriodHelper.getPeriodColInfo(ctx, itemAnalyseParam.getBgPeriodBegin().getBeginDate(), itemAnalyseParam.getBgPeriodEnd().getEndDate(), itemAnalyseParam.getBgPeriodBegin().getPeriodType().getValue())) != null) {
            sql.append(" and d.FBgPeriodId IN (");
            tmpStr = new StringBuffer();
            int in = bgPeriodColl.size();
            for (int i = 0; i < in; ++i) {
                bgPeriodInfo = bgPeriodColl.get(i);
                tmpStr.append("'" + bgPeriodInfo.getId().toString() + "',");
            }
            if (tmpStr.length() > 0) {
                tmpStr.delete(tmpStr.length() - 1, tmpStr.length());
            }
            sql.append(tmpStr).append(")");
        }
        if (itemAnalyseParam.getCurrency() != null) {
            sql.append(" and d.FCurrencyId = '").append(itemAnalyseParam.getCurrency().getId().toString()).append("'");
        }
        if (hasBgItem) {
            sql.append(" and i.FKey >= '").append(itemAnalyseParam.getBeginBgItem().getNumber().replaceAll(",", "_")).append("'");
            sql.append(" and i.FKey <= '").append(itemAnalyseParam.getEndBgItem().getNumber().replaceAll(",", "_")).append("'");
        }
        sqlBg.append(sql);
        sqlBg.append(" order by d.FOrgUnitId, p.FNumber, i.FKey");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sqlBg.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _orgUnitId = rst.getString("FOrgUnitId");
                _bgPeriodName = rst.getString(_name);
                _bgItemNumber = rst.getString("FKey").replaceAll("_", ",");
                info = new BgItemReqUseAnalyseInfo();
                info.setBgItemNumber(_bgItemNumber);
                info.setBgPeriodName(_bgPeriodName);
                info.setBgElementNumber(rst.getString("FNumber"));
                info.setBValue(rst.getBigDecimal("FBgValue"));
                queryBgItemMap.put(_bgItemNumber, null);
                if (dataMap.containsKey(_orgUnitId)) {
                    bgItemList = (List)dataMap.get(_orgUnitId);
                } else {
                    bgItemList = new ArrayList();
                    dataMap.put(_orgUnitId, bgItemList);
                    tmpMap.clear();
                }
                _key = _bgPeriodName + "_" + _bgItemNumber;
                if (tmpMap.containsKey(_key)) {
                    tmpList = (List)tmpMap.get(_key);
                } else {
                    tmpList = new ArrayList();
                    tmpMap.put(_key, tmpList);
                    bgItemList.add(tmpList);
                }
                tmpList.add(info);
                if (dataMap.containsKey(_orgUnitId + "_PERIOD")) {
                    periodList = (List)dataMap.get(_orgUnitId + "_PERIOD");
                } else {
                    periodList = new ArrayList();
                    dataMap.put(_orgUnitId + "_PERIOD", periodList);
                }
                if (periodList.contains(info.getBgPeriodName())) continue;
                periodList.add(info.getBgPeriodName());
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            dataMap.put("BGITEM_INFO", BgSHelper.getBgItemsInfo(ctx, queryBgItemMap, null, null, null));
            dataMap.put("BGELEMENT_INFO", BgSHelper.getBgElementInfo(ctx, null, null, null));
            sqlBgReq.append("select d.FOrgUnitId,p.FNumber,p." + _name + ",c.FActualAmount,i.FKey,d.FCurrencyId,e.FID elemFID,e.FNumber elFNumber,r.FID,u.FName_l2 FReqOrgName from T_BG_BgCtrlRecord c ");
            sqlBgReq.append("left join T_BG_BgData d on c.fBgDataId = d.FID ");
            sqlBgReq.append("left join T_BG_BgItemCombination i on d.FBgItemCombinId = i.FID ");
            sqlBgReq.append("left join T_BG_BgPeriod p on d.FBgPeriodId = p.FID ");
            sqlBgReq.append("left join T_BG_BgElement e on d.FBgElementId = e.FID ");
            sqlBgReq.append("left join T_BG_BudgetRequestBill r on c.FBillId = r.FID ");
            sqlBgReq.append("left join T_ORG_BaseUnit u on r.FreqOrgUnitID = u.FID ");
            sqlBgReq.append("where  ").append(sql);
            sqlBgReq.append(" and c.fbgtracetype =3  ");
            sqlBgReq.append(" order by d.FOrgUnitId, p.FNumber");
            pstmt = conn.prepareStatement(sqlBgReq.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                info = new BgItemReqUseAnalyseInfo();
                _orgUnitId = rst.getString("FOrgUnitId");
                if (!StringUtils.isEmpty((String)rst.getString("FKey"))) {
                    _bgItemNumber = rst.getString("FKey").replaceAll("_", ",");
                }
                info.setBgItemNumber(_bgItemNumber);
                info.setBgPeriodName(rst.getString(_name));
                info.setBValue(rst.getBigDecimal("FActualAmount"));
                info.setBgElementNumber(rst.getString("elFNumber"));
                info.setBgReqBillId(rst.getString("FID"));
                info.setReqOrgUnit(rst.getString("FReqOrgName"));
                bgReqEntryId = this.getBgReqEntryId(ctx, info.getBgReqBillId(), _bgItemNumber, rst.getString("FCurrencyId"), rst.getString("elemFID"));
                info.setBgReqBillEntryId(bgReqEntryId);
                if (dataMap.containsKey(_orgUnitId + "_BGREQ")) {
                    bgReqList = (List)dataMap.get(_orgUnitId + "_BGREQ");
                } else {
                    bgReqList = new ArrayList();
                    dataMap.put(_orgUnitId + "_BGREQ", bgReqList);
                }
                bgReqList.add(info);
            }
            ArrayList<BgItemReqUseAnalyseInfo> bgUseList = new ArrayList<BgItemReqUseAnalyseInfo>();
            List tmpReqList = null;
            String srcObjId = null;
            String destObjID = null;
            String srcObjEntryId = null;
            String elemNum = null;
            for (Map.Entry entry : dataMap.entrySet()) {
                Object key = entry.getKey();
                if (key.toString().indexOf("_BGREQ") <= 0) continue;
                tmpReqList = (List)entry.getValue();
                HashMap<String, String> usedkey = new HashMap<String, String>();
                if (tmpReqList == null || tmpReqList.size() <= 0) continue;
                for (int i = 0; i < tmpReqList.size(); ++i) {
                    info = (BgItemReqUseAnalyseInfo)tmpReqList.get(i);
                    if (info.getBValue().compareTo(new BigDecimal(0)) < 0) continue;
                    srcObjId = info.getBgReqBillId();
                    srcObjEntryId = info.getBgReqBillEntryId();
                    elemNum = info.getBgElementNumber();
                    String tmpkey = srcObjId + "-" + srcObjEntryId;
                    if (usedkey.containsKey(tmpkey)) continue;
                    usedkey.put(tmpkey, tmpkey);
                    BOTRelationCollection botRelationCol = null;
                    BOTRelationInfo relationInfo = null;
                    BOSObjectType destObjType = null;
                    BigDecimal useValue = new BigDecimal(0);
                    botRelationCol = BTPManagerFactory.getLocalInstance((Context)ctx).getDestRelation(srcObjId);
                    if (botRelationCol == null || botRelationCol.size() <= 0) continue;
                    for (int ui = 0; ui < botRelationCol.size(); ++ui) {
                        int j;
                        PaymentBillEntryInfo entryInfo;
                        PaymentBillEntryCollection entryColl;
                        PaymentBillInfo billInfo;
                        relationInfo = botRelationCol.get(ui);
                        destObjID = relationInfo.getDestObjectID();
                        destObjType = BgAnalyseFacadeControllerBean.getBOSType(destObjID);
                        ObjectUuidPK destObjPK = new ObjectUuidPK(destObjID);
                        if (new PaymentBillInfo().getBOSType().equals((Object)destObjType)) {
                            billInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)destObjPK);
                            if (!billInfo.getBillStatus().equals((Object)BillStatusEnum.SUBMIT) && !billInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) continue;
                            entryColl = billInfo.getEntries();
                            entryInfo = null;
                            if (entryColl == null || entryColl.size() <= 0) continue;
                            for (j = 0; j < entryColl.size(); ++j) {
                                entryInfo = entryColl.get(j);
                                if (entryInfo.getSourceBillEntryId() == null || !srcObjEntryId.equals(entryInfo.getSourceBillEntryId())) continue;
                                useValue = entryInfo.getAmount();
                                srcObjEntryId = entryInfo.getSourceBillEntryId();
                                info = new BgItemReqUseAnalyseInfo();
                                info.setBgReqBillId(srcObjId);
                                info.setBotpBillType(destObjType);
                                info.setBotpBillName("\u4ed8\u6b3e\u5355");
                                info.setBValue(useValue);
                                info.setBgReqBillEntryId(srcObjEntryId);
                                info.setBotpBillId(destObjID);
                                info.setBgElementNumber(elemNum);
                                bgUseList.add(info);
                            }
                            continue;
                        }
                        if (new PurOrderInfo().getBOSType().equals((Object)destObjType)) {
                            billInfo = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderInfo((IObjectPK)destObjPK);
                            if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) && !billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) continue;
                            entryColl = billInfo.getEntries();
                            entryInfo = null;
                            if (entryColl == null || entryColl.size() <= 0) continue;
                            for (j = 0; j < entryColl.size(); ++j) {
                                entryInfo = entryColl.get(j);
                                if (entryInfo.getSourceBillEntryId() == null || !srcObjEntryId.equals(entryInfo.getSourceBillEntryId())) continue;
                                useValue = entryInfo.getAmount();
                                srcObjEntryId = entryInfo.getSourceBillEntryId();
                                info = new BgItemReqUseAnalyseInfo();
                                info.setBgReqBillId(srcObjId);
                                info.setBotpBillType(destObjType);
                                info.setBotpBillName("\u91c7\u8d2d\u8ba2\u5355");
                                info.setBValue(useValue);
                                info.setBgReqBillEntryId(srcObjEntryId);
                                info.setBotpBillId(destObjID);
                                info.setBgElementNumber(elemNum);
                                bgUseList.add(info);
                            }
                            continue;
                        }
                        if (!new PurContractInfo().getBOSType().equals((Object)destObjType) || !(billInfo = PurContractFactory.getLocalInstance((Context)ctx).getPurContractInfo((IObjectPK)destObjPK)).getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) && !billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) continue;
                        entryColl = billInfo.getEntries();
                        entryInfo = null;
                        if (entryColl == null || entryColl.size() <= 0) continue;
                        for (j = 0; j < entryColl.size(); ++j) {
                            entryInfo = entryColl.get(j);
                            if (entryInfo.getSourceBillEntryId() == null || !srcObjEntryId.equals(entryInfo.getSourceBillEntryId())) continue;
                            useValue = entryInfo.getAmount();
                            srcObjEntryId = entryInfo.getSourceBillEntryId();
                            info = new BgItemReqUseAnalyseInfo();
                            info.setBgReqBillId(srcObjId);
                            info.setBotpBillType(destObjType);
                            info.setBotpBillName("\u91c7\u8d2d\u8ba2\u5355");
                            info.setBValue(useValue);
                            info.setBgReqBillEntryId(srcObjEntryId);
                            info.setBotpBillId(destObjID);
                            info.setBgElementNumber(elemNum);
                            bgUseList.add(info);
                        }
                    }
                }
            }
            dataMap.put("BGUSE", bgUseList);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"_queryBgItemData: ", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return dataMap;
    }

    private String getBgReqEntryId(Context ctx, String bgReqBillId, String bgItemNum, String currencyId, String bgElementId) throws EASBizException, BOSException {
        String entryId = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_BG_BudgetRequestBillEntry where FBgBillId = ? and FBgItemNumber = ? and FCurrencyID = ?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgReqBillId);
            pstmt.setString(2, bgItemNum);
            pstmt.setString(3, currencyId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                entryId = rst.getString("FID");
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"_queryBgItemData: ", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return entryId;
    }

    private static BOSObjectType getBOSType(String type) {
        int len = type.length();
        if (len >= 8) {
            return BOSUuid.getBOSObjectType((String)type, (boolean)true);
        }
        return null;
    }

    private Map queryBgItemSpecial(Context ctx, BgFormCollection bgForms, Object filterParam) throws BOSException, EASBizException {
        BgSpecialAnalysisFilterParam _param = (BgSpecialAnalysisFilterParam)filterParam;
        ArrayList<String> _tmpList = new ArrayList<String>();
        HashMap<String, String> _returnMap = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        BgFormInfo bgFormInfo = null;
        sql.append("select a.fid,b.fnumber from t_bg_bgform a left join t_bg_bgitem b  on a.fbgitemid = b.fid where a.fid in ( ");
        String str = "";
        Iterator iter = bgForms.iterator();
        while (iter.hasNext()) {
            bgFormInfo = (BgFormInfo)iter.next();
            str = str + "?,";
            _tmpList.add(bgFormInfo.getId().toString());
        }
        str = !"".equals(str) ? str.substring(0, str.length() - 1) + ")" : str + "'')";
        sql.append(str);
        String itemGroupStr = "";
        BgItemGroupInfo[] specialItemGroup = _param.getBgItemGroupInfo();
        if (specialItemGroup != null && specialItemGroup.length > 0) {
            for (int i = 0; i < specialItemGroup.length; ++i) {
                itemGroupStr = itemGroupStr + "?,";
                _tmpList.add(specialItemGroup[i].getId().toString());
            }
        }
        if (!"".equals(itemGroupStr)) {
            sql.append(" and b.fbgitemgroupid in (" + itemGroupStr.substring(0, itemGroupStr.length() - 1) + ")");
        }
        String specialNumStr = "";
        BgItemInfo[] specialItem = _param.getBgItemInfo();
        if (specialItem != null && specialItem.length > 0) {
            for (int i = 0; i < specialItem.length; ++i) {
                specialNumStr = specialNumStr + "?,";
                _tmpList.add(specialItem[i].getNumber());
            }
        }
        if (!"".equals(specialNumStr)) {
            sql.append(" and b.fnumber in (" + specialNumStr.substring(0, specialNumStr.length() - 1) + ")");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _returnMap.put(rst.getString(1), rst.getString(2));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"_queryBgItemData: ", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _returnMap;
    }

    @Override
    protected Map _querySpecific(Context ctx, Object filterParam) throws BOSException, EASBizException {
        if (filterParam == null || !(filterParam instanceof BgSpecialAnalysisFilterParam)) {
            return null;
        }
        BgSpecialAnalysisFilterParam _param = (BgSpecialAnalysisFilterParam)filterParam;
        OrgUnitInfo[] unitInfos = _param.getOrgUnits();
        BgSchemeInfo schemeInfo = _param.getBgScheme();
        BgTemplateInfo templateInfo = _param.getBgTemplateInfo();
        Map _bgSchemeMap = this.getBgSchemeByOrgUnitInfo(ctx, unitInfos, schemeInfo.getRootId());
        BgPeriodCollection _bgPeriods = null;
        if (_param.getBgPeriodBegin() != null && _param.getBgPeriodEnd() != null) {
            BgPeriodInfo bBgPeriodInfo = _param.getBgPeriodBegin();
            BgPeriodInfo eBgPeriodInfo = _param.getBgPeriodEnd();
            _bgPeriods = BgPeriodHelper.getPeriodColInfo(ctx, bBgPeriodInfo.getBeginDate(), eBgPeriodInfo.getEndDate(), bBgPeriodInfo.getPeriodType().getValue());
        }
        BgFormCollection _bgForms = (BgFormCollection)this.getBgFormBySchemeAndTemplate(ctx, _bgSchemeMap, templateInfo);
        Map _bgFormMap = this.filterBgFormInfo((IObjectCollection)_bgForms);
        List _bgGroupList = this.filterBgItemGroup((IObjectCollection)_bgForms);
        Map _bgItemSpecificMap = this.queryBgItemSpecial(ctx, _bgForms, filterParam);
        HashMap<String, Object> _queryParam = new HashMap<String, Object>();
        _queryParam.put("BGSCHEME_ID", _bgSchemeMap);
        _queryParam.put("BGFORM_ID", _bgFormMap);
        _queryParam.put("BGPERIOD_ID", (Object)_bgPeriods);
        _queryParam.put("QUERY_NAME", _param);
        List _spcificData = this.querySpcificData(ctx, _queryParam, _bgItemSpecificMap);
        Map _dataMap = this.calculateSpcificData(ctx, _queryParam, _spcificData);
        _dataMap.put("BGPERIOD_INFO", _bgPeriods);
        _dataMap.put("BGITEMGROUP_INFO", _bgGroupList);
        return _dataMap;
    }

    private Map filterBgFormInfo(IObjectCollection collection) {
        if (collection == null) {
            return new HashMap();
        }
        String _key = null;
        BgFormInfo bgFormInfo = null;
        List<BgFormInfo> _bgFormList = null;
        HashMap _bgFormMap = new HashMap();
        int in = collection.size();
        for (int i = 0; i < in; ++i) {
            bgFormInfo = (BgFormInfo)collection.getObject(i);
            _key = bgFormInfo.getOrgUnit().getId().toString();
            if (_bgFormMap.containsKey(_key)) {
                _bgFormList = (List)_bgFormMap.get(_key);
            } else {
                _bgFormList = new ArrayList();
                _bgFormMap.put(_key, _bgFormList);
            }
            _bgFormList.add(bgFormInfo);
        }
        return _bgFormMap;
    }

    private List filterBgItemGroup(IObjectCollection collection) {
        if (collection == null) {
            return new ArrayList();
        }
        BgFormInfo bgFormInfo = null;
        ArrayList<BgItemGroupInfo> _bgGroupList = new ArrayList<BgItemGroupInfo>();
        int in = collection.size();
        for (int i = 0; i < in; ++i) {
            bgFormInfo = (BgFormInfo)collection.getObject(i);
            if (_bgGroupList.contains(bgFormInfo.getBgItemGroup())) continue;
            _bgGroupList.add(bgFormInfo.getBgItemGroup());
        }
        Collections.sort(_bgGroupList, new BgComparator());
        return _bgGroupList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List querySpcificData(Context ctx, Map queryParam, Map bgItemSpecificMap) throws BOSException, EASBizException {
        ArrayList<BgSpecialData> _reList = new ArrayList<BgSpecialData>();
        if (ctx == null) return _reList;
        if (queryParam == null) {
            return _reList;
        }
        BgSpecialAnalysisFilterParam _param = (BgSpecialAnalysisFilterParam)queryParam.get("QUERY_NAME");
        OrgUnitInfo[] _orgUnits = _param.getOrgUnits();
        OrgUnitInfo _currOrgUnit = _orgUnits[0];
        Map _bgSchemeMap = (Map)queryParam.get("BGSCHEME_ID");
        Map _bgFormMap = (Map)queryParam.get("BGFORM_ID");
        BgPeriodCollection _bgPeriodCol = (BgPeriodCollection)((Object)queryParam.get("BGPERIOD_ID"));
        CurrencyInfo currency = _param.getCurrency();
        int index = 0;
        int batchNum = 25;
        int size = 0;
        int count = 0;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _orgUnitId = null;
        List _bgFormList = null;
        ArrayList<String> sqllist = new ArrayList<String>();
        BgSpecialData _data = null;
        BgFormInfo _info = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select d.FBgValue, d.FBizActual, d.FFormula, d.FBgFormId, d.FBgPeriodId, p.FNumber as pNumber, p.FName_" + ctx.getLocale() + " as pName, d.FCurrencyId, c.FNumber as cNumber, c.FName_" + ctx.getLocale() + " as cName, d.FBgElementId, e.FNumber as eNumber, e.FName_" + ctx.getLocale() + " as eName  from T_BG_BgData d left join T_BG_BgPeriod p on d.FBgPeriodId = p.FID  left join T_BD_Currency c on d.FCurrencyId = c.FID  left join t_bg_bgelement e on d.FBgElementId = e.FID  where d.FOrgUnitId = ? and d.FBgSchemeId = ? and d.FCurrencyId = ? and d.FBgFormId IN (");
        for (int i = 1; i < batchNum; ++i) {
            sql.append("?, ");
        }
        sql.append("?) ");
        if (_bgPeriodCol != null && !_bgPeriodCol.isEmpty()) {
            BgPeriodInfo _tmp = null;
            sql.append(" and (d.FBgPeriodId in (");
            int n = _bgPeriodCol.size();
            for (int i = 0; i < n; ++i) {
                _tmp = _bgPeriodCol.get(i);
                if (i < n - 1) {
                    sql.append("?,");
                } else {
                    sql.append("?))");
                }
                sqllist.add(_tmp.getId().toString());
            }
        }
        HashSet<String> itemGroupSet = new HashSet<String>();
        BgItemGroupInfo[] specialItemGroup = _param.getBgItemGroupInfo();
        if (specialItemGroup != null && specialItemGroup.length > 0) {
            for (int i = 0; i < specialItemGroup.length; ++i) {
                itemGroupSet.add(specialItemGroup[i].getNumber());
            }
        }
        HashSet<String> specialNumSet = new HashSet<String>();
        BgItemInfo[] specialItem = _param.getBgItemInfo();
        if (specialItem != null && specialItem.length > 0) {
            for (int i = 0; i < specialItem.length; ++i) {
                specialNumSet.add(specialItem[i].getNumber());
            }
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            block9: for (OrgUnitInfo unitInfo : _orgUnits) {
                if (unitInfo.getId().equals((Object)_currOrgUnit.getId()) && !_param.isHasIncludeData()) continue;
                _orgUnitId = unitInfo.getId().toString();
                pstmt.setString(1, _orgUnitId);
                pstmt.setString(2, (String)_bgSchemeMap.get(_orgUnitId));
                pstmt.setString(3, currency.getId().toString());
                _bgFormList = (List)_bgFormMap.get(_orgUnitId);
                if (_bgFormList == null || _bgFormList.isEmpty()) continue;
                HashMap<String, BgFormInfo> _tmpMap = new HashMap<String, BgFormInfo>();
                int jn = _bgFormList.size();
                for (int j = 0; j < jn; ++j) {
                    _info = (BgFormInfo)_bgFormList.get(j);
                    _tmpMap.put(_info.getId().toString(), _info);
                }
                size = _bgFormList.size();
                count = (size - 1) / batchNum + 1;
                pos = 0;
                index = 0;
                while (true) {
                    if (index >= count) continue block9;
                    for (int k = 4; k <= batchNum + 3; ++k, ++pos) {
                        if (pos < size) {
                            pstmt.setString(k, ((BgFormInfo)_bgFormList.get(pos)).getId().toString());
                            continue;
                        }
                        pstmt.setString(k, "#");
                    }
                    BgNSQLHelper.setParams((PreparedStatement)pstmt, sqllist, (int)(3 + batchNum + 1));
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _info = (BgFormInfo)_tmpMap.get(rst.getString("FBgFormId"));
                        if (itemGroupSet != null && itemGroupSet.size() > 0 && !itemGroupSet.contains(_info.getBgItemGroup().getNumber()) || specialNumSet != null && specialNumSet.size() > 0 && !specialNumSet.contains(bgItemSpecificMap.get(rst.getString("FBgFormId")))) continue;
                        _data = new BgSpecialData();
                        _data.setOrgUnitId(_orgUnitId);
                        _data.setOrgUnitName(unitInfo.getName());
                        _data.setOrgUnitNumber(unitInfo.getNumber());
                        _data.setBudgetValue(rst.getBigDecimal("FBgValue"));
                        _data.setActualValue(rst.getBigDecimal("FBizActual"));
                        _data.setFormula(rst.getString("FFormula"));
                        _data.setBgFormId(rst.getString("FBgFormId"));
                        _data.setBgItemGroupNumber(_info.getBgItemGroup().getNumber());
                        _data.setBgItemGroupName(_info.getBgItemGroup().getName());
                        String SspecialNumber = null;
                        SspecialNumber = bgItemSpecificMap.get(_data.getBgFormId()) == null ? "" : bgItemSpecificMap.get(_data.getBgFormId()).toString();
                        _data.setSpecialNumber(SspecialNumber);
                        _data.setBgPeriodId(rst.getString("FBgPeriodId"));
                        _data.setBgPeriodName(rst.getString("pName"));
                        _data.setBgPeriodNumber(rst.getString("pNumber"));
                        _data.setCurrencyId(rst.getString("FCurrencyId"));
                        _data.setCurrencyName(rst.getString("cName"));
                        _data.setCurrencyNumber(rst.getString("cNumber"));
                        _data.setBgElementId(rst.getString("FBgElementId"));
                        _data.setBgElementName(rst.getString("eName"));
                        _data.setBgElementNumbr(rst.getString("eNumber"));
                        _reList.add(_data);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    ++index;
                }
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"query Spcific Data:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return _reList;
    }

    private Map calculateSpcificData(Context ctx, Map queryParam, List spcificData) throws BOSException, EASBizException {
        if (ctx == null || queryParam == null || spcificData == null || spcificData.isEmpty()) {
            return new HashMap();
        }
        BgSpecialAnalysisFilterParam _param = (BgSpecialAnalysisFilterParam)queryParam.get("QUERY_NAME");
        OrgUnitInfo _currOrgUnit = _param.getOrgUnits()[0];
        ArrayList<BgElementInfo> _bgEleList = new ArrayList<BgElementInfo>();
        Object _dataMap = null;
        SortedMap<String, BgSpecialData> sortMap = null;
        HashMap<String, Object> _reMap = new HashMap<String, Object>();
        Map<String, Map<String, Map<String, Map<String, SortedMap<String, BgSpecialData>>>>> _orgMap = null;
        Map<String, Map<String, Map<String, SortedMap<String, BgSpecialData>>>> _groupMap = null;
        Map<String, Map<String, SortedMap<String, BgSpecialData>>> _eleMap = null;
        Map<String, SortedMap<String, BgSpecialData>> _periodMap = null;
        HashSet<String> itemNumSet = new HashSet<String>();
        String _currOrgUnitNumber = _currOrgUnit.getNumber();
        String _key = null;
        BgSpecialData _data = null;
        BgSpecialData _tmpData = null;
        BgElementInfo _bgElementInfo = null;
        Collections.sort(spcificData, new Comparator(){

            public int compare(Object o1, Object o2) {
                BgSpecialData _obj1 = (BgSpecialData)o1;
                BgSpecialData _obj2 = (BgSpecialData)o2;
                if (_obj1.getSpecialNumber() == null || _obj2.getSpecialNumber() == null) {
                    return 0;
                }
                return _obj1.getSpecialNumber().compareTo(_obj2.getSpecialNumber());
            }
        });
        int in = spcificData.size();
        for (int i = 0; i < in; ++i) {
            _data = (BgSpecialData)spcificData.get(i);
            String string = _key = _param.isExpendOrgUnit() ? _data.getOrgUnitNumber() : _currOrgUnitNumber;
            if (_reMap.containsKey(_key)) {
                _orgMap = (Map)_reMap.get(_key);
            } else {
                _orgMap = new HashMap();
                _reMap.put(_key, _orgMap);
            }
            String string2 = _key = _param.isExpendGroup() ? _data.getBgItemGroupNumber() : "0";
            if (_orgMap.containsKey(_key)) {
                _groupMap = (Map)_orgMap.get(_key);
            } else {
                _groupMap = new HashMap();
                _orgMap.put(_key, _groupMap);
            }
            _key = _data.getBgElementNumbr();
            if (_groupMap.containsKey(_key)) {
                _eleMap = (Map)_groupMap.get(_key);
            } else {
                _eleMap = new HashMap();
                _groupMap.put(_key, _eleMap);
                _bgElementInfo = new BgElementInfo();
                _bgElementInfo.setId(BOSUuid.read((String)_data.getBgElementId()));
                _bgElementInfo.setName(_data.getBgElementName());
                _bgElementInfo.setNumber(_data.getBgElementNumbr());
                if (!_bgEleList.contains(_bgElementInfo)) {
                    _bgEleList.add(_bgElementInfo);
                }
            }
            _key = _data.getBgPeriodId();
            if (_eleMap.containsKey(_key)) {
                _periodMap = (Map)_eleMap.get(_key);
            } else {
                _periodMap = new HashMap();
                _eleMap.put(_key, _periodMap);
            }
            _key = _data.getCurrencyNumber();
            if (_periodMap.containsKey(_key)) {
                sortMap = (SortedMap)_periodMap.get(_key);
            } else {
                sortMap = new TreeMap();
                _periodMap.put(_key, sortMap);
            }
            _key = _data.getBgItemNumber();
            if (sortMap.containsKey(_key)) {
                _tmpData = (BgSpecialData)sortMap.get(_key);
                _tmpData.setBudgetValue(_tmpData.getBudgetValue().add(_data.getBudgetValue()));
                _tmpData.setActualValue(_tmpData.getActualValue().add(_data.getActualValue()));
                _tmpData.setAdjustValue(_tmpData.getAdjustValue().add(_data.getAdjustValue()));
            } else {
                sortMap.put(_key, _data);
            }
            itemNumSet.add(_data.getBgItemNumber());
        }
        Collections.sort(_bgEleList, new BgComparator());
        _reMap.put("BGELEMENT_INFO", _bgEleList);
        Map BgItemMap = BgInfoHelper.getBgItemsInfo((Context)ctx, itemNumSet, null, null, (String)_currOrgUnit.getId().toString());
        _reMap.put("BGITEM_INFO", BgItemMap);
        _reMap.put("BGITEM_ID", itemNumSet);
        return _reMap;
    }

    @Override
    protected Map _queryTotalData(Context ctx, Object filterParam) throws BOSException, EASBizException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        BgSpecialAnalysisFilterParam _param = (BgSpecialAnalysisFilterParam)filterParam;
        OrgUnitInfo[] unitInfos = _param.getOrgUnits();
        BgSchemeInfo schemeInfo = _param.getBgScheme();
        BgTemplateInfo templateInfo = _param.getBgTemplateInfo();
        BgPeriodCollection _bgPeriods = null;
        if (_param.getBgPeriodBegin() != null && _param.getBgPeriodEnd() != null) {
            BgPeriodInfo bBgPeriodInfo = _param.getBgPeriodBegin();
            BgPeriodInfo eBgPeriodInfo = _param.getBgPeriodEnd();
            _bgPeriods = BgPeriodHelper.getPeriodColInfo(ctx, bBgPeriodInfo.getBeginDate(), eBgPeriodInfo.getEndDate(), bBgPeriodInfo.getPeriodType().getValue());
        }
        Map _bgSchemeMap = this.getBgSchemeByOrgUnitInfo(ctx, unitInfos, schemeInfo.getRootId());
        BgFormCollection _bgForms = (BgFormCollection)this.getBgFormBySchemeAndTemplate(ctx, _bgSchemeMap, templateInfo);
        Map _bgFormMap = this.filterBgFormInfo((IObjectCollection)_bgForms);
        Map _bgItemSpecificMap = this.queryBgItemSpecial(ctx, _bgForms, filterParam);
        HashMap<String, Object> _queryParam = new HashMap<String, Object>();
        _queryParam.put("BGSCHEME_ID", _bgSchemeMap);
        _queryParam.put("BGFORM_ID", _bgFormMap);
        _queryParam.put("BGPERIOD_ID", (Object)_bgPeriods);
        _queryParam.put("QUERY_NAME", _param);
        List _spcificData = this.querySpcificData(ctx, _queryParam, _bgItemSpecificMap);
        returnMap.put("back_result", _spcificData);
        HashSet specialNumSet = new HashSet();
        if (_bgItemSpecificMap != null && _bgItemSpecificMap.size() > 0) {
            Iterator iter = _bgItemSpecificMap.keySet().iterator();
            while (iter.hasNext()) {
                specialNumSet.add(_bgItemSpecificMap.get(iter.next()));
            }
        }
        Map specialNumMap = null;
        if (specialNumSet.size() > 0) {
            specialNumMap = BgInfoHelper.getBgItemsInfo((Context)ctx, specialNumSet, null, null, (String)unitInfos[0].getId().toString());
        }
        returnMap.put("BGITEM_INFO", specialNumMap);
        return returnMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _querySourceOrgunit(Context ctx, Object filterParam) throws BOSException, EASBizException {
        if (ctx == null || filterParam == null) {
            return null;
        }
        BgExecuteFilterParam _filterParam = null;
        if (!(filterParam instanceof BgExecuteFilterParam)) {
            return null;
        }
        _filterParam = (BgExecuteFilterParam)filterParam;
        OrgUnitInfo[] orgUnitInfos = _filterParam.getOrgUnits();
        BgSchemeInfo _bgSchemeInfo = _filterParam.getBgScheme();
        BgFormInfo _bgFormInfo = _filterParam.getBgFormInfo();
        BgPeriodInfo _beginPeriod = _filterParam.getBgPeriodBegin();
        BgPeriodInfo _endPeriod = _filterParam.getBgPeriodEnd();
        VisualItemInfo _beginItem = _filterParam.getBeginBgItem();
        VisualItemInfo _endItem = _filterParam.getEndBgItem();
        BgElementInfo _bgElementInfo = _filterParam.getBgElementInfo();
        CurrencyInfo _currency = _filterParam.getCurrency();
        String _bgFormula = _filterParam.getBgFormula();
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodColl = null;
        Object info = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<String> dataID = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        StringBuffer tmpSql = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        sql.append("select t.FID  from T_BG_BgData t join T_BG_BgItemcombination i on t.FBgItemCombinId = i.FID join T_ORG_CostCenter cc on t.FOrgUnitId = cc.FID where ");
        if (orgUnitInfos != null && orgUnitInfos.length != 0) {
            StringBuffer orgSql = new StringBuffer();
            for (int n = 0; n < orgUnitInfos.length; ++n) {
                orgSql.append("?,");
                _tmpList.add(orgUnitInfos[n].getId().toString());
            }
            orgSql.deleteCharAt(orgSql.length() - 1);
            sql.append(" t.FOrgUnitId in ( ").append(orgSql.toString()).append(" )  ");
        }
        if (_bgSchemeInfo != null) {
            sql.append(" and t.FBgSchemeId IN (select FID from T_BG_BgScheme where FRootID = ?) ");
            _tmpList.add(_bgSchemeInfo.getRootId().toString());
        }
        if (_bgFormInfo != null) {
            sql.append(" and t.FBgTemplateId IN (select FID from T_BG_BgTemplate where FRootID = ?) ");
            _tmpList.add(_bgFormInfo.getBgTemplate().getRootId().toString());
        }
        if (_beginPeriod != null && _endPeriod != null && (bgPeriodColl = BgPeriodHelper.getPeriodColInfo(ctx, _beginPeriod.getBeginDate(), _endPeriod.getEndDate(), _beginPeriod.getPeriodType().getValue())) != null) {
            tmpSql = new StringBuffer(" and t.FBgPeriodId IN (");
            int in = bgPeriodColl.size();
            for (int i = 0; i < in; ++i) {
                bgPeriodInfo = bgPeriodColl.get(i);
                tmpSql.append("?,");
                _tmpList.add(bgPeriodInfo.getId().toString());
            }
            if (tmpSql.length() > 0) {
                tmpSql.delete(tmpSql.length() - 1, tmpSql.length());
            }
            sql.append(tmpSql).append(")");
        }
        if (_beginItem != null) {
            sql.append(" and (i.FKey >= ?)");
            _tmpList.add(_beginItem.getNumber().replaceAll(",", "_"));
        }
        if (_endItem != null) {
            sql.append(" and (i.FKey <= ?)");
            _tmpList.add(_endItem.getNumber().replaceAll(",", "_"));
        }
        if (_bgElementInfo != null) {
            sql.append(" and (t.FBgElementId = ?)");
            _tmpList.add(_bgElementInfo.getId().toString());
        }
        if (_currency != null) {
            sql.append(" and (t.FCurrencyId = ?)");
            _tmpList.add(_currency.getId().toString());
        }
        if (!StringUtils.isEmpty((String)_bgFormula)) {
            sql.append(" and t.FFormula like ?");
            _tmpList.add(_bgFormula);
        }
        sql.append(" order by t.FID");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                dataID.add(rst.getString("FID"));
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"queryBgDataInfo: ", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        if (dataID == null || dataID.isEmpty()) {
            return null;
        }
        ArrayList<BgExecuteAnalyseInfo> result = new ArrayList<BgExecuteAnalyseInfo>();
        int index = 0;
        int batchSize = 200;
        int size = dataID.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        sql = new StringBuffer();
        sql.append("select fid,fname_" + ctx.getLocale() + " fname,fnumber from T_ORG_BaseUnit where fid in (select FBillSourceOrgunitID from T_BG_BgCtrlRecord where FBgDataId IN ( ");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?) ) group by fid,fname_" + ctx.getLocale() + ",fnumber ");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, (String)dataID.get(pos));
                        continue;
                    }
                    pstmt.setString(x, "#");
                }
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                BgExecuteAnalyseInfo temp = new BgExecuteAnalyseInfo();
                temp.setBillSourceOrgunitID(rst.getString("fid"));
                temp.setBillSourceOrgunitNumber(rst.getString("fnumber"));
                temp.setBillSourceOrgunitName(rst.getString("fname"));
                result.add(temp);
            }
            return result;
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            logger.error((Object)"queryBgDataInfo: ", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        }
    }

    @Override
    protected Map _queryOrg(Context ctx, List id) throws BOSException, EASBizException {
        if (id == null || id.isEmpty()) {
            return null;
        }
        int index = 0;
        int batchSize = 200;
        int size = id.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select fid , fname_").append(ctx.getLocale()).append(" from T_ORG_BaseUnit where fid in (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("? )");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, (String)id.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
            }
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String key = rst.getString("fid");
                String value = rst.getString("fname_" + ctx.getLocale());
                if (result.containsKey(key)) continue;
                result.put(key, value);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryBgDataInfo: ", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return result;
    }

    @Override
    protected Map _getFatherBgItem(Context ctx, List itemNumbers) throws BOSException {
        if (itemNumbers == null || itemNumbers.isEmpty()) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        BgItemInfo info = null;
        LinkedHashMap<String, BgItemInfo> resultMap = new LinkedHashMap<String, BgItemInfo>();
        sql.append("Select S.FNumber sonNumber,S.Flevel SonLevel,S.FName_").append(ctx.getLocale()).append(" sonName,S.FParentID , F.Fid,F.FLevel FatherLevel,F.FNumber FatherNumber,F.FName_").append(ctx.getLocale()).append(" FatherName");
        sql.append(" From T_Bg_BgItem S Left Join T_Bg_BgItem F on S.FParentID = F.Fid where S.FNumber in (");
        for (int n = 0; n < itemNumbers.size(); ++n) {
            sql.append("'").append(itemNumbers.get(n)).append("',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" ) ");
        sql.append(" order by SonLevel desc ");
        IRowSet result = null;
        try {
            result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (result.next()) {
                if (result.getString("sonNumber").equals(result.getString("FatherNumber"))) continue;
                info = new BgItemInfo();
                info.setId(BOSUuid.read((String)result.getString("fid")));
                info.setNumber(result.getString("FatherNumber"));
                info.setName(result.getString("FatherName"));
                info.setLevel(result.getInt("FatherLevel"));
                resultMap.put(result.getString("sonNumber"), info);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"budget error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(result);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)result);
        return resultMap;
    }
}

