/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.AbstractBgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgAdjustBillEntryCollection;
import com.kingdee.eas.ma.budget.BgAdjustBillEntryInfo;
import com.kingdee.eas.ma.budget.BgAdjustBillFactory;
import com.kingdee.eas.ma.budget.BgAdjustBillInfo;
import com.kingdee.eas.ma.budget.BgAdjustStateEnum;
import com.kingdee.eas.ma.budget.BgAdjustTypeEnum;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgControlMultiRuleCollection;
import com.kingdee.eas.ma.budget.BgControlMultiRuleInfo;
import com.kingdee.eas.ma.budget.BgControlRuleCollection;
import com.kingdee.eas.ma.budget.BgControlRuleInfo;
import com.kingdee.eas.ma.budget.BgControlSchemeInfo;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.budget.BgCtrlMRCtrlRuleEnum;
import com.kingdee.eas.ma.budget.BgCtrlMRCtrlValueEnum;
import com.kingdee.eas.ma.budget.BgCtrlManualDecisionException;
import com.kingdee.eas.ma.budget.BgCtrlParamCollection;
import com.kingdee.eas.ma.budget.BgCtrlParamInfo;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgCtrlTypeEnum;
import com.kingdee.eas.ma.budget.BgDataFactory;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgGetPeriodTypeForGetBlanceEnum;
import com.kingdee.eas.ma.budget.BgMultiRuleCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BudgetCtrlConstants;
import com.kingdee.eas.ma.budget.BudgetCtrlState;
import com.kingdee.eas.ma.budget.BudgetCtrlUtil;
import com.kingdee.eas.ma.budget.BudgetRequestType;
import com.kingdee.eas.ma.budget.IBgAdjustBill;
import com.kingdee.eas.ma.budget.app.AbstractBgAutoCreateAdjustBillFacadeControllerBean;
import com.kingdee.eas.ma.budget.app.BgBalCalculator;
import com.kingdee.eas.ma.budget.app.BudgetCtrlCacheHelper;
import com.kingdee.eas.ma.budget.app.BudgetCtrlHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlBalCalculator;
import com.kingdee.eas.ma.nbudget.app.formula.BgAvlFormulaInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgAutoCreateAdjustBillFacadeControllerBean
extends AbstractBgAutoCreateAdjustBillFacadeControllerBean {
    private static final long serialVersionUID = -7436200384819259571L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgAutoCreateAdjustBillFacadeControllerBean");

    @Override
    protected Map _isOverBgItemInApproving(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        BudgetCtrlState state = new BudgetCtrlState(BudgetRequestType.WF_APPROVE);
        Map bgItemMap = this.requestBudget(ctx, state, billId, true);
        Map overBudgetItem = new HashMap();
        Map noBudgetItem = new HashMap();
        HashMap<BgCtrlResultInfo, BgCtrlResultInfo> approvItemMap = null;
        for (Map.Entry entry : bgItemMap.entrySet()) {
            String key = entry.getKey().toString();
            if (key.equals("1")) {
                overBudgetItem = (Map)entry.getValue();
                continue;
            }
            noBudgetItem = (Map)entry.getValue();
        }
        Iterator noBudgetIt = noBudgetItem.entrySet().iterator();
        boolean isBg063 = BgSHelper.isBgItemIsolate(ctx);
        if (noBudgetIt.hasNext()) {
            bgItemMap.put("1", null);
        } else {
            for (Map.Entry entry : overBudgetItem.entrySet()) {
                BgCtrlResultInfo ctrlResultInfo = (BgCtrlResultInfo)entry.getKey();
                if (!this.isBgBillInApproving(ctx, ctrlResultInfo, isBg063)) continue;
                approvItemMap = new HashMap<BgCtrlResultInfo, BgCtrlResultInfo>();
                approvItemMap.put(ctrlResultInfo, ctrlResultInfo);
                break;
            }
        }
        bgItemMap.put("2", approvItemMap);
        return bgItemMap;
    }

    @Override
    protected void _createBgAdjustBill(Context ctx, BOSUuid billId, Map info) throws BOSException, EASBizException {
        Map resultMap = new HashMap();
        Map bgItemMap = new HashMap();
        for (Map.Entry entry : info.entrySet()) {
            String itemType = entry.getKey().toString();
            if (!itemType.equals("1")) continue;
            bgItemMap = (Map)entry.getValue();
        }
        String billNum = "";
        String boName = BudgetCtrlHelper.getBOName(ctx, billId);
        String ouid = BudgetCtrlHelper.getBillOUID(ctx, billId.toString(), boName);
        BgAdjustBillInfo bgAdjustBillInfo = new BgAdjustBillInfo();
        FullOrgUnitInfo fullOrgUnit = new FullOrgUnitInfo();
        fullOrgUnit.setId(BOSUuid.read((String)ouid));
        bgAdjustBillInfo.setOrgUnit(fullOrgUnit);
        bgAdjustBillInfo.setState(BgAdjustStateEnum.ADJUST);
        UserInfo user = new UserInfo();
        user.setId(BOSUuid.read((String)this.getBillCreatorID(ctx, billId.toString(), boName)));
        bgAdjustBillInfo.setCreator(user);
        bgAdjustBillInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        BgAdjustBillEntryInfo entry = null;
        BgAdjustBillEntryCollection billColl = null;
        AbstractBgCtrlResultInfo ctrlResultInfo = null;
        BgCtrlResultInfo resultInfo = null;
        BgCtrlParamInfo ctrlParamInfo = null;
        resultMap = this.checkBeforeCreate(ctx, bgItemMap);
        int billCount = 0;
        for (Map.Entry tempEntry : resultMap.entrySet()) {
            ++billCount;
        }
        Map bgDataInfo = this.queryBgData(ctx, resultMap);
        Iterator itResult = resultMap.entrySet().iterator();
        while (itResult.hasNext()) {
            billColl = new BgAdjustBillEntryCollection();
            Map.Entry entryInfo = itResult.next();
            List bgDataList = (List)entryInfo.getValue();
            for (int i = 0; i < bgDataList.size(); ++i) {
                resultInfo = (BgCtrlResultInfo)bgDataList.get(i);
                for (Map.Entry tempEntry : bgItemMap.entrySet()) {
                    ctrlResultInfo = (BgCtrlResultInfo)tempEntry.getKey();
                    if (!resultInfo.equals(ctrlResultInfo)) continue;
                    ctrlParamInfo = (BgCtrlParamInfo)tempEntry.getValue();
                    break;
                }
                entry = this.createBgAdjustBillEntry(ctx, billId, (BgCtrlResultInfo)ctrlResultInfo, ctrlParamInfo, bgDataInfo);
                BgSchemeInfo bgSchemeInfo = new BgSchemeInfo();
                EntityViewInfo viewScheme = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)ctrlResultInfo.getOrgUnitId()));
                filter.getFilterItems().add(new FilterItemInfo("isFormal", (Object)Boolean.TRUE));
                viewScheme.setFilter(filter);
                CoreBaseCollection bgSchemeColl = BgSchemeFactory.getLocalInstance(ctx).getCollection(viewScheme);
                if (bgSchemeColl != null && bgSchemeColl.size() > 0) {
                    bgSchemeInfo = (BgSchemeInfo)bgSchemeColl.get(0);
                }
                bgAdjustBillInfo.setBgScheme(bgSchemeInfo);
                entry.setBgScheme(bgSchemeInfo);
                entry.setAdjustBill(bgAdjustBillInfo);
                billColl.add(entry);
            }
            bgAdjustBillInfo.put("entry", (Object)billColl);
            if (ctrlResultInfo != null) {
                billNum = ctrlResultInfo.getBillNumber();
            }
            Context ctxSubmit = Ctx.getContext((String)ctx.getAIS(), (String)user.getId().toString(), (String)ouid, null);
            IBgAdjustBill iBgAdjustBill = BgAdjustBillFactory.getLocalInstance(ctxSubmit);
            IObjectPK pk = null;
            if (billCount > 1) {
                for (int j = 1; j <= billCount; ++j) {
                    bgAdjustBillInfo.setNumber("BG" + billNum + "-" + j);
                    pk = iBgAdjustBill.save((CoreBaseInfo)bgAdjustBillInfo);
                    this.submitBgAdjustBill(ctx, pk.toString());
                }
                continue;
            }
            bgAdjustBillInfo.setNumber("BG" + billNum);
            pk = iBgAdjustBill.save((CoreBaseInfo)bgAdjustBillInfo);
            this.submitBgAdjustBill(ctx, pk.toString());
        }
    }

    private Map queryBgData(Context ctx, Map resultMap) throws BOSException {
        int i;
        HashMap<String, CoreBaseInfo> resMap = new HashMap<String, CoreBaseInfo>();
        HashSet<String> bgDataIds = new HashSet<String>();
        for (List bgDataList : resultMap.values()) {
            if (bgDataList == null || bgDataList.isEmpty()) continue;
            for (i = 0; i < bgDataList.size(); ++i) {
                BgCtrlResultInfo ctrlR = (BgCtrlResultInfo)bgDataList.get(i);
                bgDataIds.add(ctrlR.getBgDataId());
            }
        }
        if (bgDataIds.isEmpty()) {
            return resMap;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", bgDataIds, CompareType.INCLUDE));
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("bgFormId.id");
        evi.getSelector().add("bgItemCombinId");
        evi.getSelector().add("bgElement.id");
        evi.getSelector().add("currency.id");
        evi.getSelector().add("groupNo");
        evi.getSelector().add("bgScheme.id");
        evi.getSelector().add("ctrlType");
        evi.getSelector().add("flexParam");
        evi.getSelector().add("isAllowAccess");
        evi.getSelector().add("isControl");
        evi.getSelector().add("isFlexible");
        evi.getSelector().add("isGroupCtrl");
        CoreBaseCollection bgDataCol = BgDataFactory.getLocalInstance(ctx).getCollection(evi);
        if (bgDataCol != null && !bgDataCol.isEmpty()) {
            for (i = 0; i < bgDataCol.size(); ++i) {
                resMap.put(bgDataCol.get(i).getId().toString(), bgDataCol.get(i));
            }
        }
        return resMap;
    }

    private void submitBgAdjustBill(Context ctx, String pk) throws EASBizException, BOSException, UuidException {
        BillThread process = new BillThread(ctx, pk);
        process.start();
    }

    private BgAdjustBillEntryInfo createBgAdjustBillEntry(Context ctx, BOSUuid billId, BgCtrlResultInfo ctrlResultInfo, BgCtrlParamInfo ctrlParamInfo, Map bgDataInfo) throws BOSException, EASBizException {
        BgAdjustBillEntryInfo entry = new BgAdjustBillEntryInfo();
        entry.setAdjustGroup(0);
        entry.setAdjustBefore(BgConstants.BIGZERO);
        BigDecimal adjustApply = ctrlResultInfo.getReqAmount().subtract(ctrlResultInfo.getBalance());
        entry.setAdjustApply(adjustApply);
        entry.setAdjustPass(BgConstants.BIGZERO);
        entry.setAdjustAfter(BgConstants.BIGZERO);
        entry.setAdjustType(BgAdjustTypeEnum.VALUEADD);
        FullOrgUnitInfo fullOrgUnit = new FullOrgUnitInfo();
        fullOrgUnit.setId(BOSUuid.read((String)ctrlResultInfo.getOrgUnitId()));
        entry.setOrgUnit(fullOrgUnit);
        if (ctrlParamInfo.getItemFormula() != null) {
            entry.setFormula(ctrlParamInfo.getItemFormula());
        } else {
            entry.setFormula(null);
        }
        BgPeriodInfo periodInfo = new BgPeriodInfo();
        periodInfo.setId(BOSUuid.read((String)ctrlParamInfo.getPeriodId()));
        entry.setBgPeriod(periodInfo);
        BgDataInfo bgData = (BgDataInfo)bgDataInfo.get(ctrlResultInfo.getBgDataId());
        entry.setBgForm(bgData.getBgFormId());
        entry.setBgItemId(bgData.getBgItemCombinId());
        entry.setBgItemCmbName(ctrlParamInfo.getItemCombinName());
        entry.setBgElement(bgData.getBgElement());
        entry.setCurrency(bgData.getCurrency());
        entry.setCtrlGroupNo(bgData.getGroupNo());
        entry.setBgScheme(bgData.getBgScheme());
        entry.setCtrlType(bgData.getCtrlType());
        entry.setFlexParam(bgData.getFlexParam());
        entry.setIsAllowAccess(bgData.isIsAllowAccess());
        entry.setIsControl(bgData.isIsControl());
        entry.setIsFlexible(bgData.isIsFlexible());
        entry.setIsGroupCtrl(bgData.isIsGroupCtrl());
        return entry;
    }

    private boolean IsAutoCreateBgAdjustBill(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        String ouid;
        String boName = BudgetCtrlHelper.getBOName(ctx, billId);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, ouid = BudgetCtrlHelper.getBillOUID(ctx, billId.toString(), boName));
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return false;
        }
        return ctrlScheme.isIsAutoCreateBgAdjustBill();
    }

    private boolean isBgBillInApproving(Context ctx, BgCtrlResultInfo ctrlResultInfo, boolean isBg063) throws BOSException, EASBizException {
        boolean bl;
        IRowSet rst;
        block5: {
            String ouid = ctrlResultInfo.getOrgUnitId();
            String bgItemNumber = ctrlResultInfo.getItemCombinNumber();
            ArrayList<String> params = new ArrayList<String>();
            StringBuffer sql = new StringBuffer();
            sql.append(" select bill.FID from T_BG_BgAdjustBill bill");
            sql.append(" inner join T_BG_BgAdjustBillentry entry on bill.FID = entry.FAdjustBillID");
            sql.append(" where bill.FOrgUnitID = ?");
            params.add(ouid);
            sql.append(" and bill.Fstate = 3");
            sql.append(" and entry.FBgItem=");
            sql.append(" (select FID from t_bg_bgitemcombination where fkey =? )");
            params.add(bgItemNumber);
            rst = null;
            rst = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            if (!rst.next()) break block5;
            boolean bl2 = true;
            SQLUtils.cleanup((ResultSet)rst);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private Map checkBeforeCreate(Context ctx, Map bgItemMap) throws BOSException, EASBizException {
        HashMap resultMap = new HashMap();
        BgCtrlResultInfo ctrlResultInfo = null;
        StringBuffer bgDataIdStr = new StringBuffer();
        for (Map.Entry entryInfo : bgItemMap.entrySet()) {
            ctrlResultInfo = (BgCtrlResultInfo)entryInfo.getKey();
            bgDataIdStr.append("'");
            bgDataIdStr.append(ctrlResultInfo.getBgDataId());
            bgDataIdStr.append("',");
        }
        int index = bgDataIdStr.lastIndexOf(",");
        if (index >= 0) {
            bgDataIdStr.deleteCharAt(bgDataIdStr.lastIndexOf(","));
        }
        String sql = " select FBgFormId,FID from T_BG_BgData where FID in (" + bgDataIdStr.toString() + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            block6: while (rs.next()) {
                List<BgCtrlResultInfo> itemList = null;
                String formid = rs.getString(1);
                String fid = rs.getString(2);
                BgCtrlResultInfo tempInfo = null;
                for (Map.Entry entry1 : bgItemMap.entrySet()) {
                    ctrlResultInfo = (BgCtrlResultInfo)entry1.getKey();
                    if (!ctrlResultInfo.getBgDataId().equals(fid)) continue;
                    tempInfo = ctrlResultInfo;
                    break;
                }
                if (resultMap.containsKey(formid)) {
                    Map.Entry entry2;
                    Iterator it2 = resultMap.entrySet().iterator();
                    do {
                        if (!it2.hasNext()) continue block6;
                    } while (!(entry2 = it2.next()).getKey().equals(formid));
                    itemList = (List)entry2.getValue();
                    itemList.add(tempInfo);
                    resultMap.put(formid, itemList);
                    continue;
                }
                itemList = new ArrayList<BgCtrlResultInfo>();
                itemList.add(tempInfo);
                resultMap.put(formid, itemList);
            }
            return resultMap;
        }
        catch (SQLException e) {
            throw new BgException(BgException.DATABASEERROR, e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    private String getBillCreatorID(Context ctx, String boId, String boName) throws BOSException, EASBizException {
        String queryOUOQL = "select creator.id where id = '" + boId + "'";
        IDataProvider dataProvider = EntityExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(boName));
        dataProvider.setObjectView(queryOUOQL);
        String queryOUSQL = dataProvider.getSQL();
        IRowSet rst = null;
        try {
            rst = DbUtil.executeQuery((Context)ctx, (String)queryOUSQL);
            if (rst.next()) {
                String string = rst.getString(1);
                return string;
            }
            try {
                throw new BgException(BgException.ILLEGALARGUMENT, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"5_BgAutoCreateAdjustBillFacadeControllerBean", (Locale)ctx.getLocale()) + queryOUSQL});
            }
            catch (SQLException ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
    }

    private Map requestBudget(Context ctx, BudgetCtrlState state, BOSUuid boId, boolean isCheckBalance) throws BOSException, BgCtrlException, EASBizException {
        String ouid;
        BgCtrlResultCollection ctrlResultCol = new BgCtrlResultCollection();
        String boName = BudgetCtrlHelper.getBOName(ctx, boId);
        BgControlSchemeInfo ctrlScheme = BudgetCtrlHelper.getCtrlScheme(ctx, boName, ouid = BudgetCtrlHelper.getBillOUID(ctx, boId.toString(), boName));
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return null;
        }
        BgCtrlParamCollection ctrlParamCol = this.buildCtrlParamCol(ctx, boId.toString(), state, boName, ctrlScheme);
        ctrlResultCol = this.getBgCtrlResultCol(ctx, state, ctrlParamCol, ctrlResultCol);
        ctrlResultCol = this.requestSuperiorOrgBudget(ctx, state, ctrlScheme, ctrlParamCol, ctrlResultCol);
        Map returnData = this.getReturnBudget(ctx, boId.toString(), boName);
        ctrlResultCol = this.mergeReturnBudget(ctx, ctrlResultCol, returnData);
        ctrlResultCol = this.processMultiRule(ctx, ctrlParamCol, ctrlResultCol, ctrlScheme);
        Map bgItemList = this.checkBudget(ctx, ctrlResultCol, ctrlParamCol, ctrlScheme);
        return bgItemList;
    }

    private BgCtrlParamCollection buildCtrlParamCol(Context ctx, String boId, BudgetCtrlState state, String boName, BgControlSchemeInfo ctrlScheme) throws BOSException, EASBizException {
        BgCtrlParamCollection ctrlParamCol = new BgCtrlParamCollection();
        HashMap checkDumpParam = new HashMap();
        String boAlias = ctrlScheme.getBoAlias();
        BgControlRuleCollection ruleCol = ctrlScheme.getRules();
        for (int i = 0; i < ruleCol.size(); ++i) {
            BgControlRuleInfo rule = ruleCol.get(i);
            String oqlOrgUnit = rule.getOqlOrgUnit();
            String oqlItemCombination = rule.getOqlItemCombination();
            String aliasItemCombination = rule.getAliasItemCombination();
            String oqlCurrency = rule.getOqlCurrency();
            BgPeriodEnum periodType = rule.getPeriodCycle();
            String customBgPeriodNumber = rule.getCustomBgPeriodNumber();
            String elementNumber = rule.getElementNumber();
            String oqlBizDate = rule.getOqlBizDate();
            String oqlRequest = rule.getOqlRequest();
            String oqlRequestExp = rule.getOqlRequestExtendExpression();
            String oqlRuleCondition = rule.getOqlRuleCondition();
            ArrayList<String> billItemFields = new ArrayList<String>();
            String[] tpp = oqlItemCombination.split("\\@");
            for (int x = 0; x < tpp.length; ++x) {
                String[] subTpp = tpp[x].split("\\|");
                billItemFields.add(subTpp[0]);
            }
            List oqlList = BudgetCtrlHelper.getQueryBillOQL(ctx, boId, boName, oqlOrgUnit, oqlItemCombination, oqlCurrency, oqlBizDate, oqlRequest, oqlRequestExp, oqlRuleCondition);
            String queryBillOQL = (String)oqlList.get(0);
            int itemFieldCount = (Integer)oqlList.get(1);
            if ("com.kingdee.eas.fi.gl.app.Voucher".equals(boName)) {
                queryBillOQL = queryBillOQL + " and isMgCtrl = 1 ";
            }
            IDataProvider dataProvider = EntityExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(boName));
            dataProvider.setObjectView(queryBillOQL);
            String queryBillSQL = dataProvider.getSQL();
            if (!BudgetCtrlUtil.isEmpty(oqlRuleCondition)) {
                queryBillSQL = queryBillSQL.replaceAll("INNER JOIN", "LEFT OUTER JOIN");
                if ("com.kingdee.eas.fi.gl.app.Voucher".equals(boName)) {
                    queryBillSQL = queryBillSQL.replaceAll("SELECT ", "SELECT DISTINCT ");
                }
            }
            IRowSet rst = null;
            try {
                rst = DbUtil.executeQuery((Context)ctx, (String)queryBillSQL);
                while (rst.next()) {
                    BgCtrlParamInfo ctrlParamInfo = new BgCtrlParamInfo();
                    String _orgUnitNumber = BudgetCtrlUtil.replaceNULL(rst.getString(2), "");
                    if (BudgetCtrlUtil.isEmpty(_orgUnitNumber)) continue;
                    String _orgUnitName = BudgetCtrlUtil.replaceNULL(rst.getString(3), _orgUnitNumber);
                    CostCenterOrgUnitInfo orgInfo = BudgetCtrlCacheHelper.getCostCenter(ctx, _orgUnitNumber);
                    if (orgInfo == null) continue;
                    String _orgUnitId = orgInfo.getId().toString();
                    ctrlParamInfo.setOrgUnitId(_orgUnitId);
                    ctrlParamInfo.setOrgUnitName(_orgUnitName);
                    String _billItemNumber = "";
                    String _billItemFieldAndNumber = "";
                    String _billItemName = "";
                    String _itemCombinNumber = "";
                    boolean isInvalidate = false;
                    for (int j = 1; j <= itemFieldCount; ++j) {
                        String tempBillItemNumber = rst.getString(2 + 2 * j);
                        String tempBillItemName = rst.getString(2 + 2 * j + 1);
                        if (BudgetCtrlUtil.isEmpty(tempBillItemNumber)) {
                            isInvalidate = true;
                            break;
                        }
                        _billItemNumber = _billItemNumber + tempBillItemNumber + ",";
                        _billItemName = _billItemName + tempBillItemName + "_";
                        _billItemFieldAndNumber = _billItemFieldAndNumber + billItemFields.get(j - 1) + ":" + tempBillItemNumber + "|";
                    }
                    if (isInvalidate) continue;
                    _billItemNumber = BudgetCtrlUtil.deleteStrTail(_billItemNumber);
                    _billItemFieldAndNumber = BudgetCtrlUtil.deleteStrTail(_billItemFieldAndNumber);
                    _billItemName = BudgetCtrlUtil.deleteStrTail(_billItemName);
                    String mappedItemNumber = BudgetCtrlHelper.mappingBgItem(ctx, _billItemFieldAndNumber, ctrlScheme, _orgUnitId);
                    _itemCombinNumber = mappedItemNumber != null ? mappedItemNumber : _billItemNumber;
                    ctrlParamInfo.setItemCombinNumber(_itemCombinNumber);
                    ctrlParamInfo.setBillItemNumber(_billItemNumber);
                    ctrlParamInfo.setBillItemName(_billItemName);
                    ctrlParamInfo.setBillItemAlias(aliasItemCombination);
                    String _currencyNumber = rst.getString(4 + 2 * itemFieldCount);
                    ctrlParamInfo.setCurrencyNumber(_currencyNumber);
                    ctrlParamInfo.setElementNumber(elementNumber);
                    BgElementInfo elementInfo = BudgetCtrlCacheHelper.getBgElement(ctx, elementNumber);
                    ctrlParamInfo.setElementName(elementInfo.getName());
                    java.sql.Date _bizDate = rst.getDate(5 + 2 * itemFieldCount);
                    ctrlParamInfo.setBizDate(_bizDate);
                    BigDecimal requestValue = rst.getBigDecimal(6 + 2 * itemFieldCount);
                    requestValue = BudgetCtrlHelper.calcuRequestAmount(requestValue, oqlRequest, oqlRequestExp, rst, itemFieldCount);
                    ctrlParamInfo.setAmount(requestValue);
                    BgPeriodInfo bgPeriodInfo = null;
                    bgPeriodInfo = BudgetCtrlHelper.mappingBgPeriod(ctx, (Date)_bizDate, ctrlScheme, periodType.getValue(), customBgPeriodNumber);
                    if (bgPeriodInfo == null || bgPeriodInfo.getId() == null) continue;
                    String _periodId = bgPeriodInfo.getId().toString();
                    String _periodNumber = bgPeriodInfo.getNumber();
                    String _periodName = bgPeriodInfo.getName();
                    ctrlParamInfo.setPeriodId(_periodId);
                    ctrlParamInfo.setPeriodNumber(_periodNumber);
                    ctrlParamInfo.setPeriodName(_periodName);
                    ctrlParamInfo.setPeriodType(periodType);
                    String _srcBillNumber = BudgetCtrlUtil.replaceNULL(rst.getString(1), "");
                    ctrlParamInfo.setSrcBillId(boId);
                    ctrlParamInfo.setSrcBillNumber(_srcBillNumber);
                    ctrlParamInfo.setBillType(boAlias);
                    String _bgSchemeId = BudgetCtrlHelper.getActivedBgSchemeID(ctx, ctrlParamInfo, _bizDate, boName, boId);
                    if (BudgetCtrlUtil.isEmpty(_bgSchemeId)) {
                        BudgetCtrlHelper.mergeSameCtrlParam(ctrlParamInfo, ctrlParamCol, checkDumpParam);
                        continue;
                    }
                    ctrlParamInfo.setBgSchemeId(_bgSchemeId);
                    if (BudgetRequestType.GET_BUDGET == state.getRequestType()) {
                        BudgetCtrlHelper.mergeSameCtrlParam(ctrlParamInfo, ctrlParamCol, checkDumpParam);
                        continue;
                    }
                    ctrlParamCol.add((BgCtrlParamInfo)ctrlParamInfo.clone());
                }
                continue;
            }
            catch (SQLException ex) {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, ex);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw new BOSException((Throwable)ex);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        ctrlParamCol = BudgetCtrlHelper.processItemCombination(ctx, ctrlParamCol);
        checkDumpParam.clear();
        return ctrlParamCol;
    }

    private BgCtrlResultCollection getBgCtrlResultColBal(Context ctx, BudgetCtrlState state, BgCtrlParamCollection ctrlParamCol, BgCtrlResultCollection ctrlResultCol) throws BOSException, EASBizException {
        BgCtrlResultCollection ctrlCol = null;
        if (ctrlParamCol != null && ctrlParamCol.size() > 0) {
            for (int i = 0; i < ctrlParamCol.size(); ++i) {
                BgCtrlParamInfo ctrlParamInfo = ctrlParamCol.get(i);
                ctrlCol = BgBalCalculator.calcuBalCol(ctx, ctrlParamInfo, true, BgGetPeriodTypeForGetBlanceEnum.Is_Control);
                ctrlResultCol.addCollection(ctrlCol);
            }
        }
        return ctrlResultCol;
    }

    private BgCtrlResultCollection getBgCtrlResultCol(Context ctx, BudgetCtrlState state, BgCtrlParamCollection ctrlParamCol, BgCtrlResultCollection ctrlResultCol) throws BOSException, EASBizException {
        if (ctrlParamCol != null && ctrlParamCol.size() > 0) {
            for (int i = 0; i < ctrlParamCol.size(); ++i) {
                BgCtrlParamInfo ctrlParamInfo = ctrlParamCol.get(i);
                BgCtrlResultInfo ctrlResultInfo = null;
                String orgUnitId = ctrlParamInfo.getOrgUnitId();
                String bgSchemeId = ctrlParamInfo.getBgSchemeId();
                String formula = ctrlParamInfo.getItemFormula();
                if (!BudgetCtrlState.isNeedCalBalance(state)) {
                    BgDataInfo bgDataInfo = BgBalCalculator.getBgData(ctx, orgUnitId, bgSchemeId, formula, true);
                    ctrlResultInfo = new BgCtrlResultInfo();
                    ctrlResultInfo = BudgetCtrlHelper.fillCtrlParam2CtrlResult(ctrlParamInfo, ctrlResultInfo);
                    if (BudgetCtrlUtil.isEmpty(bgDataInfo)) {
                        ctrlResultInfo.setBgDataId(null);
                        ctrlResultInfo.setBalance(null);
                    } else {
                        ctrlResultInfo.setBgDataId(bgDataInfo.getId().toString());
                        ctrlResultInfo.setBgValue(bgDataInfo.getBgValue());
                        ctrlResultInfo.setBizActual(bgDataInfo.getBizActual());
                        ctrlResultInfo.setCtrlType(bgDataInfo.getCtrlType());
                        ctrlResultInfo.setIsAllowAccess(bgDataInfo.isIsAllowAccess());
                        ctrlResultInfo.setIsBalanced(true);
                    }
                    ctrlResultCol.add(ctrlResultInfo);
                    continue;
                }
                if (state.isNeedHint()) {
                    BgCtrlResultCollection ctrlCol = null;
                    ctrlCol = BgBalCalculator.calcuBalCol(ctx, ctrlParamInfo, true, BgGetPeriodTypeForGetBlanceEnum.Is_Control);
                    ctrlResultCol.addCollection(ctrlCol);
                    continue;
                }
                ctrlResultInfo = BgBalCalculator.calcuBal(ctx, ctrlParamInfo, true, BgGetPeriodTypeForGetBlanceEnum.Is_Control);
                ctrlResultCol.add(ctrlResultInfo);
            }
        }
        return ctrlResultCol;
    }

    private BgCtrlResultCollection requestSuperiorOrgBudget(Context ctx, BudgetCtrlState state, BgControlSchemeInfo ctrlScheme, BgCtrlParamCollection ctrlParamCol, BgCtrlResultCollection bgCtrlResultCol) throws BOSException, EASBizException {
        BgControlRuleCollection ruleCol = ctrlScheme.getRules();
        if (ruleCol == null || ruleCol.isEmpty()) {
            return bgCtrlResultCol;
        }
        boolean isFindUpperOrg = ctrlScheme.isIsFindUpperOrg();
        if (!isFindUpperOrg) {
            return bgCtrlResultCol;
        }
        int maxLevel = ctrlScheme.getFindUpperOrgMaxLevel();
        if (maxLevel < 1) {
            return bgCtrlResultCol;
        }
        HashMap<String, Object> orgUnitMap = new HashMap<String, Object>();
        for (int i = 0; i < ctrlParamCol.size(); ++i) {
            if (ctrlParamCol.get(i).getOrgUnitId() == null) continue;
            orgUnitMap.put(ctrlParamCol.get(i).getOrgUnitId(), null);
        }
        Map orgUnitParentMap = BudgetCtrlHelper.getParentOrgUnitMap(ctx, orgUnitMap, isFindUpperOrg, maxLevel);
        this.recursionSuperiorOrg(ctx, state, ctrlParamCol, bgCtrlResultCol, orgUnitParentMap);
        return bgCtrlResultCol;
    }

    private void recursionSuperiorOrg(Context ctx, BudgetCtrlState state, BgCtrlParamCollection ctrlParamCol, BgCtrlResultCollection ctrlResultCol, Map orgUnitParentMap) throws BOSException, EASBizException {
        BgCtrlResultInfo ctrlResultInfo;
        int i;
        BgCtrlParamCollection _ctrlParamCol = new BgCtrlParamCollection();
        BgCtrlResultCollection _ctrlResultCol = new BgCtrlResultCollection();
        for (i = ctrlResultCol.size() - 1; i >= 0; --i) {
            BgCtrlParamInfo newCtrlParamInfo;
            ctrlResultInfo = ctrlResultCol.get(i);
            if (ctrlResultInfo.getBgDataId() != null || !orgUnitParentMap.containsKey((newCtrlParamInfo = (BgCtrlParamInfo)ctrlParamCol.get(i).clone()).getOrgUnitId())) continue;
            CostCenterOrgUnitInfo parentOrg = (CostCenterOrgUnitInfo)orgUnitParentMap.get(newCtrlParamInfo.getOrgUnitId());
            String newCCID = parentOrg.getId().toString();
            String newCCName = parentOrg.getName();
            newCtrlParamInfo.setOrgUnitId(newCCID);
            newCtrlParamInfo.setOrgUnitName(newCCName);
            String activeBgSchemeId = BudgetCtrlHelper.getActivedBgSchemeID(ctx, newCtrlParamInfo, newCtrlParamInfo.getBizDate());
            newCtrlParamInfo.setBgSchemeId(activeBgSchemeId);
            newCtrlParamInfo.put("index", new Integer(i));
            _ctrlParamCol.add(newCtrlParamInfo);
        }
        if (_ctrlParamCol != null && _ctrlParamCol.size() > 0) {
            _ctrlResultCol = this.getBgCtrlResultCol(ctx, state, _ctrlParamCol, new BgCtrlResultCollection());
            for (i = 0; _ctrlResultCol != null && !_ctrlResultCol.isEmpty() && i < _ctrlResultCol.size(); ++i) {
                ctrlResultInfo = _ctrlResultCol.get(i);
                if (ctrlResultInfo.getBgDataId() != null) {
                    if (_ctrlParamCol.get(i) == null) {
                        ctrlResultCol.add((BgCtrlResultInfo)ctrlResultInfo.clone());
                    } else {
                        ctrlResultCol.set((Integer)_ctrlParamCol.get(i).get("index"), (BgCtrlResultInfo)ctrlResultInfo.clone());
                    }
                }
                if (_ctrlParamCol.get(i) == null) continue;
                ctrlParamCol.set((Integer)_ctrlParamCol.get(i).get("index"), (BgCtrlParamInfo)_ctrlParamCol.get(i).clone());
            }
            for (i = ctrlResultCol.size() - 1; i >= 0; --i) {
                if (ctrlResultCol.get(i).getBgDataId() != null) continue;
                this.recursionSuperiorOrg(ctx, state, ctrlParamCol, ctrlResultCol, orgUnitParentMap);
                break;
            }
        }
    }

    private Map getReturnBudget(Context ctx, String boId, String boName) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> returnDataMap = new HashMap<String, BigDecimal>();
        if (BudgetCtrlHelper.isCPBCBill(boName)) {
            return returnDataMap;
        }
        StringBuffer sql = new StringBuffer(512);
        sql.append(" select FBgDataId,");
        sql.append("        FActualAmount");
        sql.append("   from T_Bg_BgCtrlRecord");
        sql.append("  where FBillId = ?");
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{boId});
        try {
            while (rst.next()) {
                String bgDataId = rst.getString("FBgDataId");
                BigDecimal actualAmount = rst.getBigDecimal("FActualAmount");
                if (actualAmount == null) {
                    actualAmount = BudgetCtrlConstants.ZERO_AMOUNT;
                }
                if (returnDataMap.containsKey(bgDataId)) {
                    BigDecimal val = (BigDecimal)returnDataMap.get(bgDataId);
                    returnDataMap.put(bgDataId, actualAmount.add(val));
                    continue;
                }
                returnDataMap.put(bgDataId, actualAmount);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, ex);
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        return returnDataMap;
    }

    private BgCtrlResultCollection mergeReturnBudget(Context ctx, BgCtrlResultCollection ctrlResultCol, Map returnData) throws BOSException, EASBizException {
        if (BudgetCtrlUtil.isEmpty((Object)ctrlResultCol) || BudgetCtrlUtil.isEmpty(returnData)) {
            return ctrlResultCol;
        }
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal balance = ctrlResultInfo.getBalance();
            if (bgDataId == null || balance == null || !returnData.containsKey(bgDataId)) continue;
            BigDecimal returnVal = (BigDecimal)returnData.get(bgDataId);
            ctrlResultInfo.setBalance(balance.add(returnVal));
        }
        return ctrlResultCol;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BgCtrlResultCollection processMultiRule(Context ctx, BgCtrlParamCollection ctrlParamCol, BgCtrlResultCollection ctrlResultCol, BgControlSchemeInfo ctrlScheme) throws EASBizException, BOSException {
        if (ctrlScheme == null || ctrlScheme.getRules() == null || ctrlScheme.getRules().size() == 0) {
            return ctrlResultCol;
        }
        BgControlMultiRuleCollection multiRuleCol = ctrlScheme.getMultiRule();
        if (multiRuleCol == null || multiRuleCol.size() == 0) {
            return ctrlResultCol;
        }
        if (BudgetCtrlUtil.isEmpty((Object)ctrlParamCol) || BudgetCtrlUtil.isEmpty((Object)ctrlResultCol)) {
            return ctrlResultCol;
        }
        Map multiRuleMap = BudgetCtrlHelper.processMultiRuleCol(multiRuleCol);
        HashMap groupCheckMap = new HashMap();
        Map<String, BgControlMultiRuleInfo> groupitem = null;
        for (int i = 0; i < multiRuleCol.size(); ++i) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i);
            boolean isGourpCheck = multiRule.isIsGroupCheck();
            if (!isGourpCheck) continue;
            String ctrlItemCombinId = multiRule.getCtrlItemCombinId();
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            if (groupCheckMap.containsKey(ctrlItemCombinId)) {
                groupitem = (Map)groupCheckMap.get(ctrlItemCombinId);
                groupitem.put(bizItemCombNumber, multiRule);
            } else {
                groupitem = new HashMap();
                groupitem.put(bizItemCombNumber, multiRule);
            }
            groupCheckMap.put(ctrlItemCombinId, groupitem);
        }
        HashMap<String, BgCtrlResultInfo> ctrlResultInfoCache = new HashMap<String, BgCtrlResultInfo>();
        HashMap<String, String> bgDataBgFormCache = new HashMap<String, String>();
        HashMap<String, BgFormInfo> bgFormInfoCache = new HashMap<String, BgFormInfo>();
        HashMap<String, CostCenterOrgUnitInfo> orgUnitCache = new HashMap<String, CostCenterOrgUnitInfo>();
        HashMap<String, BgSchemeInfo> bgSchemeCache = new HashMap<String, BgSchemeInfo>();
        int i = 0;
        while (true) {
            block41: {
                BigDecimal groupItemBal;
                BigDecimal bizItemSumActVal;
                BigDecimal bizItemSumBgVal;
                BigDecimal ctrlItemSumExeVal;
                BigDecimal ctrlItemSumActVal;
                BigDecimal ctrlItemSumBgVal;
                BigDecimal compareValue;
                BgCtrlMRCtrlRuleEnum ctrlRule;
                BigDecimal coe;
                BgCtrlMRCtrlValueEnum ctrlValue;
                BgMultiRuleCtrlResultInfo multiRuleCtrlResult;
                BigDecimal bizItemBal;
                BgCtrlResultInfo bizItemCtrlRusultInfo;
                block44: {
                    String BgFormId;
                    ReportCalculateErrorProvider errorProvider;
                    ReportVariables variables;
                    BgRptReportPropertyAdapter adapter;
                    ReportCalculateContext context;
                    String CtrlItemID;
                    BigDecimal decvalue;
                    BigDecimal groupBgVal;
                    String bizItemCombNumber;
                    BgCtrlParamInfo ctrlParamInfo;
                    block45: {
                        IRowSet rst;
                        BgControlMultiRuleInfo groupMultiRuleInfo;
                        BgCtrlResultInfo ctrlItemCtrlResultInfo;
                        String ctrlItemCombNumber;
                        BgControlMultiRuleInfo multiRuleInfo;
                        block43: {
                            block42: {
                                block40: {
                                    if (i >= ctrlResultCol.size()) {
                                        ctrlResultInfoCache.clear();
                                        bgDataBgFormCache.clear();
                                        bgFormInfoCache.clear();
                                        orgUnitCache.clear();
                                        bgSchemeCache.clear();
                                        return ctrlResultCol;
                                    }
                                    bizItemCtrlRusultInfo = ctrlResultCol.get(i);
                                    String bizItemBgDataId = bizItemCtrlRusultInfo.getBgDataId();
                                    if (bizItemBgDataId != null) break block40;
                                    bizItemCtrlRusultInfo.setIsMultiRuleCtrl(false);
                                    bizItemCtrlRusultInfo.setMultiRuleCtrlResult(null);
                                    break block41;
                                }
                                bizItemBal = bizItemCtrlRusultInfo.getBalance();
                                ctrlParamInfo = ctrlParamCol.get(i);
                                bizItemCombNumber = ctrlParamInfo.getItemCombinNumber().replaceAll(",", "_");
                                if (multiRuleMap.containsKey(bizItemCombNumber)) break block42;
                                bizItemCtrlRusultInfo.setIsMultiRuleCtrl(false);
                                bizItemCtrlRusultInfo.setMultiRuleCtrlResult(null);
                                break block41;
                            }
                            String periodNumber = ctrlParamInfo.getPeriodNumber();
                            String currencyNumber = ctrlParamInfo.getCurrencyNumber();
                            String elementNumber = ctrlParamInfo.getElementNumber();
                            multiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber);
                            ctrlItemCombNumber = multiRuleInfo.getCtrlItemCombinNumber();
                            String ctrlItemFormula = BudgetCtrlUtil.buildItemFormula(ctrlItemCombNumber.replaceAll("_", ","), periodNumber, elementNumber, currencyNumber);
                            ctrlItemCtrlResultInfo = null;
                            String ctrlResultInfoCacheKey = ctrlParamInfo.getOrgUnitId() + "@" + ctrlParamInfo.getBgSchemeId() + "@" + ctrlItemFormula;
                            if (!ctrlResultInfoCache.containsKey(ctrlResultInfoCacheKey)) {
                                BgCtrlParamInfo cloneCtrlParamInfo = (BgCtrlParamInfo)ctrlParamInfo.clone();
                                cloneCtrlParamInfo.setItemFormula(ctrlItemFormula);
                                cloneCtrlParamInfo.setItemCombinNumber(ctrlItemCombNumber);
                                ctrlItemCtrlResultInfo = BgBalCalculator.calcuBal(ctx, cloneCtrlParamInfo, true, BgGetPeriodTypeForGetBlanceEnum.Is_Control);
                                ctrlResultInfoCache.put(ctrlResultInfoCacheKey, ctrlItemCtrlResultInfo);
                            } else {
                                ctrlItemCtrlResultInfo = (BgCtrlResultInfo)ctrlResultInfoCache.get(ctrlResultInfoCacheKey);
                            }
                            if (ctrlItemCtrlResultInfo != null && ctrlItemCtrlResultInfo.getBgDataId() != null) break block43;
                            bizItemCtrlRusultInfo.setIsMultiRuleCtrl(false);
                            bizItemCtrlRusultInfo.setMultiRuleCtrlResult(null);
                            break block41;
                        }
                        bizItemCtrlRusultInfo.setIsMultiRuleCtrl(true);
                        String ctrlItemBgDataId = ctrlItemCtrlResultInfo.getBgDataId();
                        BigDecimal ctrlItemBgVal = ctrlItemCtrlResultInfo.getBgValue();
                        BigDecimal ctrlItemActVal = ctrlItemCtrlResultInfo.getBizActual();
                        String ctrlItemCombName = multiRuleInfo.getCtrlItemCombinAlias().replaceAll(",", "_");
                        multiRuleCtrlResult = new BgMultiRuleCtrlResultInfo();
                        multiRuleCtrlResult.setBgDataId(ctrlItemBgDataId);
                        multiRuleCtrlResult.setItemCombinNumber(ctrlItemCombNumber);
                        multiRuleCtrlResult.setItemCombinName(ctrlItemCombName);
                        multiRuleCtrlResult.setBgValue(ctrlItemBgVal);
                        multiRuleCtrlResult.setBizActual(ctrlItemActVal);
                        bizItemCtrlRusultInfo.setMultiRuleCtrlResult(multiRuleCtrlResult);
                        ctrlValue = multiRuleInfo.getCtrlValue();
                        coe = multiRuleInfo.getCtrlCoe();
                        ctrlRule = multiRuleInfo.getCtrlRule();
                        compareValue = BgNConstants.ZERO;
                        ctrlItemSumBgVal = (BigDecimal)ctrlItemCtrlResultInfo.get("sumBudgetValue");
                        ctrlItemSumActVal = (BigDecimal)ctrlItemCtrlResultInfo.get("sumActualValue");
                        ctrlItemSumExeVal = ctrlItemSumBgVal.compareTo(BudgetCtrlConstants.ZERO_AMOUNT) == 0 ? BudgetCtrlConstants.ZERO_AMOUNT : ctrlItemSumActVal.divide(ctrlItemSumBgVal, 8, 4);
                        bizItemSumBgVal = (BigDecimal)bizItemCtrlRusultInfo.get("sumBudgetValue");
                        groupItemBal = bizItemSumActVal = (BigDecimal)bizItemCtrlRusultInfo.get("sumActualValue");
                        groupBgVal = bizItemSumBgVal;
                        if (multiRuleMap == null || multiRuleMap.size() == 0 || groupCheckMap.isEmpty() || groupCheckMap.size() == 0) break block44;
                        decvalue = BgNConstants.ZERO;
                        if (!multiRuleMap.containsKey(bizItemCombNumber) || !groupCheckMap.containsKey(CtrlItemID = (groupMultiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber)).getCtrlItemCombinId()) || !groupMultiRuleInfo.isIsGroupCheck()) break block44;
                        context = null;
                        adapter = null;
                        variables = new ReportVariables();
                        errorProvider = new ReportCalculateErrorProvider();
                        BgFormId = null;
                        if (bgDataBgFormCache.containsKey(ctrlItemBgDataId)) {
                            BgFormId = (String)bgDataBgFormCache.get(ctrlItemBgDataId);
                        } else {
                            block39: {
                                StringBuffer SQL = new StringBuffer(2048);
                                SQL.append(" select t.fbgformid from t_bg_bgdata t where t.fid= ?");
                                rst = null;
                                rst = DbUtil.executeQuery((Context)ctx, (String)SQL.toString(), (Object[])new String[]{ctrlItemBgDataId});
                                if (rst.next()) break block39;
                                BgCtrlResultCollection bgCtrlResultCollection = null;
                                SQLUtils.cleanup((ResultSet)rst);
                                return bgCtrlResultCollection;
                            }
                            BgFormId = rst.getString("FBgFormId");
                            bgDataBgFormCache.put(ctrlItemBgDataId, BgFormId);
                            SQLUtils.cleanup((ResultSet)rst);
                        }
                        break block45;
                        catch (SQLException ex) {
                            try {
                                logger.error((Object)"budget error:", (Throwable)ex);
                                throw new BgException(BgException.DATABASEERROR, new Object[]{ex.getMessage()});
                                catch (Exception ex2) {
                                    logger.error((Object)"budget error:", (Throwable)ex2);
                                    throw new BOSException((Throwable)ex2);
                                }
                            }
                            catch (Throwable throwable) {
                                SQLUtils.cleanup(rst);
                                throw throwable;
                            }
                        }
                    }
                    BgFormInfo bgForm = null;
                    if (bgFormInfoCache.containsKey(BgFormId)) {
                        bgForm = (BgFormInfo)bgFormInfoCache.get(BgFormId);
                    } else {
                        ObjectUuidPK BgFormpk = new ObjectUuidPK(BOSUuid.read((String)BgFormId));
                        bgForm = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)BgFormpk, BgAutoCreateAdjustBillFacadeControllerBean.getBgFormSelectors());
                        bgFormInfoCache.put(BgFormId, bgForm);
                    }
                    String _ctrlOrgid = ctrlParamInfo.getOrgUnitId();
                    String _ctrlOrgnum = null;
                    if (orgUnitCache.containsKey(_ctrlOrgid)) {
                        _ctrlOrgnum = ((CostCenterOrgUnitInfo)orgUnitCache.get(_ctrlOrgid)).getNumber();
                    } else {
                        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)_ctrlOrgid));
                        CostCenterOrgUnitInfo orgUnitInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)pk);
                        _ctrlOrgnum = orgUnitInfo.getNumber();
                        orgUnitCache.put(_ctrlOrgid, orgUnitInfo);
                    }
                    String _bgSchemeId = ctrlParamInfo.getBgSchemeId();
                    String _bgSchemeNumber = null;
                    if (bgSchemeCache.containsKey(_bgSchemeId)) {
                        _bgSchemeNumber = ((BgSchemeInfo)bgSchemeCache.get(_bgSchemeId)).getNumber();
                    } else {
                        ObjectUuidPK apk = new ObjectUuidPK(BOSUuid.read((String)_bgSchemeId));
                        BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo((IObjectPK)apk);
                        _bgSchemeNumber = bgSchemeInfo.getNumber();
                        bgSchemeCache.put(_bgSchemeId, bgSchemeInfo);
                    }
                    Map group = (Map)groupCheckMap.get(CtrlItemID);
                    Iterator it = group.entrySet().iterator();
                    adapter = new BgRptReportPropertyAdapter(bgForm);
                    context = new ReportCalculateContext(ctx, (IReportPropertyAdapter)adapter, variables, (IErrorProvider)errorProvider, null);
                    BgAvlBalCalculator bgAvlBal = new BgAvlBalCalculator((ICalculateContextProvider)context, ctx);
                    SortedParameterArray params = new SortedParameterArray();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        String bizitem = (String)entry.getKey();
                        BgControlMultiRuleInfo value = (BgControlMultiRuleInfo)entry.getValue();
                        if (bizitem.equals(bizItemCombNumber)) continue;
                        String _bgElementNumber = ctrlParamInfo.getElementNumber();
                        String _bgItemNumber = bizitem.replaceAll("_", ",");
                        String _currencyNumber = ctrlParamInfo.getCurrencyNumber();
                        String _PeriodNumber = ctrlParamInfo.getPeriodNumber();
                        Object[] obj = new Object[]{new Variant((Object)_ctrlOrgnum), new Variant((Object)_bgSchemeNumber), new Variant((Object)_bgElementNumber), new Variant((Object)_bgItemNumber), new Variant((Object)_currencyNumber), new Variant((Object)_PeriodNumber)};
                        Parameter tmp = new Parameter(obj, "", false);
                        params.append((Object)tmp);
                    }
                    bgAvlBal.execute(params);
                    List formulailist = bgAvlBal.getCalDataList();
                    if (formulailist == null || formulailist.size() == 0) {
                        decvalue = BgNConstants.ZERO;
                    } else {
                        BgAvlFormulaInfo bgFormula = null;
                        String bgItemNumber = null;
                        for (int bizItemIdx = 0; bizItemIdx < formulailist.size(); ++bizItemIdx) {
                            bgFormula = (BgAvlFormulaInfo)formulailist.get(bizItemIdx);
                            bgItemNumber = bgFormula.getBgItemNumber().replaceAll(",", "_");
                            if (bgFormula.getActualValue() != null) {
                                groupItemBal = groupItemBal.add(bgFormula.getActualValue());
                            }
                            if (group.get(bgItemNumber) == null || !((BgControlMultiRuleInfo)group.get(bgItemNumber)).getCtrlValue().equals((Object)BgCtrlMRCtrlValueEnum.EXERATIO)) continue;
                            groupBgVal = groupBgVal.add(bgFormula.getBudgetValue());
                        }
                    }
                    groupItemBal = groupItemBal.add(decvalue);
                    bizItemSumBgVal = groupBgVal;
                }
                bizItemSumActVal = groupItemBal;
                if (ctrlValue.getValue() == 1) {
                    compareValue = ctrlItemSumBgVal.multiply(coe).subtract(bizItemSumActVal);
                } else if (ctrlValue.getValue() == 2) {
                    compareValue = ctrlItemSumActVal.multiply(coe).subtract(bizItemSumActVal);
                } else if (ctrlValue.getValue() == 3) {
                    compareValue = bizItemSumBgVal.multiply(ctrlItemSumExeVal).subtract(bizItemSumActVal);
                }
                if (ctrlRule.getValue() == 1) {
                    bizItemCtrlRusultInfo.setBalance(compareValue);
                } else if (ctrlRule.getValue() == 2) {
                    bizItemCtrlRusultInfo.setBalance(bizItemBal.compareTo(compareValue) > 0 ? bizItemBal : compareValue);
                } else if (ctrlRule.getValue() == 3) {
                    bizItemCtrlRusultInfo.setBalance(bizItemBal.compareTo(compareValue) > 0 ? compareValue : bizItemBal);
                }
                multiRuleCtrlResult.setBalance(bizItemBal);
            }
            ++i;
        }
    }

    private Map checkBudget(Context ctx, BgCtrlResultCollection ctrlResultCol, BgCtrlParamCollection ctrlParamCol, BgControlSchemeInfo ctrlScheme) throws BgCtrlException, BgCtrlManualDecisionException {
        BgControlRuleCollection ruleCol = ctrlScheme.getRules();
        if (BudgetCtrlUtil.isEmpty((Object)ruleCol)) {
            return null;
        }
        boolean isCanControlWithoutBudget = ctrlScheme.isIsCanControlWithoutBudget();
        boolean isAllowAccess = ctrlScheme.isIsAllowExcess();
        return this.analyseCtrlResultCol(ctx, isCanControlWithoutBudget, isAllowAccess, ctrlResultCol, ctrlParamCol, ctrlScheme);
    }

    private Map analyseCtrlResultCol(Context ctx, boolean isCanControlWithoutBudget, boolean isAllowAccessCtrlScheme, BgCtrlResultCollection ctrlResultCol, BgCtrlParamCollection ctrlParamCol, BgControlSchemeInfo ctrlScheme) {
        BgCtrlParamInfo ctrlParamInfo;
        int i;
        HashMap resultMap = new HashMap();
        HashMap<BgCtrlResultInfo, BgCtrlParamInfo> noBudgetItem = new HashMap<BgCtrlResultInfo, BgCtrlParamInfo>();
        HashMap<BgCtrlResultInfo, BgCtrlParamInfo> overBudgetItem = new HashMap<BgCtrlResultInfo, BgCtrlParamInfo>();
        BgControlMultiRuleCollection multiRuleCol = ctrlScheme.getMultiRule();
        HashMap<String, BgControlMultiRuleInfo> multiRuleMap = new HashMap<String, BgControlMultiRuleInfo>();
        if (multiRuleCol == null || multiRuleCol.size() == 0) {
            // empty if block
        }
        for (int i2 = 0; i2 < multiRuleCol.size(); ++i2) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i2);
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            multiRuleMap.put(bizItemCombNumber, multiRule);
        }
        HashMap groupCheckMap = new HashMap();
        for (int i3 = 0; i3 < multiRuleMap.size(); ++i3) {
            BgControlMultiRuleInfo multiRule = multiRuleCol.get(i3);
            boolean isGourpCheck = multiRule.isIsGroupCheck();
            if (!isGourpCheck) continue;
            Map<String, BgControlMultiRuleInfo> groupitem = new HashMap<String, BgControlMultiRuleInfo>();
            String ItemCombNumber = multiRule.getCtrlItemCombinId();
            String bizItemCombNumber = multiRule.getBizItemCombinNumber();
            if (groupCheckMap.containsKey(ItemCombNumber)) {
                groupitem = (Map)groupCheckMap.get(ItemCombNumber);
                groupitem.put(bizItemCombNumber, multiRule);
            } else {
                groupitem.put(bizItemCombNumber, multiRule);
            }
            groupCheckMap.put(ItemCombNumber, groupitem);
        }
        HashMap<String, BigDecimal> bgDataId2SumReqAmtMap = new HashMap<String, BigDecimal>();
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            BgControlMultiRuleInfo groupMultiRuleInfo;
            String CtrlItemID;
            boolean isGroupCtrl;
            BgDataInfo bgDataInfo;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            ctrlParamInfo = ctrlParamCol.get(i);
            String bizItemCombNumber = ctrlParamInfo.getItemCombinNumber().replaceAll(",", "_");
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId())) {
                if (isCanControlWithoutBudget) continue;
                if (!resultMap.containsKey(ctrlResultInfo)) {
                    noBudgetItem.put(ctrlResultInfo, ctrlParamInfo);
                }
            }
            boolean isCtrl = (bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData")) != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl) continue;
            BigDecimal balance = ctrlResultInfo.getBalance();
            BigDecimal reqAmount = ctrlResultInfo.getReqAmount();
            if (balance == null || reqAmount == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean append = true;
            boolean bl = isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo();
                if (bgDataId2SumReqAmtMap.containsKey(groupNo) && bgDataId2SumReqAmtMap.get(groupNo) instanceof BigDecimal) {
                    BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(groupNo);
                    sumReqAmt = _reqAmt.add(reqAmount);
                    if (_reqAmt.compareTo(balance) > 0) {
                        append = false;
                    }
                } else {
                    sumReqAmt = reqAmount;
                }
                bgDataId2SumReqAmtMap.put(groupNo, sumReqAmt);
                continue;
            }
            if (bgDataId2SumReqAmtMap.containsKey(bgDataId) && bgDataId2SumReqAmtMap.get(bgDataId) instanceof BigDecimal) {
                BigDecimal _reqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
                sumReqAmt = _reqAmt.add(reqAmount);
                if (_reqAmt.compareTo(balance) > 0) {
                    append = false;
                }
            } else {
                sumReqAmt = reqAmount;
            }
            if (multiRuleMap != null && multiRuleMap.size() != 0 && !groupCheckMap.isEmpty() && groupCheckMap.size() != 0 && multiRuleMap.containsKey(bizItemCombNumber) && groupCheckMap.containsKey(CtrlItemID = (groupMultiRuleInfo = (BgControlMultiRuleInfo)multiRuleMap.get(bizItemCombNumber)).getCtrlItemCombinId()) && groupMultiRuleInfo.isIsGroupCheck()) {
                Map group = (Map)groupCheckMap.get(CtrlItemID);
                for (int k = 0; k < ctrlResultCol.size(); ++k) {
                    BgCtrlResultInfo tmpResultInfo = ctrlResultCol.get(k);
                    String tmpitem = tmpResultInfo.getItemCombinNumber().replaceAll(",", "_");
                    if (!group.containsKey(tmpitem) || bizItemCombNumber.equals(tmpitem)) continue;
                    sumReqAmt = sumReqAmt.add(tmpResultInfo.getReqAmount());
                }
            }
            bgDataId2SumReqAmtMap.put(bgDataId, sumReqAmt);
        }
        for (i = 0; i < ctrlResultCol.size(); ++i) {
            boolean isGroupCtrl;
            BigDecimal balance;
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            ctrlParamInfo = ctrlParamCol.get(i);
            if (BudgetCtrlUtil.isEmpty(ctrlResultInfo.getBgDataId()) && isCanControlWithoutBudget) continue;
            BgDataInfo bgDataInfo = (BgDataInfo)ctrlResultInfo.get("bgData");
            boolean isCtrl = bgDataInfo != null ? bgDataInfo.isIsControl() : false;
            BgCtrlTypeEnum ctrlType = ctrlResultInfo.getCtrlType();
            if (!isCtrl || ctrlType == BgCtrlTypeEnum.NoCtrl || (balance = ctrlResultInfo.getBalance()) == null) continue;
            String bgDataId = ctrlResultInfo.getBgDataId();
            BigDecimal sumReqAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            boolean append = true;
            boolean bl = isGroupCtrl = bgDataInfo == null ? false : bgDataInfo.isIsGroupCtrl();
            if (isGroupCtrl) {
                String groupNo = bgDataInfo.getGroupNo();
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(groupNo);
            } else {
                sumReqAmt = (BigDecimal)bgDataId2SumReqAmtMap.get(bgDataId);
            }
            if (sumReqAmt == null || sumReqAmt.compareTo(balance) <= 0 || !append || isAllowAccessCtrlScheme && ctrlResultInfo.isIsAllowAccess() || resultMap.containsKey(ctrlResultInfo)) continue;
            overBudgetItem.put(ctrlResultInfo, ctrlParamInfo);
        }
        resultMap.put("0", noBudgetItem);
        resultMap.put("1", overBudgetItem);
        return resultMap;
    }

    public static SelectorItemCollection getBgFormSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("CU.id");
        sic.add("CU.name");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.period");
        sic.add("bgScheme.rootId");
        sic.add("bgScheme.isFormal");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.canModify");
        sic.add("bgTemplate.parent.id");
        sic.add("bgTemplate.rootId");
        sic.add("bgTemplate.formType");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("periodType");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        return sic;
    }

    class BillThread
    extends Thread {
        private Context ctx = null;
        private String pk = null;

        public BillThread(Context ctx, String pk) {
            this.ctx = ctx;
            this.pk = pk;
        }

        @Override
        public void run() {
            if (this.ctx == null) {
                return;
            }
            IBgAdjustBill ibill = null;
            try {
                ibill = BgAdjustBillFactory.getLocalInstance(this.ctx);
                ibill.submitRefer(BOSUuid.read((String)this.pk.toString()));
            }
            catch (Exception e) {
                logger.error((Object)"submitAdjustBillError ", (Throwable)e);
            }
            finally {
                ibill = null;
            }
        }
    }
}

