/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgColForPeriodFormFactory;
import com.kingdee.eas.ma.budget.BgColForPeriodFormInfo;
import com.kingdee.eas.ma.budget.BgCollectStateEnum;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgColForPeriodForm;
import com.kingdee.eas.ma.budget.RefBgColPeriodsCollection;
import com.kingdee.eas.ma.budget.app.AbstractBgColForPeriodFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgColForPeriodFacadeControllerBean
extends AbstractBgColForPeriodFacadeControllerBean {
    private static final long serialVersionUID = 9022998704535749878L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgColForPeriodFacadeControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectCollection _getSourcePeriod(Context ctx, String bgFormId, int periodType) throws BOSException, EASBizException {
        BgPeriodCollection periodCol = new BgPeriodCollection();
        if (bgFormId == null) return periodCol;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgPeriodInfo perInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select fid, fnumber, fname_" + ctx.getLocale() + " fname from t_bg_bgPeriod where FPeriodType = ? and fid in (select fbgperiodid from t_bg_bgdata where fbgformid = ?) order by fnumber");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setInt(1, periodType);
            pstmt.setString(2, bgFormId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                perInfo = new BgPeriodInfo();
                perInfo.setId(BOSUuid.read((String)rst.getString("fid")));
                perInfo.setNumber(rst.getString("fnumber"));
                perInfo.setName(rst.getString("fname"));
                periodCol.add(perInfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return periodCol;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getFormOldData(Context ctx, Map formIds, Map bgPeriods) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        if (formIds.containsKey("formIdsList")) {
            formIds.remove("formIdsList");
        }
        Set keySet = formIds.keySet();
        String[] formIdArr = keySet.toArray(new String[0]);
        keySet = bgPeriods.keySet();
        String[] periodArr = keySet.toArray(new String[0]);
        StringBuffer sql = new StringBuffer();
        sql.append("select fbgformid, fformula , fbgvalue from t_bg_bgdata where fbgformid in " + BgHelper.tranArray2String4Pre(formIdArr));
        sql.append(" and  fbgperiodid in (select fid from t_bg_bgperiod where fnumber in " + BgHelper.tranArray2String4Pre(periodArr) + ")");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgHelper.setParamString4Pre(0, formIdArr, pstmt);
            BgHelper.setParamString4Pre(formIdArr.length, periodArr, pstmt);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                dataMap.put(rst.getString("fformula") + "@" + rst.getString("fbgformid"), rst.getBigDecimal("fbgvalue"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return dataMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getFormId(Context ctx, String bgSchemeId, String bgFormId, Map endPeriods) throws BOSException, EASBizException {
        HashMap formIdMap = new HashMap();
        HashMap periodMap = new HashMap();
        HashMap<String, HashMap<String, Object>> tmpFormMap = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, Object> tmpPeriodMap = null;
        Map conditionMap = null;
        ArrayList<BgPeriodInfo> periodList = new ArrayList<BgPeriodInfo>();
        ArrayList<String> formIdsList = new ArrayList<String>();
        if (bgSchemeId != null) {
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            PreparedStatement pstmtPeriod = null;
            ResultSet rstPeriod = null;
            StringBuffer periods = new StringBuffer();
            Iterator ite = endPeriods.keySet().iterator();
            while (ite.hasNext()) {
                periods.append("'" + ite.next() + "' , ");
            }
            conditionMap = this.getQueryCondition(ctx, bgFormId, bgSchemeId);
            StringBuffer bgFormSql = new StringBuffer();
            StringBuffer periodSql = new StringBuffer();
            String periodQueryStr = periods.substring(0, periods.length() - 3);
            bgFormSql.append("select distinct fbgformid,fbgperiodid from t_bg_bgdata where Fbgschemeid = ? and  fbgperiodid in ( select fid from t_bg_bgperiod where fnumber in (" + periodQueryStr + ")) and fbgformid in (select fid from t_bg_bgform where fState = " + 2 + " and  Fbgschemeid = ? ) and fbgitemcombinid in (" + conditionMap.get("FBgitemCombinIDs") + ")  and FBgElementId in (" + conditionMap.get("FBgElementIDs") + ") and FCurrencyId in (" + conditionMap.get("FCurrencyIDs") + ")");
            periodSql.append("select FId,FNumber from t_bg_bgperiod where FNumber in (" + periodQueryStr + ") order by FNumber ASC");
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(bgFormSql.toString());
                pstmt.setString(1, bgSchemeId);
                pstmt.setString(2, bgSchemeId);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    String periodId = rst.getString("fbgperiodid");
                    periodMap.put(periodId, null);
                    String formIdStr = rst.getString("fbgformid");
                    if (BgFormFacadeFactory.getLocalInstance(ctx).checkFormIsAdjust(BOSUuid.read((String)formIdStr)) != null) continue;
                    formIdMap.put(formIdStr, null);
                    if (tmpFormMap.containsKey(formIdStr)) {
                        tmpPeriodMap = (HashMap<String, Object>)tmpFormMap.get(formIdStr);
                        if (tmpPeriodMap == null) {
                            tmpPeriodMap = new HashMap<String, Object>();
                        }
                        tmpPeriodMap.put(periodId, null);
                        continue;
                    }
                    tmpPeriodMap = new HashMap<String, Object>();
                    tmpPeriodMap.put(periodId, null);
                    tmpFormMap.put(formIdStr, tmpPeriodMap);
                }
                pstmtPeriod = conn.prepareStatement(periodSql.toString());
                rstPeriod = pstmtPeriod.executeQuery();
                while (rstPeriod.next()) {
                    BgPeriodInfo info = new BgPeriodInfo();
                    info.setId(BOSUuid.read((String)rstPeriod.getString("FId")));
                    info.setNumber(rstPeriod.getString("FNumber"));
                    periodList.add(info);
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                    catch (BOSException ex2) {
                        throw ex2;
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rstPeriod, pstmtPeriod);
                    SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rstPeriod, (Statement)pstmtPeriod);
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        }
        if (tmpFormMap.isEmpty() || tmpPeriodMap == null || tmpPeriodMap.isEmpty() || periodList.size() == 0) {
            return formIdMap;
        }
        block8: for (int i = 0; i < periodList.size(); ++i) {
            BgPeriodInfo info = (BgPeriodInfo)periodList.get(i);
            String periodId = info.getId().toString();
            Iterator it = tmpFormMap.keySet().iterator();
            while (it.hasNext()) {
                String formId = (String)it.next();
                HashMap periodTmpMap = (HashMap)tmpFormMap.get(formId);
                if (!periodTmpMap.containsKey(periodId)) continue;
                formIdsList.add(formId);
                it.remove();
                continue block8;
            }
        }
        if (periodMap.size() != endPeriods.size()) {
            return new HashMap();
        }
        formIdMap.put("formIdsList", formIdsList);
        return formIdMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _addNewData(Context ctx, Map formIds) throws BOSException, EASBizException {
        if (formIds == null) {
            return;
        }
        String decId = (String)formIds.get("decId");
        String mainFormID = (String)formIds.get("mainFormId");
        byte[] data = null;
        String mainSql = "update T_BG_BgColForPeriodForm set fkdtdata = ? where fid = ?";
        String valueSql = "select fdata from t_bg_bgform where fid = ?";
        Connection conn = null;
        PreparedStatement pstmtM = null;
        PreparedStatement pstmtV = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmtV = conn.prepareStatement(valueSql);
            pstmtV.setString(1, mainFormID);
            rst = pstmtV.executeQuery();
            if (rst.next()) {
                data = BgInfoHelper.getBytes((ResultSet)rst, (int)1);
            }
            pstmtM = conn.prepareStatement(mainSql);
            pstmtM.setBytes(1, data);
            pstmtM.setString(2, decId);
            pstmtM.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (IOException ex3) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtM);
                SQLUtils.cleanup(rst, (Statement)pstmtV, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtM);
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmtV, (Connection)conn);
    }

    @Override
    protected void _setState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgForm");
        sic.add("refBgColPeriods");
        sic.add("refBgColPeriods.bgForm.id");
        sic.add("state");
        IBgColForPeriodForm ibgCol = BgColForPeriodFormFactory.getLocalInstance(ctx);
        BgColForPeriodFormInfo bgColFormInfo = (BgColForPeriodFormInfo)ibgCol.getValue((IObjectPK)new ObjectUuidPK(id), sic);
        this.setBgFormStatus(ctx, bgColFormInfo, BgFormStateEnum.Approved, true);
        this.setBgColFormState(ctx, bgColFormInfo, BgCollectStateEnum.SIGNED);
    }

    private void setBgColFormState(Context ctx, BgColForPeriodFormInfo bgColFormInfo, BgCollectStateEnum state) throws BOSException {
        StringBuffer sqlToUpdateBgFormStatus = new StringBuffer("UPDATE T_BG_BgColForPeriodForm SET FState = ? WHERE");
        sqlToUpdateBgFormStatus.append(" FID = ");
        sqlToUpdateBgFormStatus.append("'");
        sqlToUpdateBgFormStatus.append(bgColFormInfo.getId().toString());
        sqlToUpdateBgFormStatus.append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormStatus.toString(), (Object[])new Object[]{new Integer(state.getValue())});
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void setBgFormStatus(Context ctx, BgColForPeriodFormInfo bgColFormInfo, BgFormStateEnum state, boolean end) throws BOSException {
        StringBuffer sqlToUpdateBgFormStatus = new StringBuffer("UPDATE T_BG_BgForm SET FState = ? WHERE ");
        RefBgColPeriodsCollection refBgFormCols = bgColFormInfo.getRefBgColPeriods();
        sqlToUpdateBgFormStatus.append("(");
        int count = refBgFormCols.size();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                sqlToUpdateBgFormStatus.append(" OR ");
            }
            sqlToUpdateBgFormStatus.append(" FID = ");
            sqlToUpdateBgFormStatus.append("'");
            sqlToUpdateBgFormStatus.append(refBgFormCols.get(i).getBgForm().getId().toString());
            sqlToUpdateBgFormStatus.append("'");
        }
        sqlToUpdateBgFormStatus.append(") and fid <> '" + bgColFormInfo.getId().toString() + "' ");
        try {
            DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormStatus.toString(), (Object[])new Object[]{new Integer(state.getValue())});
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        sqlToUpdateBgFormStatus = new StringBuffer("UPDATE T_BG_BgForm SET FState = ?  WHERE");
        sqlToUpdateBgFormStatus.append(" FID = ");
        sqlToUpdateBgFormStatus.append("'");
        sqlToUpdateBgFormStatus.append(bgColFormInfo.getBgForm().getId().toString());
        sqlToUpdateBgFormStatus.append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormStatus.toString(), (Object[])new Object[]{new Integer(state.getValue())});
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getAdjustMap(Context ctx, String bgFormId) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        HashMap adjustMap;
        block9: {
            adjustMap = new HashMap();
            conn = null;
            pstmt = null;
            rst = null;
            StringBuffer colForPeriodSql = new StringBuffer();
            colForPeriodSql.append("select FMapData from T_BG_BgColForPeriodForm where FBgFormId= ? order by FcreateTime desc");
            StringBuffer refColPeriodSql = new StringBuffer();
            refColPeriodSql.append("select FMapData from T_BG_BgColForPeriodForm where  FId in (select FBgColforperiodformid from T_BG_RefBgColPeriods where FBgFormId = ?) order by FcreateTime desc ");
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(colForPeriodSql.toString());
                pstmt.setString(1, bgFormId);
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    adjustMap = BgHelper.buildHashMapByByte(BgInfoHelper.getBytes((ResultSet)rst, (String)"FMapData"));
                    break block9;
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                pstmt = conn.prepareStatement(refColPeriodSql.toString());
                pstmt.setString(1, bgFormId);
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    adjustMap = BgHelper.buildHashMapByByte(BgInfoHelper.getBytes((ResultSet)rst, (String)"FMapData"));
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                    catch (BOSException ex2) {
                        throw ex2;
                    }
                    catch (IOException ex3) {
                        throw new BgException(BgException.UNSERIALIZABLEERROR, new String[]{ex3.getMessage()});
                    }
                    catch (ClassNotFoundException ex4) {
                        throw new BgException(BgException.UNSERIALIZABLEERROR, new String[]{ex4.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return adjustMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getQueryCondition(Context ctx, String bgFormId, String bgSchemeId) throws BOSException, EASBizException {
        HashMap<String, StringBuffer> conditionMap = new HashMap<String, StringBuffer>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FBgItemCombinId,FBgElementId,FCurrencyId from t_bg_bgdata where fbgformid = ? and  Fbgschemeid = ?  ");
        StringBuffer FBgitemCombinIDs = new StringBuffer("'',");
        StringBuffer FBgElementIDs = new StringBuffer("'',");
        StringBuffer FCurrencyIDs = new StringBuffer("'',");
        HashMap FBgitemCombinIDsMap = new HashMap();
        HashMap FBgElementIDsMap = new HashMap();
        HashMap FCurrencyIDsMap = new HashMap();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgFormId);
            pstmt.setString(2, bgSchemeId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String FBgitemCombinId = rst.getString("FBgItemCombinId");
                String FBgElementId = rst.getString("FBgElementId");
                String FCurrencyId = rst.getString("FCurrencyId");
                if (!FBgitemCombinIDsMap.containsKey(FBgitemCombinId)) {
                    FBgitemCombinIDs.append("'" + FBgitemCombinId + "',");
                    FBgitemCombinIDsMap.put(FBgitemCombinId, null);
                }
                if (!FBgElementIDsMap.containsKey(FBgElementId)) {
                    FBgElementIDs.append("'" + FBgElementId + "',");
                    FBgElementIDsMap.put(FBgElementId, null);
                }
                if (FCurrencyIDsMap.containsKey(FCurrencyId)) continue;
                FCurrencyIDs.append("'" + FCurrencyId + "',");
                FCurrencyIDsMap.put(FCurrencyId, null);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        FBgitemCombinIDs.delete(FBgitemCombinIDs.length() - 1, FBgitemCombinIDs.length());
        FBgElementIDs.delete(FBgElementIDs.length() - 1, FBgElementIDs.length());
        FCurrencyIDs.delete(FCurrencyIDs.length() - 1, FCurrencyIDs.length());
        conditionMap.put("FBgitemCombinIDs", FBgitemCombinIDs);
        conditionMap.put("FBgElementIDs", FBgElementIDs);
        conditionMap.put("FCurrencyIDs", FCurrencyIDs);
        FBgitemCombinIDsMap.clear();
        FBgElementIDsMap.clear();
        FCurrencyIDsMap.clear();
        return conditionMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getAdjustCheckMap(Context ctx, List formIdList, Map adjustMap) throws BOSException, EASBizException {
        HashMap adjustCheckMap = new HashMap();
        Connection conn = null;
        if (formIdList == null) return adjustCheckMap;
        if (formIdList.size() == 0) {
            return adjustCheckMap;
        }
        if (adjustMap == null) return adjustCheckMap;
        if (adjustMap.isEmpty()) return adjustCheckMap;
        StringBuffer selectSql = new StringBuffer("select fbgformid,fformula from t_bg_bgdata where fbgformid in (");
        int size = formIdList.size();
        for (int i = 0; i < size; ++i) {
            selectSql.append("'" + (String)formIdList.get(i) + "',");
        }
        selectSql.delete(selectSql.length() - 1, selectSql.length());
        selectSql.append(")");
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(selectSql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                Map adjMap;
                BOSUuid id = BOSUuid.read((String)rst.getString("fbgformid"));
                if (!adjustMap.containsKey(rst.getString("fformula"))) continue;
                if (adjustCheckMap.containsKey(id)) {
                    adjMap = (Map)adjustCheckMap.get(id);
                    if (adjMap == null) {
                        adjMap = new HashMap();
                    }
                    adjMap.put(rst.getString("fformula"), adjustMap.get(rst.getString("fformula")));
                    continue;
                }
                adjMap = new HashMap();
                adjMap.put(rst.getString("fformula"), adjustMap.get(rst.getString("fformula")));
                adjustCheckMap.put(id, adjMap);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return adjustCheckMap;
    }
}

