/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgColForPeriodFormInfo;
import com.kingdee.eas.ma.budget.BgCollectException;
import com.kingdee.eas.ma.budget.BgCollectStateEnum;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.RefBgColPeriodsCollection;
import com.kingdee.eas.ma.budget.RefBgColPeriodsInfo;
import com.kingdee.eas.ma.budget.app.AbstractBgColForPeriodFormControllerBean;
import com.kingdee.eas.ma.nbudget.BgNAdjHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgColForPeriodFormControllerBean
extends AbstractBgColForPeriodFormControllerBean {
    private static final long serialVersionUID = 1264700223198589944L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgColForPeriodFormControllerBean");

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.setBgFormStatus(ctx, (BgColForPeriodFormInfo)model, BgFormStateEnum.PeriodAdjusted);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.setBgFormStatus(ctx, (BgColForPeriodFormInfo)model, BgFormStateEnum.PeriodAdjusted);
        return super._addnew(ctx, model);
    }

    private void setBgFormStatus(Context ctx, BgColForPeriodFormInfo bgColForPeriodFormInfo, BgFormStateEnum state) throws BOSException {
        StringBuffer sqlToUpdateBgFormStatus = new StringBuffer("UPDATE T_BG_BgForm SET FState = ? WHERE");
        RefBgColPeriodsCollection refBgFormCols = bgColForPeriodFormInfo.getRefBgColPeriods();
        sqlToUpdateBgFormStatus.append(" FID = ");
        sqlToUpdateBgFormStatus.append("'");
        sqlToUpdateBgFormStatus.append(bgColForPeriodFormInfo.getBgForm().getId().toString());
        sqlToUpdateBgFormStatus.append("'");
        int count = refBgFormCols.size();
        for (int i = 0; i < count; ++i) {
            sqlToUpdateBgFormStatus.append(" OR ");
            sqlToUpdateBgFormStatus.append(" FID = ");
            sqlToUpdateBgFormStatus.append("'");
            sqlToUpdateBgFormStatus.append(refBgFormCols.get(i).getBgForm().getId().toString());
            sqlToUpdateBgFormStatus.append("'");
        }
        try {
            DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormStatus.toString(), (Object[])new Object[]{new Integer(state.getValue())});
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("bgForm");
        sic.add("bgForm.id");
        sic.add("refBgColPeriods");
        sic.add("refBgColPeriods.bgForm.id");
        sic.add("state");
        BgColForPeriodFormInfo bgColForPeriodFormInfo = (BgColForPeriodFormInfo)this.getValue(ctx, pk, sic);
        if (BgColForPeriodFormControllerBean.checkInProInst(ctx, bgColForPeriodFormInfo.getId().toString())) {
            throw new BgCollectException(BgCollectException.BGADJUSTFORMINWFNOREMOVE);
        }
        if (BgCollectStateEnum.SIGNED.equals((Object)bgColForPeriodFormInfo.getState())) {
            throw new BgCollectException(BgCollectException.BGADJUSTFORMNODELETE);
        }
        if (BgCollectStateEnum.AUDIT.equals((Object)bgColForPeriodFormInfo.getState())) {
            throw new BgCollectException(BgCollectException.BGADJUSTFORMINWFNOREMOVE);
        }
        if (this.isMutex(ctx, bgColForPeriodFormInfo.getBgForm().getId().toString(), ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString())) {
            throw new BgCollectException(BgCollectException.LOCKINFO);
        }
        this.setBgFormStatus(ctx, bgColForPeriodFormInfo, BgFormStateEnum.Approved);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            StringBuffer bgFormIdsForDeleteTmpData = new StringBuffer("(");
            bgFormIdsForDeleteTmpData.append("'" + bgColForPeriodFormInfo.getBgForm().getId().toString() + "',");
            int n = bgColForPeriodFormInfo.getRefBgColPeriods().size();
            for (int i = 0; i < n; ++i) {
                bgFormIdsForDeleteTmpData.append("'" + bgColForPeriodFormInfo.getRefBgColPeriods().get(i).getBgForm().getId().toString() + "',");
            }
            bgFormIdsForDeleteTmpData.delete(bgFormIdsForDeleteTmpData.length() - 1, bgFormIdsForDeleteTmpData.length());
            bgFormIdsForDeleteTmpData.append(") ");
            if (bgFormIdsForDeleteTmpData.toString().trim().length() > 2) {
                SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId in " + bgFormIdsForDeleteTmpData.toString()));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (BOSException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        super._delete(ctx, pk);
    }

    private boolean isMutex(Context ctx, String id, String userID) throws BOSException {
        boolean isMutex = false;
        IMutexServiceControl iMC = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isRequest = iMC.requestObjIDForUpdate(id, userID);
        if (isRequest) {
            iMC.releaseObjIDForUpdate(id);
        } else {
            isMutex = true;
        }
        return isMutex;
    }

    public static boolean checkInProInst(Context ctx, String id) throws BOSException {
        boolean result = false;
        ProcessInstInfo[] procInsts = EnactmentServiceFactory.createEnactService((Context)ctx).getProcessInstanceByHoldedObjectId(id);
        for (int i = 0; i < procInsts.length; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            result = true;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgColForPeriodFormInfo bgColFormInfo = (BgColForPeriodFormInfo)model;
        InputStream is = null;
        ObjectInputStream ois = null;
        HashMap adjustMap = null;
        Map formAdjMap = null;
        Connection conn = null;
        BgFormInfo bgFormInfo = null;
        try {
            conn = this.getConnection(ctx);
            byte[] data = bgColFormInfo.getMapData();
            if (data != null && data.length > 0) {
                try {
                    is = ZipUtil.unpack((byte[])data);
                    ois = new ObjectInputStream(is);
                    adjustMap = BgHelper.buildHashMapByByte((byte[])((HashMap)ois.readObject()).get("adjustMap"));
                    formAdjMap = this.getFormAdjustMap(conn, bgColFormInfo.getBgForm().getId(), adjustMap);
                    if (formAdjMap != null && !formAdjMap.isEmpty()) {
                        bgFormInfo = BgFSHelper.getBgFormInfo(conn, bgColFormInfo.getBgForm().getId(), false);
                        BgNAdjHelper.createTmpDataOfFormula((Context)ctx, (Connection)conn, (BOSUuid)bgFormInfo.getOrgUnit().getId(), (BOSUuid)bgFormInfo.getBgScheme().getId(), (BOSUuid)bgFormInfo.getBgTemplate().getId(), (BOSUuid)bgFormInfo.getId(), (Map)formAdjMap);
                        formAdjMap.clear();
                    } else {
                        SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + bgColFormInfo.getBgForm().getId().toString() + "'"));
                    }
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            RefBgColPeriodsInfo refBgColFormInfo = null;
            Iterator iter = bgColFormInfo.getRefBgColPeriods().iterator();
            while (iter.hasNext()) {
                refBgColFormInfo = (RefBgColPeriodsInfo)iter.next();
                refBgColFormInfo.remove("kdtData");
                formAdjMap = this.getFormAdjustMap(conn, refBgColFormInfo.getBgForm().getId(), adjustMap);
                if (formAdjMap != null && !formAdjMap.isEmpty()) {
                    bgFormInfo = BgFSHelper.getBgFormInfo(conn, refBgColFormInfo.getBgForm().getId(), false);
                    BgFSHelper.createTmpDataOfFormula(ctx, conn, bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgScheme().getId(), bgFormInfo.getBgTemplate().getId(), bgFormInfo.getId(), formAdjMap);
                    formAdjMap.clear();
                } else {
                    SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + refBgColFormInfo.getBgForm().getId().toString() + "'"));
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (ois == null) continue;
                    ois.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    private Map getColIdsMap(BgColForPeriodFormInfo editData) {
        HashMap<String, Object> decIds = new HashMap<String, Object>();
        HashMap<String, Object> refIds = new HashMap<String, Object>();
        decIds.put("decId", editData.getId().toString());
        decIds.put("mainFormId", editData.getBgForm().getId().toString());
        RefBgColPeriodsCollection coll = editData.getRefBgColPeriods();
        for (int i = 0; i < coll.size(); ++i) {
            refIds.put(coll.get(i).getBgForm().getId().toString(), null);
        }
        decIds.put("refIds", refIds);
        return decIds;
    }

    private Map getFormAdjustMap(Connection conn, BOSUuid id, Map adjustMap) throws BgException {
        HashMap newMap = null;
        if (adjustMap != null && !adjustMap.isEmpty()) {
            newMap = new HashMap();
            String selectSql = "select fformula from t_bg_bgdata where fbgformid = ?";
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            try {
                pstmt = conn.prepareStatement(selectSql);
                pstmt.setString(1, id.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!adjustMap.containsKey(rst.getString("fformula"))) continue;
                    newMap.put(rst.getString("fformula"), adjustMap.get(rst.getString("fformula")));
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        return newMap;
    }

    @Override
    protected void _auditWF(Context ctx, BOSUuid id) throws BOSException {
    }

    @Override
    protected void _auditApproving(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (this.checkHaveAudit(ctx, (IObjectPK)new ObjectUuidPK(id))) {
            throw new BgCollectException(BgCollectException.BGPERIODADJUSTFORMNOSUBMIT);
        }
        BgColForPeriodFormInfo info = this.getBgColForPeriodFormInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(BgCollectStateEnum.AUDIT);
        super._update(ctx, (IObjectPK)new ObjectUuidPK(id), (IObjectValue)info);
    }

    @Override
    protected void _auditSigned(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (this.checkHaveAudit(ctx, (IObjectPK)new ObjectUuidPK(id))) {
            throw new BgCollectException(BgCollectException.BGPERIODADJUSTFORMNOSUBMIT);
        }
        BgFormFacadeFactory.getLocalInstance(ctx).auditBgColForPeriod(id);
    }

    @Override
    protected void _auditAdjust(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        if (this.exists(ctx, (IObjectPK)pk)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("state"));
            BgColForPeriodFormInfo info = this.getBgColForPeriodFormInfo(ctx, (IObjectPK)pk, sic);
            info.setState(BgCollectStateEnum.PeriodAdjusted);
            this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)info);
        }
    }

    private boolean checkHaveAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("state");
        BgColForPeriodFormInfo info = (BgColForPeriodFormInfo)this.getValue(ctx, pk, sic);
        return BgCollectStateEnum.SIGNED.equals((Object)info.getState());
    }

    @Override
    protected Map _getAllInitData(Context ctx, BgColForPeriodFormInfo editData) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        HashMap<String, Serializable> allDataMap = new HashMap<String, Serializable>();
        HashMap otherData = null;
        try {
            otherData = BgHelper.buildHashMapByByte(editData.getMapData());
        }
        catch (IOException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        Map resultMap = null;
        if (otherData != null && !otherData.isEmpty()) {
            resultMap = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodForAdjust(otherData);
        }
        if (resultMap == null) {
            resultMap = new HashMap();
        }
        allDataMap.put("resultMap", (Serializable)((Object)resultMap));
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        CurrencyInfo currencyInfo2 = null;
        CurrencyCollection currencyCol = null;
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        if (iCurrency != null) {
            currencyCol = iCurrency.getCurrencyCollection();
            for (CurrencyInfo currencyInfo2 : currencyCol) {
                currencyMap.put(currencyInfo2.getNumber(), currencyInfo2);
            }
        } else {
            throw new BgFormException(BgFormException.NOINSTANCE);
        }
        allDataMap.put("currencyMap", currencyMap);
        boolean isExistsBgForm = false;
        BgFormInfo bgFormInfo = null;
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        if (editData.getBgForm() != null && editData.getBgForm().getId() != null && (isExistsBgForm = iBgForm.exists((IObjectPK)(pk = new ObjectUuidPK(editData.getBgForm().getId()))))) {
            bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)pk, this.getBgFormInfo());
        }
        allDataMap.put("isExistsBgForm", Boolean.valueOf(isExistsBgForm));
        allDataMap.put("bgFormInfo", bgFormInfo);
        return allDataMap;
    }

    private SelectorItemCollection getBgFormInfo() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("bgTemplate.*"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.*"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("measureUnit.*"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("bgForm.number");
        select.add("bgForm.name");
        BgColForPeriodFormInfo info = (BgColForPeriodFormInfo)super._getValue(ctx, pk, select);
        return info.getBgForm().getNumber() + " " + info.getBgForm().getName();
    }
}

