/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgCollectFormFactory;
import com.kingdee.eas.ma.budget.BgCollectFormInfo;
import com.kingdee.eas.ma.budget.BgDecException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormCollectException;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.IBgCollectForm;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.RefBgFormCollection;
import com.kingdee.eas.ma.budget.RefBgFormInfo;
import com.kingdee.eas.ma.budget.app.AbstractBgCollectFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgCollectFacadeControllerBean
extends AbstractBgCollectFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgCollectFacadeControllerBean");

    @Override
    protected Set _getCollectFormInfo(Context ctx, BOSUuid bgFormId, Set orgUnitIds, Set state, boolean isFund) throws BOSException, EASBizException {
        if (bgFormId == null) {
            throw new BgFormCollectException(BgFormCollectException.BGFORMIDISNULL);
        }
        if (orgUnitIds == null || orgUnitIds.isEmpty()) {
            throw new BgFormCollectException(BgFormCollectException.ORGUNITISNULL);
        }
        if (state == null) {
            state = new HashSet<BgFormStateEnum>();
        }
        if (state.isEmpty()) {
            state.add(BgFormStateEnum.Edited);
            state.add(BgFormStateEnum.REFERRING);
            state.add(BgFormStateEnum.Approving);
            state.add(BgFormStateEnum.Approved);
            state.add(BgFormStateEnum.Collect);
            state.add(BgFormStateEnum.Adjusted);
        }
        Set bgFormSet = null;
        ObjectUuidPK pk = new ObjectUuidPK(bgFormId);
        IBgForm ibgForm = null;
        BgFormInfo bgFormInfo = null;
        try {
            ibgForm = BgFormFactory.getLocalInstance(ctx);
            if (!ibgForm.exists((IObjectPK)pk)) {
                throw new BgFormCollectException(BgFormCollectException.BGFORMINFOISNOTEXIST);
            }
            bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)pk, this.getSelectors());
            bgFormSet = this.getCollectBgFormIds(ctx, bgFormInfo, orgUnitIds, state);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return bgFormSet;
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("bgScheme.id");
        sic.add("bgScheme.rootId");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.rootId");
        sic.add("bgPeriod.id");
        sic.add("currency.id");
        sic.add("state");
        return sic;
    }

    private Set getCollectBgFormIds(Context ctx, BgFormInfo model, Set orgUnitIds, Set state) throws BOSException, EASBizException {
        HashSet bgFormIds = new HashSet();
        Map bgSchemeMap = null;
        Object bgTemplateMap = null;
        BOSUuid bgSchemeId = null;
        BOSUuid bgTemplateId = null;
        bgSchemeId = model.getBgScheme().getRootId() != null ? model.getBgScheme().getRootId() : model.getBgScheme().getId();
        bgTemplateId = model.getBgTemplate().getRootId() != null ? model.getBgTemplate().getRootId() : model.getBgTemplate().getId();
        bgSchemeMap = this.getCollectBgSchemeByOrgUnit(ctx, bgSchemeId, orgUnitIds);
        return bgFormIds;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getCollectBgSchemeByOrgUnit(Context ctx, BOSUuid bgSchemeId, Set OrgUnitIds) throws BOSException, EASBizException {
        HashMap bgSchemeMap = new HashMap();
        if (ctx == null) return bgSchemeMap;
        if (bgSchemeId == null) {
            return bgSchemeMap;
        }
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("Select FID from T_BG_BgScheme where FROOTID = ?");
        _tmpList.add(bgSchemeId.toString());
        if (OrgUnitIds != null && !OrgUnitIds.isEmpty()) {
            sql.append(" AND FOrgUnitID IN (");
            Iterator iter = OrgUnitIds.iterator();
            while (iter.hasNext()) {
                sql.append("?,");
                _tmpList.add(iter.next().toString());
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        String bgSchemeIdStr = null;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            connection = this.getConnection(ctx);
            pstmt = connection.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgSchemeIdStr = rst.getString("FID");
                if (bgSchemeMap.containsKey(bgSchemeIdStr)) continue;
                bgSchemeMap.put(bgSchemeIdStr, null);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)connection);
        return bgSchemeMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected BOSUuid _getCollectFormId(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        if (bgFormId == null) {
            throw new BgException(BgException.NOOBJECT);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BOSUuid rebgFormId = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID from T_BG_BgForm where FAdjustId = ? and FState = ?");
            pstmt.setString(1, bgFormId.toString());
            pstmt.setInt(2, 4);
            rst = pstmt.executeQuery();
            rebgFormId = rst.next() ? BOSUuid.read((String)rst.getString(1)) : bgFormId;
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return rebgFormId;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _checkFormulaIsEctype(Context ctx, BOSUuid bgFormId, Map formulaMap) throws BOSException, EASBizException {
        if (bgFormId == null) return;
        if (formulaMap == null) return;
        if (formulaMap.isEmpty()) {
            return;
        }
        BgFormInfo bgFormInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String noFindStr = "#";
        String formulaString2222222 = null;
        String bgFormStr = null;
        StringBuffer sql = new StringBuffer(1024);
        ArrayList<String> formulas = new ArrayList<String>();
        for (String formulaString2222222 : formulaMap.keySet()) {
            formulas.add(formulaString2222222);
        }
        int index = 0;
        int batchNum = 50;
        int size = formulas.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        try {
            conn = this.getConnection(ctx);
            bgFormInfo = BgFSHelper.getBgFormInfo(conn, bgFormId, false);
            sql.append("Select TOP 1 FFormula, FBgFormId from T_BG_BgData where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula in (");
            for (index = 1; index < batchNum; ++index) {
                sql.append("?,");
            }
            sql.append("?)");
            sql.append(" and (FBgFormId <> '" + bgFormInfo.getAdjust().getId() + "')");
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                pstmt.setString(1, bgFormInfo.getOrgUnit().getId().toString());
                pstmt.setString(2, bgFormInfo.getBgScheme().getId().toString());
                for (int k = 0; k < batchNum; ++k, ++pos) {
                    if (pos < size) {
                        pstmt.setString(k + 3, (String)formulas.get(pos));
                        continue;
                    }
                    pstmt.setString(k + 3, noFindStr);
                }
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    formulaString2222222 = rst.getString(1);
                    bgFormStr = rst.getString(2);
                    break;
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            if (formulaString2222222 != null && bgFormStr != null) {
                bgFormInfo = BgFSHelper.getBgFormInfo(conn, BOSUuid.read(bgFormStr), false);
                throw new BgFormException(BgFormException.EXISTFORMFORMULASCHEME, new String[]{(String)formulaMap.get(formulaString2222222), formulaString2222222.replaceAll(",\"BgData\",true", ""), bgFormInfo.getName()});
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (EASBizException ex3) {
                    throw ex3;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected Map _loadAllRelateInfo(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        if (id == null) {
            return resultMap;
        }
        IBgCollectForm iDec = BgCollectFormFactory.getLocalInstance(ctx);
        BgCollectFormInfo info = iDec.getBgCollectFormInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors1());
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        ICostCenterOrgUnit iccOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        if (info == null) {
            throw new BgException(BgException.NOOBJECT);
        }
        ObjectUuidPK pk = new ObjectUuidPK(info.getBgForm().getId());
        BgFormInfo bgFormInfo = null;
        CostCenterOrgUnitInfo ccOrgInfo = null;
        HashSet<String> orgSet = new HashSet<String>();
        if (!iBgForm.exists((IObjectPK)pk)) {
            throw new BgException(BgException.NOOBJECT);
        }
        bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)pk, this.getBgFormInfo());
        resultMap.put("bgFormInfo", bgFormInfo);
        ccOrgInfo = iccOrgUnit.getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getOrgUnit().getId()));
        resultMap.put("defOrgUnitInfo", (Serializable)ccOrgInfo);
        orgSet.add(ccOrgInfo.getId().toString());
        CostCenterOrgUnitCollection refOrgUnitCol = new CostCenterOrgUnitCollection();
        HashSet<String> orgId = new HashSet<String>();
        if (info.getRefBgForms() != null && !info.getRefBgForms().isEmpty()) {
            RefBgFormInfo refBgDecFormInfo = null;
            RefBgFormCollection refBgDecFormCol = info.getRefBgForms();
            int n = refBgDecFormCol.size();
            for (int i = 0; i < n; ++i) {
                refBgDecFormInfo = refBgDecFormCol.get(i);
                if (refBgDecFormInfo.getBgForm() == null || refBgDecFormInfo.getBgForm().getOrgUnit() == null) {
                    throw new BgDecException(BgDecException.NOTHAVEBGFORM);
                }
                orgId.add(refBgDecFormInfo.getBgForm().getOrgUnit().getId().toString());
                orgSet.add(refBgDecFormInfo.getBgForm().getOrgUnit().getId().toString());
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection item = filter.getFilterItems();
        item.add(new FilterItemInfo("id", orgId, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        try {
            refOrgUnitCol = iccOrgUnit.getCostCenterOrgUnitCollection(viewInfo);
        }
        catch (Exception e) {
            refOrgUnitCol = new CostCenterOrgUnitCollection();
            logger.error((Object)"budget error:", (Throwable)e);
        }
        resultMap.put("refOrgUnitCol", (Serializable)refOrgUnitCol);
        EntityViewInfo view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", orgSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemInfo sore = new SorterItemInfo("longNumber");
        sore.setSortType(SortType.DESCEND);
        view.getSorter().add(sore);
        CostCenterOrgUnitInfo costCenterOrgUnitInfo = null;
        CostCenterOrgUnitCollection costCenterOrgUnitColl = null;
        HashMap<BOSUuid, CostCenterOrgUnitInfo> orgSheetCheckMap = new HashMap<BOSUuid, CostCenterOrgUnitInfo>();
        try {
            costCenterOrgUnitColl = iccOrgUnit.getCostCenterOrgUnitCollection(view);
            int size = costCenterOrgUnitColl.size();
            for (int i = 0; i < size; ++i) {
                costCenterOrgUnitInfo = costCenterOrgUnitColl.get(i);
                if (costCenterOrgUnitInfo == null) continue;
                orgSheetCheckMap.put(costCenterOrgUnitInfo.getId(), costCenterOrgUnitInfo);
            }
        }
        catch (Exception e) {
            costCenterOrgUnitColl = new CostCenterOrgUnitCollection();
            logger.error((Object)"budget error:", (Throwable)e);
        }
        resultMap.put("orgSheetCheckMap", orgSheetCheckMap);
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        CurrencyInfo currencyInfo2 = null;
        CurrencyCollection currencyCol = null;
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        if (iCurrency != null) {
            currencyCol = iCurrency.getCurrencyCollection();
            for (CurrencyInfo currencyInfo2 : currencyCol) {
                currencyMap.put(currencyInfo2.getNumber(), currencyInfo2);
            }
        }
        resultMap.put("currencyMap", currencyMap);
        return resultMap;
    }

    public SelectorItemCollection getSelectors1() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("orgList"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("bgform.id"));
        sic.add(new SelectorItemInfo("bgform.bgScheme.name"));
        sic.add(new SelectorItemInfo("refBgForms.*"));
        sic.add(new SelectorItemInfo("refBgForms.bgForm.id"));
        sic.add(new SelectorItemInfo("refBgForms.bgForm.orgUnit.id"));
        sic.add(new SelectorItemInfo("refBgForms.bgForm.bgScheme.id"));
        sic.add(new SelectorItemInfo("othercont"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    public SelectorItemCollection getBgFormInfo() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("bgTemplate.id"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.*"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("measureUnit.*"));
        return sic;
    }
}

