/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.budget.BgCollectException;
import com.kingdee.eas.ma.budget.BgCollectFormFactory;
import com.kingdee.eas.ma.budget.BgCollectFormInfo;
import com.kingdee.eas.ma.budget.BgCollectStateEnum;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDaoSqlObject;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormAdjustData;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgCollectForm;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.IRefBgForm;
import com.kingdee.eas.ma.budget.RefBgFormCollection;
import com.kingdee.eas.ma.budget.RefBgFormFactory;
import com.kingdee.eas.ma.budget.RefBgFormInfo;
import com.kingdee.eas.ma.budget.app.AbstractBgCollectFormControllerBean;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNAdjHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.app.formula.BgCalculatorProcess;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgCollectFormControllerBean
extends AbstractBgCollectFormControllerBean {
    private static final long serialVersionUID = -7969938781426721873L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgCollectFormControllerBean");
    Locale locale_L1 = LocaleUtils.getLocale((String)"L1");
    Locale locale_L2 = LocaleUtils.getLocale((String)"L2");
    Locale locale_L3 = LocaleUtils.getLocale((String)"L3");
    private static final String CURRENCY_NUMBER_TYPE = "currency";
    private static final String ELEMENT_NUMBER_TYPE = "element";
    private static final String BGITEM_NUMBER_TYPE = "bgitem";

    protected SelectorItemCollection getBgFormInfo() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    @Override
    protected Map _getTopBgData(Context ctx, BOSUuid topBgId, String subBgId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (topBgId == null) {
            return result;
        }
        IBgForm ibgform = BgFormFactory.getLocalInstance(ctx);
        if (ibgform == null) {
            throw new BgException(BgException.NOINSTANCE);
        }
        ObjectUuidPK pk = new ObjectUuidPK(topBgId);
        BgFormInfo bgFormInfo = ibgform.getBgFormInfo((IObjectPK)pk, this.getBgFormInfo());
        BgDaoSqlObject sqlOb = new BgDaoSqlObject();
        sqlOb.setSelect("distinct e.FName_" + ctx.getLocale() + " as elementname, e.FNumber as elementnumber, e.FDataType as datatype ");
        sqlOb.setFrom("T_BG_BgData as t left outer join T_BG_BgElement e on t.FBgElementId = e.FID ");
        sqlOb.setWhere("t.FOrgUnitID = '" + bgFormInfo.getOrgUnit().getId() + "' and t.FBgSchemeID = '" + bgFormInfo.getBgScheme().getId() + "' and t.FBgFormId = '" + bgFormInfo.getId() + "' and t.FFormula like '%" + BgDataTypeEnum.BgData.getName() + "%'");
        result.put(ELEMENT_NUMBER_TYPE, DbUtil.executeQuery((Context)ctx, (String)sqlOb.getSql()));
        BgDaoSqlObject topSql = new BgDaoSqlObject();
        BgDaoSqlObject subSql = new BgDaoSqlObject();
        topSql.setSelect("period.FName_" + ctx.getLocale() + " as periodname, itemcom.fkey as itemKey, itemcom.fkey as itemName, e.FName_" + ctx.getLocale() + " as elementname, e.FNumber as elementnumber, t.FBgValue as bgvalue, 0 as isSum, t.FBgFormId as bgform, t.FFormula as formula");
        subSql.setSelect("period.fname_" + ctx.getLocale() + " as periodname, itemcom.fkey as itemKey, itemcom.fkey as itemName, e.FName_" + ctx.getLocale() + " as elementname,e.FNumber as elementnumber, sum(t.FBgValue) as bgvalue, 1 as isSum, ' ' as bgform, t.FFormula as formula");
        topSql.setFrom("T_BG_BgData t left outer join T_BG_BgPeriod period on t.fbgperiodid = period.fid left outer join T_BG_BgElement e on t.fbgelementid = e.fid left outer join T_BG_BgItemCombination itemcom on t.fbgitemcombinid = itemcom.fid");
        subSql.setFrom(topSql.getFrom());
        topSql.setWhere(sqlOb.getWhere());
        subSql.setWhere("FBgFormId in " + subBgId + " and FFormula in (select FFormula from T_BG_BgData topdata where FBgFormId = '" + topBgId.toString() + "' and FFormula like '%" + BgDataTypeEnum.BgData.getName() + "%')");
        subSql.setGroup("period.fname_" + ctx.getLocale() + ", itemcom.fkey , e.fname_" + ctx.getLocale() + ", e.fnumber, t.FFormula ");
        BgDaoSqlObject allSql = new BgDaoSqlObject();
        allSql.setSelect("*");
        allSql.setFrom("(" + topSql.getSql() + " union all " + subSql.getSql() + ") AS temp ");
        allSql.setOrder("periodname, itemKey, isSum, elementname");
        IRowSet data = DbUtil.executeQuery((Context)ctx, (String)allSql.getSql());
        HashSet itemNumberSet = new HashSet();
        try {
            while (data.next()) {
                String itemCombine = data.getString("itemKey");
                if (itemCombine == null) continue;
                BgHelper.addArray2Set(itemNumberSet, itemCombine.split("_"));
            }
            data.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        result.put("data", data);
        result.put("itemMap", this.getItemNumber2NameMap(ctx, itemNumberSet, bgFormInfo.getOrgUnit().getId().toString()));
        return result;
    }

    @Override
    protected IRowSet _getSubBgData(Context ctx, BOSUuid topBgId, String subBgIds, String periodName, String itemKey, String formula) throws BOSException {
        BgDaoSqlObject subSql = new BgDaoSqlObject();
        subSql.setSelect("'" + periodName + "' as periodname, '" + itemKey + "' as itemKey, org.fname_" + ctx.getLocale() + " as itemName, element.fname_" + ctx.getLocale() + " as elementname,element.fnumber as elementnumber , data.fbgvalue as bgvalue , 0 as isSum, data.fbgformid as bgform, data.fformula as formula");
        subSql.setFrom("t_bg_bgdata data left outer join T_BG_BgElement element on data.fbgelementid = element.fid left outer join T_ORG_BaseUnit org on data.forgunitid = org.fid ");
        subSql.setWhere("Fbgformid in " + subBgIds + " and fformula in " + formula);
        return DbUtil.executeQuery((Context)ctx, (String)subSql.getSql());
    }

    private Map getItemNumber2NameMap(Context ctx, Set numberSet, String orgUnitId) throws BOSException, EASBizException {
        HashMap<String, String> itemMap = new HashMap<String, String>();
        if (numberSet.size() == 0) {
            return itemMap;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg(ctx, orgUnitId), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        IBgItem iBgItem = BgItemFactory.getLocalInstance(ctx);
        BgItemCollection bgItemColl = iBgItem.getBgItemCollection(viewInfo);
        if (bgItemColl != null && bgItemColl.size() > 0) {
            for (int i = 0; i < bgItemColl.size(); ++i) {
                BgItemInfo bgItemInfo = bgItemColl.get(i);
                itemMap.put(bgItemInfo.getNumber(), bgItemInfo.getName());
            }
        }
        return itemMap;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkBgFormState(ctx, model);
        this.setBgFormStatus(ctx, (BgCollectFormInfo)model, BgFormStateEnum.Collect);
        this.addNewGetOldData(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkBgFormState(ctx, model);
        this.setBgFormStatus(ctx, (BgCollectFormInfo)model, BgFormStateEnum.Collect);
        this.addNewGetOldData(ctx, model);
        return super._addnew(ctx, model);
    }

    private void addNewGetOldData(Context ctx, IObjectValue model) {
        BgCollectFormInfo info = (BgCollectFormInfo)model;
        HashMap<String, Object> formIds = new HashMap<String, Object>();
        ArrayList<String> mutexIds = new ArrayList<String>();
        formIds.put(info.getBgForm().getId().toString(), null);
        int n = info.getRefBgForms().size();
        for (int i = 0; i < n; ++i) {
            formIds.put(info.getRefBgForms().get(i).getBgForm().getId().toString(), null);
            mutexIds.add(info.getRefBgForms().get(i).getBgForm().getId().toString());
        }
        try {
            IMutexServiceControl iMC = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            iMC.batchRequestObjIDForUpdate(mutexIds);
            Map oldData = BgCollectFormFactory.getLocalInstance(ctx).getOldData(formIds);
            HashMap<String, byte[]> otherData = new HashMap<String, byte[]>();
            otherData.put("oldData", BgHelper.storeHashMapToByte((HashMap)oldData));
            if (otherData != null && !otherData.isEmpty()) {
                info.setOtherCont(BgHelper.storeHashMapToByte(otherData));
            }
        }
        catch (Exception ee) {
            logger.error((Object)"budget error:", (Throwable)ee);
        }
    }

    private void checkBgFormState(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        BgCollectFormInfo info = (BgCollectFormInfo)model;
        if (info != null) {
            String bgFormId2 = null;
            String bgFormNumber = null;
            BgFormInfo bgFormInfo = null;
            HashMap<String, String> collectInfo = new HashMap<String, String>();
            Map filterInfo = new HashMap();
            ArrayList<BgFormStateEnum> state = new ArrayList<BgFormStateEnum>();
            state.add(BgFormStateEnum.Approved);
            bgFormInfo = info.getBgForm();
            collectInfo.put(bgFormInfo.getId().toString(), bgFormInfo.getNumber());
            RefBgFormInfo refInfo = null;
            Iterator iter = info.getRefBgForms().iterator();
            while (iter.hasNext()) {
                refInfo = (RefBgFormInfo)iter.next();
                bgFormInfo = refInfo.getBgForm();
                if (collectInfo.containsKey(bgFormInfo.getId().toString())) continue;
                collectInfo.put(bgFormInfo.getId().toString(), bgFormInfo.getNumber());
            }
            try {
                IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
                filterInfo = ibgForm.getFormFilterInfo(info.getBgForm().getId(), state);
                filterInfo = ibgForm.getFormFilterInfo(filterInfo);
                for (String bgFormId2 : collectInfo.keySet()) {
                    bgFormNumber = (String)collectInfo.get(bgFormId2);
                    if (filterInfo.containsKey(bgFormId2)) continue;
                    throw new BgCollectException(BgCollectException.BGCOLLECTFORMNOSAVE, new String[]{bgFormNumber});
                }
            }
            catch (BOSException ex) {
                throw ex;
            }
            catch (EASBizException ex) {
                throw ex;
            }
        }
    }

    private void setBgFormStatus(Context ctx, BgCollectFormInfo bgCollectFormInfo, BgFormStateEnum state) throws BOSException {
        StringBuffer sqlToUpdateBgFormStatus = new StringBuffer("UPDATE T_BG_BgForm SET FState = ? WHERE");
        RefBgFormCollection refBgFormCols = bgCollectFormInfo.getRefBgForms();
        sqlToUpdateBgFormStatus.append(" FID = ");
        sqlToUpdateBgFormStatus.append("'");
        sqlToUpdateBgFormStatus.append(bgCollectFormInfo.getBgForm().getId().toString());
        sqlToUpdateBgFormStatus.append("'");
        int count = refBgFormCols.size();
        for (int i = 0; i < count; ++i) {
            sqlToUpdateBgFormStatus.append(" OR ");
            sqlToUpdateBgFormStatus.append(" FID = ");
            sqlToUpdateBgFormStatus.append("'");
            sqlToUpdateBgFormStatus.append(refBgFormCols.get(i).getBgForm().getId().toString());
            sqlToUpdateBgFormStatus.append("'");
        }
        try {
            DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormStatus.toString(), (Object[])new Object[]{new Integer(state.getValue())});
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean checkHaveAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("state");
        BgCollectFormInfo bgCollectFormInfo = (BgCollectFormInfo)this.getValue(ctx, pk, sic);
        return BgCollectStateEnum.SIGNED.equals((Object)bgCollectFormInfo.getState());
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (this.checkHaveAudit(ctx, pk)) {
            throw new BgCollectException(BgCollectException.BGCOLLECTFORMNOCHANGE);
        }
        BgCollectFormInfo bgCollectFormInfo = (BgCollectFormInfo)model;
        if (!bgCollectFormInfo.getRefBgForms().isEmpty()) {
            HashMap<String, RefBgFormInfo> subForm = new HashMap<String, RefBgFormInfo>();
            RefBgFormInfo refForm = null;
            for (int i = 0; i < bgCollectFormInfo.getRefBgForms().size(); ++i) {
                refForm = bgCollectFormInfo.getRefBgForms().get(i);
                subForm.put(refForm.getId().toString(), refForm);
            }
            Connection conn = null;
            PreparedStatement pstmt = null;
            ResultSet res = null;
            try {
                StringBuffer sql = new StringBuffer("SELECT FCOMMENT,FID FROM T_BG_RefBgForm WHERE FID IN (");
                Object[] params = subForm.keySet().toArray();
                BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(" )");
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                int count = (params.length - 1) / 200 + 1;
                for (int i = 0; i < count; ++i) {
                    BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)i, (int)200, (Object[])params);
                    res = pstmt.executeQuery();
                    while (res.next()) {
                        refForm = (RefBgFormInfo)subForm.get(res.getObject("FID"));
                        if (refForm == null) continue;
                        refForm.setComment(res.getString("FCOMMENT"));
                    }
                    SQLUtils.cleanup((ResultSet)res);
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(res, pstmt, conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        }
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("state");
        sic.add("bgForm.id");
        sic.add("refBgForms");
        sic.add("refBgForms.bgForm.id");
        BgCollectFormInfo bgCollectFormInfo = (BgCollectFormInfo)this.getValue(ctx, pk, sic);
        if (BgCollectStateEnum.SIGNED.equals((Object)bgCollectFormInfo.getState())) {
            throw new BgCollectException(BgCollectException.BGCOLLECTFORMNODELETE);
        }
        this.setBgFormStatus(ctx, bgCollectFormInfo, BgFormStateEnum.Approved);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            Object[] bgFormIds = new String[bgCollectFormInfo.getRefBgForms().size() + 1];
            bgFormIds[0] = bgCollectFormInfo.getBgForm().getId().toString();
            StringBuffer deleteSql = new StringBuffer("delete from T_BG_BgTmpData where FBgFormId in(?,");
            int n = bgCollectFormInfo.getRefBgForms().size();
            for (int i = 0; i < n; ++i) {
                if (i == n - 1) {
                    deleteSql.append("?)");
                } else {
                    deleteSql.append("?,");
                }
                bgFormIds[i + 1] = bgCollectFormInfo.getRefBgForms().get(i).getBgForm().getId().toString();
            }
            DbUtil.execute((Context)ctx, (String)deleteSql.toString(), (Object[])bgFormIds);
        }
        catch (BOSException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected boolean _hasBgDataFomular(Context ctx, BOSUuid BgFormId) throws BOSException {
        BgDaoSqlObject sqlOb = new BgDaoSqlObject();
        sqlOb.setSelect("top 1 * ");
        sqlOb.setFrom("t_bg_bgdata as data ");
        sqlOb.setWhere("data.Fbgformid = '" + BgFormId.toString() + "' and data.fformula  like '%" + BgDataTypeEnum.BgData.getName() + "%'");
        try {
            return DbUtil.executeQuery((Context)ctx, (String)sqlOb.getSql()).next();
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + sqlOb.getSql(), (Throwable)e);
        }
    }

    @Override
    protected void _audit(Context ctx, BOSUuid bgCollectFormId) throws BOSException, EASBizException {
        if (this.checkHaveAudit(ctx, (IObjectPK)new ObjectUuidPK(bgCollectFormId))) {
            throw new BgCollectException(BgCollectException.BGCOLLECTFORMNOAUDIT);
        }
        if (BgFormFacadeFactory.getLocalInstance(ctx).auditFormCollect(bgCollectFormId)) {
            BgCollectFormInfo info = this.getBgCollectFormInfo(ctx, (IObjectPK)new ObjectUuidPK(bgCollectFormId));
            this.setBgFormStatus(ctx, info, BgFormStateEnum.Approved);
            this.setBgFormDataSource(ctx, info, BgFormDataSourceEnum.SUPERIORCOLLECT);
            this.setCollectState(ctx, info.getId().toString(), 101);
        }
    }

    private void setCollectState(Context ctx, String id, int signed_value) throws BOSException {
        StringBuffer sqlToUpdateBgFormDataSource = new StringBuffer("UPDATE T_BG_BgCollectForm SET Fstate = ? WHERE fid = ?");
        try {
            DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormDataSource.toString(), (Object[])new Object[]{new Integer(signed_value), id});
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void setBgFormDataSource(Context ctx, BgCollectFormInfo bgCollectFormInfo, BgFormDataSourceEnum dataSourceEnum) throws BOSException {
        StringBuffer sqlToUpdateBgFormDataSource = new StringBuffer("UPDATE T_BG_BgForm SET FDataSource = ? WHERE");
        RefBgFormCollection refBgFormCols = bgCollectFormInfo.getRefBgForms();
        sqlToUpdateBgFormDataSource.append(" FID = ");
        sqlToUpdateBgFormDataSource.append("'");
        sqlToUpdateBgFormDataSource.append(bgCollectFormInfo.getBgForm().getId().toString());
        sqlToUpdateBgFormDataSource.append("'");
        int count = refBgFormCols.size();
        for (int i = 0; i < count; ++i) {
            sqlToUpdateBgFormDataSource.append(" OR ");
            sqlToUpdateBgFormDataSource.append(" FID = ");
            sqlToUpdateBgFormDataSource.append("'");
            sqlToUpdateBgFormDataSource.append(refBgFormCols.get(i).getBgForm().getId().toString());
            sqlToUpdateBgFormDataSource.append("'");
        }
        try {
            DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormDataSource.toString(), (Object[])new Object[]{new Integer(dataSourceEnum.getValue())});
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _auditWF(Context ctx, BOSUuid bgCollectFormId) throws BOSException {
    }

    @Override
    protected IRowSet _getAdjustMapByBgForm(Context ctx, BOSUuid bgFormId) throws BOSException {
        BgDaoSqlObject sqlOb = new BgDaoSqlObject();
        sqlOb.setSelect(" TOP 1 collectForm.fadjustMapData AS adjustMapData");
        sqlOb.setFrom("T_BG_BgCollectForm AS collectForm");
        sqlOb.setWhere("collectForm.fBgformID = '" + bgFormId.toString() + "'");
        sqlOb.setOrder(" collectForm.fCreateTime DESC ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sqlOb.getSql());
        if (result.size() == 0) {
            sqlOb.setSelect(" TOP 1 refForm.fadjustMapData AS adjustMapData");
            sqlOb.setFrom("T_BG_RefBgForm AS refForm LEFT OUTER JOIN T_BG_BgCollectForm AS collectForm ON refForm.FBgCollectID = collectForm.FID");
            sqlOb.setWhere("refForm.fBgformID = '" + bgFormId.toString() + "'");
            sqlOb.setOrder(" collectForm.fCreateTime DESC ");
            result = DbUtil.executeQuery((Context)ctx, (String)sqlOb.getSql());
        }
        return result;
    }

    @Override
    protected void _auditStatus(Context ctx, BOSUuid bgCollectFormId) throws BOSException, EASBizException {
        if (this.checkHaveAudit(ctx, (IObjectPK)new ObjectUuidPK(bgCollectFormId))) {
            throw new BgCollectException(BgCollectException.BGCOLLECTFORMNOSUBMIT);
        }
        BgCollectFormInfo info = this.getBgCollectFormInfo(ctx, (IObjectPK)new ObjectUuidPK(bgCollectFormId));
        info.setState(BgCollectStateEnum.AUDIT);
        super._update(ctx, (IObjectPK)new ObjectUuidPK(bgCollectFormId), (IObjectValue)info);
    }

    @Override
    protected void _auditCollectState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IBgCollectForm ibgCollectForm = BgCollectFormFactory.getLocalInstance(ctx);
        if (ibgCollectForm.exists((IObjectPK)pk)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("state"));
            BgCollectFormInfo bgCollectFormInfo = ibgCollectForm.getBgCollectFormInfo((IObjectPK)pk, sic);
            bgCollectFormInfo.setState(BgCollectStateEnum.COLLECTED);
            ibgCollectForm.update((IObjectPK)pk, (CoreBaseInfo)bgCollectFormInfo);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getBgData(Context ctx, BOSUuid orgUnitId, BOSUuid bgSchemeId, Set formulaSet) throws BOSException, EASBizException {
        if (orgUnitId == null) return new HashMap();
        if (bgSchemeId == null) return new HashMap();
        if (formulaSet == null) return new HashMap();
        if (formulaSet.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, BigDecimal> budgetMap = new HashMap<String, BigDecimal>();
        String formulaString2222222 = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FBgValue, FFormula from T_BG_BgData where FOrgUnitId = ? and FBgSchemeId = ? and FFormula in (");
        for (String formulaString2222222 : formulaSet) {
            sql.append("'" + formulaString2222222 + "',");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(")");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgUnitId.toString());
            pstmt.setString(2, bgSchemeId.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                budgetMap.put(rst.getString(2), rst.getBigDecimal(1));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return budgetMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgCollectFormInfo bgCollectFormInfo = (BgCollectFormInfo)model;
        InputStream is = null;
        ObjectInputStream ois = null;
        HashMap adjustMap = null;
        Connection conn = null;
        BOSUuid bgFormId = null;
        BgFormInfo bgFormInfo = null;
        try {
            conn = this.getConnection(ctx);
            bgCollectFormInfo.remove("kdtData");
            byte[] data = bgCollectFormInfo.getAdjustMapData();
            if (data != null && data.length > 0) {
                try {
                    is = ZipUtil.unpack((byte[])data);
                    ois = new ObjectInputStream(is);
                    adjustMap = (HashMap)ois.readObject();
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                    catch (Exception exception) {}
                }
                bgFormId = bgCollectFormInfo.getBgForm().getId();
                if (adjustMap != null && !adjustMap.isEmpty()) {
                    bgFormInfo = BgFSHelper.getBgFormInfo(conn, bgFormId, false);
                    BgNAdjHelper.createTmpDataOfFormula((Context)ctx, (Connection)conn, (BOSUuid)bgFormInfo.getOrgUnit().getId(), (BOSUuid)bgFormInfo.getBgScheme().getId(), (BOSUuid)bgFormInfo.getBgTemplate().getId(), (BOSUuid)bgFormInfo.getId(), (Map)adjustMap);
                    adjustMap.clear();
                } else {
                    SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + bgFormId.toString() + "'"));
                }
            }
            RefBgFormInfo refBgFormInfo = null;
            Iterator iter = bgCollectFormInfo.getRefBgForms().iterator();
            while (iter.hasNext()) {
                refBgFormInfo = (RefBgFormInfo)iter.next();
                refBgFormInfo.remove("kdtData");
                data = refBgFormInfo.getAdjustMapData();
                if (data == null || data.length <= 0) continue;
                try {
                    is = ZipUtil.unpack((byte[])data);
                    ois = new ObjectInputStream(is);
                    adjustMap = (HashMap)ois.readObject();
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                    catch (Exception exception) {}
                }
                bgFormId = refBgFormInfo.getBgForm().getId();
                if (adjustMap != null && !adjustMap.isEmpty()) {
                    bgFormInfo = BgFSHelper.getBgFormInfo(conn, bgFormId, false);
                    BgNAdjHelper.createTmpDataOfFormula((Context)ctx, (Connection)conn, (BOSUuid)bgFormInfo.getOrgUnit().getId(), (BOSUuid)bgFormInfo.getBgScheme().getId(), (BOSUuid)bgFormInfo.getBgTemplate().getId(), (BOSUuid)bgFormId, (Map)adjustMap);
                    adjustMap.clear();
                    continue;
                }
                SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + bgFormId.toString() + "'"));
            }
        }
        catch (IOException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    private Map getColIdsMap(BgCollectFormInfo editData) {
        HashMap<String, Object> decIds = new HashMap<String, Object>();
        HashMap<String, Object> refIds = new HashMap<String, Object>();
        decIds.put("colId", editData.getId().toString());
        decIds.put("mainFormId", editData.getBgForm().getId().toString());
        RefBgFormCollection coll = editData.getRefBgForms();
        for (int i = 0; i < coll.size(); ++i) {
            refIds.put(coll.get(i).getBgForm().getId().toString(), null);
        }
        decIds.put("refIds", refIds);
        return decIds;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String logInfo = "";
        if (ctx == null) return logInfo;
        if (pk == null) {
            return logInfo;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select f.FNumber, f.FName from T_BG_BgCollectForm t left outer join T_BG_BgForm f on t.FBgFormId = f.FID where t.FID = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, pk.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                logInfo = rst.getString(1) + " - " + rst.getString(2);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return logInfo;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] _getKdf(Context ctx, BOSUuid bgCollectId) throws BOSException, EASBizException {
        if (bgCollectId == null) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FKdtData from T_BG_BgCollectForm where FID = ?");
        byte[] data = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgCollectId.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                data = BgInfoHelper.getBytes((ResultSet)rst, (int)1);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (IOException ex3) {
                    logger.error((Object)ex3);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return data;
    }

    @Override
    protected boolean _addBgFormToChildren(Context ctx, String orgUnitId, IObjectValue formInfo) throws BOSException, EASBizException {
        block7: {
            IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
            IBgTemplate iBgTemplate = BgTemplateFactory.getLocalInstance(ctx);
            IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
            if (formInfo == null || orgUnitId == null) {
                return false;
            }
            String templateRootId = ((BgFormInfo)formInfo).getBgTemplate().getRootId().toString();
            String schemeRootId = ((BgFormInfo)formInfo).getBgScheme().getRootId().toString();
            BgFormInfo info = null;
            int n = 1;
            info = null;
            try {
                info = iBgForm.getBgFormInfo("where bgTemplate.rootId = '" + templateRootId + "' and bgScheme.rootId = '" + schemeRootId + "' and orgUnit = '" + orgUnitId + "' and bgPeriod = '" + ((BgFormInfo)formInfo).getBgPeriod().getId().toString() + "'  and FcurrencyID = '" + ((BgFormInfo)formInfo).getCurrency().getId().toString() + "'");
                if (info != null) {
                    return false;
                }
            }
            catch (BOSException ex) {
                if (info != null) break block7;
                BgTemplateInfo bgTemplateInfo = null;
                BgTemplateCollection templateCol = iBgTemplate.getBgTemplateCollection("where rootId = '" + templateRootId + "' and orgUnit = '" + orgUnitId + "' order by createTime ");
                if (templateCol.size() <= 0) {
                    return false;
                }
                bgTemplateInfo = templateCol.get(0);
                BgSchemeInfo bgSchemeInfo = iBgScheme.getBgSchemeInfo("where rootId = '" + schemeRootId + "' and orgUnit = '" + orgUnitId + "'");
                BgFormInfo bgFormInfo = new BgFormInfo();
                bgFormInfo.setId(BOSUuid.create((BOSObjectType)bgFormInfo.getBOSType()));
                bgFormInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                bgFormInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                bgFormInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                bgFormInfo.setAdjust(bgFormInfo);
                bgFormInfo.setVersionNo(BgConstants.ONE);
                bgFormInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
                bgFormInfo.setState(BgFormStateEnum.Approved);
                bgFormInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
                bgFormInfo.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
                bgFormInfo.setDataSource(BgFormDataSourceEnum.SUPERIORSPLIT);
                bgFormInfo.setSourceType(RptSrcTypeEnum.BGFORMREPORT);
                BgHelper.initNumber((CoreBaseInfo)bgFormInfo, bgFormInfo.getCU().getId().toString(), ctx);
                if (bgFormInfo.getNumber() == null || bgFormInfo.getNumber().equals("")) {
                    bgFormInfo.setNumber(((BgFormInfo)formInfo).getNumber() + "_" + n);
                    ++n;
                }
                bgFormInfo.setStartDate(new Date());
                bgFormInfo.setEndDate(bgFormInfo.getStartDate());
                bgFormInfo.setBgTemplate(bgTemplateInfo);
                bgFormInfo.setBgScheme(bgSchemeInfo);
                FullOrgUnitInfo fullOrgUnit = new FullOrgUnitInfo();
                IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
                fullOrgUnit = iFullOrgUnit.getFullOrgUnitInfo("where id = '" + bgTemplateInfo.getOrgUnit().getId().toString() + "'");
                bgFormInfo.setOrgUnit(fullOrgUnit);
                bgFormInfo.setBgPeriod(((BgFormInfo)formInfo).getBgPeriod());
                bgFormInfo.setCurrency(((BgFormInfo)formInfo).getCurrency());
                bgFormInfo.setBgType(bgTemplateInfo.getBgType());
                String bgFormName = null;
                if (bgFormInfo.getCU().getName() != null) {
                    bgFormName = bgFormInfo.getCU().getId().toString().equals(bgFormInfo.getOrgUnit().getId().toString()) ? bgFormInfo.getCU().getName().trim() + "_" + bgFormInfo.getBgPeriod().getName().trim() + "_" + bgFormInfo.getBgTemplate().getName().trim() : bgFormInfo.getCU().getName().trim() + "_" + bgFormInfo.getOrgUnit().getName().trim() + "_" + bgFormInfo.getBgPeriod().getName().trim() + "_" + bgFormInfo.getBgTemplate().getName().trim();
                }
                bgFormInfo.setName(bgFormName.length() > 80 ? bgFormName.substring(1, 80) : bgFormName);
                bgFormInfo.setMeasureUnit(bgTemplateInfo.getDefaultMeasureUnit());
                iBgForm.submit(bgFormInfo.getId(), (IObjectValue)bgFormInfo, true);
            }
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] _getBgFormKdf(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        if (bgFormId == null) {
            return null;
        }
        byte[] data = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select t.FKdtData from T_BG_RefBgForm t left outer join T_BG_BgCollectForm c on t.FBgCollectId = c.FID  where t.FBgFormId = ? and c.FState <> 102");
            pstmt.setString(1, bgFormId.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                data = BgInfoHelper.getBytes((ResultSet)rst, (int)1);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (IOException ex3) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return data;
    }

    @Override
    protected Object[] _updateBgFormData(Context ctx, String bgFormID, IObjectValue bgForm, ArrayList datas) throws BOSException, EASBizException {
        Book book = null;
        try {
            book = ((BgFormInfo)bgForm).getBook();
        }
        catch (Exception e) {
            return null;
        }
        if (book == null) {
            return null;
        }
        Object[] obj = new Object[3];
        HashMap adjustMap = new HashMap();
        HashMap valueMap = new HashMap();
        if (datas != null) {
            int index = 0;
            ArrayList tbl = null;
            ArrayList row = null;
            book.setCalculate(false);
            for (int n = 0; n < book.getSheetCount(); ++n) {
                Sheet table = book.getSheet(n);
                tbl = (ArrayList)datas.get(index);
                if (tbl != null) {
                    int rowCount = table.getMaxRowIndex() + 1;
                    int colCount = table.getMaxColIndex() + 1;
                    for (int r = 0; r < rowCount; ++r) {
                        for (int c = 0; c < colCount; ++c) {
                            Cell cell = table.getCell(r, c, true);
                            boolean b = BgNFSHelper.checkHasExpression((Cell)cell);
                            if (b) {
                                cell.updateFormula();
                            }
                            if (!b || tbl.size() < r) continue;
                            row = (ArrayList)tbl.get(r);
                            if (row.get(c) != null) {
                                BgNFSHelper.setValue((Cell)cell, row.get(c));
                            } else {
                                BgNFSHelper.setValue((Cell)cell, null);
                            }
                            if (row != null && BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                                String formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell);
                                if (formulaString == null || formulaString.trim().length() <= 0) continue;
                                if (row.get(c) != null) {
                                    BgNFSHelper.getItemFormula((Cell)cell).putExt("BG_BUDGET_VALUE", String.valueOf(row.get(c)));
                                } else {
                                    BgNFSHelper.getItemFormula((Cell)cell).putExt("BG_BUDGET_VALUE", null);
                                }
                                adjustMap.put(formulaString, row.get(c));
                                continue;
                            }
                            String expr = BgNFSHelper.getExpression((Cell)cell);
                            valueMap.put(expr, row.get(c));
                        }
                    }
                }
                ++index;
            }
        }
        byte[] data = null;
        try {
            data = IOHelper.packBook((Book)book);
        }
        catch (IOException e) {
            throw new BgException(BgException.DATABASEERROR, new String[]{e.getMessage()});
        }
        obj[0] = adjustMap;
        obj[1] = data;
        obj[2] = valueMap;
        return obj;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _updateDataForForm(Context ctx, String bgCollectId, Map dataMap) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement refPstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgCollectForm  set  FKdtData = ? where FBgFormID = ? and fid = ?");
            refPstmt = conn.prepareStatement("update T_BG_RefBgForm  set  FKdtData = ? where FBgFormID = ? and FBgCollectID = ?");
            String typeId2222222 = null;
            String[] type = null;
            for (String typeId2222222 : dataMap.keySet()) {
                type = typeId2222222.split("`");
                if (type[0].equals("from")) {
                    pstmt.setBytes(1, ((RefBgFormInfo)dataMap.get(typeId2222222)).getKdtData());
                    pstmt.setString(2, type[1]);
                    pstmt.setString(3, bgCollectId);
                    pstmt.executeUpdate();
                    continue;
                }
                if (!type[0].equals("ref")) continue;
                refPstmt.setBytes(1, ((RefBgFormInfo)dataMap.get(typeId2222222)).getKdtData());
                refPstmt.setString(2, type[1]);
                refPstmt.setString(3, bgCollectId);
                refPstmt.executeUpdate();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(refPstmt);
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)refPstmt);
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object[] _updateDataToBgTmpData(Context ctx, String formId, Object datas) throws BOSException, EASBizException {
        HashMap data = (HashMap)datas;
        String[] items = this.getStrings(data);
        HashMap haveData = new HashMap();
        HashMap<String, BigDecimal> notHaveData = new HashMap<String, BigDecimal>();
        BgDataInfo bgData = new BgDataInfo();
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmtBgData = null;
        PreparedStatement pstmtBgDataIds = null;
        PreparedStatement pstmt2 = null;
        PreparedStatement pstmt3 = null;
        PreparedStatement pstmt4 = null;
        ResultSet rst = null;
        HashMap spData = null;
        String[] bgDataIds = new String[6];
        int n = 1;
        while ((n - 1) * 50 < items.length) {
            int m;
            spData = new HashMap();
            String[] cutItems = null;
            if (n * 50 > items.length) {
                cutItems = new String[items.length - (n - 1) * 50];
                m = 0;
                while ((n - 1) * 50 + m < items.length) {
                    cutItems[m] = items[(n - 1) * 50 + m];
                    spData.put(items[(n - 1) * 50 + m], data.get(items[(n - 1) * 50 + m]));
                    ++m;
                }
            } else {
                cutItems = new String[50];
                for (m = 0; m < 50; ++m) {
                    cutItems[m] = items[(n - 1) * 50 + m];
                    spData.put(items[(n - 1) * 50 + m], data.get(items[(n - 1) * 50 + m]));
                }
            }
            ArrayList<String> _tmpList = new ArrayList<String>();
            StringBuffer sql = new StringBuffer();
            sql.append("select fformula from T_BG_BgTmpData where Fbgformid = ?");
            StringBuffer bgDataSql = new StringBuffer();
            bgDataSql.append("select fformula, fBgValue from t_bg_bgdata where fbgformid = ? and fformula in (" + BgNSQLHelper.getParamSizeString((int)cutItems.length) + ")");
            _tmpList.add(formId);
            int in = cutItems.length;
            for (int i = 0; i < in; ++i) {
                _tmpList.add(cutItems[i]);
            }
            StringBuffer bgDataIdsSql = new StringBuffer();
            bgDataIdsSql.append("select FOrgUnitId, FBgSchemeId, FBgTemplateId,   FBgPeriodId, FCurrencyId from t_bg_bgform where fid = ? ");
            StringBuffer sql2 = new StringBuffer();
            sql2.append("Insert Into T_BG_BgTmpData (FID, FBgValue,  FBizActual, FOrgUnitId, FBgSchemeId, FBgTemplateId, FBgFormId, FFormula,  FBgElementId, FBgPeriodId, FCurrencyId) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            StringBuffer sql3 = new StringBuffer();
            sql3.append("update t_bg_bgTmpdata set fbgvalue = ? where fbgformId = ? and fformula = ? ");
            StringBuffer sql4 = new StringBuffer();
            sql4.append("update t_bg_bgTmpdata set FBgBalance = FBgValue - FBizActual  where fbgformId = ? ");
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, formId);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    haveData.put(rst.getString(1), null);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                pstmtBgData = conn.prepareStatement(bgDataSql.toString());
                BgNSQLHelper.setParams((PreparedStatement)pstmtBgData, _tmpList);
                rst = pstmtBgData.executeQuery();
                while (rst.next()) {
                    if (haveData.containsKey(rst.getString(1))) continue;
                    notHaveData.put(rst.getString(1), rst.getBigDecimal(2));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmtBgData);
                if (bgDataIds[0] == null) {
                    try {
                        pstmtBgDataIds = conn.prepareStatement(bgDataIdsSql.toString());
                        pstmtBgDataIds.setString(1, formId);
                        rst = pstmtBgDataIds.executeQuery();
                        if (rst.next()) {
                            bgDataIds[0] = rst.getString(1);
                            bgDataIds[1] = rst.getString(2);
                            bgDataIds[2] = rst.getString(3);
                            bgDataIds[3] = ELEMENT_NUMBER_TYPE;
                            bgDataIds[4] = rst.getString(4);
                            bgDataIds[5] = rst.getString(5);
                        }
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmtBgDataIds);
                    }
                }
                for (String formula : spData.keySet()) {
                    if (haveData.containsKey(formula)) {
                        try {
                            pstmt3 = conn.prepareStatement(sql3.toString());
                            if (spData.get(formula) instanceof BigDecimal) {
                                pstmt3.setBigDecimal(1, (BigDecimal)spData.get(formula));
                            } else {
                                pstmt3.setBigDecimal(1, new BigDecimal("0"));
                            }
                            pstmt3.setString(2, formId);
                            pstmt3.setString(3, formula);
                            pstmt3.executeUpdate();
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(pstmt3);
                            throw throwable;
                        }
                        SQLUtils.cleanup((Statement)pstmt3);
                        continue;
                    }
                    try {
                        pstmt2 = conn.prepareStatement(sql2.toString());
                        pstmt2.setString(1, BOSUuid.create((BOSObjectType)bgData.getBOSType()).toString());
                        if (spData.get(formula) instanceof BigDecimal) {
                            pstmt2.setBigDecimal(2, (BigDecimal)spData.get(formula));
                        } else {
                            pstmt2.setBigDecimal(2, new BigDecimal("0"));
                        }
                        if (notHaveData.get(formula) instanceof BigDecimal) {
                            pstmt2.setBigDecimal(3, (BigDecimal)notHaveData.get(formula));
                        } else {
                            pstmt2.setBigDecimal(3, new BigDecimal("0"));
                        }
                        pstmt2.setString(4, bgDataIds[0]);
                        pstmt2.setString(5, bgDataIds[1]);
                        pstmt2.setString(6, bgDataIds[2]);
                        pstmt2.setString(7, formId);
                        pstmt2.setString(8, formula);
                        pstmt2.setString(9, bgDataIds[3]);
                        pstmt2.setString(10, bgDataIds[4]);
                        pstmt2.setString(11, bgDataIds[5]);
                        pstmt2.executeUpdate();
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt2);
                        throw throwable;
                    }
                    SQLUtils.cleanup((Statement)pstmt2);
                }
                pstmt4 = conn.prepareStatement(sql4.toString());
                pstmt4.setString(1, formId);
                pstmt4.executeUpdate();
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                    catch (BOSException ex2) {
                        throw ex2;
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    SQLUtils.cleanup(pstmt2);
                    SQLUtils.cleanup(pstmt3);
                    SQLUtils.cleanup(pstmt4);
                    SQLUtils.cleanup(pstmtBgData);
                    SQLUtils.cleanup(pstmtBgDataIds);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            SQLUtils.cleanup((Statement)pstmt2);
            SQLUtils.cleanup((Statement)pstmt3);
            SQLUtils.cleanup((Statement)pstmt4);
            SQLUtils.cleanup((Statement)pstmtBgData);
            SQLUtils.cleanup((Statement)pstmtBgDataIds);
            SQLUtils.cleanup((Connection)conn);
            ++n;
        }
        return null;
    }

    private String[] getStrings(Map data) {
        String[] items = new String[data.size()];
        int i = 0;
        Iterator iter = data.keySet().iterator();
        while (iter.hasNext()) {
            items[i] = (String)iter.next();
            ++i;
        }
        return items;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getOldData(Context ctx, Map bgFormId) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> itemValue = new HashMap<String, BigDecimal>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select fbgformid, fformula, fbgvalue  from T_bg_bgdata where fbgformid = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (String id : bgFormId.keySet()) {
                pstmt.setString(1, id);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    itemValue.put(rst.getString(1) + rst.getString(2), rst.getBigDecimal(3));
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return itemValue;
    }

    @Override
    protected Object _updateData(Context ctx, String colId, Map addNewData, Map delOldData, boolean isCol, byte[] newData) throws BOSException, EASBizException {
        byte[] data = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("kdtData");
        sic.add("bgForm.id");
        SelectorItemCollection formSic = new SelectorItemCollection();
        formSic.add(new SelectorItemInfo("id"));
        formSic.add(new SelectorItemInfo("data"));
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)colId));
        BgCollectFormInfo info = null;
        RefBgFormInfo refInfo = null;
        BgFormInfo bgFormInfo = null;
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        try {
            if (isCol) {
                if (newData != null) {
                    info = new BgCollectFormInfo();
                    info.setKdtData(newData);
                } else {
                    info = (BgCollectFormInfo)this.getValue(ctx, (IObjectPK)pk, sic);
                }
            } else if (newData != null) {
                refInfo = new RefBgFormInfo();
                refInfo.setKdtData(newData);
            } else {
                IRefBgForm iRef = RefBgFormFactory.getLocalInstance(ctx);
                refInfo = iRef.getRefBgFormInfo((IObjectPK)pk, sic);
            }
        }
        catch (IOException e) {
            throw new BgException(BgException.DATABASEERROR, new String[]{e.getMessage()});
        }
        catch (ClassNotFoundException e) {
            throw new BgException(BgException.DATABASEERROR, new String[]{e.getMessage()});
        }
        if (info != null) {
            try {
                int colIndex;
                int rowIndex;
                Book book = null;
                if (isCol) {
                    if (info.getKdtData() != null) {
                        book = info.getBook();
                    } else {
                        bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(info.getBgForm().getId()), formSic);
                        book = bgFormInfo.getBook();
                    }
                } else if (refInfo.getKdtData() != null) {
                    book = refInfo.getBook();
                } else {
                    bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(refInfo.getBgForm().getId()), formSic);
                    book = bgFormInfo.getBook();
                }
                Sheet sheet = null;
                Vector cellObj = null;
                for (String fomulaString : delOldData.keySet()) {
                    cellObj = (Vector)delOldData.get(fomulaString);
                    sheet = book.getSheetByID((String)cellObj.get(0));
                    rowIndex = (Integer)cellObj.get(1);
                    colIndex = (Integer)cellObj.get(2);
                    Cell nCell = sheet.getCell(rowIndex, colIndex, true);
                    BgNFSHelper.setItemFormula((Cell)nCell, null);
                    BgNFSHelper.setValue((Cell)nCell, null);
                }
                for (String fomulaString : addNewData.keySet()) {
                    cellObj = (Vector)addNewData.get(fomulaString);
                    sheet = book.getSheetByID((String)cellObj.get(0));
                    rowIndex = (Integer)cellObj.get(1);
                    colIndex = (Integer)cellObj.get(2);
                    Variant value = (Variant)cellObj.get(3);
                    Cell nCell = sheet.getCell(rowIndex, colIndex, true);
                    BgNFSHelper.setFormulaOfCell((Cell)nCell, (String)fomulaString, (boolean)true);
                    BgNFSHelper.setValue((Cell)nCell, (Object)value);
                }
                BgNFSHelper.checkBookSign((Book)book);
                data = IOHelper.packBook((Book)book);
            }
            catch (SQLException ex) {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (BOSException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new BgException(BgException.DATABASEERROR, new String[]{e.getMessage()});
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _addNewData(Context ctx, Map bgCollIds) throws BOSException, EASBizException {
        if (bgCollIds == null) {
            return;
        }
        String decId = (String)bgCollIds.get("colId");
        String mainFormID = (String)bgCollIds.get("mainFormId");
        Map refIds = (Map)bgCollIds.get("refIds");
        byte[] data = null;
        String mainSql = "update t_bg_bgcollectform set fkdtdata = ? where fid = ?";
        String valueSql = "select fdata from t_bg_bgform where fid = ?";
        Connection conn = null;
        PreparedStatement pstmtM = null;
        PreparedStatement pstmtV = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update t_bg_refbgform set fkdtdata = ? where fbgformid = ? and fbgcollectid = ?");
        try {
            block13: {
                conn = this.getConnection(ctx);
                try {
                    pstmtV = conn.prepareStatement(valueSql);
                    pstmtV.setString(1, mainFormID);
                    rst = pstmtV.executeQuery();
                    if (!rst.next()) break block13;
                    data = BgInfoHelper.getBytes((ResultSet)rst, (int)1);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmtV);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmtV);
            try {}
            catch (Throwable throwable) {
                SQLUtils.cleanup((ResultSet)rst);
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup((Statement)pstmtV);
                SQLUtils.cleanup((Statement)pstmtM);
                throw throwable;
            }
            {
                pstmtM = conn.prepareStatement(mainSql);
                pstmtM.setBytes(1, data);
                pstmtM.setString(2, decId);
                pstmtM.executeUpdate();
                SQLUtils.cleanup((Statement)pstmtM);
                pstmt = conn.prepareStatement(sql.toString());
                pstmtV = conn.prepareStatement(valueSql);
                for (String id : refIds.keySet()) {
                    pstmtV.setString(1, id);
                    rst = pstmtV.executeQuery();
                    data = null;
                    if (rst.next()) {
                        data = BgInfoHelper.getBytes((ResultSet)rst, (int)1);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    pstmt.setBytes(1, data);
                    pstmt.setString(2, id);
                    pstmt.setString(3, decId);
                    pstmt.executeUpdate();
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
            SQLUtils.cleanup((Statement)pstmt);
            SQLUtils.cleanup((Statement)pstmtV);
            SQLUtils.cleanup((Statement)pstmtM);
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (IOException ex3) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmtV);
                SQLUtils.cleanup(pstmtM);
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmtV);
        SQLUtils.cleanup((Statement)pstmtM);
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return;
    }

    @Override
    protected List _getAllNegativeAdjustCheckDataForView(Context ctx, Map adjustMap, BgFormInfo bgFormInfo) throws BOSException, EASBizException {
        HashMap inputMap = new HashMap();
        IBgFormFacade iBgFormFacade = BgFormFacadeFactory.getLocalInstance(ctx);
        Map result = iBgFormFacade.queryBgFormByOrgUnitId(bgFormInfo, adjustMap.keySet().toArray());
        Iterator iterator = result.keySet().iterator();
        while (iterator.hasNext()) {
            BgFormInfo obj = (BgFormInfo)result.get(iterator.next());
            inputMap.put(obj.getId(), adjustMap.get(obj.getOrgUnit().getId().toString()));
        }
        if (result.size() == 0) {
            inputMap = null;
        }
        IBgCollectForm iBgcollectionForm = BgCollectFormFactory.getLocalInstance(ctx);
        return iBgcollectionForm.getAllNegativeAdjustCheckData(inputMap);
    }

    @Override
    protected List _getAllNegativeAdjustCheckData(Context ctx, Map adjustMap) throws BOSException, EASBizException {
        if (adjustMap == null || adjustMap.isEmpty()) {
            return new ArrayList();
        }
        String bgFormIdStr = "";
        HashMap newMap = new HashMap();
        ArrayList<BgFormAdjustData> dataList = null;
        String formulaStr2 = null;
        BgFormDiversityData divInfo = null;
        BgFormAdjustData adjustData = null;
        Object obj = null;
        BOSUuid bgFormId = null;
        Map resultMap = null;
        StringBuffer idStr = new StringBuffer();
        Object conn = null;
        Object pstmt = null;
        Object rst = null;
        Object formIdStrForFilter = null;
        Object formulaStrForFilter = null;
        Set ctrlSet = new HashSet();
        ArrayList _tmpList = new ArrayList();
        ctrlSet = this.filterNoCtrlFormula(ctx, adjustMap);
        Iterator it = adjustMap.keySet().iterator();
        while (it.hasNext()) {
            dataList = new ArrayList<BgFormAdjustData>();
            obj = it.next();
            if (!(obj instanceof BOSUuid)) continue;
            bgFormId = obj;
            bgFormIdStr = bgFormId.toString();
            Map dataMap = (Map)adjustMap.get(bgFormId);
            if (dataMap == null) continue;
            for (String formulaStr2 : dataMap.keySet()) {
                if (!ctrlSet.contains(bgFormId + formulaStr2) || (divInfo = (BgFormDiversityData)dataMap.get(formulaStr2)) == null) continue;
                adjustData = new BgFormAdjustData(divInfo);
                divInfo.setFormula(formulaStr2);
                dataList.add(adjustData);
                newMap.put(bgFormIdStr, dataList);
            }
        }
        resultMap = this.getAllOrgAndSchemeNumByFormId(ctx, newMap);
        return this.getInvalidAdjustValue(ctx, resultMap);
    }

    private Set filterNoCtrlFormula(Context ctx, Map adjustMap) throws BOSException, BgException {
        HashSet<String> ctrlSet = new HashSet<String>();
        EntityViewInfo bgFormView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", adjustMap.keySet(), CompareType.INCLUDE));
        bgFormView.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("bgScheme.id");
        sic.add("orgUnit.id");
        bgFormView.setSelector(sic);
        BgFormCollection bgFormCol = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(bgFormView);
        HashMap<BOSUuid, BgFormInfo> bgFormMap = new HashMap<BOSUuid, BgFormInfo>();
        if (bgFormCol != null) {
            for (int i = 0; i < bgFormCol.size(); ++i) {
                bgFormMap.put(bgFormCol.get(i).getId(), bgFormCol.get(i));
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FFormula from T_BG_BgData where FctrlType != ? and FOrgUnitId = ? and FBgSchemeId = ? and FFormula in (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
        Object bgFormId2 = null;
        BgFormInfo bgFormInfo = null;
        Object[] paraArr = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (Object bgFormId2 : bgFormMap.keySet()) {
                bgFormInfo = (BgFormInfo)bgFormMap.get(bgFormId2);
                if (adjustMap.get(bgFormId2) == null || (paraArr = ((Map)adjustMap.get(bgFormId2)).keySet().toArray()).length == 0) continue;
                int batchCount = (paraArr.length - 1) / 200 + 1;
                for (int i = 0; i < batchCount; ++i) {
                    pstmt.setInt(1, new Integer(-1));
                    pstmt.setString(2, bgFormInfo.getOrgUnit().getId().toString());
                    pstmt.setString(3, bgFormInfo.getBgScheme().getId().toString());
                    BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)4, (int)i, (int)200, (Object[])paraArr);
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        ctrlSet.add(bgFormId2.toString() + rst.getString("FFormula"));
                    }
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return ctrlSet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map getAllOrgAndSchemeNumByFormId(Context ctx, Map map) throws BOSException, EASBizException {
        if (map == null) {
            return new HashMap();
        }
        List divInfoList = null;
        HashMap resultMap = new HashMap();
        StringBuffer idStr = new StringBuffer();
        if (map.keySet().size() <= 0) {
            return new HashMap();
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            idStr.append("'" + (String)it.next() + "',");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgFormAdjustData adjustData = null;
        Parameter param = null;
        String[] formulaParams = null;
        String formIdStr = null;
        String schemeNumber = null;
        String unitNumber = null;
        String bgFormName = null;
        String orgName = null;
        String itemNumber = null;
        String periodNumber = null;
        String elementNumber = null;
        String currencyNumber = null;
        String ln = "";
        Locale locale = ctx.getLocale();
        if (locale.equals(this.locale_L1)) {
            ln = "L1";
        }
        if (locale.equals(this.locale_L2)) {
            ln = "L2";
        }
        if (locale.equals(this.locale_L3)) {
            ln = "L3";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select form.FID as formId,form.FName as bgFormName,scheme.FNumber as schemeNumber,unit.FNumber as unitNumber, unit.FName_" + ln + " as orgName from T_BG_BgForm form inner join T_BG_BgScheme scheme on form.FBgSchemeID = scheme.FID inner join T_ORG_BaseUnit unit on form.FOrgUnitID = unit.FID where  form.FID in(" + idStr.toString().substring(0, idStr.length() - 1) + ") ");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                formIdStr = rst.getString("formId");
                schemeNumber = rst.getString("schemeNumber");
                unitNumber = rst.getString("unitNumber");
                bgFormName = rst.getString("bgFormName");
                orgName = rst.getString("orgName");
                if (!map.containsKey(formIdStr)) continue;
                HashMap<Parameter, BgFormAdjustData> adjustDataMap = null;
                adjustDataMap = (HashMap<Parameter, BgFormAdjustData>)resultMap.get(formIdStr);
                if (adjustDataMap == null) {
                    adjustDataMap = new HashMap<Parameter, BgFormAdjustData>();
                    resultMap.put(formIdStr, adjustDataMap);
                }
                divInfoList = (List)map.get(formIdStr);
                for (int i = 0; i < divInfoList.size(); itemNumber = itemNumber.replaceAll("_", ","), ++i) {
                    adjustData = (BgFormAdjustData)divInfoList.get(i);
                    formulaParams = BgNFSHelper.parseFormulaPara(null, (String)adjustData.getFormula());
                    itemNumber = "";
                    periodNumber = "";
                    elementNumber = "";
                    currencyNumber = "";
                    if (formulaParams.length == 4) {
                        itemNumber = formulaParams[0];
                        periodNumber = formulaParams[1];
                        elementNumber = formulaParams[2];
                        currencyNumber = formulaParams[3];
                    }
                    if (formulaParams.length == 6) {
                        itemNumber = formulaParams[0];
                        periodNumber = formulaParams[1];
                        elementNumber = formulaParams[2];
                        currencyNumber = formulaParams[5];
                    }
                    Object[] obj = new Object[]{new Variant((Object)unitNumber), new Variant((Object)schemeNumber), new Variant((Object)elementNumber), new Variant((Object)itemNumber), new Variant((Object)currencyNumber), new Variant((Object)periodNumber), new Variant((Object)adjustData.getNewValue()), new Variant((Object)adjustData.getOldValue())};
                    param = new Parameter(obj, "", false);
                    adjustData.setParam(param);
                    adjustData.setBgFormName(bgFormName);
                    adjustData.setOrgName(orgName);
                    adjustData.setCurrency(currencyNumber);
                    adjustData.setElement(elementNumber);
                    adjustData.setPeriod(periodNumber);
                    adjustData.setItemNumber(itemNumber);
                    adjustDataMap.put(param, adjustData);
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return resultMap;
    }

    private String itemNumber2Name(String itemNumber, List itemList, Locale locale) {
        String itemName = "";
        String[] itemNumbers = itemNumber.split(",");
        BgItemInfo itemInfo = null;
        if (itemNumbers != null && itemList != null) {
            int numSize = itemNumbers.length;
            for (int i = 0; i < numSize; ++i) {
                int itemSize = itemList.size();
                for (int j = 0; j < itemSize; ++j) {
                    itemInfo = (BgItemInfo)itemList.get(j);
                    if (!itemNumbers[i].equalsIgnoreCase(itemInfo.getNumber())) continue;
                    itemName = itemName + itemInfo.getName(locale) + "_";
                }
            }
        }
        return itemName.length() > 0 ? itemName.substring(0, itemName.length() - 1) : itemName;
    }

    private String elementNumber2Name(String number, List list, Locale locale) {
        String name = "";
        BgElementInfo info = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            info = (BgElementInfo)list.get(i);
            if (!number.equalsIgnoreCase(info.getNumber())) continue;
            name = info.getName(locale);
        }
        return name;
    }

    private String currencyNumber2Name(String number, List list, Locale locale) {
        String name = "";
        CurrencyInfo info = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            info = (CurrencyInfo)list.get(i);
            if (!number.equalsIgnoreCase(info.getNumber())) continue;
            name = info.getName(locale);
        }
        return name;
    }

    private int getCurrencyPrecision(String number, List list) {
        int Precision = 0;
        CurrencyInfo info = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            info = (CurrencyInfo)list.get(i);
            if (!number.equalsIgnoreCase(info.getNumber())) continue;
            Precision = info.getPrecision();
        }
        return Precision;
    }

    private void batchConvertElementNameByNumber(Connection conn, Context ctx, List numberList) throws EASBizException, BOSException {
        if (numberList == null || numberList.size() == 0) {
            return;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer query = new StringBuffer();
        ArrayList<BgElementInfo> resultList = new ArrayList<BgElementInfo>();
        ArrayList _tmpList = new ArrayList();
        Locale lc = ctx.getLocale();
        BgFormAdjustData data = null;
        Set _tmpSet = this.getNumberQueryString(numberList, ELEMENT_NUMBER_TYPE);
        _tmpList.addAll(_tmpSet);
        try {
            query.append("select Fnumber,FName_l1,Fname_l2,Fname_l3 from T_BG_BgElement ");
            if (!_tmpSet.isEmpty()) {
                query.append(" where FNumber in (" + BgNSQLHelper.getParamSizeString((Collection)_tmpSet) + ")");
            }
            pstmt = conn.prepareStatement(query.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                BgElementInfo _info = new BgElementInfo();
                _info.setNumber(rst.getString("FNumber"));
                _info.setName(rst.getString("FName_L1"), this.locale_L1);
                _info.setName(rst.getString("FName_L2"), this.locale_L2);
                _info.setName(rst.getString("FName_L3"), this.locale_L3);
                resultList.add(_info);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        int size = numberList.size();
        for (int i = 0; i < size; ++i) {
            data = (BgFormAdjustData)numberList.get(i);
            data.setElement(this.elementNumber2Name(data.getElement(), resultList, lc));
        }
    }

    private void batchConvertCurrencyNameByNumber(Connection conn, Context ctx, List numberList) throws EASBizException, BOSException {
        if (numberList == null || numberList.size() == 0) {
            return;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer query = new StringBuffer();
        ArrayList<CurrencyInfo> resultList = new ArrayList<CurrencyInfo>();
        ArrayList _tmpList = new ArrayList();
        Set _tmpSet = this.getNumberQueryString(numberList, CURRENCY_NUMBER_TYPE);
        _tmpList.addAll(_tmpSet);
        Locale lc = ctx.getLocale();
        BgFormAdjustData data = null;
        try {
            query.append("select FPrecision,Fnumber,FName_l1,Fname_l2,Fname_l3 from t_bd_currency");
            if (!_tmpSet.isEmpty()) {
                query.append(" where FNumber in (" + BgNSQLHelper.getParamSizeString((Collection)_tmpSet) + ")");
            }
            pstmt = conn.prepareStatement(query.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                CurrencyInfo _info = new CurrencyInfo();
                _info.setNumber(rst.getString("FNumber"));
                _info.setName(rst.getString("FName_L1"), this.locale_L1);
                _info.setName(rst.getString("FName_L2"), this.locale_L2);
                _info.setName(rst.getString("FName_L3"), this.locale_L3);
                _info.setPrecision(rst.getInt("FPrecision"));
                resultList.add(_info);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        int size = numberList.size();
        for (int i = 0; i < size; ++i) {
            data = (BgFormAdjustData)numberList.get(i);
            data.setPrecision(this.getCurrencyPrecision(data.getCurrency(), resultList));
            data.setCurrency(this.currencyNumber2Name(data.getCurrency(), resultList, lc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchConvertItemNameByNumber(Connection conn, Context ctx, List numberList, boolean canRepeat) throws EASBizException, BOSException {
        if (numberList == null || numberList.size() == 0) {
            return;
        }
        BgItemInfo _bgItemInfo = null;
        CostCenterOrgUnitInfo ccOrgUnitInfo = ContextUtil.getCurrentCostUnit((Context)ctx);
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Object _number = null;
        StringBuffer query = new StringBuffer();
        ArrayList<BgItemInfo> resultList = new ArrayList<BgItemInfo>();
        ArrayList<String> _tmpList = new ArrayList<String>();
        Locale lc = ctx.getLocale();
        BgFormAdjustData data = null;
        Set _tmpSet = this.getNumberQueryString(numberList, BGITEM_NUMBER_TYPE);
        _tmpList.addAll(_tmpSet);
        _tmpList.add(BgSHelper.getIsolateOrg(ctx, ccOrgUnitInfo.getId().toString()));
        try {
            if (ccOrgUnitInfo != null) {
                query.append("select FNumber,FName_L1,FName_L2,FName_L3 from T_BG_BgItem where FNumber in (" + BgNSQLHelper.getParamSizeString((Collection)_tmpSet) + ") and FOrgUnitId = ?");
                pstmt = conn.prepareStatement(query.toString());
                BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _bgItemInfo = new BgItemInfo();
                    _bgItemInfo.setNumber(rst.getString("FNumber"));
                    _bgItemInfo.setName(rst.getString("FName_L1"), this.locale_L1);
                    _bgItemInfo.setName(rst.getString("FName_L2"), this.locale_L2);
                    _bgItemInfo.setName(rst.getString("FName_L3"), this.locale_L3);
                    resultList.add(_bgItemInfo);
                }
            }
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, pstmt);
        }
        int size = numberList.size();
        for (int i = 0; i < size; ++i) {
            data = (BgFormAdjustData)numberList.get(i);
            data.setItemName(this.itemNumber2Name(data.getItemNumber(), resultList, lc));
        }
    }

    private Set getNumberQueryString(List numberList, String numberType) {
        HashSet<String> _tmpSet = new HashSet<String>();
        BgFormAdjustData data = null;
        String[] number = null;
        for (int i = 0; i < numberList.size(); ++i) {
            number = null;
            data = (BgFormAdjustData)numberList.get(i);
            if (numberType.equals(CURRENCY_NUMBER_TYPE)) {
                number = new String[]{data.getCurrency()};
            } else if (numberType.equals(ELEMENT_NUMBER_TYPE)) {
                number = new String[]{data.getElement()};
            } else if (numberType.equals(BGITEM_NUMBER_TYPE)) {
                number = data.getItemNumber().split(",");
            }
            if (number == null || number.length <= 0) continue;
            int size = number.length;
            for (int j = 0; j < size; ++j) {
                _tmpSet.add(number[j]);
            }
        }
        return _tmpSet;
    }

    protected Set getOrgUnitIds(Connection conn, BOSUuid orgUnitId, boolean canRepeat) throws EASBizException {
        HashSet<String> orgUnitIdSet = new HashSet<String>();
        if (conn == null || orgUnitId == null) {
            return orgUnitIdSet;
        }
        String[] numberStr = null;
        String _number = null;
        String _longnumber = null;
        String _orgUnitId = null;
        StringBuffer query = new StringBuffer();
        _orgUnitId = orgUnitId.toString();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("select FNumber, FLongNumber from T_ORG_CostCenter where FID = ?");
            pstmt.setString(1, _orgUnitId);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                _number = rst.getString(1);
                _longnumber = rst.getString(2);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!StringUtils.isEmpty((String)_number) && !StringUtils.isEmpty((String)_number)) {
                query.append("select FID from T_ORG_CostCenter where ");
                orgUnitIdSet = new HashSet();
                ArrayList<String> _tmpList = new ArrayList<String>();
                if (_longnumber != null) {
                    numberStr = _longnumber.split("\\!");
                    if (numberStr != null) {
                        query.append(" FNumber IN (");
                        int in = numberStr.length;
                        for (int i = 0; i < in; ++i) {
                            query.append("?,");
                            _tmpList.add(numberStr[i]);
                        }
                        query.delete(query.length() - 1, query.length());
                        query.append(") ");
                    }
                    if (!canRepeat) {
                        query.append(" or FLongNumber like ?");
                        _tmpList.add(_longnumber + "!%");
                    }
                }
                pstmt = conn.prepareStatement(query.toString());
                BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    orgUnitIdSet.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return orgUnitIdSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getInvalidAdjustValue(Context ctx, Map map) throws BOSException, EASBizException {
        if (map == null) {
            return new ArrayList();
        }
        Connection conn = null;
        ArrayList<BgFormAdjustData> result = new ArrayList<BgFormAdjustData>();
        HashMap<String, BgFormInfo> bgFormMap = new HashMap<String, BgFormInfo>();
        boolean canRepeat = false;
        String formIdStr22 = null;
        Map adjustDataMap = null;
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        BgFormInfo bgForm = null;
        BgFormAdjustData adjustData = null;
        BigDecimal afterAdjustBalance = null;
        SortedParameterArray params = new SortedParameterArray();
        Object[] parameters = null;
        Parameter param22 = null;
        Parameter _parameter = null;
        BgCalculatorProcess process = null;
        ReportCalculateContext context = null;
        BgRptReportPropertyAdapter adapter = null;
        ReportVariables variables = new ReportVariables();
        ReportCalculateErrorProvider errorProvider = new ReportCalculateErrorProvider();
        for (String formIdStr22 : map.keySet()) {
            adjustDataMap = (Map)map.get(formIdStr22);
            parameters = new Parameter[adjustDataMap.keySet().size()];
            int index = 0;
            for (Parameter param22 : adjustDataMap.keySet()) {
                parameters[index] = param22;
                ++index;
            }
            index = 0;
            params.insertAll(parameters);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(this.getBgFormInfo2());
        FilterInfo filter = new FilterInfo();
        HashSet<String> bgFormIdSet = new HashSet<String>();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            process = new BgCalculatorProcess();
            String _formIdStr = (String)it.next();
            adjustDataMap = (Map)map.get(formIdStr22);
            if (adjustDataMap == null || adjustDataMap.isEmpty()) continue;
            bgFormIdSet.add(_formIdStr);
        }
        filter.getFilterItems().add(new FilterItemInfo("id", bgFormIdSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        BgFormCollection bgFormCols = null;
        try {
            bgFormCols = iBgForm.getBgFormCollection(evi);
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        BgFormInfo info = null;
        if (bgFormCols != null && bgFormCols.size() > 0) {
            int size = bgFormCols.size();
            for (int i = 0; i < size; ++i) {
                info = bgFormCols.get(i);
                bgFormMap.put(info.getId().toString(), info);
            }
        }
        if (info != null) {
            process = new BgCalculatorProcess();
            adapter = new BgRptReportPropertyAdapter(info);
            context = new ReportCalculateContext(ctx, (IReportPropertyAdapter)adapter, variables, (IErrorProvider)errorProvider, null);
            process.initialize("bgNAvlBal", (ICalculateContextProvider)context, ctx, params);
            process.process();
        }
        for (String formIdStr22 : map.keySet()) {
            adjustDataMap = (Map)map.get(formIdStr22);
            if (adjustDataMap == null || adjustDataMap.isEmpty() || !bgFormMap.containsKey(formIdStr22) || (bgForm = (BgFormInfo)bgFormMap.get(formIdStr22)) == null) continue;
            _parameter = null;
            int in = params.size();
            for (int i = 0; i < in; ++i) {
                _parameter = params.getParameter(i);
                if (!adjustDataMap.containsKey(_parameter)) continue;
                adjustData = (BgFormAdjustData)adjustDataMap.get(_parameter);
                if (_parameter.getValue() instanceof BigDecimal) {
                    afterAdjustBalance = (BigDecimal)_parameter.getValue();
                    if (afterAdjustBalance == null || !(afterAdjustBalance.doubleValue() < 0.0)) continue;
                    adjustData.setAdjustBalance(afterAdjustBalance);
                    result.add(adjustData.replicate());
                    continue;
                }
                if (!(_parameter.getValue() instanceof String)) continue;
                adjustData.setBadFunction((String)_parameter.getValue());
                result.add(adjustData.replicate());
            }
        }
        if (result.size() == 0) {
            return result;
        }
        canRepeat = BgSHelper.isBgItemNumberRepeat(ctx);
        try {
            conn = this.getConnection(ctx);
            this.batchConvertCurrencyNameByNumber(conn, ctx, result);
            this.batchConvertElementNameByNumber(conn, ctx, result);
            this.batchConvertItemNameByNumber(conn, ctx, result, canRepeat);
            if (conn == null) return result;
        }
        catch (BOSException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                if (conn == null) throw throwable;
                try {
                    conn.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BgException(BgException.DATABASEERROR, new String[]{e.getMessage()});
                }
            }
        }
        try {
            conn.close();
            return result;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BgException(BgException.DATABASEERROR, new String[]{e.getMessage()});
        }
    }

    public SelectorItemCollection getBgFormInfo2() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("bgTemplate.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    @Override
    protected Object[] _calculate(Context ctx, String bgFormId, String mainFormId, String bgCollectId, Map adjustMap) throws BOSException, EASBizException {
        if (bgFormId == null || mainFormId == null || bgCollectId == null) {
            return null;
        }
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(bgFormId);
        ObjectUuidPK mainPk = new ObjectUuidPK(mainFormId);
        if (!iBgForm.exists((IObjectPK)pk)) {
            return null;
        }
        if (!iBgForm.exists((IObjectPK)mainPk)) {
            return null;
        }
        byte[] newData = null;
        Object[] obj = null;
        String key2 = null;
        BgFormInfo info = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), this.getBgFormInfoToRefCal());
        info.put("myBgPeriod", info.getBgPeriod());
        try {
            if (info.getId().toString().equals(mainFormId)) {
                newData = this.getMainNewData(ctx, info.getId(), bgCollectId);
                key2 = "from`" + info.getId().toString();
            } else {
                newData = this.getRefNewData(ctx, info.getId(), bgCollectId);
                key2 = "ref`" + info.getId().toString();
            }
            if (newData != null) {
                info.setData(this.getNewDataToRefCal(newData, IOHelper.unpackBook((byte[])newData), info.getId(), adjustMap));
            } else if (info.getData() != null) {
                info.setData(this.getNewDataToRefCal(info.getData(), IOHelper.unpackBook((byte[])info.getData()), info.getId(), adjustMap));
            }
            HashMap<String, BigDecimal> newAdjustMap = new HashMap<String, BigDecimal>();
            if (!adjustMap.isEmpty()) {
                BgAdjustFormDiversityData value = null;
                for (String key2 : adjustMap.keySet()) {
                    value = (BgAdjustFormDiversityData)adjustMap.get(key2);
                    key2 = info.getOrgUnit().getId().toString() + "!" + info.getBgScheme().getId().toString() + "!" + key2;
                    newAdjustMap.put(key2, value.getNewValue());
                }
            }
            BgNFSHelper.setFormulaMap((BgFormInfo)info, newAdjustMap);
            ArrayList tableData = ReportFactory.getLocalInstance((Context)ctx).backCalcEx((IObjectValue)info, info.getZipData(), null);
            obj = this._updateBgFormData(ctx, bgFormId, (IObjectValue)info, tableData);
            this._updateDataToBgTmpData(ctx, info.getId().toString(), obj[0]);
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        Object[] result = new Object[2];
        if (obj != null) {
            result[0] = obj[0];
            result[1] = bgFormId.equals(mainFormId) ? (Map)obj[2] : null;
            RefBgFormInfo refInfo = null;
            HashMap<String, RefBgFormInfo> dataMap = new HashMap<String, RefBgFormInfo>();
            try {
                refInfo = new RefBgFormInfo();
            }
            catch (IOException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            if (refInfo != null) {
                refInfo.setKdtData((byte[])obj[1]);
            }
            dataMap.put(key2, refInfo);
            if (refInfo != null) {
                this._updateDataForForm(ctx, bgCollectId, dataMap);
            }
        }
        return result;
    }

    private byte[] getNewDataToRefCal(byte[] data, Book book, BOSUuid bgFormId, Map adjustMap) throws Exception {
        if (adjustMap == null || adjustMap.isEmpty() || adjustMap.toString().equals("{}")) {
            return data;
        }
        if (book == null) {
            return data;
        }
        Sheet table = null;
        int rowIndex = 0;
        int colIndex = 0;
        int rowCount = 0;
        int colCount = 0;
        String formulaString = null;
        BgFormDiversityData adjustData = null;
        book.setCalculate(false);
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        for (int n = 0; n < book.getSheetCount(); ++n) {
            table = book.getSheet(n);
            rowCount = table.getMaxRowIndex() + 1;
            colCount = table.getMaxColIndex() + 1;
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex < colCount; ++colIndex) {
                    Cell cell = table.getCell(rowIndex, colIndex, true);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell) || !adjustMap.containsKey(formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell))) continue;
                    adjustData = (BgFormDiversityData)adjustMap.get(formulaString);
                    Object valueString = null;
                    if (adjustData == null || adjustData.getNewValue() == null) {
                        BgNFSHelper.setValue((Cell)cell, null);
                        BgNFSHelper.getItemFormula((Cell)cell).putExt("BG_BUDGET_VALUE", null);
                    } else {
                        BgNFSHelper.setValue((Cell)cell, (Object)adjustData.getNewValue());
                        BgNFSHelper.getItemFormula((Cell)cell).putExt("BG_BUDGET_VALUE", adjustData.getNewValue().toString());
                    }
                    if (adjustData.getOldValue() == null) {
                        adjustData.setOldValue(BgConstants.BIGZERO);
                    }
                    if (adjustData.getNewValue().compareTo(adjustData.getOldValue()) == 0) continue;
                    BgNFSHelper.setBackGroup((Cell)cell, (Color)BgSHelper.EDIT_COLOR);
                }
            }
        }
        return IOHelper.packBook((Book)book);
    }

    private byte[] getMainNewData(Context ctx, BOSUuid uuid, String bgColId) throws Exception {
        BgCollectFormInfo info = BgCollectFormFactory.getLocalInstance(ctx).getBgCollectFormInfo("select id, kdtData where id = '" + bgColId + "'");
        return info == null ? null : info.getKdtData();
    }

    private byte[] getRefNewData(Context ctx, BOSUuid uuid, String bgColId) throws Exception {
        RefBgFormInfo info = RefBgFormFactory.getLocalInstance(ctx).getRefBgFormInfo("select id , kdtData where bgCollect.id = '" + bgColId + "' and bgForm.id = '" + uuid.toString() + "'");
        return info == null ? null : info.getKdtData();
    }

    public SelectorItemCollection getBgFormInfoToRefCal() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add("startDate");
        sic.add("endDate");
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.precision"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("sourceType"));
        return sic;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _updateAdjustData(Context ctx, String id, Map adjustMap) throws BOSException, EASBizException {
        if (id == null) return;
        if (adjustMap == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bgForm.id"));
        sic.add(new SelectorItemInfo("refBgForms.id"));
        sic.add(new SelectorItemInfo("refBgForms.bgForm.id"));
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BgCollectFormInfo info = this.getBgCollectFormInfo(ctx, (IObjectPK)pk, sic);
        String maiFormSql = "update T_BG_BgCollectForm set FAdjustMapData = ? where FId = ?";
        String entryFormSql = "update T_BG_RefBgForm set FAdjustMapData = ? where FId = ?";
        BgFormInfo bgFormInfo = null;
        Connection conn = null;
        PreparedStatement mainPrst = null;
        PreparedStatement entryPrst = null;
        try {
            conn = this.getConnection(ctx);
            BOSUuid mainBgFormId = info.getBgForm().getId();
            if (adjustMap.containsKey(mainBgFormId)) {
                HashMap childAdjMap = (HashMap)adjustMap.get(mainBgFormId);
                if (childAdjMap != null && !childAdjMap.isEmpty()) {
                    bgFormInfo = BgFSHelper.getBgFormInfo(conn, mainBgFormId, false);
                    BgNAdjHelper.createTmpDataOfFormula((Context)ctx, (Connection)conn, (BOSUuid)bgFormInfo.getOrgUnit().getId(), (BOSUuid)bgFormInfo.getBgScheme().getId(), (BOSUuid)bgFormInfo.getBgTemplate().getId(), (BOSUuid)bgFormInfo.getId(), (Map)childAdjMap);
                } else {
                    SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + mainBgFormId.toString() + "'"));
                }
                mainPrst = conn.prepareStatement(maiFormSql);
                mainPrst.setBytes(1, BgHelper.storeHashMapToByte(childAdjMap));
                mainPrst.setString(2, info.getId().toString());
                mainPrst.executeUpdate();
                childAdjMap.clear();
            }
            RefBgFormInfo refInfo = null;
            entryPrst = conn.prepareStatement(entryFormSql);
            int size = info.getRefBgForms().size();
            for (int i = 0; i < size; ++i) {
                refInfo = info.getRefBgForms().get(i);
                BOSUuid entryFormId = refInfo.getBgForm().getId();
                if (!adjustMap.containsKey(entryFormId)) continue;
                HashMap childAdjMap = (HashMap)adjustMap.get(entryFormId);
                if (childAdjMap != null && !childAdjMap.isEmpty()) {
                    bgFormInfo = BgFSHelper.getBgFormInfo(conn, entryFormId, false);
                    BgFSHelper.createTmpDataOfFormula(ctx, conn, bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgScheme().getId(), bgFormInfo.getBgTemplate().getId(), bgFormInfo.getId(), childAdjMap);
                } else {
                    SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + entryFormId.toString() + "'"));
                }
                entryPrst.setBytes(1, BgHelper.storeHashMapToByte(childAdjMap));
                entryPrst.setString(2, refInfo.getId().toString());
                entryPrst.addBatch();
                childAdjMap.clear();
            }
            entryPrst.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (IOException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(entryPrst);
                SQLUtils.cleanup(mainPrst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)entryPrst);
        SQLUtils.cleanup(mainPrst, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _saveKdf(Context ctx, String id, byte[] data) throws BOSException, EASBizException {
        if (id == null) return;
        if (data == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgCollectForm set FKdtData = ? where FId = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setBytes(1, data);
            pstmt.setString(2, id);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected List _getAllNegativeAdjustCheckDataForView(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return null;
        }
        Map adjustMap = this.queryBgTmpDataInfoForRollView(ctx, bgFormIds);
        return BgCollectFormFactory.getLocalInstance(ctx).getAllNegativeAdjustCheckData(adjustMap);
    }

    private Map queryBgTmpDataInfoForRollView(Context ctx, List bgFormIds) throws BOSException {
        HashMap result = new HashMap();
        StringBuffer sql = new StringBuffer();
        sql.append("select bgData.FbgFormId, bgData.FFormula, bgData.FBgValue, bgData.FBizActual, bgData.FAdjustorID, bgData.FAdjustTime, bgData.FAdjustReason").append(" from t_bg_bgtmpdata bgData where FbgFormId in (");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        String formula = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql.toString());
            Map subMap = null;
            BOSUuid fBgFormId = null;
            Object[] params = bgFormIds.toArray();
            int batchCount = (params.length - 1) / 200 + 1;
            for (int i = 0; i < batchCount; ++i) {
                BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)1, (int)i, (int)200, (Object[])params);
                res = pstmt.executeQuery();
                while (res.next()) {
                    fBgFormId = BOSUuid.read((String)res.getString("FbgFormId"));
                    if (!result.containsKey(fBgFormId)) {
                        result.put(fBgFormId, new HashMap());
                    }
                    subMap = (Map)result.get(fBgFormId);
                    formula = res.getString("FFormula");
                    BgAdjustFormDiversityData bgDiversityData = new BgAdjustFormDiversityData();
                    bgDiversityData.setOldValue(res.getBigDecimal("FBizActual"));
                    bgDiversityData.setNewValue(res.getBigDecimal("FBgValue"));
                    bgDiversityData.setAdjustor(res.getString("FAdjustorID"));
                    bgDiversityData.setAdjustTime(res.getTimestamp("FAdjustTime"));
                    bgDiversityData.setAdjustReson(res.getString("FAdjustReason"));
                    bgDiversityData.setFormula(formula);
                    subMap.put(formula, bgDiversityData);
                }
                SQLUtils.cleanup((ResultSet)res);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        return result;
    }

    @Override
    protected String _getAdjustReason(Context ctx, IObjectPK bgCollectFormID) throws BOSException, EASBizException {
        String adjustReason = "";
        StringBuffer sqlToGetAdjustReason = new StringBuffer("SELECT BGCOLLECTFORM.FAdjustReason AS FADJUSTREASON FROM T_BG_BgCollectForm BGCOLLECTFORM");
        sqlToGetAdjustReason.append(" where BGCOLLECTFORM.FID = ?");
        IRowSet rsToGetsqlToGetAdjustReason = DbUtil.executeQuery((Context)ctx, (String)sqlToGetAdjustReason.toString(), (Object[])new Object[]{bgCollectFormID.toString()});
        try {
            while (rsToGetsqlToGetAdjustReason.next()) {
                if (rsToGetsqlToGetAdjustReason.getObject("FADJUSTREASON") == null) continue;
                adjustReason = rsToGetsqlToGetAdjustReason.getString("FADJUSTREASON");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adjustReason;
    }

    @Override
    protected void _setAdjustReason(Context ctx, IObjectPK bgCollectFormID, String adjustReason) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("UPDATE T_BG_BgCollectForm SET FAdjustReason = ? where FID = ?");
            pstmt.setString(1, adjustReason);
            pstmt.setString(2, bgCollectFormID.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

