/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgControlItemMapCollection;
import com.kingdee.eas.ma.budget.BgControlItemMapInfo;
import com.kingdee.eas.ma.budget.app.AbstractBgControlItemMapControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.log4j.Logger;

public class BgControlItemMapControllerBean
extends AbstractBgControlItemMapControllerBean {
    private static final long serialVersionUID = 1557802930437094554L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgControlItemMapControllerBean");

    @Override
    protected void _saveBgItemMap(Context ctx, BOSUuid ctrlSchemeId, IObjectCollection itemMapColl) throws BOSException, EASBizException {
        int i;
        String sql1 = "delete from t_bg_bgControlItemMap where fbgctrlschemeid = ?";
        String sql2 = "insert into t_bg_bgControlItemMap( FID,FBgCtrlSchemeID, FBillFieldCombinValue,FBillFieldCombinAlias,FBillItemCombinValue, FBillItemCombinAlias,FBgItemCombinID,FBgItemCombinKey,FBgItemCombinAlias)  values(?,?,?,?,?,?,?,?,?)";
        int index = 0;
        int batchNumber = 200;
        Connection conn = null;
        PreparedStatement ps = null;
        Object[] uuids = new String[itemMapColl.size()];
        BgControlItemMapInfo tmpInfo = new BgControlItemMapInfo();
        for (i = 0; i < itemMapColl.size(); ++i) {
            uuids[i] = BOSUuid.create((BOSObjectType)tmpInfo.getBOSType()).toString();
        }
        Arrays.sort(uuids);
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql1);
            ps.setString(1, ctrlSchemeId.toString());
            ps.execute();
            SQLUtils.cleanup((Statement)ps);
            ps = conn.prepareStatement(sql2);
            for (i = 0; i < itemMapColl.size(); ++i) {
                BgControlItemMapInfo info = (BgControlItemMapInfo)itemMapColl.getObject(i);
                if (info.getBgItemCombinID() == null) continue;
                ps.setString(1, (String)uuids[i]);
                ps.setString(2, ctrlSchemeId.toString());
                ps.setString(3, info.getBillFieldCombinValue());
                ps.setString(4, info.getBillFieldCombinAlias());
                ps.setString(5, info.getBillItemCombinValue());
                ps.setString(6, info.getBillItemCombinAlias());
                ps.setString(7, info.getBgItemCombinID().toString());
                ps.setString(8, info.getBgItemCombinKey());
                ps.setString(9, info.getBgItemCombinAlias());
                ps.addBatch();
                if (++index <= batchNumber) continue;
                ps.executeBatch();
                index = 0;
            }
            if (index != 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("BgControlItemMap:" + e));
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                tmpInfo = null;
                uuids = null;
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        tmpInfo = null;
        uuids = null;
    }

    @Override
    protected IObjectCollection _getBgItemMapColl(Context ctx, BOSUuid ctrlSchemeId) throws BOSException, EASBizException {
        BgControlItemMapCollection coll = new BgControlItemMapCollection();
        String sql = "select FBillFieldCombinValue, FBillFieldCombinAlias, FBillItemCombinValue,  FBillItemCombinAlias, FBgItemCombinID, FBgItemCombinKey, FBgItemCombinAlias  from t_bg_bgControlItemMap  where fbgctrlschemeid = ?  order by FBillItemCombinValue asc";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{ctrlSchemeId.toString()});
        String[] sorts = null;
        String[] values = null;
        try {
            while (rs.next()) {
                BgControlItemMapInfo info = new BgControlItemMapInfo();
                String billFieldCombinValue = rs.getString(1);
                String billFieldCombinAlias = rs.getString(2);
                String billItemCombinValue = rs.getString(3);
                String billItemCombinAlias = rs.getString(4);
                String bgItemCombinID = rs.getString(5);
                String bgItemCombinKey = rs.getString(6);
                String bgItemCombinAlias = rs.getString(7);
                info.setBillFieldCombinValue(billFieldCombinValue);
                info.setBillFieldCombinAlias(billFieldCombinAlias);
                info.setBillItemCombinValue(billItemCombinValue);
                info.setBillItemCombinAlias(billItemCombinAlias);
                info.setBgItemCombinID(bgItemCombinID);
                info.setBgItemCombinKey(bgItemCombinKey);
                info.setBgItemCombinAlias(bgItemCombinAlias);
                sorts = null;
                if (!StringUtils.isEmpty((String)billItemCombinValue)) {
                    sorts = billItemCombinValue.split("\\|");
                    for (int i = 0; i < sorts.length; ++i) {
                        values = sorts[i].split(":");
                        sorts[i] = values != null && values.length == 2 && !"%".equals(values[1]) && !StringUtils.isEmpty((String)values[1]) ? values[1] : null;
                    }
                }
                info.put("ItemSortParam", sorts);
                coll.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("BgControlItemMap:" + e));
            throw new BOSException(e.toString());
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        if (!coll.isEmpty()) {
            Object[] itemMaps = coll.toArray();
            Arrays.sort(itemMaps, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    String[] left = (String[])((BgControlItemMapInfo)arg0).get("ItemSortParam");
                    String[] right = (String[])((BgControlItemMapInfo)arg1).get("ItemSortParam");
                    if (left == null && right == null) {
                        return 0;
                    }
                    if (left == null) {
                        return 1;
                    }
                    if (right == null) {
                        return -1;
                    }
                    for (int i = 0; i < left.length; ++i) {
                        if (right.length <= i) {
                            return -1;
                        }
                        if (left[i] == null && right[i] == null) continue;
                        if (left[i] == null) {
                            return 1;
                        }
                        if (right[i] == null) {
                            return -1;
                        }
                        if (left[i].equals(right[i])) continue;
                        return left[i].compareTo(right[i]);
                    }
                    return 0;
                }
            });
            coll.clear();
            for (int i = 0; i < itemMaps.length; ++i) {
                coll.add((BgControlItemMapInfo)itemMaps[i]);
            }
        }
        return coll;
    }

    @Override
    protected String[] _mapBillItemToBgItem(Context ctx, BOSUuid bgCtrlSchemeID, String billItem) throws BOSException, EASBizException {
        String[] result = new String[2];
        String sql1 = "select FBillItemCombinValue, FBgItemCombinKey ,fbillitemcombinalias from t_bg_bgControlItemMap  where fbgctrlschemeid = ? and ( FBillItemCombinValue = ? or FBillItemCombinValue like '%\\%%' escape '\\' ) ";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{bgCtrlSchemeID.toString(), billItem});
            while (rs.next()) {
                int i;
                String _billItem = rs.getString(1);
                String[] _aa = _billItem.split("\\|");
                String[] aa = billItem.split("\\|");
                if (aa == null || _aa == null || _aa.length <= 0 || _aa.length != aa.length) continue;
                boolean isCheck = true;
                int spIndex = -1;
                for (i = 0; i < _aa.length; ++i) {
                    if (_aa[i].indexOf("%") <= 0) continue;
                    spIndex = i;
                    break;
                }
                for (i = 0; i < aa.length; ++i) {
                    if (i == spIndex || aa[i].equals(_aa[i])) continue;
                    isCheck = false;
                    break;
                }
                if (!isCheck) continue;
                if (spIndex != -1) {
                    _aa[spIndex] = _aa[spIndex].replaceAll("%", "");
                }
                if (spIndex != -1 && !aa[spIndex].startsWith(_aa[spIndex])) continue;
                result[0] = rs.getString(2);
                result[1] = rs.getString(3);
                String cc = "";
                if (result[1] != null && result[1].trim().length() != 0) {
                    String[] tmp = result[1].split("\\|");
                    for (int i2 = 0; i2 < tmp.length; ++i2) {
                        String[] subTmp = tmp[i2].split(":");
                        if (subTmp == null || subTmp.length != 2) continue;
                        cc = cc + subTmp[1] + "_";
                    }
                }
                result[1] = cc = cc.substring(0, cc.length() - 1);
                break;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }
}

