/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgControlException;
import com.kingdee.eas.ma.budget.BgControlRuleCollection;
import com.kingdee.eas.ma.budget.BgControlRuleInfo;
import com.kingdee.eas.ma.budget.BgControlSchemeFactory;
import com.kingdee.eas.ma.budget.BgControlSchemeInfo;
import com.kingdee.eas.ma.budget.IBgControlScheme;
import com.kingdee.eas.ma.budget.app.AbstractBgControlRuleControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import org.apache.log4j.Logger;

public class BgControlRuleControllerBean
extends AbstractBgControlRuleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgControlRuleControllerBean");

    @Override
    protected void _enableBgControlRule(Context ctx, IObjectPK bgControlRulePK) throws BOSException, EASBizException {
        BgControlRuleInfo bgCtrlRuleInfo = (BgControlRuleInfo)this._getValue(ctx, bgControlRulePK);
        if (bgCtrlRuleInfo.isIsEnable()) {
            throw new BgControlException(BgControlException.BGCTRLRULEHASENABLE, new Object[]{bgCtrlRuleInfo.getNumber()});
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("billName", (Object)bgCtrlRuleInfo.getBillName()));
        filter.getFilterItems().add(new FilterItemInfo("packageName", (Object)bgCtrlRuleInfo.getPackageName()));
        filter.getFilterItems().add(new FilterItemInfo("isEnable", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)bgControlRulePK.toString(), CompareType.NOTEQUALS));
        BgControlRuleCollection enableRuleCols = this.getBgControlRuleCollection(ctx, evi);
        if (enableRuleCols != null && enableRuleCols.size() > 0) {
            BgControlRuleInfo enableRuleInfo = enableRuleCols.get(0);
            throw new BgControlException(BgControlException.HASENABLERULEWITHBILL, new Object[]{enableRuleInfo.getPackageAlias(), enableRuleInfo.getBillAlias(), enableRuleInfo.getNumber()});
        }
        bgCtrlRuleInfo.setIsEnable(true);
        this._update(ctx, bgControlRulePK, (IObjectValue)bgCtrlRuleInfo);
        if (bgCtrlRuleInfo.getBgCtrlScheme() != null && bgCtrlRuleInfo.getBgCtrlScheme().getId() != null) {
            String bgCtrlSchemeId = bgCtrlRuleInfo.getBgCtrlScheme().getId().toString();
            this.setBgCtrlSchemStatus(ctx, bgCtrlSchemeId, true);
        }
    }

    private void setBgCtrlSchemStatus(Context ctx, String bgCtrlSchemeId, boolean status) throws BOSException {
        String sqlToSetBgCtrlSchemeStatus = "UPDATE T_BG_BgControlScheme SET FIsValid = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sqlToSetBgCtrlSchemeStatus, (Object[])new Object[]{status, bgCtrlSchemeId});
    }

    @Override
    protected void _disableBgControlRule(Context ctx, IObjectPK bgControlRulePK) throws BOSException, EASBizException {
        BgControlRuleInfo bgCtrlRuleInfo = (BgControlRuleInfo)this._getValue(ctx, bgControlRulePK);
        if (!bgCtrlRuleInfo.isIsEnable()) {
            throw new BgControlException(BgControlException.BGCTRLRULEHASDISABLE, new Object[]{bgCtrlRuleInfo.getNumber()});
        }
        bgCtrlRuleInfo.setIsEnable(false);
        this._update(ctx, bgControlRulePK, (IObjectValue)bgCtrlRuleInfo);
        if (bgCtrlRuleInfo.getBgCtrlScheme() != null && bgCtrlRuleInfo.getBgCtrlScheme().getId() != null) {
            String bgCtrlSchemeId = bgCtrlRuleInfo.getBgCtrlScheme().getId().toString();
            this.setBgCtrlSchemStatus(ctx, bgCtrlSchemeId, false);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    private BgControlSchemeInfo submitBgScheme(Context ctx, BgControlRuleInfo model) throws BOSException, EASBizException {
        BgControlSchemeInfo bgCtrlSchemeInfo = model.getBgCtrlScheme();
        if (bgCtrlSchemeInfo == null) {
            bgCtrlSchemeInfo = new BgControlSchemeInfo();
        }
        bgCtrlSchemeInfo.setNumber(model.getNumber());
        bgCtrlSchemeInfo.setName(model.getName());
        bgCtrlSchemeInfo.setDescription(model.getDescription());
        bgCtrlSchemeInfo.setBoAlias(model.getBillAlias());
        bgCtrlSchemeInfo.setBoName(model.getBillName());
        bgCtrlSchemeInfo.setSubSystemAlias(model.getPackageAlias());
        bgCtrlSchemeInfo.setSubSystemName(model.getPackageName());
        bgCtrlSchemeInfo.setIsValid(model.isIsEnable());
        FullOrgUnitInfo orgUnit = new FullOrgUnitInfo();
        orgUnit.setId(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
        bgCtrlSchemeInfo.setOrgUnit(orgUnit);
        IBgControlScheme bgScheme = BgControlSchemeFactory.getLocalInstance(ctx);
        IObjectPK pk = bgScheme.submit((CoreBaseInfo)bgCtrlSchemeInfo);
        bgCtrlSchemeInfo.setId(BOSUuid.read((String)pk.toString()));
        return bgCtrlSchemeInfo;
    }

    private void checkPropertyValid(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        this._checkNumberBlank(ctx, model);
        this._checkNameBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameDup(ctx, model);
        BgControlRuleInfo bgCtrlRuleInfo = (BgControlRuleInfo)model;
        if (bgCtrlRuleInfo.getPeriodCycle() == null) {
            throw new BgControlException(BgControlException.BGCTRLRULEPERIODNULL, new Object[]{model.get("number")});
        }
        if (bgCtrlRuleInfo.getElementNumber() == null || bgCtrlRuleInfo.getElementNumber().length() == 0) {
            throw new BgControlException(BgControlException.BGCTRLRULEELEMENTNULL, new Object[]{model.get("number")});
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        super._addnew(ctx, pk, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return null;
    }
}

