/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.ma.budget.BgControlException;
import com.kingdee.eas.ma.budget.BgControlItemMapCollection;
import com.kingdee.eas.ma.budget.BgControlItemMapFactory;
import com.kingdee.eas.ma.budget.BgControlMultiRuleCollection;
import com.kingdee.eas.ma.budget.BgControlMultiRuleFactory;
import com.kingdee.eas.ma.budget.BgControlMultiRuleInfo;
import com.kingdee.eas.ma.budget.BgControlPeriodMapCollection;
import com.kingdee.eas.ma.budget.BgControlPeriodMapFactory;
import com.kingdee.eas.ma.budget.BgControlPeriodMapInfo;
import com.kingdee.eas.ma.budget.BgControlRuleCollection;
import com.kingdee.eas.ma.budget.BgControlRuleInfo;
import com.kingdee.eas.ma.budget.BgControlSchemeCollection;
import com.kingdee.eas.ma.budget.BgControlSchemeFactory;
import com.kingdee.eas.ma.budget.BgControlSchemeInfo;
import com.kingdee.eas.ma.budget.BgCtrlMultiRuleEntryInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgSchemeAssignException;
import com.kingdee.eas.ma.budget.BgTemplateHelper;
import com.kingdee.eas.ma.budget.IBgControlItemMap;
import com.kingdee.eas.ma.budget.IBgControlMultiRule;
import com.kingdee.eas.ma.budget.IBgControlPeriodMap;
import com.kingdee.eas.ma.budget.IBgControlScheme;
import com.kingdee.eas.ma.budget.app.AbstractBgControlSchemeControllerBean;
import com.kingdee.eas.ma.nbudget.app.BgCodeNumberNHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgControlSchemeControllerBean
extends AbstractBgControlSchemeControllerBean {
    private static final long serialVersionUID = 3079510935045321076L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgControlSchemeControllerBean");

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("boName");
        sic.add("boAlias");
        sic.add("subSystemName");
        sic.add("subSystemAlias");
        sic.add("isValid");
        sic.add("isAssigned");
        sic.add("isNotAllowUpdate");
        sic.add("isNotAllowChangeState");
        sic.add("orgUnit.id");
        sic.add("costCenter.id");
        return sic;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        this.checkPropertyValid(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgControlSchemeInfo info = (BgControlSchemeInfo)this._getValue(ctx, pk, this.getSelector());
        if (info != null && info.getOrgUnit() != null && info.getOrgUnit().getId() != null) {
            BgCodeNumberNHelper.recycleNumber((Context)ctx, (IObjectValue)info, (String)info.getOrgUnit().getId().toString(), (String)info.getNumber());
        }
        IRowSet rst = null;
        String sql1 = "delete from t_bg_bgControlItemMap where fbgctrlschemeid = ?";
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            rst = DbUtil.executeQuery((Context)ctx, (String)"select fid from t_bg_bgcontrolscheme where fid <> ? and frootid = ?", (Object[])new String[]{pk.toString(), pk.toString()});
            if (rst.next()) {
                throw new BgSchemeAssignException(BgSchemeAssignException.NOTALLOWDELETEASSIGNED);
            }
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql1);
            ps.setString(1, pk.toString());
            ps.execute();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"BgControlItemMap:", (Throwable)e);
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)ps, (Connection)connection);
        super._delete(ctx, pk);
    }

    protected void _isReferenced(Context ctx, IObjectPK pk, Connection cn) throws ObjectReferedException {
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgControlSchemeInfo info = (BgControlSchemeInfo)model;
        this.checkPropertyValid(ctx, model);
        boolean isAssigned = false;
        if (info.getParent() != null && info.getParent().getId() != null && info.getRoot() != null && info.getRoot().getId() != null) {
            isAssigned = true;
        }
        if (isAssigned) {
            info.setIsAssigned(true);
        } else {
            info.setParent(info);
            info.setRoot(info);
            info.setIsAssigned(false);
            info.setIsNotAllowChangeState(false);
        }
        return super._addnew(ctx, model);
    }

    @Override
    protected void _setBgCtrlSchemeValidStatus(Context ctx, IObjectPK pk, boolean status) throws BOSException, EASBizException {
        BgControlSchemeInfo info = (BgControlSchemeInfo)this._getValue(ctx, pk, this.getSelector());
        if (info.isIsAssigned() && info.isIsNotAllowChangeState()) {
            throw new BgControlException(BgControlException.ASSIGEDNNOTALLOWCHANGESTATE);
        }
        if (status) {
            this.enableBgCtrlScheme(ctx, pk);
        } else {
            this.disableBgCtrlScheme(ctx, pk);
        }
    }

    private void disableBgCtrlScheme(Context ctx, IObjectPK pk) throws BOSException {
        this.setBgCtrlSchemStatus(ctx, pk.toString(), false);
    }

    private void enableBgCtrlScheme(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgControlSchemeInfo bgCtrlSchemeInfo = (BgControlSchemeInfo)this._getValue(ctx, pk, this.getSelector());
        if (bgCtrlSchemeInfo.isIsValid()) {
            throw new BgControlException(BgControlException.BGCTRLRULEHASENABLE, new Object[]{bgCtrlSchemeInfo.getNumber()});
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("boName", (Object)bgCtrlSchemeInfo.getBoName()));
        filter.getFilterItems().add(new FilterItemInfo("subSystemName", (Object)bgCtrlSchemeInfo.getSubSystemName()));
        filter.getFilterItems().add(new FilterItemInfo("isValid", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("costCenter.id", (Object)bgCtrlSchemeInfo.getCostCenter().getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)this.getSelector());
        BgControlSchemeCollection enableSchemeCols = this.getBgControlSchemeCollection(ctx, view);
        if (enableSchemeCols != null && enableSchemeCols.size() > 0) {
            BgControlSchemeInfo enableSchemeInfo = enableSchemeCols.get(0);
            throw new BgControlException(BgControlException.HASENABLERULEWITHBILL, new Object[]{enableSchemeInfo.getSubSystemAlias(), enableSchemeInfo.getBoAlias(), enableSchemeInfo.getNumber()});
        }
        this.setBgCtrlSchemStatus(ctx, pk.toString(), true);
    }

    private void setBgCtrlSchemStatus(Context ctx, String bgCtrlSchemeId, boolean status) throws BOSException {
        String sqlToSetBgCtrlSchemeStatus = "UPDATE T_BG_BgControlScheme SET FIsValid = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)sqlToSetBgCtrlSchemeStatus, (Object[])new Object[]{status, bgCtrlSchemeId});
    }

    private void checkPropertyValid(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        BgControlSchemeInfo bgCtrlSchemeInfo = (BgControlSchemeInfo)model;
        if (bgCtrlSchemeInfo.getOrgUnit() != null && bgCtrlSchemeInfo.getOrgUnit().getId() != null) {
            BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)bgCtrlSchemeInfo, (String)bgCtrlSchemeInfo.getOrgUnit().getId().toString());
        }
        if (StringUtils.isEmpty((String)bgCtrlSchemeInfo.getNumber())) {
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
        if (StringUtils.isEmpty((String)bgCtrlSchemeInfo.getName())) {
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
        if (bgCtrlSchemeInfo.getRules() == null || bgCtrlSchemeInfo.getRules().size() == 0) {
            throw new BgControlException(BgControlException.BGCTRLSCHEMEMUSTHASRULE, new Object[]{bgCtrlSchemeInfo.getNumber()});
        }
        int count = bgCtrlSchemeInfo.getRules().size();
        for (int i = 0; i < count; ++i) {
            BgControlRuleInfo bgCtrlRuleInfo = bgCtrlSchemeInfo.getRules().get(i);
            if (bgCtrlRuleInfo.getPeriodCycle() == null) {
                throw new BgControlException(BgControlException.BGCTRLRULEPERIODNULL, new Object[]{new Integer(i + 1)});
            }
            if (bgCtrlRuleInfo.getElementNumber() != null && bgCtrlRuleInfo.getElementNumber().length() != 0) continue;
            throw new BgControlException(BgControlException.BGCTRLRULEELEMENTNULL, new Object[]{new Integer(i + 1)});
        }
    }

    private void _checkNumberDup(Context ctx, BgControlSchemeInfo bgCtrlSchemeInfo) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)bgCtrlSchemeInfo.getNumber()));
        if (bgCtrlSchemeInfo.getCostCenter() != null && bgCtrlSchemeInfo.getCostCenter().getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("costCenter.id", (Object)bgCtrlSchemeInfo.getCostCenter().getId().toString()));
        }
        if (bgCtrlSchemeInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)bgCtrlSchemeInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{bgCtrlSchemeInfo.getNumber()});
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String logInfo = "";
        if (ctx == null) return logInfo;
        if (pk == null) {
            return logInfo;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FNumber, FName_" + ctx.getLocale() + " from T_BG_BgControlScheme where FID = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, pk.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                logInfo = rst.getString(1) + "-" + rst.getString(2);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return logInfo;
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue bgCtrlScheme, IObjectCollection bgItemMapColl, IObjectCollection bgPeriodMapColl, IObjectCollection bgCtrlMultiRule) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, (BgControlSchemeInfo)bgCtrlScheme);
        BgControlSchemeInfo info = (BgControlSchemeInfo)bgCtrlScheme;
        if (info.getId() != null) {
            String sql1 = "delete from t_bg_bgControlItemMap where fbgctrlschemeid = ?";
            DbUtil.execute((Context)ctx, (String)sql1, (Object[])new Object[]{info.getId().toString()});
        }
        bgCtrlScheme.remove("itemMap");
        IObjectPK pk = this._submit(ctx, bgCtrlScheme);
        IBgControlItemMap iMap = BgControlItemMapFactory.getLocalInstance(ctx);
        iMap.saveBgItemMap(BOSUuid.read((String)pk.toString()), (BgControlItemMapCollection)bgItemMapColl);
        IBgControlPeriodMap iMap2 = BgControlPeriodMapFactory.getLocalInstance(ctx);
        iMap2.savePeriodMap(pk.toString(), (BgControlPeriodMapCollection)bgPeriodMapColl);
        if (((BgControlSchemeInfo)bgCtrlScheme).getId() != null) {
            // empty if block
        }
        IBgControlMultiRule iBgControlMultiRule = BgControlMultiRuleFactory.getLocalInstance(ctx);
        iBgControlMultiRule.saveMultiRule(BOSUuid.read((String)pk.toString()).toString(), (BgControlMultiRuleCollection)bgCtrlMultiRule);
        return pk;
    }

    public static Vector getBudgetItemMap(Context ctx, String id) throws BgSchemeAssignException {
        String sql1 = " select FBgItemCombinId  from t_bg_bgControlItemMap where fbgctrlschemeid = '" + id + "' ";
        Vector<String> idVec = new Vector<String>();
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql1);
            while (row.next()) {
                idVec.add(row.getString("FBgItemCombinId"));
            }
        }
        catch (BOSException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        return idVec;
    }

    @Override
    protected Map _checkNumberBeforeAssign(Context ctx, Map schemeOrgMap) throws BOSException, EASBizException {
        HashMap retMap = new HashMap();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        for (String bgCtrlSchemeId : schemeOrgMap.keySet()) {
            BgControlSchemeInfo info = (BgControlSchemeInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(bgCtrlSchemeId), sic);
            Object ousObj = schemeOrgMap.get(bgCtrlSchemeId);
            if (ousObj == null || !(ousObj instanceof Map) || ((Map)ousObj).isEmpty()) continue;
            String number = info.getNumber();
            String name = info.getName();
            Map ous = (Map)ousObj;
            HashMap<Object, Object> ccMap = new HashMap<Object, Object>();
            for (DefaultKingdeeTreeNode node : ous.keySet()) {
                OrgStructureInfo org = (OrgStructureInfo)node.getUserObject();
                CostCenterOrgUnitInfo cc = (CostCenterOrgUnitInfo)CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getValue(" select id,name where longnumber = '" + org.getLongNumber() + "'");
                boolean hasa = this.checkNumber(ctx, number, cc.getId().toString(), bgCtrlSchemeId);
                if (!hasa) continue;
                ccMap.put(cc.get("name"), null);
            }
            retMap.put(number, ccMap);
        }
        return retMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkNumber(Context ctx, String number, String costCenterId, String bgSchemeId) throws BgException, BOSException {
        ResultSet rst;
        PreparedStatement sta;
        Connection con;
        block5: {
            boolean bl;
            con = null;
            sta = null;
            rst = null;
            StringBuffer SQL = new StringBuffer();
            SQL.append(" select fnumber ");
            SQL.append("   from T_BG_BgControlScheme");
            SQL.append("  where FNumber = ? ");
            SQL.append("    and FCostCenterId = ? ");
            SQL.append("    and FParentId <> ?");
            try {
                con = this.getConnection(ctx);
                sta = con.prepareStatement(SQL.toString());
                sta.setString(1, number);
                sta.setString(2, costCenterId);
                sta.setString(3, bgSchemeId);
                rst = sta.executeQuery();
                if (!rst.next()) break block5;
                bl = true;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                    catch (BOSException ex2) {
                        logger.error((Object)ex2.getMessage());
                        throw ex2;
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, sta, (Connection)con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)sta, (Connection)con);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)sta, (Connection)con);
        return false;
    }

    @Override
    protected Map _assignCtrlSchemes(Context ctx, Map schemeOrgMap, boolean isNotAllowChangeState, boolean isNotAllowUpdate) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("rules.*"));
        sic.add(new SelectorItemInfo("periodMap.*"));
        sic.add(new SelectorItemInfo("multiRule.*"));
        sic.add(new SelectorItemInfo("multiRule.entry.*"));
        IBgControlScheme iBgCtrlScheme = BgControlSchemeFactory.getLocalInstance(ctx);
        String orgLongNum = null;
        ArrayList<String> orgLongNums = new ArrayList<String>();
        HashSet<String> schemeIdSet = new HashSet<String>();
        HashMap<String, String> orgMap = new HashMap<String, String>();
        String schemeId2 = null;
        for (String schemeId2 : schemeOrgMap.keySet()) {
            schemeIdSet.add(schemeId2);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", schemeIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        BgControlSchemeCollection schemeCol = iBgCtrlScheme.getBgControlSchemeCollection(view);
        IORMappingDAO dao = null;
        BgControlSchemeCollection col = null;
        BgControlSchemeInfo cloneInfo = null;
        Object ousObj = null;
        BgControlSchemeInfo info = null;
        Map ous = null;
        DefaultKingdeeTreeNode node2 = null;
        OrgStructureInfo org = null;
        String bgCtrlSchemeId = null;
        Connection conn = null;
        PreparedStatement ps = null;
        IRowSet rs = null;
        ResultSet res = null;
        try {
            conn = this.getConnection(ctx);
            for (int index = 0; index < schemeCol.size(); ++index) {
                int i;
                StringBuffer sql;
                info = schemeCol.get(index);
                bgCtrlSchemeId = info.getId().toString();
                ousObj = schemeOrgMap.get(bgCtrlSchemeId);
                if (ousObj == null || !(ousObj instanceof Map) || ((Map)ousObj).isEmpty()) continue;
                ous = ousObj;
                for (DefaultKingdeeTreeNode node2 : ous.keySet()) {
                    org = (OrgStructureInfo)node2.getUserObject();
                    orgLongNums.add(org.getLongNumber());
                }
                SQLUtils.cleanup(rs, ps);
                if (!orgLongNums.isEmpty()) {
                    int batchNum = 500;
                    int size = orgLongNums.size();
                    int count = (size - 1) / batchNum + 1;
                    int pos = 0;
                    sql = new StringBuffer();
                    sql.append("select flongNumber, fid from t_org_costCenter where flongNumber in (");
                    for (i = 0; i < batchNum; ++i) {
                        if (i != batchNum - 1) {
                            sql.append("?,");
                            continue;
                        }
                        sql.append("?)");
                    }
                    ps = conn.prepareStatement(sql.toString());
                    for (index = 0; index < count; ++index) {
                        int k = 1;
                        while (k <= batchNum) {
                            if (pos < size) {
                                ps.setString(k, (String)orgLongNums.get(pos));
                            } else {
                                ps.setString(k, "#");
                            }
                            ++k;
                            ++pos;
                        }
                        res = ps.executeQuery();
                        while (res.next()) {
                            orgMap.put(res.getString(1), res.getString(2));
                        }
                    }
                }
                SQLUtils.cleanup(res, ps);
                col = new BgControlSchemeCollection();
                ArrayList<String> orgIds = new ArrayList<String>();
                String orgUnitId = null;
                FullOrgUnitInfo _cc = null;
                BgControlSchemeInfo tmpInfo = this.cloneInfo(info);
                for (DefaultKingdeeTreeNode node2 : ous.keySet()) {
                    org = (OrgStructureInfo)node2.getUserObject();
                    orgLongNum = org.getLongNumber();
                    cloneInfo = (BgControlSchemeInfo)tmpInfo.clone();
                    cloneInfo.setIsAssigned(true);
                    cloneInfo.setIsNotAllowChangeState(isNotAllowChangeState);
                    cloneInfo.setIsNotAllowUpdate(isNotAllowUpdate);
                    cloneInfo.setRoot(info);
                    cloneInfo.setParent(info);
                    _cc = new FullOrgUnitInfo();
                    orgUnitId = (String)orgMap.get(orgLongNum);
                    orgIds.add(orgUnitId);
                    _cc.setId(BOSUuid.read((String)orgUnitId));
                    cloneInfo.setCostCenter(_cc);
                    col.add(cloneInfo);
                }
                this.dealCtrlSchemeState(ctx, col);
                this.deleteAssignedCtrlScheme(ctx, info.getId().toString(), orgIds, info.getBoName(), info.getNumber());
                if (col.size() > 0) {
                    int batchSize = 50;
                    int idx = 0;
                    dao = ORMappingDAO.getInstance((BOSObjectType)info.getBOSType(), (Context)ctx, (Connection)conn);
                    for (int i2 = 0; i2 < col.size(); ++i2) {
                        dao.addNewBatch((IObjectValue)col.get(i2));
                        if (++idx <= batchSize) continue;
                        dao.executeBatch();
                        idx = 0;
                    }
                    if (idx != 0) {
                        dao.executeBatch();
                        idx = 0;
                    }
                }
                sql = new StringBuffer();
                sql.append("select fid from t_bg_bgcontrolscheme where frootid = '" + bgCtrlSchemeId + "'");
                sql.append(" and fcostcenterid in (");
                for (i = 0; i < col.size(); ++i) {
                    if (i == col.size() - 1) {
                        sql.append("'").append(col.get(i).getCostCenter().getId().toString()).append("'").append(")");
                        continue;
                    }
                    sql.append("'").append(col.get(i).getCostCenter().getId().toString()).append("'").append(",");
                }
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                ArrayList<String> childSchemeIDList = new ArrayList<String>();
                while (rs.next()) {
                    childSchemeIDList.add(rs.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rs);
                StringBuffer sb = new StringBuffer();
                sb.append("insert into t_bg_bgcontrolitemmap(fid, fbgctrlschemeid, fbillfieldcombinvalue, fbillfieldcombinalias, ");
                sb.append("fbillitemcombinvalue, fbillitemcombinalias, fbgitemcombinid,FBgItemCombinKey, fbgitemcombinalias) ");
                sb.append("select newbosid('07404752'), ?, fbillfieldcombinvalue, fbillfieldcombinalias, ");
                sb.append("fbillitemcombinvalue, fbillitemcombinalias, fbgitemcombinid,FBgItemCombinKey, fbgitemcombinalias from t_bg_bgcontrolitemmap ");
                sb.append("where fbgctrlschemeid = ?");
                ps = conn.prepareStatement(sb.toString());
                int _index = 0;
                int batchNum = 10;
                int size = childSchemeIDList.size();
                int count = (size - 1) / batchNum + 1;
                int pos = 0;
                for (_index = 0; _index < count; ++_index) {
                    for (int k = 0; k < batchNum && pos < size; ++k, ++pos) {
                        ps.setString(1, (String)childSchemeIDList.get(pos));
                        ps.setString(2, bgCtrlSchemeId);
                        ps.addBatch();
                    }
                    ps.executeBatch();
                }
                SQLUtils.cleanup((Statement)ps);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, ps, (Connection)conn);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dealCtrlSchemeState(Context ctx, BgControlSchemeCollection col) throws BgException, BOSException {
        if (col == null) return;
        if (col.isEmpty()) {
            return;
        }
        Connection con = null;
        PreparedStatement sta = null;
        StringBuffer SQL = new StringBuffer();
        BgControlSchemeInfo info = null;
        SQL.append(" update T_BG_BgControlScheme ");
        SQL.append("    set FIsValid = 0 ");
        SQL.append("  where FIsValid = 1 ");
        SQL.append("    and FBoName = ? ");
        SQL.append("    and FCostCenterId = ? ");
        try {
            con = this.getConnection(ctx);
            sta = con.prepareStatement(SQL.toString());
            for (int i = 0; i < col.size(); ++i) {
                info = col.get(i);
                if (!info.isIsValid()) continue;
                sta.setString(1, info.getBoName());
                sta.setString(2, info.getCostCenter().getId().toString());
                sta.addBatch();
            }
            sta.executeBatch();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    logger.error((Object)ex2.getMessage());
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sta, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sta, (Connection)con);
    }

    @Override
    protected Map _assign(Context ctx, Map bgCtrlSchemes, Map ous, boolean isNotAllowChangeState) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("rules.*"));
        sic.add(new SelectorItemInfo("itemMap.*"));
        sic.add(new SelectorItemInfo("periodMap.*"));
        sic.add(new SelectorItemInfo("multiRule.*"));
        IBgControlScheme iBgCtrlScheme = BgControlSchemeFactory.getLocalInstance(ctx);
        for (String bgCtrlSchemeId : bgCtrlSchemes.keySet()) {
            BgControlSchemeInfo info = (BgControlSchemeInfo)iBgCtrlScheme.getValue((IObjectPK)new ObjectUuidPK(bgCtrlSchemeId), sic);
            for (DefaultKingdeeTreeNode node : ous.keySet()) {
                OrgStructureInfo org = (OrgStructureInfo)node.getUserObject();
                BgControlSchemeInfo cloneInfo = this.cloneInfo(info);
                cloneInfo.setIsAssigned(true);
                cloneInfo.setIsNotAllowChangeState(isNotAllowChangeState);
                cloneInfo.setRoot(info);
                cloneInfo.setParent(info);
                FullOrgUnitInfo cc = (FullOrgUnitInfo)FullOrgUnitFactory.getLocalInstance((Context)ctx).getValue(" select id where longnumber = '" + org.getLongNumber() + "'");
                cc.setId(BOSUuid.read((String)cc.getId().toString()));
                cloneInfo.setCostCenter(cc);
                this.dealCtrlSchemeState(ctx, info.getBoName(), cloneInfo.getCostCenter().getId().toString(), cloneInfo.isIsValid());
                this.deleteAssignedCtrlScheme(ctx, info.getId().toString(), cloneInfo.getCostCenter().getId().toString(), cloneInfo.getBoName(), cloneInfo.getNumber());
                iBgCtrlScheme.addnew((CoreBaseInfo)cloneInfo);
            }
        }
        return null;
    }

    private BgControlSchemeInfo cloneInfo(BgControlSchemeInfo info) {
        BgControlSchemeInfo _info = (BgControlSchemeInfo)info.clone();
        _info.remove("id");
        BgControlRuleCollection _ruleCol = new BgControlRuleCollection();
        for (int r = 0; r < info.getRules().size() && info.getRules().get(r) != null; ++r) {
            BgControlRuleInfo ruleInfo = info.getRules().get(r);
            BgControlRuleInfo _ruleInfo = new BgControlRuleInfo();
            _ruleInfo.setOqlOrgUnit(ruleInfo.getOqlOrgUnit());
            _ruleInfo.setAliasOrgUnit(ruleInfo.getAliasOrgUnit());
            _ruleInfo.setOqlItemCombination(ruleInfo.getOqlItemCombination());
            _ruleInfo.setAliasItemCombination(ruleInfo.getAliasItemCombination());
            _ruleInfo.setOqlPeriod(ruleInfo.getOqlPeriod());
            _ruleInfo.setAliasPeriod(ruleInfo.getAliasPeriod());
            _ruleInfo.setOqlCurrency(ruleInfo.getOqlCurrency());
            _ruleInfo.setAliasCurrency(ruleInfo.getAliasCurrency());
            _ruleInfo.setOqlActual(ruleInfo.getOqlActual());
            _ruleInfo.setAliasActual(ruleInfo.getAliasActual());
            _ruleInfo.setElementNumber(ruleInfo.getElementNumber());
            _ruleInfo.setPeriodCycle(ruleInfo.getPeriodCycle());
            _ruleInfo.setPackageName(ruleInfo.getPackageName());
            _ruleInfo.setBillName(ruleInfo.getBillName());
            _ruleInfo.setPackageAlias(ruleInfo.getPackageAlias());
            _ruleInfo.setBillAlias(ruleInfo.getBillAlias());
            _ruleInfo.setIsEnable(ruleInfo.isIsEnable());
            _ruleInfo.setIsAllowExcess(ruleInfo.isIsAllowExcess());
            _ruleInfo.setOqlBizDate(ruleInfo.getOqlBizDate());
            _ruleInfo.setAliasBizDate(ruleInfo.getAliasBizDate());
            _ruleInfo.setOqlRequest(ruleInfo.getOqlRequest());
            _ruleInfo.setAliasRequest(ruleInfo.getAliasRequest());
            _ruleInfo.setOqlRequestExtendExpression(ruleInfo.getOqlRequestExtendExpression());
            _ruleInfo.setCustomBgPeriodNumber(ruleInfo.getCustomBgPeriodNumber());
            _ruleInfo.setOqlRuleCondition(ruleInfo.getOqlRuleCondition());
            _ruleInfo.setAliasRuleCondition(ruleInfo.getAliasRuleCondition());
            _ruleInfo.setName(ruleInfo.getName());
            _ruleInfo.setNumber(ruleInfo.getNumber());
            _ruleInfo.setDescription(ruleInfo.getDescription());
            _ruleInfo.remove("id");
            _ruleInfo.remove("bgCtrlScheme");
            _ruleCol.add(_ruleInfo);
        }
        _info.getRules().clear();
        _info.getRules().addCollection(_ruleCol);
        _info.getItemMap().clear();
        BgControlPeriodMapCollection _periodMapCol = new BgControlPeriodMapCollection();
        for (int t = 0; t < info.getPeriodMap().size() && info.getPeriodMap().get(t) != null; ++t) {
            BgControlPeriodMapInfo periodMapInfo = info.getPeriodMap().get(t);
            BgControlPeriodMapInfo _periodMapInfo = new BgControlPeriodMapInfo();
            _periodMapInfo.setBizBeginPeriod(periodMapInfo.getBizBeginPeriod());
            _periodMapInfo.setBizEndPeriod(periodMapInfo.getBizEndPeriod());
            _periodMapInfo.setBgPeriod(periodMapInfo.getBgPeriod());
            _periodMapInfo.remove("id");
            _periodMapInfo.remove("bgCtrlScheme");
            _periodMapCol.add(_periodMapInfo);
        }
        _info.getPeriodMap().clear();
        _info.getPeriodMap().addCollection(_periodMapCol);
        BgControlMultiRuleCollection _multiRuleCol = new BgControlMultiRuleCollection();
        for (int u = 0; u < info.getMultiRule().size() && info.getMultiRule().get(u) != null; ++u) {
            BgControlMultiRuleInfo multiRuleInfo = info.getMultiRule().get(u);
            BgControlMultiRuleInfo _multiRuleInfo = new BgControlMultiRuleInfo();
            _multiRuleInfo.setBizItemCombinId(multiRuleInfo.getBizItemCombinId());
            _multiRuleInfo.setBizItemCombinNumber(multiRuleInfo.getBizItemCombinNumber());
            _multiRuleInfo.setBizItemCombinAlias(multiRuleInfo.getBizItemCombinAlias());
            _multiRuleInfo.setCtrlItemCombinId(multiRuleInfo.getCtrlItemCombinId());
            _multiRuleInfo.setCtrlItemCombinNumber(multiRuleInfo.getCtrlItemCombinNumber());
            _multiRuleInfo.setCtrlItemCombinAlias(multiRuleInfo.getCtrlItemCombinAlias());
            _multiRuleInfo.setCtrlCoe(multiRuleInfo.getCtrlCoe());
            _multiRuleInfo.setCtrlRule(multiRuleInfo.getCtrlRule());
            _multiRuleInfo.setCtrlValue(multiRuleInfo.getCtrlValue());
            _multiRuleInfo.setIsGroupCheck(multiRuleInfo.isIsGroupCheck());
            _multiRuleInfo.remove("id");
            _multiRuleInfo.remove("bgCtrlScheme");
            _multiRuleInfo.getEntry().clear();
            for (int meIndex = 0; meIndex < multiRuleInfo.getEntry().size(); ++meIndex) {
                BgCtrlMultiRuleEntryInfo newCtrlEntry = new BgCtrlMultiRuleEntryInfo();
                BgCtrlMultiRuleEntryInfo oldCtrlEntry = multiRuleInfo.getEntry().get(meIndex);
                newCtrlEntry.setId(null);
                newCtrlEntry.setParent(_multiRuleInfo);
                newCtrlEntry.setControllProcess(oldCtrlEntry.getControllProcess());
                newCtrlEntry.setCtrlCoe(oldCtrlEntry.getCtrlCoe());
                newCtrlEntry.setSeq(oldCtrlEntry.getSeq());
                _multiRuleInfo.getEntry().add(newCtrlEntry);
            }
            _multiRuleCol.add(_multiRuleInfo);
        }
        _info.getMultiRule().clear();
        _info.getMultiRule().addCollection(_multiRuleCol);
        return _info;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dealCtrlSchemeState(Context ctx, String boName, String costCenterId, boolean state) throws BgException, BOSException {
        if (!state) {
            return;
        }
        Connection con = null;
        PreparedStatement sta = null;
        StringBuffer SQL = new StringBuffer();
        SQL.append(" update T_BG_BgControlScheme ");
        SQL.append("    set FIsValid = 0 ");
        SQL.append("  where FIsValid = 1 ");
        SQL.append("    and FBoName = ? ");
        SQL.append("    and FCostCenterId = ? ");
        try {
            con = this.getConnection(ctx);
            sta = con.prepareStatement(SQL.toString());
            sta.setString(1, boName);
            sta.setString(2, costCenterId);
            sta.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    logger.error((Object)ex2.getMessage());
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sta, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sta, (Connection)con);
    }

    private void deleteAssignedCtrlScheme(Context ctx, String rootId, String costCenterId, String boName, String ctrlSchemeNumber) throws BOSException, EASBizException {
        IRowSet ret = DbUtil.executeQuery((Context)ctx, (String)" select FId from T_BG_BgControlScheme  where FIsAssigned = 1 and FCostCenterId = ? and FBoName = ? and FRootId = ? and FId <> ? ", (Object[])new String[]{costCenterId, boName, rootId, rootId});
        IRowSet ret2 = DbUtil.executeQuery((Context)ctx, (String)" select FId from T_BG_BgControlScheme  where FCostCenterId = ? and FNumber = ? and FRootId <> ? and FId <> ? ", (Object[])new String[]{costCenterId, ctrlSchemeNumber, rootId, rootId});
        IBgControlScheme iCtrlScheme = BgControlSchemeFactory.getLocalInstance(ctx);
        try {
            String id;
            while (ret.next()) {
                id = ret.getString("FId");
                iCtrlScheme.delete((IObjectPK)new ObjectUuidPK(id));
            }
            while (ret2.next()) {
                id = ret2.getString("FId");
                ObjectUuidPK pk = new ObjectUuidPK(id);
                Vector combinIdVec = BgControlSchemeControllerBean.getBudgetItemMap(ctx, pk.toString());
                String sql1 = "delete from t_bg_bgControlItemMap where fbgctrlschemeid = ?";
                DbUtil.execute((Context)ctx, (String)sql1, (Object[])new Object[]{id});
                IRowSet row = DbUtil.executeQuery((Context)ctx, (String)"select fid from T_BG_BgControlScheme where frootid = ? and fid <> ?", (Object[])new String[]{id, id});
                while (row.next()) {
                    super._delete(ctx, (IObjectPK)new ObjectUuidPK(row.getString(1)));
                }
                super._delete(ctx, (IObjectPK)pk);
                BgTemplateHelper.deleteCombinItem(ctx, combinIdVec);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex.getMessage());
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (BOSException ex) {
            logger.error((Object)ex.getMessage());
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteAssignedCtrlScheme(Context ctx, String rootId, List orgIds, String boName, String number) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)rootId)) return;
        if (StringUtils.isEmpty((String)boName)) return;
        if (StringUtils.isEmpty((String)number)) {
            return;
        }
        if (orgIds == null) return;
        if (orgIds.size() == 0) {
            return;
        }
        int size = orgIds.size();
        if (size == 0) {
            return;
        }
        int batchNum = 300;
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        StringBuffer sql1 = new StringBuffer();
        sql1.append(" select FId from T_BG_BgControlScheme ");
        sql1.append(" where FIsAssigned = 1 and FBoName = ? and FRootId = ? and FId <> ? and FCostCenterId in (");
        for (int i = 1; i < batchNum; ++i) {
            sql1.append("?,");
        }
        sql1.append("?)");
        StringBuffer sql2 = new StringBuffer();
        sql2.append(" select FId from T_BG_BgControlScheme ");
        sql2.append(" where FNumber = ? and FRootId <> ? and FId <> ? and FCostCenterId in (");
        for (int i = 1; i < batchNum; ++i) {
            sql2.append("?,");
        }
        sql2.append("?)");
        StringBuffer sql3 = new StringBuffer();
        sql3.append("delete from T_BG_BgControlScheme where fid = ? ");
        StringBuffer sql4 = new StringBuffer();
        sql4.append("delete from t_bg_bgControlItemMap where fbgctrlschemeid = ? ");
        StringBuffer sql5 = new StringBuffer();
        sql5.append("delete from T_BG_BgControlScheme where fid in (select fid from T_BG_BgControlScheme where frootid = ? and fid <> frootid) ");
        PreparedStatement ps1 = null;
        PreparedStatement ps2 = null;
        PreparedStatement ps3 = null;
        PreparedStatement ps4 = null;
        PreparedStatement ps5 = null;
        Connection conn = null;
        ResultSet rst = null;
        ArrayList<String> toDelete = new ArrayList<String>();
        String id = null;
        try {
            int k;
            int index;
            conn = this.getConnection(ctx);
            ps1 = conn.prepareStatement(sql1.toString());
            ps1.setString(1, boName);
            ps1.setString(2, rootId);
            ps1.setString(3, rootId);
            pos = 0;
            for (index = 0; index < count; ++index) {
                for (k = 1; k <= batchNum; ++k, ++pos) {
                    if (pos < size) {
                        ps1.setString(k + 3, (String)orgIds.get(pos));
                        continue;
                    }
                    ps1.setString(k + 3, "#");
                }
                rst = ps1.executeQuery();
                while (rst.next()) {
                    toDelete.add(rst.getString(1));
                }
            }
            SQLUtils.cleanup(rst, (Statement)ps1);
            if (!toDelete.isEmpty()) {
                try {
                    int _index = 0;
                    ps3 = conn.prepareStatement(sql3.toString());
                    for (int i = 0; i < toDelete.size(); ++i) {
                        ps3.setString(1, (String)toDelete.get(i));
                        ps3.addBatch();
                        if (++_index != batchNum) continue;
                        ps3.executeBatch();
                        _index = 0;
                    }
                    if (_index != 0) {
                        ps3.executeBatch();
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps3);
                    throw throwable;
                }
                SQLUtils.cleanup((Statement)ps3);
            }
            ps2 = conn.prepareStatement(sql2.toString());
            ps2.setString(1, number);
            ps2.setString(2, rootId);
            ps2.setString(3, rootId);
            pos = 0;
            for (index = 0; index < count; ++index) {
                for (k = 1; k <= batchNum; ++k, ++pos) {
                    if (pos < size) {
                        ps2.setString(k + 3, (String)orgIds.get(pos));
                        continue;
                    }
                    ps2.setString(k + 3, "#");
                }
                rst = ps2.executeQuery();
                while (rst.next()) {
                    toDelete.add(rst.getString(1));
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)ps2);
            if (!toDelete.isEmpty()) {
                int i;
                Vector combinIdVec = this.batchGetBudgetItemMap(ctx, toDelete);
                ps4 = conn.prepareStatement(sql4.toString());
                int _index = 0;
                for (i = 0; i < toDelete.size(); ++i) {
                    id = (String)toDelete.get(i);
                    ps4.setString(1, id);
                    ps4.addBatch();
                    if (++_index != batchNum) continue;
                    ps4.executeBatch();
                    _index = 0;
                }
                if (_index != 0) {
                    ps4.executeBatch();
                }
                SQLUtils.cleanup((Statement)ps4);
                ps5 = conn.prepareStatement(sql5.toString());
                _index = 0;
                for (i = 0; i < toDelete.size(); ++i) {
                    id = (String)toDelete.get(i);
                    ps5.setString(1, id);
                    ps5.addBatch();
                    if (++_index != batchNum) continue;
                    ps5.executeBatch();
                    _index = 0;
                }
                if (_index != 0) {
                    ps5.executeBatch();
                }
                SQLUtils.cleanup((Statement)ps5);
                ps3 = conn.prepareStatement(sql3.toString());
                _index = 0;
                for (i = 0; i < toDelete.size(); ++i) {
                    id = (String)toDelete.get(i);
                    ps3.setString(1, id);
                    ps3.addBatch();
                    if (++_index != batchNum) continue;
                    ps5.executeBatch();
                    _index = 0;
                }
                if (_index != 0) {
                    ps3.executeBatch();
                }
                SQLUtils.cleanup((Statement)ps3);
                BgTemplateHelper.deleteCombinItem(ctx, combinIdVec);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    logger.error((Object)ex2.getMessage());
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                SQLUtils.cleanup(ps1);
                SQLUtils.cleanup(ps2);
                SQLUtils.cleanup(ps3);
                SQLUtils.cleanup(ps4);
                SQLUtils.cleanup(ps5);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        SQLUtils.cleanup((Statement)ps1);
        SQLUtils.cleanup((Statement)ps2);
        SQLUtils.cleanup((Statement)ps3);
        SQLUtils.cleanup((Statement)ps4);
        SQLUtils.cleanup(ps5);
        SQLUtils.cleanup((Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector batchGetBudgetItemMap(Context ctx, List idList) throws BgSchemeAssignException {
        Vector<String> idVec = new Vector<String>();
        if (idList == null) return idVec;
        if (idList.isEmpty()) {
            return idVec;
        }
        int size = idList.size();
        int batchSize = 100;
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct FBgItemCombinId  from t_bg_bgControlItemMap where fbgctrlschemeid in (");
        for (int i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < count; ++i) {
                for (int j = 1; j <= batchSize; ++j, ++pos) {
                    if (pos < size) {
                        pstmt.setString(j, (String)idList.get(pos));
                        continue;
                    }
                    pstmt.setString(j, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    idVec.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (BOSException e) {
            try {
                throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
                catch (SQLException e2) {
                    throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return idVec;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _updateChidrenState(Context ctx, String rootId, boolean state) throws BOSException, EASBizException {
        if (!state) {
            DbUtil.execute((Context)ctx, (String)" update T_BG_BgControlScheme set FIsValid = 0 where FIsAssigned = 1 and FRootId = ? and FId <> ? ", (Object[])new String[]{rootId, rootId});
            return true;
        }
        IRowSet ret = null;
        try {
            ret = DbUtil.executeQuery((Context)ctx, (String)" select FId, FBoName,FCostCenterId from T_BG_BgControlScheme where FIsAssigned = 1 and FRootId = ? and FId <> ? ", (Object[])new String[]{rootId, rootId});
            while (ret.next()) {
                String id = ret.getString("FID");
                String boName = ret.getString("FBoName");
                String costCenterId = ret.getString("FCostCenterId");
                DbUtil.execute((Context)ctx, (String)" update T_BG_BgControlScheme set FIsValid = 0 where FIsValid = 1 and FBoName = ? and FCostCenterId = ? and FId <> ? ", (Object[])new String[]{boName, costCenterId, id});
            }
            DbUtil.execute((Context)ctx, (String)" update T_BG_BgControlScheme set FIsValid = 1 where FIsAssigned = 1 and FRootId = ? and FId <> ? ", (Object[])new String[]{rootId, rootId});
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    logger.error((Object)ex2.getMessage());
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ret);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)ret);
        return true;
    }

    @Override
    protected void _checkCanUpdate(Context ctx, String id, String oprt) throws BOSException, EASBizException {
        BgControlSchemeInfo bgCtrlSchemeInfo = (BgControlSchemeInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(id), this.getSelector());
        if (bgCtrlSchemeInfo.isIsAssigned() && bgCtrlSchemeInfo.isIsNotAllowUpdate()) {
            throw new BgControlException(BgControlException.ASSIGENNOTALLOWUPDATE);
        }
    }
}

