/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgCtrlRecordInfo;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgTraceTypeEnum;
import com.kingdee.eas.ma.budget.app.AbstractBgCtrlRecordControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgCtrlRecordControllerBean
extends AbstractBgCtrlRecordControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgCtrlRecordControllerBean");

    @Override
    protected void _record(Context ctx, IObjectCollection ctrlRstColl) throws BOSException, EASBizException {
        if (ctrlRstColl != null && ctrlRstColl.size() > 0) {
            BgCtrlResultCollection bgCtrlRstColl = (BgCtrlResultCollection)ctrlRstColl;
            for (int i = 0; i < bgCtrlRstColl.size(); ++i) {
                BgCtrlResultInfo bgCtrlRstInfo = bgCtrlRstColl.get(i);
                if (bgCtrlRstInfo.getBgDataId() == null || bgCtrlRstInfo.getBillId() == null) continue;
                BgCtrlRecordInfo bgCtrlRecordInfo = new BgCtrlRecordInfo();
                bgCtrlRecordInfo.setBgDataId(bgCtrlRstInfo.getBgDataId());
                if (bgCtrlRstInfo.getReqAmount() != null && bgCtrlRstInfo.getReqAmount().floatValue() == 0.0f) continue;
                bgCtrlRecordInfo.setActualAmount(bgCtrlRstInfo.getReqAmount());
                bgCtrlRecordInfo.setBillId(bgCtrlRstInfo.getBillId());
                bgCtrlRecordInfo.setBillName(bgCtrlRstInfo.getBillName());
                bgCtrlRecordInfo.setBillNumber(bgCtrlRstInfo.getBillNumber());
                bgCtrlRecordInfo.setBillType(bgCtrlRstInfo.getBillType());
                bgCtrlRecordInfo.setBizDate(bgCtrlRstInfo.getBizDate());
                bgCtrlRecordInfo.setBgPeriodId(bgCtrlRstInfo.getBgPeriodNumber());
                bgCtrlRecordInfo.setItemName(bgCtrlRstInfo.getItemName());
                bgCtrlRecordInfo.setBgTraceType(BgTraceTypeEnum.Bill);
                bgCtrlRecordInfo.setDayDate(bgCtrlRstInfo.getBizDate());
                this._addnew(ctx, (IObjectValue)bgCtrlRecordInfo);
            }
        }
    }

    @Override
    protected void _cancel(Context ctx, String billId) throws BOSException, EASBizException {
        this.deduceActualAmount(ctx, billId);
        this.deleteCtrlRecord(ctx, billId);
        this.deduceUpperOrgAndUpperItemData(ctx, billId);
    }

    private void deduceActualAmount(Context ctx, String billId) throws BOSException, EASBizException {
        String sqlStr = "select fbgdataid,factualAmount from t_bg_bgctrlrecord where fbillid=? and fbgtracetype <> 4";
        String updateSql = "update t_bg_bgdata set FBizActual=FBizActual-? WHERE fid=? ";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Vector<Object[]> vec = new Vector<Object[]>();
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sqlStr);
            ps.setString(1, billId);
            rs = ps.executeQuery();
            while (rs.next()) {
                Object[] obj = new Object[]{rs.getString(1), rs.getBigDecimal(2)};
                vec.add(obj);
            }
            ps = conn.prepareStatement(updateSql);
            for (int i = 0; i < vec.size(); ++i) {
                Object[] obj = (Object[])vec.get(i);
                ps.setBigDecimal(1, (BigDecimal)obj[1]);
                ps.setString(2, (String)obj[0]);
                ps.addBatch();
            }
            if (!vec.isEmpty()) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
    }

    private void deduceUpperOrgAndUpperItemData(Context ctx, String billId) throws BOSException, EASBizException {
        if (billId == null || billId.length() == 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement queryDetailRecordSta = null;
        ResultSet queryDetailRecordRet = null;
        String queryDetailRecordSQL = "select Fid,FBgCtrlRecordId,FActualAmount from T_BG_BgCtrlRecordSumDetail where FBillId = ? ";
        PreparedStatement queryDetailRecordCountSta = null;
        ResultSet queryDetailRecordCountRet = null;
        String queryDetailRecordCountSQL = "select count(*) from T_BG_BgCtrlRecordSumDetail where FBgCtrlRecordId = ? ";
        PreparedStatement deleteDetailRecordSta = null;
        String deleteDetailRecordSQL = "delete T_BG_BgCtrlRecordSumDetail where fid = ? ";
        boolean commitDeleteDetailRecord = false;
        PreparedStatement queryRecordSta = null;
        ResultSet queryRecordRet = null;
        String queryRecordSQL = "select fbgdataid,factualAmount from t_bg_bgctrlrecord where fid = ? ";
        PreparedStatement updateRecordSta = null;
        String updateRecordSQL = " update t_bg_bgctrlrecord set factualAmount=factualAmount - ? WHERE fid = ?";
        boolean commitUpdateRecord = false;
        PreparedStatement deleteRecordSta = null;
        String deleteRecordSQL = " delete t_bg_bgctrlrecord where Fid = ? ";
        boolean commitDeleteRecord = false;
        PreparedStatement updateBgDataSta = null;
        String updateBgDataSQL = "update t_bg_bgdata set FBizActual=FBizActual - ? WHERE fid = ? ";
        boolean commitUpdateBgData = false;
        try {
            conn = this.getConnection(ctx);
            queryDetailRecordSta = conn.prepareStatement(queryDetailRecordSQL);
            queryDetailRecordCountSta = conn.prepareStatement(queryDetailRecordCountSQL);
            deleteDetailRecordSta = conn.prepareStatement(deleteDetailRecordSQL);
            deleteRecordSta = conn.prepareStatement(deleteRecordSQL);
            updateRecordSta = conn.prepareStatement(updateRecordSQL);
            queryRecordSta = conn.prepareStatement(queryRecordSQL);
            updateBgDataSta = conn.prepareStatement(updateBgDataSQL);
            queryDetailRecordSta.setString(1, billId);
            queryDetailRecordRet = queryDetailRecordSta.executeQuery();
            while (queryDetailRecordRet.next()) {
                String detailId = queryDetailRecordRet.getString("Fid");
                String bgCtrlRecordId = queryDetailRecordRet.getString("FBgCtrlRecordId");
                BigDecimal actualAmount = queryDetailRecordRet.getBigDecimal("FActualAmount");
                int detailRecordCount = 0;
                queryDetailRecordCountSta.setString(1, bgCtrlRecordId);
                queryDetailRecordCountRet = queryDetailRecordCountSta.executeQuery();
                queryDetailRecordCountRet.next();
                detailRecordCount = queryDetailRecordCountRet.getInt(1);
                deleteDetailRecordSta.setString(1, detailId);
                deleteDetailRecordSta.addBatch();
                if (!commitDeleteDetailRecord) {
                    commitDeleteDetailRecord = true;
                }
                if (detailRecordCount == 1) {
                    deleteRecordSta.setString(1, bgCtrlRecordId);
                    deleteRecordSta.addBatch();
                    if (!commitDeleteRecord) {
                        commitDeleteRecord = true;
                    }
                } else {
                    updateRecordSta.setBigDecimal(1, actualAmount);
                    updateRecordSta.setString(2, bgCtrlRecordId);
                    updateRecordSta.addBatch();
                    if (!commitUpdateRecord) {
                        commitUpdateRecord = true;
                    }
                }
                queryRecordSta.setString(1, bgCtrlRecordId);
                queryRecordRet = queryRecordSta.executeQuery();
                String bgDataId = null;
                if (!queryRecordRet.next()) continue;
                bgDataId = queryRecordRet.getString("fbgdataid");
                updateBgDataSta.setBigDecimal(1, actualAmount);
                updateBgDataSta.setString(2, bgDataId);
                updateBgDataSta.addBatch();
                if (commitUpdateBgData) continue;
                commitUpdateBgData = true;
            }
            if (commitDeleteDetailRecord) {
                deleteDetailRecordSta.executeBatch();
            }
            if (commitUpdateRecord) {
                updateRecordSta.executeBatch();
            }
            if (commitDeleteRecord) {
                deleteRecordSta.executeBatch();
            }
            if (commitUpdateBgData) {
                updateBgDataSta.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(queryDetailRecordRet, queryDetailRecordSta, (Connection)conn);
                SQLUtils.cleanup(queryDetailRecordCountRet, queryDetailRecordCountSta, (Connection)conn);
                SQLUtils.cleanup(deleteDetailRecordSta, (Connection)conn);
                SQLUtils.cleanup(queryRecordRet, queryRecordSta, (Connection)conn);
                SQLUtils.cleanup(updateRecordSta, (Connection)conn);
                SQLUtils.cleanup((Statement)deleteRecordSta, (Connection)conn);
                SQLUtils.cleanup(updateBgDataSta, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)queryDetailRecordRet, (Statement)queryDetailRecordSta, (Connection)conn);
        SQLUtils.cleanup(queryDetailRecordCountRet, (Statement)queryDetailRecordCountSta, (Connection)conn);
        SQLUtils.cleanup((Statement)deleteDetailRecordSta, (Connection)conn);
        SQLUtils.cleanup(queryRecordRet, (Statement)queryRecordSta, (Connection)conn);
        SQLUtils.cleanup((Statement)updateRecordSta, (Connection)conn);
        SQLUtils.cleanup((Statement)deleteRecordSta, (Connection)conn);
        SQLUtils.cleanup((Statement)updateBgDataSta, (Connection)conn);
    }

    private void deleteCtrlRecord(Context ctx, String billId) throws BOSException, EASBizException {
        String sqlStr = "DELETE t_bg_bgctrlrecord WHERE FBillId=? and fbgtracetype <> 4";
        DbUtil.execute((Context)ctx, (String)sqlStr, (Object[])new Object[]{billId});
    }

    @Override
    protected void _addNewColl(Context ctx, IObjectCollection coll) throws BOSException, EASBizException {
        String sql = "insert into t_bg_bgctrlrecord(FID,FCreatorID,FCreateTime,FLastUpdateUserID, FLastUpdateTime,FControlUnitID,FBgDataId,FBillId,FBillName,FBillNumber,FBillAlias, FBillType,FBizDate,FActualAmount,FBillOperate,FBgPeriodId,FItemName,fbgtracetype,FDayDate,FBillSourceOrgUnitId) values( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            BgCtrlRecordInfo info = null;
            for (int i = 0; i < coll.size(); ++i) {
                info = (BgCtrlRecordInfo)coll.getObject(i);
                String id = info.getId() == null ? BOSUuid.create((BOSObjectType)info.getBOSType()).toString() : info.getId().toString();
                ps.setString(1, id);
                String creatorId = info.getCreator() == null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : info.getCreator().getId().toString();
                ps.setString(2, creatorId);
                Timestamp createTime = info.getCreateTime() == null ? new Timestamp(System.currentTimeMillis()) : info.getCreateTime();
                ps.setTimestamp(3, createTime);
                String updatorId = info.getLastUpdateUser() == null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : info.getLastUpdateUser().getId().toString();
                ps.setString(4, updatorId);
                Timestamp updateTime = info.getLastUpdateTime() == null ? new Timestamp(System.currentTimeMillis()) : info.getLastUpdateTime();
                ps.setTimestamp(5, updateTime);
                String cuId = info.getCU() == null ? ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() : info.getCU().getId().toString();
                ps.setString(6, cuId);
                String bgDataId = info.getBgDataId();
                ps.setString(7, bgDataId);
                String billId = info.getBillId();
                ps.setString(8, billId);
                String billName = info.getBillName() == null ? "" : info.getBillName();
                ps.setString(9, billName);
                String billNumber = info.getBillNumber() == null ? "" : info.getBillNumber();
                ps.setString(10, billNumber);
                String billAlias = info.getBillAlias() == null ? "" : info.getBillAlias();
                ps.setString(11, billAlias);
                String billType = info.getBillType() == null ? "" : info.getBillType();
                ps.setString(12, billType);
                Timestamp bizTime = info.getBizDate() == null ? new Timestamp(System.currentTimeMillis()) : new Timestamp(info.getBizDate().getTime());
                ps.setTimestamp(13, bizTime);
                BigDecimal amount = info.getActualAmount() == null ? new BigDecimal("0.00") : info.getActualAmount();
                ps.setBigDecimal(14, amount);
                String billOperate = info.getBillOperate() == null ? "" : info.getBillOperate();
                ps.setString(15, billOperate);
                String bgPeriodId = info.getBgPeriodId() == null ? "" : info.getBgPeriodId();
                ps.setString(16, bgPeriodId);
                String itemName = info.getItemName() == null ? "" : info.getItemName();
                ps.setString(17, itemName);
                ps.setInt(18, info.getBgTraceType() == null ? 3 : info.getBgTraceType().getValue());
                Timestamp dayTime = info.getDayDate() == null ? null : new Timestamp(info.getDayDate().getTime());
                ps.setTimestamp(19, dayTime);
                ps.setString(20, info.getBillSourceOrgunitID());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }
}

