/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class BgDbBatchUtil {
    private static Logger logger = Logger.getLogger(BgDbBatchUtil.class);
    public static final int BATCH_SIZE = 200;
    private static final Object NOT_FOUND_VALUE = "#";

    public static void batchExecuteQuery(Context ctx, String sql, List params, CallbackHandler handler) throws BOSException {
        if (StringUtil.isEmptyString((String)sql) || handler == null || params == null || params.isEmpty()) {
            return;
        }
        Object obj = params.get(0);
        if (!(obj instanceof Object[])) {
            throw new IllegalArgumentException("the params.get(i) must be a Object[] type!");
        }
        if (((Object[])obj).length == 0) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int columnSize = ((Object[])obj).length;
        int size = params.size() * columnSize;
        int count = (params.size() - 1) / 200 + 1;
        int pos = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < count; ++i) {
                int start = handler.beforeBatchBindParams(ps);
                for (int j = 0; j < 200; ++j) {
                    int k = 0;
                    while (k < columnSize) {
                        if (pos < size) {
                            Object param = params.get(i * 200 + j);
                            ps.setObject(start + j * columnSize + k + 1, ((Object[])param)[k]);
                        } else {
                            ps.setObject(start + j * columnSize + k + 1, NOT_FOUND_VALUE);
                        }
                        ++k;
                        ++pos;
                    }
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    handler.processRow(rs);
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
    }

    static interface CallbackHandler {
        public int beforeBatchBindParams(PreparedStatement var1) throws SQLException;

        public void processRow(ResultSet var1) throws SQLException;
    }
}

