/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgDecException;
import com.kingdee.eas.ma.budget.BgDecomposerFormFactory;
import com.kingdee.eas.ma.budget.BgDecomposerFormInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.IBgDecomposerForm;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.RefBgDecFormCollection;
import com.kingdee.eas.ma.budget.RefBgDecFormInfo;
import com.kingdee.eas.ma.budget.app.AbstractBgDecomposerFacadeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgDecomposerFacadeControllerBean
extends AbstractBgDecomposerFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgDecomposerFacadeControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _checkFormulaIsEctype(Context ctx, BOSUuid bgFormId, Map formulaMap) throws BOSException, EASBizException {
        if (bgFormId == null) return;
        if (formulaMap == null) return;
        if (formulaMap.isEmpty()) {
            return;
        }
        BgFormInfo bgFormInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String noFindStr = "#";
        String formulaString2222222 = null;
        String bgFormStr = null;
        StringBuffer sql = new StringBuffer(1024);
        ArrayList<String> formulas = new ArrayList<String>();
        for (String formulaString2222222 : formulaMap.keySet()) {
            formulas.add(formulaString2222222);
        }
        int index = 0;
        int batchNum = 50;
        int size = formulas.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        try {
            conn = this.getConnection(ctx);
            bgFormInfo = BgFSHelper.getBgFormInfo(conn, bgFormId, false);
            sql.append("Select TOP 1 FFormula, FBgFormId from T_BG_BgData where FOrgUnitId = ? AND FBgSchemeId = ? AND FFormula in (");
            for (index = 1; index < batchNum; ++index) {
                sql.append("?,");
            }
            sql.append("?)");
            sql.append(" and (FBgFormId <> '" + bgFormInfo.getAdjust().getId() + "')");
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                pstmt.setString(1, bgFormInfo.getOrgUnit().getId().toString());
                pstmt.setString(2, bgFormInfo.getBgScheme().getId().toString());
                for (int k = 0; k < batchNum; ++k, ++pos) {
                    if (pos < size) {
                        pstmt.setString(k + 3, (String)formulas.get(pos));
                        continue;
                    }
                    pstmt.setString(k + 3, noFindStr);
                }
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    formulaString2222222 = rst.getString(1);
                    bgFormStr = rst.getString(2);
                    break;
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            if (formulaString2222222 != null && bgFormStr != null) {
                bgFormInfo = BgFSHelper.getBgFormInfo(conn, BOSUuid.read(bgFormStr), false);
                throw new BgFormException(BgFormException.EXISTFORMFORMULASCHEME, new String[]{(String)formulaMap.get(formulaString2222222), formulaString2222222, bgFormInfo.getName()});
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (EASBizException ex3) {
                    throw ex3;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected Map _loadAllRelateInfo(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        if (id == null) {
            return resultMap;
        }
        IBgDecomposerForm iDec = BgDecomposerFormFactory.getLocalInstance(ctx);
        BgDecomposerFormInfo info = iDec.getBgDecomposerFormInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        ICostCenterOrgUnit iccOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        if (info == null) {
            throw new BgException(BgException.NOOBJECT);
        }
        ObjectUuidPK pk = new ObjectUuidPK(info.getBgForm().getId());
        BgFormInfo bgFormInfo = null;
        CostCenterOrgUnitInfo ccOrgInfo = null;
        HashSet<String> orgSet = new HashSet<String>();
        if (!iBgForm.exists((IObjectPK)pk)) {
            throw new BgException(BgException.NOOBJECT);
        }
        bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)pk, this.getBgFormInfo());
        resultMap.put("bgFormInfo", bgFormInfo);
        ccOrgInfo = iccOrgUnit.getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getOrgUnit().getId()));
        resultMap.put("defOrgUnitInfo", (Serializable)ccOrgInfo);
        orgSet.add(ccOrgInfo.getId().toString());
        CostCenterOrgUnitCollection refOrgUnitCol = new CostCenterOrgUnitCollection();
        HashSet<String> orgId = new HashSet<String>();
        if (info.getRefBgDecForms() != null && !info.getRefBgDecForms().isEmpty()) {
            RefBgDecFormInfo refBgDecFormInfo = null;
            RefBgDecFormCollection refBgDecFormCol = info.getRefBgDecForms();
            int n = refBgDecFormCol.size();
            for (int i = 0; i < n; ++i) {
                refBgDecFormInfo = refBgDecFormCol.get(i);
                if (refBgDecFormInfo.getBgForm() == null || refBgDecFormInfo.getBgForm().getOrgUnit() == null) {
                    throw new BgDecException(BgDecException.NOTHAVEBGFORM);
                }
                orgId.add(refBgDecFormInfo.getBgForm().getOrgUnit().getId().toString());
                orgSet.add(refBgDecFormInfo.getBgForm().getOrgUnit().getId().toString());
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection item = filter.getFilterItems();
        item.add(new FilterItemInfo("id", orgId, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        refOrgUnitCol = iccOrgUnit.getCostCenterOrgUnitCollection(viewInfo);
        resultMap.put("refOrgUnitCol", (Serializable)refOrgUnitCol);
        EntityViewInfo view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", orgSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemInfo sore = new SorterItemInfo("longNumber");
        sore.setSortType(SortType.DESCEND);
        view.getSorter().add(sore);
        CostCenterOrgUnitInfo costCenterOrgUnitInfo = null;
        CostCenterOrgUnitCollection costCenterOrgUnitColl = null;
        HashMap<BOSUuid, CostCenterOrgUnitInfo> orgSheetCheckMap = new HashMap<BOSUuid, CostCenterOrgUnitInfo>();
        try {
            costCenterOrgUnitColl = iccOrgUnit.getCostCenterOrgUnitCollection(view);
            int size = costCenterOrgUnitColl.size();
            for (int i = 0; i < size; ++i) {
                costCenterOrgUnitInfo = costCenterOrgUnitColl.get(i);
                if (costCenterOrgUnitInfo == null) continue;
                orgSheetCheckMap.put(costCenterOrgUnitInfo.getId(), costCenterOrgUnitInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        resultMap.put("orgSheetCheckMap", orgSheetCheckMap);
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        CurrencyInfo currencyInfo2 = null;
        CurrencyCollection currencyCol = null;
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        if (iCurrency != null) {
            currencyCol = iCurrency.getCurrencyCollection();
            for (CurrencyInfo currencyInfo2 : currencyCol) {
                currencyMap.put(currencyInfo2.getNumber(), currencyInfo2);
            }
        }
        resultMap.put("currencyMap", currencyMap);
        return resultMap;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("bgform.id"));
        sic.add(new SelectorItemInfo("bgform.bgScheme.name"));
        sic.add(new SelectorItemInfo("refBgDecForms.*"));
        sic.add(new SelectorItemInfo("refBgDecForms.bgForm.id"));
        sic.add(new SelectorItemInfo("refBgDecForms.bgForm.orgUnit.id"));
        sic.add(new SelectorItemInfo("refBgDecForms.bgForm.bgScheme.id"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    public SelectorItemCollection getBgFormInfo() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("bgTemplate.id"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.*"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("measureUnit.*"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }
}

