/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.budget.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.budget.BgCollectException;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDaoSqlObject;
import com.kingdee.eas.ma.budget.BgDataInfo;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgDecomposerFormFactory;
import com.kingdee.eas.ma.budget.BgDecomposerFormInfo;
import com.kingdee.eas.ma.budget.BgDecomposerStateEnum;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFacadeFactory;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.IRefBgDecForm;
import com.kingdee.eas.ma.budget.RefBgDecFormCollection;
import com.kingdee.eas.ma.budget.RefBgDecFormFactory;
import com.kingdee.eas.ma.budget.RefBgDecFormInfo;
import com.kingdee.eas.ma.budget.app.AbstractBgDecomposerFormControllerBean;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNAdjHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgDecomposerFormControllerBean
extends AbstractBgDecomposerFormControllerBean {
    private static final long serialVersionUID = -5303066645507640594L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgDecomposerFormControllerBean");

    protected SelectorItemCollection getBgFormInfo() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    @Override
    protected Map _getTopBgData(Context ctx, BOSUuid topBgId, String subBgId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (topBgId == null) {
            return result;
        }
        IBgForm ibgform = BgFormFactory.getLocalInstance(ctx);
        if (ibgform == null) {
            throw new BgException(BgException.NOINSTANCE);
        }
        ObjectUuidPK pk = new ObjectUuidPK(topBgId);
        BgFormInfo bgFormInfo = ibgform.getBgFormInfo((IObjectPK)pk, this.getBgFormInfo());
        BgDaoSqlObject sqlOb = new BgDaoSqlObject();
        sqlOb.setSelect("distinct e.FName_" + ctx.getLocale() + " as elementname, e.FNumber as elementnumber, e.FDataType as datatype ");
        sqlOb.setFrom("T_BG_BgData as t left outer join T_BG_BgElement e on t.FBgElementId = e.FID ");
        sqlOb.setWhere("t.FOrgUnitID = '" + bgFormInfo.getOrgUnit().getId() + "' and t.FBgSchemeID = '" + bgFormInfo.getBgScheme().getId() + "' and t.FBgFormId = '" + bgFormInfo.getId() + "' and t.FFormula like '%" + BgDataTypeEnum.BgData.getName() + "%'");
        result.put("element", DbUtil.executeQuery((Context)ctx, (String)sqlOb.getSql()));
        BgDaoSqlObject topSql = new BgDaoSqlObject();
        BgDaoSqlObject subSql = new BgDaoSqlObject();
        topSql.setSelect("period.FName_" + ctx.getLocale() + " as periodname, itemcom.fkey as itemKey, itemcom.fkey as itemName, e.FName_" + ctx.getLocale() + " as elementname, e.FNumber as elementnumber, t.FBgValue as bgvalue, 0 as isSum, t.FBgFormId as bgform, t.FFormula as formula");
        subSql.setSelect("period.fname_" + ctx.getLocale() + " as periodname, itemcom.fkey as itemKey, itemcom.fkey as itemName, e.FName_" + ctx.getLocale() + " as elementname,e.FNumber as elementnumber, sum(t.FBgValue) as bgvalue, 1 as isSum, ' ' as bgform, t.FFormula as formula");
        topSql.setFrom("T_BG_BgData t left outer join T_BG_BgPeriod period on t.fbgperiodid = period.fid left outer join T_BG_BgElement e on t.fbgelementid = e.fid left outer join T_BG_BgItemCombination itemcom on t.fbgitemcombinid = itemcom.fid");
        subSql.setFrom(topSql.getFrom());
        topSql.setWhere(sqlOb.getWhere());
        subSql.setWhere("FBgFormId in " + subBgId + " and FFormula in (select FFormula from T_BG_BgData topdata where FBgFormId = '" + topBgId.toString() + "' and FFormula like '%" + BgDataTypeEnum.BgData.getName() + "%')");
        subSql.setGroup("period.fname_" + ctx.getLocale() + ", itemcom.fkey , e.fname_" + ctx.getLocale() + ", e.fnumber, t.FFormula ");
        BgDaoSqlObject allSql = new BgDaoSqlObject();
        allSql.setSelect("*");
        allSql.setFrom("(" + topSql.getSql() + " union all " + subSql.getSql() + ") AS temp ");
        allSql.setOrder("periodname, itemKey, isSum, elementname");
        IRowSet data = DbUtil.executeQuery((Context)ctx, (String)allSql.getSql());
        HashSet itemNumberSet = new HashSet();
        try {
            while (data.next()) {
                String itemCombine = data.getString("itemKey");
                if (itemCombine == null) continue;
                BgHelper.addArray2Set(itemNumberSet, itemCombine.split("_"));
            }
            data.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        result.put("data", data);
        result.put("itemMap", this.getItemNumber2NameMap(ctx, itemNumberSet, bgFormInfo.getOrgUnit().getId().toString()));
        return result;
    }

    @Override
    protected IRowSet _getSubBgData(Context ctx, BOSUuid topBgId, String subBgIds, String periodName, String itemKey, String formula) throws BOSException {
        BgDaoSqlObject subSql = new BgDaoSqlObject();
        subSql.setSelect("'" + periodName + "' as periodname, '" + itemKey + "' as itemKey, org.fname_" + ctx.getLocale() + " as itemName, element.fname_" + ctx.getLocale() + " as elementname,element.fnumber as elementnumber , data.fbgvalue as bgvalue , 0 as isSum, data.fbgformid as bgform, data.fformula as formula");
        subSql.setFrom("t_bg_bgdata data left outer join T_BG_BgElement element on data.fbgelementid = element.fid left outer join T_ORG_BaseUnit org on data.forgunitid = org.fid ");
        subSql.setWhere("Fbgformid in " + subBgIds + " and fformula in " + formula);
        return DbUtil.executeQuery((Context)ctx, (String)subSql.getSql());
    }

    protected boolean isUpgrade(Context ctx) throws Exception {
        return BgItemFacadeFactory.getLocalInstance(ctx).checkIsUpgrade();
    }

    private Map getItemNumber2NameMap(Context ctx, Set numberSet, String orgUnitId) throws BOSException, EASBizException {
        HashMap<String, String> itemMap = new HashMap<String, String>();
        if (numberSet.size() == 0) {
            return itemMap;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg(ctx, orgUnitId), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        IBgItem iBgItem = BgItemFactory.getLocalInstance(ctx);
        BgItemCollection bgItemColl = iBgItem.getBgItemCollection(viewInfo);
        if (bgItemColl != null && bgItemColl.size() > 0) {
            for (int i = 0; i < bgItemColl.size(); ++i) {
                BgItemInfo bgItemInfo = bgItemColl.get(i);
                itemMap.put(bgItemInfo.getNumber(), bgItemInfo.getName());
            }
        }
        return itemMap;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkBgFormState(ctx, model);
        this.setBgFormStatus(ctx, (BgDecomposerFormInfo)model, BgFormStateEnum.Decomposer);
        this.addNewGetOldData(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkBgFormState(ctx, model);
        this.setBgFormStatus(ctx, (BgDecomposerFormInfo)model, BgFormStateEnum.Decomposer);
        this.addNewGetOldData(ctx, model);
        return super._addnew(ctx, model);
    }

    private void addNewGetOldData(Context ctx, IObjectValue model) {
        BgDecomposerFormInfo info = (BgDecomposerFormInfo)model;
        HashMap<String, Object> formIds = new HashMap<String, Object>();
        ArrayList<String> mutexIds = new ArrayList<String>();
        formIds.put(info.getBgForm().getId().toString(), null);
        int n = info.getRefBgDecForms().size();
        for (int i = 0; i < n; ++i) {
            formIds.put(info.getRefBgDecForms().get(i).getBgForm().getId().toString(), null);
            mutexIds.add(info.getRefBgDecForms().get(i).getBgForm().getId().toString());
        }
        try {
            IMutexServiceControl iMC = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            iMC.batchRequestObjIDForUpdate(mutexIds);
            Map oldData = BgDecomposerFormFactory.getLocalInstance(ctx).getOldData(formIds);
            HashMap<String, byte[]> otherData = new HashMap<String, byte[]>();
            otherData.put("oldData", BgHelper.storeHashMapToByte((HashMap)oldData));
            if (otherData != null && !otherData.isEmpty()) {
                info.setOtherCont(BgHelper.storeHashMapToByte(otherData));
            }
        }
        catch (Exception ee) {
            logger.error((Object)"budget error:", (Throwable)ee);
        }
    }

    private void checkBgFormState(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        BgDecomposerFormInfo info = (BgDecomposerFormInfo)model;
        if (info != null) {
            String bgFormId2 = null;
            String bgFormNumber = null;
            BgFormInfo bgFormInfo = null;
            HashMap<String, String> decInfo = new HashMap<String, String>();
            Map filterInfo = new HashMap();
            ArrayList<BgFormStateEnum> state = new ArrayList<BgFormStateEnum>();
            state.add(BgFormStateEnum.Edited);
            state.add(BgFormStateEnum.Certificate);
            bgFormInfo = info.getBgForm();
            decInfo.put(bgFormInfo.getId().toString(), bgFormInfo.getNumber());
            RefBgDecFormInfo refInfo = null;
            Iterator iter = info.getRefBgDecForms().iterator();
            while (iter.hasNext()) {
                refInfo = (RefBgDecFormInfo)iter.next();
                bgFormInfo = refInfo.getBgForm();
                if (decInfo.containsKey(bgFormInfo.getId().toString())) continue;
                decInfo.put(bgFormInfo.getId().toString(), bgFormInfo.getNumber());
            }
            try {
                IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
                filterInfo = ibgForm.getFormFilterInfo(info.getBgForm().getId(), state);
                filterInfo = ibgForm.getFormFilterInfo(filterInfo);
                for (String bgFormId2 : decInfo.keySet()) {
                    bgFormNumber = (String)decInfo.get(bgFormId2);
                    if (filterInfo.containsKey(bgFormId2)) continue;
                    throw new BgCollectException(BgCollectException.BGCOLLECTFORMNOSAVE, new String[]{bgFormNumber});
                }
            }
            catch (BOSException ex) {
                throw ex;
            }
            catch (EASBizException ex) {
                throw ex;
            }
        }
    }

    private void setBgFormStatus(Context ctx, BgDecomposerFormInfo bgDecomposerFormInfo, BgFormStateEnum state) throws BOSException {
        StringBuffer sqlToUpdateBgFormStatus = new StringBuffer("UPDATE T_BG_BgForm SET FState = ? WHERE FSTate = ? AND (");
        RefBgDecFormCollection refBgFormCols = bgDecomposerFormInfo.getRefBgDecForms();
        sqlToUpdateBgFormStatus.append(" FID = ");
        sqlToUpdateBgFormStatus.append("'");
        sqlToUpdateBgFormStatus.append(bgDecomposerFormInfo.getBgForm().getId().toString());
        sqlToUpdateBgFormStatus.append("'");
        int count = refBgFormCols.size();
        for (int i = 0; i < count; ++i) {
            sqlToUpdateBgFormStatus.append(" OR ");
            sqlToUpdateBgFormStatus.append(" FID = ");
            sqlToUpdateBgFormStatus.append("'");
            sqlToUpdateBgFormStatus.append(refBgFormCols.get(i).getBgForm().getId().toString());
            sqlToUpdateBgFormStatus.append("'");
        }
        sqlToUpdateBgFormStatus.append(")");
        try {
            if (BgFormStateEnum.Edited.equals((Object)state)) {
                DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormStatus.toString(), (Object[])new Object[]{new Integer(state.getValue()), new Integer(30)});
            } else if (BgFormStateEnum.Decomposer.equals((Object)state)) {
                DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormStatus.toString(), (Object[])new Object[]{new Integer(state.getValue()), new Integer(1)});
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean checkHaveAudit(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("state");
        BgDecomposerFormInfo bgDecomposerFormInfo = (BgDecomposerFormInfo)this.getValue(ctx, pk, sic);
        return BgDecomposerStateEnum.SIGNED.equals((Object)bgDecomposerFormInfo.getState());
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (this.checkHaveAudit(ctx, pk)) {
            throw new BgCollectException(BgCollectException.BGCOLLECTFORMNOCHANGE);
        }
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgForm");
        sic.add("bgForm.id");
        sic.add("refBgDecForms");
        sic.add("refBgDecForms.bgForm.id");
        sic.add("state");
        BgDecomposerFormInfo bgDecomposerFormInfo = (BgDecomposerFormInfo)this.getValue(ctx, pk, sic);
        if (BgDecomposerStateEnum.SIGNED.equals((Object)bgDecomposerFormInfo.getState())) {
            throw new BgCollectException(BgCollectException.BGCOLLECTFORMNODELETE);
        }
        this.setBgFormStatus(ctx, bgDecomposerFormInfo, BgFormStateEnum.Edited);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + bgDecomposerFormInfo.getBgForm().getId().toString() + "'"));
            int n = bgDecomposerFormInfo.getRefBgDecForms().size();
            for (int i = 0; i < n; ++i) {
                SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + bgDecomposerFormInfo.getRefBgDecForms().get(i).getBgForm().getId().toString() + "'"));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (BOSException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _audit(Context ctx, BOSUuid bgCollectFormId) throws BOSException, EASBizException {
    }

    @Override
    protected void _auditWF(Context ctx, BOSUuid bgCollectFormId) throws BOSException {
    }

    @Override
    protected IRowSet _getAdjustMapByBgForm(Context ctx, BOSUuid bgFormId) throws BOSException {
        BgDaoSqlObject sqlOb = new BgDaoSqlObject();
        sqlOb.setSelect(" TOP 1 collectForm.fadjustMapData AS adjustMapData");
        sqlOb.setFrom("T_BG_BgCollectForm AS collectForm");
        sqlOb.setWhere("collectForm.fBgformID = '" + bgFormId.toString() + "'");
        sqlOb.setOrder(" collectForm.fCreateTime DESC ");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sqlOb.getSql());
        if (result.size() == 0) {
            sqlOb.setSelect(" TOP 1 refForm.fadjustMapData AS adjustMapData");
            sqlOb.setFrom("T_BG_RefBgForm AS refForm LEFT OUTER JOIN T_BG_BgCollectForm AS collectForm ON refForm.FBgCollectID = collectForm.FID");
            sqlOb.setWhere("refForm.fBgformID = '" + bgFormId.toString() + "'");
            sqlOb.setOrder(" collectForm.fCreateTime DESC ");
            result = DbUtil.executeQuery((Context)ctx, (String)sqlOb.getSql());
        }
        return result;
    }

    @Override
    protected void _auditStatus(Context ctx, BOSUuid bgCollectFormId) throws BOSException, EASBizException {
    }

    protected void _auditCollectState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getBgData(Context ctx, BOSUuid orgUnitId, BOSUuid bgSchemeId, Set formulaSet) throws BOSException, EASBizException {
        if (orgUnitId == null) return new HashMap();
        if (bgSchemeId == null) return new HashMap();
        if (formulaSet == null) return new HashMap();
        if (formulaSet.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, BigDecimal> budgetMap = new HashMap<String, BigDecimal>();
        String formulaString2222222 = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FBgValue, FFormula from T_BG_BgData where FOrgUnitId = ? and FBgSchemeId = ? and FFormula in (");
        for (String formulaString2222222 : formulaSet) {
            sql.append("'" + formulaString2222222 + "',");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(")");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgUnitId.toString());
            pstmt.setString(2, bgSchemeId.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                budgetMap.put(rst.getString(2), rst.getBigDecimal(1));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return budgetMap;
    }

    @Override
    protected boolean _hasBgDataFomular(Context ctx, BOSUuid BgFormId) throws BOSException {
        BgDaoSqlObject sqlOb = new BgDaoSqlObject();
        sqlOb.setSelect("top 1 1 ");
        sqlOb.setFrom("t_bg_bgdata as data ");
        sqlOb.setWhere("data.Fbgformid = '" + BgFormId.toString() + "' and data.fformula  like '%" + BgDataTypeEnum.BgData.getName() + "%'");
        try {
            return DbUtil.executeQuery((Context)ctx, (String)sqlOb.getSql()).next();
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + sqlOb.getSql(), (Throwable)e);
        }
    }

    @Override
    protected void _addBgFormToChildren(Context ctx, Map orgIdsMap, IObjectValue formInfo) throws BOSException, EASBizException {
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        IBgTemplate iBgTemplate = BgTemplateFactory.getLocalInstance(ctx);
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        if (formInfo == null || orgIdsMap.size() < 1) {
            return;
        }
        String templateRootId = ((BgFormInfo)formInfo).getBgTemplate().getRootId().toString();
        String schemeRootId = ((BgFormInfo)formInfo).getBgScheme().getRootId().toString();
        BgFormCollection col = null;
        String orgUnitId = null;
        Iterator iter = orgIdsMap.keySet().iterator();
        while (iter.hasNext()) {
            col = null;
            orgUnitId = (String)iter.next();
            try {
                col = iBgForm.getBgFormCollection("select id  where bgTemplate.rootId = '" + templateRootId + "' and bgScheme.rootId = '" + schemeRootId + "' and orgUnit = '" + orgUnitId + "' and bgPeriod = '" + ((BgFormInfo)formInfo).getBgPeriod().getId().toString() + "'  and currency = '" + ((BgFormInfo)formInfo).getCurrency().getId().toString() + "'");
                if (col != null && col.size() != 0) continue;
                BgSchemeInfo bgSchemeInfo = iBgScheme.getBgSchemeInfo("select id , number where rootId = '" + schemeRootId + "' and orgUnit = '" + orgUnitId + "'");
                BgTemplateInfo bgTemplateInfo = null;
                BgTemplateCollection templateCol = iBgTemplate.getBgTemplateCollection("select id, name  where rootId = '" + templateRootId + "' and orgUnit = '" + orgUnitId + "' and id in (select fbgTemplateid from t_bg_BgSchemeNode where fbgSchemeid = '" + bgSchemeInfo.getId().toString() + "'  ) order by createTime ");
                if (templateCol.size() <= 0) continue;
                bgTemplateInfo = templateCol.get(0);
                BgFormInfo bgFormInfo = new BgFormInfo();
                bgFormInfo.setId(BOSUuid.create((BOSObjectType)bgFormInfo.getBOSType()));
                bgFormInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                bgFormInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                bgFormInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                bgFormInfo.setAdjust(bgFormInfo);
                bgFormInfo.setVersionNo(BgConstants.ONE);
                FullOrgUnitInfo fullOrgUnit = new FullOrgUnitInfo();
                IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
                fullOrgUnit = iFullOrgUnit.getFullOrgUnitInfo("where id = '" + orgUnitId + "'");
                CompanyOrgUnitInfo companyInfo = this.getCompanyByOrgUnit((OrgUnitInfo)fullOrgUnit, ctx);
                if (companyInfo != null) {
                    bgFormInfo.setCompany(companyInfo);
                }
                bgFormInfo.setState(BgFormStateEnum.Edited);
                bgFormInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
                bgFormInfo.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
                bgFormInfo.setDataSource(BgFormDataSourceEnum.SUPERIORSPLIT);
                bgFormInfo.setSourceType(RptSrcTypeEnum.BGFORMREPORT);
                bgFormInfo.setStartDate(new Date());
                bgFormInfo.setEndDate(bgFormInfo.getStartDate());
                bgFormInfo.setBgTemplate(bgTemplateInfo);
                bgFormInfo.setBgScheme(bgSchemeInfo);
                bgFormInfo.setOrgUnit(fullOrgUnit);
                bgFormInfo.setBgPeriod(((BgFormInfo)formInfo).getBgPeriod());
                bgFormInfo.setCurrency(((BgFormInfo)formInfo).getCurrency());
                bgFormInfo.setBgType(bgTemplateInfo.getBgType());
                String bgFormName = null;
                if (bgFormInfo.getCU().getName() != null) {
                    bgFormName = bgFormInfo.getCU().getId().toString().equals(bgFormInfo.getOrgUnit().getId().toString()) ? bgFormInfo.getCU().getName().trim() + "_" + bgFormInfo.getBgPeriod().getName().trim() + "_" + bgFormInfo.getBgTemplate().getName().trim() : bgFormInfo.getCU().getName().trim() + "_" + bgFormInfo.getOrgUnit().getName().trim() + "_" + bgFormInfo.getBgPeriod().getName().trim() + "_" + bgFormInfo.getBgTemplate().getName().trim();
                }
                bgFormInfo.setName(bgFormName != null && bgFormName.length() > 80 ? bgFormName.substring(1, 80) : bgFormName);
                bgFormInfo.setMeasureUnit(bgTemplateInfo.getDefaultMeasureUnit());
                iBgForm.submit(bgFormInfo.getId(), (IObjectValue)bgFormInfo, true);
            }
            catch (BOSException ex) {
                throw new BOSException((Throwable)ex);
            }
            catch (Exception e) {
                if (!(e instanceof BgFormException)) continue;
                BgFormException ex = (BgFormException)((Object)e);
                throw ex;
            }
        }
    }

    protected CompanyOrgUnitInfo getCompanyByOrgUnit(OrgUnitInfo orgUnitInfo, Context ctx) throws Exception {
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), this.getCompanySelectors());
        }
        OrgUnitInfo parent = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return this.getCompanyByOrgUnit(parent, ctx);
        }
        return null;
    }

    protected SelectorItemCollection getCompanySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isBizUnit");
        sic.add("accountPeriodType.id");
        return sic;
    }

    @Override
    protected void _setState(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgForm");
        sic.add("refBgDecForms");
        sic.add("refBgDecForms.bgForm.id");
        sic.add("state");
        BgDecomposerFormInfo bgDecomposerFormInfo = (BgDecomposerFormInfo)this.getValue(ctx, pk, sic);
        this.setBgFormStatus(ctx, bgDecomposerFormInfo, BgFormStateEnum.Edited, true);
        this.setBgDecFormState(ctx, bgDecomposerFormInfo, BgDecomposerStateEnum.SIGNED);
    }

    private void setBgDecFormState(Context ctx, BgDecomposerFormInfo bgDecomposerFormInfo, BgDecomposerStateEnum state) throws BOSException {
        StringBuffer sqlToUpdateBgFormStatus = new StringBuffer("UPDATE T_BG_BgDecomposerForm SET FState = ? WHERE");
        sqlToUpdateBgFormStatus.append(" FID = ");
        sqlToUpdateBgFormStatus.append("'");
        sqlToUpdateBgFormStatus.append(bgDecomposerFormInfo.getId().toString());
        sqlToUpdateBgFormStatus.append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormStatus.toString(), (Object[])new Object[]{new Integer(state.getValue())});
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void setBgFormStatus(Context ctx, BgDecomposerFormInfo bgDecomposerFormInfo, BgFormStateEnum state, boolean end) throws BOSException {
        StringBuffer sqlToUpdateBgFormStatus = new StringBuffer("UPDATE T_BG_BgForm SET FState = ? , FDataSource = -1 WHERE");
        RefBgDecFormCollection refBgFormCols = bgDecomposerFormInfo.getRefBgDecForms();
        sqlToUpdateBgFormStatus.append("(");
        int count = refBgFormCols.size();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                sqlToUpdateBgFormStatus.append(" OR ");
            }
            sqlToUpdateBgFormStatus.append(" FID = ");
            sqlToUpdateBgFormStatus.append("'");
            sqlToUpdateBgFormStatus.append(refBgFormCols.get(i).getBgForm().getId().toString());
            sqlToUpdateBgFormStatus.append("'");
        }
        sqlToUpdateBgFormStatus.append(") and fid <> '" + bgDecomposerFormInfo.getId().toString() + "' ");
        try {
            DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormStatus.toString(), (Object[])new Object[]{new Integer(state.getValue())});
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        sqlToUpdateBgFormStatus = new StringBuffer("UPDATE T_BG_BgForm SET FState = ? , FDataSource = 0 WHERE");
        sqlToUpdateBgFormStatus.append(" FID = ");
        sqlToUpdateBgFormStatus.append("'");
        sqlToUpdateBgFormStatus.append(bgDecomposerFormInfo.getBgForm().getId().toString());
        sqlToUpdateBgFormStatus.append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sqlToUpdateBgFormStatus.toString(), (Object[])new Object[]{new Integer(1)});
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String logInfo = "";
        if (ctx == null) return logInfo;
        if (pk == null) {
            return logInfo;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select f.FNumber, f.FName from T_BG_BgDecomposerForm t left outer join T_BG_BgForm f on t.FBgFormId = f.FID where t.FID = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, pk.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                logInfo = rst.getString(1) + " - " + rst.getString(2);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return logInfo;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgDecomposerFormInfo bgDecFormInfo = (BgDecomposerFormInfo)model;
        InputStream is = null;
        ObjectInputStream ois = null;
        HashMap adjustMap = null;
        Connection conn = null;
        BgFormInfo bgFormInfo = null;
        try {
            conn = this.getConnection(ctx);
            bgDecFormInfo.remove("kdtData");
            byte[] data = bgDecFormInfo.getAdjustMapData();
            if (data != null && data.length > 0) {
                is = ZipUtil.unpack((byte[])data);
                ois = new ObjectInputStream(is);
                adjustMap = (HashMap)ois.readObject();
                if (adjustMap != null && !adjustMap.isEmpty()) {
                    bgFormInfo = BgFSHelper.getBgFormInfo(conn, bgDecFormInfo.getBgForm().getId(), false);
                    BgNAdjHelper.createTmpDataOfFormula((Context)ctx, (Connection)conn, (BOSUuid)bgFormInfo.getOrgUnit().getId(), (BOSUuid)bgFormInfo.getBgScheme().getId(), (BOSUuid)bgFormInfo.getBgTemplate().getId(), (BOSUuid)bgFormInfo.getId(), (Map)adjustMap);
                    adjustMap.clear();
                } else {
                    SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + bgDecFormInfo.getBgForm().getId().toString() + "'"));
                }
                try {
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    ois.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            RefBgDecFormInfo refBgDecFormInfo = null;
            Iterator iter = bgDecFormInfo.getRefBgDecForms().iterator();
            while (iter.hasNext()) {
                refBgDecFormInfo = (RefBgDecFormInfo)iter.next();
                refBgDecFormInfo.remove("kdtData");
                data = refBgDecFormInfo.getAdjustMapData();
                if (data == null || data.length <= 0) continue;
                is = ZipUtil.unpack((byte[])data);
                ois = new ObjectInputStream(is);
                adjustMap = (HashMap)ois.readObject();
                if (adjustMap != null && !adjustMap.isEmpty()) {
                    bgFormInfo = BgFSHelper.getBgFormInfo(conn, refBgDecFormInfo.getBgForm().getId(), false);
                    BgFSHelper.createTmpDataOfFormula(ctx, conn, bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgScheme().getId(), bgFormInfo.getBgTemplate().getId(), bgFormInfo.getId(), adjustMap);
                    adjustMap.clear();
                } else {
                    SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + refBgDecFormInfo.getBgForm().getId().toString() + "'"));
                }
                try {
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    ois.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new BOSException((Throwable)ex);
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    private Map getDecIdsMap(BgDecomposerFormInfo editData) {
        HashMap<String, Object> decIds = new HashMap<String, Object>();
        HashMap<String, Object> refIds = new HashMap<String, Object>();
        decIds.put("decId", editData.getId().toString());
        decIds.put("mainFormId", editData.getBgForm().getId().toString());
        RefBgDecFormCollection coll = editData.getRefBgDecForms();
        for (int i = 0; i < coll.size(); ++i) {
            refIds.put(coll.get(i).getBgForm().getId().toString(), null);
        }
        decIds.put("refIds", refIds);
        return decIds;
    }

    @Override
    protected Object[] _updateBgFormData(Context ctx, String bgFormId, IObjectValue info, ArrayList tableData) throws BOSException, EASBizException {
        Book book = null;
        try {
            book = ((BgFormInfo)info).getBook();
        }
        catch (Exception e) {
            return null;
        }
        if (book == null) {
            return null;
        }
        Object[] obj = new Object[3];
        HashMap adjustMap = new HashMap();
        HashMap valueMap = new HashMap();
        if (tableData != null) {
            int index = 0;
            ArrayList tbl = null;
            ArrayList row = null;
            if (book == null || book.getSheetCount() <= 0) {
                return null;
            }
            book.setCalculate(false);
            int sheetCount = book.getSheetCount();
            for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
                Sheet sheet = book.getSheet(sheetIndex);
                tbl = (ArrayList)tableData.get(index);
                if (tbl != null) {
                    int rowCount = sheet.getMaxRowIndex() + 1;
                    int colCount = sheet.getMaxColIndex() + 1;
                    for (int r = 0; r < rowCount; ++r) {
                        for (int c = 0; c < colCount; ++c) {
                            Cell cell = sheet.getCell(r, c, false);
                            boolean b = BgNFSHelper.checkHasExpression((Cell)cell);
                            if (b) {
                                cell.updateFormula();
                            }
                            if (!b || tbl.size() < r) continue;
                            row = (ArrayList)tbl.get(r);
                            if (row.get(c) != null) {
                                BgNFSHelper.setValue((Cell)cell, row.get(c));
                            } else {
                                cell.setValue(null);
                            }
                            if (row != null && BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                                String formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell);
                                if (formulaString == null || formulaString.trim().length() <= 0) continue;
                                if (row.get(c) != null) {
                                    BgNFSHelper.getItemFormula((Cell)cell).putExt("BG_BUDGET_VALUE", String.valueOf(row.get(c)));
                                } else {
                                    BgNFSHelper.getItemFormula((Cell)cell).putExt("BG_BUDGET_VALUE", null);
                                }
                                adjustMap.put(formulaString, row.get(c));
                                continue;
                            }
                            if (row == null) continue;
                            String expr = BgNFSHelper.getExpression((Cell)cell);
                            valueMap.put(expr, row.get(c));
                        }
                    }
                }
                ++index;
            }
        }
        byte[] data = null;
        try {
            data = IOHelper.packBook((Book)book);
        }
        catch (IOException e) {
            throw new BgException(BgException.DATABASEERROR, new String[]{e.getMessage()});
        }
        obj[0] = adjustMap;
        obj[1] = data;
        obj[2] = valueMap;
        return obj;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _updateDataForForm(Context ctx, String bgDecId, Map dataMap) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement refPstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgDecomposerForm  set  FKdtData = ? where FBgFormID = ? and fid = ?");
            refPstmt = conn.prepareStatement("update T_BG_RefBgDecForm  set  FKdtData = ? where FBgFormID = ? and FBgDecomposerID = ?");
            String typeId2222222 = null;
            String[] type = null;
            for (String typeId2222222 : dataMap.keySet()) {
                type = typeId2222222.split("`");
                if (type[0].equals("from")) {
                    pstmt.setBytes(1, ((RefBgDecFormInfo)dataMap.get(typeId2222222)).getKdtData());
                    pstmt.setString(2, type[1]);
                    pstmt.setString(3, bgDecId);
                    pstmt.executeUpdate();
                    continue;
                }
                if (!type[0].equals("ref")) continue;
                refPstmt.setBytes(1, ((RefBgDecFormInfo)dataMap.get(typeId2222222)).getKdtData());
                refPstmt.setString(2, type[1]);
                refPstmt.setString(3, bgDecId);
                refPstmt.executeUpdate();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                SQLUtils.cleanup(refPstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup((Statement)refPstmt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object[] _updateDataToBgTmpData(Context ctx, String formId, Object datas) throws BOSException, EASBizException {
        HashMap data = (HashMap)datas;
        String[] items = this.getStrings(data);
        HashMap haveData = new HashMap();
        HashMap<String, BigDecimal> notHaveData = new HashMap<String, BigDecimal>();
        BgDataInfo bgData = new BgDataInfo();
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmtBgData = null;
        PreparedStatement pstmtBgDataIds = null;
        PreparedStatement pstmt2 = null;
        PreparedStatement pstmt3 = null;
        PreparedStatement pstmt4 = null;
        ResultSet rst = null;
        HashMap spData = null;
        String[] bgDataIds = new String[6];
        int n = 1;
        while ((n - 1) * 50 < items.length) {
            int m;
            spData = new HashMap();
            String[] cutItems = null;
            if (n * 50 > items.length) {
                cutItems = new String[items.length - (n - 1) * 50];
                m = 0;
                while ((n - 1) * 50 + m < items.length) {
                    cutItems[m] = items[(n - 1) * 50 + m];
                    spData.put(items[(n - 1) * 50 + m], data.get(items[(n - 1) * 50 + m]));
                    ++m;
                }
            } else {
                cutItems = new String[50];
                for (m = 0; m < 50; ++m) {
                    cutItems[m] = items[(n - 1) * 50 + m];
                    spData.put(items[(n - 1) * 50 + m], data.get(items[(n - 1) * 50 + m]));
                }
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select fformula from T_BG_BgTmpData where Fbgformid = ?");
            StringBuffer bgDataSql = new StringBuffer();
            bgDataSql.append("select fformula, fBgValue from t_bg_bgdata where fbgformid = ? and fformula in (" + BgNSQLHelper.getParamSizeString((int)cutItems.length) + ")");
            ArrayList<String> _tmpList = new ArrayList<String>();
            _tmpList.add(formId);
            int in = cutItems.length;
            for (int i = 0; i < in; ++i) {
                _tmpList.add(cutItems[i]);
            }
            StringBuffer bgDataIdsSql = new StringBuffer();
            bgDataIdsSql.append("select FOrgUnitId, FBgSchemeId, FBgTemplateId,   FBgPeriodId, FCurrencyId from t_bg_bgform where fid = ? ");
            StringBuffer sql2 = new StringBuffer();
            sql2.append("Insert Into T_BG_BgTmpData (FID, FBgValue,  FBizActual, FOrgUnitId, FBgSchemeId, FBgTemplateId, FBgFormId, FFormula,  FBgElementId, FBgPeriodId, FCurrencyId) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            StringBuffer sql3 = new StringBuffer();
            sql3.append("update t_bg_bgTmpdata set fbgvalue = ? where fbgformId = ? and fformula = ? ");
            StringBuffer sql4 = new StringBuffer();
            sql4.append("update t_bg_bgTmpdata set FBgBalance = FBgValue - FBizActual  where fbgformId = ? ");
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, formId);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    haveData.put(rst.getString(1), null);
                }
                rst = null;
                pstmtBgData = conn.prepareStatement(bgDataSql.toString());
                BgNSQLHelper.setParams((PreparedStatement)pstmtBgData, _tmpList);
                rst = pstmtBgData.executeQuery();
                while (rst.next()) {
                    if (haveData.containsKey(rst.getString(1))) continue;
                    notHaveData.put(rst.getString(1), rst.getBigDecimal(2));
                }
                if (bgDataIds[0] == null) {
                    rst = null;
                    pstmtBgDataIds = conn.prepareStatement(bgDataIdsSql.toString());
                    pstmtBgDataIds.setString(1, formId);
                    rst = pstmtBgDataIds.executeQuery();
                    if (rst.next()) {
                        bgDataIds[0] = rst.getString(1);
                        bgDataIds[1] = rst.getString(2);
                        bgDataIds[2] = rst.getString(3);
                        bgDataIds[3] = "element";
                        bgDataIds[4] = rst.getString(4);
                        bgDataIds[5] = rst.getString(5);
                    }
                }
                for (String formula : spData.keySet()) {
                    if (haveData.containsKey(formula)) {
                        pstmt3 = conn.prepareStatement(sql3.toString());
                        if (spData.get(formula) instanceof BigDecimal) {
                            pstmt3.setBigDecimal(1, (BigDecimal)spData.get(formula));
                        } else {
                            pstmt3.setBigDecimal(1, new BigDecimal("0"));
                        }
                        pstmt3.setString(2, formId);
                        pstmt3.setString(3, formula);
                        pstmt3.executeUpdate();
                        SQLUtils.cleanup((Statement)pstmt3);
                        continue;
                    }
                    pstmt2 = conn.prepareStatement(sql2.toString());
                    pstmt2.setString(1, BOSUuid.create((BOSObjectType)bgData.getBOSType()).toString());
                    if (spData.get(formula) instanceof BigDecimal) {
                        pstmt2.setBigDecimal(2, (BigDecimal)spData.get(formula));
                    } else {
                        pstmt2.setBigDecimal(2, new BigDecimal("0"));
                    }
                    if (notHaveData.get(formula) instanceof BigDecimal) {
                        pstmt2.setBigDecimal(3, (BigDecimal)notHaveData.get(formula));
                    } else {
                        pstmt2.setBigDecimal(3, new BigDecimal("0"));
                    }
                    pstmt2.setString(4, bgDataIds[0]);
                    pstmt2.setString(5, bgDataIds[1]);
                    pstmt2.setString(6, bgDataIds[2]);
                    pstmt2.setString(7, formId);
                    pstmt2.setString(8, formula);
                    pstmt2.setString(9, bgDataIds[3]);
                    pstmt2.setString(10, bgDataIds[4]);
                    pstmt2.setString(11, bgDataIds[5]);
                    pstmt2.executeUpdate();
                    SQLUtils.cleanup((Statement)pstmt2);
                }
                pstmt4 = conn.prepareStatement(sql4.toString());
                pstmt4.setString(1, formId);
                pstmt4.executeUpdate();
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                    catch (BOSException ex2) {
                        throw ex2;
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    SQLUtils.cleanup(pstmt2);
                    SQLUtils.cleanup(pstmt3);
                    SQLUtils.cleanup(pstmt4);
                    SQLUtils.cleanup(pstmtBgData);
                    SQLUtils.cleanup(pstmtBgDataIds);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            SQLUtils.cleanup((Statement)pstmt2);
            SQLUtils.cleanup((Statement)pstmt3);
            SQLUtils.cleanup((Statement)pstmt4);
            SQLUtils.cleanup((Statement)pstmtBgData);
            SQLUtils.cleanup((Statement)pstmtBgDataIds);
            ++n;
        }
        return null;
    }

    private String[] getStrings(Map data) {
        String[] items = new String[data.size()];
        int i = 0;
        Iterator iter = data.keySet().iterator();
        while (iter.hasNext()) {
            items[i] = (String)iter.next();
            ++i;
        }
        return items;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getOldData(Context ctx, Map bgFormId) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> itemValue = new HashMap<String, BigDecimal>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select fbgformid, fformula, fbgvalue  from T_bg_bgdata where fbgformid = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (String id : bgFormId.keySet()) {
                pstmt.setString(1, id);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    itemValue.put(rst.getString(1) + rst.getString(2), rst.getBigDecimal(3));
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return itemValue;
    }

    @Override
    protected Object _updateData(Context ctx, String decId, Map addNewData, Map delOldData, boolean isDec, byte[] newObj) throws BOSException, EASBizException {
        byte[] data = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("kdtData");
        sic.add("bgForm.id");
        SelectorItemCollection formSic = new SelectorItemCollection();
        formSic.add(new SelectorItemInfo("id"));
        formSic.add(new SelectorItemInfo("data"));
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)decId));
        BgDecomposerFormInfo info = null;
        RefBgDecFormInfo refInfo = null;
        BgFormInfo bgFormInfo = null;
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        if (isDec) {
            if (newObj != null) {
                info = new BgDecomposerFormInfo();
                info.setKdtData(newObj);
            } else {
                info = (BgDecomposerFormInfo)this.getValue(ctx, (IObjectPK)pk, sic);
            }
        } else if (newObj != null) {
            refInfo = new RefBgDecFormInfo();
            refInfo.setKdtData(newObj);
        } else {
            IRefBgDecForm iRef = RefBgDecFormFactory.getLocalInstance(ctx);
            refInfo = iRef.getRefBgDecFormInfo((IObjectPK)pk, sic);
        }
        if (info != null) {
            try {
                int colIndex;
                int rowIndex;
                Book book = null;
                if (isDec) {
                    if (info.getKdtData() != null) {
                        book = info.getBook();
                    } else {
                        bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(info.getBgForm().getId()), formSic);
                        book = bgFormInfo.getBook();
                    }
                } else if (refInfo.getKdtData() != null) {
                    book = refInfo.getBook();
                } else {
                    bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(refInfo.getBgForm().getId()), formSic);
                    book = bgFormInfo.getBook();
                }
                Sheet sheet = null;
                Vector cellObj = null;
                for (String fomulaString : delOldData.keySet()) {
                    cellObj = (Vector)delOldData.get(fomulaString);
                    sheet = book.getSheetByID((String)cellObj.get(0));
                    rowIndex = (Integer)cellObj.get(1);
                    colIndex = (Integer)cellObj.get(2);
                    Cell nCell = sheet.getCell(rowIndex, colIndex, true);
                    BgNFSHelper.setItemFormula((Cell)nCell, null);
                    BgNFSHelper.setValue((Cell)nCell, null);
                }
                for (String fomulaString : addNewData.keySet()) {
                    cellObj = (Vector)addNewData.get(fomulaString);
                    sheet = book.getSheetByID((String)cellObj.get(0));
                    rowIndex = (Integer)cellObj.get(1);
                    colIndex = (Integer)cellObj.get(2);
                    Variant value = (Variant)cellObj.get(3);
                    Cell nCell = sheet.getCell(rowIndex, colIndex, true);
                    BgNFSHelper.setFormulaOfCell((Cell)nCell, (String)fomulaString, (boolean)true);
                    BgNFSHelper.setValue((Cell)nCell, (Object)value);
                }
                BgNFSHelper.checkBookSign((Book)book);
                data = IOHelper.packBook((Book)book);
            }
            catch (SQLException ex) {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (BOSException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new BgException(BgException.DATABASEERROR, new String[]{e.getMessage()});
            }
        }
        return data;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _addNewData(Context ctx, Map bgDecIds) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement batchPstmt;
        PreparedStatement pstmt;
        PreparedStatement pstmtV;
        PreparedStatement pstmtM;
        Connection conn;
        StringBuffer batchValueSql;
        byte[] data;
        Map refIds;
        String decId;
        block12: {
            if (bgDecIds == null) {
                return;
            }
            decId = (String)bgDecIds.get("decId");
            String mainFormID = (String)bgDecIds.get("mainFormId");
            refIds = (Map)bgDecIds.get("refIds");
            data = null;
            String mainSql = "update t_bg_bgdecomposerform set fkdtdata = ? where fid = ?";
            String valueSql = "select fdata from t_bg_bgform where fid = ?";
            batchValueSql = new StringBuffer("select fdata,fid from t_bg_bgform where fid in( ");
            conn = null;
            pstmtM = null;
            pstmtV = null;
            pstmt = null;
            batchPstmt = null;
            rst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("update t_bg_refbgdecform set fkdtdata = ? where fbgformid = ? and fbgdecomposerid = ?");
            conn = this.getConnection(ctx);
            pstmtV = conn.prepareStatement(valueSql);
            pstmtV.setString(1, mainFormID);
            rst = pstmtV.executeQuery();
            if (rst.next()) {
                data = BgInfoHelper.getBytes((ResultSet)rst, (int)1);
            }
            pstmtM = conn.prepareStatement(mainSql);
            pstmtM.setBytes(1, data);
            pstmtM.setString(2, decId);
            pstmtM.executeUpdate();
            pstmt = conn.prepareStatement(sql.toString());
            if (refIds != null && !refIds.isEmpty()) break block12;
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            SQLUtils.cleanup((Statement)pstmtM);
            SQLUtils.cleanup((Statement)pstmtV);
            SQLUtils.cleanup(batchPstmt);
            return;
        }
        try {
            for (String id : refIds.keySet()) {
                batchValueSql.append("'" + id + "',");
            }
            batchValueSql.delete(batchValueSql.length() - 1, batchValueSql.length()).append(")");
            batchPstmt = conn.prepareStatement(batchValueSql.toString());
            SQLUtils.cleanup((ResultSet)rst);
            rst = batchPstmt.executeQuery();
            HashMap<String, byte[]> valueMap = new HashMap<String, byte[]>();
            while (rst.next()) {
                byte[] datas = BgInfoHelper.getBytes((ResultSet)rst, (int)1);
                String fid = rst.getString(2);
                valueMap.put(fid, datas);
            }
            for (String id : refIds.keySet()) {
                data = (byte[])valueMap.get(id);
                pstmt.setBytes(1, data);
                pstmt.setString(2, id);
                pstmt.setString(3, decId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (IOException ex3) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                SQLUtils.cleanup(pstmtM);
                SQLUtils.cleanup((Statement)pstmtV);
                SQLUtils.cleanup(batchPstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup((Statement)pstmtM);
        SQLUtils.cleanup((Statement)pstmtV);
        SQLUtils.cleanup((Statement)batchPstmt);
        return;
    }

    @Override
    protected Object[] _calculate(Context ctx, String bgFormId, String mainFormId, String bgDecId, Map adjustMap) throws BOSException, EASBizException {
        if (bgFormId == null || mainFormId == null || bgDecId == null) {
            return null;
        }
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(bgFormId);
        ObjectUuidPK mainPk = new ObjectUuidPK(mainFormId);
        if (!iBgForm.exists((IObjectPK)pk)) {
            return null;
        }
        if (!iBgForm.exists((IObjectPK)mainPk)) {
            return null;
        }
        byte[] newData = null;
        Object[] obj = null;
        String key2 = null;
        BgFormInfo info = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), this.getBgFormInfoToRefCal());
        info.put("myBgPeriod", info.getBgPeriod());
        try {
            if (info.getId().toString().equals(mainFormId)) {
                key2 = "from`" + info.getId().toString();
                newData = this.getMainNewData(ctx, info.getId(), bgDecId);
            } else {
                key2 = "ref`" + info.getId().toString();
                newData = this.getRefNewData(ctx, info.getId(), bgDecId);
            }
            if (newData != null) {
                info.setData(this.getNewDataToRefCal(newData, IOHelper.unpackBook((byte[])newData), info.getId(), adjustMap));
            } else if (info.getData() != null) {
                info.setData(this.getNewDataToRefCal(info.getData(), IOHelper.unpackBook((byte[])info.getData()), info.getId(), adjustMap));
            }
            HashMap<String, BigDecimal> newAdjustMap = new HashMap<String, BigDecimal>();
            if (!adjustMap.isEmpty()) {
                BgAdjustFormDiversityData value = null;
                for (String key2 : adjustMap.keySet()) {
                    value = (BgAdjustFormDiversityData)adjustMap.get(key2);
                    key2 = info.getOrgUnit().getId().toString() + "!" + info.getBgScheme().getId().toString() + "!" + key2;
                    newAdjustMap.put(key2, value.getNewValue());
                }
            }
            BgNFSHelper.setFormulaMap((BgFormInfo)info, newAdjustMap);
            ArrayList tableData = ReportFactory.getLocalInstance((Context)ctx).backCalcEx((IObjectValue)info, info.getZipData(), null);
            obj = this._updateBgFormData(ctx, bgFormId, (IObjectValue)info, tableData);
            this._updateDataToBgTmpData(ctx, info.getId().toString(), obj[0]);
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        Object[] result = new Object[2];
        if (obj != null) {
            result[0] = obj[0];
            result[1] = bgFormId.equals(mainFormId) ? (Map)obj[2] : null;
            RefBgDecFormInfo refInfo = new RefBgDecFormInfo();
            HashMap<String, RefBgDecFormInfo> dataMap = new HashMap<String, RefBgDecFormInfo>();
            refInfo.setKdtData((byte[])obj[1]);
            dataMap.put(key2, refInfo);
            if (refInfo != null) {
                this._updateDataForForm(ctx, bgDecId, dataMap);
            }
        }
        return result;
    }

    private byte[] getNewDataToRefCal(byte[] data, Book book, BOSUuid bgFormId, Map adjustMap) throws Exception {
        if (adjustMap == null || adjustMap.isEmpty() || adjustMap.toString().equals("{}")) {
            return data;
        }
        if (book == null) {
            return data;
        }
        Sheet table = null;
        ArrayList<String> formulaList = new ArrayList<String>();
        ArrayList<String> valueList = new ArrayList<String>();
        ArrayList<String> valueRow = new ArrayList<String>();
        ArrayList<String> valueCol = new ArrayList<String>();
        ArrayList<String> isCtrl = new ArrayList<String>();
        ArrayList<String> isFlexCtrl = new ArrayList<String>();
        ArrayList<String> flexCtrlParam = new ArrayList<String>();
        ArrayList<String> periodCtrlPolicy = new ArrayList<String>();
        ArrayList<String> isGroupCtrl = new ArrayList<String>();
        ArrayList<String> groupCtrlNo = new ArrayList<String>();
        ArrayList<String> isAllowAccess = new ArrayList<String>();
        int rowIndex = 0;
        int colIndex = 0;
        int rowCount = 0;
        int colCount = 0;
        String formulaString = null;
        String ctrlString = null;
        BgFormDiversityData adjustData = null;
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        for (int n = 0; n < book.getSheetCount(); ++n) {
            table = book.getSheet(n);
            rowCount = table.getMaxRowIndex() + 1;
            colCount = table.getMaxColIndex() + 1;
            for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex < colCount; ++colIndex) {
                    Cell cell = table.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) continue;
                    formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell);
                    if (adjustMap.containsKey(formulaString)) {
                        adjustData = (BgFormDiversityData)adjustMap.get(formulaString);
                        if (adjustData == null || adjustData.getNewValue() == null) {
                            BgNFSHelper.setValue((Cell)cell, null);
                            BgNFSHelper.getItemFormula((Cell)cell).putExt("BG_BUDGET_VALUE", null);
                        } else {
                            BgNFSHelper.setValue((Cell)cell, (Object)adjustData.getNewValue());
                            BgNFSHelper.getItemFormula((Cell)cell).putExt("BG_BUDGET_VALUE", adjustData.getNewValue().toString());
                        }
                        if (adjustData.getOldValue() == null) {
                            adjustData.setOldValue(BgConstants.BIGZERO);
                        }
                        if (adjustData.getNewValue().compareTo(adjustData.getOldValue()) != 0) {
                            BgNFSHelper.setBackGroup((Cell)cell, (Color)BgSHelper.EDIT_COLOR);
                        }
                    }
                    if (!BgNFSHelper.checkCanEditFormulaOfCell((Cell)cell)) continue;
                    formulaList.add(formulaString);
                    if (adjustMap.containsKey(formulaString)) {
                        adjustData = (BgFormDiversityData)adjustMap.get(formulaString);
                        if (adjustData == null || adjustData.getNewValue() == null) {
                            valueList.add("0");
                        } else {
                            valueList.add(adjustData.getNewValue().toString());
                        }
                    } else if (cell.getValue() != Variant.nullVariant) {
                        valueList.add(cell.getValue().toString());
                    } else {
                        valueList.add("0");
                    }
                    valueRow.add(String.valueOf(rowIndex));
                    valueCol.add(String.valueOf(colIndex));
                    ctrlString = BgNFSHelper.getItemFormula((Cell)cell).getExt("isCtrl");
                    if (ctrlString == null || ctrlString.trim().length() == 0) {
                        isCtrl.add(null);
                    } else {
                        isCtrl.add(ctrlString);
                    }
                    ctrlString = BgNFSHelper.getItemFormula((Cell)cell).getExt("isFlexCtrl");
                    if (ctrlString == null || ctrlString.trim().length() == 0) {
                        isFlexCtrl.add(null);
                    } else {
                        isFlexCtrl.add(ctrlString);
                    }
                    ctrlString = BgNFSHelper.getItemFormula((Cell)cell).getExt("flexCtrlParam");
                    if (ctrlString == null || ctrlString.trim().length() == 0) {
                        flexCtrlParam.add(null);
                    } else {
                        flexCtrlParam.add(ctrlString);
                    }
                    ctrlString = BgNFSHelper.getItemFormula((Cell)cell).getExt("periodCtrlPolicy");
                    if (ctrlString == null || ctrlString.trim().length() == 0) {
                        periodCtrlPolicy.add(null);
                    } else {
                        periodCtrlPolicy.add(ctrlString);
                    }
                    ctrlString = BgNFSHelper.getItemFormula((Cell)cell).getExt("isGroupCtrl");
                    if (ctrlString == null || ctrlString.trim().length() == 0) {
                        isGroupCtrl.add(null);
                    } else {
                        isGroupCtrl.add(ctrlString);
                    }
                    ctrlString = BgNFSHelper.getItemFormula((Cell)cell).getExt("groupCtrlNo");
                    if (ctrlString == null || ctrlString.trim().length() == 0) {
                        groupCtrlNo.add(null);
                    } else {
                        groupCtrlNo.add(ctrlString);
                    }
                    ctrlString = BgNFSHelper.getItemFormula((Cell)cell).getExt("isAllowAccess");
                    if (ctrlString == null || ctrlString.trim().length() == 0) {
                        isAllowAccess.add(null);
                        continue;
                    }
                    isAllowAccess.add(ctrlString);
                }
            }
        }
        return IOHelper.packBook((Book)book);
    }

    private byte[] getRefNewData(Context ctx, BOSUuid uuid, String bgDecId) throws Exception {
        RefBgDecFormInfo info = RefBgDecFormFactory.getLocalInstance(ctx).getRefBgDecFormInfo("select id , kdtData where bgDecomposer.id = '" + bgDecId + "' and bgForm.id = '" + uuid.toString() + "'");
        return info == null ? null : info.getKdtData();
    }

    private byte[] getMainNewData(Context ctx, BOSUuid uuid, String bgDecId) throws Exception {
        BgDecomposerFormInfo info = BgDecomposerFormFactory.getLocalInstance(ctx).getBgDecomposerFormInfo("select id, kdtData where id = '" + bgDecId + "'");
        return info == null ? null : info.getKdtData();
    }

    public SelectorItemCollection getBgFormInfoToRefCal() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add("startDate");
        sic.add("endDate");
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.precision"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("sourceType"));
        return sic;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _updateAdjustData(Context ctx, String id, Map adjustMap) throws BOSException, EASBizException {
        if (id == null) return;
        if (adjustMap == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bgForm.id"));
        sic.add(new SelectorItemInfo("refBgDecForms.id"));
        sic.add(new SelectorItemInfo("refBgDecForms.bgForm.id"));
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BgDecomposerFormInfo info = this.getBgDecomposerFormInfo(ctx, (IObjectPK)pk, sic);
        String maiFormSql = "update T_BG_BgDecomposerForm set FAdjustMapData = ? where FId = ?";
        String entryFormSql = "update T_BG_RefBgDecForm set FAdjustMapData = ? where FId = ?";
        BgFormInfo bgFormInfo = null;
        Connection conn = null;
        PreparedStatement mainPrst = null;
        PreparedStatement entryPrst = null;
        try {
            conn = this.getConnection(ctx);
            BOSUuid mainBgFormId = info.getBgForm().getId();
            if (adjustMap.containsKey(mainBgFormId)) {
                HashMap childAdjMap = (HashMap)adjustMap.get(mainBgFormId);
                if (childAdjMap != null && !childAdjMap.isEmpty()) {
                    bgFormInfo = BgFSHelper.getBgFormInfo(conn, mainBgFormId, false);
                    BgNAdjHelper.createTmpDataOfFormula((Context)ctx, (Connection)conn, (BOSUuid)bgFormInfo.getOrgUnit().getId(), (BOSUuid)bgFormInfo.getBgScheme().getId(), (BOSUuid)bgFormInfo.getBgTemplate().getId(), (BOSUuid)bgFormInfo.getId(), (Map)childAdjMap);
                } else {
                    SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + mainBgFormId.toString() + "'"));
                }
                mainPrst = conn.prepareStatement(maiFormSql);
                mainPrst.setBytes(1, BgHelper.storeHashMapToByte(childAdjMap));
                mainPrst.setString(2, info.getId().toString());
                mainPrst.executeUpdate();
                childAdjMap.clear();
            }
            RefBgDecFormInfo refInfo = null;
            entryPrst = conn.prepareStatement(entryFormSql);
            int size = info.getRefBgDecForms().size();
            for (int i = 0; i < size; ++i) {
                refInfo = info.getRefBgDecForms().get(i);
                BOSUuid entryFormId = refInfo.getBgForm().getId();
                if (!adjustMap.containsKey(entryFormId)) continue;
                HashMap childAdjMap = (HashMap)adjustMap.get(entryFormId);
                if (childAdjMap != null && !childAdjMap.isEmpty()) {
                    bgFormInfo = BgFSHelper.getBgFormInfo(conn, entryFormId, false);
                    BgFSHelper.createTmpDataOfFormula(ctx, conn, bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgScheme().getId(), bgFormInfo.getBgTemplate().getId(), bgFormInfo.getId(), childAdjMap);
                } else {
                    SQLUtils.execute((Connection)conn, (String)("delete from T_BG_BgTmpData where FBgFormId = '" + entryFormId.toString() + "'"));
                }
                entryPrst.setBytes(1, BgHelper.storeHashMapToByte(childAdjMap));
                entryPrst.setString(2, refInfo.getId().toString());
                entryPrst.addBatch();
                childAdjMap.clear();
            }
            entryPrst.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (IOException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(mainPrst, (Connection)conn);
                SQLUtils.cleanup(entryPrst);
                throw throwable;
            }
        }
        SQLUtils.cleanup(mainPrst, (Connection)conn);
        SQLUtils.cleanup((Statement)entryPrst);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _saveKdf(Context ctx, String id, byte[] data) throws BOSException, EASBizException {
        if (id == null) return;
        if (data == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgDecomposerForm set FKdtData = ? where FId = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setBytes(1, data);
            pstmt.setString(2, id);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

