/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgElementException;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.app.AbstractBgElementControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class BgElementControllerBean
extends AbstractBgElementControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgElementControllerBean");
    private static final String SYS_ELEMENT_NUMBER = "01";

    @Override
    protected boolean _checkElementInfo(Context ctx, IObjectValue bgElementInfo) throws BOSException, EASBizException {
        boolean re = false;
        if (bgElementInfo == null) {
            return re;
        }
        if (this.checkBgElementInfo(ctx, (BgElementInfo)bgElementInfo)) {
            re = true;
        }
        return re;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (this.isSameNumOrName(ctx, model)) {
            super._addnew(ctx, pk, model);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!this.isSameNumOrName(ctx, model)) {
            return super._addnew(ctx, model);
        }
        return null;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (!this.isSameNumOrName(ctx, model)) {
            if (!this.isUse(ctx, pk)) {
                super._update(ctx, pk, model);
            } else {
                throw new BgElementException(BgElementException.ISUSE);
            }
        }
    }

    private boolean checkBgElementInfo(Context ctx, BgElementInfo bgElementInfo) throws EASBizException, BOSException {
        boolean re = true;
        FilterInfo filter = null;
        FilterItemInfo filterItem = null;
        filter = new FilterInfo();
        filterItem = new FilterItemInfo("number", (Object)bgElementInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("name", (Object)bgElementInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (bgElementInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)bgElementInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        re = this._exists(ctx, filter);
        filterItem = null;
        filter.clear();
        filter = null;
        return re;
    }

    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (!this.isUse(ctx, pk)) {
            if (this.isSysSet(ctx, pk)) {
                throw new BgElementException(BgElementException.ISSYSSET);
            }
        } else {
            throw new BgElementException(BgElementException.ISUSE);
        }
        super.delete(ctx, pk);
    }

    private boolean isSysSet(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IRowSet rs;
        block5: {
            boolean bl;
            if (pk == null) {
                return false;
            }
            String sql = "select fid from t_bg_bgelement where FID = ? and FNumber = ?";
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{pk.toString(), SYS_ELEMENT_NUMBER});
                if (!rs.next()) break block5;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"budget error:", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return false;
    }

    private boolean isUse(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        boolean isUsed = false;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int result = 0;
        try {
            String sql = " select count(fid) cnt from t_bg_bgtemRefBgElement where fbgelementid = ? ";
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, pk.toString());
            rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        if (result > 0) {
            isUsed = true;
        }
        return isUsed;
    }

    private boolean isSameNumOrName(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isSame = false;
        BgElementInfo info = (BgElementInfo)model;
        String elementNum = info.getNumber();
        String elementName = info.getName();
        BOSUuid elementId = info.getId();
        String sql1 = null;
        String sql2 = null;
        IBgElement bgElement = BgElementFactory.getLocalInstance(ctx);
        BgElementInfo infoself = null;
        BgElementInfo infoself2 = null;
        if (elementId != null) {
            sql1 = "select id where number='" + elementNum + "' and id <> '" + elementId.toString() + "'";
            sql2 = "select id where name ='" + elementName + "' and id <> '" + elementId.toString() + "'";
        } else {
            sql1 = "select id where number='" + elementNum + "'";
            sql2 = "select id where name ='" + elementName + "'";
        }
        try {
            infoself = bgElement.getBgElementInfo(sql1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            infoself2 = bgElement.getBgElementInfo(sql2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (infoself != null) {
            isSame = true;
            throw new BgElementException(BgElementException.HAVENUMBER, new String[]{elementNum});
        }
        if (infoself2 != null) {
            isSame = true;
            throw new BgElementException(BgElementException.HAVENAME, new String[]{elementName});
        }
        return isSame;
    }
}

