/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.ReferenceExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgExamineCitationCollection;
import com.kingdee.eas.ma.budget.BgExamineCitationInfo;
import com.kingdee.eas.ma.budget.BgExamineCollection;
import com.kingdee.eas.ma.budget.BgExamineException;
import com.kingdee.eas.ma.budget.BgExamineFactory;
import com.kingdee.eas.ma.budget.BgExamineInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormExamineResultFactory;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgGatherHelper;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgUtilsHelper;
import com.kingdee.eas.ma.budget.IBgExamine;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.app.AbstractBgExamineFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BgExamineFacadeControllerBean
extends AbstractBgExamineFacadeControllerBean {
    private static final long serialVersionUID = -2626068285054869020L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgExamineFacadeControllerBean");
    private static final String tmpId = "HGFEDCBA";
    private static int budgetValue = 0;
    private static int actualValue = 1;
    private static int balanceValue = 2;
    private static int bgFormulaValue = 3;
    private static final String MATCH_STR = "\\-?\\d+";
    private Calendar calendar = Calendar.getInstance();

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("CU.id");
        sic.add("examineGroup.*");
        sic.add("formula");
        sic.add("formulaAlias");
        sic.add("compareValue");
        sic.add("compareType");
        sic.add("hint");
        sic.add("citation.*");
        sic.add("citation.costCenter.id");
        sic.add("citation.bgScheme.id");
        sic.add("citation.bgTemplate.id");
        sic.add("orgUnit.id");
        sic.add("bgScheme.id");
        sic.add("bgTemplate.id");
        sic.add("noPass");
        sic.add("errorData");
        return sic;
    }

    private SelectorItemCollection getBgFormInfo() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("orgUnit.id");
        sic.add("bgScheme.id");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.formType");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        sic.add("adjust.id");
        sic.add("state");
        return sic;
    }

    protected String[] getTableName(Context ctx, Connection conn) throws EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String[] result = new String[2];
        try {
            StringBuffer createSql = new StringBuffer();
            createSql.append("Create Table BgExamineCheck  (FGroupId varChar(44), FSeq int, FOrgUnitId VarChar(44), FBgSchemeId VarChar(44), FBgFormId VarChar(44), FFormula nVarchar(200), FValue decimal(21,6), FItemCombinNumber nVarChar(200), FElementNumber nVarChar(80), FBgPeriodNumber nVarChar(80), FCurrencyNumber nVarChar(80))");
            String tabname = pool.createTempTable(createSql.toString());
            pool.createIndex(tabname, "FOrgUnitId, FBgSchemeId, FFormula", false, false);
            pool.createIndex(tabname, "FGroupId, FSeq", false, true);
            result[0] = tabname;
            result[1] = "true";
        }
        catch (Exception e) {
            result[0] = "";
            result[1] = "false";
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return result;
    }

    protected boolean createTable(Context ctx, String tableName, Connection conn) throws EASBizException {
        if (tableName == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        StringBuffer sql = new StringBuffer();
        StringBuffer cIndex = new StringBuffer();
        StringBuffer index = new StringBuffer();
        sql.append("Create Table " + tableName + " (FGroupId varChar(44), FSeq int, FOrgUnitId VarChar(44), FBgSchemeId VarChar(44), FBgFormId VarChar(44), FFormula nVarchar(200), FValue decimal(21,6), FItemCombinNumber nVarChar(200), FElementNumber nVarChar(80), FBgPeriodNumber nVarChar(80), FCurrencyNumber nVarChar(80))");
        cIndex.append("CREATE Clustered INDEX PX_" + tableName + " ON " + tableName + "(FGroupId, FSeq)");
        index.append("CREATE INDEX IX_" + tableName + " ON " + tableName + "(FOrgUnitId, FBgSchemeId, FFormula)");
        try {
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(sql.toString());
            SQLUtils.execute((Connection)conn, (String)cIndex.toString());
            SQLUtils.execute((Connection)conn, (String)index.toString());
        }
        catch (SQLException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BgException(BgException.DATABASEERROR, new String[]{e.getMessage()});
        }
        return true;
    }

    protected boolean removeTable(Context ctx, String tableName, Connection conn) throws EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
        return true;
    }

    protected void clearTable(Context ctx, String tableName, Connection conn) throws EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Truncate Table " + tableName);
        try {
            SQLUtils.execute((Connection)conn, (String)sql.toString());
        }
        catch (SQLException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean canExamine(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block7: {
            boolean bl;
            if (model == null) {
                throw new BgFormException(BgFormException.NOBGFORMINFO);
            }
            IBgExamine ibgExamine = null;
            conn = null;
            pstmt = null;
            rst = null;
            try {
                ibgExamine = BgExamineFactory.getLocalInstance(ctx);
                if (ibgExamine == null) {
                    throw new BgException(BgException.NOINSTANCE);
                }
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement("select FBgExamineId from T_BG_BgExamineNode where FBgTemplateId = ?");
                pstmt.setString(1, ((BgFormInfo)model).getBgTemplate().getId().toString());
                rst = pstmt.executeQuery();
                if (!rst.next()) break block7;
                bl = true;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"budget error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                    catch (BOSException ex2) {
                        logger.error((Object)"budget error:", (Throwable)ex2);
                        throw ex2;
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IObjectCollection getExamine(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        BgExamineCollection bgExamineCol = null;
        IBgExamine ibgExamine = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashSet<String> bgExamineIdSet = new HashSet<String>();
        try {
            ibgExamine = BgExamineFactory.getLocalInstance(ctx);
            if (ibgExamine == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FBgExamineId from T_BG_BgExamineNode where FBgTemplateId = ?");
            pstmt.setString(1, ((BgFormInfo)model).getBgTemplate().getId().toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgExamineIdSet.add(rst.getString(1));
            }
            if (!bgExamineIdSet.isEmpty()) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", bgExamineIdSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("isUse", (Object)Boolean.TRUE, CompareType.EQUALS));
                view.setFilter(filter);
                view.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
                SorterItemInfo sort = new SorterItemInfo("number");
                sort.setSortType(SortType.ASCEND);
                view.getSorter().add(sort);
                bgExamineCol = ibgExamine.getBgExamineCollection(view);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgExamineCol;
    }

    @Override
    protected Object[] _examines(Context ctx, BOSUuid[] id, String xNum) throws BOSException, EASBizException {
        if (id == null || id.length == 0) {
            throw new BgExamineException(BgExamineException.BGFORMINFOIDCANTISNULL);
        }
        Map currencyMap = null;
        Map tmpMap = null;
        currencyMap = BgSHelper.getCurrencyInfo(ctx, currencyMap, null);
        Object[] examineCheck = new Object[3];
        examineCheck[0] = Boolean.TRUE;
        examineCheck[2] = currencyMap;
        for (int i = 0; i < id.length; ++i) {
            this._examine(ctx, id[i], examineCheck, xNum);
        }
        if (examineCheck[1] instanceof HashMap) {
            tmpMap = (Map)examineCheck[1];
            examineCheck[1] = BgUtilsHelper.encodeObject(tmpMap);
        }
        examineCheck[2] = null;
        return examineCheck;
    }

    @Override
    protected Object[] _examine(Context ctx, BOSUuid id, Object[] check, String xNum) throws BOSException, EASBizException {
        Object[] examineCheck;
        block15: {
            if (id == null) {
                throw new BgExamineException(BgExamineException.BGFORMINFOIDCANTISNULL);
            }
            Connection conn = null;
            BgFormInfo bgFormInfo = null;
            BgExamineInfo bgExamineInfo = null;
            BgExamineCollection bgExamineCol = null;
            String tmpTableName = null;
            boolean isCreate = false;
            Map examineMap = null;
            examineCheck = check == null ? new Object[2] : check;
            Object object = examineCheck[0] = examineCheck[0] == null ? Boolean.TRUE : examineCheck[0];
            if (examineCheck[1] == null || !(examineCheck[1] instanceof HashMap)) {
                examineMap = new HashMap();
                examineMap.put("EXAMINE_PASS", new HashMap());
                examineMap.put("EXAMINE_PASS_SET", new HashMap());
                examineMap.put("EXAMINE_NOPASS", new HashMap());
                examineCheck[1] = examineMap;
            } else {
                examineMap = (Map)examineCheck[1];
            }
            ObjectUuidPK pk = new ObjectUuidPK(id);
            try {
                conn = this.getConnection(ctx);
                bgFormInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)pk, this.getBgFormInfo());
                int _state = bgFormInfo.getState().getValue();
                if (4 == _state || 35 == _state) {
                    pk = new ObjectUuidPK(bgFormInfo.getAdjust().getId());
                    bgFormInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)pk, this.getBgFormInfo());
                }
                if ((bgExamineCol = (BgExamineCollection)this.getExamine(ctx, (IObjectValue)bgFormInfo)) == null || bgExamineCol.isEmpty()) break block15;
                String[] result = this.getTableName(ctx, conn);
                tmpTableName = result[0];
                isCreate = Boolean.valueOf(result[1]);
                if (isCreate) {
                    Iterator iter = bgExamineCol.iterator();
                    while (iter.hasNext()) {
                        bgExamineInfo = (BgExamineInfo)iter.next();
                        this.checkBgExamine(bgExamineInfo);
                        this.builderExamineData(ctx, conn, tmpTableName, bgExamineInfo, bgFormInfo, xNum);
                        try {
                            this.checkBgExamineData(ctx, conn, tmpTableName, examineCheck, examineMap, bgExamineInfo, bgFormInfo, xNum);
                        }
                        catch (Exception e) {
                            throw new BgExamineException(BgExamineException.ERROROFCREATETABLE);
                        }
                    }
                    break block15;
                }
                throw new BgExamineException(BgExamineException.ERROROFCREATETABLE);
            }
            catch (BOSException ex) {
                logger.error((Object)"", (Throwable)ex);
                throw new BgExamineException(BgExamineException.ERROROFCIAATION);
            }
            catch (EASBizException ex) {
                logger.error((Object)"", (Throwable)ex);
                throw new BgExamineException(BgExamineException.ERROROFCIAATION);
            }
            finally {
                if (isCreate) {
                    this.removeTable(ctx, tmpTableName, conn);
                }
                SQLUtils.cleanup((Connection)conn);
            }
        }
        BgFormExamineResultFactory.getLocalInstance(ctx).saveExamineResult(id.toString(), examineCheck);
        return examineCheck;
    }

    protected void checkBgExamine(BgExamineInfo bgExamineInfo) throws EASBizException {
        if (bgExamineInfo == null) {
            return;
        }
        if (bgExamineInfo.getFormula() == null || bgExamineInfo.getFormula().trim().length() == 0 || bgExamineInfo.getFormulaAlias() == null || bgExamineInfo.getFormulaAlias().trim().length() == 0) {
            throw new BgExamineException(BgExamineException.ERROROFFORMULA);
        }
        if (bgExamineInfo.getErrorData() == null) {
            throw new BgExamineException(BgExamineException.ERROROFCONFINE);
        }
        if (bgExamineInfo.getCitation() == null || bgExamineInfo.getCitation().size() == 0) {
            throw new BgExamineException(BgExamineException.ERROROFCIAATION);
        }
        BgExamineCitationInfo bgExamCitaInfo = null;
        int n = bgExamineInfo.getCitation().size();
        for (int i = 0; i < n; ++i) {
            bgExamCitaInfo = bgExamineInfo.getCitation().get(i);
            if (bgExamCitaInfo.getFormula() != null && bgExamCitaInfo.getFormula().trim().length() != 0 && bgExamCitaInfo.getFormulaAlias() != null && bgExamCitaInfo.getFormulaAlias().trim().length() != 0) continue;
            throw new BgExamineException(BgExamineException.ERROROFFORMULA);
        }
    }

    protected void builderExamineData(Context ctx, Connection conn, String tmpTableName, BgExamineInfo bgExamineInfo, BgFormInfo bgFormInfo, String num) throws BOSException, EASBizException {
        Object formulaMap = null;
        HashMap formulaParMap = new HashMap();
        try {
            this.clearTable(ctx, tmpTableName, conn);
            this.builderTmpFormulaData(ctx, conn, tmpTableName, bgFormInfo, bgExamineInfo, num);
            this.builderUpdateFormulaGroupId(conn, tmpTableName, bgExamineInfo);
            this.builderOtherFormulaData(ctx, conn, tmpTableName, bgFormInfo, bgExamineInfo, num);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
    }

    protected void builderTmpFormulaData(Context ctx, Connection conn, String tmpTableName, BgFormInfo bgFormInfo, BgExamineInfo bgExamineInfo, String num) throws BOSException, EASBizException {
        PreparedStatement pstmt = null;
        int bgPeriodType = 0;
        StringBuffer sql = null;
        StringBuffer sql1 = null;
        StringBuffer other = null;
        BgExamineCitationInfo bgExCitInfo = null;
        this.updateBgExamineCitation(ctx, conn, bgExamineInfo, num, bgFormInfo);
        try {
            Iterator iter = bgExamineInfo.getCitation().iterator();
            while (iter.hasNext()) {
                bgExCitInfo = (BgExamineCitationInfo)iter.next();
                if (bgExCitInfo.getFormulaAlias().indexOf("BGBAL") == 0 || bgExCitInfo.getFormulaAlias().indexOf("BGACTUALS") == 0 || bgExCitInfo.getFormulaAlias().indexOf("BGFORMULA") == 0) {
                    this.builderTmpExpressionData(ctx, conn, tmpTableName, bgFormInfo, bgExCitInfo);
                    continue;
                }
                ArrayList<Object> _tmpList = new ArrayList<Object>();
                bgPeriodType = BgExamineFacadeControllerBean.getBgPeriodType(bgExCitInfo.getBgPeriodNumber());
                sql = new StringBuffer();
                sql1 = new StringBuffer();
                other = new StringBuffer();
                sql.append("Insert Into " + tmpTableName + " (FGroupId, FSeq, FOrgUnitId, FBgSchemeId, FBgFormId, FFormula, FValue, FItemCombinNumber, FElementNumber, FBgPeriodNumber, FCurrencyNumber) ");
                sql.append("Select newbosid('HGFEDCBA'), ");
                sql1.append(", t.FOrgUnitId, t.FBgSchemeId, t.FBgFormId, t.FFormula, t.FBgValue, i.FKey, e.fnumber, p.fnumber, c.fnumber from T_BG_BgData t  left outer join T_BG_BgItemCombination i on t.FBgItemCombinId = i.FId left outer join T_BG_BgElement e on t.FBgElementId = e.FId left outer join T_BG_BgPeriod p on t.FBgPeriodId = p.FId left outer join T_BD_Currency c on t.FCurrencyId = c.FId where t.FOrgUnitId = ? and t.FBgSchemeId = ? and t.FBgFormId = ? and t.FFormula like ?");
                other.append(", t.FOrgUnitId, t.FBgSchemeId, t.FBgFormId, t.FFormula, t.FBgValue, i.FKey, e.fnumber, p.fnumber, c.fnumber from T_BG_BgData t  left outer join T_BG_BgItemCombination i on t.FBgItemCombinId = i.FId left outer join T_BG_BgElement e on t.FBgElementId = e.FId left outer join T_BG_BgPeriod p on t.FBgPeriodId = p.FId left outer join T_BD_Currency c on t.FCurrencyId = c.FId where ");
                if (bgPeriodType == 0) {
                    if (bgExCitInfo.getOrgUnit() == null || bgExCitInfo.getBgScheme() == null) {
                        sql.append(String.valueOf(bgExCitInfo.getSeq()));
                        sql.append(sql1);
                        _tmpList.add(bgFormInfo.getOrgUnit().getId().toString());
                        _tmpList.add(bgFormInfo.getBgScheme().getId().toString());
                        _tmpList.add(bgFormInfo.getId().toString());
                        _tmpList.add(bgExCitInfo.getFormula());
                    } else {
                        sql.append(String.valueOf(bgExCitInfo.getSeq()));
                        sql.append(other);
                        sql.append(" t.FOrgUnitId = ? and t.FBgSchemeId = ?  and t.FFormula like ? ");
                        _tmpList.add(bgExCitInfo.getOrgUnit().getId().toString());
                        _tmpList.add(bgExCitInfo.getBgScheme().getId().toString());
                        _tmpList.add(bgExCitInfo.getFormula());
                    }
                } else if (bgExCitInfo.getOrgUnit() == null || bgExCitInfo.getBgScheme() == null) {
                    sql.append(String.valueOf(bgExCitInfo.getSeq()));
                    sql.append(sql1);
                    sql.append(" and p.FPeriodType = ?");
                    _tmpList.add(bgFormInfo.getOrgUnit().getId().toString());
                    _tmpList.add(bgFormInfo.getBgScheme().getId().toString());
                    _tmpList.add(bgFormInfo.getId().toString());
                    _tmpList.add(bgExCitInfo.getFormula());
                    _tmpList.add(new Integer(bgPeriodType));
                } else {
                    sql.append(String.valueOf(bgExCitInfo.getSeq()));
                    sql.append(other);
                    sql.append(" t.FOrgUnitId = ? and t.FBgSchemeId = ? and t.FFormula like ? ");
                    sql.append(" and p.FPeriodType = ?");
                    _tmpList.add(bgExCitInfo.getOrgUnit().getId().toString());
                    _tmpList.add(bgExCitInfo.getBgScheme().getId().toString());
                    _tmpList.add(bgExCitInfo.getFormula());
                    _tmpList.add(new Integer(bgPeriodType));
                }
                if (bgFormInfo.getBgTemplate().getFormType().getValue() == 4) {
                    sql.append(" and t.FId in (select FBGDATAID from T_BG_bgDataEntry where FBgFormId = ?)");
                } else {
                    sql.append(" and t.FFormula in (Select FFormula from T_BG_BgData where FBgFormId = ?)");
                }
                _tmpList.add(bgFormInfo.getId().toString());
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
                    pstmt.executeUpdate();
                }
                catch (SQLException ex) {
                    try {
                        logger.error((Object)"budget error:", (Throwable)ex);
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(pstmt);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)pstmt);
                this.builderTmpFormulaTmpData(ctx, conn, tmpTableName, bgFormInfo, bgExCitInfo, bgPeriodType, "t.fbgvalue", 0);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(pstmt);
        }
    }

    protected void updateBgExamineCitation(Context ctx, Connection conn, BgExamineInfo bgExamineInfo, String num, BgFormInfo bgFormInfo) throws BgException {
        Expression expression = null;
        Expression expr2 = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Vector orgunitid = new Vector();
        Vector schemeid = new Vector();
        Vector formulas = new Vector();
        List list = null;
        Vector<String> newFormulas = new Vector<String>();
        String[] orgParams = null;
        String orgUnitId = null;
        String orgUnitNum = null;
        String schemeId = null;
        String schemeNum = null;
        String forgunitid = null;
        String orgNum = null;
        String bgOrgUnitId = bgFormInfo.getOrgUnit().getId().toString();
        String bgScheneId = bgFormInfo.getBgScheme().getId().toString();
        HashSet<String> orgUnits = new HashSet<String>();
        HashSet<String> schemes = new HashSet<String>();
        HashSet<String> orgUnitsId = new HashSet<String>();
        HashSet<String> schemesId = new HashSet<String>();
        HashMap<String, String> orgIdAndNum = new HashMap<String, String>();
        HashMap<String, String> schemeNumAndschemeId = new HashMap<String, String>();
        HashMap<String, String> orgNumAndschemeId = new HashMap<String, String>();
        FullOrgUnitInfo unitInfo = null;
        BgSchemeInfo bgSchemeInfo = null;
        BgExamineCitationInfo bgExCionInfo = null;
        bgExamineInfo.getCitation().clear();
        try {
            Object selectschemeid;
            expression = ExcelFormulaPaserHelper.parse((String)bgExamineInfo.getFormula());
            expr2 = this.walk(ctx, expression, num, bgFormInfo.getBgPeriod().getNumber(), bgFormInfo.getBgPeriod().getPeriodType().getValue());
            bgExamineInfo.setFormula(expr2.toString());
            expression = ExcelFormulaPaserHelper.parse((String)bgExamineInfo.getFormula());
            this.walk(formulas, expression);
            for (int n = 0; n < formulas.size(); ++n) {
                list = TableToolkit.parseFormula((String)("=" + formulas.elementAt(n).toString()), (boolean)false);
                if (list == null || list.isEmpty()) continue;
                FormulaHint hint = (FormulaHint)list.get(0);
                String[] params = hint.getParams();
                orgParams = params[0].split(";");
                if (orgParams != null) {
                    for (String s : orgParams) {
                        newFormulas.add(hint.toString().replace(params[0], s));
                        if (s.equals("%")) continue;
                        orgUnits.add(s);
                    }
                }
                if (params[1].equals("%")) continue;
                schemes.add(params[1]);
            }
            StringBuffer str = new StringBuffer();
            StringBuffer strorg = new StringBuffer();
            if (!orgUnits.isEmpty()) {
                str.setLength(0);
                for (String s : orgUnits) {
                    str.append("'").append(s).append("'").append(" or fnumber = ");
                }
                str.delete(str.length() - 14, str.length());
                Iterator selectorgunitid = "select fid, fnumber from t_org_baseunit where fnumber = " + str.toString();
                try {
                    pstmt = conn.prepareStatement((String)((Object)selectorgunitid));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        orgUnitId = rs.getString("fid");
                        orgUnitNum = rs.getString("fnumber");
                        orgUnitsId.add(orgUnitId);
                        orgIdAndNum.put(orgUnitNum, orgUnitId);
                    }
                }
                catch (SQLException ex) {
                    try {
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, (Statement)pstmt);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
            }
            if (!schemes.isEmpty()) {
                if (!orgUnits.isEmpty()) {
                    str.setLength(0);
                    strorg.setLength(0);
                    for (String s : schemes) {
                        str.append("'").append(s).append("'").append(" or s.fnumber = ");
                    }
                    str.delete(str.length() - 16, str.length());
                    for (String s : orgUnits) {
                        strorg.append("'").append(s).append("'").append(" or o.fnumber = ");
                    }
                    strorg.delete(strorg.length() - 16, strorg.length());
                    selectschemeid = "select s.fid, s.fnumber, s.forgunitid, o.fnumber as orgnumber from T_bg_bgscheme s left join t_org_baseunit o on s.forgunitid = o.fid where (s.fnumber = " + str.toString() + ")and (o.fnumber = " + strorg.toString() + ")";
                    try {
                        pstmt = conn.prepareStatement((String)selectschemeid);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            forgunitid = rs.getString("forgunitid");
                            schemeId = rs.getString("fid");
                            schemeNum = rs.getString("fnumber");
                            orgNum = rs.getString("orgnumber");
                            schemesId.add(schemeId);
                            orgNumAndschemeId.put(orgNum, schemeId);
                        }
                    }
                    catch (SQLException ex) {
                        throw ex;
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                    }
                } else {
                    str.setLength(0);
                    for (String s : schemes) {
                        str.append("'").append(s).append("'").append(" or s.fnumber = ");
                    }
                    str.delete(str.length() - 16, str.length());
                    selectschemeid = "select s.fid, s.fnumber, s.forgunitid, o.fnumber as orgnumber from T_bg_bgscheme s left join t_org_baseunit o on s.forgunitid = o.fid where (s.fnumber = " + str.toString() + ")and s.forgunitid = '" + bgOrgUnitId + "'";
                    try {
                        pstmt = conn.prepareStatement((String)selectschemeid);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            forgunitid = rs.getString("forgunitid");
                            schemeId = rs.getString("fid");
                            schemeNum = rs.getString("fnumber");
                            orgNum = rs.getString("orgnumber");
                            schemesId.add(schemeId);
                            schemeNumAndschemeId.put(schemeNum, schemeId);
                        }
                    }
                    catch (SQLException ex) {
                        throw ex;
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                    }
                }
            } else if (!orgUnits.isEmpty()) {
                str.setLength(0);
                for (String s : orgUnits) {
                    str.append("'").append(s).append("'").append(" or o.fnumber = ");
                }
                str.delete(str.length() - 16, str.length());
                selectschemeid = "select s.fid, o.fnumber as orgnumber from T_bg_bgscheme s left join t_org_baseunit o on s.forgunitid = o.fid  where s.fnumber in ( select ss.fnumber from t_bg_bgscheme ss where ss.fid = '" + bgFormInfo.getBgScheme().getId().toString() + "') and s.forgunitid in  (select o.fid from t_org_baseunit where o.fnumber = " + str.toString() + ")";
                try {
                    pstmt = conn.prepareStatement((String)selectschemeid);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        schemeId = rs.getString("fid");
                        orgNum = rs.getString("orgnumber");
                        orgNumAndschemeId.put(orgNum, schemeId);
                    }
                }
                catch (SQLException ex) {
                    throw ex;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
                }
            }
            for (int n = 0; n < newFormulas.size(); ++n) {
                bgExCionInfo = new BgExamineCitationInfo();
                list = TableToolkit.parseFormula((String)("=" + newFormulas.elementAt(n).toString()), (boolean)false);
                if (list == null || list.isEmpty()) continue;
                FormulaHint hint = (FormulaHint)list.get(0);
                String[] newparams = new String[4];
                String[] params = hint.getParams();
                String bgItem = null;
                bgExCionInfo.put("valueType", new Integer(budgetValue));
                if (params.length == 6) {
                    if (hint.text.indexOf("BGITEM") == 0) {
                        bgItem = "=BgItem(\"" + params[2] + "\",\"" + params[5] + "\",\"" + params[3] + "\",\"BgData\",true,\"" + params[4] + "\")";
                        bgExCionInfo.put("valueType", new Integer(budgetValue));
                    } else if (hint.text.indexOf("BGBAL") == 0) {
                        bgItem = "=BgItem(\"" + params[2] + "\",\"" + params[5].replaceAll("X", "x") + "\",\"" + params[3] + "\",\"BgData\",true,\"" + params[4] + "\")";
                        bgExCionInfo.put("valueType", new Integer(balanceValue));
                    } else if (hint.text.indexOf("BGACTUALS") == 0) {
                        bgItem = "=BgItem(\"" + params[2] + "\",\"" + params[5].replaceAll("X", "x") + "\",\"" + params[3] + "\",\"BgData\",true,\"" + params[4] + "\")";
                        bgExCionInfo.put("valueType", new Integer(actualValue));
                    } else if (hint.text.indexOf("BGFORMULA") == 0) {
                        bgItem = "=BgItem(\"" + params[2] + "\",\"" + params[5].replaceAll("X", "x") + "\",\"" + params[3] + "\",\"BgData\",true,\"" + params[4] + "\")";
                        bgExCionInfo.put("valueType", new Integer(bgFormulaValue));
                    }
                }
                newparams[0] = params[2].equals("%") ? "" : params[2];
                newparams[1] = params[3].equals("%") ? "" : params[3];
                newparams[2] = params[4].equals("%") ? "" : params[4];
                newparams[3] = params[5].equals("%") ? "" : params[5];
                if (params[0].equals("%")) {
                    if (bgOrgUnitId != null) {
                        unitInfo = new FullOrgUnitInfo();
                        unitInfo.setId(BOSUuid.read((String)bgOrgUnitId));
                    }
                } else if (!((String)orgIdAndNum.get(params[0])).isEmpty()) {
                    unitInfo = new FullOrgUnitInfo();
                    unitInfo.setId(BOSUuid.read((String)((String)orgIdAndNum.get(params[0]))));
                }
                if (params[1].equals("%")) {
                    if (!params[0].equals("%")) {
                        if (orgNumAndschemeId.get(params[0]) != null) {
                            bgSchemeInfo = new BgSchemeInfo();
                            bgSchemeInfo.setId(BOSUuid.read((String)((String)orgNumAndschemeId.get(params[0]))));
                        }
                    } else if (bgScheneId != null) {
                        bgSchemeInfo = new BgSchemeInfo();
                        bgSchemeInfo.setId(BOSUuid.read((String)bgScheneId));
                    }
                } else if (!params[0].equals("%")) {
                    if (!((String)orgNumAndschemeId.get(params[0])).isEmpty()) {
                        bgSchemeInfo = new BgSchemeInfo();
                        bgSchemeInfo.setId(BOSUuid.read((String)((String)orgNumAndschemeId.get(params[0]))));
                    }
                } else if (schemeNumAndschemeId.get(params[1]) != null && !((String)schemeNumAndschemeId.get(params[1])).isEmpty()) {
                    bgSchemeInfo = new BgSchemeInfo();
                    bgSchemeInfo.setId(BOSUuid.read((String)((String)schemeNumAndschemeId.get(params[1]))));
                }
                bgExCionInfo.setId(BOSUuid.create((BOSObjectType)bgExCionInfo.getBOSType()));
                bgExCionInfo.setExamine(bgExamineInfo);
                bgExCionInfo.setFormula(bgItem);
                bgExCionInfo.setFormulaAlias(hint.toString());
                bgExCionInfo.setSeq(n + 1);
                bgExCionInfo.setBgItemCombinNumber(newparams[0]);
                bgExCionInfo.setBgElementNumber(newparams[1]);
                bgExCionInfo.setBgPeriodNumber(newparams[3]);
                bgExCionInfo.setCurrencyNumber(newparams[2]);
                bgExCionInfo.setBgScheme(bgSchemeInfo);
                bgExCionInfo.setOrgUnit(unitInfo);
                bgExamineInfo.getCitation().add(bgExCionInfo);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"examine error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rs, pstmt);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void builderTmpExpressionData(Context ctx, Connection conn, String tmpTableName, BgFormInfo bgFormInfo, BgExamineCitationInfo bgExCitInfo) throws EASBizException, BOSException {
        PreparedStatement pstmt = null;
        StringBuffer sql = null;
        StringBuffer sql1 = null;
        StringBuffer other = null;
        int bgPeriodType = 0;
        int valueType = -1;
        String colName = null;
        bgPeriodType = BgExamineFacadeControllerBean.getBgPeriodType(bgExCitInfo.getBgPeriodNumber());
        try {
            if (bgExCitInfo.getFormulaAlias().indexOf("BGACTUALS") == 0) {
                colName = "t.fbizactual";
                valueType = actualValue;
            } else if (bgExCitInfo.getFormulaAlias().indexOf("BGBAL") == 0) {
                colName = "t.FBgValue - t.fbizactual";
                valueType = balanceValue;
            } else if (bgExCitInfo.getFormulaAlias().indexOf("BGFORMULA") == 0) {
                colName = "t.FBgValue";
                valueType = bgFormulaValue;
            }
            ArrayList<Object> _tmpList = new ArrayList<Object>();
            sql = new StringBuffer();
            sql1 = new StringBuffer();
            other = new StringBuffer();
            sql.append("Insert Into " + tmpTableName + " (FGroupId, FSeq, FOrgUnitId, FBgSchemeId, FBgFormId, FFormula, FValue, FItemCombinNumber, FElementNumber, FBgPeriodNumber, FCurrencyNumber) ");
            sql.append("Select newbosid('HGFEDCBA'), ");
            sql1.append(", t.FOrgUnitId, t.FBgSchemeId, t.FBgFormId, t.FFormula, " + colName + ", i.FKey, e.fnumber, p.fnumber, c.fnumber from T_BG_BgData t  left outer join T_BG_BgItemCombination i on t.FBgItemCombinId = i.FId left outer join T_BG_BgElement e on t.FBgElementId = e.FId left outer join T_BG_BgPeriod p on t.FBgPeriodId = p.FId left outer join T_BD_Currency c on t.FCurrencyId = c.FId where t.FOrgUnitId = ? and t.FBgSchemeId = ? and t.FBgFormId = ? and t.FFormula like ?");
            other.append(", t.FOrgUnitId, t.FBgSchemeId, t.FBgFormId, t.FFormula, " + colName + ", i.FKey, e.fnumber, p.fnumber, c.fnumber from T_BG_BgData t  left outer join T_BG_BgItemCombination i on t.FBgItemCombinId = i.FId left outer join T_BG_BgElement e on t.FBgElementId = e.FId left outer join T_BG_BgPeriod p on t.FBgPeriodId = p.FId left outer join T_BD_Currency c on t.FCurrencyId = c.FId where ");
            if (bgPeriodType == 0) {
                if (bgExCitInfo.getOrgUnit() == null || bgExCitInfo.getBgScheme() == null) {
                    sql.append(String.valueOf(bgExCitInfo.getSeq()));
                    sql.append(sql1);
                    sql.append(" and t.FFormula in (Select FFormula from T_BG_BgData where FBgFormId = ?)");
                    _tmpList.add(bgFormInfo.getOrgUnit().getId().toString());
                    _tmpList.add(bgFormInfo.getBgScheme().getId().toString());
                    _tmpList.add(bgFormInfo.getId().toString());
                    _tmpList.add(bgExCitInfo.getFormula());
                    _tmpList.add(bgFormInfo.getId().toString());
                } else {
                    sql.append(String.valueOf(bgExCitInfo.getSeq()));
                    sql.append(other);
                    sql.append(" t.FOrgUnitId = ? and t.FBgSchemeId = ?");
                    sql.append(" and t.FFormula like ? and t.FFormula in (Select FFormula from T_BG_BgData where FBgFormId = ?)");
                    _tmpList.add(bgExCitInfo.getOrgUnit().getId().toString());
                    _tmpList.add(bgExCitInfo.getBgScheme().getId().toString());
                    _tmpList.add(bgExCitInfo.getFormula());
                    _tmpList.add(bgFormInfo.getId().toString());
                }
            } else if (bgExCitInfo.getOrgUnit() == null || bgExCitInfo.getBgScheme() == null) {
                sql.append(String.valueOf(bgExCitInfo.getSeq()));
                sql.append(sql1);
                sql.append(" and t.FFormula in (Select FFormula from T_BG_BgData where FBgFormId = ?)");
                sql.append(" and p.FPeriodType = ?");
                _tmpList.add(bgFormInfo.getOrgUnit().getId().toString());
                _tmpList.add(bgFormInfo.getBgScheme().getId().toString());
                _tmpList.add(bgFormInfo.getId().toString());
                _tmpList.add(bgExCitInfo.getFormula());
                _tmpList.add(bgFormInfo.getId().toString());
                _tmpList.add(new Integer(bgPeriodType));
            } else {
                sql.append(String.valueOf(bgExCitInfo.getSeq()));
                sql.append(other);
                sql.append(" t.FOrgUnitId = ? and t.FBgSchemeId = ? and t.FFormula like ? and t.FFormula in (Select FFormula from T_BG_BgData where FBgFormId = ?)");
                sql.append(" and p.FPeriodType = ?");
                _tmpList.add(bgExCitInfo.getOrgUnit().getId().toString());
                _tmpList.add(bgExCitInfo.getBgScheme().getId().toString());
                _tmpList.add(bgExCitInfo.getFormula());
                _tmpList.add(bgFormInfo.getId().toString());
                _tmpList.add(new Integer(bgPeriodType));
            }
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            pstmt.executeUpdate();
            if (valueType == balanceValue) {
                colName = "t.FBgValue - tt.fbizactual ";
                this.builderTmpFormulaTmpData(ctx, conn, tmpTableName, bgFormInfo, bgExCitInfo, bgPeriodType, colName, valueType);
            } else {
                this.builderTmpFormulaTmpData(ctx, conn, tmpTableName, bgFormInfo, bgExCitInfo, bgPeriodType, "t.fbgvalue", 0);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (Exception e) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{e.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    protected void builderUpdateFormulaGroupId(Connection conn, String tmpTableName, BgExamineInfo bgExamineInfo) throws EASBizException {
        if (conn == null) {
            return;
        }
        PreparedStatement pstmt = null;
        PreparedStatement pstup = null;
        ResultSet rst = null;
        BgExamineCitationInfo bgExCitInfo = null;
        BgExamineCitationCollection bgExCitColl = null;
        HashSet<String> groupIdSet = new HashSet<String>();
        HashMap<Integer, String> orgUnitMap = new HashMap<Integer, String>();
        HashMap<Integer, String> bgSchemeMap = new HashMap<Integer, String>();
        int batchSize = 250;
        int batchIndex = 0;
        Integer _seq = null;
        String _tmpStr = null;
        String _groupId = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _bgItemNumber = null;
        String _bgEleNumber = null;
        String _bgPerNumber = null;
        String _currNumber = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer upsql = new StringBuffer();
        sql.append("select FGroupId, FOrgUnitId, FBgSchemeId, FItemCombinNumber, FElementNumber, FBgPeriodNumber, FCurrencyNumber from ").append(tmpTableName).append(" where FSeq = ?");
        upsql.append("update " + tmpTableName + " set FGroupId = ? where FOrgUnitId = ? and FBgSchemeId = ? and ").append("FItemCombinNumber = ? and FElementNumber = ? and FBgPeriodNumber = ? and FCurrencyNumber = ?");
        bgExCitColl = bgExamineInfo.getCitation();
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstup = conn.prepareStatement(upsql.toString());
            int in = bgExCitColl.size();
            for (int i = 1; i <= in; ++i) {
                pstmt.setInt(1, i);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _groupId = rst.getString(1);
                    _orgUnitId = rst.getString(2);
                    _bgSchemeId = rst.getString(3);
                    _bgItemNumber = rst.getString(4);
                    _bgEleNumber = rst.getString(5);
                    _bgPerNumber = rst.getString(6);
                    _currNumber = rst.getString(7);
                    if (groupIdSet.contains(_groupId)) continue;
                    groupIdSet.add(_groupId);
                    for (int j = i + 1; j < in; ++j) {
                        _seq = new Integer(j);
                        bgExCitInfo = bgExCitColl.get(j);
                        pstup.setString(1, _groupId);
                        if (bgExCitInfo.getOrgUnit() == null || bgExCitInfo.getBgScheme() == null) {
                            pstup.setString(2, _orgUnitId);
                            pstup.setString(3, _bgSchemeId);
                        } else {
                            if (orgUnitMap.containsKey(_seq)) {
                                _tmpStr = bgExCitInfo.getOrgUnit().getId().toString();
                                orgUnitMap.put(_seq, _tmpStr);
                            } else {
                                _tmpStr = (String)orgUnitMap.get(_seq);
                            }
                            pstup.setString(2, _tmpStr);
                            if (bgSchemeMap.containsKey(_seq)) {
                                _tmpStr = bgExCitInfo.getBgScheme().getId().toString();
                                bgSchemeMap.put(_seq, _tmpStr);
                            } else {
                                _tmpStr = (String)bgSchemeMap.get(_seq);
                            }
                            pstup.setString(3, _tmpStr);
                        }
                        if (StringUtils.isEmpty((String)bgExCitInfo.getBgItemCombinNumber())) {
                            pstup.setString(4, _bgItemNumber);
                        } else {
                            pstup.setString(4, bgExCitInfo.getBgItemCombinNumber());
                        }
                        if (StringUtils.isEmpty((String)bgExCitInfo.getBgElementNumber())) {
                            pstup.setString(5, _bgEleNumber);
                        } else {
                            pstup.setString(5, bgExCitInfo.getBgElementNumber());
                        }
                        if (StringUtils.isEmpty((String)bgExCitInfo.getBgPeriodNumber())) {
                            pstup.setString(6, _bgPerNumber);
                        } else {
                            pstup.setString(6, bgExCitInfo.getBgPeriodNumber());
                        }
                        if (StringUtils.isEmpty((String)bgExCitInfo.getCurrencyNumber())) {
                            pstup.setString(7, _currNumber);
                        } else {
                            pstup.setString(7, bgExCitInfo.getCurrencyNumber());
                        }
                        pstup.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstup.executeBatch();
                        batchIndex = 0;
                    }
                }
                SQLUtils.cleanup((ResultSet)rst);
                if (batchIndex < 0) continue;
                pstup.executeBatch();
            }
            if (batchIndex >= 0) {
                pstup.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                SQLUtils.cleanup(pstup);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        SQLUtils.cleanup((Statement)pstup);
    }

    protected void builderTmpFormulaTmpData(Context ctx, Connection conn, String tmpTableName, BgFormInfo bgFormInfo, BgExamineCitationInfo bgExCitInfo, int periodType, String colName, int valueType) throws BOSException, EASBizException {
        HashSet<String> formulaSet = new HashSet<String>();
        String orgUnitId = null;
        String bgSchemeId = null;
        String formulaStr = null;
        PreparedStatement stmt = null;
        PreparedStatement pstmtIs = null;
        PreparedStatement pstmtUp = null;
        ResultSet rst = null;
        ArrayList<Object> _tmpList = new ArrayList<Object>();
        StringBuffer formula = new StringBuffer();
        formula.append("select FOrgUnitId, FBgSchemeId, FFormula from " + tmpTableName + " where");
        if (bgExCitInfo.getOrgUnit() == null || bgExCitInfo.getBgScheme() == null) {
            formula.append(" FOrgUnitId = ?  and FBgSchemeId = ?  and FBgFormId = ?");
            _tmpList.add(bgFormInfo.getOrgUnit().getId().toString());
            _tmpList.add(bgFormInfo.getBgScheme().getId().toString());
            _tmpList.add(bgFormInfo.getId().toString());
        } else {
            formula.append(" FOrgUnitId =?  and FBgSchemeId = ?");
            _tmpList.add(bgFormInfo.getOrgUnit().getId().toString());
            _tmpList.add(bgFormInfo.getBgScheme().getId().toString());
        }
        formula.append(" and FSeq = ?");
        _tmpList.add(new Integer(bgExCitInfo.getSeq()));
        ArrayList<Object> _tmpList1 = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        StringBuffer has = new StringBuffer();
        StringBuffer noHas = new StringBuffer();
        sql.append("Select newbosid('HGFEDCBA') FGroupId, " + String.valueOf(bgExCitInfo.getSeq()));
        if (valueType == balanceValue) {
            sql.append(", t.FOrgUnitId, t.FBgSchemeId, t.FBgFormId, t.FFormula, " + colName + " FBgValue, i.FKey, e.fnumber, p.fnumber, c.fnumber from T_BG_BgTmpData t left outer join T_BG_BgItemCombination i on t.FBgItemCombinId = i.FId left outer join T_BG_BgElement e on t.FBgElementId = e.FId left outer join T_BG_BgPeriod p on t.FBgPeriodId = p.FId left outer join T_BD_Currency c on t.FCurrencyId = c.FId  , T_BG_BgData tt ");
        } else {
            sql.append(", t.FOrgUnitId, t.FBgSchemeId, t.FBgFormId, t.FFormula, " + colName + " FBgValue, i.FKey, e.fnumber, p.fnumber, c.fnumber from T_BG_BgTmpData t  left outer join T_BG_BgItemCombination i on t.FBgItemCombinId = i.FId left outer join T_BG_BgElement e on t.FBgElementId = e.FId left outer join T_BG_BgPeriod p on t.FBgPeriodId = p.FId left outer join T_BD_Currency c on t.FCurrencyId = c.FId");
        }
        has.append(" where t.FOrgUnitId = ? and t.FBgSchemeId = ? and t.FBgFormId = ? ");
        noHas.append(" where ");
        if (bgExCitInfo.getOrgUnit() == null || bgExCitInfo.getBgScheme() == null) {
            sql.append(has);
            _tmpList1.add(bgFormInfo.getOrgUnit().getId().toString());
            _tmpList1.add(bgFormInfo.getBgScheme().getId().toString());
            _tmpList1.add(bgFormInfo.getId().toString());
        } else {
            sql.append(noHas);
            sql.append(" t.FOrgUnitId = ? and t.FBgSchemeId = ?");
            _tmpList1.add(bgExCitInfo.getOrgUnit().getId().toString());
            _tmpList1.add(bgExCitInfo.getBgScheme().getId().toString());
        }
        sql.append(" and t.FFormula like ? ");
        _tmpList1.add(bgExCitInfo.getFormula());
        if (periodType != 0) {
            sql.append(" and p.FPeriodType = ?");
            _tmpList1.add(new Integer(periodType));
        }
        if (valueType == balanceValue) {
            sql.append(" and t.fbgschemeid = tt.fbgschemeid and t.forgunitid = tt.forgunitid and t.fformula = tt.fformula");
        }
        StringBuffer insert = new StringBuffer();
        StringBuffer update = new StringBuffer();
        insert.append("Insert Into " + tmpTableName + " (FGroupId, FSeq, FOrgUnitId, FBgSchemeId, FBgFormId, FFormula, FValue, FItemCombinNumber, FElementNumber, FBgPeriodNumber, FCurrencyNumber) Values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        update.append("Update " + tmpTableName + " set FValue = ? where FOrgUnitId = ? and FBgSchemeId = ? and FFormula = ? ");
        try {
            stmt = conn.prepareStatement(formula.toString());
            BgNSQLHelper.setParams((PreparedStatement)stmt, _tmpList);
            rst = stmt.executeQuery();
            while (rst.next()) {
                orgUnitId = rst.getString("FOrgUnitId");
                bgSchemeId = rst.getString("FBgSchemeId");
                formulaStr = rst.getString("FFormula");
                if (formulaSet.contains(orgUnitId + "_" + bgSchemeId + "_" + formulaStr)) continue;
                formulaSet.add(orgUnitId + "_" + bgSchemeId + "_" + formulaStr);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)stmt);
            pstmtIs = conn.prepareStatement(insert.toString());
            pstmtUp = conn.prepareStatement(update.toString());
            stmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)stmt, _tmpList1);
            rst = stmt.executeQuery();
            while (rst.next()) {
                orgUnitId = rst.getString("FOrgUnitId");
                bgSchemeId = rst.getString("FBgSchemeId");
                formulaStr = rst.getString("FFormula");
                if (formulaSet.contains(orgUnitId + "_" + bgSchemeId + "_" + formulaStr)) {
                    pstmtUp.setBigDecimal(1, rst.getBigDecimal("FBgValue"));
                    pstmtUp.setString(2, orgUnitId);
                    pstmtUp.setString(3, bgSchemeId);
                    pstmtUp.setString(4, formulaStr);
                    pstmtUp.addBatch();
                    continue;
                }
                String formId = rst.getString("FBgFormId");
                if (!bgFormInfo.getId().toString().equals(formId)) continue;
                pstmtIs.setString(1, rst.getString("FGroupId"));
                pstmtIs.setInt(2, bgExCitInfo.getSeq());
                pstmtIs.setString(3, orgUnitId);
                pstmtIs.setString(4, bgSchemeId);
                pstmtIs.setString(5, rst.getString("FBgFormId"));
                pstmtIs.setString(6, formulaStr);
                pstmtIs.setBigDecimal(7, rst.getBigDecimal("FBgValue"));
                pstmtIs.setString(8, BgSHelper.getFormulaInfo(null, formulaStr)[BgSHelper.paraItem]);
                pstmtIs.setString(9, rst.getString(9));
                pstmtIs.setString(10, rst.getString(10));
                pstmtIs.setString(11, rst.getString(11));
                pstmtIs.addBatch();
            }
            SQLUtils.cleanup((ResultSet)rst);
            pstmtUp.executeBatch();
            pstmtIs.executeBatch();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtIs);
                SQLUtils.cleanup(pstmtUp);
                SQLUtils.cleanup(rst, (Statement)stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtIs);
        SQLUtils.cleanup((Statement)pstmtUp);
        SQLUtils.cleanup((ResultSet)rst, (Statement)stmt);
    }

    protected void builderOtherFormulaData(Context ctx, Connection conn, String tmpTableName, BgFormInfo bgFormInfo, BgExamineInfo bgExamineInfo, String num) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        block26: {
            pstmt = null;
            rst = null;
            int batchSize = 250;
            int batchIndex = 0;
            int bgExCitSize = bgExamineInfo.getCitation().size();
            String groupId = null;
            String seqStr = null;
            String builderPeriod = null;
            String formulaString = null;
            String key = null;
            String[] formulaInfo = null;
            Map.Entry entry2 = null;
            List<String[]> formulaList = new ArrayList();
            HashMap groupIdsMap = new HashMap();
            Map<String, String[]> groupIdMap = null;
            HashMap<Integer, BgExamineCitationInfo> bgExamineMap = new HashMap<Integer, BgExamineCitationInfo>();
            HashMap<String, String> bgFormIdsMap = new HashMap<String, String>();
            BgExamineCitationInfo bgExCitInfo = null;
            Iterator iter = bgExamineInfo.getCitation().iterator();
            while (iter.hasNext()) {
                bgExCitInfo = (BgExamineCitationInfo)iter.next();
                bgExamineMap.put(new Integer(bgExCitInfo.getSeq()), bgExCitInfo);
            }
            StringBuffer datasql = new StringBuffer();
            StringBuffer sql = new StringBuffer();
            datasql.append("select * from ").append(tmpTableName).append(" where FGroupId in (").append("select distinct FGroupId from ").append(tmpTableName).append(" group by FGroupId ").append("having count(fseq) < ?)");
            sql.append("Insert Into " + tmpTableName + " (FGroupId, FSeq, FOrgUnitId, FBgSchemeId, FBgFormId, FFormula, FValue, FItemCombinNumber, FElementNumber, FBgPeriodNumber, FCurrencyNumber) values (?,?,?,?,?,?,?,?,?,?,?)");
            try {
                String[] tmpFormula;
                try {
                    pstmt = conn.prepareStatement(datasql.toString());
                    pstmt.setInt(1, bgExamineInfo.getCitation().size());
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        groupId = rst.getString("FGroupId");
                        seqStr = String.valueOf(rst.getInt("FSeq"));
                        if (groupIdsMap.containsKey(groupId)) {
                            groupIdMap = (Map)groupIdsMap.get(groupId);
                        } else {
                            groupIdMap = new HashMap();
                            groupIdsMap.put(groupId, groupIdMap);
                        }
                        formulaInfo = new String[]{rst.getString("FGroupId"), seqStr, rst.getString("FOrgUnitId"), rst.getString("FBgSchemeId"), rst.getString("FBgFormId"), rst.getString("FFormula"), CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)rst.getBigDecimal("FValue")), rst.getString("FItemCombinNumber"), rst.getString("FElementNumber"), rst.getString("FBgPeriodNumber"), rst.getString("FCurrencyNumber")};
                        if ((formulaInfo[7] == null || formulaInfo[7].length() == 0) && formulaInfo[5] != null && formulaInfo[5].length() > 0) {
                            String[] paramter = BgNFSHelper.parseFormulaPara(null, (String)formulaInfo[5]);
                            formulaInfo[7] = paramter[BgSHelper.paraItem];
                        }
                        groupIdMap.put(seqStr, formulaInfo);
                        key = new StringBuffer(formulaInfo[2]).append("_").append(formulaInfo[3]).append("_").append(formulaInfo[5]).toString();
                        if (bgFormIdsMap.containsKey(key)) continue;
                        bgFormIdsMap.put(key, formulaInfo[3]);
                    }
                }
                catch (SQLException ex) {
                    try {
                        logger.error((Object)"budget error:", (Throwable)ex);
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst, (Statement)pstmt);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                String seqS = null;
                if (groupIdsMap.isEmpty()) break block26;
                for (Map.Entry entry2 : groupIdsMap.entrySet()) {
                    int index;
                    groupId = (String)entry2.getKey();
                    groupIdMap = (Map)entry2.getValue();
                    for (index = 1; index <= bgExCitSize; ++index) {
                        seqStr = String.valueOf(index);
                        if (!groupIdMap.containsKey(seqStr)) continue;
                        formulaInfo = (String[])groupIdMap.get(seqStr);
                        break;
                    }
                    for (index = 1; index <= bgExCitSize; ++index) {
                        seqStr = String.valueOf(index);
                        if (groupIdMap.containsKey(seqStr)) continue;
                        bgExCitInfo = (BgExamineCitationInfo)bgExamineMap.get(new Integer(index));
                        if (formulaInfo == null || bgExCitInfo == null) continue;
                        builderPeriod = this.parseBgPeriodNumber(formulaInfo[9], bgExCitInfo.getBgPeriodNumber(), ctx);
                        formulaString = this.builderFormula(bgExCitInfo, formulaInfo, builderPeriod);
                        tmpFormula = new String[12];
                        tmpFormula[0] = groupId;
                        tmpFormula[1] = String.valueOf(index);
                        tmpFormula[2] = bgExCitInfo.getOrgUnit() != null ? bgExCitInfo.getOrgUnit().getId().toString() : bgFormInfo.getOrgUnit().getId().toString();
                        tmpFormula[3] = bgExCitInfo.getBgScheme() != null ? bgExCitInfo.getBgScheme().getId().toString() : bgFormInfo.getBgScheme().getId().toString();
                        tmpFormula[4] = null;
                        tmpFormula[5] = formulaString;
                        tmpFormula[6] = null;
                        seqS = ((Integer)bgExCitInfo.get("valueType")).toString();
                        key = new StringBuffer(formulaInfo[2]).append("_").append(formulaInfo[3]).append("_").append(formulaInfo[5]).append(seqS).toString();
                        if (bgFormIdsMap.containsKey(key)) {
                            tmpFormula[4] = bgFormIdsMap.get(key).toString();
                        }
                        tmpFormula[7] = !StringUtils.isEmpty((String)bgExCitInfo.getBgItemCombinNumber()) && !bgExCitInfo.getBgItemCombinNumber().trim().equals("%") ? bgExCitInfo.getBgItemCombinNumber() : formulaInfo[7];
                        tmpFormula[8] = !StringUtils.isEmpty((String)bgExCitInfo.getBgElementNumber()) && !bgExCitInfo.getBgElementNumber().trim().equals("%") ? bgExCitInfo.getBgElementNumber() : formulaInfo[8];
                        tmpFormula[9] = builderPeriod;
                        tmpFormula[10] = !StringUtils.isEmpty((String)bgExCitInfo.getCurrencyNumber()) && !bgExCitInfo.getCurrencyNumber().trim().equals("%") ? bgExCitInfo.getCurrencyNumber() : formulaInfo[10];
                        tmpFormula[11] = seqS.toString();
                        formulaList.add(tmpFormula);
                    }
                }
                if (formulaList.isEmpty()) break block26;
                batchIndex = 0;
                formulaList = this.getData(conn, formulaList, bgExamineMap);
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    int n = formulaList.size();
                    for (int i = 0; i < n; ++i) {
                        tmpFormula = (String[])formulaList.get(i);
                        pstmt.setString(1, tmpFormula[0]);
                        pstmt.setInt(2, Integer.valueOf(tmpFormula[1]));
                        pstmt.setString(3, tmpFormula[2]);
                        pstmt.setString(4, tmpFormula[3]);
                        pstmt.setString(5, tmpFormula[4]);
                        pstmt.setString(6, tmpFormula[5]);
                        try {
                            pstmt.setBigDecimal(7, new BigDecimal(tmpFormula[6]));
                        }
                        catch (Exception ex) {
                            pstmt.setBigDecimal(7, BgConstants.BIGZERO);
                        }
                        pstmt.setString(8, tmpFormula[7]);
                        pstmt.setString(9, tmpFormula[8]);
                        pstmt.setString(10, tmpFormula[9]);
                        pstmt.setString(11, tmpFormula[10]);
                        pstmt.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex != 0) {
                        pstmt.executeBatch();
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)"budget error:", (Throwable)ex);
                    throw ex;
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"budget error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
    }

    protected List getData(Connection conn, List formulaList, Map bgExamineMap) throws BOSException, EASBizException {
        if (conn == null || formulaList == null || bgExamineMap == null) {
            return formulaList;
        }
        HashMap bformulaMap = new HashMap();
        HashMap aformulaMap = new HashMap();
        HashMap vformulaMap = new HashMap();
        HashMap fformulaMap = new HashMap();
        HashMap tmpMap = null;
        Set<String> formulaSet = null;
        int seq = 0;
        String key = null;
        String[] tmpFormula2 = null;
        BgExamineCitationInfo bgExCionInfo = null;
        for (String[] tmpFormula2 : formulaList) {
            seq = Integer.valueOf(tmpFormula2[11]);
            bgExCionInfo = (BgExamineCitationInfo)bgExamineMap.get(new Integer(seq));
            key = new StringBuffer(tmpFormula2[2]).append("_").append(tmpFormula2[3]).toString();
            if (seq == budgetValue) {
                tmpMap = bformulaMap;
            } else if (seq == actualValue) {
                tmpMap = aformulaMap;
            } else if (seq == balanceValue) {
                tmpMap = vformulaMap;
            } else if (seq == bgFormulaValue) {
                tmpMap = fformulaMap;
            }
            if (tmpMap != null) {
                if (tmpMap.containsKey(key)) {
                    formulaSet = (Set)tmpMap.get(key);
                } else {
                    formulaSet = new HashSet();
                    tmpMap.put(key, formulaSet);
                }
            }
            if (formulaSet == null || formulaSet.contains(tmpFormula2[5])) continue;
            formulaSet.add(tmpFormula2[5]);
        }
        try {
            if (!bformulaMap.isEmpty()) {
                tmpMap = this.getData(conn, bformulaMap, budgetValue);
                this.fillData(formulaList, tmpMap, budgetValue);
            }
            if (!aformulaMap.isEmpty()) {
                tmpMap = this.getData(conn, aformulaMap, actualValue);
                this.fillData(formulaList, tmpMap, actualValue);
            }
            if (!vformulaMap.isEmpty()) {
                tmpMap = this.getData(conn, vformulaMap, balanceValue);
                this.fillData(formulaList, tmpMap, balanceValue);
            }
            if (!fformulaMap.isEmpty()) {
                tmpMap = this.getData(conn, fformulaMap, bgFormulaValue);
                this.fillData(formulaList, tmpMap, bgFormulaValue);
            }
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        return formulaList;
    }

    protected Map getData(Connection conn, Map formulaMap, int valueType) throws SQLException {
        int i;
        if (conn == null || formulaMap == null) {
            return null;
        }
        Integer type = new Integer(valueType);
        Map.Entry entry2 = null;
        HashMap<String, Object[]> _formulaMap = new HashMap<String, Object[]>();
        Set _formulaSet = null;
        ArrayList _formulaList = new ArrayList();
        int batchSize = 250;
        int size = 0;
        int count = 0;
        int pos = 0;
        BigDecimal _value = null;
        String _key = null;
        String _osKey = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _bgFormId = null;
        String _formulaStr = null;
        String[] _keyStr = null;
        Object[] _objs = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer tmpsql = null;
        sql.append("select ");
        if (valueType == budgetValue) {
            sql.append(" FBgValue ");
        } else if (valueType == actualValue) {
            sql.append(" FBizActual ");
        } else if (valueType == balanceValue) {
            sql.append(" FBgValue - FBizActual ");
        } else if (valueType == bgFormulaValue) {
            sql.append(" FBgValue ");
        }
        sql.append(" FValue, FBgFormId, FFormula from T_BG_BgData where FOrgUnitId = ? and FBgSchemeId = ? and FFormula IN (");
        for (i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        if (valueType == budgetValue || valueType == balanceValue || valueType == bgFormulaValue) {
            tmpsql = new StringBuffer();
            tmpsql.append("select FBgValue - FBizActual FValue, FFormula, FBgFormId from T_BG_BgTmpData ").append("where FOrgUnitId = ? and FBgSchemeId = ? and FFormula IN (");
            for (i = 1; i < batchSize; ++i) {
                tmpsql.append("?,");
            }
            tmpsql.append("?)");
        }
        PreparedStatement pstmt = null;
        PreparedStatement pstmp = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            if (tmpsql != null && (valueType == budgetValue || valueType == balanceValue || valueType == bgFormulaValue)) {
                pstmp = conn.prepareStatement(tmpsql.toString());
            }
            for (Map.Entry entry2 : formulaMap.entrySet()) {
                _osKey = (String)entry2.getKey();
                _formulaSet = (Set)entry2.getValue();
                _keyStr = _osKey.split("_");
                _orgUnitId = _keyStr[0];
                _bgSchemeId = _keyStr[1];
                _formulaList.clear();
                Iterator list = _formulaSet.iterator();
                while (list.hasNext()) {
                    _formulaList.add(list.next());
                }
                size = _formulaList.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                pstmt.setString(1, _orgUnitId);
                pstmt.setString(2, _bgSchemeId);
                for (int x = 0; x < count; ++x) {
                    int y = 1;
                    while (y <= batchSize) {
                        if (pos < size) {
                            pstmt.setString(y + 2, _formulaList.get(pos).toString());
                        } else {
                            pstmt.setString(y + 2, "#");
                        }
                        ++y;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _value = rst.getBigDecimal(1);
                        _formulaStr = rst.getString(3);
                        _bgFormId = rst.getString(2);
                        _objs = new Object[]{_value, _bgFormId};
                        _key = _osKey + "_" + _formulaStr + type.toString();
                        _formulaMap.put(_key, _objs);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                if (valueType != budgetValue && valueType != balanceValue && valueType != bgFormulaValue) continue;
                pos = 0;
                if (pstmp == null) continue;
                pstmp.setString(1, _orgUnitId);
                pstmp.setString(2, _bgSchemeId);
                for (int xp = 0; xp < count; ++xp) {
                    int yp = 1;
                    while (yp <= batchSize) {
                        if (pos < size) {
                            pstmp.setString(yp + 2, _formulaList.get(pos).toString());
                        } else {
                            pstmp.setString(yp + 2, "#");
                        }
                        ++yp;
                        ++pos;
                    }
                    rst = pstmp.executeQuery();
                    while (rst.next()) {
                        _value = rst.getBigDecimal(1);
                        _formulaStr = rst.getString(2);
                        _bgFormId = rst.getString(3);
                        _key = _osKey + "_" + _formulaStr + type.toString();
                        if (_formulaMap.containsKey(_key)) {
                            _objs = (Object[])_formulaMap.get(_key);
                            _objs[0] = _value.add((BigDecimal)_objs[0]);
                            continue;
                        }
                        _objs = new Object[]{_value, _bgFormId};
                        _key = _osKey + "_" + _formulaStr + type.toString();
                        _formulaMap.put(_key, _objs);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                SQLUtils.cleanup(pstmp);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        SQLUtils.cleanup((Statement)pstmp);
        return _formulaMap;
    }

    protected void fillData(List formulaList, Map formulaMap, int valueType) {
        if (formulaList == null || formulaMap == null) {
            return;
        }
        String key = null;
        String[] tmpFormula = null;
        Object[] objs = null;
        int in = formulaList.size();
        for (int i = 0; i < in; ++i) {
            tmpFormula = (String[])formulaList.get(i);
            key = new StringBuffer(tmpFormula[2]).append("_").append(tmpFormula[3]).append("_").append(tmpFormula[5]).append(tmpFormula[11]).toString();
            if (!formulaMap.containsKey(key)) continue;
            objs = (Object[])formulaMap.get(key);
            tmpFormula[4] = (String)objs[1];
            tmpFormula[6] = CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)((BigDecimal)objs[0]));
        }
    }

    protected String builderFormula(BgExamineCitationInfo bgExCitInfo, String[] formulaInfo, String builderBgPeriod) {
        StringBuffer formulaStr = new StringBuffer();
        formulaStr.append("=BgItem(\"" + (bgExCitInfo.getBgItemCombinNumber() != null && bgExCitInfo.getBgItemCombinNumber().trim().length() > 0 && !bgExCitInfo.getBgItemCombinNumber().trim().equals("%") ? bgExCitInfo.getBgItemCombinNumber() : formulaInfo[7].replaceAll("_", ",")) + "\",\"" + builderBgPeriod + "\",\"" + (bgExCitInfo.getBgElementNumber() != null && bgExCitInfo.getBgElementNumber().trim().length() > 0 && !bgExCitInfo.getBgElementNumber().trim().equals("%") ? bgExCitInfo.getBgElementNumber() : formulaInfo[8]) + "\",\"" + BgDataTypeEnum.BgData.getName() + "\"," + Boolean.TRUE.toString() + ",\"" + (bgExCitInfo.getCurrencyNumber() != null && bgExCitInfo.getCurrencyNumber().trim().length() > 0 && !bgExCitInfo.getCurrencyNumber().trim().equals("%") ? bgExCitInfo.getCurrencyNumber() : formulaInfo[10]) + "\")");
        return formulaStr.toString();
    }

    protected String parseBgPeriodNumber(String bgPeriodNumber, String matching, Context ctx) {
        if (StringUtils.isEmpty((String)matching) || matching.trim().equals("%")) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"14_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + bgPeriodNumber + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"15_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + matching + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"16_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + bgPeriodNumber));
            return bgPeriodNumber;
        }
        if (matching.indexOf("%") == -1) {
            logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"14_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + bgPeriodNumber + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"15_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + matching + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"16_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + matching));
            return matching;
        }
        String yearCode = null;
        String halfYearCode = null;
        String quarterCode = null;
        String monthCode = null;
        String dayCode = null;
        String monthWeekCode = null;
        String yearWeekCode = null;
        String tenDayCode = null;
        String tmpBgPeriod = null;
        tmpBgPeriod = matching;
        if (Pattern.matches("[\\d]{4}Y[\\w.]*", bgPeriodNumber)) {
            yearCode = bgPeriodNumber.substring(0, 5);
            if (Pattern.matches("[\\d]{4}Y.[\\d]{2}HY", bgPeriodNumber)) {
                halfYearCode = bgPeriodNumber.substring(6, 10);
            } else if (Pattern.matches("[\\d]{4}Y.[\\d]{2}Q", bgPeriodNumber)) {
                quarterCode = bgPeriodNumber.substring(6, 9);
            } else if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M[\\w.]*", bgPeriodNumber)) {
                monthCode = bgPeriodNumber.substring(6, 9);
                if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}D", bgPeriodNumber)) {
                    dayCode = bgPeriodNumber.substring(10, 13);
                } else if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}MW", bgPeriodNumber)) {
                    monthWeekCode = bgPeriodNumber.substring(10, 14);
                } else if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}TD", bgPeriodNumber)) {
                    tenDayCode = bgPeriodNumber.substring(10, 14);
                }
            } else if (Pattern.matches("[\\d]{4}Y.[\\d]{2}W", bgPeriodNumber)) {
                yearWeekCode = bgPeriodNumber.substring(6, 9);
            }
        }
        if (yearCode != null) {
            tmpBgPeriod = tmpBgPeriod.replaceAll("%Y", yearCode);
        }
        if (halfYearCode != null) {
            tmpBgPeriod = tmpBgPeriod.replaceAll("%HY", halfYearCode);
        }
        if (quarterCode != null) {
            tmpBgPeriod = tmpBgPeriod.replaceAll("%Q", quarterCode);
        }
        if (monthCode != null) {
            tmpBgPeriod = tmpBgPeriod.replaceAll("%M", monthCode);
        }
        if (dayCode != null) {
            tmpBgPeriod = tmpBgPeriod.replaceAll("%D", dayCode);
        }
        if (yearWeekCode != null) {
            tmpBgPeriod = tmpBgPeriod.replaceAll("%W", yearWeekCode);
        }
        if (monthWeekCode != null) {
            tmpBgPeriod = tmpBgPeriod.replaceAll("%MW", monthWeekCode);
        }
        if (tenDayCode != null) {
            tmpBgPeriod = tmpBgPeriod.replaceAll("%TD", tenDayCode);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"14_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + bgPeriodNumber + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"15_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + matching + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"16_BgExamineFacadeControllerBean", (Locale)ctx.getLocale()) + tmpBgPeriod));
        return tmpBgPeriod;
    }

    public String parseFormula(String qualification, String formula) throws Exception {
        if (formula == null) {
            return qualification;
        }
        StringBuffer str = new StringBuffer();
        String formulass = null;
        String bgNExamformula = null;
        String newBgNExamformula = null;
        List list = null;
        Vector formulas = new Vector();
        Expression expres = ExcelFormulaPaserHelper.parse((String)formula);
        this.walk(formulas, expres);
        for (int n = 0; n < formulas.size(); ++n) {
            String[] orgParams;
            FormulaHint hint;
            String[] params;
            list = TableToolkit.parseFormula((String)("=" + formulas.elementAt(n).toString()), (boolean)false);
            if (list == null || list.isEmpty() || !(params = (hint = (FormulaHint)list.get(0)).getParams())[0].contains(";") || (orgParams = params[0].split(";")) == null) continue;
            str.setLength(0);
            str.append("(");
            for (String s : orgParams) {
                formulass = hint.toString().replace(params[0], s);
                str.append(formulass);
                str.append("+");
            }
            str.delete(str.length() - 1, str.length());
            str.append(")");
            newBgNExamformula = str.toString();
            bgNExamformula = hint.toString().replaceAll(" ", "");
            qualification = qualification.replace(bgNExamformula, newBgNExamformula);
        }
        return qualification;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkBgExamineData(Context ctx, Connection conn, String tmpTableName, Object[] examineCheck, Map examineCheckMap, BgExamineInfo bgExamineInfo, BgFormInfo bgFormInfo, String num) throws BOSException, EASBizException, Exception {
        int isPass;
        List _tmpList;
        ArrayList<String> examineList;
        Map _examineItems;
        HashMap<String, Map<String, String>> examineItems;
        Map _examineMap;
        HashMap<String, Object> examineMap;
        Map noPassMap;
        Map passSetMap;
        Map passMap;
        block68: {
            BgExamineCitationInfo citation = null;
            Statement stmt = null;
            ResultSet rst = null;
            HashMap<Integer, BgExamineCitationInfo> citatMap = new HashMap<Integer, BgExamineCitationInfo>();
            HashMap postilMap = new HashMap();
            passMap = null;
            passSetMap = null;
            noPassMap = null;
            examineMap = null;
            _examineMap = null;
            examineItems = null;
            _examineItems = null;
            Map<String, String> formulaMap = null;
            Map orgUnitMap = null;
            Map bgFormMap = null;
            Map currencyMap = null;
            HashSet<String> orgUnitSet = new HashSet<String>();
            HashSet<String> bgFormSet = new HashSet<String>();
            examineList = new ArrayList<String>();
            _tmpList = null;
            String oldNumber = null;
            String number = null;
            String key222 = null;
            String seqStr = null;
            String oldSeq = null;
            String qualification = null;
            String bgExamformula = null;
            String formulaString = null;
            String bgCiaFormulaString = null;
            String bgPostialStr = null;
            String valueString = null;
            String valueStr = null;
            String orgUnitId = null;
            String bgSchemeId = null;
            String bgFormId = null;
            String currencyNumber = null;
            String adjustId = null;
            BigDecimal value = null;
            StringBuffer sql = new StringBuffer();
            StringBuffer select = new StringBuffer();
            StringBuffer from = new StringBuffer();
            StringBuffer where = new StringBuffer();
            int strIndex = 0;
            isPass = 0;
            boolean isHasAllPostil = true;
            boolean isHasPostil = false;
            if (examineCheck[2] != null && examineCheck[2] instanceof Map) {
                currencyMap = (Map)examineCheck[2];
            }
            passMap = (Map)examineCheckMap.get("EXAMINE_PASS");
            passSetMap = (Map)examineCheckMap.get("EXAMINE_PASS_SET");
            noPassMap = (Map)examineCheckMap.get("EXAMINE_NOPASS");
            examineMap = new HashMap<String, Object>();
            examineItems = new HashMap<String, Map<String, String>>();
            examineMap.put("EXAMINE_NUMBER", bgExamineInfo.getNumber());
            examineMap.put("EXAMINE_NAME", bgExamineInfo.getName());
            examineMap.put("EXAMINE_FORMULA_ALIAS", bgExamineInfo.getFormula());
            examineMap.put("EXAMINE_EXPLAIN", bgExamineInfo.getHint() == null ? "" : bgExamineInfo.getHint());
            examineMap.put("EXAMINE_CITATION_SIZE", new Integer(bgExamineInfo.getCitation().size()));
            examineMap.put("EXAMINE_CITATION", examineItems);
            examineMap.put("EXAMINE_CIAATION_FORMULA", examineList);
            if (bgExamineInfo.getCitation().size() <= 0) {
                isPass = 1;
            } else {
                block67: {
                    Iterator iter;
                    select.append("select DISTINCT ");
                    from.append("from ");
                    where.append("where ");
                    qualification = bgExamineInfo.getFormula().replaceAll(" ", "");
                    formulaString = bgExamineInfo.getFormula().replaceAll(" ", "");
                    int n = bgExamineInfo.getCitation().size();
                    for (int i = 0; i < n; ++i) {
                        citation = bgExamineInfo.getCitation().get(i);
                        citatMap.put(new Integer(citation.getSeq()), citation);
                    }
                    qualification = this.parseFormula(qualification, bgExamineInfo.getFormula());
                    n = bgExamineInfo.getCitation().size();
                    for (int j = 1; j <= n; ++j) {
                        citation = (BgExamineCitationInfo)citatMap.get(new Integer(j));
                        number = String.valueOf(citation.getSeq());
                        seqStr = "t" + number;
                        select.append(seqStr + ".FSeq s" + seqStr + "," + seqStr + ".FOrgUnitId o" + seqStr + "," + seqStr + ".FBgSchemeId bs" + seqStr + "," + seqStr + ".FBgFormId bf" + seqStr + "," + seqStr + ".FFormula f" + seqStr + "," + seqStr + ".FValue v" + seqStr + "," + seqStr + ".FCurrencyNumber c" + seqStr + ",");
                        from.append(tmpTableName + " " + seqStr + ", ");
                        if (oldSeq == null) {
                            where.append("");
                        } else {
                            where.append("(" + oldSeq + ".FGroupId = " + seqStr + ".FGroupId and " + oldSeq + ".FSeq = " + oldNumber + " and " + seqStr + ".FSeq = " + number + ") and");
                        }
                        qualification = qualification.replaceAll(" ", "");
                        bgExamformula = citation.getFormulaAlias().replaceAll(" ", "");
                        strIndex = qualification.indexOf(bgExamformula);
                        if (strIndex == -1) {
                            throw new BgExamineException(BgExamineException.ERROROFFORMULA);
                        }
                        qualification = qualification.substring(0, strIndex) + "v.v" + seqStr + qualification.substring(strIndex + bgExamformula.length());
                        oldSeq = seqStr;
                        oldNumber = number;
                    }
                    select.delete(select.length() - 1, select.length());
                    from.delete(from.length() - 2, from.length());
                    if (where.toString().trim().equals("where")) {
                        where.delete(0, where.length());
                    } else {
                        where.delete(where.length() - 4, where.length());
                    }
                    if (bgExamineInfo.getErrorData().compareTo(BgConstants.BIGZERO) == 0) {
                        switch (bgExamineInfo.getCompareType().getValue()) {
                            case 0: {
                                qualification = qualification.replaceFirst("<>", "=");
                                break;
                            }
                            case 1: {
                                qualification = qualification.replaceFirst("=", "<>");
                                break;
                            }
                            case 2: {
                                qualification = qualification.replaceFirst("<", ">=");
                                break;
                            }
                            case 3: {
                                qualification = qualification.replaceFirst("<=", ">");
                                break;
                            }
                            case 4: {
                                qualification = qualification.replaceFirst(">", "<=");
                                break;
                            }
                            case 5: {
                                qualification = qualification.replaceFirst(">=", "<");
                                break;
                            }
                        }
                    } else {
                        Pattern p = null;
                        String[] expression = null;
                        switch (bgExamineInfo.getCompareType().getValue()) {
                            case 0: {
                                p = Pattern.compile("<>");
                                expression = p.split(qualification);
                                qualification = "ABS((" + expression[0] + ") - (" + expression[1] + ")) < " + bgExamineInfo.getErrorData().toString();
                                break;
                            }
                            case 1: {
                                p = Pattern.compile("=");
                                expression = p.split(qualification);
                                qualification = "ABS((" + expression[0] + ") - (" + expression[1] + ")) > " + bgExamineInfo.getErrorData().toString();
                                break;
                            }
                            case 2: {
                                p = Pattern.compile("<");
                                expression = p.split(qualification);
                                qualification = bgExamineInfo.getErrorData().toString() + " <= (" + expression[0] + ") - (" + expression[1] + ")";
                                break;
                            }
                            case 3: {
                                p = Pattern.compile("<=");
                                expression = p.split(qualification);
                                qualification = "(" + expression[0] + ") - (" + expression[1] + ") > " + bgExamineInfo.getErrorData().toString();
                                break;
                            }
                            case 4: {
                                p = Pattern.compile(">");
                                expression = p.split(qualification);
                                qualification = bgExamineInfo.getErrorData().toString() + " <= (" + expression[1] + ") - (" + expression[0] + ")";
                                break;
                            }
                            case 5: {
                                p = Pattern.compile(">=");
                                expression = p.split(qualification);
                                qualification = bgExamineInfo.getErrorData().toString() + " < (" + expression[1] + ") - (" + expression[0] + ")";
                                break;
                            }
                        }
                    }
                    sql.append("select * from (" + select + " " + from + " " + where + ")v where " + qualification + " order by ft1");
                    stmt = conn.createStatement();
                    rst = stmt.executeQuery(sql.toString());
                    while (true) {
                        if (rst.next()) {
                            formulaMap = new HashMap<String, String>();
                            formulaString = bgExamineInfo.getFormula().replaceAll(" ", "");
                            formulaString = this.parseFormula(formulaString, bgExamineInfo.getFormula());
                            valueString = new String(formulaString);
                            isHasPostil = false;
                            n = bgExamineInfo.getCitation().size();
                        } else if (examineItems.isEmpty()) {
                            isPass = 0;
                            break block67;
                        } else {
                            switch (bgExamineInfo.getNoPass().getValue()) {
                                case 1: {
                                    isPass = 2;
                                    break;
                                }
                                case 2: {
                                    if (isHasAllPostil) {
                                        isPass = 1;
                                        break;
                                    }
                                    isPass = 2;
                                    break;
                                }
                                case 3: {
                                    isPass = 1;
                                    break;
                                }
                                default: {
                                    isPass = 2;
                                }
                            }
                            orgUnitMap = this.getOrgUnitInfo(ctx, orgUnitSet);
                            bgFormMap = this.getBgFormInfo(ctx, bgFormSet);
                            iter = examineItems.keySet().iterator();
                            break;
                        }
                        for (int j = 1; j <= n; ++j) {
                            citation = (BgExamineCitationInfo)citatMap.get(new Integer(j));
                            bgExamformula = citation.getFormulaAlias().replaceAll(" ", "");
                            bgCiaFormulaString = rst.getString("ft" + j);
                            orgUnitId = rst.getString("ot" + j);
                            bgSchemeId = rst.getString("bst" + j);
                            bgFormId = rst.getString("bft" + j);
                            value = rst.getBigDecimal("vt" + j);
                            currencyNumber = rst.getString("ct" + j);
                            if (bgFormId != null && (adjustId = BgGatherHelper.getGatherAdjustId(conn, BOSUuid.read((String)bgFormId)).toString()) != null && bgExamineInfo.getNoPass().getValue() == 2 && adjustId != null && this.checkBgExaminePostil(ctx, bgSchemeId, adjustId, bgCiaFormulaString, postilMap)) {
                                bgPostialStr = this.getBgExaminePostil(postilMap, bgSchemeId, adjustId, bgCiaFormulaString);
                                formulaMap.put("EXAMINE_CITATION_POSTIAL" + j, bgPostialStr);
                                isHasPostil = true;
                            }
                            bgCiaFormulaString = bgExamformula.indexOf("BGBAL") == 0 ? bgCiaFormulaString.replaceFirst("=BgItem", "BgBal") : (bgExamformula.indexOf("BGACTUALS") == 0 ? bgCiaFormulaString.replaceFirst("=BgItem", "BgActuals") : (bgExamformula.indexOf("BGFORMULA") == 0 ? bgCiaFormulaString.replaceFirst("=BgItem", "BgFormula") : bgCiaFormulaString.replaceFirst("=BgItem", "BgItem")));
                            int precis = 2;
                            if (currencyMap != null && currencyMap.containsKey(currencyNumber)) {
                                precis = ((CurrencyInfo)currencyMap.get(currencyNumber)).getPrecision();
                            }
                            valueStr = BgNationalFormatUIUtil.getNumberFormat(ctx, precis).format(value);
                            orgUnitSet.add(orgUnitId);
                            bgFormSet.add(bgFormId);
                            formulaMap.put("EXAMINE_CITATION_ORGUNIT" + j, orgUnitId);
                            formulaMap.put("EXAMINE_CITATION_ORGUNIT_NAME" + j, null);
                            formulaMap.put("EXAMINE_CITATION_SCHEME" + j, bgSchemeId);
                            formulaMap.put("EXAMINE_CITATION_FORM" + j, bgFormId);
                            formulaMap.put("EXAMINE_CITATION_FORM_NAME" + j, null);
                            formulaMap.put("EXAMINE_CIAATION_FORMULA" + j, bgCiaFormulaString);
                            formulaMap.put("EXAMINE_CITATION_VALUE" + j, valueStr);
                            formulaString = formulaString.replaceAll(" ", "");
                            strIndex = formulaString.indexOf(bgExamformula);
                            if (strIndex == -1) {
                                throw new BgExamineException(BgExamineException.ERROROFFORMULA);
                            }
                            formulaString = formulaString.substring(0, strIndex) + bgCiaFormulaString + formulaString.substring(strIndex + bgExamformula.length());
                            strIndex = (valueString = valueString.replaceAll(" ", "")).indexOf(bgExamformula);
                            if (strIndex == -1) {
                                throw new BgExamineException(BgExamineException.ERROROFFORMULA);
                            }
                            valueString = valueString.substring(0, strIndex) + valueStr + valueString.substring(strIndex + bgExamformula.length());
                        }
                        if (!isHasPostil) {
                            isHasAllPostil = false;
                        }
                        formulaMap.put("EXAMINE_FORMULA", formulaString);
                        formulaMap.put("EXAMINE_FORMULA_VALUE", valueString);
                        if (examineItems.containsKey(bgFormInfo.getId().toString() + "_" + formulaString)) continue;
                        examineItems.put(bgFormInfo.getId().toString() + "_" + formulaString, formulaMap);
                        examineList.add(bgFormInfo.getId().toString() + "_" + formulaString);
                    }
                    while (iter.hasNext()) {
                        formulaString = (String)iter.next();
                        formulaMap = (Map)examineItems.get(formulaString);
                        for (String key222 : formulaMap.keySet()) {
                            if (key222.startsWith("EXAMINE_CITATION_ORGUNIT")) {
                                seqStr = key222.replaceFirst("EXAMINE_CITATION_ORGUNIT", "");
                                orgUnitId = (String)formulaMap.get(key222);
                                if (!orgUnitMap.containsKey(orgUnitId)) continue;
                                formulaMap.put("EXAMINE_CITATION_ORGUNIT_NAME" + seqStr, ((CostCenterOrgUnitInfo)orgUnitMap.get(orgUnitId)).getName());
                                continue;
                            }
                            if (!key222.startsWith("EXAMINE_CITATION_FORM")) continue;
                            seqStr = key222.replaceFirst("EXAMINE_CITATION_FORM", "");
                            bgFormId = (String)formulaMap.get(key222);
                            if (!bgFormMap.containsKey(bgFormId)) continue;
                            formulaMap.put("EXAMINE_CITATION_FORM_NAME" + seqStr, ((BgFormInfo)bgFormMap.get(bgFormId)).getName());
                        }
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)stmt);
            }
            break block68;
            catch (SQLException ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
                if (ex == null || !ex.getSQLState().equals("22012")) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                }
                isPass = 0;
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst, (Statement)stmt);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)stmt);
                catch (BOSException ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw ex2;
                    catch (EASBizException ex3) {
                        throw ex3;
                    }
                }
            }
        }
        switch (isPass) {
            case 0: {
                if (examineCheck[0] == null) {
                    examineCheck[0] = Boolean.TRUE;
                }
                if (passMap.containsKey(bgExamineInfo.getId().toString())) {
                    _examineMap = (Map)passMap.get(bgExamineInfo.getId().toString());
                    _examineItems = (Map)_examineMap.get("EXAMINE_CITATION");
                    _tmpList = (List)_examineMap.get("EXAMINE_CIAATION_FORMULA");
                    _examineItems.putAll(examineItems);
                    _tmpList.addAll(examineList);
                    return;
                }
                passMap.put(bgExamineInfo.getId().toString(), examineMap);
                return;
            }
            case 1: {
                if (examineCheck[0] == null) {
                    examineCheck[0] = Boolean.TRUE;
                }
                if (passSetMap.containsKey(bgExamineInfo.getId().toString())) {
                    _examineMap = (Map)passSetMap.get(bgExamineInfo.getId().toString());
                    _examineItems = (Map)_examineMap.get("EXAMINE_CITATION");
                    _tmpList = (List)_examineMap.get("EXAMINE_CIAATION_FORMULA");
                    _examineItems.putAll(examineItems);
                    _tmpList.addAll(examineList);
                    return;
                }
                passSetMap.put(bgExamineInfo.getId().toString(), examineMap);
                return;
            }
            case 2: {
                examineCheck[0] = Boolean.FALSE;
                if (noPassMap.containsKey(bgExamineInfo.getId().toString())) {
                    _examineMap = (Map)noPassMap.get(bgExamineInfo.getId().toString());
                    _examineItems = (Map)_examineMap.get("EXAMINE_CITATION");
                    _tmpList = (List)_examineMap.get("EXAMINE_CIAATION_FORMULA");
                    _examineItems.putAll(examineItems);
                    _tmpList.addAll(examineList);
                    return;
                }
                noPassMap.put(bgExamineInfo.getId().toString(), examineMap);
                return;
            }
        }
        examineCheck[0] = Boolean.FALSE;
        if (noPassMap.containsKey(bgExamineInfo.getId().toString())) {
            _examineMap = (Map)noPassMap.get(bgExamineInfo.getId().toString());
            _examineItems = (Map)_examineMap.get("EXAMINE_CITATION");
            _tmpList = (List)_examineMap.get("EXAMINE_CIAATION_FORMULA");
            _examineItems.putAll(examineItems);
            _tmpList.addAll(examineList);
            return;
        }
        noPassMap.put(bgExamineInfo.getId().toString(), examineMap);
    }

    /*
     * WARNING - void declaration
     */
    protected Map getOrgUnitInfo(Context ctx, Set orgUnitSet) throws BOSException, EASBizException {
        HashMap<String, CostCenterOrgUnitInfo> orgUnitMap = new HashMap<String, CostCenterOrgUnitInfo>();
        if (orgUnitSet == null || orgUnitSet.isEmpty()) {
            return orgUnitMap;
        }
        String orgUnitId22 = null;
        HashSet _orgUnitSet = new HashSet();
        Object var6_6 = null;
        for (String orgUnitId22 : orgUnitSet) {
            void var6_7;
            if (var6_7 == null || var6_7.size() > 50) {
                HashSet hashSet = new HashSet();
                _orgUnitSet.add(hashSet);
            }
            var6_7.add(orgUnitId22);
        }
        ICostCenterOrgUnit iccOrgUnit = null;
        CostCenterOrgUnitInfo ccOrgUnitInfo = null;
        CostCenterOrgUnitCollection ccOrgUnitCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        iccOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        if (iccOrgUnit == null) {
            throw new BgException(BgException.NOINSTANCE);
        }
        for (Set set : _orgUnitSet) {
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
            ccOrgUnitCol = iccOrgUnit.getCostCenterOrgUnitCollection(view);
            if (ccOrgUnitCol == null || ccOrgUnitCol.isEmpty()) continue;
            int n = ccOrgUnitCol.size();
            for (int i = 0; i < n; ++i) {
                ccOrgUnitInfo = ccOrgUnitCol.get(i);
                if (orgUnitMap.containsKey(ccOrgUnitInfo.getId().toString())) continue;
                orgUnitMap.put(ccOrgUnitInfo.getId().toString(), ccOrgUnitInfo);
            }
        }
        return orgUnitMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map getBgFormInfo(Context ctx, Set bgFormSet) throws BOSException, EASBizException {
        HashMap<String, BgFormInfo> bgFormMap = new HashMap<String, BgFormInfo>();
        if (bgFormSet == null) return bgFormMap;
        if (bgFormSet.isEmpty()) {
            return bgFormMap;
        }
        String bgFormId2222222 = null;
        BgFormInfo bgFormInfo = null;
        ArrayList<String> bgFormList = new ArrayList<String>();
        for (String bgFormId2222222 : bgFormSet) {
            bgFormList.add(bgFormId2222222);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 50;
        int size = bgFormList.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        String noFindStr = "#";
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FName, FNumber from T_BG_BgForm WHERE FID IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?, ");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int k = 1; k <= batchNum; ++k, ++pos) {
                    if (pos < size) {
                        pstmt.setString(k, (String)bgFormList.get(pos));
                        continue;
                    }
                    pstmt.setString(k, noFindStr);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgFormInfo = new BgFormInfo();
                    bgFormId2222222 = rst.getString("FID");
                    bgFormInfo.setId(BOSUuid.read((String)bgFormId2222222));
                    bgFormInfo.setName(rst.getString("FName"));
                    bgFormInfo.setNumber(rst.getString("FNumber"));
                    bgFormMap.put(bgFormId2222222, bgFormInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return bgFormMap;
    }

    protected boolean checkBgExaminePostil(Context ctx, String bgSchemeId, String bgFormId, String formulaString, Map postilMap) throws BOSException, EASBizException {
        if (bgFormId == null || bgFormId.toString().trim().length() == 0 || formulaString == null) {
            return false;
        }
        HashMap bgSchemeMap = null;
        HashMap<String, String> bgFormMap = null;
        boolean isSearch = false;
        boolean isLoad = false;
        if (postilMap == null) {
            postilMap = new HashMap();
        }
        if (postilMap.containsKey(bgSchemeId)) {
            bgSchemeMap = (HashMap)postilMap.get(bgSchemeId);
            if (bgSchemeMap.containsKey(bgFormId)) {
                bgFormMap = (HashMap<String, String>)bgSchemeMap.get(bgFormId);
                if (bgFormMap.containsKey(formulaString)) {
                    isSearch = true;
                }
            } else {
                isLoad = true;
                bgFormMap = new HashMap<String, String>();
                bgSchemeMap.put(bgFormId, bgFormMap);
            }
        } else {
            isLoad = true;
            bgSchemeMap = new HashMap();
            postilMap.put(bgSchemeId, bgSchemeMap);
            bgFormMap = new HashMap();
            bgSchemeMap.put(bgFormId, bgFormMap);
        }
        if (isLoad) {
            IBgForm ibgForm = null;
            BgFormInfo bgFormInfo = null;
            PostilInfo postilInfo2 = null;
            String formulaStr = null;
            String positionStr = null;
            HashMap<String, PostilInfo> bgFormPostils = new HashMap<String, PostilInfo>();
            Book book = null;
            Sheet sheet = null;
            Cell cell = null;
            ObjectUuidPK pk = new ObjectUuidPK(bgFormId);
            try {
                ibgForm = BgFormFactory.getLocalInstance(ctx);
                if (ibgForm.exists((IObjectPK)pk)) {
                    bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)pk, this.getBgFormValue());
                    for (PostilInfo postilInfo2 : bgFormInfo.getPostils()) {
                        if (postilInfo2.getPostilType().getValue() != 3) continue;
                        bgFormPostils.put(postilInfo2.getSheet().getSheetID() + "_" + postilInfo2.getCellName(), postilInfo2);
                    }
                    if (bgFormInfo.getZipData() != null) {
                        book = bgFormInfo.getBook();
                        int n = book.getSheetCount();
                        for (int i = 0; i < n; ++i) {
                            sheet = book.getSheet(i);
                            int rowCount = sheet.getMaxRowIndex() + 1;
                            int colCount = sheet.getMaxColIndex() + 1;
                            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                                for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                                    cell = sheet.getCell(rowIndex, colIndex, true);
                                    positionStr = TableToolkit.xy2range((int)colIndex, (int)rowIndex);
                                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell) || !bgFormPostils.containsKey(sheet.getID() + "_" + positionStr)) continue;
                                    formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
                                    postilInfo2 = (PostilInfo)bgFormPostils.get(sheet.getID() + "_" + positionStr);
                                    bgFormMap.put(formulaStr, postilInfo2.getDescription());
                                }
                            }
                        }
                    }
                    isSearch = this.checkBgExaminePostil(ctx, bgSchemeId, bgFormId, formulaString, postilMap);
                }
            }
            catch (BOSException ex) {
                throw ex;
            }
            catch (EASBizException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new BgException(BgException.UNSERIALIZABLEERROR, new String[]{ex.getMessage()});
            }
        }
        return isSearch;
    }

    protected String getBgExaminePostil(Map postilMap, String bgSchemeId, String bgFormId, String formulaString) {
        Map bgFormMap;
        Map bgSchemeMap;
        if (postilMap == null || postilMap.isEmpty() || formulaString == null) {
            return null;
        }
        if (postilMap.containsKey(bgSchemeId) && (bgSchemeMap = (Map)postilMap.get(bgSchemeId)).containsKey(bgFormId) && (bgFormMap = (Map)bgSchemeMap.get(bgFormId)).containsKey(formulaString)) {
            return (String)bgFormMap.get(formulaString);
        }
        return null;
    }

    protected SelectorItemCollection getBgFormValue() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("data");
        sic.add("orgUnit.id");
        sic.add("bgScheme.id");
        sic.add("bgTemplate.id");
        sic.add("postils.*");
        sic.add("postils.report.id");
        sic.add("postils.sheet.id");
        sic.add("postils.sheet.sheetID");
        return sic;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _canExamine(Context ctx, BOSUuid[] bgFormId) throws BOSException, EASBizException {
        IBgForm ibgForm = null;
        BgFormInfo bgFormInfo = null;
        Object bgExamineCol = null;
        if (bgFormId == null) return false;
        if (bgFormId.length == 0) {
            return false;
        }
        ObjectUuidPK pk = null;
        int i = 0;
        int n = bgFormId.length;
        while (i < n) {
            pk = new ObjectUuidPK(bgFormId[i]);
            try {
                ibgForm = BgFormFactory.getLocalInstance(ctx);
                bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)pk, this.getBgFormInfo());
                if (this.canExamine(ctx, (IObjectValue)bgFormInfo)) {
                    return true;
                }
            }
            catch (BOSException ex) {
                throw ex;
            }
            catch (EASBizException ex) {
                throw ex;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _examineHadX(Context ctx, BOSUuid[] bgFormId) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block7: {
            boolean bl;
            block6: {
                String[] ids = new String[bgFormId.length];
                for (int i = 0; i < bgFormId.length; ++i) {
                    ids[i] = bgFormId[i].toString();
                }
                String sql = "select fhadx from t_bg_bgexaminecitation where fexamineid in (select fbgexamineid from t_bg_bgexaminenode where fbgtemplateid in (select fbgtemplateid from t_bg_bgform where fid in " + BgHelper.tranArray2String(ids) + "))";
                conn = null;
                pstmt = null;
                rst = null;
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sql.toString());
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        if (rst.getInt(1) != 1) continue;
                        bl = true;
                        break block6;
                    }
                    break block7;
                }
                catch (Exception e) {
                    try {
                        logger.error((Object)e);
                        throw new BgException(BgException.DATABASEERROR, new String[]{e.getMessage()});
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return false;
    }

    private Expression walk(Context ctx, Expression expr, String xNum, String currentPeriod, int periodType) throws Exception {
        if (expr instanceof FunctionExpr) {
            FunctionExpr fun = (FunctionExpr)expr;
            if (!(fun.funcionName.equalsIgnoreCase("BGBAL") || fun.funcionName.equalsIgnoreCase("BGACTUALS") || fun.funcionName.equalsIgnoreCase("BGITEM") || fun.funcionName.equalsIgnoreCase("BGFORMULA"))) {
                for (int i = 0; i < fun.parameters.size(); ++i) {
                    fun.parameters.set(i, this.walk(ctx, (Expression)fun.parameters.get(i), xNum, currentPeriod, periodType));
                }
            }
            Expression p5 = (Expression)fun.parameters.get(5);
            String s5 = ((StringExpr)p5).value;
            s5 = s5.replaceAll("X", "x");
            s5 = this.parseOffsetPeriod(s5, currentPeriod);
            try {
                s5 = BgPeriodNVariableHelper.getBgPeriodByN(currentPeriod, s5, periodType);
            }
            catch (BgFormException ex) {
                logger.error((Object)"budget error:", (Throwable)((Object)ex));
            }
            if (p5 instanceof StringExpr && fun.parameters.size() == 6 && s5.indexOf("x") > -1) {
                Date beginDate = null;
                Date endDate = null;
                beginDate = this.getPerNum(ctx, s5, xNum, true);
                endDate = this.getPerNum(ctx, s5, xNum, false);
                int bgPeriodType = BgExamineFacadeControllerBean.getBgPeriodType(xNum);
                BgPeriodCollection bgPerCol = BgPeriodHelper.getPeriodColInfo(ctx, beginDate, endDate, bgPeriodType);
                String bgPerNum = null;
                bgPerNum = bgPerCol.size() < 1 ? "0000Y" : bgPerCol.get(0).getNumber();
                StringBuffer sb = new StringBuffer();
                FunctionExpr cpFun = BgExamineFacadeControllerBean.copy(fun);
                cpFun.parameters.set(5, new StringExpr(bgPerNum));
                cpFun.output(sb);
                return ExcelFormulaPaserHelper.parse((String)("(" + sb.toString() + ")"));
            }
            if (p5 instanceof StringExpr && fun.parameters.size() == 6 && s5.indexOf("x") == -1) {
                StringBuffer sb = new StringBuffer();
                FunctionExpr cpFun = BgExamineFacadeControllerBean.copy(fun);
                cpFun.parameters.set(5, new StringExpr(s5));
                cpFun.output(sb);
                return ExcelFormulaPaserHelper.parse((String)("(" + sb.toString() + ")"));
            }
            if (p5 instanceof StringExpr && fun.parameters.size() == 7) {
                StringBuffer sb = new StringBuffer();
                Expression p6 = (Expression)fun.parameters.get(6);
                String s6 = ((StringExpr)p6).value;
                s6 = s6.replaceAll("X", "x");
                s6 = this.parseOffsetPeriod(s6, currentPeriod);
                try {
                    s6 = BgPeriodNVariableHelper.getBgPeriodByN(currentPeriod, s6, periodType);
                }
                catch (BgFormException ex) {
                    logger.error((Object)"budget error:", (Throwable)((Object)ex));
                }
                Date beginDate = null;
                Date endDate = null;
                int bgPeriodType = 0;
                if (s5.indexOf("x") > -1) {
                    beginDate = this.getPerNum(ctx, s5, xNum, true);
                    bgPeriodType = BgExamineFacadeControllerBean.getBgPeriodType(xNum);
                } else {
                    beginDate = this.getPerNum(ctx, s5, s5, true);
                    bgPeriodType = BgExamineFacadeControllerBean.getBgPeriodType(s5);
                }
                if (s6.indexOf("x") > -1) {
                    endDate = this.getPerNum(ctx, s6, xNum, false);
                    bgPeriodType = BgExamineFacadeControllerBean.getBgPeriodType(xNum);
                } else {
                    endDate = this.getPerNum(ctx, s6, s6, false);
                    bgPeriodType = BgExamineFacadeControllerBean.getBgPeriodType(s6);
                }
                BgPeriodCollection bgPerCol = BgPeriodHelper.getPeriodColInfo(ctx, beginDate, endDate, bgPeriodType);
                for (int n = 0; n < bgPerCol.size(); ++n) {
                    FunctionExpr cpFun = BgExamineFacadeControllerBean.copy(fun);
                    cpFun.parameters.set(5, new StringExpr(bgPerCol.get(n).getNumber()));
                    cpFun.parameters.remove(6);
                    if (sb.indexOf("B") >= 0) {
                        sb.append('+');
                    }
                    cpFun.output(sb);
                }
                if (bgPerCol.size() < 1) {
                    FunctionExpr cpFun = BgExamineFacadeControllerBean.copy(fun);
                    cpFun.parameters.set(5, new StringExpr("0000Y"));
                    cpFun.parameters.remove(6);
                    cpFun.output(sb);
                }
                return ExcelFormulaPaserHelper.parse((String)("(" + sb.toString() + ")"));
            }
        } else if (expr instanceof BinaryOperationExpr) {
            BinaryOperationExpr bin = (BinaryOperationExpr)expr;
            bin.left = this.walk(ctx, bin.left, xNum, currentPeriod, periodType);
            bin.right = this.walk(ctx, bin.right, xNum, currentPeriod, periodType);
        } else if (expr instanceof UnaryOperationExpr) {
            UnaryOperationExpr bin = (UnaryOperationExpr)expr;
            bin.operand = this.walk(ctx, bin.operand, xNum, currentPeriod, periodType);
        } else if (expr instanceof ReferenceExpr) {
            SysUtil.abort();
        }
        return expr;
    }

    private String parseOffsetPeriod(String offsetStr, String currentPeriod) {
        String periodNumber = offsetStr;
        if (Pattern.matches(MATCH_STR, offsetStr)) {
            int _offset = 0;
            try {
                _offset = Integer.parseInt(offsetStr);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                return offsetStr;
            }
            periodNumber = BgNPeriodHelper.getOffsetBgPeriodNumberForExpression((String)currentPeriod, (int)_offset);
        }
        return periodNumber;
    }

    private static int getBgPeriodType(String bgPeriodStr) {
        if (bgPeriodStr.indexOf("ZDY_") >= 0) {
            return 8;
        }
        if (bgPeriodStr.indexOf("Y") >= 0) {
            if (bgPeriodStr.indexOf("HY") >= 0) {
                return 2;
            }
            if (bgPeriodStr.indexOf("Q") >= 0) {
                return 3;
            }
            if (bgPeriodStr.indexOf("M") >= 0) {
                if (bgPeriodStr.indexOf("TD") >= 0) {
                    return 9;
                }
                if (bgPeriodStr.indexOf("D") >= 0) {
                    return 7;
                }
                if (bgPeriodStr.indexOf("MW") >= 0) {
                    return 6;
                }
                return 4;
            }
            if (bgPeriodStr.indexOf("W") >= 0) {
                return 5;
            }
            return 1;
        }
        return 0;
    }

    private Date getPerNum(Context ctx, String xNum, String num, boolean isBegin) throws BOSException {
        IBgPeriod iBgPer = BgPeriodFactory.getLocalInstance(ctx);
        BgPeriodCollection bgPerCol = iBgPer.getBgPeriodCollection("where number = '" + num + "'");
        BgPeriodInfo bgPerInfo = null;
        if (bgPerCol.size() > 0) {
            bgPerInfo = bgPerCol.get(0);
        }
        if (bgPerInfo != null) {
            if (isBegin) {
                this.calendar.setTime(bgPerInfo.getBeginDate());
            } else {
                this.calendar.setTime(bgPerInfo.getEndDate());
            }
        }
        if (xNum.indexOf("+") + xNum.indexOf("-") < 0) {
            return this.calendar.getTime();
        }
        boolean isSum = false;
        if (xNum.indexOf("+") > 0) {
            isSum = true;
        }
        xNum = xNum.replaceAll("x", "");
        xNum = xNum.replaceAll("X", "");
        xNum = xNum.replaceAll(" ", "");
        xNum = xNum.replaceAll("\\+", "");
        xNum = xNum.replaceAll("\\-", "");
        BigDecimal number = new BigDecimal(xNum);
        if (num.indexOf("Y") >= 0) {
            if (num.indexOf("HY") >= 0) {
                if (isSum) {
                    this.calendar.add(2, number.intValue() * 6);
                } else {
                    this.calendar.add(2, -(number.intValue() * 6));
                }
                return this.calendar.getTime();
            }
            if (num.indexOf("Q") >= 0) {
                if (isSum) {
                    this.calendar.add(2, number.intValue() * 3);
                } else {
                    this.calendar.add(2, -(number.intValue() * 3));
                }
                return this.calendar.getTime();
            }
            if (num.indexOf("M") >= 0) {
                if (num.indexOf("TD") >= 0) {
                    if (isSum) {
                        this.calendar.add(5, number.intValue() * 10);
                    } else {
                        this.calendar.add(5, -number.intValue() * 10);
                    }
                    if (isBegin) {
                        this.calendar.add(5, -(number.intValue() + 1) / 2);
                    } else {
                        this.calendar.add(5, (number.intValue() + 1) / 2);
                    }
                    return this.calendar.getTime();
                }
                if (num.indexOf("D") >= 0) {
                    if (isSum) {
                        this.calendar.add(5, number.intValue());
                    } else {
                        this.calendar.add(5, -number.intValue());
                    }
                    return this.calendar.getTime();
                }
                if (num.indexOf("MW") >= 0) {
                    if (isSum) {
                        this.calendar.add(5, number.intValue() * 7);
                    } else {
                        this.calendar.add(5, -number.intValue() * 7);
                    }
                    return this.calendar.getTime();
                }
                if (isSum) {
                    this.calendar.add(2, number.intValue());
                } else {
                    this.calendar.add(2, -number.intValue());
                }
                return this.calendar.getTime();
            }
            if (num.indexOf("W") >= 0) {
                if (isSum) {
                    this.calendar.add(6, number.intValue() * 7);
                } else {
                    this.calendar.add(6, -number.intValue() * 7);
                }
                return this.calendar.getTime();
            }
            if (isSum) {
                this.calendar.add(1, number.intValue());
            } else {
                this.calendar.add(1, -number.intValue());
            }
            return this.calendar.getTime();
        }
        return null;
    }

    private static FunctionExpr copy(FunctionExpr foo) throws Exception {
        FunctionExpr cp = (FunctionExpr)ExcelFormulaPaserHelper.parse((String)foo.toString());
        return cp;
    }

    private void walk(Vector formulas, Expression expr) throws Exception {
        if (expr instanceof FunctionExpr) {
            formulas.addElement(expr.toString());
        } else if (expr instanceof BinaryOperationExpr) {
            BinaryOperationExpr bin = (BinaryOperationExpr)expr;
            this.walk(formulas, bin.left);
            this.walk(formulas, bin.right);
        } else if (expr instanceof UnaryOperationExpr) {
            UnaryOperationExpr bin = (UnaryOperationExpr)expr;
            this.walk(formulas, bin.operand);
        }
    }

    @Override
    protected boolean _examineWF(Context ctx, BOSUuid id, String xNum) throws BOSException, EASBizException {
        if (id == null || id.toString().trim().length() == 0) {
            throw new BgExamineException(BgExamineException.BGFORMINFOIDCANTISNULL);
        }
        if (this._canExamine(ctx, new BOSUuid[]{id})) {
            Map currencyMap = null;
            Map tmpMap = null;
            currencyMap = BgSHelper.getCurrencyInfo(ctx, currencyMap, null);
            Object[] examineCheck = new Object[3];
            examineCheck[0] = Boolean.TRUE;
            examineCheck[2] = currencyMap;
            this._examine(ctx, id, examineCheck, xNum);
            if (examineCheck[1] instanceof HashMap) {
                tmpMap = (Map)examineCheck[1];
                examineCheck[1] = BgUtilsHelper.encodeObject(tmpMap);
            }
            examineCheck[2] = null;
            return (Boolean)examineCheck[0];
        }
        return true;
    }

    @Override
    protected IObjectCollection _getExaminesByBgFormIds(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        BgExamineCollection col = new BgExamineCollection();
        if (bgFormIds == null || bgFormIds.size() == 0) {
            return col;
        }
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet ret = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct c.fid,c.fname_l2,c.fnumber ");
        sql.append(" from t_bg_bgform a,t_bg_bgtemplate b,t_bg_bgexamine c,T_BG_BgExamineNode d");
        sql.append(" where a.fid in(");
        for (int i = 0; i < bgFormIds.size(); ++i) {
            String bgFormId = bgFormIds.get(i).toString();
            if (i == bgFormIds.size() - 1) {
                sql.append("?");
            } else {
                sql.append("?,");
            }
            _tmpList.add(bgFormId);
        }
        sql.append(")and a.fbgtemplateid=b.fid and b.fid=d.fbgtemplateid and d.fbgexamineid=c.fid group by c.fid,c.fname_l2,c.fnumber ");
        try {
            conn = this.getConnection(ctx);
            statement = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)statement, _tmpList);
            ret = statement.executeQuery();
            while (ret.next()) {
                BgExamineInfo examineInfo = new BgExamineInfo();
                String id = ret.getString(1);
                String name = ret.getString(2);
                String number = ret.getString(3);
                examineInfo.setId(BOSUuid.read((String)id));
                examineInfo.setNumber(number);
                examineInfo.setName(name);
                col.addObject((IObjectValue)examineInfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ret, statement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)ret, (Statement)statement);
        return col;
    }

    private String getNumberFormat(String str, int number) {
        if (str == null || number <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < number; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    protected String outTime(long startTime, long beginTime, long endTime) {
        return new StringBuffer("invoke process use = ").append(endTime - beginTime).append(" ms; alluse = ").append(endTime - startTime).append(" ms;").toString();
    }
}

