/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFPException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormPeriodData;
import com.kingdee.eas.ma.budget.BgFormPeriodFilterParam;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.app.AbstractBgFPeriodFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public class BgFPeriodFacadeControllerBean
extends AbstractBgFPeriodFacadeControllerBean {
    private static final long serialVersionUID = 1416612065126378586L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgFPeriodFacadeControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _weave(Context ctx, Object parameter, List formula, boolean isBudget) throws BOSException, EASBizException {
        Connection conn;
        Map formulaMap;
        block8: {
            formulaMap = null;
            if (parameter == null) return formulaMap;
            if (!(parameter instanceof BgFormPeriodFilterParam)) {
                return formulaMap;
            }
            BgFormPeriodFilterParam filterParam = (BgFormPeriodFilterParam)parameter;
            conn = null;
            String tmpTableName = null;
            boolean isCreate = false;
            try {
                if (this.checkParameter(filterParam) && (isCreate = this.createTable(ctx, conn = this.getConnection(ctx), tmpTableName = this.getTableName(ctx, conn)))) {
                    this.builderBgPeriodEditData(ctx, conn, tmpTableName, filterParam, formula, isBudget);
                    formulaMap = this.getData(ctx, conn, tmpTableName);
                }
                if (!isCreate) break block8;
            }
            catch (BOSException ex) {
                try {
                    throw ex;
                    catch (EASBizException ex2) {
                        throw ex2;
                    }
                }
                catch (Throwable throwable) {
                    if (isCreate) {
                        this.clearTable(ctx, conn, tmpTableName);
                        this.removeTable(ctx, conn, tmpTableName);
                    }
                    SQLUtils.cleanup(conn);
                    throw throwable;
                }
            }
            this.clearTable(ctx, conn, tmpTableName);
            this.removeTable(ctx, conn, tmpTableName);
        }
        SQLUtils.cleanup((Connection)conn);
        return formulaMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _weave(Context ctx, Object parameter, boolean isBudget) throws BOSException, EASBizException {
        Connection conn;
        List mutexList;
        block8: {
            mutexList = null;
            if (parameter == null) return mutexList;
            if (!(parameter instanceof BgFormPeriodFilterParam)) {
                return mutexList;
            }
            BgFormPeriodFilterParam filterParam = (BgFormPeriodFilterParam)parameter;
            conn = null;
            String tmpTableName = null;
            boolean isCreate = false;
            try {
                if (this.checkParameter(filterParam) && (isCreate = this.createTable(ctx, conn = this.getConnection(ctx), tmpTableName = this.getTableName(ctx, conn)))) {
                    this.builderBgPeriodEditData(ctx, conn, tmpTableName, filterParam, null, isBudget);
                    mutexList = this.builderSaveData(ctx, conn, tmpTableName, filterParam);
                }
                if (!isCreate) break block8;
            }
            catch (BOSException ex) {
                try {
                    throw ex;
                    catch (EASBizException ex2) {
                        throw ex2;
                    }
                }
                catch (Throwable throwable) {
                    if (isCreate) {
                        this.clearTable(ctx, conn, tmpTableName);
                        this.removeTable(ctx, conn, tmpTableName);
                    }
                    SQLUtils.cleanup(conn);
                    throw throwable;
                }
            }
            this.clearTable(ctx, conn, tmpTableName);
            this.removeTable(ctx, conn, tmpTableName);
        }
        SQLUtils.cleanup((Connection)conn);
        return mutexList;
    }

    protected boolean checkParameter(BgFormPeriodFilterParam filterParam) throws EASBizException {
        if (filterParam.getSourceData() == null || filterParam.getSourceData().isEmpty()) {
            throw new BgFPException(BgFPException.INEXISTENCESOURCEDATA);
        }
        if (filterParam.getTargetData() == null || filterParam.getTargetData().isEmpty()) {
            throw new BgFPException(BgFPException.INEXISTENCETARGETDATA);
        }
        BgFormPeriodData data = null;
        List sourceData = null;
        List targetData = null;
        sourceData = filterParam.getSourceData();
        int in = sourceData.size();
        for (int i = 0; i < in; ++i) {
            data = (BgFormPeriodData)sourceData.get(i);
            if (data.getBgFormInfo() == null) {
                throw new BgFPException(BgFPException.BGFORMINFODATAERROR);
            }
            if (data.getCurrencyInfo() == null) {
                throw new BgFPException(BgFPException.CURRENCYDATAERROR);
            }
            if (data.getRateValue() != null) continue;
            throw new BgFPException(BgFPException.RATEDATAERROR);
        }
        targetData = filterParam.getTargetData();
        int jn = targetData.size();
        for (int j = 0; j < jn; ++j) {
            data = (BgFormPeriodData)targetData.get(j);
            if (data.getBgFormInfo() == null) {
                throw new BgFPException(BgFPException.BGFORMINFODATAERROR);
            }
            if (data.getCurrencyInfo() == null) {
                throw new BgFPException(BgFPException.CURRENCYDATAERROR);
            }
            if (data.getRateValue() != null) continue;
            throw new BgFPException(BgFPException.RATEDATAERROR);
        }
        return true;
    }

    protected String getTableName(Context ctx, Connection conn) throws EASBizException {
        boolean isRepeat = true;
        String tmpName = "T_BgFPTmp";
        Random random = new Random();
        DecimalFormat df = new DecimalFormat("000000");
        while (isRepeat) {
            ResultSet rst;
            PreparedStatement pstmt;
            block6: {
                tmpName = tmpName + df.format(random.nextInt(999999));
                pstmt = null;
                rst = null;
                try {
                    pstmt = conn.prepareStatement("select * from KSQL_USERTABLES where KSQL_TABNAME = ?");
                    pstmt.setString(1, tmpName);
                    rst = pstmt.executeQuery();
                    if (rst.next()) break block6;
                    isRepeat = false;
                }
                catch (SQLException ex) {
                    try {
                        throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst, (Statement)pstmt);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create temp TableName succeed!");
        }
        return tmpName;
    }

    protected boolean createTable(Context ctx, Connection conn, String tableName) throws EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tableName + " (FOrgUnitId VarChar(44), FBgSchemeId VarChar(44), FFormula VarChar(500), FValue decimal(21,6), FBgItemNumber nVarChar(200), FBgPeriodNumber nVarChar(80), FBgElementNumber nVarChar(80), FCurrencyNumber nVarChar(80))");
        try {
            SQLUtils.execute((Connection)conn, (String)sql.toString());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"create temp Table succeed!");
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        return true;
    }

    protected boolean removeTable(Context ctx, Connection conn, String tableName) throws EASBizException {
        StringBuffer table = new StringBuffer();
        table.append("DROP TABLE " + tableName);
        try {
            SQLUtils.execute((Connection)conn, (String)table.toString());
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        return true;
    }

    protected void clearTable(Context ctx, Connection conn, String tableName) throws EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Truncate Table " + tableName);
        try {
            SQLUtils.execute((Connection)conn, (String)sql.toString());
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
    }

    protected void builderBgPeriodEditData(Context ctx, Connection conn, String tableName, BgFormPeriodFilterParam parameter, List formula, boolean isBudget) throws BOSException, EASBizException {
        List sourceData = null;
        sourceData = parameter.getSourceData();
        if (formula == null || formula.isEmpty()) {
            this.builderFormulaData(ctx, conn, tableName, sourceData, isBudget);
            this.builderTmpFormulaData(ctx, conn, tableName, sourceData, isBudget);
        } else {
            this.builderSheetFormulaData(ctx, conn, tableName, sourceData, formula, isBudget);
        }
    }

    protected void builderSheetFormulaData(Context ctx, Connection conn, String tableName, List sourceData, List formula, boolean isBudget) throws BOSException, EASBizException {
        if (sourceData == null || sourceData.isEmpty()) {
            return;
        }
        BgFormPeriodData data = null;
        BgFormDiversityData divData = null;
        OrgUnitInfo orgUnitInfo = null;
        BgSchemeInfo bgSchemeInfo = null;
        BgPeriodInfo bgPeriodInfo = null;
        CurrencyInfo currencyInfo = null;
        BigDecimal rateValue = null;
        BigDecimal value = null;
        HashMap formulaMap = new HashMap();
        String[] formulaStr = null;
        String formulaString = null;
        String bgItemCombinNumber = null;
        String bgPeriodNumber = null;
        String bgElementNumber = null;
        String currencyNumber = null;
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tableName + " (FOrgUnitId, FBgSchemeId, FFormula, FValue, FBgItemNumber, FBgPeriodNumber, FBgElementNumber, FCurrencyNumber) values (?, ?, ?, ?, ?, ?, ?, ?)");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            int in = sourceData.size();
            for (int i = 0; i < in; ++i) {
                data = (BgFormPeriodData)sourceData.get(i);
                orgUnitInfo = data.getOrgUnitInfo();
                bgSchemeInfo = data.getBgSchemeInfo();
                bgPeriodInfo = data.getBgPeriodInfo();
                currencyInfo = data.getCurrencyInfo();
                rateValue = data.getRateValue().divide(BgConstants.HUNDRED, 8, 4);
                int jn = formula.size();
                for (int j = 0; j < jn; ++j) {
                    divData = (BgFormDiversityData)formula.get(j);
                    formulaString = divData.getFormula();
                    value = divData.getNewValue();
                    value = value.multiply(rateValue);
                    formulaStr = BgNFSHelper.parseFormulaPara(formulaMap, (String)formulaString);
                    if (formulaStr == null) continue;
                    bgItemCombinNumber = formulaStr[0];
                    bgPeriodNumber = formulaStr[1];
                    bgElementNumber = formulaStr[2];
                    currencyNumber = formulaStr[5];
                    if (StringUtils.isEmpty((String)bgPeriodNumber) || !bgPeriodInfo.getNumber().equals(bgPeriodNumber) || StringUtils.isEmpty((String)currencyNumber) || !currencyInfo.getNumber().equals(currencyNumber)) continue;
                    pstmt.setString(1, orgUnitInfo.getId().toString());
                    pstmt.setString(2, bgSchemeInfo.getId().toString());
                    pstmt.setString(3, formulaString);
                    pstmt.setBigDecimal(4, value);
                    pstmt.setString(5, bgItemCombinNumber);
                    pstmt.setString(6, bgPeriodNumber);
                    pstmt.setString(7, bgElementNumber);
                    pstmt.setString(8, currencyNumber);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    protected void builderFormulaData(Context ctx, Connection conn, String tableName, List sourceData, boolean isBudget) throws BOSException, EASBizException {
        if (sourceData == null || sourceData.isEmpty()) {
            return;
        }
        BgFormPeriodData data = null;
        OrgUnitInfo orgUnitInfo = null;
        BgSchemeInfo bgSchemeInfo = null;
        BgFormInfo bgFormInfo = null;
        BgPeriodInfo bgPeriodInfo = null;
        CurrencyInfo currencyInfo = null;
        BigDecimal rateValue = null;
        String columnName = isBudget ? "FBgValue" : "FBizActual";
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tableName + " (FOrgUnitId, FBgSchemeId, FFormula, FValue, FBgItemNumber, FBgPeriodNumber, FBgElementNumber, FCurrencyNumber) ");
        sql.append(" select t.FOrgUnitId, t.FBgSchemeId, t.FFormula, t." + columnName + " * ?, i.FKey, p.FNumber, e.FNumber, c.FNumber ");
        sql.append(" from T_BG_BgData t left outer join T_BG_BgItemCombination i on t.FBgItemCombinId = i.FID left outer join T_BG_BgPeriod p on t.FBgPeriodId = p.FID left outer join T_BG_BgElement e on t.FBgElementId = e.FID left outer join T_BD_Currency c on t.FCurrencyId = c.FID");
        sql.append(" where t.FOrgUnitId = ? and t.FBgSchemeId = ? and t.FBgFormId = ? and t.FBgPeriodId = ? and t.FCurrencyId = ?");
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            int in = sourceData.size();
            for (int i = 0; i < in; ++i) {
                data = (BgFormPeriodData)sourceData.get(i);
                orgUnitInfo = data.getOrgUnitInfo();
                bgSchemeInfo = data.getBgSchemeInfo();
                bgFormInfo = data.getBgFormInfo();
                bgPeriodInfo = data.getBgPeriodInfo();
                currencyInfo = data.getCurrencyInfo();
                rateValue = data.getRateValue().divide(BgConstants.HUNDRED, 8, 4);
                pstmt.setBigDecimal(1, rateValue);
                pstmt.setString(2, orgUnitInfo.getId().toString());
                pstmt.setString(3, bgSchemeInfo.getId().toString());
                pstmt.setString(4, bgFormInfo.getId().toString());
                pstmt.setString(5, bgPeriodInfo.getId().toString());
                pstmt.setString(6, currencyInfo.getId().toString());
                pstmt.executeUpdate();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    protected void builderTmpFormulaData(Context ctx, Connection conn, String tableName, List sourceData, boolean isBudget) throws BOSException, EASBizException {
        if (sourceData == null || sourceData.isEmpty()) {
            return;
        }
        BgFormPeriodData data = null;
        OrgUnitInfo orgUnitInfo = null;
        BgSchemeInfo bgSchemeInfo = null;
        BgFormInfo bgFormInfo = null;
        BgPeriodInfo bgPeriodInfo = null;
        CurrencyInfo currencyInfo = null;
        BigDecimal rateValue = null;
        BigDecimal value = null;
        String columnName = isBudget ? "FBgValue" : "FBizActual";
        HashSet<String> dataSet = new HashSet<String>();
        int batchSize = 100;
        int batchUpate = 0;
        int batchInsert = 0;
        String key = null;
        String orgUnitId = null;
        String bgSchemeId = null;
        String formulaStr = null;
        String bgItemCombinId = null;
        String bgPeriodId = null;
        String bgElementId = null;
        String currencyId = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer update = new StringBuffer();
        StringBuffer insert = new StringBuffer();
        sql.append("select t.FOrgUnitId, t.FBgSchemeId, t.FFormula, t." + columnName + ", i.FKey, p.FNumber, e.FNumber, c.FNumber ");
        sql.append(" from T_BG_BgTmpData t left outer join T_BG_BgItemCombination i on t.FBgItemCombinId = i.FID left outer join T_BG_BgPeriod p on t.FBgPeriodId = p.FID left outer join T_BG_BgElement e on t.FBgElementId = e.FID left outer join T_BD_Currency c on t.FCurrencyId = c.FID");
        sql.append(" where t.FOrgUnitId = ? and t.FBgSchemeId = ? and t.FBgFormId = ? and t.FBgPeriodId = ? and t.FCurrencyId = ?");
        update.append("update " + tableName + " set FValue = ? where FOrgUnitId = ? and FBgSchemeId = ? and FFormula = ?");
        insert.append("Insert Into " + tableName + " (FOrgUnitId, FBgSchemeId, FFormula, FValue, FBgItemNumber, FBgPeriodNumber, FBgElementNumber, FCurrencyNumber) values (?,?,?,?,?,?,?,?)");
        PreparedStatement pstmt = null;
        PreparedStatement upstmt = null;
        PreparedStatement inpstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("select FOrgUnitId, FBgSchemeId, FFormula from " + tableName);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                orgUnitId = rst.getString(1);
                bgSchemeId = rst.getString(2);
                formulaStr = rst.getString(3);
                dataSet.add(orgUnitId + "_" + bgSchemeId + "_" + formulaStr);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            pstmt = conn.prepareStatement(sql.toString());
            upstmt = conn.prepareStatement(update.toString());
            inpstmt = conn.prepareStatement(insert.toString());
            int in = sourceData.size();
            for (int i = 0; i < in; ++i) {
                data = (BgFormPeriodData)sourceData.get(i);
                orgUnitInfo = data.getOrgUnitInfo();
                bgSchemeInfo = data.getBgSchemeInfo();
                bgFormInfo = data.getBgFormInfo();
                bgPeriodInfo = data.getBgPeriodInfo();
                currencyInfo = data.getCurrencyInfo();
                rateValue = data.getRateValue().divide(BgConstants.HUNDRED, 8, 4);
                pstmt.setString(1, orgUnitInfo.getId().toString());
                pstmt.setString(2, bgSchemeInfo.getId().toString());
                pstmt.setString(3, bgFormInfo.getId().toString());
                pstmt.setString(4, bgPeriodInfo.getId().toString());
                pstmt.setString(5, currencyInfo.getId().toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    orgUnitId = rst.getString(1);
                    bgSchemeId = rst.getString(2);
                    formulaStr = rst.getString(3);
                    value = rst.getBigDecimal(4);
                    bgItemCombinId = rst.getString(5);
                    bgPeriodId = rst.getString(6);
                    bgElementId = rst.getString(7);
                    currencyId = rst.getString(8);
                    key = orgUnitId + "_" + bgSchemeId + "_" + formulaStr;
                    if (dataSet.contains(key)) {
                        upstmt.setBigDecimal(1, value.multiply(rateValue));
                        upstmt.setString(2, orgUnitId);
                        upstmt.setString(3, bgSchemeId);
                        upstmt.setString(4, formulaStr);
                        upstmt.addBatch();
                        if (++batchUpate < batchSize) continue;
                        upstmt.executeBatch();
                        batchUpate = 0;
                        continue;
                    }
                    inpstmt.setString(1, orgUnitId);
                    inpstmt.setString(2, bgSchemeId);
                    inpstmt.setString(3, formulaStr);
                    inpstmt.setBigDecimal(4, value.multiply(rateValue));
                    inpstmt.setString(5, bgItemCombinId);
                    inpstmt.setString(6, bgPeriodId);
                    inpstmt.setString(7, bgElementId);
                    inpstmt.setString(8, currencyId);
                    inpstmt.addBatch();
                    if (++batchInsert < batchSize) continue;
                    inpstmt.executeBatch();
                    batchInsert = 0;
                }
                if (batchUpate > 0) {
                    upstmt.executeBatch();
                }
                if (batchInsert > 0) {
                    inpstmt.executeBatch();
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(upstmt);
                SQLUtils.cleanup(inpstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Statement)upstmt);
        SQLUtils.cleanup((Statement)inpstmt);
    }

    protected List builderSaveData(Context ctx, Connection conn, String tableName, BgFormPeriodFilterParam parameter) throws BOSException, EASBizException {
        List targetData = parameter.getTargetData();
        ArrayList reList = new ArrayList();
        ArrayList<String> mutexList = new ArrayList<String>();
        ArrayList<String> succeed = new ArrayList<String>();
        BgFormPeriodData data = null;
        BgFormDiversityData divData = null;
        UserInfo user = null;
        BgFormInfo bgFormInfo = null;
        BgPeriodInfo bgPeriodInfo = null;
        CurrencyInfo currencyInfo = null;
        BigDecimal rateValue = null;
        BigDecimal value = null;
        BigDecimal oldValue = null;
        IBgForm ibgForm = null;
        HashSet<BOSUuid> hasSaveSet = new HashSet<BOSUuid>();
        HashSet<BOSUuid> mutexSet = new HashSet<BOSUuid>();
        HashMap<BOSUuid, BgFormInfo> bgFormMap = new HashMap<BOSUuid, BgFormInfo>();
        HashMap<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
        HashMap formulaMap = new HashMap();
        Map adjustMap = null;
        boolean isMutex = false;
        boolean isAdjust = false;
        BOSUuid bgFormId2 = null;
        String[] formulaStr = null;
        String key = null;
        String formulaString = null;
        String userID = null;
        String bgItemNumber = null;
        String bgElementNumber = null;
        String currencyNumber = null;
        Date date = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        int rowCount = 0;
        int rowIndex = 0;
        int colCount = 0;
        int colIndex = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select FBgItemNumber, FBgElementNumber, FCurrencyNumber, sum(FValue) as FSValue from " + tableName + " group by FBgItemNumber, FBgElementNumber, FCurrencyNumber");
        ibgForm = BgFormFactory.getLocalInstance(ctx);
        if (ibgForm == null) {
            throw new BgException(BgException.NOINSTANCE);
        }
        date = new Date();
        user = ContextUtil.getCurrentUserInfo((Context)ctx);
        userID = user.getId().toString();
        try {
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgItemNumber = rst.getString(1);
                bgElementNumber = rst.getString(2);
                currencyNumber = rst.getString(3);
                value = rst.getBigDecimal(4);
                key = bgItemNumber.replaceAll("_", ",") + "_" + bgElementNumber + "_" + currencyNumber;
                dataMap.put(key, value);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        int in = targetData.size();
        for (int i = 0; i < in; ++i) {
            data = (BgFormPeriodData)targetData.get(i);
            bgPeriodInfo = data.getBgPeriodInfo();
            currencyInfo = data.getCurrencyInfo();
            rateValue = data.getRateValue().divide(BgConstants.HUNDRED, 8, 4);
            isMutex = false;
            if (bgFormMap.containsKey(data.getBgFormInfo().getId())) {
                bgFormInfo = (BgFormInfo)bgFormMap.get(data.getBgFormInfo().getId());
                isMutex = true;
            } else {
                bgFormInfo = data.getBgFormInfo();
                isMutex = BgSHelper.applyMutex(ctx, bgFormInfo.getId().toString(), user.getName());
                if (isMutex) {
                    bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(data.getBgFormInfo().getId()), BgNFSHelper.getSelectors());
                    bgFormMap.put(bgFormInfo.getId(), bgFormInfo);
                } else if (!mutexSet.contains(bgFormInfo.getId())) {
                    mutexSet.add(bgFormInfo.getId());
                    mutexList.add(bgFormInfo.getName());
                }
            }
            if (!isMutex) continue;
            isAdjust = BgFSHelper.checkHasAdjust(bgFormInfo);
            if (isAdjust) {
                try {
                    adjustMap = this.loadDiversityInfo(bgFormInfo);
                }
                catch (Exception ex) {
                    throw new BgException(BgException.OTHERERROR, new String[]{ex.getMessage()});
                }
            }
            if (bgFormInfo.getZipData() == null || bgFormInfo.getZipData().length <= 0) continue;
            try {
                _book = bgFormInfo.getBook();
            }
            catch (Exception ex) {
                throw new BgException(BgException.UNSERIALIZABLEERROR, new String[]{ex.getMessage()});
            }
            BgNFSHelper.disableUndo((Book)_book);
            BgNFSHelper.disableCal((Book)_book);
            int jn = _book.getSheetCount();
            for (int j = 0; j < jn; ++j) {
                _sheet = _book.getSheet(j);
                rowCount = _sheet.getMaxRowIndex();
                colCount = _sheet.getMaxColIndex();
                for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                    for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_cell) || (formulaStr = BgNFSHelper.parseFormulaPara(formulaMap, (String)(formulaString = BgNFSHelper.getFormulaOfCell((Cell)_cell)))) == null) continue;
                        key = !StringUtils.isEmpty((String)formulaStr[0]) ? formulaStr[0] : "";
                        key = !StringUtils.isEmpty((String)formulaStr[2]) ? key + "_" + formulaStr[2] : key + "_";
                        key = !StringUtils.isEmpty((String)formulaStr[5]) ? key + "_" + formulaStr[5] : key + "_";
                        if (StringUtils.isEmpty((String)formulaStr[1]) || !formulaStr[1].equals(bgPeriodInfo.getNumber()) || !formulaStr[5].equals(currencyInfo.getNumber()) || !dataMap.containsKey(key)) continue;
                        value = (BigDecimal)dataMap.get(key);
                        value = value.multiply(rateValue);
                        if (isAdjust) {
                            if (!BgNFSHelper.checkIsEmptyValue((Cell)_cell)) {
                                oldValue = (BigDecimal)BgNFSHelper.getValue((Cell)_cell);
                                if (oldValue.compareTo(value) != 0) {
                                    if (adjustMap != null) {
                                        if (adjustMap.containsKey(formulaString)) {
                                            divData = (BgFormDiversityData)adjustMap.get(formulaString);
                                        } else {
                                            divData = new BgFormDiversityData();
                                            divData.setFormula(formulaString);
                                            divData.setOldValue(oldValue);
                                            adjustMap.put(formulaString, divData);
                                        }
                                    }
                                    if (divData != null) {
                                        divData.setAdjustor(userID);
                                        divData.setAdjustTime(date);
                                        divData.setNewValue(value);
                                    }
                                }
                            } else if (value.compareTo(BgConstants.BIGZERO) != 0) {
                                if (adjustMap != null) {
                                    if (adjustMap.containsKey(formulaString)) {
                                        divData = (BgFormDiversityData)adjustMap.get(formulaString);
                                    } else {
                                        divData = new BgFormDiversityData();
                                        divData.setFormula(formulaString);
                                        divData.setOldValue(oldValue);
                                        adjustMap.put(formulaString, divData);
                                    }
                                }
                                if (divData != null) {
                                    divData.setAdjustor(userID);
                                    divData.setAdjustTime(date);
                                    divData.setNewValue(value);
                                }
                            }
                        }
                        BgNFSHelper.setValue((Cell)_cell, (Object)value);
                        BgNFSHelper.setBudgetValue((Cell)_cell, (BigDecimal)value);
                        if (hasSaveSet.contains(bgFormInfo.getId())) continue;
                        hasSaveSet.add(bgFormInfo.getId());
                    }
                }
            }
            if (!hasSaveSet.contains(bgFormInfo.getId())) continue;
            try {
                bgFormInfo.setBook(_book);
            }
            catch (Exception ex) {
                throw new BgException(BgException.UNSERIALIZABLEERROR, new String[]{ex.getMessage()});
            }
            if (!isAdjust) continue;
            try {
                this.storeDiversityInfo(bgFormInfo, adjustMap);
                continue;
            }
            catch (Exception ex) {
                throw new BgException(BgException.OTHERERROR, new String[]{ex.getMessage()});
            }
        }
        try {
            for (BOSUuid bgFormId2 : bgFormMap.keySet()) {
                bgFormInfo = (BgFormInfo)bgFormMap.get(bgFormId2);
                bgFormInfo.setDataSource(BgFormDataSourceEnum.BGPERIODEDIT);
                if (hasSaveSet.contains(bgFormId2)) {
                    if (BgFSHelper.checkHasAdjust(bgFormInfo)) {
                        ibgForm.submit((CoreBaseInfo)bgFormInfo);
                    } else {
                        ibgForm.submit(bgFormId2, (IObjectValue)bgFormInfo, true);
                    }
                }
                succeed.add(bgFormInfo.getName());
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            for (BOSUuid bgFormId2 : bgFormMap.keySet()) {
                BgSHelper.releaseMutex(ctx, bgFormId2);
            }
        }
        reList.add(mutexList);
        reList.add(succeed);
        return reList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map loadDiversityInfo(BgFormInfo bgFormInfo) throws Exception {
        HashMap adjustMap = null;
        if (bgFormInfo != null) {
            byte[] data = bgFormInfo.getAdjustMapData();
            if (data == null || data.length == 0) {
                adjustMap = new HashMap();
            } else {
                InputStream is = null;
                ObjectInputStream ois = null;
                try {
                    is = ZipUtil.unpack((byte[])data);
                    ois = new ObjectInputStream(is);
                    adjustMap = (HashMap)ois.readObject();
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                    try {
                        ois.close();
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                }
                if (adjustMap == null) {
                    throw new BgFormException(BgFormException.LOADDIVERSITYERROR);
                }
            }
        } else {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        return adjustMap;
    }

    protected void storeDiversityInfo(BgFormInfo bgFormInfo, Map adjustMap) throws Exception {
        if (bgFormInfo != null && adjustMap != null) {
            ByteArrayOutputStream baos = null;
            ObjectOutputStream oos = null;
            try {
                baos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(baos);
                oos.writeObject(adjustMap);
                bgFormInfo.setAdjustMapData(ZipUtil.pack((ByteArrayOutputStream)baos));
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw ex;
            }
            finally {
                try {
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        }
    }

    protected Map getData(Context ctx, Connection conn, String tableName) throws BOSException, EASBizException {
        BigDecimal value = null;
        HashMap<String, BigDecimal> reDataMap = new HashMap<String, BigDecimal>();
        String key = null;
        String bgItemNumber = null;
        String bgElementNumber = null;
        String currencyNumber = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FBgItemNumber, FBgElementNumber, FCurrencyNumber, sum(FValue) as FSValue from " + tableName + " group by FBgItemNumber, FBgElementNumber, FCurrencyNumber");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgItemNumber = rst.getString(1);
                bgElementNumber = rst.getString(2);
                currencyNumber = rst.getString(3);
                value = rst.getBigDecimal(4);
                key = bgItemNumber.replaceAll("_", ",") + "_" + bgElementNumber + "_" + currencyNumber;
                reDataMap.put(key, value);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return reDataMap;
    }
}

