/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgExamineException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.app.AbstractBgFormAnalyseFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import org.apache.log4j.Logger;

public class BgFormAnalyseFacadeControllerBean
extends AbstractBgFormAnalyseFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgFormAnalyseFacadeControllerBean");
    public static final String YearCode = "Y";
    private static String tmpTableName = null;
    private static String tmpTableNameSum = null;
    private static int tempint = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getTempLastBgPeriods(Context ctx, String[] bgPeriods, String bgSchemeId) {
        String[] tempLastBgPeriods = new String[bgPeriods.length];
        BgPeriodInfo tempInfo = null;
        BgPeriodInfo tempLastInfo = null;
        for (int i = 0; i < bgPeriods.length; ++i) {
            try {
                tempInfo = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodInfo((IObjectPK)new ObjectUuidPK(bgPeriods[i]));
                tempLastInfo = BgPeriodHelper.getPreviousYearOfBgPeriodInfo(tempInfo, ctx);
                if (tempLastInfo != null) {
                    boolean isUse = this.bgPeriodIsUse(tempLastInfo, bgSchemeId, ctx);
                    if (isUse) {
                        tempLastBgPeriods[i] = tempLastInfo.getId().toString();
                        continue;
                    }
                    if (isUse) continue;
                    tempLastBgPeriods[i] = null;
                    continue;
                }
                if (tempLastInfo != null) continue;
                tempLastBgPeriods[i] = null;
            }
            catch (EASBizException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            continue;
        }
        return tempLastBgPeriods;
    }

    private String getMeas(Object[][] filterParams, SchemaSource ss) {
        String date = new String();
        date = date + "{";
        for (int i = 0; i < 15; ++i) {
            if (!((Boolean)filterParams[i][1]).booleanValue()) continue;
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BgValueBeforeAdjust", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MFBgValueBeforeAdjust]} , ";
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"AdjustValue", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MFAdjustValue]} , ";
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"FBgValue", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MFBgValue]} , ";
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BizActual", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MBizActual]} , ";
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"FLYBgValue", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MLYBgValue]} , ";
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"FLYActualValue", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MLYActualValue]} , ";
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"LYBgValueRate", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MLYBgValueRate]} , ";
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"FBgValueSum", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MBgValueSumFinal]} , ";
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BizActualSum", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MActualValueSumFinal]} , ";
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"FTYBgValue", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MTYBgValueFinal]} , ";
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"FTYActualValue", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MTYActualValueFinal]} , ";
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"OperationPlan", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[OperationPlan]} , ";
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"OperationDifference", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[MOperationDifference]} , ";
            }
            if (((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"OperationDifferRate", (Locale)ContextUtils.getLocaleFromEnv()))) {
                date = date + "{[Measures].[OperationDifferRate]} , ";
            }
            if (!((String)filterParams[i][0]).equalsIgnoreCase(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"LYActualValueRate", (Locale)ContextUtils.getLocaleFromEnv()))) continue;
            date = date + "{[Measures].[MLYActualValueRate]} , ";
        }
        date = date.substring(0, date.lastIndexOf(",") - 1);
        date = date + "}";
        return date;
    }

    private StringBuffer getItems(Object[][] bgItems) {
        StringBuffer bgitems = new StringBuffer();
        for (int i = 0; i < bgItems.length; ++i) {
            if (bgItems[i] == null || bgItems[i][1] == null || bgItems[i][2] == null) continue;
            bgitems.append(" and " + bgItems[i][2].toString() + " in " + bgItems[i][1]);
        }
        return bgitems;
    }

    private Object[][] order(Object[][] bgItems) {
        Object[][] orderItems = new Object[bgItems.length][];
        Integer FNum = null;
        int m = 0;
        for (int i = 1; i <= 100; ++i) {
            for (int n = 0; n < bgItems.length; ++n) {
                if (bgItems[n] == null || bgItems[n][1] == null || bgItems[n][2] == null) continue;
                FNum = null;
                FNum = new Integer(bgItems[n][2].toString().substring(1));
                if (FNum != i) continue;
                orderItems[m] = bgItems[n];
                ++m;
            }
        }
        return orderItems;
    }

    private StringBuffer getItemReffield(Object[][] bgItems) {
        StringBuffer bgItemReffield = new StringBuffer();
        bgItemReffield.append(" and B.fKey = ");
        for (int i = 0; i < bgItems.length; ++i) {
            if (bgItems[i] == null || bgItems[i][1] == null || bgItems[i][2] == null) continue;
            bgItemReffield.append(bgItems[i][2].toString() + " || '_' || ");
        }
        if (bgItems.length <= 0) {
            bgItemReffield.delete(bgItemReffield.length() - 13, bgItemReffield.length());
        } else {
            bgItemReffield.delete(bgItemReffield.length() - 11, bgItemReffield.length());
        }
        return bgItemReffield;
    }

    private StringBuffer getItemDate(Object[][] bgItems) {
        StringBuffer bgitem = new StringBuffer();
        for (int i = 0; i < bgItems.length; ++i) {
            if (bgItems[i] == null || bgItems[i][1] == null || bgItems[i][2] == null) continue;
            bgitem.append(" , " + bgItems[i][2] + " AS " + bgItems[i][2].toString());
        }
        return bgitem;
    }

    private void setSchemaConfigFileMacroValue(Object[][] bgItems, String dyTablePrefix, SchemaSource ss) {
        StringBuffer p = new StringBuffer();
        StringBuffer d = new StringBuffer();
        StringBuffer u = new StringBuffer();
        StringBuffer s = new StringBuffer(0);
        int n = bgItems.length;
        for (int i = 0; i < n; ++i) {
            if (bgItems[i] == null || bgItems[i][1] == null || bgItems[i][2] == null) continue;
            s.setLength(0);
            String tab = dyTablePrefix + i;
            String key = bgItems[i][2].toString();
            p.append("<Parameter name=\"" + tab + "\" type=\"Table\"/>\r\n");
            d.append("<Dimension name=\"" + tab + "\" caption=\"" + bgItems[i][0].toString() + "\" table=\"" + tab + "\" primaryKey=\"fnumber\">\r\n");
            d.append("<Hierarchy>\r\n");
            d.append("<Level name=\"" + tab + "\" column=\"fnumber\">\r\n");
            d.append("<Property name=\"name\" column=\"fname\"/>\r\n");
            d.append("</Level>\r\n");
            d.append("</Hierarchy>\r\n");
            d.append("</Dimension>\r\n");
            u.append("<DimensionUsage name=\"" + tab + "\" foreignKey=\"" + key + "\" />\r\n");
        }
        ss.setMacroValue("DyParameter", p.toString());
        ss.setMacroValue("DyDimension", d.toString());
        ss.setMacroValue("DyDimensionUsage", u.toString());
    }

    private String[] getElements(BgElementCollection bgElement) {
        String[] elements = new String[bgElement.size()];
        for (int i = 0; i < bgElement.size(); ++i) {
            elements[i] = bgElement.get(i).getId().toString();
        }
        return elements;
    }

    private StringBuffer getBgDate(BigDecimal amountUnit, RptParams params, SchemaSource ss) {
        StringBuffer date = new StringBuffer();
        date.append("");
        String[] valueKey = new String[15];
        String[] valueName = new String[15];
        for (int i = 0; i < valueKey.length; ++i) {
            valueKey[i] = null;
        }
        date.append(" , D.FSumPastValue/").append(amountUnit).append(" FSumPastValue");
        valueKey[0] = "FSumPastValue";
        valueName[0] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"AdjustValue", (Locale)ContextUtils.getLocaleFromEnv());
        date.append(" , (A.FBgValue - D.FSumPastValue) AS FBalance");
        valueKey[1] = "FBalance";
        valueName[1] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BgValueBeforeAdjust", (Locale)ContextUtils.getLocaleFromEnv());
        date.append(" , A.FBgValue/").append(amountUnit).append(" FBgValue");
        valueKey[2] = "FBgValue";
        valueName[2] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"FBgValue", (Locale)ContextUtils.getLocaleFromEnv());
        date.append(" , A.FBizActual/").append(amountUnit).append(" BizActual");
        valueKey[3] = "BizActual";
        valueName[3] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BizActual", (Locale)ContextUtils.getLocaleFromEnv());
        date.append(" , A.FLYBgValue/").append(amountUnit).append(" FLYBgValue");
        valueKey[4] = "FLYBgValue";
        valueName[4] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"FLYBgValue", (Locale)ContextUtils.getLocaleFromEnv());
        date.append(" , A.FLYBizActual/").append(amountUnit).append(" FLYActualValue");
        valueKey[5] = "FLYActualValue";
        valueName[5] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"FLYActualValue", (Locale)ContextUtils.getLocaleFromEnv());
        date.append(" , ((A.FBgValue - A.FLYBgValue) / (case A.FLYBgValue when 0 then 1 else A.FLYBgValue end)) AS LYBgValueRate ");
        valueKey[6] = "LYBgValueRate";
        valueName[6] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"LYBgValueRate", (Locale)ContextUtils.getLocaleFromEnv());
        date.append(" , ((A.FBizActual - A.FLYBizActual) / (case A.FLYBizActual when 0 then 1 else A.FLYBizActual end)) AS LYActualValueRate ");
        valueKey[7] = "LYActualValueRate";
        valueName[7] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"LYActualValueRate", (Locale)ContextUtils.getLocaleFromEnv());
        date.append(" , A.ItemSumBgValue/").append(amountUnit).append(" FBgValueSum");
        valueKey[8] = "FBgValueSum";
        valueName[8] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"FBgValueSum", (Locale)ContextUtils.getLocaleFromEnv());
        date.append(" , A.ItemSumBizActual/").append(amountUnit).append(" BizActualSum");
        valueKey[9] = "BizActualSum";
        valueName[9] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BizActualSum", (Locale)ContextUtils.getLocaleFromEnv());
        date.append(" , A.SumBgValue/").append(amountUnit).append(" FTYBgValue");
        valueKey[10] = "FTYBgValue";
        valueName[10] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"FTYBgValue", (Locale)ContextUtils.getLocaleFromEnv());
        date.append(" , A.SumBizActual/").append(amountUnit).append(" FTYActualValue");
        valueKey[11] = "FTYActualValue";
        valueName[11] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"FTYActualValue", (Locale)ContextUtils.getLocaleFromEnv());
        date.append(" , (A.FBizActual / (case A.FBgValue when  0 then 1 else A.FBgValue end)) AS OperationPlan ");
        valueKey[12] = "OperationPlan";
        valueName[12] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"OperationPlan", (Locale)ContextUtils.getLocaleFromEnv());
        date.append(" , (A.FBgValue - A.FBizActual) AS OperationDifference ");
        valueKey[13] = "OperationDifference";
        valueName[13] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"OperationDifference", (Locale)ContextUtils.getLocaleFromEnv());
        date.append(" , ((A.FBgValue - A.FBizActual) / (case A.FBgValue when  0 then 1 else A.FBgValue end)) AS OperationDifferRate ");
        valueKey[14] = "OperationDifferRate";
        valueName[14] = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"OperationDifferRate", (Locale)ContextUtils.getLocaleFromEnv());
        this.setSchemaConfigFileMacroValue(valueKey, valueName, ss);
        return date;
    }

    private void setSchemaConfigFileMacroValue(String[] valueKey, String[] valueName, SchemaSource ss) {
        StringBuffer m = new StringBuffer();
        for (int i = 0; i < valueKey.length; ++i) {
            if (valueKey[i] == null || valueKey[i].equals("OperationPlan") || valueKey[i].equals("OperationDifferRate") || valueKey[i].equals("LYBgValueRate") || valueKey[i].equals("LYActualValueRate")) continue;
            m.append("<Measure name=\"" + valueKey[i] + "\" caption=\"" + valueName[i] + "\" column=\"" + valueKey[i] + "\" aggregator=\"sum\" formatString=\"#,##0.00\"/>\r\n");
        }
        ss.setMacroValue("Measure", m.toString());
    }

    private String[] getOrgs(OrgUnitInfo[] orgCont) {
        String[] orgs = new String[orgCont.length];
        for (int i = 0; i < orgCont.length; ++i) {
            if (orgCont[i] == null) continue;
            orgs[i] = orgCont[i].getId().toString();
        }
        return orgs;
    }

    private String dateToStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd H:mm:ss.mmm");
        return sdf.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getPeriods(BgPeriodInfo beginPeriodInfo, BgPeriodInfo endPeriodInfo, Context ctx) throws EASBizException, BOSException {
        if (beginPeriodInfo == null || endPeriodInfo == null) {
            return null;
        }
        BgPeriodCollection bgPeriodIds = null;
        String[] periods = null;
        try {
            bgPeriodIds = BgPeriodHelper.getPeriodColInfo(ctx, beginPeriodInfo.getBeginDate(), endPeriodInfo.getEndDate(), beginPeriodInfo.getPeriodType().getValue());
            periods = new String[bgPeriodIds.size()];
            for (int i = 0; i < bgPeriodIds.size(); ++i) {
                periods[i] = bgPeriodIds.get(i).getId().toString();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        return periods;
    }

    private BgPeriodInfo[] getBgPeriodInfosByIds(String[] bgPeriods, Context ctx) {
        if (bgPeriods == null) {
            return null;
        }
        int len = bgPeriods.length;
        BgPeriodInfo[] bgPeriodColl = new BgPeriodInfo[len];
        for (int i = 0; i < len; ++i) {
            try {
                bgPeriodColl[i] = BgPeriodFactory.getLocalInstance(ctx).getBgPeriodInfo("select * where id ='" + bgPeriods[i] + "'");
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)"budget error:", (Throwable)e);
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
        return bgPeriodColl;
    }

    private boolean isSameYear(BgPeriodInfo beginPeriodInfo, BgPeriodInfo endPeriodInfo) {
        int endYear;
        boolean isSameYear = true;
        int beginYear = beginPeriodInfo.getYear();
        if (beginYear == (endYear = endPeriodInfo.getYear())) {
            isSameYear = true;
        } else if (beginYear != endYear) {
            isSameYear = false;
        }
        return isSameYear;
    }

    private int getNumsOfYears(BgPeriodInfo beginPeriodInfo, BgPeriodInfo endPeriodInfo) {
        int beginYear = beginPeriodInfo.getYear();
        int endYear = endPeriodInfo.getYear();
        return endYear - beginYear + 1;
    }

    private int getTempYearLen(BgPeriodInfo bgPeriodInfo, Context ctx) {
        if (bgPeriodInfo == null) {
            return 0;
        }
        int bgPeriodType = bgPeriodInfo.getPeriodType().getValue();
        if (bgPeriodType == 1) {
            return 1;
        }
        if (bgPeriodType == 2) {
            return 2;
        }
        if (bgPeriodType == 3) {
            return 4;
        }
        if (bgPeriodType == 4) {
            return 12;
        }
        if (bgPeriodType == 5) {
            return 53;
        }
        if (bgPeriodType == 6) {
            return 5;
        }
        if (bgPeriodType == 7) {
            return 365;
        }
        return 0;
    }

    private int getThisYearBeginLen(BgPeriodInfo beginPeriodInfo, Context ctx) {
        int bgPeriodType = beginPeriodInfo.getPeriodType().getValue();
        if (bgPeriodType == 1) {
            return 1;
        }
        if (bgPeriodType == 2) {
            return 2 - beginPeriodInfo.getHalfYear() + 1;
        }
        if (bgPeriodType == 3) {
            return 4 - beginPeriodInfo.getQuarter() + 1;
        }
        if (bgPeriodType == 4) {
            return 12 - beginPeriodInfo.getMonth() + 1;
        }
        if (bgPeriodType == 5) {
            return 53 - beginPeriodInfo.getWeek() + 1;
        }
        if (bgPeriodType == 6) {
            return 5 - beginPeriodInfo.getWeek() + 1;
        }
        return 1;
    }

    private int getThisYearEndLen(BgPeriodInfo endPeriodInfo, Context ctx) {
        int bgPeriodType = endPeriodInfo.getPeriodType().getValue();
        if (bgPeriodType == 1) {
            return 1;
        }
        if (bgPeriodType == 2) {
            return endPeriodInfo.getHalfYear();
        }
        if (bgPeriodType == 3) {
            return endPeriodInfo.getQuarter();
        }
        if (bgPeriodType == 4) {
            return endPeriodInfo.getMonth();
        }
        if (bgPeriodType == 5) {
            return endPeriodInfo.getWeek();
        }
        if (bgPeriodType == 6) {
            return endPeriodInfo.getWeek();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bgPeriodIsUse(BgPeriodInfo info, String bgSchemeId, Context ctx) {
        if (info == null) {
            return false;
        }
        boolean isUse = false;
        String id = info.getId().toString();
        IRowSet rs = null;
        String sql = "select fid from t_bg_bgdata where fbgperiodid ='" + id + "' and fbgSchemeId = '" + bgSchemeId + "'";
        try {
            rs = this._executeQuery(ctx, sql, null);
            if (rs.next()) {
                isUse = true;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        finally {
            if (rs != null) {
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        return isUse;
    }

    private BgPeriodInfo getTempBgPeriodInfo(BgPeriodInfo beginPeriodInfo, int i, Context ctx) throws EASBizException, BOSException {
        if (beginPeriodInfo == null) {
            return null;
        }
        int bgPeriodType = beginPeriodInfo.getPeriodType().getValue();
        int yearNum = beginPeriodInfo.getYear();
        int tempYearNum = yearNum + i - 1;
        String yearNumber = tempYearNum + YearCode;
        String subNumber = null;
        if (bgPeriodType == 1) {
            subNumber = "";
        }
        if (bgPeriodType == 2) {
            subNumber = ".02HY";
        }
        if (bgPeriodType == 3) {
            subNumber = ".04Q";
        }
        if (bgPeriodType == 4) {
            subNumber = ".12M";
        }
        if (bgPeriodType == 5) {
            subNumber = ".53YW";
        }
        if (bgPeriodType == 6) {
            subNumber = ".12M.05MW";
        }
        if (bgPeriodType == 7) {
            subNumber = ".12M.31D";
        }
        String number = yearNumber + subNumber;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodCol = null;
        try {
            IBgPeriod ibgPeriod = BgPeriodFactory.getLocalInstance(ctx);
            if (ibgPeriod == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgPeriodCol = ibgPeriod.getBgPeriodCollection(view);
            if (bgPeriodCol != null && !bgPeriodCol.isEmpty()) {
                bgPeriodInfo = bgPeriodCol.get(0);
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        return bgPeriodInfo;
    }

    protected String getTableName(Context ctx, Connection conn) throws EASBizException {
        boolean isRepeat = true;
        String tmpName = "BITmp";
        Random random = new Random();
        DecimalFormat df = new DecimalFormat("000000");
        while (isRepeat) {
            ResultSet rst;
            PreparedStatement pstmt;
            block6: {
                tmpName = tmpName + df.format(random.nextInt(999999));
                pstmt = null;
                rst = null;
                try {
                    pstmt = conn.prepareStatement("select * from KSQL_USERTABLES where KSQL_TABNAME = ?");
                    pstmt.setString(1, tmpName);
                    rst = pstmt.executeQuery();
                    if (rst.next()) break block6;
                    isRepeat = false;
                }
                catch (SQLException ex) {
                    try {
                        throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst, (Statement)pstmt);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create temp TableName succeed!");
        }
        return tmpName;
    }

    protected boolean createKuaNianTable(Context ctx, String tableName, Connection conn) throws EASBizException {
        if (tableName == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tableName + " (FBgPeriodId VarChar(44), FLYBgPeriodId VarChar(44), FSumBgValue decimal(21,6), FSumBizActual decimal(21,6), FBGItemCombinId VarChar(44),FOrgUnitId VarChar(44) )");
        try {
            SQLUtils.execute((Connection)conn, (String)sql.toString());
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        return true;
    }

    protected boolean createSumTable(Context ctx, String tableName, Connection conn) throws EASBizException {
        if (tableName == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tableName + " (FOrgUnitId VarChar(44), FBgSchemeId VarChar(44),FBGItemCombinId VarChar(44),FSeq int)");
        try {
            SQLUtils.execute((Connection)conn, (String)sql.toString());
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        return true;
    }

    protected boolean createTable(Context ctx, String tableName, Connection conn) throws EASBizException {
        if (tableName == null) {
            throw new BgExamineException(BgExamineException.TMPTABLENAMECANTISNULL);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tableName + " (FBgPeriodId VarChar(44), FLYBgPeriodId VarChar(44))");
        try {
            SQLUtils.execute((Connection)conn, (String)sql.toString());
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        return true;
    }
}

