/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatus;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.RptOperationSchemaComp;
import com.kingdee.eas.fi.rpt.check.ReportCheck;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgAdjustBillEntryCollection;
import com.kingdee.eas.ma.budget.BgAdjustBillEntryInfo;
import com.kingdee.eas.ma.budget.BgAdjustBillFactory;
import com.kingdee.eas.ma.budget.BgAdjustBillInfo;
import com.kingdee.eas.ma.budget.BgColForPeriodFormInfo;
import com.kingdee.eas.ma.budget.BgColForPeriodHelper;
import com.kingdee.eas.ma.budget.BgCollectFormInfo;
import com.kingdee.eas.ma.budget.BgCollectHelper;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDecHelper;
import com.kingdee.eas.ma.budget.BgDecomposerFormInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgTemMeasureUnitCollection;
import com.kingdee.eas.ma.budget.BgTemMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgAdjustBill;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.RefBgDecFormInfo;
import com.kingdee.eas.ma.budget.RefBgFormInfo;
import com.kingdee.eas.ma.budget.app.AbstractBgFormControllerBean;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNDataInfo;
import com.kingdee.eas.ma.nbudget.BgNExpressionHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.BgNFormFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.BgSpecialBudgetHelper;
import com.kingdee.eas.ma.nbudget.IBgNFormFacade;
import com.kingdee.eas.ma.nbudget.app.BgCodeNumberNHelper;
import com.kingdee.eas.ma.nbudget.utils.BgCodeRuleNUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgFormControllerBean
extends AbstractBgFormControllerBean {
    private static final long serialVersionUID = -6861427705865491617L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgFormControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = null;
        IBgNFormFacade ibgNFormFacade = BgNFormFacadeFactory.getLocalInstance((Context)ctx);
        if (ibgNFormFacade == null) {
            throw new BgFormException(BgFormException.NOINSTANCE);
        }
        this.checkBatchAddNewBgFormInfo(ctx, model);
        if (BgNFSHelper.checkHasBudget((IObjectValue)model)) {
            int state = model.getInt("state");
            if (state == 42 || state == 103) {
                model.setInt("state", 1);
            }
            if (BgNFSHelper.checkHasAdjust((IObjectValue)model)) {
                if (((BgFormInfo)model).getBgTemplate().getFormType().getValue() != 4) {
                    ibgNFormFacade.getAdjustSheet(model);
                }
            } else {
                ibgNFormFacade.getBudgetSheet(model);
            }
        } else if (BgNFSHelper.checkHasActual((IObjectValue)model)) {
            ibgNFormFacade.getActualSheet(model);
        }
        BgNFSHelper.clearTypeSign((IObjectValue)model);
        try {
            Range unLock = null;
            Book _book = ((BgFormInfo)model).getBook();
            if (_book != null) {
                int _sheetSize = _book.getSheetCount();
                for (int _sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
                    Sheet _sheet = _book.getSheet(_sheetIndex);
                    int rowCount = _sheet.getMaxRowIndex();
                    int colCount = _sheet.getMaxColIndex();
                    for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                        for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                            Cell _cell = _sheet.getCell(rowIndex, colIndex, false);
                            if (_cell == null || BgNFSHelper.getCellData((Cell)_cell, (String)"BGDATA_STATE_LOCK") == null) continue;
                            BgNFSHelper.removeCellData((Cell)_cell, (String)"BGDATA_STATE_LOCK");
                            if (unLock == null) {
                                unLock = _sheet.getRange(_cell);
                                continue;
                            }
                            unLock.addAll((SortedCellBlockArray)_sheet.getRange(_cell));
                        }
                    }
                }
            }
            if (unLock != null && _book != null) {
                boolean autoCal = _book.isAutoCalculate();
                _book.setAutoCalculate(false);
                StyleAttributes sa = Styles.getEmptySA();
                sa.setLocked(false);
                unLock.setIgnoreProtected(true);
                unLock.setStyle(sa, Styles.getEmptySA());
                ((BgFormInfo)model).setBook(_book);
                _book.setAutoCalculate(autoCal);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        pk = super._save(ctx, model);
        return pk;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgFormInfo _bgFormInfo = (BgFormInfo)model;
        if (_bgFormInfo.getCU() == null) {
            _bgFormInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        int maxApply = 10;
        int apply = 0;
        Connection conn = null;
        BgCodeRuleNUtils ruleRule = new BgCodeRuleNUtils(ctx, false);
        try {
            conn = this.getConnection(ctx);
            if (_bgFormInfo.getState().getValue() != 4 && _bgFormInfo.getState().getValue() != 15 && _bgFormInfo.getState().getValue() != 6 && _bgFormInfo.getState().getValue() != 101) {
                String orgUnitId = _bgFormInfo.getOrgUnit().getId().toString();
                do {
                    ruleRule.applyNumber((IObjectValue)_bgFormInfo, orgUnitId, "sourceType", null);
                } while (this.checkBgFormNumber(conn, _bgFormInfo, true) && ++apply < maxApply);
                if (this.checkBgFormNumber(conn, _bgFormInfo, false)) {
                    throw new BgFormException(BgFormException.NUMBERREPEAT, new String[]{_bgFormInfo.getNumber()});
                }
                ruleRule.applyNumber((IObjectValue)_bgFormInfo, orgUnitId, "sourceType", "name");
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        if (StringUtils.isEmpty((String)_bgFormInfo.getNumber())) {
            _bgFormInfo.setNumber("BgForm-" + System.currentTimeMillis());
        }
        if (_bgFormInfo.getNumber().indexOf("(") >= 0 || _bgFormInfo.getNumber().indexOf(")") >= 0) {
            throw new BgNFormException(BgNFormException.NUMBERERROR);
        }
        String logName = _bgFormInfo.getNumber() + " " + _bgFormInfo.getName();
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgForm_addNew");
        ((BgFormInfo)model).setIsConfirm(false);
        if (model.get("record") == null) {
            model.setInt("record", 0);
        }
        IObjectPK result = super._addnew(ctx, model);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return result;
    }

    @Override
    protected IObjectPK _submit(Context ctx, BOSUuid bgFormId, IObjectValue model, boolean isBudget) throws BOSException, EASBizException {
        if (isBudget) {
            BgNFSHelper.setBudget((IObjectValue)model);
        } else {
            BgNFSHelper.setActual((IObjectValue)model);
        }
        return this._save(ctx, model);
    }

    @Override
    protected void _updateValue(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null || !(model instanceof BgFormInfo)) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        String _bgFormId = model.getString("id");
        byte[] _bytes = model.getBytes("data");
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgForm set FData = ? where FID = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            if (_bytes != null && _bytes.length > 0) {
                BgInfoHelper.setBytes((PreparedStatement)pstmt, (int)1, (byte[])_bytes);
            } else {
                pstmt.setBytes(1, null);
            }
            pstmt.setString(2, _bgFormId);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _updateValue(Context ctx, IObjectValue model, Map valueMap, boolean isBudget) throws BOSException, EASBizException {
        if (model == null || !(model instanceof BgFormInfo)) {
            return;
        }
        this._updateValue(ctx, model);
        if (valueMap == null || valueMap.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        int batchIndex = 0;
        int batchSize = 200;
        String _formula2 = null;
        String _bgFormId = ((BgFormInfo)model).getId().toString();
        BigDecimal _value = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgData set " + (isBudget ? "FBgValue" : "FBgActual") + " = ? where FBgFormId = ? and FFormula = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (String _formula2 : valueMap.keySet()) {
                _value = (BigDecimal)valueMap.get(_formula2);
                pstmt.setBigDecimal(1, _value);
                pstmt.setString(2, _bgFormId);
                pstmt.setString(3, _formula2);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void checkBatchAddNewBgFormInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        BgFormInfo _bgFormInfo = (BgFormInfo)model;
        if (_bgFormInfo.getZipData() == null || _bgFormInfo.getZipData().length == 0) {
            IBgTemplate ibgTemplate = null;
            ObjectUuidPK pk = null;
            BgTemplateInfo _bgTemplateInfo = null;
            Book _book = null;
            Sheet _sheet = null;
            Cell _cell = null;
            String _formulaStr = null;
            String _tmpformulaStr = null;
            int rowIndex = 0;
            int rowCount = 0;
            int colIndex = 0;
            int colCount = 0;
            ibgTemplate = BgTemplateFactory.getLocalInstance(ctx);
            _bgTemplateInfo = ibgTemplate.getBgTemplateInfo((IObjectPK)(pk = new ObjectUuidPK(_bgFormInfo.getBgTemplate().getId())), this.getTemplateSelector(_bgFormInfo.getBgTemplate()));
            boolean isSpecialForm = 3 == _bgTemplateInfo.getFormType().getValue();
            _bgFormInfo.setZipData(_bgTemplateInfo.getZipData());
            _bgFormInfo.setBgType(_bgTemplateInfo.getBgType());
            _bgFormInfo.setMeasureUnit(_bgTemplateInfo.getDefaultMeasureUnit());
            _bgFormInfo.setTemplateLastUpdateTime(_bgTemplateInfo.getLastUpdateTime());
            if (_bgTemplateInfo.getBgMeasureUnit() != null && !_bgTemplateInfo.getBgMeasureUnit().isEmpty()) {
                BgMeasureUnitInfo bgMeasureUnit = null;
                BgTemMeasureUnitInfo bgTemInfo = null;
                BgTemMeasureUnitCollection bgTemCol = _bgTemplateInfo.getBgMeasureUnit();
                Iterator iter = bgTemCol.iterator();
                while (iter.hasNext()) {
                    bgTemInfo = (BgTemMeasureUnitInfo)iter.next();
                    bgMeasureUnit = new BgMeasureUnitInfo();
                    bgMeasureUnit.setBgForm(_bgFormInfo);
                    bgMeasureUnit.setBgElement(bgTemInfo.getBgElement());
                    bgMeasureUnit.setMeasureUnit(bgTemInfo.getMeasureUnit());
                    _bgFormInfo.getBgMeasureUnit().add(bgMeasureUnit);
                }
            }
            UserInfo _user = _bgFormInfo.getCreator();
            String[] _formulaInfo = null;
            ArrayList<String[]> _formulaCheckList = new ArrayList<String[]>();
            try {
                _book = _bgFormInfo.getBook();
                BgNFSHelper.disableUndo((Book)_book);
                BgNFSHelper.disableCal((Book)_book);
                if (isSpecialForm) {
                    if (_bgFormInfo.getBgItem().getOrgUnit() == null && _bgFormInfo.getOrgUnit() != null) {
                        _bgFormInfo.getBgItem().setOrgUnit(_bgFormInfo.getOrgUnit());
                    }
                    BgSpecialBudgetHelper.fillAndbuildFormula((Book)_book, (BgItemInfo)_bgFormInfo.getBgItem(), (Context)ctx);
                }
                int sheetSize = _book.getSheetCount();
                for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                    _sheet = _book.getSheet(sheetIndex);
                    BgNFSHelper.replaceSheetSign((Sheet)_sheet);
                    if (_sheet != null && _sheet.getUserObject("SHEET_CREATER_ID") == null) {
                        _sheet.setUserObject("SHEET_CREATER_ID", (Object)_user.getId().toString());
                    }
                    String companyNumber = BgNExpressionHelper.getCompanyNumber((Context)ctx, (IObjectValue)model);
                    rowCount = _sheet.getMaxRowIndex();
                    colCount = _sheet.getMaxColIndex();
                    for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                        for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                            _cell = _sheet.getCell(rowIndex, colIndex, false);
                            if (BgNFSHelper.checkHasFormulaOfCell((Cell)_cell)) {
                                _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)_cell);
                                if (!_formulaStr.equals(_tmpformulaStr = BgNFSHelper.checkFormula(null, (String)_formulaStr, (IObjectValue)model))) {
                                    BgNFSHelper.setFormulaOfCell((Cell)_cell, (String)_tmpformulaStr);
                                    _formulaStr = _tmpformulaStr;
                                }
                                BgNFSHelper.setFormulaEditOfDisable((Cell)_cell);
                                BgNFSHelper.setValue((Cell)_cell, (Object)BgNConstants.ZERO);
                                BgNFSHelper.setBudgetValue((Cell)_cell, (BigDecimal)BgNConstants.ZERO);
                                BgNFSHelper.setActualValue((Cell)_cell, (BigDecimal)BgNConstants.ZERO);
                                _formulaInfo = new String[]{_sheet.getSheetName(), _formulaStr, String.valueOf(rowIndex), String.valueOf(colIndex)};
                                _formulaCheckList.add(_formulaInfo);
                            }
                            BgNFSHelper.checkExpressions((Cell)_cell, (IObjectValue)model, (int)1, (String)companyNumber);
                            BgNFSHelper.checkExpressions((Cell)_cell, (IObjectValue)model, (int)0, (String)companyNumber);
                        }
                    }
                }
                BgNExpressionHelper.dealAcctItemExpression((Context)ctx, (Book)_book, (IObjectValue)model);
                BgNFSHelper.checkFormulaIsEctype(_formulaCheckList);
                BgNFSHelper.checkBookSign((Book)_book);
                _book.activeSheet(0);
                _bgFormInfo.setBook(_book);
                BgNFSHelper.setBudget((IObjectValue)model);
            }
            catch (Exception ex) {
                if (ex instanceof BgFormException) {
                    BgFormException e = (BgFormException)((Object)ex);
                    throw e;
                }
                throw new BOSException((Throwable)ex);
            }
        }
    }

    protected SelectorItemCollection getTemplateSelector(BgTemplateInfo templateInfo) {
        byte[] _bytes;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        byte[] byArray = _bytes = templateInfo != null ? templateInfo.getData() : null;
        if (_bytes == null || _bytes.length == 0) {
            sic.add("data");
        }
        sic.add("lastUpdateTime");
        sic.add("bgType.id");
        sic.add("defaultMeasureUnit.id");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("formType");
        sic.add("data");
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected boolean _checkTemplateQuoted(Context ctx, String schemeId, String templateId) throws BOSException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        boolean re;
        block5: {
            re = false;
            if (schemeId == null || schemeId.trim().length() == 0 || templateId == null || templateId.trim().length() == 0) {
                return false;
            }
            conn = null;
            pstmt = null;
            rst = null;
            conn = this.getConnection(ctx);
            try {
                pstmt = conn.prepareStatement("select FID from T_BG_BgForm where FBgSchemeID = ? AND FBgTemplateID = ?");
                pstmt.setString(1, schemeId);
                pstmt.setString(2, templateId);
                rst = pstmt.executeQuery();
                if (!rst.next()) break block5;
                re = true;
            }
            catch (SQLException sQLException) {
                SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return re;
    }

    protected void updateRow(IRow sRow, int colCount, Map formulaMap, Map bargainMap, Map aliasMap, Set aliasSet) {
        if (sRow == null) {
            return;
        }
        BOSUuid rowId = null;
        String formulaString = null;
        String tmpFormulaString = null;
        String valueStr = null;
        BigDecimal value = null;
        BigDecimal add = null;
        ICell sCell = null;
        ICell _tmpCell = null;
        RptCell _tmpRptCell = null;
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            sCell = sRow.getCell(colIndex);
            if (!BgFSHelper.checkHasFormulaOfCell(sCell) || !formulaMap.containsKey(tmpFormulaString = this.getFormulaOfBargain(formulaString = BgFSHelper.getFormulaOfCell(sCell), bargainMap))) continue;
            _tmpCell = (ICell)formulaMap.get(tmpFormulaString);
            _tmpRptCell = (RptCell)_tmpCell.getUserObject();
            rowId = (BOSUuid)aliasMap.get(tmpFormulaString);
            aliasSet.add(rowId);
            if (_tmpCell.getValue() != null) {
                valueStr = _tmpCell.getValue().toString();
            }
            try {
                value = new BigDecimal(valueStr);
            }
            catch (Exception ex) {
                value = BgConstants.BIGZERO;
            }
            try {
                add = new BigDecimal(sCell.getValue().toString());
            }
            catch (Exception ex) {
                add = BgConstants.BIGZERO;
            }
            value = value.add(add);
            valueStr = value.toString();
            _tmpCell.setValue((Object)valueStr);
            _tmpRptCell.getItemFormula().putExt("BG_BUDGET_VALUE", valueStr);
            if (formulaString.equals(tmpFormulaString)) continue;
            _tmpRptCell.getItemFormula().putExt("DATA_SOURCE_TEMP_FUDIAN", Boolean.TRUE.toString());
        }
    }

    protected boolean hasAddNewFormula(IRow row, int colCount, Map formulaMap, Map bargainMap) {
        if (row == null) {
            return false;
        }
        ICell cell = null;
        String formulaString = null;
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            cell = row.getCell(colIndex);
            if (!BgFSHelper.checkHasFormulaOfCell(cell)) continue;
            formulaString = BgFSHelper.getFormulaOfCell(cell);
            if (formulaMap.containsKey(formulaString = this.getFormulaOfBargain(formulaString, bargainMap))) continue;
            return true;
        }
        return false;
    }

    protected String getFormulaOfBargain(String formulaString, Map bargainMap) {
        if (formulaString == null) {
            return null;
        }
        String[] parameter = null;
        String[] bgItems = null;
        StringBuffer _tmpBgItem = new StringBuffer();
        parameter = BgFSHelper.getFormulaInfo(null, formulaString);
        if (parameter != null && (bgItems = parameter[BgSHelper.paraItem].split(",")).length > 1) {
            int i;
            int n = bgItems.length;
            for (i = 0; i < n; ++i) {
                if (bargainMap == null || !bargainMap.containsKey(bgItems[i])) continue;
                bgItems[i] = null;
            }
            n = bgItems.length;
            for (i = 0; i < n; ++i) {
                if (bgItems[i] == null) continue;
                _tmpBgItem.append(bgItems[i] + ",");
            }
            parameter[BgSHelper.paraItem] = _tmpBgItem.delete(_tmpBgItem.length() - 1, _tmpBgItem.length()).toString();
            formulaString = new StringBuffer("=BgItem(\"" + parameter[BgSHelper.paraItem] + "\",\"" + parameter[BgSHelper.paraPeriod] + "\",\"" + parameter[BgSHelper.paraElement] + "\",\"" + parameter[BgSHelper.paraDataType] + "\"," + parameter[BgSHelper.paraCollect] + ",\"" + parameter[BgSHelper.paraCurrency] + "\")").toString();
        }
        return formulaString;
    }

    protected boolean checkBgFormNumber(Connection conn, BgFormInfo model, boolean hasClearNumber) throws EASBizException {
        boolean re = false;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("select FID from T_BG_BgForm where FNumber = ? and FOrgUnitID = ? and FID <> ?");
            pstmt.setString(1, model.getNumber());
            pstmt.setString(2, model.getOrgUnit().getId().toString());
            pstmt.setString(3, model.getId().toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                re = true;
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        if (re && hasClearNumber) {
            model.setNumber(null);
        }
        return re;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        String _bgFormId = null;
        String _tmpFormId = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgFormInfo info = null;
        _bgFormId = pk.toString();
        try {
            conn = this.getConnection(ctx);
            info = BgInfoHelper.getBgFormInfo((Connection)conn, (BOSUuid)BOSUuid.read((String)_bgFormId), (boolean)false);
            if (info == null) {
                throw new BgFormException(BgFormException.NOBGFORMINFO);
            }
            if (info.getState().getValue() != 1 && info.getState().getValue() != 4) {
                return;
            }
            pstmt = conn.prepareStatement("select FBgFormID from T_BG_BgDecForPeriodForm where FBgFormID = '" + pk.toString() + "' and FState in ('100') ");
            rst = pstmt.executeQuery();
            if (rst.next()) {
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
                return;
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (1 == info.getState().getValue()) {
                BgCodeNumberNHelper.recycleNumber((Context)ctx, (IObjectValue)info, (String)info.getOrgUnit().getId().toString(), (String)info.getNumber(), (String)"sourceType");
            }
            AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
            pstmt = conn.prepareStatement("select fid from T_BG_BgForm where FAdjustId = ? and fid <> ?");
            pstmt.setString(1, pk.toString());
            pstmt.setString(2, pk.toString());
            rst = pstmt.executeQuery();
            String logName = info.getNumber() + " " + info.getName();
            IObjectPK Loginpk = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgForm_remove");
            while (rst.next()) {
                _tmpFormId = rst.getString(1);
                if (StringUtils.isEmpty((String)_tmpFormId)) continue;
                BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgAuditIdea where FBgFormId = ?", (String)_tmpFormId);
                BgNSQLHelper.execute((Context)ctx, (String)"delete from T_RPT_RptSheetPara where FReportID = ?", (String)_tmpFormId);
                BgNSQLHelper.execute((Context)ctx, (String)"delete from T_RPT_RptPostil where FReportID = ?", (String)_tmpFormId);
                BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgPastData where FPastRecordID IN (select FID from T_BG_BgPastRecord where FBgFormID = ?)", (String)_tmpFormId);
                BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgPastRecord where FBgFormID = ?", (String)_tmpFormId);
                BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgRefBgCurrency where FBgFormID = ?", (String)_tmpFormId);
                BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgRefBgElement where FBgFormID = ?", (String)_tmpFormId);
                BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgRefBgPeriod where FBgFormID = ?", (String)_tmpFormId);
                BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgRefBgItemCombin where FBgFormID = ?", (String)_tmpFormId);
                BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgMeasureUnit where FBgFormID = ?", (String)_tmpFormId);
                BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgSheet where FBgFormId = ?", (String)_tmpFormId);
                asm.deleteAttachemtsByBoID(_tmpFormId);
                BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgCtrlRecord where FBillId = ?", (String)_tmpFormId);
                BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgBillIntegrateForm where FEntryId in(Select fid from t_Bg_bgFormEntry where fbgformid = ?)", (String)_tmpFormId);
                BgNSQLHelper.execute((Context)ctx, (String)"delete from t_Bg_bgFormEntry where fbgformid = ?", (String)_tmpFormId);
                BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgForm where FId = ?", (String)_tmpFormId);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            asm.deleteAttachemtsByBoID(_bgFormId);
            BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgAuditIdea where FBgFormId = ?", (String)_bgFormId);
            BgNSQLHelper.execute((Context)ctx, (String)"delete from T_RPT_RptSheetPara where FReportID = ?", (String)_bgFormId);
            BgNSQLHelper.execute((Context)ctx, (String)"delete from T_RPT_RptPostil where FReportID = ?", (String)_bgFormId);
            BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgPastData where FPastRecordID IN (select FID from T_BG_BgPastRecord where FBgFormID = ?)", (String)_bgFormId);
            BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgPastRecord where FBgFormID = ?", (String)_bgFormId);
            BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgRefBgCurrency where FBgFormID = ?", (String)_bgFormId);
            BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgRefBgElement where FBgFormID = ?", (String)_bgFormId);
            BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgRefBgPeriod where FBgFormID = ?", (String)_bgFormId);
            BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgRefBgItemCombin where FBgFormID = ?", (String)_bgFormId);
            BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgMeasureUnit where FBgFormID = ?", (String)_bgFormId);
            BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgSheet where FBgFormId = ?", (String)_bgFormId);
            BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgGatherInfo where FBgFormId = ?", (String)_bgFormId);
            BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgCtrlRecord where FBillId = ?", (String)_bgFormId);
            this.clearBgData(conn, _bgFormId);
            if (!info.getId().equals((Object)info.getAdjust().getId())) {
                this.clearBgTmpData(conn, info.getAdjust().getId().toString());
            }
            BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgBillIntegrateForm where FEntryId in(Select fid from t_Bg_bgFormEntry where fbgformid = ?)", (String)_bgFormId);
            BgNSQLHelper.execute((Context)ctx, (String)"delete from t_Bg_bgFormEntry where fbgformid = ?", (String)_bgFormId);
            BgNSQLHelper.execute((Context)ctx, (String)"delete from T_BG_BgForm where FId = ?", (String)_bgFormId);
            BgCodeRuleNUtils ruleRule = new BgCodeRuleNUtils(ctx, false);
            ruleRule.recycleNumber((IObjectValue)info, info.getOrgUnit().getId().toString(), new String[]{info.getNumber()}, null);
            LogUtil.afterLog((Context)ctx, (IObjectPK)Loginpk);
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException ex) {
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
    }

    private void clearBgTmpData(Connection conn, String bgAdjustId) throws SQLException, EASBizException {
        if (!StringUtils.isEmpty((String)bgAdjustId)) {
            ArrayList<String> bgFormIds = new ArrayList<String>();
            bgFormIds.add(bgAdjustId);
            this.clearBgTmpData(conn, bgFormIds);
        }
    }

    private void clearBgData(Connection conn, String bgFormId) throws SQLException, EASBizException {
        if (!StringUtils.isEmpty((String)bgFormId)) {
            ArrayList<String> bgFormIds = new ArrayList<String>();
            bgFormIds.add(bgFormId);
            this.clearBgData(conn, bgFormIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBgData(Connection conn, List bgFormIds) throws SQLException, EASBizException {
        if (conn == null || bgFormIds == null || bgFormIds.isEmpty()) {
            return;
        }
        this.execute(conn, "delete T_Bg_BgDataEntry where FBgFormId = ?", bgFormIds);
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            Set subSet;
            HashMap refs = new HashMap();
            StringBuffer sql = new StringBuffer("select bgData.FID bgData_FID, dataEntry.FBgFormId dataEntry_FBgFormId from T_Bg_BgData bgData left join T_Bg_BgDataEntry dataEntry on bgData.FID = dataEntry.FBgDataId where bgData.FBgFormId in (");
            BgNSQLHelper.addPlaceHolder((StringBuffer)sql).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            Object[] ids = bgFormIds.toArray();
            int count = BgNSQLHelper.getBatchCount((Object[])ids);
            for (int i = 0; i < count; ++i) {
                BgNSQLHelper.setParam4BatchDefCount((PreparedStatement)pstmt, (int)1, (int)i, (Object[])ids);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    String bgDataId = rst.getString("bgData_FID");
                    String formId = rst.getString("dataEntry_FBgFormId");
                    if (!refs.containsKey(bgDataId)) {
                        refs.put(bgDataId, new HashSet());
                    }
                    subSet = (Set)refs.get(bgDataId);
                    if (StringUtils.isEmpty((String)formId)) continue;
                    subSet.add(formId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmt);
            ArrayList<Object[]> delList = new ArrayList<Object[]>();
            ArrayList<Object[]> updateList = new ArrayList<Object[]>();
            for (String bgDataId : refs.keySet()) {
                Object[] params;
                subSet = (Set)refs.get(bgDataId);
                if (subSet == null || subSet.isEmpty()) {
                    params = new Object[]{bgDataId};
                    delList.add(params);
                    continue;
                }
                params = new Object[]{subSet.toArray()[0], bgDataId};
                updateList.add(params);
            }
            BgNSQLHelper.executeBatch((Connection)conn, (String)"update T_Bg_BgData set FBgFormId = ? where FID = ?", updateList);
            BgNSQLHelper.executeBatch((Connection)conn, (String)"delete from T_Bg_BgData where FID = ?", delList);
            BgNSQLHelper.executeBatch((Connection)conn, (String)"delete from T_Bg_BgBillIntegrateRecord where FBgDataID = ?", delList);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
    }

    private void clearBgTmpData(Connection conn, List adjustPK) throws SQLException, EASBizException {
        if (conn == null || adjustPK == null || adjustPK.isEmpty()) {
            return;
        }
        Object formulaString = null;
        String fid = null;
        Object divData = null;
        HashSet<String> fidSet = new HashSet<String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer tmpSql = new StringBuffer();
        StringBuffer selSql = new StringBuffer();
        selSql.append("SELECT FId FROM T_BG_BgTmpData WHERE FBgFormId in(");
        tmpSql.append("delete from T_BG_BgTmpData where Fid = ?");
        try {
            BgNSQLHelper.addPlaceHolder((StringBuffer)selSql, (int)200).append(")");
            pstmt = conn.prepareStatement(selSql.toString());
            int batchCount = (adjustPK.size() - 1) / 200 + 1;
            for (int i = 0; i < batchCount; ++i) {
                BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)1, (int)i, (int)200, (Object[])adjustPK.toArray());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    fid = rst.getString("FID");
                    fidSet.add(fid);
                }
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            BgNSQLHelper.executeBatch((Connection)conn, (String)tmpSql.toString(), new ArrayList(fidSet));
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    private Map getFormSchemeByOrgUnit(Context ctx, String bgSchemeRootId, Map OrgUnitMap, String bgOrgLongNum) throws BOSException, EASBizException {
        HashMap bgSchemeMap = new HashMap();
        if (bgSchemeRootId == null) {
            return bgSchemeMap;
        }
        ArrayList<String> _tmp = new ArrayList<String>();
        _tmp.add(bgSchemeRootId);
        StringBuffer sql = new StringBuffer();
        sql.append("Select FID from T_BG_BgScheme where FROOTID = ?");
        if (OrgUnitMap != null && !OrgUnitMap.isEmpty()) {
            sql.append(" AND FOrgUnitID IN (");
            Iterator iter = OrgUnitMap.keySet().iterator();
            while (iter.hasNext()) {
                sql.append("?, ");
                _tmp.add(iter.next().toString());
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (bgOrgLongNum != null) {
            _tmp.add(bgOrgLongNum + "!%");
            _tmp.add(bgOrgLongNum);
            sql.append(" AND FOrgUnitID IN (");
            sql.append(" select fid from t_org_costcenter where flongnumber like ? or flongnumber = ?");
            sql.append(")");
        }
        String bgSchemeId = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmp);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgSchemeId = rst.getString("FID");
                if (bgSchemeMap.containsKey(bgSchemeId)) continue;
                bgSchemeMap.put(bgSchemeId, null);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgSchemeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getFormTemplateByOrgUnit(Context ctx, String pTemplateId, Map bgSchemeMap, Map OrgUnitMap, String bgOrgLongNum) throws BOSException {
        HashMap<String, String> bgTemplateMap = new HashMap<String, String>();
        if (pTemplateId == null || bgSchemeMap == null || bgSchemeMap.isEmpty()) {
            return bgTemplateMap;
        }
        ArrayList<String> _tmp = new ArrayList<String>();
        _tmp.add(pTemplateId);
        StringBuffer sql = new StringBuffer();
        sql.append("Select a.FID, b.FBgSchemeID FROM T_BG_BgTemplate a INNER JOIN T_BG_BgSchemeNode b ON a.FID = b.FBgTemplateID where a.FRootId = ?");
        if (OrgUnitMap != null && !OrgUnitMap.isEmpty()) {
            sql.append(" AND a.FOrgUnitID IN (");
            Iterator iter = OrgUnitMap.keySet().iterator();
            while (iter.hasNext()) {
                sql.append("?, ");
                _tmp.add(iter.next().toString());
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        if (bgOrgLongNum != null) {
            _tmp.add(bgOrgLongNum + "!%");
            _tmp.add(bgOrgLongNum);
            sql.append(" AND FOrgUnitID IN (");
            sql.append(" select fid from t_org_costcenter where flongnumber like ? or  flongnumber = ?");
            sql.append(")");
        }
        String bgTemplateId = null;
        String bgSchemeId = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmp);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgTemplateId = rst.getString("FID");
                bgSchemeId = rst.getString("FBgSchemeID");
                if (!bgSchemeMap.containsKey(bgSchemeId) || bgTemplateMap.containsKey(bgTemplateId)) continue;
                bgTemplateMap.put(bgTemplateId, bgSchemeId);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgTemplateMap;
    }

    @Override
    protected Map _getFormFilterInfo(Context ctx, BOSUuid bgFormId, List state) throws BOSException, EASBizException {
        if (bgFormId == null) {
            return new HashMap();
        }
        Map resultMap = new HashMap();
        Connection conn = null;
        IBgForm ibgForm = null;
        BgFormInfo bgFormInfo = null;
        try {
            conn = this.getConnection(ctx);
            ibgForm = BgFormFactory.getLocalInstance(ctx);
            if (ibgForm == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), BgNFSHelper.getGatherSelectors());
            resultMap = this.getBgFormIdsByState(ctx, conn, bgFormInfo, state, resultMap);
        }
        catch (BOSException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return resultMap;
    }

    protected Map getBgFormIdsByState(Context ctx, Connection conn, BgFormInfo model, List state, Map resultMap) throws EASBizException {
        if (conn == null || model == null) {
            return resultMap;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _rBgSchemeId = null;
        String _rBgTemplateId = null;
        String _bgPeriodId = null;
        String _currencyId = null;
        String _bgFormId = null;
        String _orgUnitId = null;
        String orgUnitLongNumber = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("orgUnit.id"));
        selector.add(new SelectorItemInfo("orgUnit.longNumber"));
        try {
            BgFormInfo info = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(model.getId().toString()), selector);
            orgUnitLongNumber = info.getOrgUnit().getLongNumber();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            throw new BgFormException(BgFormException.NOBGFORMINFO, new String[]{e.getMessage()});
        }
        _rBgSchemeId = model.getBgScheme().getRootId().toString();
        _rBgTemplateId = model.getBgTemplate().getRootId().toString();
        _bgPeriodId = model.getBgPeriod().getId().toString();
        _currencyId = model.getCurrency().getId().toString();
        ArrayList<Object> _tmpList = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT f.FID, f.FOrgUnitId FROM T_BG_BgForm f left join T_BG_BgScheme s on f.FBgSchemeId = s.FID left join T_BG_BgTemplate t on f.FBgTemplateId = t.FID left join t_org_costcenter u on f.FOrgUnitId = u.FID WHERE s.FRootId = ? AND t.FRootId = ? AND f.FBgPeriodId = ? AND f.fCurrencyId = ? ");
        sql.append(" and u.flongnumber like '").append(orgUnitLongNumber).append("%' ");
        _tmpList.add(_rBgSchemeId);
        _tmpList.add(_rBgTemplateId);
        _tmpList.add(_bgPeriodId);
        _tmpList.add(_currencyId);
        if (state != null && state.size() > 0) {
            sql.append(" AND f.FState IN (");
            int in = state.size();
            for (int i = 0; i < in; ++i) {
                sql.append("?,");
                _tmpList.add(new Integer(((BgFormStateEnum)((Object)state.get(i))).getValue()));
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
        }
        try {
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _bgFormId = rst.getString(1);
                _orgUnitId = rst.getString(2);
                resultMap.put(_bgFormId, _orgUnitId);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return resultMap;
    }

    @Override
    protected Map _getFormFilterInfo(Context ctx, Map filterInfo) throws BOSException, EASBizException {
        if (filterInfo == null || filterInfo.isEmpty()) {
            return filterInfo;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        ArrayList<Object> _tmpList1 = new ArrayList<Object>();
        _tmpList1.add(new Integer(4));
        String bgFormId2 = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FAdjustID from T_BG_BgForm where (FState = ?) and FAdjustID in (");
        for (String bgFormId2 : filterInfo.keySet()) {
            sql.append("?, ");
            _tmpList1.add(bgFormId2);
        }
        sql.delete(sql.length() - 2, sql.length());
        sql.append(")");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList1);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgFormId2 = rst.getString(2);
                if (!filterInfo.containsKey(bgFormId2)) continue;
                filterInfo.remove(bgFormId2);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!filterInfo.isEmpty()) {
                ArrayList<Object> _tmpList = new ArrayList<Object>();
                _tmpList.add(new Integer(9));
                sql = new StringBuffer();
                sql.append("select e.FBgFormId from T_BG_BgAdjustBill t left outer join T_BG_BgAdjustBillEntry e on t.FID = e.FAdjustBillId ");
                sql.append("where t.FState <> ? and e.FBgFormId IN (");
                for (String bgFormId2 : filterInfo.keySet()) {
                    sql.append("?, ");
                    _tmpList.add(bgFormId2);
                }
                sql.delete(sql.length() - 2, sql.length());
                sql.append(")");
                pstmt = conn.prepareStatement(sql.toString());
                BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgFormId2 = rst.getString(1);
                    if (!filterInfo.containsKey(bgFormId2)) continue;
                    filterInfo.remove(bgFormId2);
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return filterInfo;
    }

    @Override
    protected HashMap _getFormDecomposerInfo(Context ctx, BOSUuid id, int state) throws BOSException, EASBizException {
        if (id == null) {
            return new HashMap();
        }
        HashMap bgFormTab = new HashMap();
        ObjectUuidPK pk = null;
        BgFormInfo tempInfo = null;
        try {
            IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
            if (ibgForm == null) {
                throw new BgFormException(BgFormException.NOBGFORMINFO);
            }
            pk = new ObjectUuidPK(id);
            tempInfo = ibgForm.getBgFormInfo((IObjectPK)pk, BgNFSHelper.getGatherSelectors());
            bgFormTab = this.getFormDecInfo(ctx, tempInfo, state);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        return bgFormTab;
    }

    private HashMap getFormDecInfo(Context ctx, BgFormInfo model, int state) throws EASBizException, BOSException {
        HashMap<String, String> bgFormTab = new HashMap<String, String>();
        if (model == null) {
            return bgFormTab;
        }
        String bgSchemeRootId = null;
        String bgTemplateRootId = null;
        String bgSchemeId = null;
        String bgTemplateId2 = null;
        String[] bgTemplateIds = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String bgOrgLongNum = null;
        HashMap bgOrgUnitMap = new HashMap();
        Map bgSchemeMap = null;
        Map bgTemplateMap = null;
        try {
            BgFormInfo bgFormInfo = model;
            bgSchemeId = bgFormInfo.getBgScheme().getId().toString();
            if (bgFormInfo.getBgScheme().getRootId() != null && bgFormInfo.getBgScheme().getRootId().toString().length() > 0) {
                bgSchemeRootId = bgFormInfo.getBgScheme().getRootId().toString();
            }
            bgTemplateRootId = bgFormInfo.getBgTemplate().getRootId().toString();
            bgTemplateId2 = bgFormInfo.getBgTemplate().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add("number");
            sic.add("longNumber");
            CostCenterOrgUnitInfo orgInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getOrgUnit().getId()));
            if (orgInfo != null) {
                bgOrgLongNum = orgInfo.getLongNumber();
            }
            if (!(bgTemplateMap = this.getFormTemplateByOrgUnit(ctx, bgTemplateRootId, bgSchemeMap = this.getFormSchemeByOrgUnit(ctx, bgSchemeRootId, null, bgOrgLongNum), null, bgOrgLongNum)).isEmpty()) {
                ArrayList<Object> _tmpList = new ArrayList<Object>();
                StringBuffer sql = new StringBuffer(512);
                sql.append("select FORGUNITID, FID from T_BG_BgForm where (FBgPeriodID = ?) and (FCurrencyID = ?) ");
                _tmpList.add(bgFormInfo.getBgPeriod().getId().toString());
                _tmpList.add(bgFormInfo.getCurrency().getId().toString());
                if (state != -1) {
                    sql.append(" and (FSTATE <> ?) and (FSTATE <> 15) and (FSTATE <> ?)");
                    _tmpList.add(new Integer(state));
                    _tmpList.add(new Integer(41));
                } else {
                    sql.append(" and (FSTATE = -1)");
                }
                sql.append(" and (");
                bgTemplateIds = new String[bgTemplateMap.size()];
                int i = 0;
                for (String bgTemplateId2 : bgTemplateMap.keySet()) {
                    bgSchemeId = (String)bgTemplateMap.get(bgTemplateId2);
                    sql.append("(FBgSchemeID =? AND FBgTemplateID = ?) OR ");
                    _tmpList.add(bgSchemeId);
                    _tmpList.add(bgTemplateId2);
                    bgTemplateIds[i] = bgTemplateId2;
                    ++i;
                }
                sql.append("(FBgSchemeID ='' AND FBgTemplateID = ''))");
                if (model.getCurrency() != null && model.getCurrency().getId() != null) {
                    sql.append(" and FcurrencyID = ?");
                    _tmpList.add(model.getCurrency().getId().toString());
                }
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql.toString());
                BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (bgFormTab.containsKey(rst.getString(1))) continue;
                    bgFormTab.put(rst.getString(1), rst.getString(2));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                String templateOrg = "select distinct forgunitid from t_bg_bgtemplate where fid in " + BgHelper.tranArray2String4Pre(bgTemplateIds);
                pstmt = conn.prepareStatement(templateOrg);
                BgHelper.setParamString4Pre(0, bgTemplateIds, pstmt);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (!bgFormTab.containsKey(rst.getString(1))) {
                        bgFormTab.put(rst.getString(1), null);
                        continue;
                    }
                    bgFormTab.remove(rst.getString(1));
                }
            }
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, conn);
        }
        return bgFormTab;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _batchRemove(Context ctx, List bgFormIds, BOSUuid ctrlUnitID, BOSUuid userID) throws BOSException, EASBizException {
        if (bgFormIds == null) {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        int index = 0;
        int batchSize = 50;
        int size = bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        boolean isRequest = false;
        String _bgFormId = null;
        String _ctrlId = ctrlUnitID.toString();
        Object _bgFormIds = null;
        HashSet<String> _tmpSet = new HashSet<String>();
        ArrayList _applyList = new ArrayList();
        Map.Entry entry2222 = null;
        HashMap tmpMap = new HashMap();
        HashSet remove = new HashSet();
        HashSet<String> cantSet = new HashSet<String>();
        HashSet<String> ctrlSet = new HashSet<String>();
        _applyList.addAll(bgFormIds);
        tmpMap.put("DELETE_OVER", remove);
        tmpMap.put("DELETE_CANT", cantSet);
        tmpMap.put("DELETE_CTRL", ctrlSet);
        IMutexServiceControl imsc = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        IEnactmentService iems = EnactmentServiceFactory.createEnactService((Context)ctx);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            StringBuffer sql1 = new StringBuffer();
            sql1.append("select FBgFormID from T_BG_BgDecForPeriodForm where FState in ('100') and FBgFormID in (");
            for (index = 1; index < batchSize; ++index) {
                sql1.append("?,");
            }
            sql1.append("?)");
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql1.toString());
                for (index = 0; index < count; ++index) {
                    for (int x = 1; x < batchSize + 1; ++x, ++pos) {
                        if (pos < size) {
                            pstmt.setString(x, (String)_applyList.get(pos));
                            this.writerLogin(ctx, _applyList.get(pos).toString());
                            continue;
                        }
                        pstmt.setString(x, "#");
                    }
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _tmpSet.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            catch (Exception e) {
                logger.error((Object)e);
                e.printStackTrace();
            }
            int in = bgFormIds.size();
            for (int i = 0; i < in; ++i) {
                _bgFormId = (String)bgFormIds.get(i);
                if (!_tmpSet.contains(_bgFormId)) continue;
                _applyList.remove(_bgFormId);
                cantSet.add(_bgFormId);
            }
            Map _tmpMap = imsc.batchObjectUpdateLockService(_applyList, new ArrayList());
            if (_tmpMap != null) {
                for (Map.Entry entry2222 : _tmpMap.entrySet()) {
                    _bgFormId = (String)entry2222.getKey();
                    isRequest = (Boolean)entry2222.getValue();
                    if (isRequest) continue;
                    _applyList.remove(_bgFormId);
                    ctrlSet.add(_bgFormId);
                }
            }
            if (!_applyList.isEmpty()) {
                this.batchRemove(ctx, _applyList);
                remove.addAll(_applyList);
            }
            if (_applyList != null && !_applyList.isEmpty()) {
                imsc.batchObjectUpdateLockService(new ArrayList(), _applyList);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (EASBizException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return tmpMap;
    }

    private void writerLogin(Context ctx, String id) throws EASBizException, BOSException {
        BgFormInfo bgFormInfo = (BgFormInfo)super._getValue(ctx, (IObjectPK)new ObjectUuidPK(id));
        String logName = bgFormInfo.getNumber() + " " + bgFormInfo.getName();
        IObjectPK Loginpk = LogUtil.beginLog((Context)ctx, (String)"writerLogin", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgForm_remove");
        LogUtil.afterLog((Context)ctx, (IObjectPK)Loginpk);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void batchRemove(Context ctx, List deletePk) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (deletePk == null) return;
        if (deletePk.isEmpty()) {
            return;
        }
        String _bgFormId = null;
        String _orgUnitId = null;
        String _tmpFormId = null;
        BgFormInfo _bgFormInfo = null;
        ArrayList<String> _adjustPk = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            AttachmentServerManager iAsm = AttachmentManagerFactory.getServerManager((Context)ctx);
            int in = deletePk.size();
            for (int i = 0; i < in; ++i) {
                _bgFormId = (String)deletePk.get(i);
                iAsm.deleteAttachemtsByBoID(_bgFormId);
            }
            HashMap<String, Boolean> _checkMap = new HashMap<String, Boolean>();
            HashMap _numberMap = new HashMap();
            ICodingRuleManager iCrm = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            int in2 = deletePk.size();
            for (int i = 0; i < in2; ++i) {
                Boolean re;
                _bgFormId = (String)deletePk.get(i);
                _bgFormInfo = BgInfoHelper.getBgFormInfo((Connection)conn, (String)_bgFormId, (boolean)false);
                _orgUnitId = _bgFormInfo.getOrgUnit().getId().toString();
                if (!_checkMap.containsKey(_orgUnitId)) {
                    if (iCrm.isExist((IObjectValue)_bgFormInfo, _orgUnitId)) {
                        _checkMap.put(_orgUnitId, Boolean.TRUE);
                    } else {
                        _checkMap.put(_orgUnitId, Boolean.FALSE);
                    }
                }
                if ((re = (Boolean)_checkMap.get(_orgUnitId)) != null && re.booleanValue()) {
                    if (!_numberMap.containsKey(_orgUnitId)) {
                        _numberMap.put(_orgUnitId, new ArrayList());
                    }
                    List _tmp = (List)_numberMap.get(_orgUnitId);
                    _tmp.add(_bgFormInfo.getNumber());
                }
                if (iCrm.isExist((IObjectValue)_bgFormInfo, _orgUnitId, "sourceType") && iCrm.isUseIntermitNumber((IObjectValue)_bgFormInfo, _orgUnitId, "sourceType")) {
                    iCrm.recycleNumber((IObjectValue)_bgFormInfo, _orgUnitId, "sourceType", null, _bgFormInfo.getNumber());
                }
                if (_bgFormInfo.getId().equals((Object)_bgFormInfo.getAdjust().getId())) continue;
                _adjustPk.add(_bgFormInfo.getAdjust().getId().toString());
            }
            Map.Entry _entry2222222 = null;
            for (Map.Entry _entry2222222 : _numberMap.entrySet()) {
                _orgUnitId = (String)_entry2222222.getKey();
                List _tmp = (List)_entry2222222.getValue();
                String[] _tmpStrs = new String[_tmp.size()];
                int in3 = _tmp.size();
                for (int i = 0; i < in3; ++i) {
                    _tmpStrs[i] = (String)_tmp.get(i);
                }
                iCrm.recycleBatchNumber((IObjectValue)_bgFormInfo, _orgUnitId, _tmpStrs);
            }
            pstmt = conn.prepareStatement("select fid from T_BG_BgForm where FAdjustId = ? and fid <> ?");
            int in4 = deletePk.size();
            for (int i = 0; i < in4; ++i) {
                _bgFormId = (String)deletePk.get(i);
                pstmt.setString(1, _bgFormId);
                pstmt.setString(2, _bgFormId);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _tmpFormId = rst.getString(1);
                    if (StringUtils.isEmpty((String)_tmpFormId)) continue;
                    this.execute(conn, "delete from T_BG_BgAuditIdea where FBgFormId = ?", _tmpFormId);
                    this.execute(conn, "delete from T_RPT_RptSheetPara where FReportID = ?", _tmpFormId);
                    this.execute(conn, "delete from T_RPT_RptPostil where FReportID = ?", _tmpFormId);
                    this.execute(conn, "delete from T_BG_BgRefBgCurrency where FBgFormID = ?", _tmpFormId);
                    this.execute(conn, "delete from T_BG_BgRefBgElement where FBgFormID = ?", _tmpFormId);
                    this.execute(conn, "delete from T_BG_BgRefBgPeriod where FBgFormID = ?", _tmpFormId);
                    this.execute(conn, "delete from T_BG_BgRefBgItemCombin where FBgFormID = ?", _tmpFormId);
                    this.execute(conn, "delete from T_BG_BgMeasureUnit where FBgFormID = ?", _tmpFormId);
                    this.execute(conn, "delete from T_BG_BgSheet where FBgFormId = ?", _tmpFormId);
                    iAsm.deleteAttachemtsByBoID(_tmpFormId);
                    this.execute(conn, "delete from T_BG_BgBillIntegrateForm where FEntryId in(Select fid from t_Bg_bgFormEntry where fbgformid = ?)", _tmpFormId);
                    this.execute(conn, "delete from t_Bg_bgFormEntry where fbgformid = ?", _tmpFormId);
                    this.execute(conn, "delete from T_BG_BgForm where FId = ?", _tmpFormId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmt);
            this.execute(conn, "delete from T_BG_BgAuditIdea where FBgFormId = ?", deletePk);
            this.execute(conn, "delete from T_RPT_RptSheetPara where FReportID = ?", deletePk);
            this.execute(conn, "delete from T_RPT_RptPostil where FReportID = ?", deletePk);
            this.execute(conn, "delete from T_BG_BgPastRecord where FBgFormID = ?", deletePk);
            this.execute(conn, "delete from T_BG_BgRefBgCurrency where FBgFormID = ?", deletePk);
            this.execute(conn, "delete from T_BG_BgRefBgElement where FBgFormID = ?", deletePk);
            this.execute(conn, "delete from T_BG_BgRefBgPeriod where FBgFormID = ?", deletePk);
            this.execute(conn, "delete from T_BG_BgRefBgItemCombin where FBgFormID = ?", deletePk);
            this.execute(conn, "delete from T_BG_BgMeasureUnit where FBgFormID = ?", deletePk);
            this.execute(conn, "delete from T_BG_BgSheet where FBgFormId = ?", deletePk);
            this.execute(conn, "delete from T_BG_BgGatherInfo where FBgFormId = ?", deletePk);
            this.clearBgData(conn, deletePk);
            this.clearBgTmpData(conn, _adjustPk);
            this.execute(conn, "delete from T_BG_BgBillIntegrateForm where FEntryId in(Select fid from t_Bg_bgFormEntry where fbgformid = ?)", deletePk);
            this.execute(conn, "delete from t_Bg_bgFormEntry where fbgformid = ?", deletePk);
            this.deleteUpdatePlayHistory(conn, deletePk);
            this.execute(conn, "delete from T_BG_BgForm where FId = ?", deletePk);
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (EASBizException ex2) {
                    throw ex2;
                }
                catch (SQLException e) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{e.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private void deleteUpdatePlayHistory(Connection conn, List deletePk) throws SQLException {
        if (conn == null || deletePk == null || deletePk.isEmpty()) {
            return;
        }
        String deleteEntrySql = "delete T_Bg_BgFormEntry where FBgFormId IN(Select FID From T_Bg_BgForm Where FState = 15 and FAdjustId IN (Select FAdjustId From T_Bg_BgForm Where FState <> 15 and FID <> FAdjustId and FID = ?) and FVersionNo > (Select FVersionNo From T_Bg_BgForm Where FID = (Select FAdjustId From T_Bg_BgForm Where FID = ?)))";
        String deleteSql = "delete From T_Bg_BgForm Where FState = 15 and FAdjustId IN (Select FAdjustId From T_Bg_BgForm Where FState <> 15 and FID <> FAdjustId and FID = ?) and FVersionNo > (Select FVersionNo From T_Bg_BgForm Where FID = (Select FAdjustId From T_Bg_BgForm Where FID = ?))";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int i = 0; i < deletePk.size(); ++i) {
            Object[] obj = new Object[]{deletePk.get(i), deletePk.get(i)};
            params.add(obj);
        }
        BgNSQLHelper.executeBatch((Connection)conn, (String)deleteEntrySql, params);
        BgNSQLHelper.executeBatch((Connection)conn, (String)deleteSql, params);
    }

    public int[] execute(Connection conn, String sql, List parameter) throws EASBizException {
        if (conn == null || sql == null || parameter == null) {
            return null;
        }
        int[] re = null;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            int in = parameter.size();
            for (int i = 0; i < in; ++i) {
                pstmt.setString(1, (String)parameter.get(i));
                pstmt.addBatch();
            }
            re = pstmt.executeBatch();
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        return re;
    }

    public int[] execute(Connection conn, String sql, String parameter) throws EASBizException {
        if (conn == null || sql == null || parameter == null) {
            return null;
        }
        int[] re = null;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, parameter);
            pstmt.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
        return re;
    }

    @Override
    protected IObjectPK _cloneAdjust(Context ctx, BOSUuid bgFormId, BgFormDataSourceEnum dataSource, BgFormStateEnum state) throws BOSException, EASBizException {
        if (bgFormId == null || dataSource == null || state == null) {
            return null;
        }
        IBgForm ibgForm = null;
        ObjectUuidPK pk = null;
        IObjectPK npk = null;
        BgFormInfo bgFormInfo = null;
        BgFormInfo cloneInfo = null;
        ibgForm = BgFormFactory.getLocalInstance(ctx);
        if (ibgForm == null) {
            throw new BgFormException(BgFormException.NOINSTANCE);
        }
        pk = new ObjectUuidPK(bgFormId);
        if (!ibgForm.exists((IObjectPK)pk)) {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)pk, BgNFSHelper.getSelectors());
        cloneInfo = bgFormInfo.deepcloneForAdjust();
        cloneInfo.setDataSource(dataSource);
        cloneInfo.setState(state);
        cloneInfo.setStartDate(new Date());
        cloneInfo.setEndDate(bgFormInfo.getStartDate());
        cloneInfo.setAdjust(bgFormInfo);
        cloneInfo.setAdjustMapData(null);
        npk = ibgForm.addnew((CoreBaseInfo)cloneInfo);
        return npk;
    }

    @Override
    protected List _reportCheck(Context ctx, BOSUuid[] bgFormIds) throws BOSException, EASBizException {
        return this.bgFormReportCheck(ctx, bgFormIds, null);
    }

    @Override
    protected List _reportCheck(Context ctx, BOSUuid billId, BOSUuid[] refBillIds, BOSUuid[] bgFormIds, String type) throws BOSException, EASBizException {
        ArrayList<Object> re = new ArrayList<Object>();
        re.add(Boolean.TRUE);
        if (billId == null || refBillIds == null || refBillIds.length == 0 || bgFormIds == null || bgFormIds.length == 0 || type == null) {
            return re;
        }
        ArrayList<BOSUuid> pass = new ArrayList<BOSUuid>();
        ArrayList<BOSUuid> nopass = new ArrayList<BOSUuid>();
        BgFormInfo bgFormInfo = null;
        BgCollectFormInfo bgCollectFormInfo = null;
        RefBgFormInfo refBgFormInfo = null;
        BgDecomposerFormInfo decFormInfo = null;
        RefBgDecFormInfo refBgDecFormInfo = null;
        BgColForPeriodFormInfo colForPeriodInfo = null;
        List checkReport = null;
        StringBuffer msg = new StringBuffer();
        String collectType = BgCollectFormInfo.class.getName();
        String decomposerType = BgDecomposerFormInfo.class.getName();
        String colForPeriodType = BgColForPeriodFormInfo.class.getName();
        byte[] data = null;
        HashMap adjustMap = null;
        RptOperationSchemaComp comp = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            if (type.equals(colForPeriodType)) {
                colForPeriodInfo = BgColForPeriodHelper.getBgColForPeriodInfo(ctx, conn, billId);
                if (colForPeriodInfo != null) {
                    data = null;
                    byte[] data2 = (byte[])colForPeriodInfo.getAdjustMap().get("adjustMap");
                    if (data2 != null) {
                        adjustMap = BgHelper.buildHashMapByByte(data2);
                    }
                } else {
                    data = null;
                    adjustMap = null;
                }
            }
            int n = bgFormIds.length;
            for (int i = 0; i < n; ++i) {
                if (!refBillIds[i].equals((Object)billId)) {
                    if (type.equals(collectType)) {
                        refBgFormInfo = BgCollectHelper.getRefBgFormInfo(conn, refBillIds[i]);
                        if (refBgFormInfo != null) {
                            data = refBgFormInfo.getKdtData();
                            adjustMap = refBgFormInfo.getAdjustMap();
                        } else {
                            data = null;
                            adjustMap = null;
                        }
                    } else if (type.equals(decomposerType)) {
                        refBgDecFormInfo = BgDecHelper.getRefBgDecFormInfo(ctx, conn, refBillIds[i]);
                        if (refBgDecFormInfo != null) {
                            data = refBgDecFormInfo.getKdtData();
                            adjustMap = refBgDecFormInfo.getAdjustMap();
                        } else {
                            data = null;
                            adjustMap = null;
                        }
                    }
                } else if (type.equals(collectType)) {
                    bgCollectFormInfo = BgCollectHelper.getBgCollectInfo(conn, billId);
                    if (bgCollectFormInfo != null) {
                        data = bgCollectFormInfo.getKdtData();
                        adjustMap = bgCollectFormInfo.getAdjustMap();
                    } else {
                        data = null;
                        adjustMap = null;
                    }
                } else if (type.equals(decomposerType)) {
                    decFormInfo = BgDecHelper.getBgDecInfo(ctx, conn, billId);
                    if (decFormInfo != null) {
                        data = decFormInfo.getKdtData();
                        adjustMap = decFormInfo.getAdjustMap();
                    } else {
                        data = null;
                        adjustMap = null;
                    }
                }
                if (data != null && data.length > 0) {
                    bgFormInfo = BgInfoHelper.getBgFormInfo((Context)ctx, (BOSUuid)bgFormIds[i], (boolean)false);
                    bgFormInfo.setZipData(data);
                } else {
                    bgFormInfo = BgInfoHelper.getBgFormInfo((Context)ctx, (BOSUuid)bgFormIds[i], (boolean)true);
                }
                BookProperties bp = BookProperties.loadFromBook((Book)bgFormInfo.getBook());
                comp = bgFormInfo.get("operationSchemas") != null ? (RptOperationSchemaComp)bgFormInfo.get("operationSchemas") : bp.getOperationSchema();
                if (comp != null) {
                    if (adjustMap != null && !adjustMap.isEmpty()) {
                        bgFormInfo.setBook(this.replaceBookValue(bgFormInfo.getBook(), adjustMap));
                    }
                    bgFormInfo.put("FORMULA_DATA", this.extractData(bgFormInfo, true, null));
                    bgFormInfo.put("operationSchemas", comp);
                    try {
                        BgRptReportPropertyAdapter adapter = new BgRptReportPropertyAdapter(bgFormInfo);
                        checkReport = ReportCheck.checkReport((Context)ctx, (ReportBaseInfo)bgFormInfo, (IReportPropertyAdapter)adapter, null);
                    }
                    catch (Exception exception) {}
                } else {
                    checkReport = null;
                }
                if (checkReport != null && Boolean.FALSE.equals(checkReport.get(0))) {
                    re.set(0, Boolean.FALSE);
                    msg.append("<a>" + bgFormInfo.getNumber() + " - " + bgFormInfo.getName() + "</a>");
                    msg.append("<br>");
                    msg.append(checkReport.get(2));
                    msg.append("<br>");
                    msg.append("<br>");
                    nopass.add(bgFormIds[i]);
                    continue;
                }
                pass.add(bgFormIds[i]);
            }
            re.add(pass);
            re.add(nopass);
            re.add(msg.length() > 0 ? msg.toString() : null);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return re;
    }

    @Override
    protected List _decForPeriodReprotCheck(Context ctx, BOSUuid[] ids, String type, Map adjustMap) throws BOSException, EASBizException {
        if (adjustMap != null) {
            adjustMap.put("type", type);
        }
        return this.bgFormReportCheck(ctx, ids, adjustMap);
    }

    @Override
    protected List _reportCheck(Context ctx, BOSUuid[] ids, String type) throws BOSException, EASBizException {
        List<Boolean> check = null;
        if (ids == null || ids.length == 0 || type == null) {
            check = new ArrayList<Boolean>();
            check.add(Boolean.TRUE);
            return check;
        }
        if (type.equalsIgnoreCase(BgFormInfo.class.getName())) {
            check = this.bgFormReportCheck(ctx, ids, null);
        } else if (type.equalsIgnoreCase(BgAdjustBillInfo.class.getName())) {
            check = this.adjustBillReportCheck(ctx, ids);
        }
        return check;
    }

    protected List bgFormReportCheck(Context ctx, BOSUuid[] ids, Map adjustMap) throws BOSException, EASBizException {
        boolean isDecForPeriod = adjustMap != null && adjustMap.containsKey("type");
        ArrayList<Object> reList = new ArrayList<Object>();
        reList.add(Boolean.TRUE);
        if (ids == null || ids.length == 0) {
            return reList;
        }
        ArrayList<BOSUuid> _pass = new ArrayList<BOSUuid>();
        ArrayList<BOSUuid> _nopass = new ArrayList<BOSUuid>();
        List check = null;
        StringBuffer msg = new StringBuffer();
        Map _adjustMap = null;
        BgFormInfo bgFormInfo = null;
        RptOperationSchemaComp comp = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            int n = ids.length;
            for (int i = 0; i < n; ++i) {
                bgFormInfo = BgInfoHelper.getBgFormInfo((Context)ctx, (BOSUuid)ids[i], (boolean)true);
                if (bgFormInfo.getData() == null) continue;
                BookProperties bp = BookProperties.loadFromBook((Book)bgFormInfo.getBook());
                comp = bgFormInfo.get("operationSchemas") != null ? (RptOperationSchemaComp)bgFormInfo.get("operationSchemas") : bp.getOperationSchema();
                if (comp != null && !comp.isCheckExpEmpty()) {
                    if (isDecForPeriod) {
                        bgFormInfo.setBook(this.replaceBookValue(bgFormInfo.getBook(), adjustMap));
                    } else if (adjustMap != null && adjustMap.containsKey(ids[i])) {
                        _adjustMap = (Map)adjustMap.get(ids[i]);
                        bgFormInfo.setBook(this.replaceBookValue(bgFormInfo.getBook(), _adjustMap));
                    }
                    bgFormInfo.put("FORMULA_DATA", this.extractData(bgFormInfo, true, null));
                    bgFormInfo.put("operationSchemas", comp);
                    try {
                        BgRptReportPropertyAdapter adapter = new BgRptReportPropertyAdapter(bgFormInfo);
                        check = ReportCheck.checkReport((Context)ctx, (ReportBaseInfo)bgFormInfo, (IReportPropertyAdapter)adapter, null);
                    }
                    catch (Exception exception) {}
                } else {
                    check = null;
                }
                if (check != null && Boolean.FALSE.equals(check.get(0))) {
                    reList.set(0, Boolean.FALSE);
                    msg.append("<a>" + bgFormInfo.getNumber() + " - " + bgFormInfo.getName() + "</a>");
                    msg.append("<br>");
                    msg.append(check.get(2));
                    msg.append("<br>");
                    msg.append("<br>");
                    _nopass.add(ids[i]);
                    continue;
                }
                _pass.add(ids[i]);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        reList.add(_pass);
        reList.add(_nopass);
        reList.add(msg.length() > 0 ? msg.toString() : null);
        return reList;
    }

    protected List adjustBillReportCheck(Context ctx, BOSUuid[] ids) throws BOSException, EASBizException {
        ArrayList<Object> check = new ArrayList<Object>();
        check.add(Boolean.TRUE);
        if (ids == null || ids.length == 0) {
            return check;
        }
        IBgAdjustBill ibgAdjustBill = BgAdjustBillFactory.getLocalInstance(ctx);
        if (ibgAdjustBill == null) {
            throw new BgException(BgException.NOINSTANCE);
        }
        BOSUuid[] bgFormIds = null;
        ObjectUuidPK pk = null;
        BgAdjustBillInfo billInfo = null;
        BgAdjustBillEntryInfo entry = null;
        BgAdjustBillEntryCollection entrys = null;
        BgFormDiversityData divData = null;
        HashMap<BOSUuid, Map<String, BgFormDiversityData>> bgFormMap = new HashMap<BOSUuid, Map<String, BgFormDiversityData>>();
        Map<String, BgFormDiversityData> adjustMap = null;
        ArrayList _pass = new ArrayList();
        ArrayList _noPass = new ArrayList();
        List _check = null;
        List _tmp = null;
        StringBuffer msg = new StringBuffer();
        try {
            int in = ids.length;
            for (int i = 0; i < in; ++i) {
                int j;
                int jn;
                pk = new ObjectUuidPK(ids[i]);
                billInfo = ibgAdjustBill.getBgAdjustBillInfo((IObjectPK)pk);
                entrys = billInfo.getEntry();
                Iterator iter = entrys.iterator();
                while (iter.hasNext()) {
                    entry = (BgAdjustBillEntryInfo)iter.next();
                    if (bgFormMap.containsKey(entry.getBgForm().getId())) {
                        adjustMap = (Map)bgFormMap.get(entry.getBgForm().getId());
                    } else {
                        adjustMap = new HashMap();
                        bgFormMap.put(entry.getBgForm().getId(), adjustMap);
                    }
                    if (adjustMap.containsKey(entry.getFormula())) {
                        divData = (BgFormDiversityData)adjustMap.get(entry.getFormula());
                        divData.setNewValue(entry.getAdjustAfter());
                        continue;
                    }
                    divData = new BgFormDiversityData();
                    divData.setFormula(entry.getFormula());
                    divData.setNewValue(entry.getAdjustAfter());
                    adjustMap.put(entry.getFormula(), divData);
                }
                int index = 0;
                bgFormIds = new BOSUuid[bgFormMap.size()];
                Iterator form = bgFormMap.keySet().iterator();
                while (form.hasNext()) {
                    bgFormIds[index++] = (BOSUuid)form.next();
                }
                _check = this.bgFormReportCheck(ctx, bgFormIds, bgFormMap);
                int theCheckSize = _check.size();
                if (theCheckSize >= 1 && Boolean.FALSE.equals(_check.get(0))) {
                    check.set(0, Boolean.FALSE);
                    if (theCheckSize >= 4) {
                        msg.append(_check.get(3));
                    }
                    if (theCheckSize < 2 || _check.get(1) == null || !(_check.get(1) instanceof List)) continue;
                    _tmp = (List)_check.get(1);
                    jn = _tmp.size();
                    for (j = 0; j < jn; ++j) {
                        _noPass.add(_tmp.get(j));
                    }
                    continue;
                }
                if (theCheckSize < 3 || _check.get(2) == null || !(_check.get(2) instanceof List)) continue;
                _tmp = (List)_check.get(1);
                jn = _tmp.size();
                for (j = 0; j < jn; ++j) {
                    _pass.add(_tmp.get(j));
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        check.add(_pass);
        check.add(_noPass);
        if (msg.length() != 0) {
            check.add(msg.toString());
        } else {
            check.add(null);
        }
        return check;
    }

    private Book replaceBookValue(Book book, Map adjustMap) throws Exception {
        if (book == null || adjustMap == null || adjustMap.isEmpty()) {
            return book;
        }
        int rowIndex = 0;
        int colIndex = 0;
        int rowCount = 0;
        int colCount = 0;
        String formulaStr = null;
        BgFormDiversityData divData = null;
        Sheet sheet = null;
        Cell cell = null;
        boolean isCalculate = book.isAutoCalculate();
        book.setCalculate(false);
        int n = book.getSheetCount();
        for (int i = 0; i < n; ++i) {
            sheet = book.getSheet(i);
            rowCount = sheet.getMaxRowIndex();
            colCount = sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell) || !adjustMap.containsKey(formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell))) continue;
                    divData = (BgFormDiversityData)adjustMap.get(formulaStr);
                    BgNFSHelper.setValue((Cell)cell, (Object)divData.getNewValue());
                }
            }
        }
        return book;
    }

    private List extractData(BgFormInfo model, boolean valueFirst, int[] calIndex) {
        Book _book = null;
        Sheet _sheet = null;
        try {
            _book = model.getBook();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList result = null;
        if (_book == null) {
            return result;
        }
        BgNFSHelper.disableCal((Book)_book);
        BgNFSHelper.disableUndo((Book)_book);
        result = new ArrayList(_book.getSheetCount());
        ArrayList<String> names = new ArrayList<String>(_book.getSheetCount());
        result.add(names);
        int i = 0;
        int jn = _book.getSheetCount();
        for (int j = 0; j < jn; ++j) {
            int r;
            _sheet = _book.getSheet(j);
            if (_sheet == null) {
                result.add(null);
                names.add(null);
                continue;
            }
            names.add(_sheet.getSheetName());
            int rowcount = _sheet.getMaxRowIndex();
            if (rowcount < 1) continue;
            ArrayList myBody = new ArrayList(rowcount);
            result.add(myBody);
            int lastRow = 0;
            for (r = 0; r < rowcount; ++r) {
                Row row = _sheet.getRow(r, false);
                if (row == null) {
                    myBody.add(null);
                    continue;
                }
                ArrayList<Object> myRow = new ArrayList<Object>(_sheet.getMaxColIndex());
                boolean hasContent = false;
                for (int k = 0; k < _sheet.getMaxColIndex(); ++k) {
                    Cell cell = row.getCell(k, false);
                    if (cell == null || cell.getValue() == Variant.nullVariant && BgNFSHelper.getExpression((Cell)cell) == null) {
                        myRow.add(null);
                        continue;
                    }
                    if (cell != null && BgNFSHelper.getValue((Cell)cell) instanceof String && StringUtils.isEmpty((String)((String)BgNFSHelper.getValue((Cell)cell))) && BgNFSHelper.getExpression((Cell)cell) == null) {
                        myRow.add(null);
                        continue;
                    }
                    hasContent = true;
                    String s = BgNFSHelper.getExpression((Cell)cell);
                    Variant obj = cell.getValue();
                    if (!StringUtils.isEmpty((String)s)) {
                        if (valueFirst || calIndex != null && calIndex[i] < 0) {
                            myRow.add(obj);
                            continue;
                        }
                        myRow.add(s);
                        continue;
                    }
                    myRow.add(obj);
                }
                if (hasContent) {
                    myBody.add(myRow);
                    lastRow = j;
                    continue;
                }
                myBody.add(null);
            }
            for (r = rowcount - 1; r > lastRow; --r) {
                myBody.remove(r);
            }
            ++i;
        }
        return result;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, BOSUuid bgFormId, boolean hasLoadData) throws BOSException, EASBizException {
        if (bgFormId == null) {
            throw null;
        }
        BgFormInfo bgFormInfo = null;
        if (this.exists(ctx, (IObjectPK)new ObjectUuidPK(bgFormId))) {
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                bgFormInfo = BgFSHelper.getBgFormInfo(conn, bgFormId, hasLoadData);
            }
            catch (BOSException ex) {
                throw ex;
            }
            catch (EASBizException ex) {
                throw ex;
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        } else {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        return bgFormInfo;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectValue model = super._getValue(ctx, pk);
        Map tmpMap = null;
        int _state = model.getInt("state");
        if (15 != _state) {
            if (4 == _state || 35 == _state) {
                BOSUuid _id;
                if (model.getObjectValue("adjust") != null && (_id = model.getObjectValue("adjust").getBOSUuid("id")) != null) {
                    ObjectUuidPK _pk = new ObjectUuidPK(_id);
                    tmpMap = this.getBgValue(ctx, (IObjectPK)_pk);
                    tmpMap = this.getBgTmpValue(ctx, (IObjectPK)_pk, tmpMap);
                }
            } else {
                tmpMap = this.getBgValue(ctx, pk);
            }
        }
        model.put("CELL_DATA", tmpMap);
        return model;
    }

    public CoreBaseInfo getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        CoreBaseInfo model = super.getValue(ctx, pk, selector);
        Map tmpMap = null;
        int _state = model.getInt("state");
        if (15 != _state) {
            if (4 == _state || 35 == _state) {
                BOSUuid _id;
                if (model.getObjectValue("adjust") != null && (_id = model.getObjectValue("adjust").getBOSUuid("id")) != null) {
                    ObjectUuidPK _pk = new ObjectUuidPK(_id);
                    tmpMap = this.getBgValue(ctx, (IObjectPK)_pk);
                    tmpMap = this.getBgTmpValue(ctx, (IObjectPK)_pk, tmpMap);
                }
            } else {
                tmpMap = this.getBgValue(ctx, pk);
            }
        }
        model.put("CELL_DATA", tmpMap);
        return model;
    }

    private String outTime(long startTime, long beginTime, long endTime) {
        return new StringBuffer("invoke process use = ").append(endTime - beginTime).append(" ms; alluse = ").append(endTime - startTime).append(" ms;").toString();
    }

    @Override
    protected Map _getBgDataInfo(Context ctx, BOSUuid orgUnitId, BOSUuid bgSchemeId, Set formulas) throws BOSException, EASBizException {
        HashMap<String, BgNDataInfo> bgDataMap = new HashMap<String, BgNDataInfo>();
        if (orgUnitId == null || bgSchemeId == null || formulas == null || formulas.isEmpty()) {
            return bgDataMap;
        }
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        _endTime = _startTime;
        logger.info((Object)"invoke begin load bgData!");
        BgNDataInfo dataInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select FBgValue, FBgActual, FFormula, FDataState from T_BG_BgData ").append("where FOrgUnitId = ? and FBgSchemeId = ? and FFormula in(");
            BgNSQLHelper.addPlaceHolder((StringBuffer)sql).append(")");
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            Object[] params = formulas.toArray();
            int count = BgNSQLHelper.getBatchCount((Object[])params);
            for (int i = 0; i < count; ++i) {
                pstmt.setString(1, orgUnitId.toString());
                pstmt.setString(2, bgSchemeId.toString());
                BgNSQLHelper.setParam4BatchDefCount((PreparedStatement)pstmt, (int)3, (int)i, (Object[])params);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    dataInfo = new BgNDataInfo();
                    dataInfo.setFormula(rst.getString("FFormula"));
                    dataInfo.setBudgetValue(rst.getBigDecimal("FBgValue"));
                    dataInfo.setActualValue(rst.getBigDecimal("FBgActual"));
                    dataInfo.setState(rst.getInt("FDataState"));
                    bgDataMap.put(dataInfo.getFormula(), dataInfo);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"load bgdata:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        _endTime = System.currentTimeMillis();
        logger.info((Object)"invoke end load bgData!");
        logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
        return bgDataMap;
    }

    private Map getBgValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HashMap<String, BgNDataInfo> bgDataMap = new HashMap<String, BgNDataInfo>();
        if (pk == null) {
            return bgDataMap;
        }
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        _endTime = _startTime;
        logger.info((Object)"invoke begin load bgData!");
        BgNDataInfo dataInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FBgValue, FBgActual, FFormula, FDataState from T_BG_BgData where FBgFormId = ?");
            pstmt.setString(1, pk.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                dataInfo = new BgNDataInfo();
                dataInfo.setFormula(rst.getString("FFormula"));
                dataInfo.setBudgetValue(rst.getBigDecimal("FBgValue"));
                dataInfo.setActualValue(rst.getBigDecimal("FBgActual"));
                dataInfo.setState(rst.getInt("FDataState"));
                bgDataMap.put(dataInfo.getFormula(), dataInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"load bgdata:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        _endTime = System.currentTimeMillis();
        logger.info((Object)"invoke end load bgData!");
        logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
        return bgDataMap;
    }

    private Map getBgTmpValue(Context ctx, IObjectPK pk, Map bgDataMap) throws BOSException, EASBizException {
        if (bgDataMap == null) {
            bgDataMap = new HashMap<String, BgNDataInfo>();
        }
        if (pk == null) {
            return bgDataMap;
        }
        BgNDataInfo dataInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FBgValue, FFormula from T_BG_BgTmpData where FBgFormId = ?");
            pstmt.setString(1, pk.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                dataInfo = new BgNDataInfo();
                dataInfo.setFormula(rst.getString("FFormula"));
                dataInfo.setAdjustValue(rst.getBigDecimal("FBgValue"));
                bgDataMap.put(dataInfo.getFormula(), dataInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"load bgdata:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgDataMap;
    }

    @Override
    protected boolean _checkHasPeriod(Context ctx, BOSUuid companyId) throws BOSException, EASBizException {
        if (companyId == null) {
            return false;
        }
        boolean re = false;
        ISystemStatus iSystemStatus = null;
        ISystemStatusCtrol iSystemStatusCtrol = null;
        SystemStatusInfo systemStatus = null;
        SystemStatusCollection systemStatusC = null;
        SystemStatusCtrolInfo systemStatusCtrol = null;
        SystemStatusCtrolCollection systemStatusCtrolC = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)new Integer(6), CompareType.EQUALS));
        view.setFilter(filter);
        iSystemStatus = SystemStatusFactory.getLocalInstance((Context)ctx);
        systemStatusC = iSystemStatus.getSystemStatusCollection(view);
        if (systemStatusC != null && !systemStatusC.isEmpty() && (systemStatus = systemStatusC.get(0)).isHasPeriod()) {
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("systemStatus", (Object)systemStatus.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId.toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
            iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            systemStatusCtrolC = iSystemStatusCtrol.getSystemStatusCtrolCollection(view);
            if (systemStatusCtrolC != null && !systemStatusCtrolC.isEmpty() && (systemStatusCtrol = systemStatusCtrolC.get(0)).getCurrentPeriod() != null) {
                re = true;
            }
        }
        return re;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _getSheetName(Context ctx, String bgFormId) throws BOSException, EASBizException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (StringUtils.isEmpty((String)bgFormId)) {
            return result;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String[] sheetInfo = null;
        String sheetId = null;
        String sheetName = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FSheetId, FSheetName from T_BG_BgSheet where FBgFormId = ? order by FSheetIndex");
            pstmt.setString(1, bgFormId);
            rst = pstmt.executeQuery();
            BgFormInfo bgFormInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo("select id,data,bgTemplate.id where id ='" + bgFormId + "'");
            boolean isSheetPer = BgSHelper.isBgSheetPermissionUsed(ctx);
            Map sheetPer = null;
            if (isSheetPer) {
                sheetPer = this.getSheetPermessionMap(ctx, bgFormInfo.getBook(), bgFormInfo.getBgTemplate().getId().toString());
            }
            while (rst.next()) {
                sheetId = rst.getString(1);
                if (isSheetPer && sheetPer != null && !sheetPer.containsKey(sheetId)) continue;
                sheetName = rst.getString(2);
                sheetInfo = new String[]{sheetId, sheetName};
                result.add(sheetInfo);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
                catch (Exception e) {
                    logger.error((Object)"error", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return result;
    }

    private Map getSheetPermessionMap(Context ctx, Book _book, String templateId) {
        Map sheetPer = null;
        sheetPer = this.addBgSheetPermission(ctx, templateId);
        Sheet _sheet = null;
        String user = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (_book != null) {
            int sheetIndex = 0;
            int sheetSize = _book.getSheetCount();
            for (sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                _sheet = _book.getSheet(sheetIndex);
                this.hideSheet(_sheet, sheetPer, user);
            }
        }
        return sheetPer;
    }

    protected Map addBgSheetPermission(Context ctx, String bgTemplateId) {
        if (bgTemplateId == null) {
            return null;
        }
        Map hasPer = new HashMap<String, Object>();
        Map sheetPer = new HashMap();
        try {
            hasPer.put(bgTemplateId, null);
            hasPer = BgPermissionHelper.getBgTemplateSheetPermission((Context)ctx, hasPer);
            if (hasPer != null && hasPer.get(bgTemplateId) != null) {
                sheetPer = (Map)hasPer.get(bgTemplateId);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return sheetPer;
    }

    protected void hideSheet(Sheet _sheet, Map sheetPer, String user) {
        String sheetCreater = null;
        if (sheetPer != null && sheetPer.containsKey(BgNFSHelper.getSheetSign((Sheet)_sheet))) {
            sheetPer.put(_sheet.getID(), null);
        } else {
            sheetCreater = (String)_sheet.getUserObjectValue("SHEET_CREATER_ID");
            if (sheetCreater != null && sheetCreater.equals(user)) {
                sheetPer.put(_sheet.getID(), null);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void _saveXNum(Context ctx, BOSUuid[] bgFormId, String xNum) throws BOSException, EASBizException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void _sendMessage(Context ctx, BOSUuid bgFormId, String sendOrgUnitName, String sendName) throws BOSException, EASBizException {
        if (bgFormId == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        StringBuffer ids = new StringBuffer();
        String resourceFile = "com.kingdee.eas.ma.budget.BgFormMsgResource";
        String title = null;
        String body = null;
        ArrayList<String> bgFormIds = new ArrayList<String>();
        BgFormInfo bgFormInfo = null;
        SenderAgent agent = null;
        Message message = null;
        Locale locale = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        locale = ctx.getLocale();
        try {
            conn = this.getConnection(ctx);
            bgFormInfo = BgInfoHelper.getBgFormInfo((Connection)conn, (String)bgFormId.toString(), (boolean)false);
            if (bgFormInfo != null) {
                title = ResourceBase.getString((String)resourceFile, (String)"title", (Locale)locale);
                body = ResourceBase.getString((String)resourceFile, (String)"body", (Locale)locale);
                body = MessageFormat.format(body, sendOrgUnitName, bgFormInfo.getNumber());
                pstmt = conn.prepareStatement("select FBGFORMID from T_BG_BGGATHERINFO where FSUBBGFORMID = ?");
                pstmt.setString(1, bgFormId.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgFormIds.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (!bgFormIds.isEmpty()) {
                    ArrayList<String> _tmpList = new ArrayList<String>();
                    sql.append("select FLastUpdateUserId from T_BG_BgForm where FID IN (");
                    int in = bgFormIds.size() - 1;
                    for (int i = 0; i < in; ++i) {
                        sql.append("?,");
                        _tmpList.add(bgFormIds.get(i).toString());
                    }
                    sql.append("?)");
                    _tmpList.add(bgFormIds.get(bgFormIds.size() - 1).toString());
                    pstmt = conn.prepareStatement(sql.toString());
                    BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        ids.append(rst.getString(1)).append(";");
                    }
                    agent = SenderAgent.getSenderAgent();
                    message = MessageFactory.newMessage((String)"kingdee.workflow");
                    message.setLocaleStringHeader("title", title, locale);
                    message.setLocaleStringHeader("sender", sendName, locale);
                    message.setLocaleStringHeader("body", body, locale);
                    message.setIntHeader("type", 0);
                    message.setIntHeader("bizType", 0);
                    message.setIntHeader("sourceStatus", 0);
                    message.setIntHeader("priority", 10);
                    message.setStringHeader("databaseCenter", ctx.getAIS());
                    message.setStringHeader("solution", ctx.getSolution());
                    message.setStringHeader("receiver", ids.toString());
                    agent.sendMessage(message);
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
            throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
    }

    @Override
    protected void _record(Context ctx, List list) throws BOSException, EASBizException {
        int i;
        StringBuffer sql = new StringBuffer();
        ArrayList numList = (ArrayList)list;
        Connection conn = null;
        PreparedStatement pstmt = null;
        int batchSize = 200;
        int batchIndex = 0;
        int size = numList.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        String logName = EASResource.getString((String)"com.kingdee.eas.ma.budget.BgFormMsgResource", (String)"bgFormSelfRecord");
        IObjectPK Loginpk = LogUtil.beginLog((Context)ctx, (String)"_record", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgFormSelfDefine_record");
        sql.append("update T_BG_bgForm set FRecord = ? where   Fid in (");
        for (i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (i = 0; i < count; ++i) {
                pstmt.setInt(1, 1);
                int j = 2;
                while (j <= batchSize + 1) {
                    if (pos < size) {
                        pstmt.setString(j, (String)numList.get(pos));
                    } else {
                        pstmt.setString(j, "#");
                    }
                    ++j;
                    ++pos;
                }
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)Loginpk);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _unRecord(Context ctx, List list) throws BOSException, EASBizException {
        int i;
        StringBuffer sql = new StringBuffer();
        ArrayList numList = (ArrayList)list;
        Connection conn = null;
        PreparedStatement pstmt = null;
        int batchSize = 200;
        int batchIndex = 0;
        int size = numList.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        String logName = EASResource.getString((String)"com.kingdee.eas.ma.budget.BgFormMsgResource", (String)"bgFormSelfUnRecord");
        IObjectPK Loginpk = LogUtil.beginLog((Context)ctx, (String)"_unRecord", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgFormSelfDefine_unRecord");
        sql.append("update T_BG_bgForm set FRecord = ? where   Fid in (");
        for (i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (i = 0; i < count; ++i) {
                pstmt.setInt(1, 0);
                int j = 2;
                while (j <= batchSize + 1) {
                    if (pos < size) {
                        pstmt.setString(j, (String)numList.get(pos));
                    } else {
                        pstmt.setString(j, "#");
                    }
                    ++j;
                    ++pos;
                }
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
            LogUtil.afterLog((Context)ctx, (IObjectPK)Loginpk);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected boolean _batchRemove(Context ctx, BOSUuid[] bgFormIds) throws BOSException, EASBizException {
        if (bgFormIds != null && bgFormIds.length > 0) {
            BOSUuid bgFormId2 = null;
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                for (BOSUuid bgFormId2 : bgFormIds) {
                    this._delete(ctx, (IObjectPK)new ObjectUuidPK(bgFormId2));
                }
            }
            catch (BOSException ex) {
                throw ex;
            }
            catch (EASBizException ex) {
                throw ex;
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        } else {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        return true;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgFormInfo info = (BgFormInfo)super._getValue(ctx, pk);
        return info.getNumber() + "  " + info.getName();
    }

    @Override
    protected Set _changeEditCompleted(Context ctx, Set bgFormIDSet, boolean isEditCompleted) throws BOSException, EASBizException {
        HashSet idSet = new HashSet();
        if (EmptyUtil.isEmpty((Collection)bgFormIDSet)) {
            return idSet;
        }
        int setState = isEditCompleted ? 102 : 1;
        int filterState = isEditCompleted ? 1 : 102;
        StringBuffer sql = new StringBuffer("update T_BG_bgForm set FState = " + setState + " where FId in ( ");
        BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)bgFormIDSet.size());
        sql.append(" ) and FState = " + filterState);
        try {
            BgNSQLHelper.execute((Context)ctx, (String)sql.toString(), (Object[])bgFormIDSet.toArray());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }
}

