/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.app.AbstractBgFormEntryControllerBean;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.util.BgViewHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgFormEntryControllerBean
extends AbstractBgFormEntryControllerBean {
    private static final long serialVersionUID = 379554784983996777L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgFormEntryControllerBean");

    @Override
    protected void _saveStyle(Context ctx, String bgViewId, IBgDimensionManager bgDimensionManager) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgViewId) || bgDimensionManager == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BgViewHelper.writeStyle((OutputStream)bos, (IBgDimensionManager)bgDimensionManager);
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_Bg_BgFormEntry set FDimensionStyle = ? where FBgFormId = ?");
            pstmt.setBytes(1, bos.toByteArray());
            pstmt.setString(2, bgViewId);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _saveDimensionData(Context ctx, String bgViewId, IBgDimensionManager bgDimensionManager, String orgUnitId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgViewId) || bgDimensionManager == null) {
            return;
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("rowShowLevel", bgDimensionManager.isRowShowLevel());
        map.put("rowAddMember", bgDimensionManager.isRowAddMember());
        byte[] viewData = null;
        try {
            viewData = BgViewHelper.upParse((List)bgDimensionManager.getDimension(), map);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (viewData != null) {
            IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
            IBgFormFacade ibgFormFacade = BgFormFacadeFactory.getLocalInstance(ctx);
            Map resultMap = ibgFormFacade.queryBgFormByOrgUnitId((BgFormInfo)ibgForm.getValue((IObjectPK)new ObjectUuidPK(bgViewId), this.getSel()), new Object[]{orgUnitId});
            Connection conn = null;
            PreparedStatement pstmt = null;
            conn = this.getConnection(ctx);
            try {
                pstmt = conn.prepareStatement("update T_Bg_BgFormEntry set FDimensionData = ? where FBgFormId = ?");
                pstmt.setBytes(1, viewData);
                pstmt.setString(2, ((BgFormInfo)resultMap.get(orgUnitId)).getId().toString());
                pstmt.executeUpdate();
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            }
        }
    }

    private SelectorItemCollection getSel() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bgTemplate.rootId");
        sic.add("bgScheme.rootId");
        sic.add("orgUnit.id");
        sic.add("bgPeriod.id");
        sic.add("currency.id");
        sic.add("state");
        return sic;
    }
}

