/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.AbstractBgFormInfo;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgGatherHelper;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.BookHelper;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.app.AbstractBgGatherFacadeControllerBean;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNDataInfo;
import com.kingdee.eas.ma.nbudget.BgNEnumGatherInfo;
import com.kingdee.eas.ma.nbudget.BgNEnumInfo;
import com.kingdee.eas.ma.nbudget.BgNEnumerateHelper;
import com.kingdee.eas.ma.nbudget.BgNEnumerateInfo;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.ma.nbudget.SheetInfo;
import com.kingdee.eas.ma.view.app.BgViewServerHelper;
import com.kingdee.eas.ma.view.common.BgDimensionInfo;
import com.kingdee.eas.ma.view.common.BgDimensionManagerImpl;
import com.kingdee.eas.ma.view.common.BgDimensionMember;
import com.kingdee.eas.ma.view.common.BudgetViewLoaderImpl;
import com.kingdee.eas.ma.view.common.IBgDimensionManager;
import com.kingdee.eas.ma.view.common.IBudgetView;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgGatherFacadeControllerBean
extends AbstractBgGatherFacadeControllerBean {
    private final String APPROVED_VALUE = "0";
    private final String APPROVING_VALUE = "1";
    private final String BASISAPPROVED_VALUE = "2";
    private final String REPORT_VALUE = "3";
    private final String CERTIFICATE_VALUE = "4";
    private final String ALL_VALUE = "5";
    private static final long serialVersionUID = -4184878082548136148L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgGatherFacadeControllerBean");

    @Override
    protected Map _checkGatherInfo(Context ctx, BOSUuid bgFormId, Set orgUnitIds, Map parameter) throws BOSException, EASBizException {
        Map<String, Boolean> resultMap = new HashMap<String, Boolean>();
        resultMap.put("GATHER_CHECK_RESULT", Boolean.FALSE);
        if (bgFormId == null || orgUnitIds == null || orgUnitIds.isEmpty() || parameter == null) {
            return resultMap;
        }
        Connection conn = null;
        IBgForm ibgForm = null;
        try {
            conn = this.getConnection(ctx);
            ibgForm = BgFormFactory.getLocalInstance(ctx);
            if (ibgForm == null) {
                throw new BgFormException(BgFormException.NOINSTANCE);
            }
            BgFormInfo bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), BgGatherFacadeControllerBean.getGatherSelectors());
            resultMap = this.getBgFormIdsByGather(ctx, conn, bgFormInfo, orgUnitIds, null, parameter, resultMap);
        }
        catch (BOSException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return resultMap;
    }

    @Override
    protected Map _checkGatherInfo(Context ctx, IObjectValue model, Set orgUnitIds, Map parameter) throws BOSException, EASBizException {
        Map<String, Boolean> resultMap = new HashMap<String, Boolean>();
        resultMap.put("GATHER_CHECK_RESULT", Boolean.FALSE);
        if (model == null || !(model instanceof BgFormInfo) || orgUnitIds == null || orgUnitIds.isEmpty() || parameter == null) {
            return resultMap;
        }
        Connection conn = null;
        Set formulaSet = null;
        try {
            conn = this.getConnection(ctx);
            BgFormInfo bgFormInfo = (BgFormInfo)model;
            Object obj = model.get("BGFORM_FORMULA");
            if (obj != null && obj instanceof Set) {
                formulaSet = (Set)obj;
                model.remove("BGFORM_FORMULA");
            }
            resultMap = this.getBgFormIdsByGather(ctx, conn, bgFormInfo, orgUnitIds, formulaSet, parameter, resultMap);
        }
        catch (BOSException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return resultMap;
    }

    private void buildBatchSQL(StringBuffer sb, int batchNum) {
        for (int i = 0; i < batchNum; ++i) {
            if (i != batchNum - 1) {
                sb.append("?,");
                continue;
            }
            sb.append("?");
        }
    }

    protected Map getBgFormIdsByGather(Context ctx, Connection conn, BgFormInfo model, Set orgUnitSet, Set formulaSet, Map parameter, Map resultMap) throws EASBizException {
        if (conn == null || orgUnitSet == null || orgUnitSet.isEmpty()) {
            return resultMap;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Object _obj = null;
        String _rBgSchemeId = null;
        String _rBgTemplateId = null;
        String _bgPeriodId = null;
        String _currencyId = null;
        String _orgUnitId2 = null;
        String _orgUnitName = null;
        String _bgSchemeId = null;
        String _bgBillId = null;
        String _formulaStr2 = null;
        String gatherState = BgNSHelper.isStateOfGather((Context)ctx);
        ArrayList<String> _orgUnitIDList = new ArrayList<String>();
        HashSet<String> _tmpOrgUnitIdSet = new HashSet<String>();
        HashMap<String, String> _gatherOrgUnitMap = new HashMap<String, String>();
        HashMap<String, String> _gatherCantMap = new HashMap<String, String>();
        HashMap<String, String> _gatherBgFormIdsMap = new HashMap<String, String>();
        HashMap<String, String> _gatherBgSchemeIdMap = new HashMap<String, String>();
        ArrayList<String> _formulaList = new ArrayList<String>();
        if (formulaSet != null && !formulaSet.isEmpty()) {
            for (String _formulaStr2 : formulaSet) {
                _formulaList.add(_formulaStr2);
            }
        }
        resultMap.put("GATHER_CHECK_RESULT", Boolean.FALSE);
        resultMap.put("GATHER_CHECK_ORGUNIT", _gatherOrgUnitMap);
        resultMap.put("GATHER_CHECK_CANT_ORGUNIT", _gatherCantMap);
        resultMap.put("GATHER_CHECK_BGFORM_ID", _gatherBgFormIdsMap);
        resultMap.put("GATHER_CHECK_BGSCHEME_ID", _gatherBgSchemeIdMap);
        int _batchNum = 300;
        int index = 0;
        int batchSize = 200;
        int size = _formulaList.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        boolean isGatherType = (Boolean)parameter.get("GATHER_TYPE");
        boolean isGahterFormula = (Boolean)parameter.get("GATHER_FORMULA");
        boolean isGatherAdd = false;
        _obj = parameter.get("GATHER_SCHEME_FORMULA");
        isGahterFormula = _obj instanceof Boolean && model.getBgTemplate().getFormType().getValue() == 0 ? (Boolean)_obj : false;
        _obj = parameter.get("GATHER_TYPE_EXT");
        isGatherAdd = "GATHER_ADD_ACTUAL".equals(_obj);
        _rBgSchemeId = model.getBgScheme().getRootId().toString();
        _rBgTemplateId = model.getBgTemplate().getRootId().toString();
        _bgPeriodId = model.getBgPeriod().getId().toString();
        _currencyId = model.getCurrency().getId().toString();
        StringBuffer sql = new StringBuffer(1024);
        ArrayList<Object> _tmpList = new ArrayList<Object>();
        ArrayList<String> _tmpOrgIDList = new ArrayList<String>();
        if (isGatherAdd) {
            if (isGahterFormula) {
                sql.append("SELECT r.FID, f.FOrgUnitId, u.FName_" + ctx.getLocale() + ", s.FID FROM T_BG_BgActualRecord r left join T_BG_BgForm f on r.FBgFormId = f.FID left join T_BG_BgScheme s on f.FBgSchemeId = s.FID left join T_ORG_BaseUnit u on f.FOrgUnitId = u.FID WHERE s.FRootId = ? AND f.FBgPeriodId = ? AND f.FCurrencyId = ?");
                _tmpList.add(_rBgSchemeId);
                _tmpList.add(_bgPeriodId);
                _tmpList.add(_currencyId);
                sql.append(" AND r.FState IN (?)");
                _tmpList.add(new Integer(2));
                sql.append(" AND f.FOrgUnitID IN (");
                this.buildBatchSQL(sql, _batchNum);
                sql.append(")");
            } else {
                sql.append("SELECT r.FID, f.FOrgUnitId, u.FName_" + ctx.getLocale() + ", s.FID FROM T_BG_BgActualRecord r left join T_BG_BgForm f on r.FBgFormId = f.FID left join T_BG_BgScheme s on f.FBgSchemeId = s.FID left join T_BG_BgTemplate t on f.FBgTemplateId = t.FID left join T_ORG_BaseUnit u on f.FOrgUnitId = u.FID WHERE s.FRootId = ? AND t.FRootId = ? AND f.FBgPeriodId = ? AND f.FCurrencyId = ?");
                _tmpList.add(_rBgSchemeId);
                _tmpList.add(_rBgTemplateId);
                _tmpList.add(_bgPeriodId);
                _tmpList.add(_currencyId);
                sql.append(" AND r.FState IN (?)");
                _tmpList.add(new Integer(2));
                sql.append(" AND f.FOrgUnitID IN (");
                this.buildBatchSQL(sql, _batchNum);
                sql.append(")");
            }
        } else if (isGahterFormula) {
            sql.append("SELECT s.FID, s.FOrgUnitId, u.FName_" + ctx.getLocale() + ",f.fid FROM T_BG_BgScheme s left join T_ORG_BaseUnit u on s.ForgUnitId = u.FID left join T_BG_BgForm f on f.fbgschemeid=s.fid WHERE s.FRootId = ?");
            _tmpList.add(_rBgSchemeId);
            sql.append(" AND s.FOrgUnitID IN (");
            this.buildBatchSQL(sql, _batchNum);
            sql.append(")");
        } else {
            List _state;
            sql.append("SELECT f.FID, f.FOrgUnitId, u.FName_" + ctx.getLocale() + ", s.FID FROM T_BG_BgForm f left join T_BG_BgScheme s on f.FBgSchemeId = s.FID left join T_BG_BgTemplate t on f.FBgTemplateId = t.FID left join T_ORG_BaseUnit u on f.FOrgUnitId = u.FID WHERE s.FRootId = ? AND t.FRootId = ? AND f.FBgPeriodId = ? AND f.FCurrencyId = ?");
            _tmpList.add(_rBgSchemeId);
            _tmpList.add(_rBgTemplateId);
            _tmpList.add(_bgPeriodId);
            _tmpList.add(_currencyId);
            if (isGatherType) {
                _state = this.getGatherState(ctx);
                sql.append(" AND f.FState IN (").append(BgNSQLHelper.getParamSizeString((Collection)_state)).append(")");
                _tmpList.addAll(_state);
            } else {
                _state = this.getGatherAllState();
                sql.append(" AND f.FState IN (").append(BgNSQLHelper.getParamSizeString((Collection)_state)).append(")");
                _tmpList.addAll(_state);
            }
            sql.append(" AND f.FOrgUnitID IN (");
            this.buildBatchSQL(sql, _batchNum);
            sql.append(")");
        }
        try {
            Iterator iter = orgUnitSet.iterator();
            while (iter.hasNext()) {
                _tmpOrgIDList.add(iter.next().toString());
            }
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            int _size = _tmpOrgIDList.size();
            int _count = (_size - 1) / _batchNum + 1;
            int _pos = 0;
            for (int _index = 0; _index < _count; ++_index) {
                int k = 1;
                while (k <= _batchNum) {
                    if (_pos < _size) {
                        pstmt.setString(k + _tmpList.size(), (String)_tmpOrgIDList.get(_pos));
                    } else {
                        pstmt.setString(k + _tmpList.size(), "#");
                    }
                    ++k;
                    ++_pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (isGatherAdd) {
                        _bgBillId = rst.getString(1);
                        _orgUnitId2 = rst.getString(2);
                        _orgUnitName = rst.getString(3);
                        _bgSchemeId = rst.getString(4);
                        _gatherBgSchemeIdMap.put(_orgUnitId2, _bgSchemeId);
                        _gatherBgFormIdsMap.put(_orgUnitId2, _bgBillId);
                    } else if (isGahterFormula) {
                        _bgSchemeId = rst.getString(1);
                        _orgUnitId2 = rst.getString(2);
                        _orgUnitName = rst.getString(3);
                        _bgBillId = rst.getString(4);
                        _gatherBgSchemeIdMap.put(_orgUnitId2, _bgSchemeId);
                        _gatherBgFormIdsMap.put(_orgUnitId2, _bgBillId);
                    } else {
                        _bgBillId = rst.getString(1);
                        _orgUnitId2 = rst.getString(2);
                        _orgUnitName = rst.getString(3);
                        _bgSchemeId = rst.getString(4);
                        _gatherBgSchemeIdMap.put(_orgUnitId2, _bgSchemeId);
                        _gatherBgFormIdsMap.put(_orgUnitId2, _bgBillId);
                    }
                    if (StringUtils.isEmpty((String)_orgUnitId2)) continue;
                    _gatherOrgUnitMap.put(_orgUnitId2, _orgUnitName);
                }
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            if (isGahterFormula && !_gatherOrgUnitMap.isEmpty() && formulaSet != null && !formulaSet.isEmpty()) {
                ArrayList<String> _tmpList1 = new ArrayList<String>();
                List _state = new ArrayList();
                sql = new StringBuffer();
                sql.append("select distinct t.FOrgUnitId from T_BG_BgData t left join T_BG_BgForm f on t.FBgFormId = F.FID where (");
                for (String _orgUnitId2 : _gatherBgSchemeIdMap.keySet()) {
                    _bgSchemeId = (String)_gatherBgSchemeIdMap.get(_orgUnitId2);
                    sql.append("(t.FOrgUnitId = ? and t.FBgSchemeId = ?) or ");
                    _tmpList1.add(_orgUnitId2);
                    _tmpList1.add(_bgSchemeId);
                }
                sql.delete(sql.length() - 4, sql.length());
                sql.append(")");
                if (formulaSet != null) {
                    sql.append(" AND (t.FFormula in (");
                    for (int i = 1; i < batchSize; ++i) {
                        sql.append("?,");
                    }
                    sql.append("?))");
                } else {
                    sql.append(" AND (t.FFormula in (select FFormula from T_BG_BgData where FBgFormId = ?))");
                }
                if (isGatherType) {
                    _state = this.getGatherState(ctx);
                    sql.append(" AND f.FState IN (").append(BgNSQLHelper.getParamSizeString(_state)).append(")");
                } else {
                    _state = this.getGatherAllState();
                    sql.append(" AND f.FState IN (").append(BgNSQLHelper.getParamSizeString(_state)).append(")");
                }
                pstmt = conn.prepareStatement(sql.toString());
                if (formulaSet == null) {
                    BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList1);
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _orgUnitId2 = rst.getString(1);
                        _tmpOrgUnitIdSet.add(_orgUnitId2);
                    }
                } else {
                    boolean hasAdjust = BgNFSHelper.checkHasAdjust((IObjectValue)model);
                    for (index = 0; index < count; ++index) {
                        BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList1);
                        int k = 1;
                        while (k <= batchSize) {
                            if (pos < size) {
                                pstmt.setString(_tmpList1.size() * 2 + k, (String)_formulaList.get(pos));
                            } else {
                                pstmt.setString(_tmpList1.size() * 2 + k, "#");
                            }
                            ++k;
                            ++pos;
                        }
                        if (!hasAdjust) {
                            pstmt.setString(_tmpList1.size() * 2 + batchSize + 1, model.getId().toString());
                        } else {
                            pstmt.setString(_tmpList1.size() * 2 + batchSize + 1, model.getAdjust().getId().toString());
                        }
                        BgNSQLHelper.setParams((PreparedStatement)pstmt, _state, (int)(_tmpList1.size() * 2 + batchSize + 2));
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _orgUnitId2 = rst.getString(1);
                            _tmpOrgUnitIdSet.add(_orgUnitId2);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                Iterator iter2 = _gatherOrgUnitMap.keySet().iterator();
                while (iter2.hasNext()) {
                    _orgUnitId2 = (String)iter2.next();
                    if (_tmpOrgUnitIdSet.contains(_orgUnitId2)) continue;
                    iter2.remove();
                }
                iter2 = _gatherBgSchemeIdMap.keySet().iterator();
                while (iter2.hasNext()) {
                    _orgUnitId2 = (String)iter2.next();
                    if (_tmpOrgUnitIdSet.contains(_orgUnitId2)) continue;
                    iter2.remove();
                }
            }
            if (_gatherOrgUnitMap.isEmpty()) {
                resultMap.put("GATHER_CHECK_RESULT", Boolean.FALSE);
            } else {
                resultMap.put("GATHER_CHECK_RESULT", Boolean.TRUE);
                for (String _orgUnitId2 : orgUnitSet) {
                    if (_gatherOrgUnitMap.containsKey(_orgUnitId2)) continue;
                    _orgUnitIDList.add(_orgUnitId2);
                }
            }
            if (!_orgUnitIDList.isEmpty()) {
                int batchNum = 500;
                size = _orgUnitIDList.size();
                count = (size - 1) / batchNum + 1;
                pos = 0;
                ArrayList orgUnitList = new ArrayList();
                sql = new StringBuffer(2048);
                sql.append("SELECT FID, FName_" + ctx.getLocale() + " FROM T_ORG_BaseUnit WHERE FID IN (");
                for (int i = 0; i < batchNum; ++i) {
                    if (i != batchNum - 1) {
                        sql.append("?,");
                        continue;
                    }
                    sql.append("?)");
                }
                pstmt = conn.prepareStatement(sql.toString());
                for (index = 0; index < count; ++index) {
                    int k = 1;
                    while (k <= batchNum) {
                        if (pos < size) {
                            pstmt.setString(k, (String)_orgUnitIDList.get(pos));
                        } else {
                            pstmt.setString(k, "#");
                        }
                        ++k;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _orgUnitId2 = rst.getString(1);
                        _orgUnitName = rst.getString(2);
                        _gatherCantMap.put(_orgUnitId2, _orgUnitName);
                    }
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return resultMap;
    }

    protected Set getGatherBgFormIds(Context ctx, BgFormInfo model, Set orgUnitSet) throws BOSException, EASBizException {
        if (orgUnitSet == null || orgUnitSet.isEmpty()) {
            return new HashSet();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _rBgSchemeId = null;
        String _rBgTemplateId = null;
        String _bgPeriodId = null;
        String _currencyId = null;
        String _bgFormId = null;
        HashSet<String> _bgFormIdsSet = new HashSet<String>();
        ArrayList<String> _tmpList = new ArrayList<String>();
        _rBgSchemeId = model.getBgScheme().getRootId().toString();
        _rBgTemplateId = model.getBgTemplate().getRootId().toString();
        _bgPeriodId = model.getBgPeriod().getId().toString();
        _currencyId = model.getCurrency().getId().toString();
        StringBuffer sql = new StringBuffer(1024);
        sql.append("SELECT f.FID FROM T_BG_BgForm f left join T_BG_BgScheme s on f.FBgSchemeId = s.FID left join T_BG_BgTemplate t on f.FBgTemplateId = t.FID left join T_ORG_BaseUnit u on f.FOrgUnitId = u.FID WHERE s.FRootId = ? AND t.FRootId = ? AND f.FBgPeriodId = ? AND f.FCurrencyId = ?");
        _tmpList.add(_rBgSchemeId);
        _tmpList.add(_rBgTemplateId);
        _tmpList.add(_bgPeriodId);
        _tmpList.add(_currencyId);
        List _state = this.getGatherState(ctx);
        _tmpList.addAll(_state);
        sql.append(" AND f.FState IN (").append(BgNSQLHelper.getParamSizeString((Collection)_state)).append(")");
        sql.append(" AND f.FOrgUnitID IN (");
        Iterator iter = orgUnitSet.iterator();
        while (iter.hasNext()) {
            sql.append("?, ");
            _tmpList.add(iter.next().toString());
        }
        sql.delete(sql.length() - 2, sql.length() - 1);
        sql.append(")");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                _bgFormId = rst.getString(1);
                _bgFormIdsSet.add(_bgFormId);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return _bgFormIdsSet;
    }

    protected List getGatherState(Context ctx) {
        ArrayList<Integer> state = new ArrayList<Integer>();
        String gatherState = BgNSHelper.isStateOfGather((Context)ctx);
        if ("0".equals(gatherState)) {
            state.add(new Integer(2));
            state.add(new Integer(4));
            state.add(new Integer(20));
            state.add(new Integer(43));
        } else if ("1".equals(gatherState)) {
            state.add(new Integer(14));
            state.add(new Integer(2));
            state.add(new Integer(4));
            state.add(new Integer(20));
            state.add(new Integer(43));
        } else if ("2".equals(gatherState)) {
            state.add(new Integer(3));
            state.add(new Integer(2));
            state.add(new Integer(4));
            state.add(new Integer(20));
            state.add(new Integer(43));
        } else if ("3".equals(gatherState)) {
            state.add(new Integer(40));
            state.add(new Integer(41));
            state.add(new Integer(14));
            state.add(new Integer(2));
            state.add(new Integer(4));
            state.add(new Integer(20));
            state.add(new Integer(43));
        } else if ("4".equals(gatherState)) {
            state.add(new Integer(41));
            state.add(new Integer(14));
            state.add(new Integer(2));
            state.add(new Integer(4));
            state.add(new Integer(20));
            state.add(new Integer(43));
        } else if ("5".equals(gatherState)) {
            state.add(new Integer(1));
            state.add(new Integer(102));
            state.add(new Integer(103));
            state.add(new Integer(2));
            state.add(new Integer(3));
            state.add(new Integer(14));
            state.add(new Integer(20));
            state.add(new Integer(25));
            state.add(new Integer(40));
            state.add(new Integer(41));
            state.add(new Integer(42));
            state.add(new Integer(43));
        } else {
            state.add(new Integer(2));
        }
        return state;
    }

    protected List getGatherAllState() {
        ArrayList<Integer> state = new ArrayList<Integer>();
        state.add(new Integer(1));
        state.add(new Integer(102));
        state.add(new Integer(103));
        state.add(new Integer(2));
        state.add(new Integer(3));
        state.add(new Integer(14));
        state.add(new Integer(20));
        state.add(new Integer(25));
        state.add(new Integer(40));
        state.add(new Integer(41));
        state.add(new Integer(42));
        state.add(new Integer(43));
        return state;
    }

    @Override
    protected Map _getGatherValueForView(Context ctx, IObjectPK formId, Map bgSchemeIdsMap, Map bgFormIdsMap, Map parameter, IBgDimensionManager dimensionManager) throws BOSException, EASBizException {
        IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
        BgFormInfo bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(formId.toString()), BgNFSHelper.getSelectors());
        List _orgUnitSort = null;
        List _orgUnitIds = null;
        HashSet formulaSet = new HashSet();
        Set bgElementSet = null;
        Object _obj = null;
        Map valueMap = null;
        HashMap<String, String> bgAdjustIdsMap = new HashMap<String, String>();
        ArrayList<Object> allFormIds = new ArrayList<Object>();
        boolean hasGatherTmpData = (Boolean)parameter.get("GATHER_TMPDATA");
        boolean hasBudget = (Boolean)parameter.get("GATHER_TYPE");
        _obj = parameter.get("GATHER_SORT");
        if (_obj != null && _obj instanceof List) {
            _orgUnitSort = _obj;
        }
        _obj = parameter.get("GATHER_CLEAR_FORMULA");
        _orgUnitIds = this.getOrgUnitIdsBySort(bgFormIdsMap, _orgUnitSort);
        if (dimensionManager == null) {
            IBudgetView view = BudgetViewLoaderImpl.getIntance();
            dimensionManager = new BgDimensionManagerImpl();
            try {
                view.load(dimensionManager, bgFormInfo.getEntries().get(0).getDimensionData());
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.NODATA, e);
            }
        }
        allFormIds.addAll(bgFormIdsMap.values());
        if (hasGatherTmpData) {
            Map resultMap = BgFormFacadeFactory.getLocalInstance(ctx).queryBgFormByOrgUnitId(bgFormInfo, bgFormIdsMap.keySet().toArray());
            BgFormInfo curFormInfo = null;
            for (Object o : resultMap.keySet()) {
                curFormInfo = (BgFormInfo)resultMap.get(o);
                if (curFormInfo.getState().getValue() != 35 && curFormInfo.getState().getValue() != 4) continue;
                bgAdjustIdsMap.put(curFormInfo.getOrgUnit().getId().toString(), curFormInfo.getId().toString());
                allFormIds.add(curFormInfo.getId().toString());
            }
        }
        this.findAllMembers(ctx, dimensionManager.getRowDimension(), allFormIds, bgFormInfo.getOrgUnit().getId().toString());
        this.findAllFormula(ctx, formulaSet, dimensionManager, bgFormInfo);
        bgElementSet = this.getCantGatherBgElement(ctx);
        this.filterFormulaSetForView(ctx, formulaSet, bgFormInfo, bgElementSet);
        valueMap = this.gatherOfFormula(ctx, bgSchemeIdsMap, formulaSet, hasBudget, hasGatherTmpData, false, parameter);
        this.saveGatherAttachment(ctx, bgFormInfo, bgSchemeIdsMap, bgFormIdsMap, true);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("RowDimension", dimensionManager.getRowDimension());
        returnMap.put("value", valueMap);
        return returnMap;
    }

    private void filterFormulaSetForView(Context ctx, Set formulaSet, BgFormInfo currentForm, Set bgElementSet) throws BOSException, EASBizException {
        if (formulaSet == null || formulaSet.isEmpty()) {
            return;
        }
        Connection conn = this.getConnection(ctx);
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int formStateValue = currentForm.getState().getValue();
        boolean isEditValue = formStateValue == 1 || formStateValue == 102 || formStateValue == 103;
        try {
            if (isEditValue || formStateValue == 35 || formStateValue == 4) {
                StringBuffer filterUnEditableSql = new StringBuffer();
                filterUnEditableSql = isEditValue ? new StringBuffer("select FFormula FROM T_BG_bgData where FDataState not in (1,102,103) and FOrgUnitId = ? and FBgSchemeId = ? and FFormula in (") : new StringBuffer("select FFormula FROM T_BG_bgData where FDataState != 9 and FOrgUnitId = ? and FBgSchemeId = ? and FFormula in (");
                BgNSQLHelper.addPlaceHolder((StringBuffer)filterUnEditableSql, (int)200).append(")");
                pstmt = conn.prepareStatement(filterUnEditableSql.toString());
                Object[] params = formulaSet.toArray();
                int batchCount = (params.length - 1) / 200 + 1;
                for (int i = 0; i < batchCount; ++i) {
                    pstmt.setString(1, currentForm.getOrgUnit().getId().toString());
                    pstmt.setString(2, currentForm.getBgScheme().getId().toString());
                    BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)3, (int)i, (int)200, (Object[])params);
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        formulaSet.remove(rst.getString("FFormula"));
                    }
                }
            }
            String formula = "";
            String[] parameter = null;
            Iterator iterator = formulaSet.iterator();
            while (iterator.hasNext()) {
                formula = (String)iterator.next();
                parameter = BgNFSHelper.parseFormulaPara((String)formula);
                if (!bgElementSet.contains(parameter[2])) continue;
                iterator.remove();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BgFormException(BgFormException.DATABASEERROR, e);
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
    }

    private void findAllFormula(Context ctx, Set formulaSet, IBgDimensionManager curDimensionManager, BgFormInfo _curBgFormInfo) throws BOSException, EASBizException {
        formulaSet.addAll(BgViewServerHelper.getFormulasForView((Context)ctx, (IBgDimensionManager)curDimensionManager, (BgFormInfo)_curBgFormInfo));
    }

    private void findAllMembers(Context ctx, List<BgDimensionInfo> rowDimensionInfos, List bgFormIds, String orgId) throws BOSException, EASBizException {
        Object _orgUnitId = null;
        String _bgFormId2 = null;
        BgFormInfo _curBgFormInfo = null;
        IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
        IBudgetView view = BudgetViewLoaderImpl.getIntance();
        HashMap<String, BgDimensionInfo> itemDimensionAtRowMap = new HashMap<String, BgDimensionInfo>();
        List curRowDimensionInfos = null;
        for (BgDimensionInfo dimension : rowDimensionInfos) {
            if (!dimension.getType().equalsIgnoreCase("BGITEM")) continue;
            itemDimensionAtRowMap.put(dimension.getAttributeNumber(), dimension);
        }
        BgDimensionManagerImpl curDimensionManager = new BgDimensionManagerImpl();
        List members = null;
        List curMembers = null;
        HashSet<String> membersNum = new HashSet<String>();
        BgDimensionInfo dimensionInfo = null;
        HashMap<String, BgDimensionMember> memberDetail = new HashMap<String, BgDimensionMember>();
        for (String _bgFormId2 : bgFormIds) {
            _curBgFormInfo = ibgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(_bgFormId2), this.getSelectorsForView());
            try {
                view.load((IBgDimensionManager)curDimensionManager, _curBgFormInfo.getEntries().get(0).getDimensionData());
                view.loadStyle((IBgDimensionManager)curDimensionManager, _curBgFormInfo.getEntries().get(0).getDimensionStyle());
                curRowDimensionInfos = curDimensionManager.getRowDimension();
                for (BgDimensionInfo curDiemsionInfo : curRowDimensionInfos) {
                    if (!curDiemsionInfo.getType().equalsIgnoreCase("BGITEM")) continue;
                    curMembers = curDiemsionInfo.getMember();
                    dimensionInfo = (BgDimensionInfo)itemDimensionAtRowMap.get(curDiemsionInfo.getAttributeNumber());
                    members = dimensionInfo.getMember();
                    for (BgDimensionMember member : members) {
                        membersNum.add(member.getNumber());
                    }
                    for (BgDimensionMember curMember : curMembers) {
                        if (!curMember.isAllowEdit() || membersNum.contains(curMember.getNumber())) continue;
                        members.add(curMember);
                        memberDetail.put(curMember.getNumber(), curMember);
                    }
                    Collections.sort(curMembers);
                    dimensionInfo.unParseMember();
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.NODATA, e);
            }
            if (memberDetail.keySet().size() > 0) {
                IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.ma.budget.BgItemQuery"));
                EntityViewInfo entityView = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", memberDetail.keySet(), CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg(orgId), CompareType.EQUALS));
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("number"));
                selector.add(new SelectorItemInfo("longNumber"));
                selector.add(new SelectorItemInfo("level"));
                selector.add(new SelectorItemInfo("name"));
                selector.add(new SelectorItemInfo("refField"));
                selector.add(new SelectorItemInfo("specialNumber"));
                entityView.getSelector().addObjectCollection((IObjectCollection)selector);
                entityView.setFilter(filter);
                queryExecutor.setObjectView(entityView);
                IRowSet rowSet = queryExecutor.executeQuery();
                try {
                    while (rowSet.next()) {
                        String number = rowSet.getString("number");
                        BgDimensionMember member = (BgDimensionMember)memberDetail.get(number);
                        member.setNumber(rowSet.getString("number"));
                        member.setSortValue((Comparable)((Object)rowSet.getString("longNumber")));
                        member.setLevel(rowSet.getInt("level"));
                        member.setName(rowSet.getString("name"));
                        member.setAttribute(rowSet.getString("refField"));
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BgFormException(BgFormException.DATABASEERROR, e);
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rowSet);
                }
            }
            curDimensionManager.clear();
        }
    }

    private SelectorItemCollection getSelectorsForView() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("entries.dimensionData");
        sic.add("entries.dimensionStyle");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.periodType");
        return sic;
    }

    @Override
    protected IObjectValue _getGatherValue(Context ctx, IObjectPK bgFormPk, Map orgUnitMap, Map bgSchemeIdsMap, Map bgFormIdsMap, Map parameter) throws BOSException, EASBizException {
        if (bgFormPk == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{"id"});
        }
        IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
        if (ibgForm == null) {
            throw new BgException(BgException.NOINSTANCE);
        }
        BgFormInfo bgFormInfo = null;
        if (!ibgForm.exists(bgFormPk)) {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        bgFormInfo = ibgForm.getBgFormInfo(bgFormPk, BgNFSHelper.getSelectors());
        bgFormInfo = (BgFormInfo)this._getGatherValue(ctx, (IObjectValue)bgFormInfo, orgUnitMap, bgSchemeIdsMap, bgFormIdsMap, parameter);
        return bgFormInfo;
    }

    @Override
    protected IObjectValue _getGatherValue(Context ctx, IObjectValue model, Map orgUnitMap, Map bgSchemeIdsMap, Map bgFormIdsMap, Map parameter) throws BOSException, EASBizException {
        BgFormInfo bgFormInfo = (BgFormInfo)model;
        Book[] _books = new Book[3];
        Sheet _sheet = null;
        boolean isBookCal = false;
        Map adjustMap = null;
        Map valueMap = null;
        Map _enumMap = null;
        HashMap bgFormDataMap = new HashMap();
        Set formulaSet = new HashSet();
        Set bgElementSet = null;
        HashSet<String> bgSheetIdSet = null;
        List _orgUnitSort = null;
        List _orgUnitIds = null;
        int sheetIndex = 0;
        int sheetCount = 0;
        int state = 0;
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        Object _obj = null;
        String _orgUnitId2 = null;
        String _bgFormId = null;
        SheetInfo[] _sheetIds = null;
        SheetInfo _sheetId2 = null;
        boolean hasGatherAddActual = false;
        boolean hasClearFormula = false;
        boolean hasBudget = (Boolean)parameter.get("GATHER_TYPE");
        boolean hasGatherCell = (Boolean)parameter.get("GATHER_CELL");
        boolean hasGatherFormula = (Boolean)parameter.get("GATHER_FORMULA");
        boolean hasGatherEnumErate = (Boolean)parameter.get("GATHER_ENUMERATE");
        boolean hasGatherTmpData = (Boolean)parameter.get("GATHER_TMPDATA");
        boolean hasGatherSheet = (Boolean)parameter.get("GATHER_SHEET");
        _obj = parameter.get("GATHER_TYPE_EXT");
        boolean bl = hasGatherEnumErate = bgFormInfo.getBgTemplate().getFormType().getValue() == 1;
        if (_obj != null && "GATHER_ADD_ACTUAL".equals(_obj)) {
            hasGatherAddActual = true;
        }
        if ((_obj = (Object)parameter.get("GATHER_CLEAR_FORMULA")) instanceof Boolean) {
            hasClearFormula = (Boolean)_obj;
        }
        if (hasGatherEnumErate) {
            hasGatherFormula = true;
        }
        if (hasGatherSheet && (_obj = (Object)parameter.get("GATHER_SHEET_ID")) != null && _obj instanceof SheetInfo[]) {
            bgSheetIdSet = new HashSet<String>();
            for (SheetInfo _sheetId2 : (SheetInfo[])_obj) {
                if (StringUtils.isEmpty((String)_sheetId2.getSheetId())) continue;
                bgSheetIdSet.add(_sheetId2.getSheetId());
            }
        }
        if (bgSheetIdSet == null || bgSheetIdSet.isEmpty()) {
            hasGatherSheet = false;
        }
        if ((_obj = (Object)parameter.get("GATHER_SORT")) != null && _obj instanceof List) {
            _orgUnitSort = (List)_obj;
        }
        if (bgFormInfo.getState() != null) {
            state = bgFormInfo.getState().getValue();
        }
        _beginTime = _startTime = System.currentTimeMillis();
        try {
            if (hasGatherTmpData) {
                adjustMap = this.getAdjustMap(bgFormInfo);
            }
            try {
                VariableEntry ve;
                _books[0] = bgFormInfo.getBook();
                if (_books[0].getUserObjectValue("VARIABLES") instanceof ReportVariables && (ve = ((ReportVariables)_books[0].getUserObjectValue("VARIABLES")).get("autoCalculateState", _books[0].getName())) != null) {
                    isBookCal = ve.getBoolValue(false);
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.UNSERIALIZABLEERROR);
            }
            this.setGatherBook(_books[0]);
            if (hasClearFormula) {
                this.clearBookFormula(_books[0], hasBudget, hasGatherAddActual);
            }
            if (hasGatherEnumErate) {
                _books[1] = BookHelper.clone(_books[0]);
                BookHelper.copyBook(_books[0], _books[1], 1);
                _books[2] = BookHelper.clone(_books[0]);
                BookHelper.copyBook(_books[0], _books[2], 2);
            }
            this.setGatherBook(_books);
            bgElementSet = this.getCantGatherBgElement(ctx);
            if (hasBudget && hasGatherEnumErate) {
                _obj = BgNEnumerateHelper.getBgEnumInfo((Book)_books[0]);
                if (_obj != null && _obj instanceof Map) {
                    _enumMap = (Map)_obj;
                }
                BgGatherHelper.removeGatherSignBook(_books, _enumMap, bgFormInfo.getState().getValue());
            }
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke process parameter succeed!");
            logger.info((Object)BgNFSHelper.outTime((long)_startTime, (long)_beginTime, (long)_endTime));
            _beginTime = _endTime;
            if (hasGatherCell || hasGatherEnumErate) {
                if (_orgUnitSort != null && _orgUnitSort.isEmpty()) {
                    StringBuffer sb = new StringBuffer();
                    Object[] params = new Object[bgFormIdsMap.size()];
                    sb.append("select fid from t_org_costcenter where fid in(");
                    Iterator it = bgFormIdsMap.keySet().iterator();
                    Object key = null;
                    int i = 0;
                    while (it.hasNext()) {
                        sb.append("?,");
                        key = it.next();
                        params[i] = key;
                        ++i;
                    }
                    String sql = sb.toString().substring(0, sb.length() - 1) + ") order by flongnumber";
                    try {
                        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                        if (rs != null) {
                            while (rs.next()) {
                                _orgUnitSort.add(rs.getString(1));
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                _orgUnitIds = this.getOrgUnitIdsBySort(bgFormIdsMap, _orgUnitSort);
                formulaSet.addAll(BgNFSHelper.getFormulaSetOfBook((Book)_books[0], null));
                for (String _orgUnitId2 : _orgUnitIds) {
                    _bgFormId = (String)bgFormIdsMap.get(_orgUnitId2);
                    if (hasGatherCell || !hasGatherEnumErate) continue;
                    this.gatherEnumBookArea(ctx, _books, _bgFormId, bgSheetIdSet, formulaSet, _enumMap, hasBudget, hasGatherTmpData, state);
                }
            }
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke process gather area succeed!");
            logger.info((Object)BgNFSHelper.outTime((long)_startTime, (long)_beginTime, (long)_endTime));
            _beginTime = _endTime;
            if (hasGatherFormula) {
                formulaSet = BgNFSHelper.getFormulaSetOfBook((Book)_books[0], bgSheetIdSet);
                valueMap = this.gatherOfFormula(ctx, bgSchemeIdsMap, formulaSet, hasBudget, hasGatherTmpData, hasGatherAddActual, parameter);
            }
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke process gather value succeed!");
            logger.info((Object)BgNFSHelper.outTime((long)_startTime, (long)_beginTime, (long)_endTime));
            _beginTime = _endTime;
            sheetCount = _books[0].getSheetCount();
            for (sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
                _sheet = _books[0].getSheet(sheetIndex);
                if (bgSheetIdSet != null && !bgSheetIdSet.contains(_sheet.getID()) || !BgNFSHelper.checkHasSign((Sheet)_sheet)) continue;
                this.fillValue(ctx, _sheet, valueMap, adjustMap, bgElementSet, hasBudget, hasGatherTmpData, hasGatherAddActual);
            }
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke process fill value succeed!");
            logger.info((Object)BgNFSHelper.outTime((long)_startTime, (long)_beginTime, (long)_endTime));
            _beginTime = _endTime;
            if (hasGatherTmpData) {
                this.setAdjustMap(bgFormInfo, adjustMap);
            }
            if (hasGatherEnumErate) {
                BookHelper.pauseBook(_books[1], _books[0], 1);
                BookHelper.pauseBook(_books[2], _books[0], 2);
            }
            this.saveGatherInfo(_books[0], orgUnitMap, bgSchemeIdsMap, bgFormIdsMap, _orgUnitSort, hasGatherTmpData, parameter);
            this.saveGatherAttachment(ctx, bgFormInfo, bgSchemeIdsMap, bgFormIdsMap, hasGatherFormula);
            if (isBookCal) {
                _books[0].calc();
            }
            bgFormInfo.setBook(_books[0]);
            if (bgFormInfo.getState().getValue() != 4) {
                bgFormInfo.setDataSource(BgFormDataSourceEnum.FORMCOLLECT);
            }
            bgFormInfo.put("CELL_DATA", valueMap);
            _endTime = System.currentTimeMillis();
            logger.info((Object)"invoke process gather succeed!");
            logger.info((Object)BgNFSHelper.outTime((long)_startTime, (long)_beginTime, (long)_endTime));
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (IOException ex) {
            logger.error((Object)ex);
            throw new BgFormException(BgFormException.UNSERIALIZABLEERROR);
        }
        return bgFormInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getAdjustMap(BgFormInfo model) {
        if (model == null) {
            return new HashMap();
        }
        HashMap adjustMap = null;
        byte[] data = model.getAdjustMapData();
        if (data != null && data.length > 0) {
            InputStream is = null;
            ObjectInputStream ois = null;
            try {
                is = ZipUtil.unpack((byte[])data);
                ois = new ObjectInputStream(is);
                adjustMap = (HashMap)ois.readObject();
            }
            catch (IOException ex) {
                adjustMap = new HashMap();
                logger.error((Object)ex);
            }
            catch (ClassNotFoundException ex) {
                adjustMap = new HashMap();
                logger.error((Object)ex);
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException ex) {
                    logger.error((Object)ex);
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    logger.error((Object)ex);
                }
            }
        } else {
            adjustMap = new HashMap();
        }
        return adjustMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAdjustMap(BgFormInfo model, Map adjustMap) {
        if (model == null || adjustMap == null) {
            return;
        }
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(adjustMap);
            oos.flush();
            model.setAdjustMapData(ZipUtil.pack((ByteArrayOutputStream)baos));
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex);
            }
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected void saveGatherAttachment(Context ctx, BgFormInfo bgFormInfo, Map bgSchemeIdsMap, Map bgFormIdsMap, boolean isGatherFormula) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeIdsMap == null || bgFormIdsMap == null) {
            return;
        }
        String _bgFormId = null;
        String _gatherId2 = null;
        String _attachmentId = null;
        String[] _attchId = null;
        IBoAttchAsso iboAttchAsso = null;
        Map.Entry _entry2 = null;
        ArrayList<String> addAttachmentIds = new ArrayList<String>();
        Set<String> _bgFormIdsSet = null;
        HashSet<String> attachment = new HashSet<String>();
        if (isGatherFormula) {
            HashSet<String> orgUnitSet = new HashSet<String>();
            Iterator iter = bgSchemeIdsMap.keySet().iterator();
            while (iter.hasNext()) {
                orgUnitSet.add(iter.next().toString());
            }
            _bgFormIdsSet = this.getGatherBgFormIds(ctx, bgFormInfo, orgUnitSet);
            orgUnitSet.clear();
        } else {
            _bgFormIdsSet = new HashSet();
            for (Map.Entry _entry2 : bgFormIdsMap.entrySet()) {
                _gatherId2 = (String)_entry2.getValue();
                _bgFormIdsSet.add(_gatherId2);
            }
        }
        _bgFormId = bgFormInfo.getId().toString();
        iboAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        _attchId = iboAttchAsso.getAttchIDsByBoID(_bgFormId);
        if (_attchId != null) {
            int in = _attchId.length;
            for (int i = 0; i < in; ++i) {
                _attachmentId = _attchId[i].toString();
                attachment.add(_attachmentId);
            }
        }
        for (String _gatherId2 : _bgFormIdsSet) {
            addAttachmentIds.clear();
            try {
                int i;
                _attchId = iboAttchAsso.getAttchIDsByBoID(_gatherId2);
                if (_attchId == null) continue;
                int in = _attchId.length;
                for (i = 0; i < in; ++i) {
                    _attachmentId = _attchId[i].toString();
                    if (attachment.contains(_attachmentId)) continue;
                    addAttachmentIds.add(_attachmentId);
                }
                if (addAttachmentIds.isEmpty()) continue;
                _attchId = new String[addAttachmentIds.size()];
                in = addAttachmentIds.size();
                for (i = 0; i < in; ++i) {
                    _attchId[i] = (String)addAttachmentIds.get(i);
                }
                iboAttchAsso.addAssociations(_bgFormId, _attchId);
            }
            catch (Exception ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
        }
    }

    protected void saveGatherInfo(Book book, Map orgUnitMap, Map bgSchemeIdsMap, Map bgFormIdsMap, List orgUnitSort, boolean isGatherAdjData, Map parameter) {
        if (book == null || bgSchemeIdsMap == null) {
            return;
        }
        boolean hasGatherByPeriod = false;
        Object _obj = parameter.get("GATHER_PERIOD");
        if (_obj instanceof Boolean) {
            hasGatherByPeriod = (Boolean)_obj;
        }
        book.setUserObject("GATHER_ORGUNIT", (Object)orgUnitMap);
        book.setUserObject("GATHER_ORGUNIT_SORT", (Object)orgUnitSort);
        book.setUserObject("GATHER_SCHEME", (Object)bgSchemeIdsMap);
        book.setUserObject("GATHER_BGFORM", (Object)bgFormIdsMap);
        book.setUserObject("IS_GATHER_ADJUST", (Object)new Boolean(isGatherAdjData));
        book.setUserObject("IS_GATHER_PERIOD", (Object)new Boolean(hasGatherByPeriod));
    }

    protected void setGatherBook(Book[] books) {
        if (books == null) {
            return;
        }
        Book _book2 = null;
        for (Book _book2 : books) {
            BgNFSHelper.disableCal((Book)_book2);
            BgNFSHelper.disableUndo((Book)_book2);
        }
    }

    protected void setGatherBook(Book book) {
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
    }

    protected void setGatherSheet(Sheet sheet) {
        if (sheet != null) {
            return;
        }
    }

    protected Map gatherOfFormula(Context ctx, Map bgSchemeIds, Set formulaSet, boolean isBudget, boolean isTmpData, boolean isAddActaul, Map parameter) throws BOSException, EASBizException {
        int i;
        int index;
        if (ctx == null || bgSchemeIds == null || bgSchemeIds.isEmpty() || formulaSet == null || formulaSet.isEmpty()) {
            return new HashMap();
        }
        boolean hasGatherScheme = false;
        Object _obj = parameter.get("GATHER_SCHEME_FORMULA");
        if (_obj instanceof Boolean) {
            hasGatherScheme = (Boolean)_obj;
        }
        boolean hasGatherByPeriod = false;
        _obj = parameter.get("GATHER_PERIOD");
        if (_obj instanceof Boolean) {
            hasGatherByPeriod = (Boolean)_obj;
        }
        String _gatherByPeriodId = (String)parameter.get("GATHER_PERIOD_ID");
        String _formulaStr = null;
        String _orgUnitId2 = null;
        String _bgSchemeId = null;
        BigDecimal _value = null;
        BgNDataInfo data = null;
        HashMap<String, BgNDataInfo> formulaValueMap = new HashMap<String, BgNDataInfo>();
        ArrayList formulaList = new ArrayList();
        formulaList.addAll(formulaSet);
        List _state = null;
        ArrayList<String> _orgList = new ArrayList<String>();
        ArrayList<String> _schemeList = new ArrayList<String>();
        for (String _orgUnitId2 : bgSchemeIds.keySet()) {
            _bgSchemeId = (String)bgSchemeIds.get(_orgUnitId2);
            _orgList.add(_orgUnitId2);
            _schemeList.add(_bgSchemeId);
        }
        int formultBatchSize = 500;
        int formultSize = formulaList.size();
        int formultCount = (formultSize - 1) / formultBatchSize + 1;
        boolean formultPos = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer(8192);
        StringBuffer adjSql = new StringBuffer(8192);
        if (isBudget) {
            sql.append("select sum(t.FBgValue) cnt, t.FFormula from T_BG_BgData t ");
            adjSql.append("select sum(t.FBgBalance) cnt, t.FFormula from T_BG_BgTmpData t ");
            if (hasGatherScheme) {
                sql.append(" left join T_BG_BgForm f on t.FBgFormId = f.FID ");
            }
            sql.append(" where ");
            adjSql.append(" where ");
            for (index = 0; index < bgSchemeIds.size(); ++index) {
                if (index == 0) {
                    sql.append(" ((t.FOrgUnitId = ? and t.FBgSchemeId = ?)");
                    adjSql.append(" ((t.FOrgUnitId = ? and t.FBgSchemeId = ?)");
                    continue;
                }
                sql.append(" or (t.FOrgUnitId = ? and t.FBgSchemeId = ?)");
                adjSql.append(" or (t.FOrgUnitId = ? and t.FBgSchemeId = ?)");
            }
            sql.append(") and t.FFormula in(");
            adjSql.append(") and t.FFormula in(");
            for (i = 0; i < formultBatchSize; ++i) {
                if (i == formultBatchSize - 1) {
                    sql.append("?");
                    adjSql.append("?");
                    continue;
                }
                sql.append("?,");
                adjSql.append("?,");
            }
            sql.append(") ");
            adjSql.append(") ");
            sql.append(" and NOT exists (SELECT FID FROM T_BG_BgElement WHERE FApportionable = 0 and T_BG_BgElement.fid = t.FBgElementId) ");
            adjSql.append(" and NOT exists (SELECT FID FROM T_BG_BgElement WHERE FApportionable = 0 and T_BG_BgElement.fid = t.FBgElementId) ");
            if (hasGatherScheme) {
                _state = this.getGatherState(ctx);
                sql.append(" AND f.FState IN (").append(BgNSQLHelper.getParamSizeString((Collection)_state)).append(")");
            }
            sql.append(" group by t.FFormula");
            adjSql.append(" group by t.FFormula");
        } else if (isAddActaul) {
            sql.append("select sum(FBIZACTUAL), FFormula from T_BG_BgActualData where ");
            for (index = 0; index < bgSchemeIds.size(); ++index) {
                if (index == 0) {
                    sql.append(" ((FOrgUnitId = ? and FBgSchemeId = ?)");
                    continue;
                }
                sql.append(" or (FOrgUnitId = ? and FBgSchemeId = ?)");
            }
            sql.append(") and FFormula in(");
            for (i = 0; i < formultBatchSize; ++i) {
                if (i == formultBatchSize - 1) {
                    sql.append("?");
                    continue;
                }
                sql.append("?,");
            }
            sql.append(") ");
            if (hasGatherByPeriod) {
                sql.append(" and FBgPeriodId = ? ");
            }
            sql.append(" and FBgActualRecordId in (select FID from T_BG_BgActualRecord where FState = ?");
            sql.append(") group by FFormula");
        } else {
            sql.append("select sum(FBgActual) cnt, FFormula from T_BG_BgData where ");
            for (index = 0; index < bgSchemeIds.size(); ++index) {
                if (index == 0) {
                    sql.append(" ((FOrgUnitId = ? and FBgSchemeId = ?)");
                    continue;
                }
                sql.append(" or (FOrgUnitId = ? and FBgSchemeId = ?)");
            }
            sql.append(") and FFormula in(");
            for (i = 0; i < formultBatchSize; ++i) {
                if (i == formultBatchSize - 1) {
                    sql.append("?");
                    continue;
                }
                sql.append("?,");
            }
            sql.append(") ");
            sql.append(" and NOT exists (SELECT FID FROM T_BG_BgElement WHERE FApportionable = 0 and T_BG_BgElement.fid = FBgElementId)");
            sql.append(" group by FFormula");
        }
        try {
            int pos;
            int size;
            int i2;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int y = 1;
            int pos2 = 0;
            while (y <= bgSchemeIds.size()) {
                pstmt.setString(y * 2 - 1, (String)_orgList.get(pos2));
                pstmt.setString(y * 2, (String)_schemeList.get(pos2));
                ++y;
                ++pos2;
            }
            index = 0;
            for (i2 = 0; i2 < formultCount; ++i2) {
                size = 0;
                pos = bgSchemeIds.size() * 2 + 1;
                while (size < formultBatchSize) {
                    if (index < formultSize) {
                        pstmt.setString(pos, (String)formulaList.get(index));
                    } else {
                        pstmt.setString(pos, "#");
                    }
                    ++size;
                    ++index;
                    ++pos;
                }
                if (isBudget) {
                    BgNSQLHelper.setParams((PreparedStatement)pstmt, (List)_state, (int)(bgSchemeIds.size() * 2 + 1 + formultBatchSize));
                } else if (isAddActaul) {
                    if (hasGatherByPeriod) {
                        pstmt.setString(bgSchemeIds.size() * 2 + formultBatchSize + 1, _gatherByPeriodId);
                        pstmt.setInt(bgSchemeIds.size() * 2 + formultBatchSize + 2, 2);
                    } else {
                        pstmt.setInt(bgSchemeIds.size() * 2 + formultBatchSize + 1, 2);
                    }
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _value = rst.getBigDecimal(1);
                    _formulaStr = rst.getString(2);
                    if (!formulaValueMap.containsKey(_formulaStr)) {
                        data = new BgNDataInfo();
                        data.setFormula(_formulaStr);
                        if (isBudget) {
                            data.setBudgetValue(_value);
                        } else if (isAddActaul) {
                            data.setAddActualValue(_value);
                        } else {
                            data.setActualValue(_value);
                        }
                        formulaValueMap.put(_formulaStr, data);
                        continue;
                    }
                    data = (BgNDataInfo)formulaValueMap.get(_formulaStr);
                    if (isBudget) {
                        data.setBudgetValue(data.getBudgetValue().add(_value));
                        continue;
                    }
                    if (isAddActaul) {
                        data.setAddActualValue(data.getAddActualValue().add(_value));
                        continue;
                    }
                    data.setActualValue(data.getActualValue().add(_value));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            if (isBudget && isTmpData) {
                pstmt = conn.prepareStatement(adjSql.toString());
                int y2 = 1;
                int pos3 = 0;
                while (y2 <= bgSchemeIds.size()) {
                    pstmt.setString(y2 * 2 - 1, (String)_orgList.get(pos3));
                    pstmt.setString(y2 * 2, (String)_schemeList.get(pos3));
                    ++y2;
                    ++pos3;
                }
                index = 0;
                for (i2 = 0; i2 < formultCount; ++i2) {
                    size = 0;
                    pos = bgSchemeIds.size() * 2 + 1;
                    while (size < formultBatchSize) {
                        if (index < formultSize) {
                            pstmt.setString(pos, (String)formulaList.get(index));
                        } else {
                            pstmt.setString(pos, "#");
                        }
                        ++size;
                        ++index;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _value = rst.getBigDecimal(1);
                        _formulaStr = rst.getString(2);
                        if (!formulaValueMap.containsKey(_formulaStr)) {
                            data = new BgNDataInfo();
                            data.setFormula(_formulaStr);
                            data.setBudgetValue(_value);
                            formulaValueMap.put(_formulaStr, data);
                            continue;
                        }
                        data = (BgNDataInfo)formulaValueMap.get(_formulaStr);
                        data.setBudgetValue(data.getBudgetValue().add(_value));
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return formulaValueMap;
    }

    protected void fillValue(Context ctx, Sheet sheet, Map valueMap, Map adjustMap, Set bgElementSet, boolean hasBudget, boolean hasGatherAdjData, boolean hasGatherAddActual) {
        if (sheet == null || valueMap == null) {
            return;
        }
        BgNDataInfo dataInfo = null;
        String userId = null;
        Timestamp time = null;
        if (hasGatherAdjData) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            time = new Timestamp(System.currentTimeMillis());
        }
        int rowIndex = 0;
        int colIndex = 0;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        Cell _cell = null;
        String _formulaStr = null;
        String[] _parameter = null;
        BigDecimal _value = null;
        BgFormDiversityData divData = null;
        for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                _cell = sheet.getCell(rowIndex, colIndex, true);
                if (BgNFSHelper.checkHasFormulaOfCell((Cell)_cell)) {
                    if (BgNFSHelper.isLockOfCell((Cell)_cell)) {
                        BgNFSHelper.setCellData((Cell)_cell, (String)"BGDATA_CAN_UPDATE", (Object)Boolean.FALSE);
                    }
                    _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)_cell);
                    _parameter = BgNFSHelper.parseFormulaPara((String)_formulaStr);
                    if (hasGatherAdjData) {
                        _value = !BgNFSHelper.checkIsEmptyValue((Cell)_cell) ? BgNFSHelper.getBudgetValue((Cell)_cell) : BgNConstants.ZERO;
                    }
                    if (!bgElementSet.contains(_parameter[2])) {
                        if (valueMap.containsKey(_formulaStr)) {
                            dataInfo = (BgNDataInfo)valueMap.get(_formulaStr);
                            if (hasBudget) {
                                BgNFSHelper.setValue((Cell)_cell, (Object)dataInfo.getBudgetValue());
                                BgNFSHelper.setBudgetValue((Cell)_cell, (BigDecimal)dataInfo.getBudgetValue());
                            } else if (hasGatherAddActual) {
                                BgNFSHelper.setValue((Cell)_cell, (Object)dataInfo.getAddActualValue());
                            } else {
                                BgNFSHelper.setValue((Cell)_cell, (Object)dataInfo.getActualValue());
                                BgNFSHelper.setActualValue((Cell)_cell, (BigDecimal)dataInfo.getActualValue());
                            }
                            if (hasGatherAdjData && _value != null && _value.compareTo(dataInfo.getBudgetValue()) != 0) {
                                if (adjustMap != null) {
                                    if (adjustMap.containsKey(_formulaStr)) {
                                        divData = (BgFormDiversityData)adjustMap.get(_formulaStr);
                                    } else {
                                        divData = new BgFormDiversityData();
                                        divData.setFormula(_formulaStr);
                                        divData.setOldValue(_value);
                                        adjustMap.put(_formulaStr, divData);
                                    }
                                }
                                if (divData != null) {
                                    divData.setNewValue(dataInfo.getBudgetValue());
                                    divData.setAdjustor(userId);
                                    divData.setAdjustTime(time);
                                }
                            }
                        } else if (hasGatherAdjData && _value != null && _value.compareTo(BgNConstants.ZERO) != 0) {
                            if (adjustMap != null) {
                                if (adjustMap.containsKey(_formulaStr)) {
                                    divData = (BgFormDiversityData)adjustMap.get(_formulaStr);
                                } else {
                                    divData = new BgFormDiversityData();
                                    divData.setFormula(_formulaStr);
                                    divData.setOldValue(_value);
                                    adjustMap.put(_formulaStr, divData);
                                }
                            }
                            if (divData != null) {
                                divData.setNewValue(BgNConstants.ZERO);
                                divData.setAdjustor(userId);
                                divData.setAdjustTime(time);
                            }
                        }
                    }
                }
                if (!_cell.hasFormula()) continue;
                BgNFSHelper.saveExpression((Cell)_cell, (String)_cell.getFormula(), (int)0);
            }
        }
    }

    protected List getOrgUnitIdsBySort(Map bgFormIdsMap, List orgUnitSort) {
        ArrayList<String> _orgUnitIds = new ArrayList<String>();
        Map.Entry _entry2 = null;
        String _orgUnitId = null;
        if (orgUnitSort != null && !orgUnitSort.isEmpty()) {
            int in = orgUnitSort.size();
            for (int i = 0; i < in; ++i) {
                _orgUnitId = (String)orgUnitSort.get(i);
                if (!bgFormIdsMap.containsKey(_orgUnitId)) continue;
                _orgUnitIds.add(_orgUnitId);
            }
        } else {
            for (Map.Entry _entry2 : bgFormIdsMap.entrySet()) {
                _orgUnitId = (String)_entry2.getKey();
                _orgUnitIds.add(_orgUnitId);
            }
        }
        return _orgUnitIds;
    }

    @Override
    protected List _getGatherView(Context ctx, Map bgFormIds, String formulaStr, boolean isBudget, boolean isAdjust) throws BOSException, EASBizException {
        List reList = new ArrayList();
        if (formulaStr == null || bgFormIds == null || bgFormIds.isEmpty()) {
            return reList;
        }
        Connection conn = null;
        String bgFormIdStr2 = null;
        String tmpFormula = null;
        Map bargainMap = null;
        try {
            conn = this.getConnection(ctx);
            bargainMap = this.getUseBargainByBgItemInfo(ctx, conn);
            tmpFormula = this.getQueryOfFormula(formulaStr);
            for (String bgFormIdStr2 : bgFormIds.keySet()) {
                reList = this.getGatherFormulaView(ctx, conn, bgFormIdStr2, formulaStr, tmpFormula, isBudget, isAdjust, reList, bargainMap);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return reList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List getGatherFormulaView(Context ctx, Connection conn, String bgFormId, String formulaStr, String queryFormulaStr, boolean isBudget, boolean isAdjust, List data, Map bargainMap) throws BOSException, EASBizException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BigDecimal value = null;
        String tmpFormula = null;
        String _tmpFormula = null;
        Object orgUnitId = null;
        Object[] dataObj = null;
        HashMap<String, Object[]> dataMap = new HashMap<String, Object[]>();
        BgFormInfo bgFormInfo = null;
        FullOrgUnitInfo orgUnitInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select" + (isBudget ? " FBgValue" : " FBizActual") + ", FFormula from T_BG_BgData where FBgFormId = ? and FFormula like ?");
        try {
            bgFormInfo = BgInfoHelper.getBgFormInfo((Connection)conn, (BOSUuid)BOSUuid.read((String)bgFormId), (boolean)false);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getOrgUnit().getId()), sic);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgFormId);
            pstmt.setString(2, queryFormulaStr);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                value = rst.getBigDecimal(1);
                tmpFormula = rst.getString(2);
                _tmpFormula = this.getFormulaOfBargain(tmpFormula, bargainMap);
                if (_tmpFormula == null || !formulaStr.equals(_tmpFormula)) continue;
                dataObj = new Object[]{orgUnitId, orgUnitInfo.getName(), bgFormId, bgFormInfo.getName(), tmpFormula, value};
                data.add(dataObj);
                dataMap.put(tmpFormula, dataObj);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (isAdjust && isBudget) {
                sql = new StringBuffer();
                sql.append("select FBgValue, FFormula from T_BG_BgTmpData where FBgFormId = ? and FFormula like ?");
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, bgFormId);
                pstmt.setString(2, queryFormulaStr);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    value = rst.getBigDecimal(1);
                    tmpFormula = rst.getString(2);
                    _tmpFormula = this.getFormulaOfBargain(tmpFormula, bargainMap);
                    if (_tmpFormula == null || !formulaStr.equals(_tmpFormula)) continue;
                    if (dataMap.containsKey(tmpFormula)) {
                        dataObj = (Object[])dataMap.get(tmpFormula);
                        dataObj[5] = value;
                        continue;
                    }
                    dataObj = new Object[]{orgUnitId, orgUnitInfo.getName(), bgFormId, bgFormInfo.getName(), tmpFormula, value};
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (EASBizException ex2) {
                    throw ex2;
                }
                catch (BOSException ex3) {
                    throw ex3;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return data;
    }

    protected Map getUseBargainByBgItemInfo(Context ctx, Connection conn) throws EASBizException {
        if (ctx == null || conn == null) {
            return new HashMap();
        }
        HashMap<String, BgItemInfo> bgBargainMap = new HashMap<String, BgItemInfo>();
        BgItemInfo bgItemInfo = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String bargainGroupNo = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer group = new StringBuffer();
        group.append("select FRefField from T_BG_BgItemGroup where FName_" + ctx.getLocale() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"35_BgGatherFacadeControllerBean", (Locale)ctx.getLocale()));
        try {
            pstmt = conn.prepareStatement(group.toString());
            rst = pstmt.executeQuery();
            bargainGroupNo = rst.next() ? rst.getString(1) : "F17";
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            sql.append("select t.FID, t.FNumber, t.FName_" + ctx.getLocale() + " from T_BG_BgItem t left outer join T_BG_BgItemCombination i on t.FNumber = i." + bargainGroupNo + " where t.FReffield = '" + bargainGroupNo + "' and i." + bargainGroupNo + " is not null;");
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgItemInfo = new BgItemInfo();
                bgItemInfo.setId(BOSUuid.read((String)rst.getString(1)));
                bgItemInfo.setNumber(rst.getString(2));
                bgItemInfo.setName(rst.getString(3));
                bgBargainMap.put(bgItemInfo.getNumber(), bgItemInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgBargainMap;
    }

    protected Map getFormulaCellMap(Sheet sheet, int rowCount, int colCount, Map aliasMap) {
        if (sheet == null) {
            return new HashMap();
        }
        Row _row = null;
        Column _column = null;
        Cell _cell = null;
        HashMap<String, Cell> formulaMap = new HashMap<String, Cell>();
        String formulaStr = null;
        Object sign = null;
        String rowId = null;
        int rowIndex = 0;
        int colIndex = 0;
        for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            _row = sheet.getRow(rowIndex, false);
            if (_row == null || !BgNFSHelper.checkHasSign((Row)_row)) continue;
            rowId = BgNFSHelper.getRowSign((Row)_row);
            sign = BgNFSHelper.getRowSource((Row)_row);
            if (sign == null || "DATA_SOURCE_TEMP".equals(sign)) continue;
            for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                _column = sheet.getColumn(colCount, false);
                if (_column == null || !BgNFSHelper.checkHasSign((Column)_column) || (sign = BgNFSHelper.getColSource((Column)_column)) == null || "DATA_SOURCE_TEMP".equals(sign) || !BgNFSHelper.checkHasFormulaOfCell((Cell)(_cell = sheet.getCell(rowIndex, colIndex, true)))) continue;
                formulaStr = BgNFSHelper.getFormulaOfCell((Cell)_cell);
                formulaMap.put(formulaStr, _cell);
                aliasMap.put(formulaStr, rowId);
            }
        }
        return formulaMap;
    }

    protected String getFormulaOfBargain(String formulaString, Map bargainMap) {
        if (formulaString == null) {
            return null;
        }
        String[] parameter = null;
        String[] bgItems = null;
        StringBuffer _tmpBgItem = new StringBuffer();
        parameter = BgNFSHelper.parseFormulaPara(null, (String)formulaString);
        if (parameter != null && (bgItems = parameter[0].split(",")).length > 1) {
            int i;
            int n = bgItems.length;
            for (i = 0; i < n; ++i) {
                if (bargainMap == null || !bargainMap.containsKey(bgItems[i])) continue;
                bgItems[i] = null;
            }
            n = bgItems.length;
            for (i = 0; i < n; ++i) {
                if (bgItems[i] == null) continue;
                _tmpBgItem.append(bgItems[i] + ",");
            }
            parameter[0] = _tmpBgItem.delete(_tmpBgItem.length() - 1, _tmpBgItem.length()).toString();
            formulaString = new StringBuffer("=BgItem(\"" + parameter[0] + "\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\"," + parameter[4] + ",\"" + parameter[5] + "\")").toString();
        }
        return formulaString;
    }

    protected String getQueryOfFormula(String formulaStr) {
        String[] parameter = BgNFSHelper.parseFormulaPara(null, (String)formulaStr);
        if (parameter != null) {
            StringBuffer formulaString = new StringBuffer("=BgItem(\"%" + parameter[0] + "%\",\"" + parameter[1] + "\",\"" + parameter[2] + "\",\"" + parameter[3] + "\"," + parameter[4] + ",\"" + parameter[5] + "\")");
            return formulaString.toString();
        }
        return formulaStr;
    }

    protected Map getBeforeValueMap(Book book) {
        HashMap<String, BigDecimal> befValueMap = new HashMap<String, BigDecimal>();
        if (book == null) {
            return befValueMap;
        }
        Cell _cell = null;
        Sheet _sheet = null;
        Object _obj = null;
        String _formulaStr = null;
        BigDecimal _value = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        int count = book.getSheetCount();
        for (int index = 0; index < count; ++index) {
            _sheet = book.getSheet(index);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_cell)) continue;
                    _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)_cell);
                    if (!BgNFSHelper.checkIsEmptyValue((Cell)_cell)) {
                        _obj = BgNFSHelper.getValue((Cell)_cell);
                        if (_obj instanceof BigDecimal) {
                            _value = (BigDecimal)_obj;
                        } else {
                            try {
                                _value = new BigDecimal(_obj.toString().trim().replaceAll(",", ""));
                            }
                            catch (Exception ex) {
                                _value = BgNConstants.ZERO;
                            }
                        }
                    } else {
                        _value = BgNConstants.ZERO;
                    }
                    befValueMap.put(_formulaStr, _value);
                }
            }
        }
        return befValueMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Set getCantGatherBgElement(Context ctx) throws BOSException, EASBizException {
        if (ctx == null) {
            return new HashSet();
        }
        HashSet<String> bgElementSet = new HashSet<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FNumber from T_BG_BgElement where FApportionable = 0");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgElementSet.add(rst.getString(1));
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgElementSet;
    }

    protected Sheet getGatherSheet(Book book, String sheetId) {
        if (book == null || StringUtils.isEmpty((String)sheetId)) {
            return null;
        }
        Sheet _sheet = null;
        String _sheetId = null;
        int sheetSize = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            if (!BgNFSHelper.checkHasSign((Sheet)_sheet) || !sheetId.equals(_sheetId = BgNFSHelper.getSheetSign((Sheet)_sheet))) continue;
            return _sheet;
        }
        return null;
    }

    protected void gatherEnumBookArea(Context ctx, Book[] books, String bgFormId, Set bgSheetIdSet, Set formulaSet, Map enumMap, boolean hasBudget, boolean hasTmpData, int state) throws BOSException, EASBizException {
        if (ctx == null || books == null || books.length == 0 || StringUtils.isEmpty((String)bgFormId) || enumMap == null) {
            return;
        }
        if (bgSheetIdSet != null && bgSheetIdSet.isEmpty()) {
            return;
        }
        String _bgFormId = null;
        List _enumsInfo = null;
        BgFormInfo _bgFormInfo = null;
        Book _upBook = null;
        Sheet _sheet = null;
        Sheet _upSheet = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            _bgFormId = bgFormId;
            if (hasTmpData && (_bgFormId = BgInfoHelper.checkHasAdjust((Connection)conn, (String)bgFormId)) == null) {
                _bgFormId = bgFormId;
            }
            _bgFormInfo = BgInfoHelper.getBgFormInfo((Connection)conn, (String)_bgFormId, (boolean)true);
            try {
                _upBook = _bgFormInfo.getBook();
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw new BgFormException(BgFormException.UNSERIALIZABLEERROR);
            }
            this.setGatherBook(_upBook);
            int count = books[0].getSheetCount();
            for (int index = 0; index < count; ++index) {
                _sheet = books[0].getSheet(index);
                _upSheet = this.getGatherSheet(_upBook, BgNFSHelper.getSheetSign((Sheet)_sheet));
                if (_sheet == null || _upSheet == null || bgSheetIdSet != null && !bgSheetIdSet.contains(_sheet.getID())) continue;
                this.setGatherSheet(_sheet);
                this.setGatherSheet(_upSheet);
                if (!BgNFSHelper.checkHasSign((Sheet)_sheet)) continue;
                _enumsInfo = BgNEnumerateHelper.getBgEnumInfo((String)_sheet.getID(), (Map)enumMap);
                this.gatherEnumSheetArea(books, _sheet, _upSheet, _enumsInfo, formulaSet, state);
                this.clearEnumSheetNullRow(_sheet, _enumsInfo, enumMap);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void clearEnumSheetNullRow(Sheet sheet, List enumsInfo, Map enumMap) {
        if (sheet == null || enumsInfo == null || enumsInfo.isEmpty()) {
            return;
        }
        Row row = null;
        BgNEnumGatherInfo gatherInfo = null;
        ArrayList<Integer> delRows = new ArrayList<Integer>();
        List gatherList = null;
        int lastRow = -1;
        for (int i = 0; i < enumsInfo.size(); ++i) {
            BgNEnumerateInfo enumInfo = (BgNEnumerateInfo)enumsInfo.get(i);
            if (!BgNEnumerateHelper.checkHasGatherArea((BgNEnumerateInfo)enumInfo)) continue;
            gatherList = enumInfo.getGatherEnumInfo();
            int jn = gatherList.size();
            for (int j = 0; j < jn; ++j) {
                lastRow = -1;
                gatherInfo = (BgNEnumGatherInfo)gatherList.get(j);
                Rectangle rect = BgNEnumerateHelper.getEnumArea((Sheet)sheet, (BgNEnumInfo)gatherInfo);
                if (rect == null || rect.height == 0) continue;
                int rowCount = rect.height;
                for (int rowIndex = rect.x; rowIndex <= rowCount; ++rowIndex) {
                    row = sheet.getRow(rowIndex, false);
                    if (BgGatherHelper.checkHasEnumSign(row)) continue;
                    if (BgNFSHelper.checkIsEmptyRow((Row)row)) {
                        delRows.add(new Integer(row.getRow()));
                        continue;
                    }
                    lastRow = Math.max(lastRow, row.getRow());
                }
                if (!delRows.isEmpty()) {
                    Collections.sort(delRows);
                    for (int k = delRows.size() - 1; k >= 0; --k) {
                        int rIndex = (Integer)delRows.get(k);
                        if (rIndex >= lastRow) continue;
                        BgNFSHelper.removeRow((Sheet)sheet, (int)rIndex);
                    }
                }
                delRows.clear();
            }
        }
    }

    protected void gatherEnumSheetArea(Book[] books, Sheet sheet, Sheet upSheet, List enumsInfo, Set formulaSet, int state) {
        if (books == null || sheet == null || upSheet == null || enumsInfo == null) {
            return;
        }
        BgNEnumerateInfo _enumInfo = null;
        BgNEnumGatherInfo _gatherInfo = null;
        List _gatherList = null;
        int in = enumsInfo.size();
        for (int i = 0; i < in; ++i) {
            _enumInfo = (BgNEnumerateInfo)enumsInfo.get(i);
            if (!BgNEnumerateHelper.checkHasGatherArea((BgNEnumerateInfo)_enumInfo)) continue;
            _gatherList = _enumInfo.getGatherEnumInfo();
            int jn = _gatherList.size();
            for (int j = 0; j < jn; ++j) {
                _gatherInfo = (BgNEnumGatherInfo)_gatherList.get(j);
                this.gatherEnumArea(books, sheet, upSheet, _gatherInfo, formulaSet, state);
            }
        }
    }

    protected void gatherEnumArea(Book[] books, Sheet sheet, Sheet upSheet, BgNEnumGatherInfo enumInfo, Set formulaSet, int state) {
        if (books == null || sheet == null || upSheet == null || enumInfo == null) {
            return;
        }
        Rectangle _rect = BgNEnumerateHelper.getEnumArea((Sheet)sheet, (BgNEnumInfo)enumInfo);
        Rectangle _upRect = BgNEnumerateHelper.getEnumArea((Sheet)upSheet, (BgNEnumInfo)enumInfo);
        if (_rect == null || _rect.height == 0 || _upRect == null) {
            return;
        }
        Row _row = null;
        Row _upRow = null;
        Cell _cell = null;
        Cell _upCell = null;
        Set _alias = null;
        int rowCount = _upRect.height;
        int colIndex = _upRect.y;
        int colCount = _upRect.width;
        int _differ = _rect.y - _upRect.y;
        _alias = BgGatherHelper.getAreaAlias(sheet, _rect, state);
        for (int rowIndex = _upRect.x; rowIndex <= rowCount; ++rowIndex) {
            _upRow = upSheet.getRow(rowIndex, false);
            if (!BgGatherHelper.checkHasFormula(_upRow, formulaSet, _upRect)) continue;
            _row = BgGatherHelper.getLastUpdataRow(books, sheet, _rect, _upRow, _alias, _upRect.y);
            for (colIndex = _upRect.y; colIndex <= colCount; ++colIndex) {
                _cell = _row.getCell(colIndex + _differ, true);
                _upCell = _upRow.getCell(colIndex, false);
                this.updateCell(_cell, _upCell, formulaSet);
            }
        }
    }

    protected void updateCell(Cell cell, Cell upCell, Set formulaSet) {
        if (cell == null || upCell == null) {
            return;
        }
        String _formulaStr = null;
        String[] _strs = null;
        if (upCell.getValue() != Variant.nullVariant && !upCell.getValue().isEmpty()) {
            cell.setValue(upCell.getValue());
        }
        if (BgNFSHelper.checkHasFormulaOfCell((Cell)upCell)) {
            _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)upCell);
            if (!formulaSet.contains(_formulaStr)) {
                BgNFSHelper.setFormulaOfCell((Cell)cell, (String)_formulaStr, (boolean)true);
                formulaSet.add(_formulaStr);
                BgNFSHelper.setCellSource((Cell)cell, (String)"DATA_SOURCE_COLLECT");
            } else {
                BgNFSHelper.setUserObject((Cell)cell, (String)"SIGN_DATA_SOURCE", (String)"DATA_SOURCE_COLLECT");
            }
        } else {
            BgNFSHelper.setUserObject((Cell)cell, (String)"SIGN_DATA_SOURCE", (String)"DATA_SOURCE_COLLECT");
        }
        if (BgNFSHelper.checkHasBgItemInfo((Cell)upCell)) {
            _strs = BgNFSHelper.getBgItemInfo((Cell)upCell);
            BgNFSHelper.setBgItemInfo((Cell)cell, (String)_strs[1], (String)_strs[2]);
            BgNFSHelper.setUserObject((Cell)cell, (String)"SIGN_DATA_SOURCE", (String)"DATA_SOURCE_COLLECT");
        }
        if (BgNFSHelper.checkHasBgPeriodInfo((Cell)upCell)) {
            _strs = BgNFSHelper.getBgPeriodInfo((Cell)upCell);
            BgNFSHelper.setBgPeriodInfo((Cell)cell, (String)_strs[1]);
            BgNFSHelper.setUserObject((Cell)cell, (String)"SIGN_DATA_SOURCE", (String)"DATA_SOURCE_COLLECT");
        }
        if (BgNFSHelper.checkHasBgElementInfo((Cell)upCell)) {
            _strs = BgNFSHelper.getBgElementInfo((Cell)upCell);
            BgNFSHelper.setBgElementInfo((Cell)cell, (String)_strs[1], (String)_strs[2]);
            BgNFSHelper.setUserObject((Cell)cell, (String)"SIGN_DATA_SOURCE", (String)"DATA_SOURCE_COLLECT");
        }
        if (BgNFSHelper.checkHasCurrencyInfo((Cell)upCell)) {
            _strs = BgNFSHelper.getCurrencyInfo((Cell)upCell);
            BgNFSHelper.setCurrencyInfo((Cell)cell, (String)_strs[1]);
            BgNFSHelper.setUserObject((Cell)cell, (String)"SIGN_DATA_SOURCE", (String)"DATA_SOURCE_COLLECT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _queryGatherValue(Context ctx, Map bgGatherMap, Map queryMap, int view, boolean hasTmpData) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> _queryMap = new HashMap<String, BigDecimal>();
        if (bgGatherMap == null || queryMap == null || bgGatherMap.isEmpty() || queryMap.isEmpty()) {
            return _queryMap;
        }
        int index = 0;
        int size = 0;
        int count = 0;
        int pos = 0;
        int batchSize = 200;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _key = null;
        String _tmpKey = null;
        BigDecimal _value = null;
        BigDecimal _tmpValue = null;
        List _formulaList = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        Map.Entry _entry2 = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmp = null;
        ResultSet rst = null;
        String _tmpStr = "FBgValue";
        _tmpStr = view == 0 ? "FBgValue" : (view == 1 ? "FBgActual" : "FBizActual");
        StringBuffer sql = new StringBuffer();
        sql.append("select FOrgUnitId, sum(").append(_tmpStr).append(") from T_BG_BgData where ");
        sql.append("(");
        for (Map.Entry _entry2 : bgGatherMap.entrySet()) {
            _orgUnitId = (String)_entry2.getKey();
            _bgSchemeId = (String)_entry2.getValue();
            sql.append("(FOrgUnitId = ? and FBgSchemeId = ?) or ");
            _tmpList.add(_orgUnitId);
            _tmpList.add(_bgSchemeId);
        }
        sql.delete(sql.length() - 4, sql.length()).append(")");
        sql.append(" and FFormula in (");
        for (index = 1; index < batchSize; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        sql.append(" group by FOrgUnitId");
        _tmpStr = sql.toString();
        try {
            int x;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(_tmpStr);
            for (Map.Entry _entry2 : queryMap.entrySet()) {
                _key = (String)_entry2.getKey();
                _formulaList = (List)_entry2.getValue();
                index = 0;
                size = _formulaList.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                for (index = 0; index < count; ++index) {
                    BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
                    x = 1;
                    while (x <= batchSize) {
                        if (pos < size) {
                            pstmt.setString(_tmpList.size() + x, (String)_formulaList.get(pos));
                        } else {
                            pstmt.setString(_tmpList.size() + x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    try {
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _orgUnitId = rst.getString(1);
                            _value = rst.getBigDecimal(2);
                            _tmpKey = _orgUnitId + "_" + _key;
                            if (_queryMap.containsKey(_tmpKey)) {
                                _tmpValue = (BigDecimal)_queryMap.get(_tmpKey);
                                _value = _value.add(_tmpValue);
                            }
                            _queryMap.put(_tmpKey, _value);
                        }
                        continue;
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
            }
            SQLUtils.cleanup((Statement)pstmt);
            if (hasTmpData && view == 0) {
                _tmpStr = _tmpStr.replaceAll("T_BG_BgData", "T_BG_BgTmpData");
                _tmpStr = _tmpStr.replaceAll("FBgValue", "FBgBalance");
                pstmp = conn.prepareStatement(_tmpStr);
                for (Map.Entry _entry2 : queryMap.entrySet()) {
                    _key = (String)_entry2.getKey();
                    _formulaList = (List)_entry2.getValue();
                    index = 0;
                    size = _formulaList.size();
                    count = (size - 1) / batchSize + 1;
                    pos = 0;
                    for (index = 0; index < count; ++index) {
                        BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
                        x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                pstmp.setString(_tmpList.size() + x, (String)_formulaList.get(pos));
                            } else {
                                pstmp.setString(_tmpList.size() + x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        try {
                            rst = pstmp.executeQuery();
                            while (rst.next()) {
                                _orgUnitId = rst.getString(1);
                                _value = rst.getBigDecimal(2);
                                _tmpKey = _orgUnitId + "_" + _key;
                                if (_queryMap.containsKey(_tmpKey)) {
                                    _tmpValue = (BigDecimal)_queryMap.get(_tmpKey);
                                    _value = _value.add(_tmpValue);
                                }
                                _queryMap.put(_tmpKey, _value);
                            }
                            continue;
                        }
                        finally {
                            SQLUtils.cleanup((ResultSet)rst);
                        }
                    }
                }
                SQLUtils.cleanup((Statement)pstmp);
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(pstmp);
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        return _queryMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _queryGatherValue(Context ctx, Map bgGatherMap, Set formulaSet, int view, boolean hasTmpData) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> _queryMap = new HashMap<String, BigDecimal>();
        if (bgGatherMap == null) return _queryMap;
        if (formulaSet == null) return _queryMap;
        if (bgGatherMap.isEmpty()) return _queryMap;
        if (formulaSet.isEmpty()) {
            return _queryMap;
        }
        int index = 0;
        int size = 0;
        int count = 0;
        int pos = 0;
        int batchSize = 200;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _key = null;
        String _formulaStr = null;
        BigDecimal _value = null;
        BigDecimal _tmpValue = null;
        ArrayList _formulaList = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        Map.Entry _entry2222 = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        _formulaList = new ArrayList();
        _formulaList.addAll(formulaSet);
        index = 0;
        size = _formulaList.size();
        count = (size - 1) / batchSize + 1;
        pos = 0;
        String _tmpStr = "FBgValue";
        _tmpStr = view == 0 ? "FBgValue" : (view == 1 ? "FBgActual" : "FBizActual");
        StringBuffer sql = new StringBuffer();
        sql.append("select FOrgUnitId, FFormula, ").append(_tmpStr).append(" from T_BG_BgData where ");
        sql.append("(");
        for (Map.Entry _entry2222 : bgGatherMap.entrySet()) {
            _orgUnitId = (String)_entry2222.getKey();
            _bgSchemeId = (String)_entry2222.getValue();
            sql.append("(FOrgUnitId = ? and FBgSchemeId = ?) or ");
            _tmpList.add(_orgUnitId);
            _tmpList.add(_bgSchemeId);
        }
        sql.delete(sql.length() - 4, sql.length()).append(")");
        sql.append(" and FFormula in (");
        for (index = 1; index < batchSize; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        _tmpStr = sql.toString();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(_tmpStr);
            for (index = 0; index < count; ++index) {
                BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
                for (int x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(_tmpList.size() + x, (String)_formulaList.get(pos));
                        continue;
                    }
                    pstmt.setString(_tmpList.size() + x, "#");
                }
                try {
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _orgUnitId = rst.getString(1);
                        _formulaStr = rst.getString(2);
                        _value = rst.getBigDecimal(3);
                        _key = _orgUnitId + "_" + _formulaStr;
                        _queryMap.put(_key, _value);
                    }
                    continue;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            SQLUtils.cleanup((Statement)pstmt);
            if (hasTmpData && view == 0) {
                _tmpStr = _tmpStr.replaceAll("T_BG_BgData", "T_BG_BgTmpData");
                _tmpStr = _tmpStr.replaceAll("FBgValue", "FBgBalance");
                index = 0;
                size = _formulaList.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                pstmt = conn.prepareStatement(_tmpStr);
                for (index = 0; index < count; ++index) {
                    BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
                    for (int x = 1; x <= batchSize; ++x, ++pos) {
                        if (pos < size) {
                            pstmt.setString(_tmpList.size() + x, (String)_formulaList.get(pos));
                            continue;
                        }
                        pstmt.setString(_tmpList.size() + x, "#");
                    }
                    try {
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _orgUnitId = rst.getString(1);
                            _formulaStr = rst.getString(2);
                            _value = rst.getBigDecimal(3);
                            _key = _orgUnitId + "_" + _formulaStr;
                            if (_queryMap.containsKey(_key)) {
                                _tmpValue = (BigDecimal)_queryMap.get(_key);
                                _value = _value.add(_tmpValue);
                            }
                            _queryMap.put(_key, _value);
                        }
                        continue;
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return _queryMap;
    }

    private void clearBookFormula(Book book, boolean hasBudget, boolean hasAddActual) {
        if (book == null) {
            return;
        }
        Sheet _sheet = null;
        Cell _cell = null;
        String _expression = null;
        int count = book.getSheetCount();
        for (int index = 0; index < count; ++index) {
            _sheet = book.getSheet(index);
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_cell) || !BgNFSHelper.checkHasExpression((Cell)_cell) || BookFormulaHelper.isExcelFunction((Book)book, (Sheet)_sheet, (String)(_expression = BgNFSHelper.getExpression((Cell)_cell)))) continue;
                    if (hasBudget) {
                        BgNFSHelper.clearExpression((Cell)_cell, (int)0);
                    } else if (hasAddActual) {
                        BgNFSHelper.clearExpression((Cell)_cell, (int)2);
                    } else {
                        BgNFSHelper.clearExpression((Cell)_cell, (int)1);
                    }
                    if (_cell.getUserObjectValue("force_lock_org_longnumber") != null) continue;
                    BgNFSHelper.clearExpression((Cell)_cell);
                    BgNFSHelper.setCellLocked((Cell)_cell, (boolean)false);
                }
            }
        }
    }

    @Override
    protected Map _checkBatchGatherInfo(Context ctx, Object[] bgFormIds, Set orgUnitIds, Map parameter) throws BOSException, EASBizException {
        HashMap<String, Map> result = new HashMap<String, Map>();
        if (bgFormIds == null || bgFormIds.length == 0 || orgUnitIds == null || orgUnitIds.size() == 0 || parameter == null || parameter.size() == 0) {
            return result;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgFormCollection col = this.getBgForms(ctx, conn, bgFormIds);
            if (col == null || col.size() == 0) {
                HashMap<String, Map> hashMap = result;
                return hashMap;
            }
            for (int i = 0; i < col.size(); ++i) {
                BgFormInfo bgForm = col.get(i);
                Map subRes = this._checkGatherInfo(ctx, (IObjectValue)bgForm, orgUnitIds, parameter);
                result.put(bgForm.getId().toString(), subRes);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"_checkBatchGatherInfo:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BgFormCollection getBgForms(Context ctx, Connection conn, Object[] bgFormIds) throws SQLException {
        BgFormCollection col = new BgFormCollection();
        if (conn == null || bgFormIds == null || bgFormIds.length == 0) {
            return col;
        }
        PreparedStatement pmt = null;
        ResultSet res = null;
        try {
            StringBuffer sql = new StringBuffer("select bgForm.FID bgForm_FID,bgForm.FName bgForm_FName,bgForm.FNumber bgForm_FNumber,bgForm.FState bgForm_FState,bgForm.FControlUnitID bgForm_FControlUnitID,bgForm.FOrgUnitID bgForm_FOrgUnitID,bgForm.FBgSchemeID bgForm_FBgSchemeID,bgScheme.FRootID bgScheme_FRootID,bgForm.FBgTemplateID bgForm_FBgTemplateID,bgTemplate.FRootID bgTemplate_FRootID,bgForm.FCurrencyID bgForm_FCurrencyID,bgForm.FBgPeriodID bgForm_FBgPeriodID,bgForm.FAdjustID bgForm_FAdjustID FROM T_Bg_BgForm bgForm Left Join T_Bg_BgTemplate bgTemplate ON bgForm.FBgTemplateID = bgTemplate.FID Left Join T_Bg_BgScheme bgScheme ON bgForm.FBgSchemeID = bgScheme.FID WHERE bgForm.FID in(");
            BgNSQLHelper.addPlaceHolder((StringBuffer)sql, (int)200).append(")");
            pmt = conn.prepareStatement(sql.toString());
            int count = (bgFormIds.length - 1) / 200 + 1;
            for (int i = 0; i < count; ++i) {
                BgNSQLHelper.setParam4Batch((PreparedStatement)pmt, (int)i, (int)200, (Object[])bgFormIds);
                res = pmt.executeQuery();
                while (res.next()) {
                    BOSUuid id = this.getUuidByRes(res, "bgForm_FID");
                    if (id == null) continue;
                    BgFormInfo bgForm = new BgFormInfo();
                    bgForm.setId(id);
                    bgForm.setName(res.getString("bgForm_FName"));
                    bgForm.setNumber(res.getString("bgForm_FNumber"));
                    bgForm.setState(BgFormStateEnum.getEnum(res.getInt("bgForm_FState")));
                    id = this.getUuidByRes(res, "bgForm_FControlUnitID");
                    if (id != null) {
                        CtrlUnitInfo cu = new CtrlUnitInfo();
                        cu.setId(id);
                        bgForm.setCU(cu);
                    }
                    if ((id = this.getUuidByRes(res, "bgForm_FOrgUnitID")) != null) {
                        FullOrgUnitInfo org = new FullOrgUnitInfo();
                        org.setId(id);
                        bgForm.setOrgUnit(org);
                    }
                    if ((id = this.getUuidByRes(res, "bgForm_FBgTemplateID")) != null) {
                        BgTemplateInfo bgTemplate = new BgTemplateInfo();
                        bgTemplate.setId(id);
                        bgTemplate.setRootId(this.getUuidByRes(res, "bgTemplate_FRootID"));
                        bgForm.setBgTemplate(bgTemplate);
                    }
                    if ((id = this.getUuidByRes(res, "bgForm_FBgSchemeID")) != null) {
                        BgSchemeInfo bgScheme = new BgSchemeInfo();
                        bgScheme.setId(id);
                        bgScheme.setRootId(this.getUuidByRes(res, "bgScheme_FRootID"));
                        bgForm.setBgScheme(bgScheme);
                    }
                    if ((id = this.getUuidByRes(res, "bgForm_FCurrencyID")) != null) {
                        CurrencyInfo cy = new CurrencyInfo();
                        cy.setId(id);
                        bgForm.setCurrency(cy);
                    }
                    if ((id = this.getUuidByRes(res, "bgForm_FBgPeriodID")) != null) {
                        BgPeriodInfo bp = new BgPeriodInfo();
                        bp.setId(id);
                        bgForm.setBgPeriod(bp);
                    }
                    if ((id = this.getUuidByRes(res, "bgForm_FBgPeriodID")) != null) {
                        BgFormInfo adjust = new BgFormInfo();
                        adjust.setId(id);
                        bgForm.setAdjust(adjust);
                    }
                    col.add(bgForm);
                }
                SQLUtils.cleanup((ResultSet)res);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(res, pmt);
            throw throwable;
        }
        SQLUtils.cleanup(res, (Statement)pmt);
        return col;
    }

    private BOSUuid getUuidByRes(ResultSet res, String key) throws SQLException {
        String temString = res.getString(key);
        if (temString != null && !temString.trim().equals("")) {
            return BOSUuid.read((String)temString);
        }
        return null;
    }

    @Override
    protected String _gatherInfo4Batch(Context ctx, String bgFormId, Map orgUnitMap, Map bgSchemeIdsMap, Map bgFormIdsMap, Map parameter) throws BOSException, EASBizException {
        if (bgFormId == null || orgUnitMap == null || bgSchemeIdsMap == null || bgFormIdsMap == null || parameter == null) {
            return "paramError";
        }
        BgFormInfo model = (BgFormInfo)this._getGatherValue(ctx, (IObjectPK)new ObjectStringPK(bgFormId), orgUnitMap, bgSchemeIdsMap, bgFormIdsMap, parameter);
        if (model != null) {
            boolean isBudget = true;
            Object obj = parameter.get("GATHER_IS_BUDGET");
            if (obj instanceof Boolean) {
                isBudget = (Boolean)obj;
            }
            if (isBudget) {
                model.put("BGFORMINFO_TYPE", "BGFORM_BUDGET");
            } else {
                model.put("BGFORMINFO_TYPE", "BGFORM_ACTUAL");
            }
            BgFormFactory.getLocalInstance(ctx).save((CoreBaseInfo)model);
            return "success";
        }
        return "fail";
    }

    @Override
    protected Map _autoGather(Context ctx, String bgFormId, Set orgUnitSet, Map parameter) throws BOSException, EASBizException {
        HashMap<String, Object> autogatherresult = new HashMap<String, Object>();
        HashMap<String, Object> tmpresult = new HashMap<String, Object>();
        IPermission iPermisstion = PermissionFactory.getLocalInstance((Context)ctx);
        HashMap<String, String> failOrg = new HashMap<String, String>();
        IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
        if (ibgForm == null) {
            throw new BgFormException(BgFormException.NOINSTANCE);
        }
        BgFormInfo bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId), BgGatherFacadeControllerBean.getGatherSelectors());
        String orgId = bgFormInfo.getOrgUnit().getId().toString();
        HashMap orgNameMap = (HashMap)this._getAutoOrgName(ctx, orgUnitSet, orgId);
        autogatherresult.put("orgNameMap", orgNameMap);
        ArrayList orgSortList = (ArrayList)this._getOrgShowSort(ctx, orgUnitSet, orgId);
        autogatherresult.put("orgSortList", orgSortList);
        Map dealOrgMap = this._autoGatherChildMap(ctx, orgId, orgUnitSet);
        autogatherresult.put("dealOrgMap", dealOrgMap);
        String dealorgid = "";
        String dealformid = "";
        for (int i = 0; i < dealOrgMap.size(); ++i) {
            List list;
            HashMap dealorg;
            if (!dealOrgMap.containsKey(i + 1 + "") || (dealorg = (HashMap)dealOrgMap.get(i + 1 + "")).size() > 1 || dealorg.isEmpty()) continue;
            for (Map.Entry pairs : dealorg.entrySet()) {
                dealorgid = (String)pairs.getKey();
            }
            HashMap childs = (HashMap)dealorg.get(dealorgid);
            HashSet<String> child = new HashSet<String>();
            HashMap<String, String> _gatherCantMap = new HashMap<String, String>();
            for (Map.Entry pairs : childs.entrySet()) {
                if (!failOrg.containsKey((String)pairs.getKey())) {
                    child.add((String)pairs.getKey());
                    continue;
                }
                String cantorgname = (String)orgNameMap.get((String)pairs.getKey());
                if (StringUtils.isEmpty((String)cantorgname)) continue;
                cantorgname = cantorgname.replaceAll("--", "").trim();
                _gatherCantMap.put((String)pairs.getKey(), cantorgname);
            }
            try {
                iPermisstion.checkFunctionPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()), (IObjectPK)new ObjectUuidPK(dealorgid), "bg_form04_update");
            }
            catch (Exception ex) {
                failOrg.put(dealorgid, dealorgid);
                tmpresult = new HashMap();
                tmpresult.put("GATHER_CHECK_RESULT", Boolean.FALSE);
                tmpresult.put("errresource", "com.kingdee.eas.ma.budget.BgFormMsgResource");
                tmpresult.put("errmsg", "NoFormEditRight");
                autogatherresult.put(dealorgid, tmpresult);
                continue;
            }
            if (child.size() <= 0 || child.isEmpty()) {
                failOrg.put(dealorgid, dealorgid);
                tmpresult = new HashMap();
                tmpresult.put("GATHER_CHECK_RESULT", Boolean.FALSE);
                tmpresult.put("errresource", "com.kingdee.eas.ma.budget.BgFormMsgResource");
                tmpresult.put("errmsg", "noChildCanGather");
                tmpresult.put("GATHER_CHECK_CANT_ORGUNIT", _gatherCantMap);
                autogatherresult.put(dealorgid, tmpresult);
                continue;
            }
            boolean canGather = this._queryFormfromChildren(ctx, child, (IObjectValue)bgFormInfo);
            if (!canGather) {
                failOrg.put(dealorgid, dealorgid);
                for (String pairstmp : child) {
                    String cantorgname = (String)orgNameMap.get(pairstmp);
                    if (StringUtils.isEmpty((String)cantorgname)) continue;
                    cantorgname = cantorgname.replaceAll("--", "").trim();
                    _gatherCantMap.put(pairstmp, cantorgname);
                }
                tmpresult = new HashMap();
                tmpresult.put("GATHER_CHECK_RESULT", Boolean.FALSE);
                tmpresult.put("errresource", "com.kingdee.eas.ma.budget.BgFormMsgResource");
                tmpresult.put("errmsg", "childHasNotForm");
                tmpresult.put("GATHER_CHECK_CANT_ORGUNIT", _gatherCantMap);
                autogatherresult.put(dealorgid, tmpresult);
                continue;
            }
            String result = this._addBgFormToChildren(ctx, dealorgid, (IObjectValue)bgFormInfo);
            if (result.equals("-1") || result.equals("0") || result.equals("-2") || result.equals("-3")) {
                failOrg.put(dealorgid, dealorgid);
                tmpresult = new HashMap();
                tmpresult.put("GATHER_CHECK_RESULT", Boolean.FALSE);
                tmpresult.put("errresource", "com.kingdee.eas.ma.budget.BgFormMsgResource");
                if (result.equals("-1")) {
                    tmpresult.put("errmsg", "childFormError");
                }
                if (result.equals("0")) {
                    tmpresult.put("errmsg", "TemplateNotExists");
                }
                if (result.equals("-2")) {
                    tmpresult.put("errmsg", "NoFormAddRight");
                }
                if (result.equals("-3")) {
                    tmpresult.put("errmsg", "otherError");
                }
                autogatherresult.put(dealorgid, tmpresult);
                continue;
            }
            dealformid = result;
            if (this._getISInWorkFlow(ctx, dealformid)) {
                failOrg.put(dealorgid, dealorgid);
                tmpresult = new HashMap();
                tmpresult.put("GATHER_CHECK_RESULT", Boolean.FALSE);
                tmpresult.put("errresource", "com.kingdee.eas.ma.budget.BgFormMsgResource");
                tmpresult.put("errmsg", "NoFormEditRight");
                autogatherresult.put(dealorgid, tmpresult);
                continue;
            }
            if (BgSHelper.isBgSheetPermissionUsed() && ((list = BgFormFactory.getLocalInstance(ctx).getSheetName(dealformid)) == null || list.isEmpty())) {
                failOrg.put(dealorgid, dealorgid);
                tmpresult = new HashMap();
                tmpresult.put("GATHER_CHECK_RESULT", Boolean.FALSE);
                tmpresult.put("errresource", "com.kingdee.eas.ma.budget.BgFormMsgResource");
                tmpresult.put("errmsg", "FormHasNotPe");
                autogatherresult.put(dealorgid, tmpresult);
                continue;
            }
            Map gatherresult = this._checkGatherInfo(ctx, BOSUuid.read((String)dealformid), child, parameter);
            Object obj = null;
            Map _gatherOrgUnitMap = null;
            Map _gatherBgSchemeIdMap = null;
            Map _gatherBgFormIdsMap = null;
            Map _cantOrgMap = null;
            obj = gatherresult.get("GATHER_CHECK_ORGUNIT");
            if (obj != null && obj instanceof Map) {
                _gatherOrgUnitMap = obj;
            }
            if ((obj = gatherresult.get("GATHER_CHECK_BGSCHEME_ID")) != null && obj instanceof Map) {
                _gatherBgSchemeIdMap = obj;
            }
            if ((obj = gatherresult.get("GATHER_CHECK_BGFORM_ID")) != null && obj instanceof Map) {
                _gatherBgFormIdsMap = obj;
            }
            if ((obj = gatherresult.get("GATHER_CHECK_CANT_ORGUNIT")) != null && obj instanceof Map) {
                _cantOrgMap = obj;
            }
            if (Boolean.FALSE.equals(obj = gatherresult.get("GATHER_CHECK_RESULT"))) {
                autogatherresult.put(dealorgid, gatherresult);
                failOrg.put(dealorgid, dealorgid);
                if (_cantOrgMap != null && _cantOrgMap.size() > 0) continue;
                for (String pairstmp : child) {
                    String cantorgname = (String)orgNameMap.get(pairstmp);
                    cantorgname = cantorgname.replaceAll("--", "").trim();
                    if (_cantOrgMap == null) continue;
                    _cantOrgMap.put(pairstmp, cantorgname);
                }
                continue;
            }
            try {
                IObjectValue model = this._getGatherValue(ctx, (IObjectPK)new ObjectUuidPK(dealformid), _gatherOrgUnitMap, _gatherBgSchemeIdMap, _gatherBgFormIdsMap, parameter);
                Book _books = null;
                _books = ((BgFormInfo)model).getBook();
                this.dealBookInfo(_books);
                ((BgFormInfo)model).setBook(_books);
                BgFormFactory.getLocalInstance(ctx).submit(BOSUuid.read((String)dealformid), model, true);
                autogatherresult.put(dealorgid, gatherresult);
                continue;
            }
            catch (Exception ex) {
                failOrg.put(dealorgid, dealorgid);
                tmpresult = new HashMap();
                tmpresult.put("GATHER_CHECK_RESULT", Boolean.FALSE);
                tmpresult.put("errresource", "com.kingdee.eas.ma.budget.BgFormMsgResource");
                tmpresult.put("errmsg", "FormSaveFail");
                autogatherresult.put(dealorgid, tmpresult);
                logger.error((Object)ex.getMessage());
            }
        }
        return autogatherresult;
    }

    @Override
    protected Map _autoGatherChildMap(Context ctx, String orgId, Set orgUnitSet) throws BOSException, EASBizException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Connection conn = null;
        HashMap orgsort = new HashMap();
        HashMap<String, HashMap> orgbylevel = new HashMap<String, HashMap>();
        String lonNumber = "";
        StringBuffer sql = new StringBuffer();
        try {
            conn = this.getConnection(ctx);
            sql.append("select t.flongnumber from  T_ORG_CostCenter t  where t.fid= ?");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                lonNumber = rst.getString(1);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        if (lonNumber == null || lonNumber.equals("")) {
            // empty if block
        }
        ArrayList<String> _tmpList = new ArrayList<String>();
        sql = new StringBuffer();
        sql.append("select t.fid ,t.flongnumber,t.flevel from  T_ORG_CostCenter t  where t.flongnumber like ? and t.fid in (");
        _tmpList.add(lonNumber + "!%");
        for (String orgid : orgUnitSet) {
            sql.append("?,");
            _tmpList.add(orgid);
        }
        sql.delete(sql.length() - 1, sql.length()).append(")");
        sql.append(" order by  flevel desc, flongnumber desc ");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            int i = 0;
            while (rst.next()) {
                HashMap leveltmp;
                String orgtmp = rst.getString(1);
                String[] orginfo = new String[3];
                orginfo[0] = rst.getString(2);
                orginfo[1] = rst.getString(3);
                HashMap<String, String[]> tmp = new HashMap<String, String[]>();
                tmp.put(rst.getString(1), orginfo);
                orgsort.put(i + "", tmp);
                if (orgbylevel.containsKey(orginfo[1])) {
                    leveltmp = (HashMap)orgbylevel.get(orginfo[1]);
                    leveltmp.put(orgtmp, orginfo[0]);
                } else {
                    leveltmp = new HashMap();
                    leveltmp.put(orgtmp, orginfo[0]);
                    orgbylevel.put(orginfo[1], leveltmp);
                }
                ++i;
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        catch (SQLException ex) {
            logger.error((Object)ex.getMessage());
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        int dealbumber = 0;
        int maxdealbumber = 0;
        HashMap dealorg = new HashMap();
        HashMap<String, String> dealorgsort = new HashMap<String, String>();
        for (int i = 0; i < orgsort.size(); ++i) {
            HashMap levelorg;
            boolean pass = true;
            HashMap tmpOrgInfo = (HashMap)orgsort.get(i + "");
            Iterator iterorg = tmpOrgInfo.entrySet().iterator();
            Map.Entry pairs = iterorg.next();
            String child = (String)pairs.getKey();
            String[] childorgInfo = (String[])tmpOrgInfo.get(child);
            String childlevel = childorgInfo[1];
            String childlongnumber = childorgInfo[0];
            int maxlevel = Integer.parseInt(childlevel);
            block13: for (int j = maxlevel - 1; j >= 0 && pass && (levelorg = (HashMap)orgbylevel.get(j + "")) != null && !levelorg.isEmpty(); --j) {
                for (Map.Entry levelpairs : levelorg.entrySet()) {
                    String parentorg = (String)levelpairs.getKey();
                    String longlevel = (String)levelpairs.getValue();
                    if (childlongnumber.indexOf(longlevel + "!") != 0) continue;
                    if (!dealorgsort.containsKey(parentorg)) {
                        dealbumber = ++maxdealbumber;
                        dealorgsort.put(parentorg, dealbumber + "");
                    } else {
                        dealbumber = Integer.parseInt((String)dealorgsort.get(parentorg));
                    }
                    if (dealorg.containsKey(dealbumber + "")) {
                        HashMap parentmap = (HashMap)dealorg.get(dealbumber + "");
                        HashMap childmap = (HashMap)parentmap.get(parentorg);
                        childmap.put(child, child);
                    } else {
                        HashMap<String, String> childmap = new HashMap<String, String>();
                        childmap.put(child, child);
                        HashMap<String, HashMap<String, String>> parentmap = new HashMap<String, HashMap<String, String>>();
                        parentmap.put(parentorg, childmap);
                        dealorg.put(dealbumber + "", parentmap);
                    }
                    pass = false;
                    continue block13;
                }
            }
            if (!pass) continue;
            if (!dealorgsort.containsKey(orgId)) {
                dealbumber = ++maxdealbumber;
                dealorgsort.put(orgId, dealbumber + "");
            } else {
                dealbumber = Integer.parseInt((String)dealorgsort.get(orgId));
            }
            if (dealorg.containsKey(dealbumber + "")) {
                HashMap parentmap = (HashMap)dealorg.get(dealbumber + "");
                HashMap childmap = (HashMap)parentmap.get(orgId);
                childmap.put(child, child);
                continue;
            }
            HashMap<String, String> childmap = new HashMap<String, String>();
            childmap.put(child, child);
            HashMap<String, HashMap<String, String>> parentmap = new HashMap<String, HashMap<String, String>>();
            parentmap.put(orgId, childmap);
            dealorg.put(dealbumber + "", parentmap);
        }
        return dealorg;
    }

    protected String _addBgFormToChildren(Context ctx, String orgUnitId, IObjectValue formInfo) throws BOSException, EASBizException {
        String Id = "";
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        IBgTemplate iBgTemplate = BgTemplateFactory.getLocalInstance(ctx);
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        if (formInfo == null || orgUnitId == null) {
            return "-1";
        }
        String templateRootId = ((BgFormInfo)formInfo).getBgTemplate().getRootId().toString();
        String schemeRootId = ((BgFormInfo)formInfo).getBgScheme().getRootId().toString();
        AbstractBgFormInfo info = null;
        int n = 1;
        info = null;
        try {
            BigDecimal version = new BigDecimal(0);
            BgFormCollection col = iBgForm.getBgFormCollection("where bgTemplate.rootId = '" + templateRootId + "' and bgScheme.rootId = '" + schemeRootId + "' and orgUnit = '" + orgUnitId + "' and bgPeriod = '" + ((BgFormInfo)formInfo).getBgPeriod().getId().toString() + "'  and currency.id = '" + ((BgFormInfo)formInfo).getCurrency().getId().toString() + "'");
            if (col != null) {
                for (int i = 0; i < col.size(); ++i) {
                    if (version.compareTo(col.get(i).getVersionNo()) > 0) continue;
                    version = col.get(i).getVersionNo();
                    info = col.get(i);
                }
            }
            if (info != null) {
                if (info.getState().equals((Object)BgFormStateEnum.Edited)) {
                    return info.getId().toString();
                }
                return "-1";
            }
            IPermission iPermisstion = PermissionFactory.getLocalInstance((Context)ctx);
            iPermisstion.checkFunctionPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()), (IObjectPK)new ObjectUuidPK(orgUnitId), "bg_form02_addNew");
            BgTemplateInfo bgTemplateInfo = null;
            BgTemplateCollection templateCol = iBgTemplate.getBgTemplateCollection("where rootId = '" + templateRootId + "' and orgUnit = '" + orgUnitId + "' order by createTime ");
            if (templateCol.size() <= 0) {
                return "0";
            }
            bgTemplateInfo = templateCol.get(0);
            BgSchemeInfo bgSchemeInfo = iBgScheme.getBgSchemeInfo("where rootId = '" + schemeRootId + "' and orgUnit = '" + orgUnitId + "'");
            BgFormInfo bgFormInfo = new BgFormInfo();
            bgFormInfo.setId(BOSUuid.create((BOSObjectType)bgFormInfo.getBOSType()));
            bgFormInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            bgFormInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
            bgFormInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            bgFormInfo.setAdjust(bgFormInfo);
            bgFormInfo.setVersionNo(BgConstants.ONE);
            bgFormInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
            bgFormInfo.setState(BgFormStateEnum.Edited);
            bgFormInfo.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
            bgFormInfo.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
            bgFormInfo.setDataSource(BgFormDataSourceEnum.FORMCOLLECT);
            bgFormInfo.setSourceType(RptSrcTypeEnum.BGFORMREPORT);
            BgHelper.initNumber((CoreBaseInfo)bgFormInfo, bgFormInfo.getCU().getId().toString(), ctx);
            if (bgFormInfo.getNumber() == null || bgFormInfo.getNumber().equals("")) {
                bgFormInfo.setNumber(((BgFormInfo)formInfo).getNumber() + "_" + n);
                ++n;
            }
            bgFormInfo.setStartDate(new Date());
            bgFormInfo.setEndDate(bgFormInfo.getStartDate());
            bgFormInfo.setBgTemplate(bgTemplateInfo);
            bgFormInfo.setBgScheme(bgSchemeInfo);
            FullOrgUnitInfo fullOrgUnit = new FullOrgUnitInfo();
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            fullOrgUnit = iFullOrgUnit.getFullOrgUnitInfo("where id = '" + bgTemplateInfo.getOrgUnit().getId().toString() + "'");
            bgFormInfo.setOrgUnit(fullOrgUnit);
            bgFormInfo.setBgPeriod(((BgFormInfo)formInfo).getBgPeriod());
            bgFormInfo.setCurrency(((BgFormInfo)formInfo).getCurrency());
            bgFormInfo.setBgType(bgTemplateInfo.getBgType());
            String bgFormName = null;
            if (bgFormInfo.getCU().getName() != null) {
                bgFormName = bgFormInfo.getCU().getId().toString().equals(bgFormInfo.getOrgUnit().getId().toString()) ? bgFormInfo.getCU().getName().trim() + "_" + bgFormInfo.getBgPeriod().getName().trim() + "_" + bgFormInfo.getBgTemplate().getName().trim() : bgFormInfo.getCU().getName().trim() + "_" + bgFormInfo.getOrgUnit().getName().trim() + "_" + bgFormInfo.getBgPeriod().getName().trim() + "_" + bgFormInfo.getBgTemplate().getName().trim();
            }
            bgFormInfo.setName(bgFormName != null && bgFormName.length() > 80 ? bgFormName.substring(1, 80) : bgFormName);
            bgFormInfo.setMeasureUnit(bgTemplateInfo.getDefaultMeasureUnit());
            iBgForm.submit(bgFormInfo.getId(), (IObjectValue)bgFormInfo, true);
            Id = bgFormInfo.getId().toString();
            return Id;
        }
        catch (Exception ex) {
            return "-2";
        }
    }

    protected boolean _queryFormfromChildren(Context ctx, Set orgUnitIds, IObjectValue formInfo) throws BOSException, EASBizException {
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        if (formInfo == null || orgUnitIds == null || orgUnitIds.size() <= 0) {
            return false;
        }
        String templateRootId = ((BgFormInfo)formInfo).getBgTemplate().getRootId().toString();
        String schemeRootId = ((BgFormInfo)formInfo).getBgScheme().getRootId().toString();
        BgFormCollection col = null;
        col = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("where bgTemplate.rootId = '").append(templateRootId).append("' and bgScheme.rootId = '").append(schemeRootId).append("' and bgPeriod = '").append(((BgFormInfo)formInfo).getBgPeriod().getId().toString()).append("'  and currency.id = '").append(((BgFormInfo)formInfo).getCurrency().getId().toString()).append("' and orgUnit in (");
            for (String orgid : orgUnitIds) {
                sql.append("'" + orgid + "', ");
            }
            sql.delete(sql.length() - 2, sql.length()).append(")");
            col = iBgForm.getBgFormCollection(sql.toString());
            if (col != null && col.size() > 0) {
                return true;
            }
        }
        catch (BOSException ex) {
            return false;
        }
        return false;
    }

    public static SelectorItemCollection getGatherSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        sic.add("CU.id");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.rootId");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.rootId");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.number");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.periodType");
        sic.add("adjust.id");
        return sic;
    }

    public void dealBookInfo(Book _book) throws BOSException, EASBizException {
        Sheet sheet = null;
        int count = _book.getSheetCount();
        for (int i = 0; i < count; ++i) {
            sheet = _book.getSheet(i);
            int rowIndex = 0;
            int colIndex = 0;
            int rowCount = sheet.getMaxRowIndex();
            int colCount = sheet.getMaxColIndex();
            Cell _cell = null;
            BigDecimal _value = null;
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = sheet.getCell(rowIndex, colIndex, true);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)_cell)) continue;
                    if (!BgNFSHelper.checkIsEmptyValue((Cell)_cell)) {
                        try {
                            _value = _cell.getValue().toBigDecimal();
                        }
                        catch (Exception ex) {
                            logger.error((Object)ex);
                            _value = BgNConstants.ZERO;
                        }
                    } else {
                        _value = BgNConstants.ZERO;
                    }
                    BgNFSHelper.setBudgetValue((Cell)_cell, (BigDecimal)_value);
                }
            }
        }
    }

    protected Map _getAutoOrgName(Context ctx, Set orgUnitSet, String orgId) throws BOSException, EASBizException {
        Object orgID;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Connection conn = null;
        HashMap<Object, String> orgsort = new HashMap<Object, String>();
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        conn = this.getConnection(ctx);
        sql.append("select t.fid ,t.flevel,t.fname_").append(ctx.getLocale()).append(" from  T_ORG_CostCenter t  where t.fid in (");
        sql.append("?, ");
        _tmpList.add(orgId);
        for (String orgid : orgUnitSet) {
            sql.append("?,");
            _tmpList.add(orgid);
        }
        sql.delete(sql.length() - 1, sql.length()).append(")");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                orgID = rst.getString(1);
                String orgName = rst.getString(3);
                int level = rst.getInt(2);
                StringBuffer tmp = new StringBuffer();
                for (int j = 0; j < level; ++j) {
                    if (j == level - 1) {
                        tmp.append("--");
                        continue;
                    }
                    tmp.append("   ");
                }
                orgName = tmp.toString() + orgName;
                orgsort.put(orgID, orgName);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            orgID = orgsort;
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return orgID;
    }

    protected List _getOrgShowSort(Context ctx, Set orgUnitSet, String orgId) throws BOSException, EASBizException {
        Object orgID;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Connection conn = null;
        ArrayList<String> orgsort = new ArrayList<String>();
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        conn = this.getConnection(ctx);
        sql.append("select t.fid ,t.fname_").append(ctx.getLocale()).append(" from  T_ORG_CostCenter t  where  t.fid in (");
        sql.append("?, ");
        _tmpList.add(orgId);
        for (String orgid : orgUnitSet) {
            sql.append("?,");
            _tmpList.add(orgid);
        }
        sql.delete(sql.length() - 1, sql.length()).append(")");
        sql.append(" order by  flongnumber ");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                orgID = rst.getString(1);
                orgsort.add((String)orgID);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            orgID = orgsort;
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return orgID;
    }

    protected boolean _getISInWorkFlow(Context ctx, String bgformid) throws BOSException, EASBizException {
        boolean inProInst = false;
        ProcessInstInfo[] procInsts = EnactmentServiceFactory.createEnactService((Context)ctx).getProcessInstanceByHoldedObjectId(bgformid);
        for (int i = 0; i < procInsts.length; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            inProInst = true;
            break;
        }
        return inProInst;
    }

    @Override
    protected Map _getGatherValueForView(Context ctx, IObjectPK formId, Map bgSchemeIdsMap, Map bgFormIdsMap, Map parameter, IBgDimensionManager dimensionManager, Map extMap) throws BOSException, EASBizException {
        IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
        BgFormInfo bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(formId.toString()), BgNFSHelper.getSelectors());
        List _orgUnitSort = null;
        List _orgUnitIds = null;
        HashSet formulaSet = new HashSet();
        Set bgElementSet = null;
        Object _obj = null;
        Map valueMap = null;
        HashMap<String, String> bgAdjustIdsMap = new HashMap<String, String>();
        ArrayList<Object> allFormIds = new ArrayList<Object>();
        boolean hasGatherTmpData = (Boolean)parameter.get("GATHER_TMPDATA");
        boolean hasBudget = (Boolean)parameter.get("GATHER_TYPE");
        boolean hasGatherAddActual = false;
        boolean hasGatherPeriod = false;
        String gatherPeriodId = null;
        _obj = parameter.get("GATHER_TYPE_EXT");
        if (_obj != null && "GATHER_ADD_ACTUAL".equals(_obj)) {
            hasGatherAddActual = true;
        }
        if ((_obj = (Object)parameter.get("GATHER_PERIOD")) instanceof Boolean) {
            hasGatherPeriod = (Boolean)_obj;
        }
        if ((_obj = (Object)parameter.get("GATHER_PERIOD_ID")) != null) {
            gatherPeriodId = _obj.toString();
        }
        if ((_obj = parameter.get("GATHER_SORT")) != null && _obj instanceof List) {
            _orgUnitSort = (List)_obj;
        }
        _obj = parameter.get("GATHER_CLEAR_FORMULA");
        _orgUnitIds = this.getOrgUnitIdsBySort(bgFormIdsMap, _orgUnitSort);
        if (dimensionManager == null) {
            IBudgetView view = BudgetViewLoaderImpl.getIntance();
            dimensionManager = new BgDimensionManagerImpl();
            try {
                view.load(dimensionManager, bgFormInfo.getEntries().get(0).getDimensionData());
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.NODATA, e);
            }
        }
        allFormIds.addAll(bgFormIdsMap.values());
        if (hasGatherTmpData) {
            Map resultMap = BgFormFacadeFactory.getLocalInstance(ctx).queryBgFormByOrgUnitId(bgFormInfo, bgFormIdsMap.keySet().toArray());
            BgFormInfo curFormInfo = null;
            for (Object o : resultMap.keySet()) {
                curFormInfo = (BgFormInfo)resultMap.get(o);
                if (curFormInfo.getState().getValue() != 35 && curFormInfo.getState().getValue() != 4 && curFormInfo.getState().getValue() != 6 && curFormInfo.getState().getValue() != 101) continue;
                bgAdjustIdsMap.put(curFormInfo.getOrgUnit().getId().toString(), curFormInfo.getId().toString());
                allFormIds.add(curFormInfo.getId().toString());
            }
        }
        if (!hasGatherAddActual) {
            this.findAllMembers(ctx, dimensionManager.getRowDimension(), allFormIds, bgFormInfo.getOrgUnit().getId().toString());
        }
        this.findAllFormula(ctx, formulaSet, dimensionManager, bgFormInfo);
        bgElementSet = this.getCantGatherBgElement(ctx);
        if (hasGatherAddActual) {
            if (extMap == null) {
                extMap = new HashMap<String, Boolean>();
            }
            extMap.put("GATHER_ADD_ACTUAL", hasGatherAddActual);
            extMap.put("GATHER_PERIOD", hasGatherPeriod);
            extMap.put("GATHER_PERIOD_ID", (Boolean)((Object)gatherPeriodId));
        }
        this.filterFormulaSetForView(ctx, formulaSet, bgFormInfo, bgElementSet, extMap);
        valueMap = this.gatherOfFormula(ctx, bgSchemeIdsMap, formulaSet, hasBudget && !hasGatherAddActual, hasGatherTmpData, hasGatherAddActual, parameter);
        this.saveGatherAttachment(ctx, bgFormInfo, bgSchemeIdsMap, bgFormIdsMap, true);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("RowDimension", dimensionManager.getRowDimension());
        returnMap.put("value", valueMap);
        return returnMap;
    }

    private void filterFormulaSetForView(Context ctx, Set formulaSet, BgFormInfo currentForm, Set bgElementSet, Map extMap) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String noFindStr = "#";
        try {
            int formStateValue;
            boolean isEditValue;
            boolean hasGatherAddActual = false;
            boolean hasGatherPeriod = false;
            String gatherPeriodId = null;
            if (extMap != null) {
                hasGatherAddActual = extMap.get("GATHER_ADD_ACTUAL") instanceof Boolean ? (Boolean)extMap.get("GATHER_ADD_ACTUAL") : false;
                hasGatherPeriod = extMap.get("GATHER_PERIOD") instanceof Boolean ? (Boolean)extMap.get("GATHER_PERIOD") : false;
                gatherPeriodId = extMap.get("GATHER_PERIOD_ID") != null ? extMap.get("GATHER_PERIOD_ID").toString() : null;
            }
            boolean bl = isEditValue = (formStateValue = currentForm.getState().getValue()) == 1 || formStateValue == 102 || formStateValue == 103;
            if (isEditValue || formStateValue == 35 || formStateValue == 4 || hasGatherAddActual) {
                StringBuffer filterUnEditableSql = new StringBuffer();
                filterUnEditableSql = isEditValue ? new StringBuffer("select FFormula FROM T_BG_bgData where FDataState != 1 and FOrgUnitId = ? and FBgSchemeId = ? and FFormula in (") : new StringBuffer("select FFormula FROM T_BG_bgData where FDataState != 9 and FOrgUnitId = ? and FBgSchemeId = ? and FFormula in (");
                BgNSQLHelper.addPlaceHolder((StringBuffer)filterUnEditableSql, (int)200).append(")");
                pstmt = conn.prepareStatement(filterUnEditableSql.toString());
                int batchCount = (formulaSet.size() - 1) / 200 + 1;
                HashSet<String> delFormulaSet = new HashSet<String>();
                for (int i = 0; i < batchCount; ++i) {
                    pstmt.setString(1, currentForm.getOrgUnit().getId().toString());
                    pstmt.setString(2, currentForm.getBgScheme().getId().toString());
                    BgNSQLHelper.setParam4Batch((PreparedStatement)pstmt, (int)3, (int)i, (int)200, (Object[])formulaSet.toArray());
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        delFormulaSet.add(rst.getString("FFormula"));
                    }
                }
                if (delFormulaSet.size() > 0) {
                    formulaSet.removeAll(delFormulaSet);
                }
            }
            Set legalPeriodSet = new HashSet<String>();
            boolean checkPeriod = false;
            if (extMap != null && extMap.get("legalPeriod") != null) {
                legalPeriodSet = (Set)extMap.get("legalPeriod");
                checkPeriod = true;
            }
            if (hasGatherAddActual && hasGatherPeriod) {
                legalPeriodSet.add(BgPeriodFactory.getLocalInstance(ctx).getBgPeriodInfo((IObjectPK)new ObjectUuidPK(gatherPeriodId)).getNumber());
            }
            String formula = "";
            String[] parameter = null;
            Iterator iterator = formulaSet.iterator();
            while (iterator.hasNext()) {
                formula = (String)iterator.next();
                parameter = BgNFSHelper.parseFormulaPara((String)formula);
                if (bgElementSet.contains(parameter[2])) {
                    iterator.remove();
                    continue;
                }
                if (checkPeriod && !legalPeriodSet.contains(parameter[1])) {
                    iterator.remove();
                    continue;
                }
                if (!hasGatherAddActual || !hasGatherPeriod || legalPeriodSet.contains(parameter[1])) continue;
                iterator.remove();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BgFormException(BgFormException.DATABASEERROR, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
    }
}

