/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemEfficacyException;
import com.kingdee.eas.ma.budget.BgItemEntryInfo;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.app.AbstractBgItemEntryControllerBean;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgItemEntryControllerBean
extends AbstractBgItemEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgItemEntryControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _addNew(Context ctx, BOSUuid orgUnitId, Map bgItemIds) throws BOSException, EASBizException {
        if (orgUnitId == null) return;
        if (bgItemIds == null) return;
        if (bgItemIds.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Object orgUnitIdSet = null;
        HashMap<String, String> bgItemNumberMap = new HashMap<String, String>();
        Map orgUnitMap = null;
        BOSUuid subOrgUnitId = null;
        String _fid2222222 = null;
        String _number = null;
        String _orgUnitId2222222 = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FNumber from T_BG_BgItem where FID IN (");
        Iterator iter = bgItemIds.keySet().iterator();
        while (iter.hasNext()) {
            sql.append("?,");
            _tmpList.add(iter.next().toString());
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(")");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgItemNumberMap.put(rst.getString(1), rst.getString(2));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!bgItemNumberMap.isEmpty()) {
                IObjectValue obj = null;
                BgItemEntryInfo _bgItemEntryInfo = null;
                for (String _fid2222222 : bgItemNumberMap.keySet()) {
                    _number = (String)bgItemNumberMap.get(_fid2222222);
                    try {
                        obj = this._getValue(ctx, orgUnitId, _number);
                        if (obj == null || !(obj instanceof BgItemEntryInfo)) continue;
                        _bgItemEntryInfo = (BgItemEntryInfo)obj;
                        if (!bgItemIds.containsKey(_fid2222222) || (orgUnitMap = (Map)bgItemIds.get(_fid2222222)) == null) continue;
                        for (String _orgUnitId2222222 : orgUnitMap.keySet()) {
                            subOrgUnitId = BOSUuid.read((String)_orgUnitId2222222);
                            if (this._checkCanUse(ctx, subOrgUnitId, _number)) continue;
                            this.AssignBgItemEntry(ctx, conn, subOrgUnitId, _bgItemEntryInfo);
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                }
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void AssignBgItemEntry(Context ctx, Connection conn, BOSUuid orgUnitId, BgItemEntryInfo bgItemEntryInfo) throws BOSException, EASBizException {
        if (ctx == null || conn == null || bgItemEntryInfo == null) {
            return;
        }
        BgItemInfo _bgItemInfo = new BgItemInfo();
        _bgItemInfo.setId(bgItemEntryInfo.getBgItem().getId());
        _bgItemInfo.setName(bgItemEntryInfo.getName());
        _bgItemInfo.setNumber(bgItemEntryInfo.getNumber());
        _bgItemInfo.setLongNumber(bgItemEntryInfo.getLongnumber());
        _bgItemInfo.setSpecialNumber(bgItemEntryInfo.getSpecialNumber());
        _bgItemInfo.setRefField(bgItemEntryInfo.getRefField());
        _bgItemInfo.setLevel(bgItemEntryInfo.getLevel());
        _bgItemInfo.setIsEffective(bgItemEntryInfo.isIsEffective());
        _bgItemInfo.setIsLeaf(bgItemEntryInfo.isIsLeaf());
        FullOrgUnitInfo _fullOrgUnitInfo = new FullOrgUnitInfo();
        _fullOrgUnitInfo.setId(orgUnitId);
        _bgItemInfo.setOrgUnit(_fullOrgUnitInfo);
        BgItemGroupInfo _bgItemGroupInfo = new BgItemGroupInfo();
        _bgItemGroupInfo.setId(BOSUuid.read((String)bgItemEntryInfo.getBgItemGroupId()));
        _bgItemGroupInfo.setRefField(_bgItemInfo.getRefField());
        _bgItemInfo.setBgItemGroup(_bgItemGroupInfo);
        BgItemInfo _parentInfo = new BgItemInfo();
        _parentInfo.setId(BOSUuid.read((String)bgItemEntryInfo.getBgItemParentId()));
        _bgItemInfo.setParent(_parentInfo);
        IBgItem ibgItem = BgItemFactory.getLocalInstance(ctx);
        ibgItem.addnew((CoreBaseInfo)_bgItemInfo);
    }

    @Override
    protected boolean _checkCanUse(Context ctx, BOSUuid orgUnitId, String number) throws BOSException, EASBizException {
        Map _tmpMap = this._getCanUse(ctx, orgUnitId, number);
        return _tmpMap != null && !_tmpMap.isEmpty();
    }

    @Override
    protected Map _getCanUse(Context ctx, BOSUuid orgUnitId, String number) throws BOSException, EASBizException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (orgUnitId == null || StringUtils.isEmpty((String)number)) {
            return resultMap;
        }
        Set orgUnitIdSet = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _fid = null;
        String _tmpStr = null;
        StringBuffer query = new StringBuffer();
        try {
            conn = this.getConnection(ctx);
            orgUnitIdSet = this.getOrgUnitIds(conn, orgUnitId);
            if (orgUnitIdSet != null && !orgUnitIdSet.isEmpty()) {
                query.append("select FID, FCurOrgUnitId from T_BG_BgItemEntry where FNumber = ? and FCurOrgUnitId IN (");
                for (int i = 1; i < 100; ++i) {
                    query.append("?,");
                }
                query.append("?)");
                int index = 0;
                int batchNum = 100;
                int size = orgUnitIdSet.size();
                int count = (size - 1) / batchNum + 1;
                int pos = 0;
                ArrayList tmpList = new ArrayList();
                tmpList.addAll(orgUnitIdSet);
                pstmt = conn.prepareStatement(query.toString());
                for (index = 0; index < count; ++index) {
                    pstmt.setString(1, number);
                    int k = 1;
                    while (k <= batchNum) {
                        if (pos < size) {
                            pstmt.setString(k + 1, (String)tmpList.get(pos));
                        } else {
                            pstmt.setString(k + 1, "#");
                        }
                        ++k;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _fid = rst.getString(1);
                        _tmpStr = rst.getString(2);
                        resultMap.put(_fid, _tmpStr);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return resultMap;
    }

    @Override
    protected boolean _checkCanUse(Context ctx, BOSUuid orgUnitId, List number) throws BOSException, EASBizException {
        Map _tmpMap = this._getCanUse(ctx, orgUnitId, number);
        return _tmpMap != null && !_tmpMap.isEmpty();
    }

    @Override
    protected Map _getCanUse(Context ctx, BOSUuid orgUnitId, List number) throws BOSException, EASBizException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (orgUnitId == null || number == null || number.isEmpty()) {
            return resultMap;
        }
        Set orgUnitIdSet = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _fid = null;
        Object _number = null;
        String _tmpStr = null;
        StringBuffer query = new StringBuffer();
        try {
            conn = this.getConnection(ctx);
            orgUnitIdSet = this.getOrgUnitIds(conn, orgUnitId);
            if (orgUnitIdSet != null && !orgUnitIdSet.isEmpty()) {
                String[] numberArray = number.toArray(new String[0]);
                String[] orgIdArray = orgUnitIdSet.toArray(new String[0]);
                query.append("select FID, FCurOrgUnitId from T_BG_BgItemEntry where FNumber IN ");
                query.append(BgHelper.tranArray2String4Pre(numberArray));
                query.append(" and FCurOrgUnitId IN ");
                query.append(BgHelper.tranArray2String4Pre(orgIdArray));
                pstmt = conn.prepareStatement(query.toString());
                BgHelper.setParamString4Pre(0, numberArray, pstmt);
                BgHelper.setParamString4Pre(numberArray.length, orgIdArray, pstmt);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _fid = rst.getString(1);
                    _tmpStr = rst.getString(2);
                    resultMap.put(_fid, _tmpStr);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return resultMap;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, BOSUuid orgUnitId, String number) throws BOSException, EASBizException {
        if (orgUnitId == null || StringUtils.isEmpty((String)number)) {
            return null;
        }
        BgItemEntryInfo _bgItemEntryInfo = null;
        Set orgUnitIdSet = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _number2 = null;
        StringBuffer query = new StringBuffer();
        Locale locale_L1 = LocaleUtils.getLocale((String)"L1");
        Locale locale_L2 = LocaleUtils.getLocale((String)"L2");
        Locale locale_L3 = LocaleUtils.getLocale((String)"L3");
        try {
            conn = this.getConnection(ctx);
            orgUnitIdSet = this.getOrgUnitIds(conn, orgUnitId);
            if (orgUnitIdSet != null && !orgUnitIdSet.isEmpty()) {
                ArrayList<String> _tmpList = new ArrayList<String>();
                query.append("select * from T_BG_BgItemEntry where FNumber = ? and FCurOrgUnitId IN (");
                _tmpList.add(number);
                for (String _number2 : orgUnitIdSet) {
                    query.append("?,");
                    _tmpList.add(_number2);
                }
                query.delete(query.length() - 1, query.length());
                query.append(")");
                pstmt = conn.prepareStatement(query.toString());
                BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    _bgItemEntryInfo = new BgItemEntryInfo();
                    _bgItemEntryInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                    BgItemInfo _bgItemInfo = new BgItemInfo();
                    _bgItemInfo.setId(BOSUuid.read((String)rst.getString("FBgItemID")));
                    _bgItemEntryInfo.setBgItem(_bgItemInfo);
                    _bgItemEntryInfo.setName(rst.getString("FName_L1"), locale_L1);
                    _bgItemEntryInfo.setName(rst.getString("FName_L2"), locale_L2);
                    _bgItemEntryInfo.setName(rst.getString("FName_L3"), locale_L3);
                    _bgItemEntryInfo.setNumber(rst.getString("FNumber"));
                    _bgItemEntryInfo.setLongnumber(rst.getString("FLongnumber"));
                    _bgItemEntryInfo.setSpecialNumber(rst.getString("FSpecialNumber"));
                    _bgItemEntryInfo.setLevel(rst.getInt("FLevel"));
                    _bgItemEntryInfo.setIsEffective(rst.getBoolean("FIsEffective"));
                    _bgItemEntryInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                    _bgItemEntryInfo.setRefField(rst.getString("FRefField"));
                    _bgItemEntryInfo.setBgItemGroupId(rst.getString("FBgItemGroupId"));
                    _bgItemEntryInfo.setBgItemParentId(rst.getString("FBgItemParentId"));
                    _bgItemEntryInfo.setCurOrgUnitId(rst.getString("FCurOrgUnitId"));
                    _bgItemEntryInfo.setCurOrgUnitNumber(rst.getString("FCurOrgUnitNumber"));
                    _bgItemEntryInfo.setCurOrgUnitLongnumber(rst.getString("FCurOrgUnitLongnumber"));
                    _bgItemEntryInfo.setCurOrgUnitName(rst.getString("FCurOrgUnitName_l1"), locale_L1);
                    _bgItemEntryInfo.setCurOrgUnitName(rst.getString("FCurOrgUnitName_l2"), locale_L2);
                    _bgItemEntryInfo.setCurOrgUnitName(rst.getString("FCurOrgUnitName_l3"), locale_L3);
                    _bgItemEntryInfo.setSouOrgUnitId(rst.getString("FSouOrgUnitId"));
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return _bgItemEntryInfo;
    }

    protected Set getOrgUnitIds(Connection conn, BOSUuid orgUnitId) throws EASBizException {
        HashSet<String> orgUnitIdSet = new HashSet<String>();
        if (conn == null || orgUnitId == null) {
            return orgUnitIdSet;
        }
        String[] numberStr = null;
        String _number = null;
        String _longnumber = null;
        String _orgUnitId = null;
        StringBuffer query = new StringBuffer();
        _orgUnitId = orgUnitId.toString();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement("select FNumber, FLongNumber from T_ORG_CostCenter where FID = ?");
            pstmt.setString(1, _orgUnitId);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                _number = rst.getString(1);
                _longnumber = rst.getString(2);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!StringUtils.isEmpty((String)_number) && !StringUtils.isEmpty((String)_number)) {
                ArrayList<String> _tmpList = new ArrayList<String>();
                query.append("select FID from T_ORG_CostCenter where ");
                orgUnitIdSet = new HashSet();
                if (_longnumber != null) {
                    numberStr = _longnumber.split("\\!");
                    if (numberStr != null) {
                        query.append(" FNumber IN (");
                        int in = numberStr.length;
                        for (int i = 0; i < in; ++i) {
                            query.append("?,");
                            _tmpList.add(numberStr[i]);
                        }
                        query.delete(query.length() - 1, query.length());
                        query.append(") or ");
                    }
                    query.append("FLongNumber like ?");
                    _tmpList.add(_longnumber + "!%");
                }
                pstmt = conn.prepareStatement(query.toString());
                BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    orgUnitIdSet.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return orgUnitIdSet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _checkData(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstup = null;
        ResultSet rst = null;
        HashSet<String> refFieldSet = new HashSet<String>();
        HashMap<String, String> entryMap = new HashMap<String, String>();
        String _fid = null;
        String _longnumber = null;
        String _parentId = null;
        String _parentLongnumber = null;
        int batchSize = 200;
        int batchIndex = 0;
        int _level = 0;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FReffield from T_BG_BgItemGroup");
            pstup = conn.prepareStatement("update T_BG_BgItemEntry set FParentId = ? where FID = ?");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                refFieldSet.add(rst.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!refFieldSet.isEmpty()) {
                pstmt = conn.prepareStatement("select FID, FLongNumber, FLevel from T_BG_BgItemEntry where FRefField = ? order by FLongNumber");
                Iterator iter = refFieldSet.iterator();
                while (iter.hasNext()) {
                    pstmt.setString(1, iter.next().toString());
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _fid = rst.getString(1);
                        _longnumber = rst.getString(2);
                        _level = rst.getInt(3);
                        entryMap.put(_longnumber, _fid);
                        if (_level <= 1 || !entryMap.containsKey(_parentLongnumber = _longnumber.substring(0, _longnumber.lastIndexOf("!")))) continue;
                        _parentId = (String)entryMap.get(_parentLongnumber);
                        pstup.setString(1, _parentId);
                        pstup.setString(2, _fid);
                        pstup.addBatch();
                        if (++batchIndex < batchSize) continue;
                        pstup.executeBatch();
                        batchIndex = 0;
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    if (batchIndex == 0) continue;
                    pstup.executeBatch();
                    batchIndex = 0;
                }
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstup);
                SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstup);
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _updateItemOrg(Context ctx, int levelNum, Map changeLevel, Map changeItem) throws BOSException, EASBizException {
        String msg = "";
        ArrayList itemNums = null;
        Vector item = null;
        Connection conn = null;
        PreparedStatement pstHad = null;
        PreparedStatement pstParent = null;
        PreparedStatement pstUp = null;
        ResultSet rst = null;
        String oneLSql = null;
        String otherSql = null;
        String updateSql = null;
        oneLSql = "select flongnumber from t_bg_bgitementry where ";
        otherSql = "select flongnumber from t_bg_bgitementry where ";
        updateSql = "update t_bg_bgitementry set FCurOrgUnitId = ? , FCurOrgUnitNumber = ? , FCurOrgUnitLongnumber = ? , FCurOrgUnitName_l1 = ? , FCurOrgUnitName_l2 = ? , FCurOrgUnitName_l3 = ? where fid = ?";
        String itemNotIn = "";
        String itemParentIn = "";
        String[] filter = new String[2];
        String[] org = new String[7];
        HashMap updateItem = null;
        HashMap hadParentItem = new HashMap();
        try {
            conn = this.getConnection(ctx);
            for (int i = 1; i <= levelNum; ++i) {
                if (!changeLevel.containsKey(new Integer(i))) continue;
                itemNums = (ArrayList)changeLevel.get(new Integer(i));
                int n = 0;
                while (n * 30 < itemNums.size()) {
                    String longNum;
                    Iterator ite;
                    updateItem = new HashMap();
                    for (int m = 0; m < 30 && n * 30 + m != itemNums.size(); ++m) {
                        item = (Vector)changeItem.get(itemNums.get(n * 30 + m));
                        filter = this.getOrgFilter(item);
                        itemNotIn = itemNotIn + " or ( fnumber = '" + itemNums.get(n * 30 + m) + "' and " + filter[0] + ")";
                        if (i != 1) {
                            itemParentIn = itemParentIn + " or ( fid ='" + filter[1] + "'  and " + filter[0] + ")";
                        }
                        org = new String[]{((FullOrgUnitInfo)item.get(2)).getId().toString(), ((FullOrgUnitInfo)item.get(2)).getNumber(), ((FullOrgUnitInfo)item.get(2)).getLongNumber(), ((FullOrgUnitInfo)item.get(2)).getName(new Locale("L1")), ((FullOrgUnitInfo)item.get(2)).getName(new Locale("L2")), ((FullOrgUnitInfo)item.get(2)).getName(new Locale("L3")), (String)item.get(4)};
                        updateItem.put(item.get(0), org);
                    }
                    pstHad = conn.prepareStatement(oneLSql + itemNotIn.substring(3));
                    rst = pstHad.executeQuery();
                    while (rst.next()) {
                    }
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstHad);
                    if (i != 1) {
                        pstParent = conn.prepareStatement(otherSql + itemParentIn.substring(3));
                        rst = pstParent.executeQuery();
                        while (rst.next()) {
                            hadParentItem.put(rst.getString(1), null);
                        }
                        SQLUtils.cleanup((Statement)pstParent);
                        SQLUtils.cleanup((ResultSet)rst);
                        pstUp = conn.prepareStatement(updateSql);
                        ite = updateItem.keySet().iterator();
                        while (ite.hasNext()) {
                            longNum = ite.next().toString();
                            String parentNum = longNum.substring(0, longNum.lastIndexOf("!"));
                            if (!hadParentItem.containsKey(parentNum)) {
                                msg = msg + longNum + "#";
                                continue;
                            }
                            org = (String[])updateItem.get(longNum);
                            pstUp.setString(1, org[0]);
                            pstUp.setString(2, org[1]);
                            pstUp.setString(3, org[2]);
                            pstUp.setString(4, org[3]);
                            pstUp.setString(5, org[4]);
                            pstUp.setString(6, org[5]);
                            pstUp.setString(7, org[6]);
                            pstUp.addBatch();
                        }
                        pstUp.executeBatch();
                    } else {
                        pstUp = conn.prepareStatement(updateSql);
                        ite = updateItem.keySet().iterator();
                        while (ite.hasNext()) {
                            longNum = ite.next().toString();
                            org = (String[])updateItem.get(longNum);
                            pstUp.setString(1, org[0]);
                            pstUp.setString(2, org[1]);
                            pstUp.setString(3, org[2]);
                            pstUp.setString(4, org[3]);
                            pstUp.setString(5, org[4]);
                            pstUp.setString(6, org[5]);
                            pstUp.setString(7, org[6]);
                            pstUp.addBatch();
                        }
                        pstUp.executeBatch();
                    }
                    SQLUtils.cleanup((Statement)pstUp);
                    ++n;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pstUp);
            SQLUtils.cleanup(pstParent);
            SQLUtils.cleanup(rst, pstHad, (Connection)conn);
        }
        return msg;
    }

    private String[] getOrgFilter(Vector itemOrgInfo) {
        String orgFilter = null;
        String parentId = null;
        orgFilter = "( FCurOrgUnitNumber in ( ";
        String orgLN = ((FullOrgUnitInfo)itemOrgInfo.get(2)).getLongNumber();
        parentId = (String)itemOrgInfo.get(1);
        String[] orgs = orgLN.split("!");
        for (int i = 0; i < orgs.length; ++i) {
            orgFilter = orgFilter + " '" + orgs[i] + "' ";
            if (i == orgs.length - 1) continue;
            orgFilter = orgFilter + " , ";
        }
        orgFilter = orgFilter + " ) or fcurOrgUnitLongnumber like '" + orgLN + "!%')";
        String[] filter = new String[]{orgFilter, parentId};
        return filter;
    }

    @Override
    protected Map _getCanUseReturnNum(Context ctx, BOSUuid orgUnitId, List number) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (orgUnitId == null || number == null || number.isEmpty()) {
            return resultMap;
        }
        Set orgUnitIdSet = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _fid = null;
        String _number2 = null;
        Object _tmpStr = null;
        StringBuffer query = new StringBuffer();
        try {
            conn = this.getConnection(ctx);
            orgUnitIdSet = this.getOrgUnitIds(conn, orgUnitId);
            if (orgUnitIdSet != null && !orgUnitIdSet.isEmpty()) {
                query.append("select Fnumber from T_BG_BgItemEntry where FNumber IN (");
                for (String _number2 : number) {
                    query.append("'" + _number2 + "',");
                }
                query.delete(query.length() - 1, query.length());
                query.append(")");
                query.append(" and FCurOrgUnitId IN (");
                for (String _number2 : orgUnitIdSet) {
                    query.append("'" + _number2 + "',");
                }
                query.delete(query.length() - 1, query.length());
                query.append(")");
                pstmt = conn.prepareStatement(query.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _fid = rst.getString(1);
                    resultMap.put(_fid, null);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return resultMap;
    }

    @Override
    protected Map _getCanCancelCancel(Context ctx, BOSUuid orgUnitId, List number) throws BOSException, EASBizException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (orgUnitId == null || number == null || number.isEmpty()) {
            return resultMap;
        }
        Set orgUnitIdSet = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String _fid = null;
        String _number2 = null;
        String _tmpStr = null;
        StringBuffer query = new StringBuffer();
        ArrayList<String> itemLongNumList = new ArrayList<String>();
        try {
            conn = this.getConnection(ctx);
            orgUnitIdSet = this.getOrgUnitIds(conn, orgUnitId);
            if (orgUnitIdSet != null && !orgUnitIdSet.isEmpty()) {
                query.append("select FID, FCurOrgUnitId, fnumber, flongNumber from T_BG_BgItemEntry where FNumber IN (");
                for (String _number2 : number) {
                    query.append("'" + _number2 + "',");
                }
                query.delete(query.length() - 1, query.length());
                query.append(")");
                query.append(" and FCurOrgUnitId IN (");
                for (String _number2 : orgUnitIdSet) {
                    query.append("'" + _number2 + "',");
                }
                query.delete(query.length() - 1, query.length());
                query.append(")");
                query.append(" order by flongNumber");
                pstmt = conn.prepareStatement(query.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _fid = rst.getString(1);
                    _tmpStr = rst.getString(2);
                    itemLongNumList.add(rst.getString(4));
                    if (!this.isCanEfficacy(ctx, itemLongNumList, rst.getString(4), orgUnitIdSet)) continue;
                    resultMap.put(_fid, _tmpStr);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return resultMap;
    }

    private boolean isCanEfficacy(Context ctx, List longNums, String currentLongNum, Set orgUnitIdSet) throws BOSException, EASBizException {
        if (currentLongNum == null || currentLongNum.length() <= 0) {
            throw new BOSException();
        }
        if (currentLongNum.indexOf("!") == -1) {
            return true;
        }
        boolean isCanEfficacy = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer SQL = null;
        String _number2 = null;
        try {
            int i;
            conn = this.getConnection(ctx);
            String[] allParentNum = currentLongNum.split("!");
            ArrayList<String> allParentLongNums = new ArrayList<String>();
            allParentLongNums.add(currentLongNum);
            for (i = 1; i < allParentNum.length; ++i) {
                int lastIndex = currentLongNum.lastIndexOf("!");
                if (lastIndex == -1) {
                    allParentLongNums.add(currentLongNum);
                    break;
                }
                currentLongNum = currentLongNum.substring(0, lastIndex);
                allParentLongNums.add(currentLongNum);
            }
            Collections.reverse(allParentLongNums);
            for (i = allParentNum.length - 2; i >= 0; --i) {
                String parentNum = allParentNum[i];
                String parentLongNum = allParentLongNums.get(i).toString();
                if (longNums.contains(parentLongNum)) {
                    isCanEfficacy = true;
                    continue;
                }
                ArrayList<String> _tmpList = new ArrayList<String>();
                SQL = new StringBuffer();
                SQL.append("select FIsEffective , fnumber from T_BG_BgItemEntry where fNumber= ? ");
                _tmpList.add(parentNum);
                SQL.append(" and FCurOrgUnitId IN (");
                for (String _number2 : orgUnitIdSet) {
                    SQL.append("?,");
                    _tmpList.add(_number2);
                }
                SQL.delete(SQL.length() - 1, SQL.length());
                SQL.append(")");
                pstmt = conn.prepareStatement(SQL.toString());
                BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList);
                rst = pstmt.executeQuery();
                if (!rst.next()) continue;
                int status = rst.getInt("FIsEffective");
                if (status == 1) {
                    isCanEfficacy = true;
                    continue;
                }
                isCanEfficacy = false;
                throw new BgItemEfficacyException(BgItemEfficacyException.PARENTISINEFFICACY, new String[]{"[" + rst.getString("fnumber") + "]"});
            }
            boolean bl = isCanEfficacy;
            return bl;
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _updateOrgNumber(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement queryPstmt = null;
        PreparedStatement updatePstmt = null;
        ResultSet queryRst = null;
        CostCenterOrgUnitInfo ccOrgInfo = null;
        ArrayList<CostCenterOrgUnitInfo> orgList = new ArrayList<CostCenterOrgUnitInfo>();
        String queryOrgSql = "select FID,FNumber,FLongNumber,FName_" + ctx.getLocale() + " from T_ORG_CostCenter where FID in (select distinct FCurOrgUnitId from T_BG_BgItemEntry)";
        String updateSql = "update T_BG_BgItemEntry  set FCurOrgUnitNumber= ?,FCurOrgUnitLongnumber=?,FCurOrgUnitName_" + ctx.getLocale() + "=? where FCurOrgUnitId = ?";
        try {
            conn = this.getConnection(ctx);
            queryPstmt = conn.prepareStatement(queryOrgSql);
            queryRst = queryPstmt.executeQuery();
            while (queryRst.next()) {
                ccOrgInfo = new CostCenterOrgUnitInfo();
                ccOrgInfo.setId(BOSUuid.read((String)queryRst.getString(1)));
                ccOrgInfo.setNumber(queryRst.getString(2));
                ccOrgInfo.setLongNumber(queryRst.getString(3));
                ccOrgInfo.setName(queryRst.getString(4));
                orgList.add(ccOrgInfo);
            }
            updatePstmt = conn.prepareStatement(updateSql);
            int size = orgList.size();
            for (int i = 0; i < size; ++i) {
                ccOrgInfo = (CostCenterOrgUnitInfo)orgList.get(i);
                updatePstmt.setString(1, ccOrgInfo.getNumber());
                updatePstmt.setString(2, ccOrgInfo.getLongNumber());
                updatePstmt.setString(3, ccOrgInfo.getName());
                updatePstmt.setString(4, ccOrgInfo.getId().toString());
                updatePstmt.addBatch();
            }
            updatePstmt.executeBatch();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(queryRst, queryPstmt, (Connection)conn);
                SQLUtils.cleanup(updatePstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)queryRst, (Statement)queryPstmt, (Connection)conn);
        SQLUtils.cleanup((Statement)updatePstmt);
    }
}

