/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemException;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemGroupFactory;
import com.kingdee.eas.ma.budget.BgItemGroupInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgItemGroup;
import com.kingdee.eas.ma.budget.app.AbstractBgItemGroupControllerBean;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BgItemGroupControllerBean
extends AbstractBgItemGroupControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgItemGroupControllerBean");

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgItemGroupInfo info = (BgItemGroupInfo)model;
        String number = info.getNumber();
        String name = info.getName();
        String id = pk.toString();
        if (this.checkDupNumber(ctx, number, id)) {
            throw new BgItemException(BgItemException.GROUPHAVENUMBER, new String[]{number});
        }
        if (this.checkDupName(ctx, name, id)) {
            throw new BgItemException(BgItemException.GROUPHAVENAME, new String[]{name});
        }
        super._update(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        IObjectPK pk = null;
        BgItemGroupInfo bgItemGroupInfo = (BgItemGroupInfo)model;
        if (StringUtils.isEmpty((String)bgItemGroupInfo.getNumber())) {
            String companyId = ContextUtil.getCurrentCostUnit((Context)ctx).getId().toString();
            BgHelper.setSNumber(ctx, companyId, (CoreBaseInfo)bgItemGroupInfo);
            if (StringUtils.isEmpty((String)bgItemGroupInfo.getNumber())) {
                bgItemGroupInfo.setNumber("BgItemGroup-" + System.currentTimeMillis());
            }
        }
        String number = bgItemGroupInfo.getNumber();
        String name = bgItemGroupInfo.getName();
        if (this.checkDupNumber(ctx, number, null)) {
            throw new BgItemException(BgItemException.GROUPHAVENUMBER, new String[]{number});
        }
        if (this.checkDupName(ctx, name, null)) {
            throw new BgItemException(BgItemException.GROUPHAVENAME, new String[]{name});
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select count(FID) from T_BG_BgItemGroup where FIsLeaf = 1");
            rst = pstmt.executeQuery();
            rst.next();
            int num = rst.getInt(1);
            if (num >= 250) {
                throw new BgItemException(BgItemException.GROUPISTOOLARGER);
            }
            if (bgItemGroupInfo.getParent() != null && bgItemGroupInfo.getParent().getId() != null) {
                BgItemGroupInfo parent = bgItemGroupInfo.getParent();
                parent.setRefField(null);
                parent.setIsLeaf(false);
                this._update(ctx, (IObjectPK)new ObjectUuidPK(parent.getId()), (IObjectValue)parent);
            }
            this.setBgItemGroupRefField(ctx, bgItemGroupInfo);
            pk = super._addnew(ctx, model);
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return pk;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBgItemGroup ibgItemGroup = null;
        BgItemGroupInfo bgItemGroupInfo = null;
        BgItemGroupInfo parent = null;
        ibgItemGroup = BgItemGroupFactory.getLocalInstance(ctx);
        bgItemGroupInfo = ibgItemGroup.getBgItemGroupInfo(pk);
        String companyId = ContextUtil.getCurrentCostUnit((Context)ctx).getId().toString();
        BgHelper.recycleNumber(ctx, (CoreBaseInfo)bgItemGroupInfo, companyId);
        if (bgItemGroupInfo.getParent() != null && bgItemGroupInfo.getParent().getId() != null) {
            ObjectUuidPK ppk = new ObjectUuidPK(bgItemGroupInfo.getParent().getId());
            super._delete(ctx, pk);
            parent = ibgItemGroup.getBgItemGroupInfo((IObjectPK)ppk);
            if (this.checkIsLeaf(ctx, parent.getId())) {
                this.setBgItemGroupRefField(ctx, parent);
                parent.setIsLeaf(true);
                this._update(ctx, (IObjectPK)ppk, (IObjectValue)parent);
            }
        } else {
            super._delete(ctx, pk);
        }
    }

    private boolean checkDupName(Context ctx, String name, String id) throws BOSException, EASBizException {
        boolean re = true;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_BG_BgItemGroup where FName_" + ctx.getLocale() + " = ?");
        if (id != null) {
            sql.append(" and FID != ?");
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, name);
            if (id != null) {
                pstmt.setString(2, id);
            }
            if (!(rst = pstmt.executeQuery()).next()) {
                re = false;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkDupNumber(Context ctx, String number, String id) throws BOSException, EASBizException {
        boolean re = true;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_BG_BgItemGroup where FNumber = ?");
        if (id != null) {
            sql.append(" and FID != ?");
        }
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, number);
            if (id != null) {
                pstmt.setString(2, id);
            }
            if (!(rst = pstmt.executeQuery()).next()) {
                re = false;
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return re;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
            catch (BOSException bOSException) {
                return re;
            }
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setBgItemGroupRefField(Context ctx, BgItemGroupInfo model) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block11: {
            HashMap refFieldMap;
            block10: {
                conn = null;
                pstmt = null;
                rst = null;
                String refField = null;
                refFieldMap = new HashMap();
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement("select FRefField From T_BG_BgItemGroup Where FId = '" + model.getId().toString() + "'");
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        refField = rst.getString("FRefField");
                    }
                    if (refField == null) {
                        pstmt = conn.prepareStatement("select FRefField from T_BG_BgItemGroup where (FRefField IS NOT NULL )");
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            String str = rst.getString(1);
                            if (str == null || str.trim().length() <= 1) continue;
                            refFieldMap.put(new Integer(str.substring(1)), null);
                        }
                        if (!refFieldMap.isEmpty()) {
                            break block10;
                        }
                        model.setRefField("F1");
                        break block11;
                    }
                    model.setRefField(refField);
                    break block11;
                }
                catch (BOSException ex) {
                    try {
                        throw ex;
                        catch (SQLException ex2) {
                            throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                        }
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            for (int i = 1; i <= 250; ++i) {
                if (refFieldMap.containsKey(new Integer(i))) continue;
                model.setRefField("F" + i);
                break;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkIsLeaf(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        boolean re = true;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID From T_BG_BgItemGroup where FParentID = ?");
            pstmt.setString(1, id.toString());
            rst = pstmt.executeQuery();
            re = !rst.next();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return re;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _removeAll(Context ctx, BOSUuid bgItemGroupID, String orgUnitLongNum) throws BOSException, EASBizException {
        String sql = null;
        this.isUsedForGroup(ctx, bgItemGroupID.toString(), orgUnitLongNum);
        ArrayList<String> _tmpList = new ArrayList<String>();
        if (!"".equals(bgItemGroupID.toString())) {
            sql = " DELETE FROM T_BG_Bgitem WHERE (FBGITEMGROUPID = ? and forgunitId in (select fid from t_org_baseunit where flongnumber = ? or flongnumber like ?))";
            _tmpList.add(bgItemGroupID.toString());
            _tmpList.add(orgUnitLongNum);
            _tmpList.add(orgUnitLongNum + "!%");
        } else {
            sql = " DELETE FROM T_BG_Bgitem WHERE forgunitId in (select fid from t_org_baseunit where flongnumber = ? or flongnumber like ?)";
            _tmpList.add(orgUnitLongNum);
            _tmpList.add(orgUnitLongNum + "!%");
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            BgNSQLHelper.setParams((PreparedStatement)stmt, _tmpList);
            stmt.executeUpdate();
        }
        catch (BOSException e) {
            try {
                throw e;
                catch (SQLException e2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void isUsedForGroup(Context ctx, String groupID, String orgLongNum) throws BgItemException {
        OrgUnitInfo orgUnitInfo = ContextUtil.getCurrentOrgUnit((Context)ctx);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "";
        int n = 0;
        try {
            if (!StringUtils.isEmpty((String)groupID)) {
                IBgItem iBgItem = BgItemFactory.getLocalInstance(ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bgItemGroup.id", (Object)groupID));
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg(ctx, orgUnitInfo.getId().toString())));
                filter.setMaskString("#0 and #1");
                viewInfo.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("number"));
                selector.add(new SelectorItemInfo("refField"));
                viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
                BgItemCollection coll = iBgItem.getBgItemCollection(viewInfo);
                if (coll.size() == 0) {
                    throw new BgItemException(BgItemException.NOTHAVEITEM);
                }
                String refField = coll.get(0).getRefField();
                n = coll.size();
                sql = "select fid from T_BG_BgItemCombination where " + refField + " in (";
                for (int i = 0; i < n; ++i) {
                    sql = sql + "'" + coll.get(i).getNumber().toString() + "'";
                    if (i == n - 1) continue;
                    sql = sql + ",";
                }
                sql = sql + ")";
                conn = this.getConnection(ctx);
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    throw new BgItemException(BgItemException.ISUSEDFORGROUP);
                }
            }
        }
        catch (BOSException e) {
            throw new BgItemException(BgItemException.ISUSEDFORGROUP);
        }
        catch (SQLException e) {
            throw new BgItemException(BgItemException.ISUSEDFORGROUP);
        }
        catch (Exception e1) {
            logger.error((Object)"budget error:", (Throwable)e1);
        }
        finally {
            SQLUtils.cleanup(stmt, conn);
        }
    }
}

