/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.app.AbstractBgNFFacadeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class BgNFFacadeControllerBean
extends AbstractBgNFFacadeControllerBean {
    private static final long serialVersionUID = -717927461268684622L;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectCollection _getBgTemplateInfo(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        BgTemplateCollection bgTemplateCol = new BgTemplateCollection();
        if (bgSchemeId == null) {
            return bgTemplateCol;
        }
        BgTemplateInfo bgTemplateInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName, FNumber from T_BG_BgTemplate t where t.FID in (select fbgtemplateid from T_BG_BgSchemeNode where FBgSchemeId = ?) order by FNumber");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgSchemeId.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgTemplateInfo = new BgTemplateInfo();
                bgTemplateInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgTemplateInfo.setName(rst.getString("FName"));
                bgTemplateInfo.setNumber(rst.getString("FNumber"));
                bgTemplateCol.add(bgTemplateInfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgTemplateCol;
    }
}

