/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.ma.budget.BgAnalysisTypeEnum;
import com.kingdee.eas.ma.budget.BgBalanceFilterParam;
import com.kingdee.eas.ma.budget.BgCommonException;
import com.kingdee.eas.ma.budget.BgCompareOneFilterParam;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDifferFilterParam;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementException;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFillHelper;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgGetPeriodTypeForGetBlanceEnum;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemException;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgItemQueryHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgQueryFormFilterParam;
import com.kingdee.eas.ma.budget.BgRptDataInfo;
import com.kingdee.eas.ma.budget.BgRptDataInfo2;
import com.kingdee.eas.ma.budget.BgRptFilterParam;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeAssignException;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateException;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.BgTraceFilterParam;
import com.kingdee.eas.ma.budget.BgTraceHelperBean;
import com.kingdee.eas.ma.budget.BgTraceInfo;
import com.kingdee.eas.ma.budget.BgTraceInfoContainter;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.app.AbstractBgRptFacadeControllerBean;
import com.kingdee.eas.ma.budget.app.BgBalCalculator;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgRptFacadeControllerBean
extends AbstractBgRptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgRptFacadeControllerBean");
    IBgForm iBgForm = null;
    private static final String date_pattern = "yyyy-MM-dd HH:mm:ss";
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    @Override
    protected IObjectValue _getBgForm(Context ctx, Object queryFilterParam) throws BOSException, EASBizException {
        BgRptFilterParam filterParam = (BgRptFilterParam)queryFilterParam;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < filterParam.getPeriodIds().length; ++i) {
            set.add(filterParam.getPeriodIds()[i]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        filterItems.add(new FilterItemInfo("orgUnit", (Object)BgHelper.tranArray2Set(filterParam.getOrgUnitIds()), CompareType.INCLUDE));
        if (filterParam.getOrgUnitIds().length == 1) {
            filterItems.add(new FilterItemInfo("bgScheme", (Object)filterParam.getBgSchemeId()));
            filterItems.add(new FilterItemInfo("bgTemplate", filterParam.getBgTemplate().keySet().toArray()[0]));
        } else {
            filterItems.add(new FilterItemInfo("bgScheme.rootId", (Object)filterParam.getBgSchemeId()));
            filterItems.add(new FilterItemInfo("bgTemplate.rootId", filterParam.getBgTemplate().keySet().toArray()[0]));
        }
        filterItems.add(new FilterItemInfo("bgPeriod", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)BgFormStateEnum.Approved, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)BgFormStateEnum.Edited, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)BgFormStateEnum.Approving, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)BgFormStateEnum.Adjusted, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)BgFormStateEnum.Collect, CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("bgScheme", (Object)filterParam.getThisBgSchemeId()));
        filter.setMaskString("#0 and #1 and #2 and #3 and ( #4 or #5 or #6 or #7 or #8 ) and #9");
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("bgPeriod"));
        sic.add(new SelectorItemInfo("orgUnit"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("bgScheme"));
        sic.add(new SelectorItemInfo("bgTemplate"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("state"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
        BgFormInfo bgFormInfo = null;
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        BgFormCollection bgFormColl = iBgForm.getBgFormCollection(viewInfo);
        if (bgFormColl == null || bgFormColl.size() <= 0) {
            return null;
        }
        bgFormInfo = bgFormColl.get(0);
        return bgFormInfo;
    }

    @Override
    protected List _getBgData(Context ctx, Object queryFilterParam) throws BOSException, EASBizException {
        int length;
        String[] temIDs;
        BgTemplateInfo info;
        String rootTemId;
        Iterator iterator;
        String tempId;
        int i;
        String[] rootIds;
        IRowSet rs;
        String tmpsql;
        BgRptFilterParam filterParam = (BgRptFilterParam)queryFilterParam;
        if (filterParam.getBgRptType().equals((Object)BgAnalysisTypeEnum.BGDIFFER)) {
            return this.getBgData4Differ(ctx, queryFilterParam);
        }
        ArrayList<BgRptDataInfo> infoList = new ArrayList<BgRptDataInfo>();
        ArrayList _tmpList = new ArrayList();
        BgAnalysisTypeEnum rptType = filterParam.getBgRptType();
        String[] bgPeriodIds = null;
        bgPeriodIds = rptType.equals((Object)BgAnalysisTypeEnum.BGCOMPARE) || rptType.equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE) || rptType.equals((Object)BgAnalysisTypeEnum.BGQUERY) || rptType.equals((Object)BgAnalysisTypeEnum.BGCOMPAREANALYSIS) ? filterParam.getPeriodIds() : (rptType.equals((Object)BgAnalysisTypeEnum.BGTRACE) ? this.getBgPeriodIds(ctx, filterParam.getBeginPeriodId(), filterParam.getEndPeriodId()) : this.getBgPeriodIds(ctx, filterParam.getBeginPeriodId(), filterParam.getEndPeriodId()));
        String bgTemplateId = filterParam.getBgTemplate().isEmpty() ? "" : (String)filterParam.getBgTemplate().keySet().toArray()[0];
        Map bgMap = bgTemplateId.equals("") ? new HashMap() : this.getBgMaterialMap(ctx, bgTemplateId);
        StringBuffer strBuff = new StringBuffer("SELECT BgItemComb.FKey as FKey,BgData.FId AS BGDateID,BgData.FOrgUnitId AS OrgUnitId, BgData.FBgSchemeId AS BgSchemeId, BgData.FBgTemplateId AS BgTemplateId, ");
        strBuff.append(" BgData.FBgPeriodId AS BgPeriodId, BgData.FBgItemCombinId AS BgItemCombinId,");
        strBuff.append(" BgData.FBgElementId AS BgElementId, BgData.FCurrencyId AS CurrencyId, BgData.FBgValue AS BgValue, BgData.FBizActual AS BizActual  \r\n");
        strBuff.append(" FROM T_BG_BgData AS BgData  \r\n");
        strBuff.append(" INNER JOIN T_BG_BgForm AS BgForm ON BgData.FBgFormId=BgForm.FID  \r\n");
        strBuff.append(" INNER JOIN T_BG_BgItemCombination  as BgItemComb ON  BgItemComb.fid=BgData.FBgItemCombinId  \r\n");
        strBuff.append(" , t_Bg_Bgscheme B, t_Bg_Bgtemplate C   \r\n");
        strBuff.append(" WHERE  BGDATA.Fbgschemeid = B.Fid AND  BGDATA.fbgtemplateid = C.fid  \r\n");
        if (queryFilterParam instanceof BgQueryFormFilterParam) {
            if (filterParam.getOrgUnitIds() != null) {
                strBuff.append(" AND BgData.FOrgUnitId IN  ");
                strBuff.append(BgHelper.tranArray2String(filterParam.getOrgUnitIds()));
            }
        } else if (filterParam.getAttainOrgUnitIds() != null) {
            strBuff.append(" AND BgData.FOrgUnitId IN  ");
            strBuff.append(BgHelper.tranArray2String(filterParam.getAttainOrgUnitIds()));
        } else if (filterParam.getOrgUnitIds() != null) {
            strBuff.append(" AND BgData.FOrgUnitId IN  ");
            strBuff.append(BgHelper.tranArray2String(filterParam.getOrgUnitIds()));
        }
        if (filterParam.getOrgUnitIds() != null && filterParam.getOrgUnitIds().length > 1) {
            strBuff.append(" AND B.FrootId IN ");
        } else {
            strBuff.append(" AND B.FId IN ");
        }
        if (filterParam.getBgRptType().equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            strBuff.append(BgHelper.tranSet2String(filterParam.getMultiBgSchemeMap().keySet()));
        } else if (filterParam instanceof BgBalanceFilterParam && filterParam.getBgSchemeIds().length > 1) {
            tmpsql = "select distinct frootid from t_bg_bgscheme where fid in " + BgHelper.tranArray2String(filterParam.getBgSchemeIds());
            rs = DbUtil.executeQuery((Context)ctx, (String)tmpsql);
            if (rs.size() != 0) {
                rootIds = new String[rs.size()];
                try {
                    i = 0;
                    while (rs.next()) {
                        rootIds[i] = rs.getString(1);
                        ++i;
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                strBuff.append(BgHelper.tranArray2String(rootIds));
            }
        } else {
            strBuff.append(BgHelper.tranArray2String(filterParam.getBgSchemeIds()));
        }
        strBuff.append(" \r\n");
        if (queryFilterParam instanceof NewBgCompareAndAnalysisFilterParam) {
            strBuff.append(" and (");
            strBuff.append(" C.Fid = '" + filterParam.getBgTemplateID() + "'");
            strBuff.append(") ");
        } else if (queryFilterParam instanceof BgBalanceFilterParam && ((BgBalanceFilterParam)queryFilterParam).getItemFrom() != null && ((BgBalanceFilterParam)queryFilterParam).getItemTo() != null) {
            if (filterParam.getOrgUnitIds() != null && filterParam.getOrgUnitIds().length > 1) {
                tempId = null;
                strBuff.append(" and (");
                if (filterParam.getBgTemplate() != null && filterParam.getBgTemplate().size() > 0 && (iterator = filterParam.getBgTemplate().keySet().iterator()).hasNext()) {
                    tempId = (String)iterator.next();
                }
                rootTemId = null;
                if (tempId != null) {
                    info = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateInfo((IObjectPK)new ObjectUuidPK(tempId));
                    if (info != null && info.getRootId() != null) {
                        rootTemId = info.getRootId().toString();
                    }
                    if (rootTemId != null) {
                        strBuff.append(" C.FrootId = '" + rootTemId + "'");
                    }
                } else {
                    temIDs = filterParam.getBgTemplateIds();
                    length = temIDs.length;
                    for (i = 0; i < length; ++i) {
                        if (i == 0) {
                            strBuff.append(" C.Frootid = '" + temIDs[i] + "'");
                            continue;
                        }
                        strBuff.append(" or C.Frootid = '" + temIDs[i] + "'");
                    }
                }
            } else {
                strBuff.append(" and  (C.Fid = '" + filterParam.getBgTemplateIds()[0] + "'");
            }
            strBuff.append(") ");
        } else if (queryFilterParam instanceof BgTraceFilterParam && ((BgTraceFilterParam)queryFilterParam).getItemFrom() != null && ((BgTraceFilterParam)queryFilterParam).getItemTo() != null) {
            if (filterParam.getOrgUnitIds() != null && filterParam.getOrgUnitIds().length > 1) {
                tempId = null;
                strBuff.append(" and (");
                if (filterParam.getBgTemplate() != null && filterParam.getBgTemplate().size() > 0 && (iterator = filterParam.getBgTemplate().keySet().iterator()).hasNext()) {
                    tempId = (String)iterator.next();
                }
                rootTemId = null;
                if (tempId != null) {
                    info = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateInfo((IObjectPK)new ObjectUuidPK(tempId));
                    if (info != null && info.getRootId() != null) {
                        rootTemId = info.getRootId().toString();
                    }
                    if (rootTemId != null) {
                        strBuff.append(" C.FrootId = '" + rootTemId + "'");
                    }
                } else {
                    temIDs = filterParam.getBgTemplateIds();
                    length = temIDs.length;
                    for (i = 0; i < length; ++i) {
                        if (i == 0) {
                            strBuff.append(" C.Frootid = '" + temIDs[i] + "'");
                            continue;
                        }
                        strBuff.append(" or C.Frootid = '" + temIDs[i] + "'");
                    }
                }
            } else {
                strBuff.append(" and  (C.Fid = '" + filterParam.getBgTemplateIds()[0] + "'");
            }
            strBuff.append(") ");
        } else if (queryFilterParam instanceof BgQueryFormFilterParam && (((BgQueryFormFilterParam)queryFilterParam).getItemFrom() != null || ((BgQueryFormFilterParam)queryFilterParam).getItemTo() != null)) {
            if (filterParam.getOrgUnitIds() != null && filterParam.getOrgUnitIds().length > 1) {
                tempId = null;
                strBuff.append(" and (");
                if (filterParam.getBgTemplate() != null && filterParam.getBgTemplate().size() > 0 && (iterator = filterParam.getBgTemplate().keySet().iterator()).hasNext()) {
                    tempId = (String)iterator.next();
                }
                rootTemId = null;
                if (tempId != null) {
                    info = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateInfo((IObjectPK)new ObjectUuidPK(tempId));
                    if (info != null && info.getRootId() != null) {
                        rootTemId = info.getRootId().toString();
                    }
                    if (rootTemId != null) {
                        strBuff.append(" C.FrootId = '" + rootTemId + "'");
                    }
                } else {
                    temIDs = filterParam.getBgTemplateIds();
                    length = temIDs.length;
                    for (i = 0; i < length; ++i) {
                        if (i == 0) {
                            strBuff.append(" C.Frootid = '" + temIDs[i] + "'");
                            continue;
                        }
                        strBuff.append(" or C.Frootid = '" + temIDs[i] + "'");
                    }
                }
            } else {
                strBuff.append(" and (C.Fid = '" + filterParam.getBgTemplateIds()[0] + "'");
            }
            strBuff.append(") ");
        } else if (queryFilterParam instanceof BgCompareOneFilterParam && (((BgCompareOneFilterParam)queryFilterParam).getItemFrom() != null || ((BgCompareOneFilterParam)queryFilterParam).getItemTo() != null)) {
            if (filterParam.getOrgUnitIds() != null && filterParam.getOrgUnitIds().length > 1) {
                tempId = null;
                strBuff.append(" and (");
                if (filterParam.getBgTemplate() != null && filterParam.getBgTemplate().size() > 0 && (iterator = filterParam.getBgTemplate().keySet().iterator()).hasNext()) {
                    tempId = (String)iterator.next();
                }
                rootTemId = null;
                if (tempId != null) {
                    info = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateInfo((IObjectPK)new ObjectUuidPK(tempId));
                    if (info != null && info.getRootId() != null) {
                        rootTemId = info.getRootId().toString();
                    }
                    if (rootTemId != null) {
                        strBuff.append(" C.FrootId = '" + rootTemId + "'");
                    }
                } else {
                    temIDs = filterParam.getBgTemplateIds();
                    length = temIDs.length;
                    for (i = 0; i < length; ++i) {
                        if (i == 0) {
                            strBuff.append(" C.Frootid = '" + temIDs[i] + "'");
                            continue;
                        }
                        strBuff.append(" or C.Frootid = '" + temIDs[i] + "'");
                    }
                }
            } else {
                strBuff.append(" and  (C.Fid = '" + filterParam.getBgTemplateIds()[0] + "'");
            }
            strBuff.append(") ");
        } else {
            if (filterParam.getOrgUnitIds() != null && filterParam.getOrgUnitIds().length > 1) {
                strBuff.append(" AND C.FrootId IN ");
            } else {
                strBuff.append(" AND C.FId IN ");
            }
            if (filterParam instanceof BgBalanceFilterParam && filterParam.getBgTemplateIds().length > 1) {
                tmpsql = "select distinct frootid from t_bg_bgtemplate where fid in " + BgHelper.tranArray2String(filterParam.getBgTemplateIds());
                rs = DbUtil.executeQuery((Context)ctx, (String)tmpsql);
                if (rs.size() != 0) {
                    rootIds = new String[rs.size()];
                    try {
                        i = 0;
                        while (rs.next()) {
                            rootIds[i] = rs.getString(1);
                            ++i;
                        }
                    }
                    catch (SQLException e) {
                        logger.error((Object)e);
                        throw new BOSException((Throwable)e);
                    }
                    strBuff.append(BgHelper.tranArray2String(rootIds));
                }
            } else if (filterParam instanceof BgQueryFormFilterParam) {
                tmpsql = "select distinct frootid from t_bg_bgtemplate where fid in " + BgHelper.tranArray2String(filterParam.getBgTemplateIds());
                rs = DbUtil.executeQuery((Context)ctx, (String)tmpsql);
                if (rs.size() != 0) {
                    rootIds = new String[rs.size()];
                    try {
                        i = 0;
                        while (rs.next()) {
                            rootIds[i] = rs.getString(1);
                            ++i;
                        }
                    }
                    catch (SQLException e) {
                        logger.error((Object)e);
                        throw new BOSException((Throwable)e);
                    }
                    strBuff.append(BgHelper.tranArray2String(rootIds));
                }
            } else {
                strBuff.append(BgHelper.tranArray2String(filterParam.getBgTemplateIds()));
            }
        }
        strBuff.append(" \r\n");
        if (bgPeriodIds != null) {
            strBuff.append(" AND BgData.FBgPeriodId IN ");
            strBuff.append(BgHelper.tranArray2String(bgPeriodIds));
            strBuff.append(" \r\n");
        }
        this.dealElement(ctx, queryFilterParam, bgMap, strBuff, _tmpList);
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        this.dealCurrency(ctx, company, rptType, queryFilterParam, strBuff, _tmpList);
        strBuff.append(" order by BgItemComb.FKey \r\n ");
        boolean isDealItem = false;
        String itemFrom = null;
        String itemTo = null;
        if (queryFilterParam instanceof BgQueryFormFilterParam) {
            itemFrom = ((BgQueryFormFilterParam)queryFilterParam).getItemFrom();
            itemTo = ((BgQueryFormFilterParam)queryFilterParam).getItemTo();
        } else if (queryFilterParam instanceof BgBalanceFilterParam) {
            itemFrom = ((BgBalanceFilterParam)queryFilterParam).getItemFrom();
            itemTo = ((BgBalanceFilterParam)queryFilterParam).getItemTo();
        }
        List[] listItemNumber = null;
        HashMap<String, String> mapItemName = null;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs2 = null;
        if (itemFrom != null || itemTo != null) {
            String[] itemToArray;
            isDealItem = true;
            String[] itemTromArray = itemFrom.split("_");
            int size = itemTromArray.length <= (itemToArray = itemTo.split("_")).length ? itemTromArray.length : itemToArray.length;
            listItemNumber = new List[size];
            mapItemName = new HashMap<String, String>();
            for (int i2 = 0; i2 < size; ++i2) {
                ArrayList<String> listItemNumberTemp = new ArrayList<String>();
                StringBuffer itemSql = null;
                itemSql = new StringBuffer("select fnumber,fname_" + ctx.getLocale() + " fname from t_bg_bgitem where forgUnitId = ? and");
                itemSql.append(" (fnumber >= ? and fnumber <= ?) ");
                try {
                    conn = this.getConnection(ctx);
                    ps = conn.prepareStatement(itemSql.toString());
                    String isolateOrg = BgSHelper.getIsolateOrg(ctx, filterParam.getOrgUnitId());
                    ps.setString(1, BOSUuid.read((String)isolateOrg).toString());
                    ps.setString(2, itemTromArray[i2]);
                    ps.setString(3, itemToArray[i2]);
                    rs2 = ps.executeQuery();
                    while (rs2.next()) {
                        listItemNumberTemp.add(rs2.getString("fnumber"));
                        mapItemName.put(rs2.getString("fnumber"), rs2.getString("fname"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs2, (Statement)ps, (Connection)conn);
                }
                listItemNumber[i2] = listItemNumberTemp;
            }
        }
        System.currentTimeMillis();
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(strBuff.toString());
            BgNSQLHelper.setParams((PreparedStatement)ps, _tmpList);
            rs2 = ps.executeQuery();
            BigDecimal bgValue = SysConstant.BIGZERO;
            BigDecimal bizActual = SysConstant.BIGZERO;
            BigDecimal bgBalance = SysConstant.BIGZERO;
            HashMap numberSet = new HashMap();
            HashMap nameSet = new HashMap();
            while (rs2.next()) {
                String fkey = rs2.getString("FKey");
                String bgItemCombinId = rs2.getString("BgItemCombinId");
                BgRptDataInfo bgRptInfo = new BgRptDataInfo();
                if (isDealItem) {
                    if (!this.checkFeyIsIn(listItemNumber, mapItemName, fkey, bgItemCombinId, numberSet, nameSet)) continue;
                    bgRptInfo.setFkey(fkey);
                    if (mapItemName != null) {
                        bgRptInfo.setFitemNameArray((String)mapItemName.get(bgItemCombinId));
                    }
                }
                bgRptInfo.setRptDataType("CurrentPeriodAnaly");
                bgRptInfo.setBgDataId(rs2.getString("BGDateID"));
                bgRptInfo.setBgOrgUnitId(rs2.getString("OrgUnitId"));
                bgRptInfo.setBgSchemeId(rs2.getString("BgSchemeId"));
                bgRptInfo.setBgPeriodId(rs2.getString("BgPeriodId"));
                bgRptInfo.setBgCombinId(bgItemCombinId);
                bgRptInfo.setBgCurrencyId(rs2.getString("CurrencyId"));
                bgRptInfo.setBgElementId(rs2.getString("BgElementId"));
                bgValue = rs2.getBigDecimal("BgValue");
                bgRptInfo.setBgValue(bgValue);
                bizActual = rs2.getBigDecimal("BizActual");
                bgRptInfo.setBizActual(bizActual);
                bgBalance = this.getBgBalance(bgValue, bizActual);
                bgRptInfo.setBgBalance(bgBalance);
                if (bgBalance != null && bgBalance.signum() == 1) {
                    bgRptInfo.setUsableBg(bgBalance);
                } else {
                    bgRptInfo.setUsableBg(SysConstant.BIGZERO);
                }
                infoList.add(bgRptInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs2, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs2, (Statement)ps, (Connection)conn);
        return infoList;
    }

    @Override
    protected List _getData(Context ctx, Object queryFilterParam) throws BOSException, EASBizException {
        IRowSet rs;
        Object[] obj;
        BgRptFilterParam filterParam = (BgRptFilterParam)queryFilterParam;
        ArrayList<BgRptDataInfo> infoList = new ArrayList<BgRptDataInfo>();
        ArrayList<String> _tmpList = new ArrayList<String>();
        BgAnalysisTypeEnum rptType = filterParam.getBgRptType();
        String[] bgPeriodIds = null;
        bgPeriodIds = filterParam.getPeriodIds() != null ? filterParam.getPeriodIds() : this.getBgPeriodIds(ctx, filterParam.getBeginPeriodId(), filterParam.getEndPeriodId());
        String bgTemplateId = filterParam.getBgTemplate().isEmpty() ? "" : (String)filterParam.getBgTemplate().keySet().toArray()[0];
        Map bgMap = bgTemplateId.equals("") ? new HashMap() : this.getBgMaterialMap(ctx, bgTemplateId);
        StringBuffer strBuff = new StringBuffer("SELECT BgItemComb.FKey as FKey,BgData.FId AS BGDateID,BgData.FOrgUnitId AS OrgUnitId, BgData.FBgSchemeId AS BgSchemeId, BgData.FBgTemplateId AS BgTemplateId, ");
        strBuff.append(" BgData.FBgPeriodId AS BgPeriodId, BgData.FBgItemCombinId AS BgItemCombinId,");
        strBuff.append(" BgData.FBgElementId AS BgElementId, BgData.FCurrencyId AS CurrencyId, BgData.FBgValue AS BgValue, BgData.FBizActual AS BizActual  \r\n");
        strBuff.append(" FROM T_BG_BgData AS BgData  \r\n");
        strBuff.append(" INNER JOIN T_BG_BgForm AS BgForm ON BgData.FBgFormId=BgForm.FID  \r\n");
        strBuff.append(" INNER JOIN T_BG_BgItemCombination  as BgItemComb ON  BgItemComb.fid=BgData.FBgItemCombinId  \r\n");
        strBuff.append(" , t_Bg_Bgscheme B, t_Bg_Bgtemplate C   \r\n");
        strBuff.append(" WHERE  BGDATA.Fbgschemeid = B.Fid AND  BGDATA.fbgtemplateid = C.fid  \r\n");
        if (filterParam.getOrgUnitIds() != null) {
            strBuff.append(" AND BgData.FOrgUnitId IN (");
            strBuff.append(BgNSQLHelper.getParamSizeString((int)filterParam.getOrgUnitIds().length));
            int in = filterParam.getOrgUnitIds().length;
            for (int i = 0; i < in; ++i) {
                _tmpList.add(filterParam.getOrgUnitIds()[i]);
            }
            strBuff.append(")");
        }
        String bgTemplateID = filterParam.getCurrentBgTemplate();
        String bgschemeID = filterParam.getThisBgSchemeId();
        if (filterParam.getOrgUnitIds() != null && filterParam.getOrgUnitIds().length > 1) {
            ArrayList<String> _schemeList = new ArrayList<String>();
            obj = new Object[]{bgschemeID, bgschemeID};
            rs = DbUtil.executeQuery((Context)ctx, (String)"select distinct FRootID from t_Bg_bgscheme where fid = ? or FrootID =?", (Object[])obj);
            try {
                while (rs.next()) {
                    _schemeList.add(rs.getString(1));
                    _tmpList.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            if (_schemeList.isEmpty()) {
                _tmpList.add(filterParam.getBgSchemeId());
                _tmpList.add(filterParam.getBgSchemeId());
            }
            strBuff.append(" AND B.FrootId in(").append(BgNSQLHelper.getParamSizeString((int)_schemeList.size())).append(")");
        } else {
            strBuff.append(" AND B.FId = ?");
            _tmpList.add(bgschemeID);
        }
        if (filterParam.getOrgUnitIds() != null && filterParam.getOrgUnitIds().length > 1) {
            ArrayList<String> _templateList = new ArrayList<String>();
            obj = new Object[]{bgTemplateID, bgTemplateID};
            rs = DbUtil.executeQuery((Context)ctx, (String)"select distinct FrootID from t_Bg_bgtemplate where fid = ? or FrootID =?", (Object[])obj);
            try {
                while (rs.next()) {
                    _templateList.add(rs.getString(1));
                    _tmpList.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            if (_templateList.isEmpty()) {
                _templateList.add("#");
                _tmpList.add("#");
            }
            strBuff.append(" AND C.FrootId in(").append(BgNSQLHelper.getParamSizeString((int)_templateList.size())).append(")");
        } else {
            strBuff.append(" AND C.FId = ?'");
            _tmpList.add(bgTemplateID);
        }
        strBuff.append(" \r\n");
        if (bgPeriodIds != null) {
            strBuff.append(" AND BgData.FBgPeriodId IN (");
            strBuff.append(BgNSQLHelper.getParamSizeString((int)bgPeriodIds.length));
            strBuff.append(") \r\n");
            int in = bgPeriodIds.length;
            for (int i = 0; i < in; ++i) {
                _tmpList.add(bgPeriodIds[i]);
            }
        }
        this.dealElement(ctx, queryFilterParam, bgMap, strBuff, _tmpList);
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        this.dealCurrency(ctx, company, rptType, queryFilterParam, strBuff, _tmpList);
        strBuff.append(" order by BgItemComb.FKey \r\n ");
        boolean isDealItem = false;
        String itemFrom = null;
        String itemTo = null;
        if (queryFilterParam instanceof BgQueryFormFilterParam) {
            itemFrom = ((BgQueryFormFilterParam)queryFilterParam).getItemFrom();
            itemTo = ((BgQueryFormFilterParam)queryFilterParam).getItemTo();
        } else if (queryFilterParam instanceof BgBalanceFilterParam) {
            itemFrom = ((BgBalanceFilterParam)queryFilterParam).getItemFrom();
            itemTo = ((BgBalanceFilterParam)queryFilterParam).getItemTo();
        }
        List[] listItemNumber = null;
        HashMap<String, String> mapItemName = null;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs2 = null;
        if (itemFrom != null || itemTo != null) {
            String[] itemToArray;
            isDealItem = true;
            String[] itemTromArray = itemFrom.split("_");
            int size = itemTromArray.length <= (itemToArray = itemTo.split("_")).length ? itemTromArray.length : itemToArray.length;
            listItemNumber = new List[size];
            mapItemName = new HashMap<String, String>();
            for (int i = 0; i < size; ++i) {
                ArrayList<String> listItemNumberTemp = new ArrayList<String>();
                StringBuffer itemSql = new StringBuffer("select fnumber,fname_" + ctx.getLocale() + " fname from t_bg_bgitem where FOrgUnitId = ? and ");
                itemSql.append(" (fnumber >= ? and fnumber <= ? ) ");
                try {
                    conn = this.getConnection(ctx);
                    ps = conn.prepareStatement(itemSql.toString());
                    ps.setString(1, filterParam.getOrgUnitId());
                    ps.setString(2, itemTromArray[i]);
                    ps.setString(3, itemToArray[i]);
                    rs2 = ps.executeQuery();
                    while (rs2.next()) {
                        listItemNumberTemp.add(rs2.getString("fnumber"));
                        mapItemName.put(rs2.getString("fnumber"), rs2.getString("fname"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs2, (Statement)ps, (Connection)conn);
                }
                listItemNumber[i] = listItemNumberTemp;
            }
        }
        System.currentTimeMillis();
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(strBuff.toString());
            BgNSQLHelper.setParams((PreparedStatement)ps, _tmpList);
            rs2 = ps.executeQuery();
            BigDecimal bgValue = SysConstant.BIGZERO;
            BigDecimal bizActual = SysConstant.BIGZERO;
            BigDecimal bgBalance = SysConstant.BIGZERO;
            HashMap numberSet = new HashMap();
            HashMap nameSet = new HashMap();
            while (rs2.next()) {
                String fkey = rs2.getString("FKey");
                String bgItemCombinId = rs2.getString("BgItemCombinId");
                BgRptDataInfo bgRptInfo = new BgRptDataInfo();
                if (isDealItem) {
                    if (!this.checkFeyIsIn(listItemNumber, mapItemName, fkey, bgItemCombinId, numberSet, nameSet)) continue;
                    bgRptInfo.setFkey(fkey);
                    if (mapItemName != null) {
                        bgRptInfo.setFitemNameArray((String)mapItemName.get(bgItemCombinId));
                    }
                }
                bgRptInfo.setRptDataType("CurrentPeriodAnaly");
                bgRptInfo.setBgDataId(rs2.getString("BGDateID"));
                bgRptInfo.setBgOrgUnitId(rs2.getString("OrgUnitId"));
                bgRptInfo.setBgSchemeId(rs2.getString("BgSchemeId"));
                bgRptInfo.setBgPeriodId(rs2.getString("BgPeriodId"));
                bgRptInfo.setBgCombinId(bgItemCombinId);
                bgRptInfo.setBgCurrencyId(rs2.getString("CurrencyId"));
                bgRptInfo.setBgElementId(rs2.getString("BgElementId"));
                bgValue = rs2.getBigDecimal("BgValue");
                bgRptInfo.setBgValue(bgValue);
                bizActual = rs2.getBigDecimal("BizActual");
                bgRptInfo.setBizActual(bizActual);
                bgBalance = this.getBgBalance(bgValue, bizActual);
                bgRptInfo.setBgBalance(bgBalance);
                if (bgBalance != null && bgBalance.signum() == 1) {
                    bgRptInfo.setUsableBg(bgBalance);
                } else {
                    bgRptInfo.setUsableBg(SysConstant.BIGZERO);
                }
                infoList.add(bgRptInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs2, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs2, (Statement)ps, (Connection)conn);
        return infoList;
    }

    private boolean checkFeyIsIn(List[] listItemNumberArray, Map mapItemName, String fkey, String bgItemCombinId, Map numberMap, Map nameMap) {
        for (List listItemNumber : listItemNumberArray) {
            boolean isExit = false;
            for (String number : listItemNumber) {
                if (fkey.indexOf(number + "_") < 0 && !fkey.equals(number) && fkey.indexOf("_" + number + "_") <= 0 && fkey.indexOf("_" + number) <= 0) continue;
                isExit = true;
                break;
            }
            if (isExit) continue;
            return false;
        }
        if (!numberMap.containsKey(bgItemCombinId)) {
            numberMap.put(bgItemCombinId, fkey);
            String[] number = fkey.split("_");
            String nameArr = null;
            int length = number.length;
            for (int i = 0; i < length; ++i) {
                nameArr = i == 0 ? (String)mapItemName.get(number[i]) : nameArr + "_" + (String)mapItemName.get(number[i]);
            }
            nameMap.put(bgItemCombinId, nameMap);
        }
        return true;
    }

    private void dealElement(Context ctx, Object queryFilterParam, Map bgMap, StringBuffer strBuff, List _tmpList) throws EASBizException, BOSException {
        if (queryFilterParam instanceof BgQueryFormFilterParam && ((BgQueryFormFilterParam)queryFilterParam).getElement() != null && !((BgQueryFormFilterParam)queryFilterParam).getElement().equals("")) {
            strBuff.append(" AND BgData.FBgElementId = ? ");
            _tmpList.add(((BgQueryFormFilterParam)queryFilterParam).getElement());
        } else if (queryFilterParam instanceof BgBalanceFilterParam && ((BgBalanceFilterParam)queryFilterParam).getElement() != null) {
            strBuff.append(" AND BgData.FBgElementId = ? ");
            _tmpList.add(((BgBalanceFilterParam)queryFilterParam).getElement());
        } else if (queryFilterParam instanceof BgCompareOneFilterParam && ((BgCompareOneFilterParam)queryFilterParam).getElement() != null) {
            strBuff.append(" AND BgData.FBgElementId = ? ");
            _tmpList.add(((BgCompareOneFilterParam)queryFilterParam).getElement());
        } else {
            strBuff.append(" AND BgData.FBgElementId IN ");
            if (bgMap.get("BGELEMENT") == null) {
                strBuff.append("('')");
            } else {
                Set _tmpSet = (Set)bgMap.get("BGELEMENT");
                strBuff.append("(" + BgNSQLHelper.getParamSizeString((Collection)_tmpSet) + ")");
                _tmpList.addAll(_tmpSet);
            }
        }
        strBuff.append(" \r\n");
    }

    private void dealItem(Context ctx, Object queryFilterParam, Map bgMap, StringBuffer strBuff) throws EASBizException, BOSException {
        if (queryFilterParam instanceof BgQueryFormFilterParam && ((BgQueryFormFilterParam)queryFilterParam).getItemFrom() != null) {
            String itemFrom = ((BgQueryFormFilterParam)queryFilterParam).getItemFrom();
            String itemTo = ((BgQueryFormFilterParam)queryFilterParam).getItemTo();
            String[] itemTromArray = itemFrom.split("_");
            String[] itemToArray = itemTo.split("_");
            StringBuffer itemSql = new StringBuffer("select fnumber from t_bg_bgitem where ");
            int size = itemToArray.length;
            for (int i = 0; i < size; ++i) {
                if (i == 0) {
                    itemSql.append(" fnumber >='" + itemTromArray[i] + "' and fnumber <='" + itemToArray[i] + "' ");
                    continue;
                }
                itemSql.append(" and fnumber >='" + itemTromArray[i] + "' and fnumber <='" + itemToArray[i] + "' ");
            }
            if (!((BgQueryFormFilterParam)queryFilterParam).getItemFrom().toString().equals("")) {
                strBuff.append(" AND BgItemComb.fkey >=");
                strBuff.append("'").append(((BgQueryFormFilterParam)queryFilterParam).getItemFrom()).append("'");
                strBuff.append(" AND BgItemComb.fkey <=");
                strBuff.append("'").append(((BgQueryFormFilterParam)queryFilterParam).getItemTo()).append("'");
            }
        } else if (queryFilterParam instanceof BgBalanceFilterParam && ((BgBalanceFilterParam)queryFilterParam).getItemFrom() != null) {
            if (!((BgBalanceFilterParam)queryFilterParam).getItemFrom().toString().equals("")) {
                strBuff.append(" AND BgItemComb.fkey >=");
                strBuff.append("'").append(((BgBalanceFilterParam)queryFilterParam).getItemFrom()).append("'");
                strBuff.append(" AND BgItemComb.fkey <=");
                strBuff.append("'").append(((BgBalanceFilterParam)queryFilterParam).getItemTo()).append("'");
            }
        } else if (queryFilterParam instanceof BgCompareOneFilterParam && ((BgCompareOneFilterParam)queryFilterParam).getItemFrom() != null) {
            if (!((BgCompareOneFilterParam)queryFilterParam).getItemFrom().toString().equals("")) {
                strBuff.append(" AND BgItemComb.fkey >=");
                strBuff.append("'").append(((BgCompareOneFilterParam)queryFilterParam).getItemFrom()).append("'");
                strBuff.append(" AND BgItemComb.fkey <=");
                strBuff.append("'").append(((BgCompareOneFilterParam)queryFilterParam).getItemTo()).append("'");
            }
        } else if (queryFilterParam instanceof BgTraceFilterParam && ((BgTraceFilterParam)queryFilterParam).getItemFrom() != null) {
            if (!((BgTraceFilterParam)queryFilterParam).getItemFrom().toString().equals("")) {
                strBuff.append(" AND BgItemComb.fkey >=");
                strBuff.append("'").append(((BgTraceFilterParam)queryFilterParam).getItemFrom()).append("'");
                strBuff.append(" AND BgItemComb.fkey <=");
                strBuff.append("'").append(((BgTraceFilterParam)queryFilterParam).getItemTo()).append("'");
            }
        } else {
            strBuff.append(" AND BgData.FBgItemCombinId IN ");
            if (bgMap.get("BGITEMCOMBINE") == null) {
                strBuff.append("('')");
            } else {
                strBuff.append(BgHelper.tranSet2String(((HashMap)bgMap.get("BGITEMCOMBINE")).keySet()));
            }
        }
        strBuff.append(" \r\n");
    }

    private void dealCurrency(Context ctx, CompanyOrgUnitInfo company, BgAnalysisTypeEnum rptType, Object queryFilterParam, StringBuffer strBuff, List _tmpList) throws EASBizException, BOSException {
        if (rptType.equals((Object)BgAnalysisTypeEnum.BGQUERY) || rptType.equals((Object)BgAnalysisTypeEnum.BGBALANCE) || rptType.equals((Object)BgAnalysisTypeEnum.BGTRACE)) {
            if (queryFilterParam instanceof BgQueryFormFilterParam && ((BgQueryFormFilterParam)queryFilterParam).getCurrency() == null) {
                strBuff.append(" AND BgData.FCurrencyId like ");
                strBuff.append("'%'");
            } else {
                strBuff.append(" AND BgData.FCurrencyId = ? ");
                if (queryFilterParam instanceof BgQueryFormFilterParam) {
                    _tmpList.add(((BgQueryFormFilterParam)queryFilterParam).getCurrency().getId().toString());
                } else if (queryFilterParam instanceof BgBalanceFilterParam) {
                    _tmpList.add(((BgBalanceFilterParam)queryFilterParam).getCurrency().getId().toString());
                } else if (queryFilterParam instanceof BgTraceFilterParam) {
                    _tmpList.add(((BgTraceFilterParam)queryFilterParam).getCurrency().getId().toString());
                }
            }
        } else if (rptType.equals((Object)BgAnalysisTypeEnum.BGCOMPARE)) {
            strBuff.append(" AND BgData.FCurrencyId = ? ");
            _tmpList.add(((BgCompareOneFilterParam)queryFilterParam).getCurrency().getId().toString());
        } else if (rptType.equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            strBuff.append(" AND BgData.FCurrencyId = ?");
            _tmpList.add(((BgCompareOneFilterParam)queryFilterParam).getCurrency().getId().toString());
        } else {
            strBuff.append(" AND BgData.FCurrencyId = ? ");
            _tmpList.add(BgHelper.getCompanyBaseCurrency(ctx, company).getId().toString());
        }
        strBuff.append(" \r\n");
    }

    private List getBgData4Differ(Context ctx, Object queryFilterParam) throws BOSException, EASBizException {
        BgDifferFilterParam filterParam = (BgDifferFilterParam)queryFilterParam;
        ArrayList<BgRptDataInfo2> infoList = new ArrayList<BgRptDataInfo2>();
        BgAnalysisTypeEnum rptType = filterParam.getBgRptType();
        String[] bgPeriodIds = null;
        bgPeriodIds = rptType.equals((Object)BgAnalysisTypeEnum.BGDIFFER) ? filterParam.getPeriodIds() : this.getBgPeriodIds(ctx, filterParam.getBeginPeriodId(), filterParam.getEndPeriodId());
        String bgTemplateId = (String)filterParam.getBgTemplate().keySet().toArray()[0];
        Map bgMap = this.getBgMaterialMap(ctx, bgTemplateId);
        ArrayList<Object> _tmpList = new ArrayList<Object>();
        StringBuffer strBuff = new StringBuffer("SELECT BgData.FOrgUnitId AS OrgUnitId, BgData.FBgSchemeId AS BgSchemeId, BgData.FBgTemplateId AS BgTemplateId, ");
        strBuff.append(" BgData.FBgPeriodId AS BgPeriodId, BgData.FBgItemCombinId AS BgItemCombinId, ");
        strBuff.append(" BgData.FBgElementId AS BgElementId, BgData.FCurrencyId AS CurrencyId, sum(BgData.FBgValue) AS BgValue, sum(BgData.FBizActual) AS BizActual,");
        strBuff.append(" sum(PastData.FPastValue)  as  DifferValue , BgItemCmb.FKey as ItemNumber ");
        strBuff.append(" FROM T_BG_BgData AS BgData ");
        strBuff.append(" INNER JOIN T_BG_BgForm AS BgForm ON BgData.FBgFormId=BgForm.FID ");
        strBuff.append(" INNER JOIN T_BG_BgPastData AS PastData ON PastData.FBgDataID = BgData.FID ");
        strBuff.append(" INNER JOIN T_BG_BgItemCombination   AS  BgItemCmb on   BgItemCmb.FID =  BgData.FBgItemCombinId ");
        strBuff.append(" WHERE  ");
        strBuff.append(" BgData.FOrgUnitId IN  (");
        String[] _tmps = filterParam.getOrgUnitIds();
        int in = _tmps.length;
        for (int i = 0; i < in; ++i) {
            _tmpList.add(_tmps[i]);
        }
        strBuff.append(BgNSQLHelper.getParamSizeString((int)_tmps.length));
        strBuff.append(") AND BgData.FBgSchemeId IN ");
        if (filterParam.getBgRptType().equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            Set tmpSet = filterParam.getMultiBgSchemeMap().keySet();
            _tmpList.addAll(tmpSet);
            strBuff.append("(").append(BgNSQLHelper.getParamSizeString((int)tmpSet.size())).append(")");
        } else {
            strBuff.append("( select fid from t_bg_bgscheme where frootid in ( select frootid from t_bg_bgscheme where fid = ?))");
            _tmpList.add(filterParam.getBgSchemeId());
        }
        strBuff.append(" AND BgData.FBgPeriodId IN (");
        strBuff.append(BgNSQLHelper.getParamSizeString((int)bgPeriodIds.length)).append(")");
        _tmps = bgPeriodIds;
        in = _tmps.length;
        for (int i = 0; i < in; ++i) {
            _tmpList.add(_tmps[i]);
        }
        if (!StringUtils.isEmpty((String)filterParam.getElement())) {
            String _tmp = filterParam.getElement();
            _tmps = _tmp.split(",");
            int in2 = _tmps.length;
            for (int i = 0; i < in2; ++i) {
                _tmpList.add(_tmps[i]);
            }
            strBuff.append(" AND BgData.FBgElementId in (").append(BgNSQLHelper.getParamSizeString((int)_tmps.length)).append(" ) ");
        }
        if (filterParam.getItemFrom() != null) {
            strBuff.append(" AND BgItemCmb.FKey >= ? ");
            _tmpList.add(filterParam.getItemFrom());
        }
        if (filterParam.getItemTo() != null) {
            strBuff.append(" AND BgItemCmb.FKey <= ?  ");
            _tmpList.add(filterParam.getItemTo());
        }
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (filterParam.getCurrency() != null) {
            strBuff.append(" AND BgData.FCurrencyId = ?");
            strBuff.append(" AND BgForm.FState = ?");
            _tmpList.add(filterParam.getCurrency().getId().toString());
            _tmpList.add(new Integer(2));
        } else {
            strBuff.append(" AND BgData.FCurrencyId = ?");
            strBuff.append(" AND BgForm.FState = ?");
            _tmpList.add(BgHelper.getCompanyBaseCurrency(ctx, company).getId().toString());
            _tmpList.add(new Integer(2));
        }
        strBuff.append("  group by  BgData.FOrgUnitId ,BgData.FBgSchemeId , BgData.FBgTemplateId, BgData.FBgPeriodId ,BgData.FBgItemCombinId,BgData.FBgElementId,BgData.FCurrencyId , BgItemCmb.FKey   ");
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(strBuff.toString());
            BgNSQLHelper.setParams((PreparedStatement)ps, _tmpList);
            rs = ps.executeQuery();
            BigDecimal bgValue = SysConstant.BIGZERO;
            BigDecimal bizActual = SysConstant.BIGZERO;
            BigDecimal bgBalance = SysConstant.BIGZERO;
            BigDecimal pastValue = SysConstant.BIGZERO;
            while (rs.next()) {
                BgRptDataInfo2 bgRptInfo = new BgRptDataInfo2();
                bgRptInfo.setRptDataType("CurrentPeriodAnaly");
                bgRptInfo.setBgOrgUnitId(rs.getString("OrgUnitId"));
                bgRptInfo.setBgSchemeId(rs.getString("BgSchemeId"));
                bgRptInfo.setBgPeriodId(rs.getString("BgPeriodId"));
                bgRptInfo.setBgCombinId(rs.getString("BgItemCombinId"));
                bgRptInfo.setBgCurrencyId(rs.getString("CurrencyId"));
                bgRptInfo.setBgElementId(rs.getString("BgElementId"));
                bgValue = rs.getBigDecimal("BgValue");
                bgRptInfo.setBgValue(bgValue);
                bizActual = rs.getBigDecimal("BizActual");
                bgRptInfo.setBizActual(bizActual);
                bgBalance = this.getBgBalance(bgValue, bizActual);
                bgRptInfo.setBgBalance(bgBalance);
                if (bgBalance != null && bgBalance.signum() == 1) {
                    bgRptInfo.setUsableBg(bgBalance);
                } else {
                    bgRptInfo.setUsableBg(SysConstant.BIGZERO);
                }
                bgRptInfo.setDifferValue(rs.getBigDecimal("DifferValue"));
                infoList.add(bgRptInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return infoList;
    }

    @Override
    protected Map _getSchemeMap(Context ctx, String currentOrgId, Set schemeIdSet, Set orgIdSet) throws BOSException, EASBizException {
        Map retMap = this.getCommonSchemeMap(ctx, currentOrgId, schemeIdSet, orgIdSet);
        return retMap;
    }

    private Map getCommonSchemeMap(Context ctx, String currentOrgId, Set schemeIdSet, Set orgIdSet) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String schemeId2 = null;
        Vector retVec = new Vector();
        HashSet<String> currentSchemeSet = new HashSet<String>();
        HashMap valMap = new HashMap();
        Connection connection = this.getConnection(ctx);
        for (String schemeId2 : schemeIdSet) {
            HashSet<String> retSchemeIdSet = new HashSet<String>();
            HashSet newSet = new HashSet(orgIdSet);
            this.dealSchemeByRoot(connection, newSet, schemeId2, retSchemeIdSet);
            if (orgIdSet.contains(currentOrgId)) {
                retSchemeIdSet.add(schemeId2);
            }
            if (retSchemeIdSet == null || retSchemeIdSet.size() != orgIdSet.size()) continue;
            currentSchemeSet.add(schemeId2);
            valMap.put(schemeId2, retSchemeIdSet);
            retVec.add(retSchemeIdSet);
        }
        resultMap.put("AllSchemeVec", retVec);
        resultMap.put("CurrentTemplateSet", currentSchemeSet);
        resultMap.put("RelatedSchemeMap", valMap);
        SQLUtils.cleanup((Connection)connection);
        return resultMap;
    }

    private void dealSchemeByRoot(Connection connection, Set orgIdSet, String currentSchemeId, Set schemeIdSet) throws BOSException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = "Select FID, FOrgUnitID from T_BG_BgScheme where (FRootID =(select frootid from t_bg_bgscheme where fid=?)) AND FOrgUnitID IN " + BgHelper.tranSet2String(orgIdSet);
        try {
            ps = connection.prepareStatement(sql);
            ps.setString(1, currentSchemeId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String schemeId = rs.getString(1);
                schemeIdSet.add(schemeId);
            }
        }
        catch (SQLException e) {
            try {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)connection);
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
    }

    private String getSchemeRootId(Connection connection, String currentSchemeId) throws BOSException {
        ResultSet rs;
        PreparedStatement ps;
        block4: {
            String string;
            ps = null;
            rs = null;
            try {
                String sql = " select frootid from t_bg_bgscheme where fid=? ";
                ps = connection.prepareStatement(sql);
                ps.setString(1, currentSchemeId);
                rs = ps.executeQuery();
                if (!rs.next()) break block4;
                string = rs.getString(1);
            }
            catch (SQLException e) {
                try {
                    throw new BOSException(e.toString());
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        return null;
    }

    private void dealScheme(Connection connection, Map resultMap, Set orgIdSet, String currentSchemeId, Set schemeIdSet) throws BOSException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = " select b.fid,a.fid,b.fnumber from t_bg_bgscheme a,t_org_baseunit b  where a.forgunitid=b.fid and a.fparentschemeid = ? ";
            ps = connection.prepareStatement(sql);
            ps.setString(1, currentSchemeId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String orgId = rs.getString(1);
                String schemeId = rs.getString(2);
                String orgNumber = rs.getString(3);
                if (orgIdSet.contains(orgId)) {
                    if (!resultMap.containsKey(orgId)) {
                        resultMap.put(orgId, schemeId);
                        schemeIdSet.add(schemeId);
                    }
                    orgIdSet.remove(orgId);
                }
                if (orgIdSet == null || orgIdSet.size() <= 0) continue;
                this.dealScheme(connection, resultMap, orgIdSet, schemeId, schemeIdSet);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
    }

    private void dealScheme(Context ctx, Map resultMap, Set orgIdSet, String currentSchemeId, Set schemeIdSet) throws BOSException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            String sql = " select b.fid,a.fid,b.fnumber from t_bg_bgscheme a,t_org_baseunit b  where a.forgunitid=b.fid and a.fparentschemeid = ? ";
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, currentSchemeId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String orgId = rs.getString(1);
                String schemeId = rs.getString(2);
                String orgNumber = rs.getString(3);
                if (orgIdSet.contains(orgId)) {
                    if (!resultMap.containsKey(orgId)) {
                        resultMap.put(orgId, schemeId);
                        schemeIdSet.add(schemeId);
                    }
                    orgIdSet.remove(orgId);
                }
                if (orgIdSet == null || orgIdSet.size() <= 0) continue;
                this.dealScheme(ctx, resultMap, orgIdSet, schemeId, schemeIdSet);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
    }

    @Override
    protected Map _getTemplateMap(Context ctx, Set schemeIdSet, Set templateIdSet, Set orgIdSet) throws BOSException, EASBizException {
        return this.getCommonTempalteMap(ctx, schemeIdSet, templateIdSet, orgIdSet);
    }

    private Map getCommonTempalteMap(Context ctx, Set schemeIdSet, Set templateIdSet, Set orgIdSet) throws BOSException, EASBizException {
        HashMap<String, AbstractCollection> resultMap = new HashMap<String, AbstractCollection>();
        String templateId2 = null;
        Vector retVec = new Vector();
        HashSet<String> currentTemplateSet = new HashSet<String>();
        String schemeSql = BgHelper.tranSet2String(schemeIdSet);
        String currentOrgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        Connection connection = this.getConnection(ctx);
        for (String templateId2 : templateIdSet) {
            HashMap tempMap = new HashMap();
            HashSet<String> retTemplateIdSet = new HashSet<String>();
            HashSet newSet = new HashSet(orgIdSet);
            this.dealTemplateByRoot(connection, schemeIdSet, schemeSql, tempMap, newSet, templateId2, retTemplateIdSet);
            if (orgIdSet.contains(currentOrgId)) {
                retTemplateIdSet.add(templateId2);
            }
            if (retTemplateIdSet == null || retTemplateIdSet.size() != orgIdSet.size()) continue;
            currentTemplateSet.add(templateId2);
            retTemplateIdSet.add(templateId2);
            retVec.add(retTemplateIdSet);
        }
        resultMap.put("AllSchemeVec", retVec);
        resultMap.put("CurrentTemplateSet", currentTemplateSet);
        SQLUtils.cleanup((Connection)connection);
        return resultMap;
    }

    private void dealTemplateByRoot(Connection connection, Set schemeIdSet, String schemeSql, Map resultMap, Set orgIdSet, String currentTemplateId, Set templateIdSet) throws BOSException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(" Select Template.FID, Template.FOrgUnitID from T_BG_BgTemplate AS Template ");
        strBuff.append(" INNER JOIN T_BG_BgSchemeNode AS SchemeNode ON Template.FID=SchemeNode.FBgTemplateID ");
        strBuff.append(" where (Template.FRootId =(select FRootId from T_BG_BgTemplate where fid=?)) AND FOrgUnitID IN ");
        strBuff.append(BgHelper.tranSet2String(orgIdSet));
        strBuff.append(" AND SchemeNode.FBgSchemeID IN ");
        strBuff.append(schemeSql);
        try {
            ps = connection.prepareStatement(strBuff.toString());
            ps.setString(1, currentTemplateId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString(1);
                templateIdSet.add(templateId);
            }
        }
        catch (SQLException e) {
            try {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)connection);
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
    }

    private void dealTemplate(Context ctx, Set schemeIdSet, String schemeSql, Map resultMap, Set orgIdSet, String currentTemplateId, Set templateIdSet) throws BOSException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            String sql = "select b.fid,a.fid,b.fnumber from t_bg_bgtemplate a,t_org_baseunit b, T_BG_BgSchemeNode c   where a.forgunitid=b.fid and a.fid=c.fbgtemplateid and c.fbgschemeid in " + schemeSql + " and a.fparentid = ?";
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, currentTemplateId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String orgId = rs.getString(1);
                String templateId = rs.getString(2);
                String orgNumber = rs.getString(3);
                if (orgIdSet.contains(orgId)) {
                    if (!resultMap.containsKey(orgId)) {
                        resultMap.put(orgId, templateId);
                        templateIdSet.add(templateId);
                    }
                    orgIdSet.remove(orgId);
                }
                if (orgIdSet == null || orgIdSet.size() <= 0) continue;
                this.dealTemplate(ctx, schemeIdSet, schemeSql, resultMap, orgIdSet, templateId, templateIdSet);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
    }

    private void dealTemplate(Connection connection, Set schemeIdSet, String schemeSql, Map resultMap, Set orgIdSet, String currentTemplateId, Set templateIdSet) throws BOSException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = "select b.fid,a.fid,b.fnumber from t_bg_bgtemplate a,t_org_baseunit b, T_BG_BgSchemeNode c   where a.forgunitid=b.fid and a.fid=c.fbgtemplateid and c.fbgschemeid in " + schemeSql + " and a.fparentid = ?";
            ps = connection.prepareStatement(sql);
            ps.setString(1, currentTemplateId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String orgId = rs.getString(1);
                String templateId = rs.getString(2);
                String orgNumber = rs.getString(3);
                if (orgIdSet.contains(orgId)) {
                    if (!resultMap.containsKey(orgId)) {
                        resultMap.put(orgId, templateId);
                        templateIdSet.add(templateId);
                    }
                    orgIdSet.remove(orgId);
                }
                if (orgIdSet == null || orgIdSet.size() <= 0) continue;
                this.dealTemplate(connection, schemeIdSet, schemeSql, resultMap, orgIdSet, templateId, templateIdSet);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
    }

    private BgSchemeInfo getBgScheme(Context ctx, String bgSchemeId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("dateFrom"));
        selector.add(new SelectorItemInfo("dateTo"));
        selector.add(new SelectorItemInfo("period"));
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        BgSchemeInfo bgSchemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeId), selector);
        return bgSchemeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Set getAccumPeriod(Context ctx, int bgPeriodType, Date beginDate, Date endDate) throws EASBizException, BOSException {
        String sql = " select FID from T_BG_BgPeriod where FPeriodType=? and FBeginDate>=? and FEndDate<=?";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<String> accumPeriodIdSet = new HashSet<String>();
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            ps.setInt(1, bgPeriodType);
            ps.setDate(2, TypeConversionUtils.objToDate((Object)beginDate));
            ps.setDate(3, TypeConversionUtils.objToDate((Object)endDate));
            rs = ps.executeQuery();
            while (rs.next()) {
                accumPeriodIdSet.add(rs.getString("FID"));
            }
        }
        catch (SQLException sQLException) {
            SQLUtils.cleanup(ps, (Connection)conn);
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return accumPeriodIdSet;
    }

    private BigDecimal getBgBalance(BigDecimal bgValue, BigDecimal bizActual) {
        if (bgValue != null && bizActual != null) {
            return bgValue.subtract(bizActual);
        }
        if (bgValue == null && bizActual != null) {
            return bizActual.negate();
        }
        if (bgValue != null && bizActual == null) {
            return bgValue;
        }
        return null;
    }

    private String[] getBgPeriodIds(Context ctx, String beginPeriodId, String endPeriodId) throws BOSException, EASBizException {
        if (beginPeriodId == null || endPeriodId == null) {
            return null;
        }
        BOSUuid sId = BOSUuid.read((String)beginPeriodId);
        BOSUuid eId = BOSUuid.read((String)endPeriodId);
        IBgPeriod iBgP = BgPeriodFactory.getLocalInstance(ctx);
        BgPeriodCollection bgPeiodColl = iBgP.getPeriodCollection(sId, eId);
        String[] ids = new String[bgPeiodColl.size()];
        for (int i = 0; i < bgPeiodColl.size(); ++i) {
            ids[i] = bgPeiodColl.get(i).getId().toString();
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void setOrgUnitParent(Context ctx, String[] orgUnitIds) throws BOSException, EASBizException {
        HashMap<String, String> orgUnitParentMap = new HashMap<String, String>();
        StringBuffer strBuff = new StringBuffer(" SELECT FID,FParentID FROM T_ORG_BaseUnit WHERE ");
        strBuff.append(" FID IN ");
        strBuff.append(BgHelper.tranArray2String(orgUnitIds));
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(strBuff.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                orgUnitParentMap.put(rs.getString("FID"), rs.getString("FParentID"));
            }
        }
        catch (SQLException sQLException) {
            SQLUtils.cleanup(rs, ps, (Connection)conn);
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
    }

    @Override
    protected Map _getBgBaseMap(Context ctx, String bgTemplateId) throws BOSException, EASBizException {
        BgTemplateInfo tInfo = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateInfo("select orgUnit.id where id = '" + bgTemplateId + "'");
        Map bgMap = this.getBgMaterialMap(ctx, bgTemplateId);
        HashMap bgBaseMaterial = new HashMap();
        bgBaseMaterial.put("BgItemCombinId", bgMap.get("BgItemCombinId"));
        bgBaseMaterial.put("BGITEMCOMBINE", this.getItemCombineNameByNumber(ctx, (Map)bgMap.get("BGITEMCOMBINE"), tInfo.getOrgUnit().getId().toString()));
        if (bgMap.get("BGELEMENT") != null && ((Set)bgMap.get("BGELEMENT")).size() > 0) {
            bgBaseMaterial.put("BGELEMENT", this.getBgElement(ctx, (Set)bgMap.get("BGELEMENT")));
        } else {
            bgBaseMaterial.put("BGELEMENT", null);
        }
        bgBaseMaterial.put("BGITEMCOMBINENUMBER", this.getItemCombineNumber(ctx, (Map)bgMap.get("BGITEMCOMBINE"), tInfo.getOrgUnit().getId().toString()));
        return bgBaseMaterial;
    }

    @Override
    protected Map _getBgBaseMapByForm(Context ctx, String bgFormId) throws BOSException, EASBizException {
        BgFormInfo formInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo("select orgUnit.id where id = '" + bgFormId + "'");
        Map bgMap = this.getBgMaterialMapByForm(ctx, bgFormId);
        HashMap bgBaseMaterial = new HashMap();
        bgBaseMaterial.put("BgItemCombinId", bgMap.get("BgItemCombinId"));
        bgBaseMaterial.put("BGITEMCOMBINE", this.getItemCombineNameByNumber(ctx, (Map)bgMap.get("BGITEMCOMBINE"), formInfo.getOrgUnit().getId().toString()));
        if (bgMap.get("BGELEMENT") != null && ((Set)bgMap.get("BGELEMENT")).size() > 0) {
            bgBaseMaterial.put("BGELEMENT", this.getBgElement(ctx, (Set)bgMap.get("BGELEMENT")));
        } else {
            bgBaseMaterial.put("BGELEMENT", null);
        }
        bgBaseMaterial.put("BGITEMCOMBINENUMBER", this.getItemCombineNumber(ctx, (Map)bgMap.get("BGITEMCOMBINE"), formInfo.getOrgUnit().getId().toString()));
        return bgBaseMaterial;
    }

    private Map getItemCombine(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, String> itemCombineMap = new HashMap<String, String>();
        StringBuffer strBuff = new StringBuffer(" SELECT FID,FKey FROM T_BG_BgItemCombination WHERE ");
        strBuff.append(" FID IN ");
        strBuff.append(BgHelper.tranSet2String(idSet));
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(strBuff.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                itemCombineMap.put(rs.getString("FID"), rs.getString("FKey"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return itemCombineMap;
    }

    private Map getItemCombineByNumber(Context ctx, Set numberSet) throws BOSException, EASBizException {
        HashMap<String, String> itemCombineMap = new HashMap<String, String>();
        StringBuffer strBuff = new StringBuffer(" SELECT FID,FKey FROM T_BG_BgItemCombination WHERE ");
        strBuff.append(" FKey IN ");
        strBuff.append(BgHelper.tranSet2String(numberSet));
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(strBuff.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                itemCombineMap.put(rs.getString("FID"), rs.getString("FKey"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return itemCombineMap;
    }

    private Map getItemCombineNameByNumber(Context ctx, Map combineMap, String orgUnitId) throws BOSException, EASBizException {
        LinkedHashMap<String, String> itemCombineMap = new LinkedHashMap<String, String>();
        Map itemMap = this.getItemNumber2NameMap(ctx, this.getItemNumberSet(new HashSet(combineMap.values())), orgUnitId);
        for (String itemCombineId : combineMap.keySet()) {
            String number = (String)combineMap.get(itemCombineId);
            String[] itemNumber = number.split(",");
            String itemCombineName = "";
            for (int i = 0; i < itemNumber.length; ++i) {
                itemCombineName = i == 0 ? (String)itemMap.get(itemNumber[0]) : itemCombineName + "_" + (String)itemMap.get(itemNumber[i]);
            }
            itemCombineMap.put(itemCombineId, itemCombineName);
        }
        return itemCombineMap;
    }

    private Map getItemCombineNumber(Context ctx, Map combineMap, String orgUnitId) throws BOSException, EASBizException {
        LinkedHashMap<String, String> itemCombineMap = new LinkedHashMap<String, String>();
        Map itemMap = this.getItemNumber2NameMap(ctx, this.getItemNumberSet(new HashSet(combineMap.values())), orgUnitId);
        for (String itemCombineId : combineMap.keySet()) {
            String number = (String)combineMap.get(itemCombineId);
            itemCombineMap.put(itemCombineId, number);
        }
        return itemCombineMap;
    }

    private Vector getBgElement(Context ctx, Set idSet) throws BOSException, EASBizException {
        IBgElement iBgElement = BgElementFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("dataType"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        viewInfo.getSorter().addObjectCollection((IObjectCollection)sorter);
        BgElementCollection bgElementColl = iBgElement.getBgElementCollection(viewInfo);
        Vector vec = BgHelper.tranColl2Vec((IObjectCollection)bgElementColl);
        return vec;
    }

    private Vector getBgCurrency(Context ctx, Set idSet) throws BOSException, EASBizException {
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        CurrencyCollection currencyColl = iCurrency.getCurrencyCollection(viewInfo);
        Vector vec = BgHelper.tranColl2Vec((IObjectCollection)currencyColl);
        return vec;
    }

    private Map getBgMaterialMap(Context ctx, String bgTemplateId) throws BOSException, EASBizException {
        HashMap<String, Object> bgMap = new HashMap<String, Object>();
        Map mapTEMP = BgItemQueryHelper.getCombinItemIds(ctx, bgTemplateId);
        if (mapTEMP == null || mapTEMP.isEmpty()) {
            throw new BgCommonException(BgCommonException.CHECKBGITEMCOMBINE);
        }
        Vector idVec = (Vector)mapTEMP.get("ids");
        Map itemMap = (Map)mapTEMP.get("id.to.name.map");
        if (idVec == null || idVec.isEmpty()) {
            throw new BgCommonException(BgCommonException.CHECKBGITEMCOMBINE);
        }
        bgMap.put("BGITEMCOMBINE", itemMap);
        bgMap.put("BgItemCombinId", idVec);
        mapTEMP = BgItemQueryHelper.getElementIds(ctx, bgTemplateId);
        if (mapTEMP == null || mapTEMP.isEmpty()) {
            throw new BgCommonException(BgCommonException.CHECKBGELEMENT);
        }
        idVec = (Vector)mapTEMP.get("ids");
        itemMap = (Map)mapTEMP.get("id.to.name.map");
        if (idVec == null || idVec.isEmpty()) {
            throw new BgCommonException(BgCommonException.CHECKBGELEMENT);
        }
        idVec.clear();
        bgMap.put("BGELEMENT", itemMap.keySet());
        mapTEMP = BgItemQueryHelper.getCurrencyIds(ctx, bgTemplateId);
        idVec = (Vector)mapTEMP.get("ids");
        itemMap = (Map)mapTEMP.get("id.to.name.map");
        idVec.clear();
        bgMap.put("BGCURRENCY", itemMap.keySet());
        return bgMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getBgMaterialMapByForm(Context ctx, String bgFormId) throws BOSException, EASBizException {
        HashMap<String, Object> bgMap = new HashMap<String, Object>();
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        BgFormInfo bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormId));
        try {
            KDF kdf = bgFormInfo.getKDF();
            Hashtable<String, String> keyMap = new Hashtable<String, String>();
            HashMap<String, String> tmpBgElement = new HashMap<String, String>();
            HashMap<String, String> mapCurrency = new HashMap<String, String>();
            HashMap<String, String> tmpCurrency = new HashMap<String, String>();
            Vector<Object> itemIdVector = new Vector<Object>();
            Vector<String> itemNumberVector = new Vector<String>();
            HashMap<String, String> mapBgElement = new HashMap<String, String>();
            Collection collection = kdf.getAllTable();
            IBgElement iBgE = BgElementFactory.getLocalInstance(ctx);
            ICurrency iCurr = CurrencyFactory.getLocalInstance((Context)ctx);
            if (collection != null) {
                int colletionSize = collection.size();
                for (int k = 0; k < colletionSize; ++k) {
                    KDTable table = (KDTable)kdf.getTableByIndex(k);
                    int rowCount = table.getBody().size();
                    int colCount = table.getColumnCount();
                    for (int i = 0; i < rowCount; ++i) {
                        for (int j = 0; j < colCount; ++j) {
                            String currencyId;
                            String bgElementId;
                            RptCell rCell;
                            String itemFormula;
                            List list;
                            ICell cell = table.getCell(i, j);
                            if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell) || (list = TableToolkit.parseFormula((String)(itemFormula = (rCell = (RptCell)cell.getUserObject()).getItemFormulaLine()), (boolean)false)) == null || list.isEmpty()) continue;
                            FormulaHint hint = (FormulaHint)list.get(0);
                            String[] params = hint.getParams();
                            if (params[0] == null) {
                                throw new BgTemplateException(BgTemplateException.BGITEMERROR_ITEM, new Object[]{"" + (i + 1), "" + (j + 1)});
                            }
                            if (params[0].equals("")) {
                                throw new BgTemplateException(BgTemplateException.BGITEMERROR_ITEM, new Object[]{"" + (i + 1), "" + (j + 1)});
                            }
                            if (!keyMap.containsKey(params[0])) {
                                String key = this.getCombinKey(params[0]);
                                keyMap.put(params[0], key);
                                itemNumberVector.add(params[0]);
                            }
                            if (tmpBgElement.containsKey(params[2])) {
                                bgElementId = (String)tmpBgElement.get(params[2]);
                                if (bgElementId != null && !bgElementId.equals("")) {
                                    mapBgElement.put(bgElementId, bgElementId);
                                }
                            } else {
                                bgElementId = this.getBgElementId(params[2], iBgE, i, j);
                                if (bgElementId != null && !bgElementId.equals("")) {
                                    tmpBgElement.put(params[2], bgElementId);
                                    if (!mapBgElement.containsKey(bgElementId)) {
                                        mapBgElement.put(bgElementId, bgElementId);
                                    }
                                }
                            }
                            if (tmpCurrency.containsKey(params[5])) {
                                currencyId = (String)tmpCurrency.get(params[5]);
                                if (currencyId == null || currencyId.equals("")) continue;
                                mapCurrency.put(currencyId, currencyId);
                                continue;
                            }
                            currencyId = this.getCurrencyId(params[5], iCurr, i, j);
                            if (currencyId == null || currencyId.equals("")) continue;
                            tmpCurrency.put(params[5], currencyId);
                            if (mapCurrency.containsKey(currencyId)) continue;
                            mapCurrency.put(currencyId, currencyId);
                        }
                    }
                }
            }
            Vector<String> keysVec = new Vector<String>();
            int h = 1;
            int GROUPSIZE = 50;
            String keys = " ( ''";
            for (Object obj : keyMap.keySet()) {
                String key = (String)keyMap.get(obj);
                keys = keys + ",'" + key + "'";
                if (++h != GROUPSIZE) continue;
                h = 1;
                keys = keys + " )";
                keysVec.add(keys);
                keys = " ( ''";
            }
            if (h < GROUPSIZE && h != 1) {
                keys = keys + " )";
                keysVec.add(keys);
            }
            Hashtable existCombinMap = new Hashtable();
            for (h = 0; h < keysVec.size(); ++h) {
                keys = (String)keysVec.get(h);
                this.getExistCombin(ctx, keys, existCombinMap, GROUPSIZE);
            }
            for (Object obj : existCombinMap.keySet()) {
                if (!keyMap.containsKey(obj)) continue;
                keyMap.remove(obj);
            }
            if (!keyMap.isEmpty()) {
                Hashtable<String, String> bgItemMap = new Hashtable<String, String>();
                for (String obj : keyMap.keySet()) {
                    String[] strs = obj.split(",");
                    for (int i = 0; i < strs.length; ++i) {
                        if (bgItemMap.containsKey(strs[i])) continue;
                        bgItemMap.put(strs[i], "");
                    }
                }
                BgNFSHelper.getRefField((Context)ctx, bgItemMap, (String)bgFormInfo.getOrgUnit().getId().toString());
                this.checkBgItemHasField(bgItemMap);
                Hashtable newCombinMap = this.insertNewCombin(ctx, keyMap, bgItemMap);
                for (int i = 0; i < itemNumberVector.size(); ++i) {
                    if (existCombinMap.containsKey(itemNumberVector.get(i))) {
                        itemIdVector.add(existCombinMap.get(itemNumberVector.get(i)));
                        continue;
                    }
                    if (newCombinMap.containsKey(itemNumberVector.get(i))) {
                        itemIdVector.add(newCombinMap.get(itemNumberVector.get(i)));
                        continue;
                    }
                    itemIdVector.add("");
                }
            } else {
                for (int i = 0; i < itemNumberVector.size(); ++i) {
                    if (existCombinMap.containsKey(itemNumberVector.get(i))) {
                        itemIdVector.add(existCombinMap.get(itemNumberVector.get(i)));
                        continue;
                    }
                    itemIdVector.add("");
                }
            }
            if (itemIdVector == null || itemNumberVector == null) {
                throw new BgCommonException(BgCommonException.CHECKBGITEMCOMBINE);
            }
            if (mapBgElement == null) {
                throw new BgCommonException(BgCommonException.CHECKBGELEMENT);
            }
            HashMap itemMap = new HashMap();
            for (int i = 0; i < itemIdVector.size(); ++i) {
                itemMap.put(itemIdVector.get(i), itemNumberVector.get(i));
            }
            bgMap.put("BGITEMCOMBINE", itemMap);
            bgMap.put("BgItemCombinId", itemIdVector);
            bgMap.put("BGELEMENT", mapBgElement.keySet());
            bgMap.put("BGCURRENCY", mapCurrency);
        }
        catch (IOException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (KDFException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        finally {
            bgFormInfo.clear();
        }
        return bgMap;
    }

    private String getCombinKey(String combinStr) {
        if (combinStr == null) {
            return "";
        }
        return combinStr.replaceAll(",", "_");
    }

    private String getCurrencyId(String currencyNumber, ICurrency curr, int i, int j) throws EASBizException, BOSException {
        if (currencyNumber.equals("")) {
            return null;
        }
        ObjectBaseInfo currency = null;
        try {
            currency = curr.getObjectBaseInfo("select id where number='" + currencyNumber + "'");
        }
        catch (BOSException e) {
            throw new BgTemplateException(BgTemplateException.BGITEMERROR_CURRENCY, new Object[]{"" + (i + 1), "" + (j + 1)});
        }
        catch (EASBizException e) {
            throw new BgTemplateException(BgTemplateException.BGITEMERROR_CURRENCY, new Object[]{"" + (i + 1), "" + (j + 1)});
        }
        return currency.getId().toString();
    }

    private void getExistCombin(Context ctx, String keys, Hashtable result, int maxKeySize) throws BOSException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        if (result == null) {
            result = new Hashtable<String, String>();
        }
        try {
            keys = keys.replaceAll("\\(", "");
            keys = keys.replaceAll("\\)", "");
            String sql = "select fid ,fkey from t_bg_bgItemCombination where fkey = ? ";
            for (int i = 1; i < maxKeySize; ++i) {
                sql = sql + " or fkey = ? ";
            }
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            String[] strs = keys.split(",");
            int index = 1;
            for (int i = 0; i < strs.length; ++i) {
                ps.setString(index, strs[i].replaceAll("'", "").trim());
                ++index;
            }
            while (index <= maxKeySize) {
                ps.setString(index, "");
                ++index;
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                result.put(rs.getString(2).replaceAll("_", ","), rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
    }

    private String getBgElementId(String bgElementNumber, IBgElement bgE, int i, int j) throws EASBizException, BOSException {
        BgElementInfo element = null;
        try {
            element = bgE.getBgElementInfo("select id where number='" + bgElementNumber + "'");
        }
        catch (BOSException e) {
            throw new BgTemplateException(BgTemplateException.BGITEMERROR_ELEMENT, new Object[]{"" + (i + 1), "" + (j + 1)});
        }
        catch (EASBizException e) {
            throw new BgTemplateException(BgTemplateException.BGITEMERROR_ELEMENT, new Object[]{"" + (i + 1), "" + (j + 1)});
        }
        return element.getId().toString();
    }

    private Hashtable insertNewCombin(Context ctx, Hashtable keyMap, Hashtable bgItemMap) throws BOSException {
        PreparedStatement ps = null;
        Connection connection = null;
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            int i;
            String field;
            String combinStr2 = "";
            connection = this.getConnection(ctx);
            Vector<String> fieldVec = new Vector<String>();
            for (Object obj : bgItemMap.keySet()) {
                field = (String)bgItemMap.get(obj);
                if (fieldVec.contains(field)) continue;
                fieldVec.add(field);
            }
            String sql = " insert into t_bg_bgItemCombination( fid ,";
            for (i = 0; i < fieldVec.size(); ++i) {
                field = fieldVec.get(i);
                sql = sql + field + " , ";
            }
            sql = sql + " fkey ) ";
            sql = sql + " values( ? , ";
            for (i = 0; i < fieldVec.size(); ++i) {
                sql = sql + " ? , ";
            }
            sql = sql + " ? ) ";
            ps = connection.prepareStatement(sql);
            for (String combinStr2 : keyMap.keySet()) {
                String[] strs = combinStr2.split(",");
                String fid = Uuid.create().toString() + "ABCDEFGH";
                result.put(combinStr2, fid);
                String key = combinStr2.replaceAll(",", "_");
                ps.setString(1, fid);
                int k = 2;
                for (int j = 0; j < fieldVec.size(); ++j) {
                    String _refField = (String)fieldVec.get(j);
                    int pot = -1;
                    for (int i2 = 0; i2 < strs.length; ++i2) {
                        String refField = (String)bgItemMap.get(strs[i2]);
                        if (!_refField.equals(refField)) continue;
                        pot = i2;
                        break;
                    }
                    if (pot == -1) {
                        ps.setString(k, null);
                    } else {
                        ps.setString(k, strs[pot]);
                    }
                    ++k;
                }
                ps.setString(k, key);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
        return result;
    }

    private void checkBgItemHasField(Hashtable bgItemMap) throws BgTemplateException {
        for (Object key : bgItemMap.keySet()) {
            String value = (String)bgItemMap.get(key);
            if (!value.equals("")) continue;
            throw new BgTemplateException(BgTemplateException.EXISTERRORBGITEM, new Object[]{key});
        }
    }

    private Map getItemNumber2NameMap(Context ctx, Set numberSet, String orgUnitId) throws BOSException, EASBizException {
        LinkedHashMap<String, String> itemMap = new LinkedHashMap<String, String>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg(ctx, orgUnitId), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        SorterItemInfo sore = new SorterItemInfo("number");
        sore.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sore);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        IBgItem iBgItem = BgItemFactory.getLocalInstance(ctx);
        BgItemCollection bgItemColl = iBgItem.getBgItemCollection(viewInfo);
        if (bgItemColl != null && bgItemColl.size() > 0) {
            for (int i = 0; i < bgItemColl.size(); ++i) {
                BgItemInfo bgItemInfo = bgItemColl.get(i);
                itemMap.put(bgItemInfo.getNumber(), bgItemInfo.getName());
            }
        }
        return itemMap;
    }

    private BgItemCollection getBgItemCollByNumberSet(Context ctx, Set numberSet) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberSet, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("mapData"));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        IBgItem iBgItem = BgItemFactory.getLocalInstance(ctx);
        BgItemCollection bgItemColl = iBgItem.getBgItemCollection(viewInfo);
        return bgItemColl;
    }

    private Set getItemNumberSet(Set itemCombinNumberSet) {
        HashSet itemNumberSet = new HashSet();
        for (String itemCombine : itemCombinNumberSet) {
            if (itemCombine == null) continue;
            BgHelper.addArray2Set(itemNumberSet, itemCombine.split(","));
        }
        return itemNumberSet;
    }

    @Override
    protected Map _getBgItemCombine4Differ(Context ctx, String strItemSQL, String orgUnitId) throws BOSException, EASBizException {
        HashMap<String, Cloneable> bgMap = new HashMap<String, Cloneable>();
        Vector<String> itemIdSet = new Vector<String>();
        LinkedHashMap<String, String> itemNameSet = new LinkedHashMap<String, String>();
        HashMap<String, String> itemNumSet = new HashMap<String, String>();
        String sql = strItemSQL;
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.createStatement();
            rs = ps.executeQuery(sql);
            while (rs.next()) {
                itemIdSet.add(rs.getString("FBgItemCombineID"));
                itemNumSet.put(rs.getString("FBgItemCombineID"), rs.getString("FBgItemCombineNum"));
            }
            HashSet<String> itemNumberSet = new HashSet<String>();
            String itemCombine = null;
            Iterator iter = itemNumSet.keySet().iterator();
            while (iter.hasNext()) {
                itemCombine = (String)itemNumSet.get(iter.next());
                if (itemCombine == null) continue;
                String[] st = itemCombine.split("_");
                for (int m = 0; m < st.length; ++m) {
                    itemNumberSet.add(st[m]);
                }
            }
            HashMap<String, String> itemMap = new HashMap<String, String>();
            if (itemNumberSet.size() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", itemNumberSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgSHelper.getIsolateOrg(ctx, orgUnitId), CompareType.EQUALS));
                viewInfo.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("number"));
                selector.add(new SelectorItemInfo("name"));
                SorterItemInfo sore = new SorterItemInfo("number");
                sore.setSortType(SortType.ASCEND);
                viewInfo.getSorter().add(sore);
                viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
                IBgItem iBgItem = BgItemFactory.getLocalInstance(ctx);
                BgItemCollection bgItemColl = iBgItem.getBgItemCollection(viewInfo);
                if (bgItemColl != null && bgItemColl.size() > 0) {
                    for (int i = 0; i < bgItemColl.size(); ++i) {
                        BgItemInfo bgItemInfo = bgItemColl.get(i);
                        itemMap.put(bgItemInfo.getNumber(), bgItemInfo.getName());
                    }
                }
                for (String itemCombineId : itemNumSet.keySet()) {
                    String number = (String)itemNumSet.get(itemCombineId);
                    String[] itemNumber = number.split("_");
                    String itemCombineName = "";
                    for (int i = 0; i < itemNumber.length; ++i) {
                        itemCombineName = i == 0 ? (String)itemMap.get(itemNumber[0]) : itemCombineName + "_" + itemMap.get(itemNumber[i]);
                    }
                    itemNameSet.put(itemCombineId, itemCombineName);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        bgMap.put("BgItemCombineNum", itemNumSet);
        bgMap.put("BgItemCombinId", itemIdSet);
        bgMap.put("BgItemCombineName", itemNameSet);
        return bgMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getBgItemNumberByID(Context ctx, Object parameInfo) throws BOSException, BgItemException {
        BgBalanceFilterParam parm = (BgBalanceFilterParam)parameInfo;
        String sql = " select fid FROM T_BG_BgItemCombination where fkey >= ? and fkey <= ? ";
        ArrayList<String> list = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, parm.getItemFrom());
            ps.setString(2, parm.getItemTo());
            rs = ps.executeQuery();
            while (rs.next()) {
                if (rs.getString("fid") == null) continue;
                list.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String _getElementNamebyId(Context ctx, String elementId) throws BOSException, BgElementException {
        conn = null;
        ps = null;
        rs = null;
        conn = this.getConnection(ctx);
        sql = "SELECT * FROM T_BG_BgElement where fid= ?";
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, elementId);
            rs = ps.executeQuery();
            while (rs.next()) {
                if (rs.getString("fname_l2") == null) continue;
                var7_7 = rs.getString("fname_l2");
                ** GOTO lbl22
            }
            ** GOTO lbl24
        }
        catch (SQLException e) {
            try {
                BgRptFacadeControllerBean.logger.error((Object)"budget error:", (Throwable)e);
            }
            catch (Throwable var8_9) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw var8_9;
            }
lbl22:
            // 1 sources

            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
            return var7_7;
lbl24:
            // 1 sources

            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
            return null;
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getCurrencyNameById(Context ctx, String currencyId) throws BOSException, BgException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        conn = this.getConnection(ctx);
        String sql = "SELECT * FROM T_BD_Currency where fid= ?";
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, currencyId);
            rs = ps.executeQuery(sql);
            while (rs.next()) {
                if (rs.getString("fname_l2") == null) continue;
                String string = rs.getString("fname_l2");
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
                return string;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
        }
        return null;
    }

    @Override
    protected BgTraceInfoContainter _getTraceInfoByBgDataId(Context ctx, List bgDataIdList) throws BOSException, BgException {
        HashMap dump = new HashMap();
        for (int i = 0; i < bgDataIdList.size(); ++i) {
            dump.put(bgDataIdList.get(i).toString(), null);
        }
        Map groupMap = this._getGroupBgDataId(ctx, dump);
        Iterator itr = groupMap.keySet().iterator();
        while (itr.hasNext()) {
            String groupNo = itr.next().toString();
            Map bgDatas = (Map)groupMap.get(groupNo);
            dump.putAll(bgDatas);
        }
        BgTraceInfoContainter container = new BgTraceInfoContainter();
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        conn = this.getConnection(ctx);
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT a.fbgdataid as bgDataID,");
        kSql.append("        a.fbgdataid,");
        kSql.append("        a.FActualAmount,");
        kSql.append("        a.FBillType,");
        kSql.append("        a.FBizDate,");
        kSql.append("        a.FBgPeriodId,");
        kSql.append("        a.FBillId,");
        kSql.append("        a.FItemName,");
        kSql.append("        a.FBillNumber,");
        kSql.append("        a.fbgtracetype as traceType,");
        kSql.append("        a.FActualType as actualType,");
        kSql.append("        b.fformula as formula,");
        kSql.append("        b.FBizActual as bizActual,");
        kSql.append("        b.fbgValue as bgValue,");
        kSql.append("        b.fiscontrol as isControl,");
        kSql.append("        b.fisflexible as isFlexible,");
        kSql.append("        b.fflexparam as flexParam,");
        kSql.append("        b.fctrltype as ctrltype,");
        kSql.append("        currency.FName_l2 currName,");
        kSql.append("        a.FCreateTime createTime,");
        kSql.append("        currency.fprecision cision");
        kSql.append("   FROM T_BG_BgCtrlRecord      a,");
        kSql.append("        t_bg_bgdata            b,");
        kSql.append("        t_bg_bgitemcombination c,");
        kSql.append("        T_BD_Currency          currency");
        kSql.append("  where currency.fid = b.FCurrencyId");
        kSql.append("    and a.fbgdataid = b.fid");
        kSql.append("    and b.fbgitemcombinid = c.fid");
        if (dump.isEmpty()) {
            kSql.append("    and 1 = 2");
        } else {
            kSql.append("    and b.Fid in " + BgHelper.tranSet2String(dump.keySet()));
        }
        kSql.append("  order by c.fkey,a.FBgPeriodId,b.fisgroupctrl asc ,b.fgroupno, b.FBgElementId,a.FBizDate,a.FBillNumber");
        try {
            ps = conn.createStatement();
            rs = ps.executeQuery(kSql.toString());
            while (rs.next()) {
                List<BgTraceInfo> tempList;
                BigDecimal actualVal;
                BgTraceInfo info = new BgTraceInfo();
                info.setFormula(rs.getString("formula"));
                info.setTraceType(rs.getInt("traceType"));
                info.setAmount(rs.getBigDecimal("FActualAmount"));
                info.setBillType(rs.getString("FBillType"));
                info.setDate(rs.getDate("FBizDate").toString());
                info.setPeriod(rs.getString("FBgPeriodId"));
                info.setBillid(rs.getString("FBillId"));
                info.setItem(rs.getString("FItemName"));
                info.setBillNum(rs.getString("FBillNumber"));
                info.setCurrency(rs.getString("currName"));
                info.setPrecision(rs.getInt("cision"));
                info.setCtrlDate(rs.getDate("createTime").toString());
                info.setActualType(rs.getInt("actualType"));
                BigDecimal bgVal = rs.getBigDecimal("bgValue");
                if (bgVal == null) {
                    bgVal = ZERO;
                }
                if ((actualVal = rs.getBigDecimal("bizActual")) == null) {
                    actualVal = ZERO;
                }
                info.setBgValue(bgVal);
                info.setBgAcutal(actualVal);
                info.setIscontrol(rs.getInt("isControl"));
                info.setIsflexible(rs.getInt("isFlexible"));
                info.setFlexparam(rs.getBigDecimal("flexParam"));
                info.setCtrltype(rs.getInt("ctrltype"));
                String bgDataID = rs.getString("bgDataID");
                info.setBgDataID(bgDataID);
                if (container.keyList().contains(bgDataID)) {
                    tempList = (List)container.get(bgDataID);
                    tempList.add(info);
                    continue;
                }
                tempList = new ArrayList();
                tempList.add(info);
                container.put(bgDataID, tempList);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return container;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected Map _getGroupBgDataId(Context ctx, Map bgDataIds) throws BOSException, BgException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected Map _getBgItemNameById(Context ctx, Set idset, String orgUnitId) throws BOSException {
        for (String string : idset) {
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected Map _getBgItemCombine(Context ctx, String itemSql, List combinIdList, String orgUnitId) throws BOSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected Vector _getBgElementFromSchema(Context ctx, String schemaid) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT distinct FBgElementId FROM T_BG_BgData  where FBgSchemeId in ( select fid from t_bg_bgscheme where frootid = '" + schemaid + "') or fbgschemeid = '" + schemaid + "'"));
        String elementids = "";
        try {
            while (rs.next()) {
                elementids = elementids + "'" + rs.getString(1) + "' ,";
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (rs.size() <= 0) {
            return new Vector();
        }
        elementids = elementids.substring(0, elementids.length() - 1);
        IBgElement ibg = BgElementFactory.getLocalInstance(ctx);
        BgElementCollection bec = ibg.getBgElementCollection(" where id in( " + elementids + " ) ");
        Vector<BgElementInfo> v = new Vector<BgElementInfo>();
        for (int i = 0; i < bec.size(); ++i) {
            v.add(bec.get(i));
        }
        return v;
    }

    @Override
    protected boolean _updateBizActual(Context ctx, String strOrgUnitID, int intYear, String strBgCombineItemNum, String strBgElementNum, String strCurrencyNum, BigDecimal bizActual) throws BOSException, EASBizException {
        BgFormInfo bgform;
        if (this.iBgForm == null) {
            this.iBgForm = BgFormFactory.getLocalInstance(ctx);
        }
        if ((bgform = this.iBgForm.getBgFormInfo(" where orgUnit.id='" + strOrgUnitID + "'  and bgScheme.isFormal=true and bgPeriod.periodType=" + (Object)((Object)BgPeriodEnum.YEAR) + " and bgPeriod.year=" + intYear)) == null) {
            return false;
        }
        String strFormID = bgform.getId().toString();
        String strSchemaID = bgform.getBgScheme().getId().toString();
        String strFormula = "=BgItem(\"" + strBgCombineItemNum + "\",\"" + intYear + "Y\",\"" + strBgElementNum + "Y\",\"BgData\",true,\"" + strCurrencyNum + "\")";
        DbUtil.execute((Context)ctx, (String)(" update t_bg_bgdata set fbizactual=" + bizActual.toString() + " where forgunitid='" + strOrgUnitID + "'  and   fbgschemeid='" + strSchemaID + "'  and   fformula='" + strFormula + "' "));
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected BigDecimal[] _getBgData(Context ctx, BOSUuid orgUnitId, BOSUuid bgSchemeId, Set formulaSet) throws BOSException, EASBizException {
        BigDecimal[] value = new BigDecimal[]{BgConstants.BIGZERO, BgConstants.BIGZERO};
        if (orgUnitId == null) return value;
        if (bgSchemeId == null) return value;
        if (formulaSet == null) return value;
        if (formulaSet.isEmpty()) {
            return value;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(FBgValue), sum(FBizActual) from T_BG_BgData where FOrgUnitId = ? and FBgSchemeId = ? and FFormula in (");
        Iterator iter = formulaSet.iterator();
        while (iter.hasNext()) {
            sql.append(iter.next() + ",");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(")");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgUnitId.toString());
            pstmt.setString(2, bgSchemeId.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                value[0] = rst.getBigDecimal(1) == null ? BgConstants.BIGZERO : rst.getBigDecimal(1);
                value[1] = rst.getBigDecimal(2) == null ? BgConstants.BIGZERO : rst.getBigDecimal(2);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return value;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected BigDecimal[] _getBgData(Context ctx, BOSUuid orgUnitId, BOSUuid bgSchemeRootId, Set formulaSet, boolean isRoot) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        BigDecimal[] value;
        block9: {
            value = new BigDecimal[]{BgConstants.BIGZERO, BgConstants.BIGZERO};
            if (orgUnitId == null) return value;
            if (bgSchemeRootId == null) return value;
            if (formulaSet == null) return value;
            if (formulaSet.isEmpty()) {
                return value;
            }
            conn = null;
            pstmt = null;
            rst = null;
            try {
                if (isRoot) {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement("select FID from T_BG_BgScheme where FOrgUnitId = ? and FRootId = ?");
                    pstmt.setString(1, orgUnitId.toString());
                    pstmt.setString(2, bgSchemeRootId.toString());
                    rst = pstmt.executeQuery();
                    if (rst.next()) {
                        String bgSchemeId = rst.getString(1);
                        value = this._getBgData(ctx, orgUnitId, BOSUuid.read((String)bgSchemeId), formulaSet);
                    }
                    break block9;
                }
                value = this._getBgData(ctx, orgUnitId, bgSchemeRootId, formulaSet);
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                    catch (EASBizException ex2) {
                        throw ex2;
                    }
                    catch (BOSException ex3) {
                        throw ex3;
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return value;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected BOSUuid _getChildBgScheme(Context ctx, BOSUuid bgSchemeRootId, BOSUuid orgUniId) throws BOSException, EASBizException {
        if (bgSchemeRootId == null) return null;
        if (orgUniId == null) {
            return null;
        }
        BOSUuid id = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID from T_BG_BgScheme where FOrgUnitId = ? and FRootId = ?");
            pstmt.setString(1, orgUniId.toString());
            pstmt.setString(2, bgSchemeRootId.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                id = BOSUuid.read((String)rst.getString(1));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return id;
    }

    @Override
    protected Vector _getBgItemCombinSortByCombinKey(Context ctx, Vector itemCombinVec) throws BOSException, EASBizException {
        Vector<String> result = new Vector<String>();
        Vector<String> keysVec = new Vector<String>();
        int h = 1;
        int GROUPSIZE = 50;
        String keys = " ( ''";
        for (int i = 0; itemCombinVec != null && i < itemCombinVec.size(); ++i) {
            String key = (String)itemCombinVec.get(i);
            keys = keys + ",'" + key + "'";
            if (++h != GROUPSIZE) continue;
            h = 1;
            keys = keys + " )";
            keysVec.add(keys);
            keys = " ( ''";
        }
        if (h < GROUPSIZE && h != 1) {
            keys = keys + " )";
            keysVec.add(keys);
        }
        IRowSet rs = null;
        String sql = null;
        for (h = 0; h < keysVec.size(); ++h) {
            keys = (String)keysVec.get(h);
            sql = "select fid from t_bg_bgitemcombination where fid in " + keys + " order by fkey";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        SQLUtils.cleanup(rs);
        return result;
    }

    @Override
    protected List _filterBgDataId(Context ctx, List bgDataIdList, String orgId) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        Vector<String> keysVec = new Vector<String>();
        int h = 1;
        int GROUPSIZE = 50;
        String keys = " ( ''";
        for (int i = 0; i < bgDataIdList.size(); ++i) {
            String key = (String)bgDataIdList.get(i);
            keys = keys + ",'" + key + "'";
            if (++h != GROUPSIZE) continue;
            h = 1;
            keys = keys + " )";
            keysVec.add(keys);
            keys = " ( ''";
        }
        if (h < GROUPSIZE && h != 1) {
            keys = keys + " )";
            keysVec.add(keys);
        }
        for (h = 0; h < keysVec.size(); ++h) {
            keys = (String)keysVec.get(h);
            List tmp = this.getBgDataByOrg(ctx, keys, orgId);
            for (int i = 0; tmp != null && i < tmp.size(); ++i) {
                result.add(tmp.get(i));
            }
        }
        return result;
    }

    private List getBgDataByOrg(Context ctx, String keys, String orgId) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        String sql = "select fid from t_bg_bgdata  where forgunitid = ? and fid in " + keys;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{orgId});
        try {
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _bgschemehasform(Context ctx, String orgId, String bgSchemeRootId, String bgTemRootId) throws BOSException, EASBizException {
        IRowSet rst = null;
        int cnt = 0;
        String sql = "select count(a.fid) cnt  from t_bg_bgform a ,t_bg_bgscheme b ,t_bg_bgtemplate c  where a.fbgschemeid = b.fid and b.forgunitid = ? and b.frootid = ? and  a.fbgtemplateid = c.fid and c.forgunitid = ? and c.frootid = ? and  a.forgunitid = ? ";
        try {
            rst = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{orgId, bgSchemeRootId, orgId, bgTemRootId, orgId});
            if (rst.next()) {
                cnt = rst.getInt(1);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return cnt > 0;
    }

    @Override
    protected Map _getBgItemCombine4DifferByNumber(Context ctx, Object queryFilterParam) throws BOSException, EASBizException {
        int i;
        BgRptFilterParam filterParam = (BgRptFilterParam)queryFilterParam;
        SimpleTimer time = new SimpleTimer();
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"46_BgRptFacadeControllerBean", (Locale)ctx.getLocale()) + time.getTime()));
        HashMap<String, Cloneable> bgMap = new HashMap<String, Cloneable>();
        Vector itemIdSet = new Vector();
        LinkedHashMap itemNameMap = new LinkedHashMap();
        LinkedHashMap<String, String> itemNumMap = new LinkedHashMap<String, String>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = "SELECT  fid as BgItemCombinId, fkey as FBgItemCombineNum  FROM  T_BG_BgItemCombination order by fkey asc";
        boolean isDealItem = false;
        String itemFrom = null;
        String itemTo = null;
        if (queryFilterParam instanceof BgCompareOneFilterParam) {
            itemFrom = ((BgCompareOneFilterParam)queryFilterParam).getItemFrom();
            itemTo = ((BgCompareOneFilterParam)queryFilterParam).getItemTo();
        } else if (queryFilterParam instanceof BgBalanceFilterParam) {
            itemFrom = ((BgBalanceFilterParam)queryFilterParam).getItemFrom();
            itemTo = ((BgBalanceFilterParam)queryFilterParam).getItemTo();
        } else {
            itemFrom = ((BgQueryFormFilterParam)queryFilterParam).getItemFrom();
            itemTo = ((BgQueryFormFilterParam)queryFilterParam).getItemTo();
        }
        List[] listItemNumber = null;
        LinkedHashMap<String, String> mapItemName = new LinkedHashMap<String, String>();
        if (itemFrom != null || itemTo != null) {
            isDealItem = true;
            String[] itemTromArray = null;
            itemTromArray = itemFrom != null ? itemFrom.split("_") : new String[]{};
            String[] itemToArray = null;
            itemToArray = itemTo != null ? itemTo.split("_") : new String[]{};
            int size = itemTromArray.length <= itemToArray.length ? itemTromArray.length : itemToArray.length;
            listItemNumber = new List[size];
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"47_BgRptFacadeControllerBean", (Locale)ctx.getLocale()) + time.getTime()));
            for (i = 0; i < size; ++i) {
                ArrayList<String> listItemNumberTemp = new ArrayList<String>();
                StringBuffer itemSql = new StringBuffer("select fnumber,fname_" + ctx.getLocale() + " fname from t_bg_bgitem order by fnumber asc");
                try {
                    conn = this.getConnection(ctx);
                    ps = conn.prepareStatement(itemSql.toString());
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        String number = rs.getString("fnumber");
                        if (number.compareTo(itemTromArray[i]) >= 0 && number.compareTo(itemToArray[i]) <= 0) {
                            listItemNumberTemp.add(number);
                        }
                        mapItemName.put(number, rs.getString("fname"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
                }
                listItemNumber[i] = listItemNumberTemp;
            }
        }
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"48_BgRptFacadeControllerBean", (Locale)ctx.getLocale()) + time.getTime()));
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String fkey = rs.getString("FBgItemCombineNum");
                String bgItemCombinId = rs.getString("BgItemCombinId");
                if (isDealItem && !this.checkFeyIsIn(listItemNumber, fkey)) continue;
                itemNumMap.put(bgItemCombinId, fkey);
                String[] name = fkey.split("_");
                int length = name.length;
                for (i = 0; i < length; ++i) {
                    if (i == 0) {
                        itemNameMap.put(bgItemCombinId, mapItemName.get(name[i]));
                        continue;
                    }
                    itemNameMap.put(bgItemCombinId, ((HashMap)itemNameMap).get(bgItemCombinId) + "_" + mapItemName.get(name[i]));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        bgMap.put("BgItemCombineNum", itemNumMap);
        bgMap.put("BgItemCombinId", itemIdSet);
        bgMap.put("BgItemCombineName", itemNameMap);
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"49_BgRptFacadeControllerBean", (Locale)ctx.getLocale()) + time.getTime()));
        return bgMap;
    }

    private boolean checkFeyIsIn(List[] listItemNumberArray, String fkey) {
        for (List listItemNumber : listItemNumberArray) {
            boolean isExit = false;
            for (String number : listItemNumber) {
                if (fkey.indexOf(number + "_") < 0 && !fkey.equals(number) && fkey.indexOf("_" + number + "_") <= 0 && fkey.indexOf("_" + number) <= 0) continue;
                isExit = true;
                break;
            }
            if (isExit) continue;
            return false;
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _getBgItemCombinByIds(Context ctx, List bgItemCombinIds, String orgUnitId) throws BOSException, EASBizException {
        HashMap<String, Cloneable> bgItemMap = null;
        Map _bgItemMap = null;
        HashMap<String, String> bgItemNumMap = null;
        HashMap<String, String> bgItemNameMap = null;
        HashMap _bgItemNumMap = null;
        Vector<String> bgItemIdVec = null;
        bgItemMap = new HashMap<String, Cloneable>();
        bgItemNumMap = new HashMap<String, String>();
        _bgItemNumMap = new HashMap();
        bgItemNameMap = new HashMap<String, String>();
        bgItemIdVec = new Vector<String>();
        VisualItemInfo visItemInfo = null;
        bgItemMap.put("BgItemCombineNum", bgItemNumMap);
        bgItemMap.put("BgItemCombineName", bgItemNameMap);
        bgItemMap.put("BgItemCombinId", bgItemIdVec);
        if (bgItemCombinIds == null) return bgItemMap;
        if (bgItemCombinIds.isEmpty()) {
            return bgItemMap;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchNum = 50;
        int size = bgItemCombinIds.size();
        int count = (size - 1) / batchNum + 1;
        int pos = 0;
        String noFindStr = "#";
        String bgItemId2222222 = null;
        String bgItemNum = null;
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select FID, FKey from T_BG_BgItemCombination where FID IN (");
        for (index = 1; index < batchNum; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int k = 1; k <= batchNum; ++k, ++pos) {
                    if (pos < size) {
                        pstmt.setString(k, (String)bgItemCombinIds.get(pos));
                        continue;
                    }
                    pstmt.setString(k, noFindStr);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgItemId2222222 = rst.getString("FID");
                    bgItemNum = rst.getString("FKey");
                    bgItemIdVec.add(bgItemId2222222);
                    bgItemNumMap.put(bgItemId2222222, bgItemNum);
                    bgItemNameMap.put(bgItemId2222222, null);
                    _bgItemNumMap.put(bgItemNum.replaceAll("_", ","), null);
                }
                SQLUtils.cleanup((ResultSet)rst);
                if (_bgItemNumMap.isEmpty()) continue;
                _bgItemMap = BgSHelper.getBgItemsInfo(ctx, _bgItemNumMap, null, null, orgUnitId);
                for (String bgItemId2222222 : bgItemNumMap.keySet()) {
                    bgItemNum = (String)bgItemNumMap.get(bgItemId2222222);
                    visItemInfo = BgSHelper.getBgItemCombinInfo(ctx, bgItemNum, _bgItemMap, orgUnitId);
                    bgItemNameMap.put(bgItemId2222222, visItemInfo.getName());
                }
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return bgItemMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getBgDataByFormID(Context ctx, BgRptFilterParam filterParam, String bgFormID, String orgUnitID) throws BOSException {
        String elementID;
        BgTraceFilterParam param = (BgTraceFilterParam)filterParam;
        BgPeriodInfo beginInfo = param.getBeginPeriod();
        BgPeriodInfo endInfo = param.getEndPeriod();
        BgPeriodCollection bgPC = null;
        String bgSchemeID = param.getBgSchemeId();
        Map map = this.getItemNumberList(ctx, param);
        try {
            bgPC = BgPeriodFactory.getLocalInstance(ctx).getPeriodCollection(beginInfo.getId(), endInfo.getId());
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        String formulaSql = null;
        if (param.getBgFormId() != null) {
            formulaSql = this.getBgItemByBgFormID(ctx, param.getBgFormId(), bgPC);
        }
        if (param.getBgFormMap() != null) {
            formulaSql = this.getBgItemByBgFormID(ctx, param, bgPC);
        }
        StringBuffer sql = new StringBuffer("select a.fid as fid , c.fkey as fkey from t_bg_bgdata a  inner join t_bg_bgctrlrecord b on a.fid = b.FBGDATAID  inner join t_bg_bgitemcombination c on a.FBgItemCombinId = c.fid  inner join t_bg_bgform f on a.fbgformid = f.fid  where a.fformula in " + (StringUtils.isEmpty((String)formulaSql) ? "('')" : formulaSql) + " and a.fbgschemeid in (select fid from t_bg_bgscheme where frootid  =  (select frootid from t_bg_bgscheme where fid ='" + bgSchemeID + "') and forgunitid = '" + orgUnitID + "')  and a.forgunitid = '" + orgUnitID + "'");
        CurrencyInfo currency = param.getCurrency();
        if (currency != null) {
            sql.append(" and a.fcurrencyid ='" + currency.getId() + "'");
        }
        if ((elementID = param.getElement()) != null) {
            sql.append(" and a.fbgelementid = '" + elementID + "'");
        }
        if (filterParam instanceof BgTraceFilterParam) {
            BgTraceFilterParam _filterParam = (BgTraceFilterParam)filterParam;
            if (_filterParam.getItemFrom() != null && _filterParam.getItemTo() != null) {
                String _begin = null;
                String _end = null;
                _begin = _filterParam.getItemFrom();
                _end = _filterParam.getItemTo();
                sql.append(" and (c.Fkey >= '" + _begin.replaceAll(",", "_") + "' and c.Fkey <= '" + _end.replaceAll(",", "_") + "')");
            }
            if (_filterParam.getItems() != null) {
                StringBuffer tempStr = new StringBuffer(" and c.FKey in('',");
                String[] items = _filterParam.getItems();
                String[] tempItemStr = null;
                int length = items.length;
                for (int i = 0; i < length; ++i) {
                    if (items[i] == null || (tempItemStr = items[i].split("\\!")) == null || tempItemStr.length != 2) continue;
                    tempStr.append("'" + tempItemStr[0].replaceAll(",", "_") + "',");
                }
                tempStr.delete(tempStr.length() - 1, tempStr.length());
                tempStr.append(") ");
                sql.append(tempStr.toString());
            }
        }
        sql.append("    and a.FDataState =9");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> list = new ArrayList<String>();
        try {
            while (rs.next()) {
                String id = rs.getString("fid");
                list.add(id);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBgItemByBgFormID(Context ctx, BgTraceFilterParam param, BgPeriodCollection bgPC) throws BOSException {
        Map bgFormMap = param.getBgFormMap();
        String sql = " select fformula from t_bg_bgdata  where fbgformid in " + BgHelper.tranSet2String(bgFormMap.keySet()) + " union select fformula from t_bg_bgdata  where fid in (select fbgdataid from t_bg_bgdataentry where fbgformid in " + BgHelper.tranSet2String(bgFormMap.keySet()) + ")";
        String[] periodNums = this.getPeriodNums(bgPC);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> list = new ArrayList<String>();
        String[] items = param.getItems();
        HashMap userItemMap = new HashMap();
        BgElementInfo bgElementInfo = null;
        CurrencyInfo currencyInfo = null;
        try {
            if (param.getElement() != null) {
                bgElementInfo = BgElementFactory.getLocalInstance(ctx).getBgElementInfo((IObjectPK)new ObjectUuidPK(param.getElement()));
            }
            if (param.getCurrencyInfo() != null) {
                currencyInfo = param.getCurrencyInfo();
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        try {
            while (rs.next()) {
                String formula = rs.getString("fformula");
                String[] formulaParam = BgFillHelper.parseStrFormulaToArray(formula);
                if (!this.isExistItem(items, formulaParam[0]) || userItemMap.containsKey(formulaParam[0]) || bgElementInfo != null && !bgElementInfo.getNumber().equals(formulaParam[2]) || currencyInfo != null && !currencyInfo.getNumber().equals(formulaParam[5])) continue;
                int num = periodNums.length;
                for (int i = 0; i < num; ++i) {
                    list.add(this.rebuildFormula(formulaParam, periodNums[i]));
                }
                userItemMap.put(formulaParam[0], null);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return this.constructFormulaSql(list);
    }

    private boolean isExistItem(String[] items, String item) {
        if (items != null) {
            String[] tmpItems = null;
            for (int i = 0; i < items.length; ++i) {
                tmpItems = items[i].split("\\!");
                if (tmpItems == null || tmpItems.length != 2 || !tmpItems[0].equals(item)) continue;
                return true;
            }
        }
        return false;
    }

    private String getBgItemByBgFormID(Context ctx, String bgFormID, BgPeriodCollection bgPC) throws BOSException {
        String sql = "select bgdata.fformula from t_bg_bgdata bgdata left join t_bg_bgdataentry dataentry on bgdata.fid = dataentry.fbgdataid where bgdata.fbgformid = '" + bgFormID + "' or dataentry.fbgformid = '" + bgFormID + "'";
        String[] periodNums = this.getPeriodNums(bgPC);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> list = new ArrayList<String>();
        try {
            while (rs.next()) {
                String formula = rs.getString("fformula");
                String[] formulaParam = BgFillHelper.parseStrFormulaToArray(formula);
                int num = periodNums.length;
                for (int i = 0; i < num; ++i) {
                    list.add(this.rebuildFormula(formulaParam, periodNums[i]));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return this.constructFormulaSql(list);
    }

    private String getBgItemByFormula(String formula, BgPeriodCollection bgPC) {
        String[] periodNums = this.getPeriodNums(bgPC);
        ArrayList<String> list = new ArrayList<String>();
        String[] formulaParam = BgFillHelper.parseStrFormulaToArray(formula);
        int num = periodNums.length;
        for (int i = 0; i < num; ++i) {
            list.add(this.rebuildFormula(formulaParam, periodNums[i]));
        }
        return this.constructFormulaSql(list);
    }

    private String rebuildFormula(String[] formulaParamArray, String periodNum) {
        return "=BgItem(\"" + formulaParamArray[0] + "\",\"" + periodNum + "\",\"" + formulaParamArray[2] + "\",\"" + formulaParamArray[3] + "\",true,\"" + formulaParamArray[5] + "\")";
    }

    private String[] getPeriodNums(BgPeriodCollection bgPC) {
        int size = bgPC.size();
        String[] rtnAry = new String[size];
        for (int i = 0; i < size; ++i) {
            rtnAry[i] = bgPC.get(i).getNumber();
        }
        return rtnAry;
    }

    private String constructFormulaSql(List formulaList) {
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        int num = formulaList.size();
        for (int i = 0; i < num; ++i) {
            String formula = formulaList.get(i).toString();
            sb.append(formula);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    private String constructPeriodSql(BgPeriodCollection bgPC) {
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        int num = bgPC.size();
        for (int i = 0; i < num; ++i) {
            String periodID = bgPC.get(i).getId().toString();
            sb.append(periodID);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    @Override
    protected List _getRelationData(Context ctx, BgRptFilterParam filterParam) throws BOSException {
        BgTraceFilterParam param = (BgTraceFilterParam)filterParam;
        String bgFormID = param.getBgFormId();
        Map bgFormMap = param.getBgFormMap();
        StringBuffer bgFormIDs = new StringBuffer("(");
        if (bgFormID == null || bgFormMap == null || bgFormMap.isEmpty()) {
            return new ArrayList();
        }
        if (bgFormID != null) {
            bgFormIDs.append("'" + bgFormID + "',");
        }
        if (bgFormMap != null && bgFormMap.size() > 0) {
            Iterator it = bgFormMap.keySet().iterator();
            while (it.hasNext()) {
                bgFormIDs.append("'" + (String)it.next() + "',");
            }
        }
        bgFormIDs.delete(bgFormIDs.length() - 1, bgFormIDs.length());
        bgFormIDs.append(")");
        BgPeriodInfo beginInfo = param.getBeginPeriod();
        BgPeriodCollection bgPC = null;
        if (beginInfo != null) {
            BgPeriodInfo endInfo = param.getEndPeriod();
            try {
                bgPC = BgPeriodFactory.getLocalInstance(ctx).getPeriodCollection(beginInfo.getId(), endInfo.getId());
            }
            catch (EASBizException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
        OrgUnitInfo[] orgAry = param.getOrgUnitInfoAry();
        String orgSql = this.constructOrgUnitSql(orgAry);
        StringBuffer sql = null;
        sql = new StringBuffer("select forgunitid , fid from t_bg_bgform where fbgtemplateid in (select fid from t_bg_bgtemplate where frootid in (select frootid from t_bg_bgtemplate where fid in (select fbgtemplateid from t_bg_bgform where fid in " + bgFormIDs + "))) and fbgschemeid in (select fid from t_bg_bgscheme where frootid in  (select frootid from t_bg_bgscheme where fid in (select fbgschemeid from t_bg_bgform where fid in  " + bgFormIDs + "))) and forgunitid in " + orgSql + " and fstate = " + 2);
        if (beginInfo != null) {
            sql.append(" and fbgperiodid in " + this.constructPeriodSql(bgPC));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<BgTraceHelperBean> list = new ArrayList<BgTraceHelperBean>();
        try {
            while (rs.next()) {
                String tempBgFormID = rs.getString("fid");
                String orgUnitID = rs.getString("forgunitid");
                BgTraceHelperBean bh = new BgTraceHelperBean(tempBgFormID, orgUnitID);
                list.add(bh);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return list;
    }

    private String constructOrgUnitSql(OrgUnitInfo[] orgAry) {
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        int num = orgAry.length;
        for (int i = 0; i < num; ++i) {
            String tempOrgId = orgAry[i].getId().toString();
            sb.append(tempOrgId);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    private Map getItemNumberList(Context ctx, BgTraceFilterParam filterParam) throws BOSException {
        HashMap<String, String> mapItemName;
        block6: {
            String[] itemToArray;
            mapItemName = new HashMap<String, String>();
            String itemFrom = filterParam.getItemFrom();
            String itemTo = filterParam.getItemTo();
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            if (itemFrom == null && itemTo == null) break block6;
            String[] itemTromArray = itemFrom.split("_");
            int size = itemTromArray.length <= (itemToArray = itemTo.split("_")).length ? itemTromArray.length : itemToArray.length;
            for (int i = 0; i < size; ++i) {
                StringBuffer itemSql = new StringBuffer("select fnumber,fname_" + ctx.getLocale() + " fname from t_bg_bgitem where ");
                itemSql.append(" (fnumber >= ? and fnumber <= ?) ");
                try {
                    conn = this.getConnection(ctx);
                    ps = conn.prepareStatement(itemSql.toString());
                    ps.setString(1, itemTromArray[i]);
                    ps.setString(2, itemToArray[i]);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        mapItemName.put(rs.getString("fnumber"), rs.getString("fname"));
                    }
                }
                catch (SQLException e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, ps, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
            }
        }
        return mapItemName;
    }

    @Override
    protected BigDecimal _getAddedBgVal(Context ctx, BgTraceFilterParam filterParam, BgTraceInfo info, String bgItem, String orgUnitID) throws BOSException {
        BigDecimal ret = BgNConstants.ZERO;
        try {
            ret = BgBalCalculator.calcuBal(ctx, info.getBgDataID(), false, BgGetPeriodTypeForGetBlanceEnum.Is_BgTrace_Init_Bal);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    private List getPeriodIDListByScheme(Context ctx, BgPeriodInfo periodInfo, String bgSchemeId, String bgItem) throws BOSException, EASBizException {
        int type = -1;
        if (periodInfo != null && periodInfo.getPeriodType() != null) {
            type = periodInfo.getPeriodType().getValue();
        }
        Date dateFrom = null;
        Date dateTo = null;
        String _sql = "select FDateFrom , FDateTo from T_BG_BgScheme where fid = '" + bgSchemeId + "'";
        IRowSet _rs = DbUtil.executeQuery((Context)ctx, (String)_sql);
        try {
            if (_rs.next()) {
                dateFrom = _rs.getDate("fdatefrom");
                dateFrom = new Date(dateFrom.getYear(), dateFrom.getMonth(), dateFrom.getDate(), 0, 0, 0);
                dateTo = _rs.getDate("FDateTo");
                dateTo = new Date(dateTo.getYear(), dateTo.getMonth(), dateTo.getDate(), 23, 59, 59);
            }
        }
        catch (SQLException e2) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e2);
        }
        String periodTypeSql = "";
        if (type == -1) {
            String[] bgFormulaAry = BgFillHelper.parseStrFormulaToArray(bgItem);
            periodTypeSql = " and fperiodtype = (select FPeriodType from t_bg_bgperiod where fnumber = '" + bgFormulaAry[1] + "')";
        } else {
            periodTypeSql = " and fperiodtype = " + type;
        }
        String sql_ = "select distinct fid ,fnumber from t_bg_bgPeriod where fenddate <= to_date('" + this.dateToStr(dateTo) + "') and  fbegindate >= to_date('" + this.dateToStr(dateFrom) + "')" + periodTypeSql + " or (  fbegindate >= to_date('" + this.dateToStr(dateFrom) + "')        and fbegindate < to_date('" + this.dateToStr(dateTo) + "')        and fendDate > to_date('" + this.dateToStr(dateTo) + "') " + periodTypeSql + "     )  order by fnumber ";
        ArrayList<String> idList = new ArrayList<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql_);
            while (rs.next()) {
                String number = rs.getString("fnumber");
                idList.add(number);
            }
        }
        catch (BOSException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        catch (SQLException e1) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e1);
        }
        return idList;
    }

    private List getPeriodIDListByScheme(Context ctx, BgPeriodInfo periodInfo, String bgSchemeId) throws BOSException {
        int type = periodInfo.getPeriodType().getValue();
        Date dateFrom = null;
        Date dateTo = null;
        String _sql = "select FDateFrom , FDateTo from T_BG_BgScheme where fid = '" + bgSchemeId + "'";
        IRowSet _rs = DbUtil.executeQuery((Context)ctx, (String)_sql);
        try {
            if (_rs.next()) {
                dateFrom = _rs.getDate("fdatefrom");
                dateFrom = new Date(dateFrom.getYear(), dateFrom.getMonth(), dateFrom.getDate(), 0, 0, 0);
                dateTo = _rs.getDate("FDateTo");
                dateTo = new Date(dateTo.getYear(), dateTo.getMonth(), dateTo.getDate(), 23, 59, 59);
            }
        }
        catch (SQLException e2) {
            logger.error((Object)"budget error:", (Throwable)e2);
        }
        String sql_ = "select fid ,fnumber from t_bg_bgPeriod where fenddate <= to_date('" + this.dateToStr(dateTo) + "') and  fbegindate >= to_date('" + this.dateToStr(dateFrom) + "') and fperiodtype = " + type + " order by fnumber ";
        ArrayList<String> idList = new ArrayList<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql_);
            while (rs.next()) {
                String number = rs.getString("fnumber");
                idList.add(number);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (SQLException e1) {
            logger.error((Object)"budget error:", (Throwable)e1);
        }
        return idList;
    }

    private BigDecimal getTotalSchemeVal(Context ctx, String formulaSql, String bgSchemeID, String orgUnitID) throws BOSException {
        String sql = "select sum(fbgValue* (case FIsFlexible when 1 then fflexparam else 1 end )) as sumBgVal from t_bg_bgdata where fformula in " + formulaSql + " and fbgschemeid in (select fid from t_bg_bgscheme where frootid = ( select frootid from t_bg_bgscheme where fid = '" + bgSchemeID + "' )) and forgunitid = '" + orgUnitID + "' and fbgformid in (select fid from t_bg_bgform where fstate = 2)";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        BigDecimal sumBgVal = null;
        try {
            if (rs.next() && (sumBgVal = rs.getBigDecimal("sumBgVal")) == null) {
                sumBgVal = ZERO;
            }
        }
        catch (SQLException e2) {
            logger.error((Object)"budget error:", (Throwable)e2);
        }
        return sumBgVal;
    }

    private String getBgItemSql(List idList, int num, BgTraceInfo info) {
        String formula = info.getFormula();
        String[] formulaAry = BgFillHelper.parseStrFormulaToArray(formula);
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        for (int i = 0; i < num; ++i) {
            String periodNum = idList.get(i).toString();
            sb.append(this.rebuildFormula(formulaAry, periodNum));
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }

    private String dateToStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(date_pattern);
        return sdf.format(date);
    }

    @Override
    protected BigDecimal _getTotalBgVal(Context ctx, BgTraceFilterParam filterParam, BgTraceInfo info, String bgItem, String orgUnitID) throws BOSException {
        BigDecimal result = null;
        String currentPeriodID = info.getPeriod();
        BgPeriodInfo beginInfo = filterParam.getBeginPeriod();
        String bgSchemeID = filterParam.getBgSchemeId();
        List schemePeriodIDList = null;
        try {
            schemePeriodIDList = this.getPeriodIDListByScheme(ctx, beginInfo, bgSchemeID, bgItem);
        }
        catch (EASBizException e1) {
            throw new BOSException((Throwable)e1);
        }
        int curtPeriodIDIndex = schemePeriodIDList.indexOf(currentPeriodID);
        String totalFormulaSql = this.getBgItemSql(schemePeriodIDList, schemePeriodIDList.size(), info);
        BigDecimal sumBgVal = this.getTotalSchemeVal(ctx, totalFormulaSql, bgSchemeID, orgUnitID);
        int isFlexible = info.getIsflexible();
        if (curtPeriodIDIndex == 0) {
            if (isFlexible == 1) {
                BigDecimal fleRate = info.getFlexparam();
                result = sumBgVal.multiply(fleRate);
            } else {
                result = sumBgVal;
            }
        } else if (curtPeriodIDIndex == -1) {
            result = ZERO;
        } else {
            String formulaSql = this.getBgItemSql(schemePeriodIDList, curtPeriodIDIndex, info);
            String grpFormulaSql = this.getGrpFormula(ctx, orgUnitID, bgSchemeID, schemePeriodIDList, curtPeriodIDIndex, info);
            String sql = "select FBizActual from t_bg_bgdata where ( fformula in " + formulaSql + (grpFormulaSql != null ? " or fformula in " + grpFormulaSql + ")" : ")") + " and fbgschemeid = (select fid from t_bg_bgscheme where frootid = ( select frootid from t_bg_bgscheme where fid = '" + bgSchemeID + "' ) and forgunitid = '" + orgUnitID + "') and forgunitid = '" + orgUnitID + "' and fbgformid in (select fid from t_bg_bgform where fstate = 2)";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            BigDecimal tempResult = ZERO;
            try {
                while (rs.next()) {
                    BigDecimal actualVal = rs.getBigDecimal("fbizactual");
                    if (actualVal == null) {
                        actualVal = ZERO;
                    }
                    tempResult = tempResult.add(actualVal);
                }
            }
            catch (SQLException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            if (isFlexible == 1) {
                BigDecimal fleRate = info.getFlexparam();
                result = sumBgVal.multiply(fleRate).subtract(tempResult);
            } else {
                result = sumBgVal.subtract(tempResult);
            }
        }
        if (result == null) {
            result = ZERO;
        }
        return result;
    }

    @Override
    protected List _getBgDataIDByFormula(Context ctx, BgTraceFilterParam filterParam, String formula) throws BOSException {
        String[] tempAry = formula.split("&");
        if (tempAry.length > 1) {
            formula = tempAry[0];
        }
        OrgUnitInfo orgUnitInfo = filterParam.getOrgUnitInfoAry()[0];
        BOSUuid orgUnitID = orgUnitInfo.getId();
        String sqlOrgUnit = "";
        sqlOrgUnit = orgUnitID == null ? " and forgunitid in (select fid from t_org_baseunit where fnumber = '" + orgUnitInfo.getNumber() + "')" : " and forgunitid = '" + orgUnitID + "'";
        String bgSchemeID = filterParam.getBgSchemeId();
        String formulaSql = "";
        BgPeriodInfo beginInfo = filterParam.getBeginPeriod();
        if (beginInfo != null) {
            int periodType = beginInfo.getPeriodType().getValue();
            BgPeriodCollection bgPC = null;
            if (periodType == 8) {
                bgPC = new BgPeriodCollection();
                bgPC.add(beginInfo);
            } else {
                BgPeriodInfo endInfo = filterParam.getEndPeriod();
                try {
                    bgPC = BgPeriodFactory.getLocalInstance(ctx).getPeriodCollection(beginInfo.getId(), endInfo.getId());
                }
                catch (EASBizException e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
            }
            formulaSql = this.getBgItemByFormula(formula, bgPC);
        } else {
            formulaSql = "('" + formula + "')";
        }
        String sql = "select fid from t_bg_bgdata   where fformula in " + formulaSql + " and fbgschemeid in (select fid from t_bg_bgscheme where frootid  =  (select frootid from t_bg_bgscheme where fid ='" + bgSchemeID + "')" + sqlOrgUnit + ")" + sqlOrgUnit;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> list = new ArrayList<String>();
        try {
            while (rs.next()) {
                String id = rs.getString("fid");
                list.add(id);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return list;
    }

    @Override
    protected String _getOrgUnitNumByBgFormID(Context ctx, String bgFormID) throws BOSException {
        String sql = "select fnumber from t_org_baseunit where fid = (select forgunitid from t_bg_bgform where fid = '" + bgFormID + "')";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String number = null;
        try {
            if (rs.next()) {
                number = rs.getString("fnumber");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return number;
    }

    @Override
    protected BigDecimal _getThisYearBgVal(Context ctx, BgTraceFilterParam filterParam, BgTraceInfo info, String bgFormId, String orgUnitId) throws BOSException {
        BigDecimal result = null;
        String currentPeriodID = info.getPeriod();
        BgPeriodInfo beginInfo = filterParam.getBeginPeriod();
        String bgSchemeID = filterParam.getBgSchemeId();
        beginInfo = new BgPeriodInfo();
        beginInfo.setNumber(currentPeriodID);
        List schemePeriodIDList = this.getThisYearCtrlPeriodNumberList(ctx, beginInfo, bgSchemeID);
        int curtPeriodIDIndex = schemePeriodIDList.indexOf(currentPeriodID);
        String totalFormulaSql = this.getBgItemSql(schemePeriodIDList, schemePeriodIDList.size(), info);
        BigDecimal sumBgVal = this.getTotalSchemeVal(ctx, totalFormulaSql, bgSchemeID, orgUnitId);
        if (curtPeriodIDIndex == 0) {
            result = sumBgVal;
        } else if (curtPeriodIDIndex == -1) {
            result = ZERO;
        } else {
            String formulaSql = this.getBgItemSql(schemePeriodIDList, curtPeriodIDIndex, info);
            String grpFormulaSql = this.getGrpFormula(ctx, orgUnitId, bgSchemeID, schemePeriodIDList, curtPeriodIDIndex, info);
            String sql = "select FBizActual from t_bg_bgdata where ( fformula in " + formulaSql + (grpFormulaSql != null ? " or fformula in " + grpFormulaSql + ")" : ")") + " and fbgschemeid = (select fid from t_bg_bgscheme where frootid = ( select frootid from t_bg_bgscheme where fid = '" + bgSchemeID + "' ) and forgunitid = '" + orgUnitId + "') and forgunitid = '" + orgUnitId + "' and fbgformid in (select fid from t_bg_bgform where fstate = 2)";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            BigDecimal tempResult = ZERO;
            try {
                while (rs.next()) {
                    BigDecimal actualVal = rs.getBigDecimal("fbizactual");
                    if (actualVal == null) {
                        actualVal = ZERO;
                    }
                    tempResult = tempResult.add(actualVal);
                }
            }
            catch (SQLException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            result = sumBgVal.subtract(tempResult);
        }
        if (result == null) {
            result = ZERO;
        }
        return result;
    }

    private List getThisYearCtrlPeriodNumberList(Context ctx, BgPeriodInfo periodInfo, String bgSchemeId) {
        ArrayList<String> periodIdList = new ArrayList<String>();
        Date beginDate = null;
        Date endDate = null;
        IBgPeriod iBgPeriod = null;
        CoreBaseInfo period = null;
        try {
            iBgPeriod = BgPeriodFactory.getLocalInstance(ctx);
            period = iBgPeriod.getValue(" select * where number = '" + periodInfo.getNumber() + "' ");
        }
        catch (BOSException ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        if (period == null) {
            return periodIdList;
        }
        int year = ((BgPeriodInfo)period).getYear();
        beginDate = new Date();
        beginDate.setYear(year - 1900);
        beginDate.setMonth(0);
        beginDate.setDate(1);
        beginDate.setHours(0);
        beginDate.setMinutes(0);
        beginDate.setSeconds(0);
        endDate = new Date();
        endDate.setYear(year - 1900);
        endDate.setMonth(11);
        endDate.setDate(31);
        endDate.setHours(0);
        endDate.setMinutes(0);
        endDate.setSeconds(0);
        BgPeriodCollection bgPeriodList = null;
        try {
            bgPeriodList = BgHelper.getBgPeriodCollOverDateRange(ctx, ((BgPeriodInfo)period).getPeriodType().getValue(), beginDate, endDate);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (bgPeriodList != null) {
            int count = bgPeriodList.size();
            for (int i = 0; i < count; ++i) {
                periodIdList.add(bgPeriodList.get(i).getNumber());
            }
        }
        return periodIdList;
    }

    private String getGrpFormula(Context ctx, String orgUnitID, String bgSchemeID, List schemePeriodIDList, int curtPeriodIDIndex, BgTraceInfo info) throws BOSException {
        String formula = info.getFormula();
        String[] formulaAry = BgFillHelper.parseStrFormulaToArray(formula);
        if (formulaAry == null || formulaAry[0] == null || formulaAry[1] == null || formulaAry[2] == null || formulaAry[5] == null) {
            return null;
        }
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select distinct ic2.fkey");
        kSql.append("   from t_bg_bgdata            d1,");
        kSql.append("        t_bg_bgelement         e,");
        kSql.append("        t_bd_currency          c,");
        kSql.append("        t_bg_bgitemcombination ic1,");
        kSql.append("        t_bg_bgitemcombination ic2,");
        kSql.append("        t_bg_bgdata d2");
        kSql.append("  where d1.fisgroupctrl = 1");
        kSql.append("    and d1.fbgelementid = e.fid");
        kSql.append("    and d1.fcurrencyid = c.fid");
        kSql.append("    and d1.fbgitemcombinid = ic1.fid");
        kSql.append("    and d2.fisgroupctrl = 1");
        kSql.append("    and d1.fgroupno = d2.fgroupno");
        kSql.append("    and d2.fbgitemcombinid = ic2.fid");
        kSql.append("    and e.fnumber = '" + formulaAry[2] + "'");
        kSql.append("    and c.fnumber = '" + formulaAry[5] + "'");
        kSql.append("    and ic1.fkey = '" + formulaAry[0] + "'");
        kSql.append("    and d1.fbgschemeid =");
        kSql.append("        (select fid");
        kSql.append("           from t_bg_bgscheme");
        kSql.append("          where frootid =");
        kSql.append("                (select frootid");
        kSql.append("                   from t_bg_bgscheme");
        kSql.append("                  where fid = '" + bgSchemeID + "')");
        kSql.append("            and forgunitid = '" + orgUnitID + "')");
        kSql.append("    and d1.forgunitid = '" + orgUnitID + "'");
        kSql.append("    and d1.fbgformid in (select fid from t_bg_bgform where fstate = 2)");
        HashMap keyMap = new HashMap();
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString());
        try {
            while (rst.next()) {
                String key = rst.getString(1);
                if (key.equals(formulaAry[0])) continue;
                keyMap.put(rst.getString(1), null);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (keyMap.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        Iterator itr = keyMap.keySet().iterator();
        while (itr.hasNext()) {
            String key = itr.next().toString();
            String[] _formulaAry = (String[])formulaAry.clone();
            _formulaAry[0] = key;
            for (int i = 0; i < curtPeriodIDIndex; ++i) {
                String periodNum = schemePeriodIDList.get(i).toString();
                sb.append(this.rebuildFormula(_formulaAry, periodNum));
                if (i == curtPeriodIDIndex - 1) break;
                sb.append("','");
            }
            sb.append("')");
        }
        return sb.toString();
    }
}

