/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BGTEMPLATE_STATUS_Enum;
import com.kingdee.eas.ma.budget.BgExamineNodeFactory;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormulaObject;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPermissionFactory;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeException;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemModifyEnum;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgExamineNode;
import com.kingdee.eas.ma.budget.IBgPermission;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.app.AbstractBgSchemeControllerBean;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSQLHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgSchemeControllerBean
extends AbstractBgSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgSchemeControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectCollection _getTemplateByScheme(Context ctx, String id) throws BOSException, EASBizException {
        BgTemplateCollection templateColl = new BgTemplateCollection();
        if (StringUtils.isEmpty((String)id)) {
            return templateColl;
        }
        BgTemplateInfo bgTemplateInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FID, t.FNumber, t.FName from T_BG_BgSchemeNode sn left join T_BG_BgTemplate t on sn.FBgTemplateId = t.fid where sn.FBgSchemeId = ? order by t.FNumber");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, id);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgTemplateInfo = new BgTemplateInfo();
                bgTemplateInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgTemplateInfo.setNumber(rst.getString("FNumber"));
                bgTemplateInfo.setName(rst.getString("FName"));
                templateColl.add(bgTemplateInfo);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return templateColl;
    }

    @Override
    protected void _executeScheme(Context ctx, IObjectPK bgSchemePK, BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (bgSchemePK == null) {
            return;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(200);
            IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
            BgSchemeInfo bgSchemeInfo = iBgScheme.getBgSchemeInfo(bgSchemePK);
            Date dateFrom = bgSchemeInfo.getDateFrom();
            Date dateTo = bgSchemeInfo.getDateTo();
            BgPeriodEnum periodType = bgSchemeInfo.getPeriod();
            strBuffer.append(" select FId  from T_BG_BgScheme where (FDateFrom <= ? and FDateTo >= ? ) ");
            strBuffer.append(" and FId <> ? and FOrgUnitID = ? and FIsFormal = 1 ");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setDate(1, new java.sql.Date(dateTo.getTime()));
            ps.setDate(2, new java.sql.Date(dateFrom.getTime()));
            ps.setString(3, bgSchemePK.toString());
            ps.setString(4, orgUnitId.toString());
            rs = ps.executeQuery();
            if (rs.next()) {
                throw new BgSchemeException(BgSchemeException.ACCROSSLIFECYCLE, new Object[]{periodType.getAlias(), periodType.getAlias()});
            }
            String sql = "update t_bg_bgscheme set FIsFormal = 1 where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{bgSchemePK.toString()});
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)model;
        String number = bgSchemeInfo.getNumber();
        String name = bgSchemeInfo.getName();
        String orgUnitId = bgSchemeInfo.getOrgUnit().getId().toString();
        if (this.checkDupNumber(ctx, number, "", orgUnitId)) {
            throw new BgSchemeException(BgSchemeException.NUMBERDUP);
        }
        if (this.checkDupName(ctx, name, "", orgUnitId)) {
            throw new BgSchemeException(BgSchemeException.NAMEDUP);
        }
        if (bgSchemeInfo.isFormallyYearScheme()) {
            this.checkFormallyYearScheme(ctx, bgSchemeInfo, orgUnitId);
        }
        if (bgSchemeInfo.getRootId() == null) {
            BOSUuid rootId = BOSUuid.read((String)pk.toString());
            bgSchemeInfo.setRootId(rootId);
        }
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)model;
        if (StringUtils.isEmpty((String)bgSchemeInfo.getNumber())) {
            BgHelper.setSNumber(ctx, bgSchemeInfo.getOrgUnit().getId().toString(), (CoreBaseInfo)bgSchemeInfo);
            if (StringUtils.isEmpty((String)bgSchemeInfo.getNumber())) {
                bgSchemeInfo.setNumber("BgControlScheme-" + System.currentTimeMillis());
            }
        }
        String number = bgSchemeInfo.getNumber();
        String name = bgSchemeInfo.getName();
        String orgUnitId = bgSchemeInfo.getOrgUnit().getId().toString();
        if (bgSchemeInfo.getCU() == null) {
            bgSchemeInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (this.checkDupNumber(ctx, number = bgSchemeInfo.getNumber(), "", orgUnitId)) {
            throw new BgSchemeException(BgSchemeException.NUMBERDUP);
        }
        if (this.checkDupName(ctx, name, "", orgUnitId)) {
            throw new BgSchemeException(BgSchemeException.NAMEDUP);
        }
        if (bgSchemeInfo.isFormallyYearScheme()) {
            this.checkFormallyYearScheme(ctx, bgSchemeInfo, orgUnitId);
        }
        bgSchemeInfo.setId(BOSUuid.create((BOSObjectType)bgSchemeInfo.getBOSType()));
        if (bgSchemeInfo.getRootId() == null) {
            BOSUuid rootId = bgSchemeInfo.getId();
            bgSchemeInfo.setRootId(rootId);
        }
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)model;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BG_BgScheme set FDATETO = ? where FROOTID = (select frootId from t_bg_bgscheme where fid = ? ) AND FID !=?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select fid from t_bg_bgscheme where fid = frootid and fid = ?", (Object[])new Object[]{bgSchemeInfo.getId().toString()});
        try {
            if (rowSet.next()) {
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{bgSchemeInfo.getDateTo(), bgSchemeInfo.getId().toString(), bgSchemeInfo.getId().toString()});
            }
        }
        catch (SQLException e) {
            logger.error((Object)"error", (Throwable)e);
            throw new BgFormException(BgFormException.DATABASEERROR, new Object[]{e.getCause()});
        }
        finally {
            SQLUtils.cleanup((ResultSet)rowSet);
        }
        String number = bgSchemeInfo.getNumber();
        String name = bgSchemeInfo.getName();
        String orgUnitId = bgSchemeInfo.getOrgUnit().getId().toString();
        String id = pk.toString();
        if (this.checkDupNumber(ctx, number, id, orgUnitId)) {
            throw new BgSchemeException(BgSchemeException.NUMBERDUP);
        }
        if (this.checkDupName(ctx, name, id, orgUnitId)) {
            throw new BgSchemeException(BgSchemeException.NAMEDUP);
        }
        if (bgSchemeInfo.isFormallyYearScheme()) {
            this.checkFormallyYearScheme(ctx, bgSchemeInfo, orgUnitId);
        }
        super._update(ctx, pk, model);
    }

    private boolean checkDupName(Context ctx, String name, String id, String orgUnitId) throws BOSException, EASBizException {
        PreparedStatement sm;
        Connection connection;
        ResultSet rs;
        block6: {
            boolean bl;
            rs = null;
            connection = null;
            sm = null;
            StringBuffer sql = new StringBuffer(60);
            sql.append(" select fid from t_bg_bgscheme where fname_" + ctx.getLocale().toString() + " = ? and forgunitid = ? ");
            if (!id.equals("")) {
                sql.append(" and fid!=?");
            }
            try {
                connection = this.getConnection(ctx);
                sm = connection.prepareStatement(sql.toString());
                sm.setString(1, name);
                sm.setString(2, orgUnitId);
                if (!id.equals("")) {
                    sm.setString(3, id);
                }
                if (!(rs = sm.executeQuery()).next()) break block6;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sm, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return false;
    }

    private boolean checkDupNumber(Context ctx, String number, String id, String orgUnitId) throws BOSException, EASBizException {
        PreparedStatement sm;
        Connection connection;
        ResultSet rs;
        block6: {
            boolean bl;
            rs = null;
            connection = null;
            sm = null;
            StringBuffer sql = new StringBuffer(60);
            sql.append(" select fid from t_bg_bgscheme where fnumber=? and forgunitid = ? ");
            if (!id.equals("")) {
                sql.append(" and fid!=?");
            }
            try {
                connection = this.getConnection(ctx);
                sm = connection.prepareStatement(sql.toString());
                sm.setString(1, number);
                sm.setString(2, orgUnitId);
                if (!id.equals("")) {
                    sm.setString(3, id);
                }
                if (!(rs = sm.executeQuery()).next()) break block6;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sm, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return false;
    }

    private boolean checkFormallyYearScheme(Context ctx, BgSchemeInfo bgSchemeInfo, String orgUnitId) throws BOSException, EASBizException {
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FId  from T_BG_BgScheme where FformallyYearScheme = 1 and (FDateFrom <= ? and FDateTo >= ? ) and FOrgUnitID = ? ");
        boolean isNew = true;
        String schemeID = "";
        if (bgSchemeInfo.getId() != null && bgSchemeInfo.getId().toString().length() > 0) {
            sql.append(" and FId <> ? ");
            schemeID = bgSchemeInfo.getId().toString();
            isNew = false;
        }
        Date dateFrom = bgSchemeInfo.getDateFrom();
        Date dateTo = bgSchemeInfo.getDateTo();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql.toString());
            ps.setDate(1, new java.sql.Date(dateTo.getTime()));
            ps.setDate(2, new java.sql.Date(dateFrom.getTime()));
            ps.setString(3, orgUnitId);
            if (!isNew) {
                ps.setString(4, schemeID);
            }
            if ((rs = ps.executeQuery()).next()) {
                throw new BgSchemeException(BgSchemeException.HASFORMALLYYEARSCHEME);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return false;
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected boolean _isQuotedByBgForm(Context ctx, String schemeId) throws BOSException, EASBizException {
        boolean isQuoted = false;
        if (schemeId == null) {
            isQuoted = false;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(200);
            strBuffer.append("select FBgSchemeID from T_BG_BgForm where FBgSchemeID=?");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, schemeId);
            rs = ps.executeQuery();
            isQuoted = rs.next();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return isQuoted;
    }

    @Override
    public boolean _hasChildScheme(Context ctx, String schemeId) throws BOSException, EASBizException {
        boolean hasChild = false;
        if (schemeId == null) {
            hasChild = false;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(200);
            strBuffer.append("select FID from T_BG_BgScheme where FParentSchemeID=?");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, schemeId);
            rs = ps.executeQuery();
            hasChild = rs.next();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return hasChild;
    }

    @Override
    protected IObjectCollection _getBgSchemeByOrgUnit(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        BgSchemeCollection bgSchemeCollection = new BgSchemeCollection();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("rootId"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("name"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("number"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("period"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("isFormal"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("dateFrom"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("dateTo"));
        entityViewInfo.getSorter().add(new SorterItemInfo("number"));
        bgSchemeCollection = this.getBgSchemeCollection(ctx, entityViewInfo);
        return bgSchemeCollection;
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("dateFrom"));
        sic.add(new SelectorItemInfo("dateTo"));
        sic.add(new SelectorItemInfo("isFormal"));
        sic.add(new SelectorItemInfo("parentScheme.name"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.number"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.creator.*"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.name"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.isAllowChange"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.creator.name"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.createTime"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.id"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.rootId"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.description"));
        sic.add(new SelectorItemInfo("creator.*"));
        return sic;
    }

    private BgTemplateInfo getBgTemplateInfo(Context ctx, String number, String orgId, String rootId) throws SQLDataException {
        Connection connection;
        ResultSet rs;
        PreparedStatement ps;
        BgTemplateInfo result;
        block5: {
            result = null;
            ps = null;
            rs = null;
            connection = null;
            StringBuffer strBuffer = new StringBuffer(200);
            strBuffer.append("select fid,fparentid from T_BG_BgTemplate where fnumber=? and forgunitid=? and frootid = ?");
            try {
                connection = this.getConnection(ctx);
                ps = connection.prepareStatement(strBuffer.toString());
                ps.setString(1, number);
                ps.setString(2, orgId);
                ps.setString(3, rootId);
                rs = ps.executeQuery();
                if (!rs.next()) break block5;
                result = new BgTemplateInfo();
                String id = rs.getString(1);
                String parentId = rs.getString(2);
                result.setId(BOSUuid.read((String)id));
                if (parentId != null && !parentId.equals("")) {
                    BgTemplateInfo parent = new BgTemplateInfo();
                    parent.setId(BOSUuid.read((String)parentId));
                    result.setParent(parent);
                }
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)connection);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return result;
    }

    protected void replaceSchemeInBgFormula(Context ctx, KDF souceKDF, String id) throws EASBizException, BOSException {
        KDF kdf = new KDF();
        kdf.addTable(souceKDF.getTableByIndex(0));
        Collection collection = kdf.getAllTable();
        if (collection != null) {
            int colletionSize = collection.size();
            for (int k = 0; k < colletionSize; ++k) {
                KDTable table = (KDTable)kdf.getTableByIndex(k);
                int rowCount = table.getBody().size();
                int colCount = table.getColumnCount();
                for (int i = 0; i < rowCount; ++i) {
                    for (int j = 0; j < colCount; ++j) {
                        RptCell rCell;
                        String formulaString;
                        ICell cell = table.getCell(i, j);
                        if (cell.getValue() != null && cell.getValue() instanceof BgFormulaObject) {
                            RptCell rpeCell = null;
                            rpeCell = cell.getUserObject() != null && cell.getUserObject() instanceof RptCell ? (RptCell)cell.getUserObject() : new RptCell(cell);
                            if (rpeCell.getItemFormula() == null) {
                                rpeCell.setItemFormula(new ItemFormula());
                            }
                            rpeCell.getItemFormula().putExt("BGFORMULA_FROM_SUPER", "true");
                        }
                        if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell) || (formulaString = (rCell = (RptCell)cell.getUserObject()).getItemFormulaLine()) == null || formulaString.trim().length() <= 0 || rCell.getItemFormula() == null) continue;
                        rCell.getItemFormula().putExt("BGITEM_CANUPDATE", "false");
                    }
                }
                BgFSHelper.updateAliasSuperior(table);
            }
        }
        byte[] bytesData = null;
        try {
            bytesData = ZipKDF.pack((KDF)kdf);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.insertData(ctx, id, bytesData);
    }

    private void insertData(Context ctx, String id, byte[] data) throws BOSException {
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(400);
            strBuffer.append("update t_bg_bgtemplate set fdata = ? where fid = ? ");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setBytes(1, data);
            ps.setString(2, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private boolean isExecutedByOrg(Context ctx, String schemeId, String orgUnitId) throws SQLDataException {
        boolean isExecutedByOrg = false;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        connection = this.getConnection(ctx);
        StringBuffer strBuffer = new StringBuffer(200);
        strBuffer.append("select FID from T_BG_BgScheme where FParentSchemeID=? and FOrgUnitID=? and FIsFormal=1");
        try {
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, schemeId);
            ps.setString(2, orgUnitId);
            rs = ps.executeQuery();
            while (rs.next()) {
                isExecutedByOrg = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return isExecutedByOrg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _usedByBgFormInOrgUnit(Context ctx, String schemeId, String ortUnitId) throws BOSException, EASBizException {
        boolean used = false;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(200);
            strBuffer.append("select bgscheme.FID as FId from T_BG_BgForm bgform , T_BG_BgScheme bgscheme where bgform.FBgSchemeID = bgscheme.FID and bgscheme.FParentSchemeID=? and bgform.FOrgUnitID=?");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, schemeId);
            ps.setString(2, ortUnitId);
            rs = ps.executeQuery();
            if (rs.next()) {
                used = true;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, ps, (Connection)connection);
        }
        return used;
    }

    @Override
    protected void _antiExecuteScheme(Context ctx, IObjectPK bgSchemePK) throws BOSException, EASBizException {
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        BgSchemeInfo bgSchemeInfo = iBgScheme.getBgSchemeInfo(bgSchemePK);
        bgSchemeInfo.setIsFormal(false);
        super.update(ctx, bgSchemePK, (CoreBaseInfo)bgSchemeInfo);
    }

    @Override
    protected void _sendMessageToSubOrgs(Context ctx, String ids, String orgName, String schemeName, String userNumber) throws BOSException, EASBizException {
        if (ids == null || ids.trim().length() < 1) {
            return;
        }
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = BgSchemeControllerBean.getContextLocales(ctx);
        Locale locale2 = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        for (Locale locale2 : lcla) {
            String superOrg = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgSchemeResource", (String)"ReceiveSuperOrg", (Locale)ctx.getLocale());
            String assignedScheme = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgSchemeResource", (String)"AssignedScheme", (Locale)ctx.getLocale());
            message.setLocaleStringHeader("title", superOrg + orgName + assignedScheme + schemeName + " ", locale2);
            message.setLocaleStringHeader("sender", userNumber, locale2);
            message.setLocaleStringHeader("body", superOrg + orgName + assignedScheme + schemeName + " ", locale2);
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 0);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("receiver", ids);
        senderAgent.sendMessage(message);
    }

    private static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    @Override
    protected Hashtable _getDirectChildren(Context ctx, String bgFormId, List subOrgList) throws BOSException, EASBizException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String bgSchemeId = "";
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(200);
            strBuffer.append("select b.frootid rootId from T_BG_BgForm a,T_Bg_BgScheme b where a.fbgschemeid=b.fid and a.fid = ?");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, bgFormId);
            rs = ps.executeQuery();
            if (rs.next()) {
                bgSchemeId = rs.getString(1);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
            ArrayList<String> _tmpList = new ArrayList<String>();
            _tmpList.add(bgSchemeId);
            strBuffer = new StringBuffer();
            strBuffer.append("select forgunitid ,fid from t_bg_bgscheme where frootid = ? ");
            for (int i = 0; i < subOrgList.size(); ++i) {
                FullOrgUnitInfo org = (FullOrgUnitInfo)subOrgList.get(i);
                if (i == 0) {
                    strBuffer.append(" and ( forgunitid=?");
                } else {
                    strBuffer.append(" or forgunitid=?");
                }
                _tmpList.add(org.getId().toString());
            }
            strBuffer.append(" ) ");
            ps = connection.prepareStatement(strBuffer.toString());
            BgNSQLHelper.setParams((PreparedStatement)ps, _tmpList);
            rs = ps.executeQuery();
            while (rs.next()) {
                result.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return result;
    }

    @Override
    protected Hashtable _getInDirectChildren(Context ctx, String bgFormId, Hashtable subOrgNumberMap) throws BOSException, EASBizException {
        Hashtable result = new Hashtable();
        String bgSchemeRootId = "";
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(200);
            strBuffer.append("select b.frootid rootId from T_BG_BgForm a,T_Bg_BgScheme b where a.fbgschemeid=b.fid and a.fid = ?");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, bgFormId);
            rs = ps.executeQuery();
            if (rs.next()) {
                bgSchemeRootId = rs.getString(1);
            }
            if (bgSchemeRootId != null && !bgSchemeRootId.equals("")) {
                this.dealScheme(ctx, result, subOrgNumberMap, bgSchemeRootId);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return result;
    }

    private void dealScheme(Context ctx, Hashtable resultMap, Hashtable subOrgMap, String bgSchemeRootId) throws BOSException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            String sql = " select b.fid,a.fid,b.fnumber from t_bg_bgscheme a,t_org_baseunit b  where a.forgunitid=b.fid and a.frootid = ? ";
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.setString(1, bgSchemeRootId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String orgId = rs.getString(1);
                String schemeId = rs.getString(2);
                String orgNumber = rs.getString(3);
                if (!subOrgMap.containsKey(orgNumber)) continue;
                if (!resultMap.containsKey(orgId)) {
                    resultMap.put(orgId, schemeId);
                }
                subOrgMap.remove(orgNumber);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
    }

    private boolean hasChildSchemeOnOu(Context ctx, String schemeId, String schemeRootId, String orgUnitid) throws BOSException {
        boolean hasChild = false;
        if (schemeId == null) {
            hasChild = false;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer2 = new StringBuffer(200);
            strBuffer2.append("select FID from T_BG_BgScheme where FRootID=? and FOrgUnitID=?");
            ps = connection.prepareStatement(strBuffer2.toString());
            ps.setString(1, schemeRootId);
            ps.setString(2, orgUnitid);
            rs = ps.executeQuery();
            hasChild = rs.next();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return hasChild;
    }

    @Override
    protected boolean _checkTempParentQuotedBySchemeParent(Context ctx, String templateId, String schemeId) throws BOSException, EASBizException {
        boolean isquoted = false;
        if (schemeId == null || templateId == null) {
            isquoted = false;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer2 = new StringBuffer(200);
            strBuffer2.append("select FID from T_BG_BgSchemeNode where FBgSchemeID in (select FParentSchemeID from T_BG_BgScheme where FID=?) and FBgTemplateID in (select FParentID from T_BG_BgTemplate where FID=?)");
            ps = connection.prepareStatement(strBuffer2.toString());
            ps.setString(1, schemeId);
            ps.setString(2, templateId);
            rs = ps.executeQuery();
            isquoted = rs.next();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return isquoted;
    }

    @Override
    protected boolean _checkTempAssignedInBgScheme(Context ctx, String templateId, String schemeId) throws BOSException, EASBizException {
        boolean assigned = false;
        if (schemeId == null || templateId == null) {
            assigned = false;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            String sql = "select count(fid) from T_BG_BgSchemeNode where FBgSchemeID in(select FID from t_bg_bgScheme where FParentSchemeID=?) AND FBgTemplateID in(select FID from t_bg_bgTemplate where FParentID =?)";
            ps = connection.prepareStatement(sql);
            ps.setString(1, schemeId);
            ps.setString(2, templateId);
            rs = ps.executeQuery();
            assigned = rs.next() ? rs.getInt(1) > 0 : false;
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return assigned;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        BgSchemeInfo info = this.getBgSchemeInfo(ctx, pk, sic);
        BgHelper.recycleNumber(ctx, (CoreBaseInfo)info, info.getOrgUnit().getId().toString());
        super._delete(ctx, pk);
    }

    @Override
    protected IObjectCollection _getTemplateBySchemeToAddTem(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("isAllowChange"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("rootId"));
        sic.add(new SelectorItemInfo("defaultMeasureUnit"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("templateStatus"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.*"));
        sic.add(new SelectorItemInfo("bgType.*"));
        Vector<String> temId = new Vector<String>();
        BgTemplateInfo bgTemplateInfo = null;
        BgTemplateCollection templateColl = new BgTemplateCollection();
        IBgTemplate iBgTemplate = BgTemplateFactory.getLocalInstance(ctx);
        if (id == null) {
            return new BgTemplateCollection();
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(200);
            strBuffer.append("select fbgtemplateID  from T_BG_BgSchemenode where fbgschemeID= ?");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, id);
            rs = ps.executeQuery();
            strBuffer = null;
            while (rs.next()) {
                temId.add(rs.getString("fbgtemplateID"));
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        if (!temId.isEmpty()) {
            ArrayList<String> _tmpList = new ArrayList<String>();
            _tmpList.addAll(temId);
            try {
                connection = this.getConnection(ctx);
                StringBuffer strBuffer = new StringBuffer(1000);
                strBuffer.append("select fid  from T_BG_Bgtemplate where fID in (").append(BgNSQLHelper.getParamSizeString((int)temId.size())).append(")");
                strBuffer.append(" order by fnumber");
                ps = connection.prepareStatement(strBuffer.toString());
                BgNSQLHelper.setParams((PreparedStatement)ps, _tmpList);
                rs = ps.executeQuery();
                strBuffer = null;
                while (rs.next()) {
                    bgTemplateInfo = iBgTemplate.getBgTemplateInfo((IObjectPK)new ObjectUuidPK(rs.getString("fid")), sic);
                    templateColl.add(bgTemplateInfo);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
            }
        }
        return templateColl;
    }

    @Override
    protected IObjectCollection _getTemplate(Context ctx, String orgUnitID) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<Object> _tmpList = new ArrayList<Object>();
        BgTemplateInfo bgTemInfo = null;
        BgTemplateCollection coll = new BgTemplateCollection();
        IBgPermission iBgPermission = BgPermissionFactory.getLocalInstance(ctx);
        try {
            String selectSql = "select a.fid fid,a.fname aname,a.fnumber number,b.fname_" + ctx.getLocale().getLanguage() + " fname,a.fcreateTime createtime,a.fisAllowChange isAllowChange,a.FTemplateStatus FTemplateStatus, a.FFormType formType from t_bg_bgtemplate a  , t_pm_user b where a.fcreatorid=b.fid and a.FTemplateStatus=? and a.forgUnitid = ?";
            _tmpList.add(new Integer(0));
            _tmpList.add(orgUnitID);
            if (BgSHelper.isBgPermissionUsed(ctx)) {
                HashSet<String> orgSet = new HashSet<String>();
                orgSet.add(orgUnitID);
                String user = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                Set temPer = iBgPermission.getBgTemplatePermission(user, orgSet);
                Set schToTemPer = iBgPermission.getBgSchToTemPermission(user, orgSet);
                selectSql = selectSql + " and (";
                if (temPer != null && !temPer.isEmpty()) {
                    if (schToTemPer != null && !schToTemPer.isEmpty()) {
                        temPer = BgSchemeControllerBean.getSameId(temPer, schToTemPer);
                    }
                    selectSql = selectSql + " a.fid in " + BgHelper.tranSet2String(temPer);
                } else if (schToTemPer != null && !schToTemPer.isEmpty()) {
                    selectSql = selectSql + " a.fid in " + BgHelper.tranSet2String(schToTemPer);
                }
                Set temType = iBgPermission.getBgTemplateTypePermisson(user, orgSet);
                if (temType != null && !temType.isEmpty()) {
                    selectSql = temPer != null && !temPer.isEmpty() ? selectSql + " and a.FBgTypeID in " + BgHelper.tranSet2String(temType) : selectSql + " a.FBgTypeID in " + BgHelper.tranSet2String(temType);
                }
                if (!(temPer != null && !temPer.isEmpty() || temType != null && !temType.isEmpty() || schToTemPer != null && !schToTemPer.isEmpty())) {
                    selectSql = selectSql + " a.fid = '111'";
                }
                selectSql = selectSql + " or a.fcreatorid = '" + user + "' )";
            }
            selectSql = selectSql + " order by a.fnumber";
            conn = super.getConnection(ctx);
            ps = conn.prepareStatement(selectSql);
            BgNSQLHelper.setParams((PreparedStatement)ps, _tmpList);
            rs = ps.executeQuery();
            while (rs.next()) {
                bgTemInfo = new BgTemplateInfo();
                bgTemInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                bgTemInfo.setName(rs.getString("aname"));
                bgTemInfo.setNumber(rs.getString("number"));
                bgTemInfo.setFormType(BgTemFormTypeEnum.getEnum(rs.getInt("formType")));
                UserInfo creator = new UserInfo();
                creator.setName(rs.getString("fname"));
                bgTemInfo.setCreator(creator);
                bgTemInfo.setCreateTime(rs.getTimestamp("createTime"));
                int isAllow = rs.getInt("isAllowChange");
                if (isAllow == 0) {
                    isAllow = 1;
                }
                bgTemInfo.setIsAllowChange(BgTemModifyEnum.getEnum(isAllow));
                bgTemInfo.setTemplateStatus(BGTEMPLATE_STATUS_Enum.getEnum(rs.getInt("FTemplateStatus")));
                coll.add(bgTemInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return coll;
    }

    private static Set getSameId(Set temPer, Set schToTemPer) {
        HashSet<String> temId = new HashSet<String>();
        String id = null;
        Iterator ite = temPer.iterator();
        while (ite.hasNext()) {
            id = ite.next().toString();
            if (!schToTemPer.contains(id)) continue;
            temId.add(id);
        }
        return temId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _isAreadyDispatched(Context ctx, String rootID, String orgUnitID) throws BOSException, EASBizException {
        String sql = "select fid from t_bg_bgtemplate where forgunitid = ? and frootid =? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgUnitID, rootID});
        try {
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Hashtable _isAreadyDispatched(Context ctx, String rootID, Hashtable orgMap) throws BOSException, EASBizException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        String orgIdStr = "(''";
        for (String id : orgMap.keySet()) {
            orgIdStr = orgIdStr + ",'" + id + "'";
        }
        orgIdStr = orgIdStr + ")";
        String sql = "select forgunitid from t_bg_bgtemplate where forgunitid in " + orgIdStr + " and frootid =? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{rootID});
        try {
            while (rs.next()) {
                String orgId = rs.getString(1);
                result.put(orgId, orgId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return result;
    }

    @Override
    protected boolean _hasFormallyYearScheme(Context ctx, String unitID) throws BOSException, EASBizException {
        PreparedStatement ps;
        Connection conn;
        block5: {
            boolean bl;
            conn = null;
            ps = null;
            ResultSet rs = null;
            try {
                conn = super.getConnection(ctx);
                String sql = "";
                sql = unitID == null || unitID.trim().length() == 0 ? "select fid from T_BG_BgScheme where FformallyYearScheme = 1" : "select fid from T_BG_BgScheme where FformallyYearScheme = 1 and FOrgUnitID = ?";
                ps = conn.prepareStatement(sql);
                if (!StringUtils.isEmpty((String)unitID)) {
                    ps.setString(1, unitID);
                }
                if (!(rs = ps.executeQuery()).next()) break block5;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _checkIsUpdate(Context ctx, Map orgUnit) throws BOSException, EASBizException {
        if (orgUnit == null) return false;
        if (orgUnit.isEmpty()) {
            return false;
        }
        boolean re = false;
        Iterator iter = null;
        HashMap bgTemplateMap = new HashMap();
        Vector vct = null;
        String orgUnitId2222222 = null;
        String bgTemplateId2222222 = null;
        ArrayList _tmpList1 = new ArrayList();
        int batchNum = 300;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_BG_BgTemplate where FOrgUnitId in (");
        for (int i = 0; i < batchNum; ++i) {
            if (i != batchNum - 1) {
                sql.append("?").append(",");
                continue;
            }
            sql.append("?").append(")");
        }
        StringBuffer sqlFrootID = new StringBuffer("select FROOTID from T_BG_BgTemplate where ");
        boolean sqlFrootIDIsFirst = true;
        ArrayList<String> orgUnitList = new ArrayList<String>();
        for (String orgUnitId2222222 : orgUnit.keySet()) {
            orgUnitList.add(orgUnitId2222222);
            vct = (Vector)orgUnit.get(orgUnitId2222222);
            int n = vct.size();
            for (int i = 0; i < n; ++i) {
                bgTemplateId2222222 = (String)vct.get(i);
                bgTemplateMap.put(bgTemplateId2222222, null);
            }
        }
        ArrayList<String> _tmpList = new ArrayList<String>();
        for (String bgTemplateId2222222 : bgTemplateMap.keySet()) {
            if (sqlFrootIDIsFirst) {
                sqlFrootID.append(" FID = ?");
                sqlFrootIDIsFirst = false;
            } else {
                sqlFrootID.append(" OR FID = ?");
            }
            sqlFrootID.append(" or FROOTID = ?");
            _tmpList.add(bgTemplateId2222222);
            _tmpList.add(bgTemplateId2222222);
        }
        bgTemplateMap = new HashMap();
        Connection conn1 = null;
        PreparedStatement pstmt1 = null;
        ResultSet rst1 = null;
        try {
            conn1 = this.getConnection(ctx);
            pstmt1 = conn1.prepareStatement(sqlFrootID.toString());
            BgNSQLHelper.setParams((PreparedStatement)pstmt1, _tmpList);
            rst1 = pstmt1.executeQuery();
            while (rst1.next()) {
                bgTemplateMap.put(rst1.getString("FROOTID"), null);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst1, pstmt1, (Connection)conn1);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst1, (Statement)pstmt1, (Connection)conn1);
        if (bgTemplateMap == null) return false;
        if (bgTemplateMap.isEmpty()) {
            return false;
        }
        sql.append(" and FRootId in (");
        for (int i = 0; i < batchNum; ++i) {
            if (i != batchNum - 1) {
                sql.append("?").append(",");
                continue;
            }
            sql.append("?").append(")");
        }
        ArrayList<String> bgTemplateList = new ArrayList<String>();
        for (String bgTemplateId2222222 : bgTemplateMap.keySet()) {
            bgTemplateList.add(bgTemplateId2222222);
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int size = orgUnitList.size() > bgTemplateList.size() ? orgUnitList.size() : bgTemplateList.size();
            int count = (size - 1) / batchNum + 1;
            int orgUnit_pos = 0;
            int template_pos = 0;
            for (int i = 0; i < count; ++i) {
                int k;
                for (k = 1; k <= batchNum; ++k, ++orgUnit_pos) {
                    if (orgUnit_pos < orgUnitList.size()) {
                        pstmt.setString(k, (String)orgUnitList.get(orgUnit_pos));
                        continue;
                    }
                    pstmt.setString(k, "#");
                }
                for (k = batchNum + 1; k <= batchNum * 2; ++k, ++template_pos) {
                    if (template_pos < bgTemplateList.size()) {
                        pstmt.setString(k, (String)bgTemplateList.get(template_pos));
                        continue;
                    }
                    pstmt.setString(k, "#");
                }
                rst = pstmt.executeQuery();
                if (!rst.next()) continue;
                re = true;
                break;
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex3) {
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Vector getExamineIds(Context ctx, String templateId) throws Exception {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        Vector<String> examineIds;
        block5: {
            Vector vector;
            examineIds = new Vector<String>();
            String sql = "select FBgExamineID from t_bg_bgexaminenode where FBgTemplateID = ?";
            conn = null;
            pstmt = null;
            rs = null;
            conn = this.getConnection(ctx);
            try {
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, templateId);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    examineIds.add(rs.getString("FBgExamineID").toString());
                }
                if (examineIds.size() != 0) break block5;
                vector = null;
            }
            catch (SQLException sQLException) {
                SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return vector;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return examineIds;
    }

    private Vector getBgFormIdBgTemId(Context ctx, String templateId) throws BOSException, EASBizException {
        Vector<String> result = new Vector<String>();
        String sql = "select fid from t_bg_bgform where FBgTemplateID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{templateId});
        try {
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private void updateExamine(Context ctx, IObjectValue bgSchemeInfo, Vector orgIdVec, Hashtable idMap, Hashtable temMap) throws EASBizException, BOSException {
        Vector examineIds = new Vector();
        IBgExamineNode iBgExamineNode = BgExamineNodeFactory.getLocalInstance(ctx);
        if (bgSchemeInfo == null) {
            return;
        }
        String schemeId = ((BgSchemeInfo)bgSchemeInfo).getId().toString();
        for (int m = 0; m < orgIdVec.size(); ++m) {
            String orgUnitId = (String)orgIdVec.get(m);
            Vector temVec = new Vector();
            if (temMap.get(orgUnitId) == null) {
                return;
            }
            temVec = (Vector)temMap.get(orgUnitId);
            if (temVec.isEmpty()) {
                return;
            }
            IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
            BgTemplateCollection templatesByScheme = iBgScheme.getTemplateByScheme(schemeId);
            for (int i = 0; i < templatesByScheme.size(); ++i) {
                BgTemplateInfo upperInfo = templatesByScheme.get(i);
                if (!temVec.contains(templatesByScheme.get(i).getId().toString())) continue;
                try {
                    examineIds = this.getExamineIds(ctx, templatesByScheme.get(i).getId().toString());
                }
                catch (Exception e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                String rootId = upperInfo.getRootId().toString();
                Vector<String> vec = new Vector<String>();
                String sql = " select fid from t_bg_bgtemplate where frootid = ? and forgunitId = ?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{rootId, orgUnitId});
                try {
                    while (rs.next()) {
                        vec.add(rs.getString(1));
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                for (int k = 0; k < vec.size(); ++k) {
                    String temId = (String)vec.get(k);
                    if (examineIds == null) {
                        examineIds = new Vector();
                    }
                    iBgExamineNode.schemeExamineUpdate(temId, examineIds);
                }
            }
        }
    }

    @Override
    protected IObjectCollection _getSameSchemeByOrgNumbers(Context ctx, String[] orgNumbers) throws BOSException, EASBizException {
        if (orgNumbers == null || orgNumbers.length == 0) {
            return new BgSchemeCollection();
        }
        String sql = " select a.fid, a.fnumber, a.frootid from t_bg_bgscheme a , t_org_baseunit b  where a.forgunitid = b.fid and b.fnumber = ? ";
        sql = sql + " order by a.fnumber ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{orgNumbers[0].trim()});
        HashMap rootIdMap = new HashMap();
        HashMap numberMap = new HashMap();
        HashMap secondRootIdMap = new HashMap();
        HashMap secondNumberMap = new HashMap();
        HashMap tmpRootIdMap = new HashMap();
        HashMap tmpNumberMap = new HashMap();
        try {
            while (rs.next()) {
                numberMap.put(rs.getString(2), null);
                rootIdMap.put(rs.getString(3), null);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        for (int i = 1; i < orgNumbers.length; ++i) {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{orgNumbers[i].trim()});
            try {
                while (rs.next()) {
                    secondNumberMap.put(rs.getString(2), null);
                    secondRootIdMap.put(rs.getString(3), null);
                }
                for (String tmpNumger : secondNumberMap.keySet()) {
                    if (!numberMap.containsKey(tmpNumger)) continue;
                    tmpNumberMap.put(tmpNumger, null);
                }
                numberMap.clear();
                for (String tmpNumger : tmpNumberMap.keySet()) {
                    numberMap.put(tmpNumger, null);
                }
                secondNumberMap.clear();
                tmpNumberMap.clear();
                for (String tmpNumger : secondRootIdMap.keySet()) {
                    if (!rootIdMap.containsKey(tmpNumger)) continue;
                    tmpRootIdMap.put(tmpNumger, null);
                }
                rootIdMap.clear();
                for (String tmpNumger : tmpRootIdMap.keySet()) {
                    rootIdMap.put(tmpNumger, null);
                }
                secondRootIdMap.clear();
                tmpRootIdMap.clear();
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        String rootIds = "(''";
        Iterator it = rootIdMap.keySet().iterator();
        while (it.hasNext()) {
            rootIds = rootIds + ",'" + it.next() + "'";
        }
        rootIds = rootIds + " )";
        String numbers = "(''";
        Iterator it2 = numberMap.keySet().iterator();
        while (it2.hasNext()) {
            numbers = numbers + ",'" + it2.next() + "'";
        }
        numbers = numbers + " )";
        String orgStrs = "(''";
        for (int i = 0; i < orgNumbers.length; ++i) {
            orgStrs = orgStrs + ",'" + orgNumbers[i] + "'";
        }
        orgStrs = orgStrs + " )";
        String sql1 = "select aa.fid, aa.fnumber, aa.fname_" + ctx.getLocale() + ", aa.fisFormal, aa.fperiod, bb.FName_" + ctx.getLocale() + " from t_bg_bgscheme aa,t_org_baseunit bb  where aa.forgunitid = bb.fid  and aa.fnumber in  ( select distinct a.fnumber  \tfrom t_bg_bgscheme a , t_org_baseunit b  \twhere a.forgunitid = b.fid and b.fnumber in " + orgStrs + " \tand a.fnumber in " + numbers + "  \tand a.frootid in " + rootIds + " ) and bb.fnumber = ?";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{orgNumbers[0].trim()});
        BgSchemeCollection bgSchemeCol = new BgSchemeCollection();
        try {
            while (rs.next()) {
                BgSchemeInfo bgScheme = new BgSchemeInfo();
                String id = rs.getString(1);
                String number = rs.getString(2);
                String name = rs.getString(3);
                int isFormal = rs.getInt(4);
                int period = rs.getInt(5);
                bgScheme.setId(BOSUuid.read((String)id));
                bgScheme.setNumber(number);
                bgScheme.setName(name);
                bgScheme.setIsFormal(isFormal == 1);
                bgScheme.setPeriod(BgPeriodEnum.getEnum(period));
                bgScheme.setOrgUnit(new FullOrgUnitInfo());
                bgScheme.getOrgUnit().setName(rs.getString(6));
                bgSchemeCol.add(bgScheme);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return bgSchemeCol;
    }

    @Override
    protected boolean _executePlan(Context ctx, BOSUuid orgUnitId, BOSUuid bgSchemeId, BOSUuid bgPeriodId, String command) throws BOSException, EASBizException {
        if (orgUnitId == null || bgSchemeId == null || bgPeriodId == null || command == null) {
            return false;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement update = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        HashSet<BOSUuid> orgUnitSet = new HashSet<BOSUuid>();
        HashMap<BOSUuid, CostCenterOrgUnitInfo> orgUnitMap = new HashMap<BOSUuid, CostCenterOrgUnitInfo>();
        IPermission ipermission = null;
        ICostCenterOrgUnit iccOrgUnit = null;
        CostCenterOrgUnitInfo ccorgUnitInfo = null;
        CostCenterOrgUnitCollection ccOrgUnitCol = null;
        FullOrgUnitInfo fOrgUnitInfo = null;
        FullOrgUnitCollection fOrgUnitCol = null;
        BgSchemeInfo bgSchemeInfo = null;
        EntityViewInfo view = null;
        FilterInfo filter = null;
        int commandInt = 0;
        commandInt = command.equals("PLAN") ? 2 : (command.equals("BEFOREHAND") ? 1 : 0);
        try {
            conn = this.getConnection(ctx);
            bgSchemeInfo = BgFSHelper.getBgSchemeInfo(ctx, conn, bgSchemeId);
            ipermission = PermissionFactory.getLocalInstance((Context)ctx);
            iccOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            ccorgUnitInfo = iccOrgUnit.getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)(ccorgUnitInfo.getNumber() + "%"), CompareType.LIKE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            ccOrgUnitCol = iccOrgUnit.getCostCenterOrgUnitCollection(view);
            if (ccOrgUnitCol != null && !ccOrgUnitCol.isEmpty() && (fOrgUnitCol = BgNFSHelper.getOrgPermission((Context)ctx, (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()))) != null && !fOrgUnitCol.isEmpty()) {
                int jn = fOrgUnitCol.size();
                for (int j = 0; j < jn; ++j) {
                    fOrgUnitInfo = fOrgUnitCol.get(j);
                    orgUnitSet.add(fOrgUnitInfo.getId());
                }
                int in = ccOrgUnitCol.size();
                for (int i = 0; i < in; ++i) {
                    ccorgUnitInfo = ccOrgUnitCol.get(i);
                    if (!orgUnitSet.contains(ccorgUnitInfo.getId())) continue;
                    orgUnitMap.put(ccorgUnitInfo.getId(), ccorgUnitInfo);
                }
                if (!orgUnitMap.isEmpty()) {
                    ArrayList<String> _tmpList = new ArrayList<String>();
                    sql.append("select f.FID from t_bg_bgform f  left outer join T_BG_BgScheme s on f.FBgSchemeId = s.FID  where s.FRootId = ? and f.FbgPeriodId = ? and f.FOrgUnitId in (");
                    Iterator iter = orgUnitMap.keySet().iterator();
                    while (iter.hasNext()) {
                        sql.append("?,");
                        _tmpList.add(iter.next().toString());
                    }
                    sql.delete(sql.length() - 1, sql.length());
                    sql.append(")");
                    update = conn.prepareStatement("update T_BG_BgForm set FExecuteState = ? where FID = ?");
                    pstmt = conn.prepareStatement(sql.toString());
                    pstmt.setString(1, bgSchemeInfo.getRootId().toString());
                    pstmt.setString(2, bgPeriodId.toString());
                    BgNSQLHelper.setParams((PreparedStatement)pstmt, _tmpList, (int)3);
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        update.setInt(1, commandInt);
                        update.setString(2, rst.getString(1));
                        update.addBatch();
                    }
                    update.executeBatch();
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(update);
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return true;
    }

    @Override
    protected void _batchAntiExecuteScheme(Context ctx, BOSUuid bgSchemeId, BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (bgSchemeId == null || orgUnitId == null) {
            return;
        }
        BOSUuid bgSchemeRootId = null;
        BgSchemeInfo bgSchemeInfo = null;
        CostCenterOrgUnitInfo ccOrgUnitInfo2 = null;
        CostCenterOrgUnitCollection ccOrgUnitCol = null;
        ICostCenterOrgUnit iccorgUnit = null;
        EntityViewInfo view = null;
        FilterInfo filter = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            bgSchemeInfo = BgFSHelper.getBgSchemeInfo(ctx, conn, bgSchemeId);
            bgSchemeRootId = bgSchemeInfo.getRootId() != null ? bgSchemeInfo.getRootId() : bgSchemeId;
            iccorgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            if (iccorgUnit == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            ccOrgUnitInfo2 = iccorgUnit.getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)(ccOrgUnitInfo2.getNumber() + "%"), CompareType.LIKE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            ccOrgUnitCol = iccorgUnit.getCostCenterOrgUnitCollection(view);
            if (ccOrgUnitCol != null && !ccOrgUnitCol.isEmpty()) {
                pstmt = conn.prepareStatement("update T_BG_BgScheme set FisFormal = 0 where FOrgUnitId = ? and FRootID = ?");
                for (CostCenterOrgUnitInfo ccOrgUnitInfo2 : ccOrgUnitCol) {
                    pstmt.setString(1, ccOrgUnitInfo2.getId().toString());
                    pstmt.setString(2, bgSchemeRootId.toString());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
            iccorgUnit = null;
        }
    }

    @Override
    protected String _batchEexecuteScheme(Context ctx, IObjectPK bgSchemePK, BOSUuid orgUnitId) throws BOSException, EASBizException {
        String successStr = "";
        String errorStr = "";
        if (bgSchemePK == null || orgUnitId == null) {
            return null;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        IRowSet rs1 = null;
        try {
            String sql1 = " select frootid ,fdatefrom,fdateto from t_bg_bgscheme where fid = ?";
            String rootId = "";
            Timestamp dateFrom = null;
            Timestamp dateTo = null;
            rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{bgSchemePK.toString()});
            if (rs1.next()) {
                rootId = rs1.getString(1);
                dateFrom = rs1.getTimestamp(2);
                dateTo = rs1.getTimestamp(3);
            }
            String sql2 = "select flongnumber from t_org_baseunit where fid = ?";
            String longNumber = "";
            rs1 = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new String[]{orgUnitId.toString()});
            if (rs1.next()) {
                longNumber = rs1.getString(1);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, String> mapOrgName = new HashMap<String, String>();
            String sql = "select a.fid ,a.forgunitid ,b.fname_" + ctx.getLocale() + " from t_bg_bgscheme a,t_org_baseunit b  where a.forgunitid = b.fid and a.frootid = ? and ( b.flongnumber = ? or b.flongnumber like '" + longNumber + "!%')";
            rs1 = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{rootId, longNumber});
            while (rs1.next()) {
                map.put(rs1.getString(2), rs1.getString(1));
                mapOrgName.put(rs1.getString(2), rs1.getString(3));
            }
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(200);
            strBuffer.append("select FOrgUnitID  from T_BG_BgScheme where (FDateFrom <= ? and FDateTo >= ? ) and FIsFormal = 1");
            int index = 0;
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                it.next();
                if (index == 0) {
                    strBuffer.append(" and ((  FId <> ? and FOrgUnitID = ? ) ");
                } else {
                    strBuffer.append(" or (  FId <> ? and FOrgUnitID = ? ) ");
                }
                ++index;
            }
            strBuffer.append(" )");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setTimestamp(1, dateTo);
            ps.setTimestamp(2, dateFrom);
            index = 0;
            for (String orgId : map.keySet()) {
                String schemeId = (String)map.get(orgId);
                ps.setString(3 + index, schemeId);
                ps.setString(3 + ++index, orgId);
                ++index;
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                errorStr = errorStr + mapOrgName.get(rs.getString(1)) + ",";
                mapOrgName.remove(rs.getString(1));
                map.remove(rs.getString(1));
            }
            String updateSql = "update t_bg_bgscheme set fisformal = 1 where fid = ?";
            ps = connection.prepareStatement(updateSql);
            for (String orgId : map.keySet()) {
                String schemeId = (String)map.get(orgId);
                ps.setString(1, schemeId);
                ps.addBatch();
            }
            ps.executeBatch();
            for (String orgId : mapOrgName.keySet()) {
                successStr = successStr + mapOrgName.get(orgId) + ",";
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, connection);
                SQLUtils.cleanup(rs1);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        SQLUtils.cleanup((ResultSet)rs1);
        if (successStr.length() > 1) {
            successStr = successStr.substring(0, successStr.length() - 1);
        }
        if (errorStr.length() > 1) {
            errorStr = errorStr.substring(0, errorStr.length() - 1);
        }
        String str = successStr.trim().equals("") ? "" : ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgSchemeResource", (String)"exeSuccessOrg", (Locale)this.getLocale(ctx)) + successStr + "\u3002";
        str = str + (errorStr.trim().equals("") ? "" : ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgSchemeResource", (String)"exeErrorOrg", (Locale)this.getLocale(ctx)) + errorStr + "\u3002" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgSchemeResource", (String)"exeErrorReason", (Locale)this.getLocale(ctx)));
        str = str.trim();
        return str;
    }

    private Locale getLocale(Context ctx) {
        try {
            return ctx.getLocale();
        }
        catch (Throwable e) {
            logger.error((Object)("Get Locale fail!" + e.getMessage()));
            return new Locale("L2");
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        if (bgSchemeId == null) {
            return null;
        }
        Connection conn = null;
        BgSchemeInfo bgSchemeInfo = null;
        try {
            conn = this.getConnection(ctx);
            bgSchemeInfo = BgFSHelper.getBgSchemeInfo(ctx, conn, bgSchemeId);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bgSchemeInfo;
    }

    @Override
    protected Map _getCreatorByScheme(Context ctx, List bgSchemeId) throws BOSException, EASBizException {
        HashMap<String, String> schemeCreator = new HashMap<String, String>();
        if (ctx == null || bgSchemeId == null || bgSchemeId.isEmpty()) {
            return schemeCreator;
        }
        String schemeid = null;
        String creatorid = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            if (!bgSchemeId.isEmpty()) {
                conn = this.getConnection(ctx);
                int batchNum = 500;
                int size = bgSchemeId.size();
                int count = (size - 1) / batchNum + 1;
                int pos = 0;
                StringBuffer sql = new StringBuffer();
                sql.append("select fid, fcreatorid from T_BG_BGSCHEME where fid in (");
                for (int i = 0; i < batchNum; ++i) {
                    if (i != batchNum - 1) {
                        sql.append("?,");
                        continue;
                    }
                    sql.append("?)");
                }
                ps = conn.prepareStatement(sql.toString());
                for (int index = 0; index < count; ++index) {
                    int k = 1;
                    while (k <= batchNum) {
                        if (pos < size) {
                            ps.setString(k, (String)bgSchemeId.get(pos));
                        } else {
                            ps.setString(k, "#");
                        }
                        ++k;
                        ++pos;
                    }
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        schemeid = rs.getString("fid");
                        creatorid = rs.getString("fcreatorid");
                        schemeCreator.put(schemeid, creatorid);
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, ps, (Connection)conn);
        return schemeCreator;
    }
}

