/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.IRptSheetParam;
import com.kingdee.eas.fi.rpt.PostilTypeEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamFactory;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgCtrSettingFacadeFactory;
import com.kingdee.eas.ma.budget.BgCtrlSetHelper;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemHelper;
import com.kingdee.eas.ma.budget.BgMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.budget.BgSchemeAssignException;
import com.kingdee.eas.ma.budget.BgSchemeException;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemModifyEnum;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateException;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateHelper;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.BgTemplatePostilCollection;
import com.kingdee.eas.ma.budget.BgTemplatePostilFactory;
import com.kingdee.eas.ma.budget.BgTemplatePostilInfo;
import com.kingdee.eas.ma.budget.IBgCtrSettingFacade;
import com.kingdee.eas.ma.budget.IBgTemplatePostil;
import com.kingdee.eas.ma.budget.app.AbstractBgTemplateControllerBean;
import com.kingdee.eas.ma.nbudget.BgFacadeHelper;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.BgNTemplateException;
import com.kingdee.eas.ma.nbudget.BgNTemplateHelper;
import com.kingdee.eas.ma.nbudget.BgTemplateFacade;
import com.kingdee.eas.ma.view.BgViewDimensionFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgTemplateControllerBean
extends AbstractBgTemplateControllerBean {
    private static final long serialVersionUID = 1932690973363885138L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.app.BgTemplateControllerBean");

    @Override
    protected IObjectCollection _getCollctionByOrgUnit(Context ctx, String orgId) throws BOSException, EASBizException {
        BgTemplateCollection bgTemplateCollection = new BgTemplateCollection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(400);
            strBuffer.append("SELECT bgTemplate.FID AS FId, bgTemplate.FNumber AS FNumber, bgTemplate.FName AS FName, bgTemplate.FIsAllowChange AS FIsAllowChange, bgTemplate.FCreatorID AS FCreatorId, tUSER.FName_L2 AS FUserName, bgTemplate.FCreateTime AS FcreateTime FROM T_BG_BgTemplate bgTemplate, T_PM_User tUSER ,T_ORG_BaseUnit unit where bgTemplate.FCreatorID = tUSER.FID and bgTemplate.FOrgUnitID = unit.FID and unit.fid = ?");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, orgId);
            strBuffer = null;
            rs = ps.executeQuery();
            while (rs.next()) {
                BgTemplateInfo bgTemplateInfo = new BgTemplateInfo();
                bgTemplateInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                bgTemplateInfo.setNumber(rs.getString("FNumber"));
                bgTemplateInfo.setName(rs.getString("FName"));
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rs.getString("FCreatorId")));
                userInfo.setName(rs.getString("FUserName"));
                bgTemplateInfo.setCreator(userInfo);
                bgTemplateInfo.setCreateTime(rs.getTimestamp("FcreateTime"));
                bgTemplateCollection.add(bgTemplateInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return bgTemplateCollection;
    }

    private boolean checkDupNumber(Context ctx, String number, String id, String orgUnitId) throws BOSException, EASBizException {
        PreparedStatement sm;
        Connection connection;
        ResultSet rs;
        block6: {
            boolean bl;
            rs = null;
            connection = null;
            sm = null;
            StringBuffer sql = new StringBuffer(60);
            sql.append(" select fid from t_bg_bgtemplate where fnumber=? and forgunitid = ? ");
            if (!id.equals("")) {
                sql.append(" and fid != ?");
            }
            try {
                connection = this.getConnection(ctx);
                sm = connection.prepareStatement(sql.toString());
                sm.setString(1, number);
                sm.setString(2, orgUnitId);
                if (!id.equals("")) {
                    sm.setString(3, id);
                }
                if (!(rs = sm.executeQuery()).next()) break block6;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sm, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return false;
    }

    @Override
    protected String _dealWithBgItemCombin(Context ctx, String bgItemCombinStr) throws BOSException, EASBizException {
        String[] strs = bgItemCombinStr.split(",");
        String[] refF = new String[strs.length];
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        String result = "";
        try {
            int i;
            String sql = "select fnumber,fid,freffield from t_bg_bgitem where ";
            String numberFilterSql = "";
            for (int i2 = 0; i2 < strs.length; ++i2) {
                numberFilterSql = i2 == 0 ? " fnumber = ? " : numberFilterSql + "  or fnumber = ? ";
            }
            String orderSql = " order by '!'||freffield";
            sql = sql + numberFilterSql + orderSql;
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            for (int i3 = 0; i3 < strs.length; ++i3) {
                ps.setString(i3 + 1, strs[i3]);
            }
            rs = ps.executeQuery();
            int index = 0;
            while (rs.next()) {
                strs[index] = rs.getString(1);
                refF[index] = rs.getString(3);
                ++index;
            }
            StringBuffer strBuffer = new StringBuffer(400);
            strBuffer.append("select fid from t_bg_bgItemCombination where ");
            String key = "";
            for (i = 0; i < strs.length; ++i) {
                key = key + strs[i] + "_";
                if (i == 0) {
                    strBuffer.append(refF[i] + "='" + strs[i] + "'");
                    continue;
                }
                strBuffer.append(" and " + refF[i] + "='" + strs[i] + "'");
            }
            key = key.substring(0, key.length() - 1);
            strBuffer.append(" and fkey='" + key + "'");
            ps = connection.prepareStatement(strBuffer.toString());
            rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getString(1);
            }
            if (result.equals("")) {
                String fid;
                strBuffer = new StringBuffer(200);
                strBuffer.append(" insert into t_bg_bgItemCombination( fid ,");
                for (i = 0; i < refF.length; ++i) {
                    strBuffer.append(refF[i] + " , ");
                }
                strBuffer.append(" fkey ) ");
                strBuffer.append(" values( ? , ");
                for (i = 0; i < strs.length; ++i) {
                    strBuffer.append(" ? , ");
                }
                strBuffer.append(" ? ) ");
                ps = connection.prepareStatement(strBuffer.toString());
                result = fid = Uuid.create().toString() + "ABCDEFGH";
                ps.setString(1, fid);
                index = 2;
                key = "";
                for (int i4 = 0; i4 < strs.length; ++i4) {
                    ps.setString(index, strs[i4]);
                    key = key + strs[i4] + "_";
                    ++index;
                }
                key = key.substring(0, key.length() - 1);
                ps.setString(index, key);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return result;
    }

    private void insertMapData(Context ctx, String id, byte[] data) throws BOSException, BgNTemplateException {
        if (data == null) {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            try {
                Book book = Book.Manager.getNewBook();
                Sheet sheet = null;
                int n = book.getSheetCount();
                for (int i = 0; i < n; ++i) {
                    sheet = book.getSheet(i);
                    sheet.setUserObject("SHEET_CREATER_ID", (Object)userInfo.getId().toString());
                    BgNFSHelper.setSheetSign((Sheet)sheet);
                }
                Connection conn = null;
                try {
                    conn = this.getConnection(ctx);
                    BgNTemplateHelper.updateSheetName((Context)ctx, (Connection)conn, (String)id, (Book)book);
                }
                catch (Exception e) {
                    throw new BOSException(e.toString());
                }
                finally {
                    SQLUtils.cleanup((Connection)conn);
                }
                data = IOHelper.packBook((Book)book);
            }
            catch (IOException e) {
                throw new BgNTemplateException(BgNTemplateException.OPENBOOKFAIL, (Throwable)e);
            }
        }
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(400);
            strBuffer.append("update t_bg_bgtemplate set fdata = ? where fid = ? ");
            ps = connection.prepareStatement(strBuffer.toString());
            if (data == null) {
                ps.setBytes(1, null);
            } else {
                BgInfoHelper.setBytes((PreparedStatement)ps, (int)1, (byte[])data);
            }
            ps.setString(2, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgTemplateInfo templateInfo = (BgTemplateInfo)model;
        if (StringUtils.isEmpty((String)templateInfo.getNumber())) {
            BgHelper.setSNumber(ctx, templateInfo.getOrgUnit().getId().toString(), (CoreBaseInfo)templateInfo);
            if (StringUtils.isEmpty((String)templateInfo.getNumber())) {
                templateInfo.setNumber("BgTemplate-" + System.currentTimeMillis());
            }
        }
        if (templateInfo.getCU() == null) {
            templateInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (templateInfo.getRootId() == null) {
            if (templateInfo.getId() != null) {
                BOSUuid rootId = templateInfo.getId();
                templateInfo.setRootId(rootId);
            } else {
                BOSUuid id = BOSUuid.create((BOSObjectType)templateInfo.getBOSType());
                templateInfo.setId(id);
                templateInfo.setRootId(id);
            }
        }
        String number = templateInfo.getNumber();
        String orgUnitId = templateInfo.getOrgUnit().getId().toString();
        number = templateInfo.getNumber();
        if (this.checkDupNumber(ctx, number, "", orgUnitId)) {
            throw new BgTemplateException(BgTemplateException.NUMBERDUP);
        }
        if (number.indexOf("(") >= 0 || number.indexOf(")") >= 0) {
            throw new BgNFormException(BgNFormException.NUMBERERROR);
        }
        BgTemplateInfo coreInfo = templateInfo;
        Book book = null;
        if (templateInfo.getData() == null || templateInfo.getData().length == 0) {
            try {
                book = this.createNewBook(ctx);
                templateInfo.setBook(book);
            }
            catch (IOException e) {
                throw new BgNTemplateException(BgNTemplateException.OPENBOOKFAIL, (Throwable)e);
            }
        }
        try {
            book = templateInfo.getBook();
        }
        catch (Exception e) {
            // empty catch block
        }
        book = this.transAndCheckBook(ctx, templateInfo, book);
        boolean isEnum = false;
        if (templateInfo.getFormType() != null && templateInfo.getFormType().equals((Object)BgTemFormTypeEnum.ENUMERATEFORM)) {
            isEnum = true;
        }
        BgNTemplateHelper.initAliasObjectTem((Book)book, (boolean)isEnum);
        try {
            templateInfo.setBook(book);
        }
        catch (IOException ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgNTemplateHelper.updateSheetName((Context)ctx, (Connection)conn, (String)templateInfo.getId().toString(), (Book)book);
        }
        catch (Exception e) {
            throw new BOSException(e.toString());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)coreInfo);
        this.startBgParamBG033(ctx, (BgTemplateInfo)model);
        this.addBGSheetParam(ctx, templateInfo);
        return pk;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        String orgUnitId;
        String number;
        BgTemplateInfo templateInfo = (BgTemplateInfo)model;
        if (StringUtils.isEmpty((String)templateInfo.getNumber())) {
            BgHelper.setSNumber(ctx, templateInfo.getOrgUnit().getId().toString(), (CoreBaseInfo)templateInfo);
            if (StringUtils.isEmpty((String)templateInfo.getNumber())) {
                templateInfo.setNumber("BgTemplate-" + System.currentTimeMillis());
            }
        }
        if (templateInfo.getCU() == null) {
            templateInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (templateInfo.getRootId() == null) {
            if (templateInfo.getId() != null) {
                BOSUuid rootId = templateInfo.getId();
                templateInfo.setRootId(rootId);
            } else {
                BOSUuid id = BOSUuid.create((BOSObjectType)templateInfo.getBOSType());
                templateInfo.setId(id);
                templateInfo.setRootId(id);
            }
        }
        if (this.checkDupNumber(ctx, number = templateInfo.getNumber(), "", orgUnitId = templateInfo.getOrgUnit().getId().toString())) {
            throw new BgTemplateException(BgTemplateException.NUMBERDUP);
        }
        Book book = null;
        if (templateInfo.getData() == null || templateInfo.getData().length == 0) {
            try {
                book = this.createNewBook(ctx);
                templateInfo.setBook(book);
            }
            catch (IOException e) {
                throw new BgNTemplateException(BgNTemplateException.OPENBOOKFAIL, (Throwable)e);
            }
        }
        try {
            book = templateInfo.getBook();
        }
        catch (Exception e) {
            // empty catch block
        }
        book = this.transAndCheckBook(ctx, templateInfo, book);
        boolean isEnum = false;
        if (templateInfo.getFormType() != null && templateInfo.getFormType().equals((Object)BgTemFormTypeEnum.ENUMERATEFORM)) {
            isEnum = true;
        }
        BgNTemplateHelper.initAliasObjectTem((Book)book, (boolean)isEnum);
        try {
            templateInfo.setBook(book);
        }
        catch (IOException ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgNTemplateHelper.updateSheetName((Context)ctx, (Connection)conn, (String)templateInfo.getId().toString(), (Book)book);
        }
        catch (Exception e) {
            throw new BOSException(e.toString());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        super._addnew(ctx, pk, model);
        this.startBgParamBG033(ctx, (BgTemplateInfo)model);
        this.addBGSheetParam(ctx, templateInfo);
        this.updatePostil(ctx, templateInfo);
    }

    private void startBgParamBG033(Context ctx, BgTemplateInfo model) {
        if (model.getFormType().equals((Object)BgTemFormTypeEnum.SCRIPTFORM)) {
            try {
                DbUtil.execute((Context)ctx, (String)" update t_bas_paramitem set FIsModify = 1 where fid = 'JI9vazRdSxCLiiaqKVJJGe0ql5o=' ");
            }
            catch (Exception ex) {
                logger.error((Object)"error:", (Throwable)ex);
            }
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        String orgUnitId;
        String id;
        BgTemplateInfo templateInfo = (BgTemplateInfo)model;
        String number = templateInfo.getNumber();
        if (this.checkDupNumber(ctx, number, id = pk.toString(), orgUnitId = templateInfo.getOrgUnit().getId().toString())) {
            throw new BgTemplateException(BgTemplateException.NUMBERDUP);
        }
        Book book = null;
        try {
            if (templateInfo.getData() == null || templateInfo.getData().length == 0) {
                book = this.createNewBook(ctx);
                templateInfo.setBook(book);
            } else {
                book = templateInfo.getBook();
            }
        }
        catch (Exception e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR, e);
        }
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        if (book != null) {
            book = this.transAndCheckBook(ctx, templateInfo, book);
            boolean isEnum = false;
            if (templateInfo.getFormType() != null && templateInfo.getFormType().equals((Object)BgTemFormTypeEnum.ENUMERATEFORM)) {
                isEnum = true;
            }
            BgNTemplateHelper.initAliasObjectTem((Book)book, (boolean)isEnum);
        }
        BgTemplateInfo _tmpInfo = new BgTemplateInfo();
        _tmpInfo.setId(templateInfo.getId());
        _tmpInfo.setName(templateInfo.getName());
        _tmpInfo.setNumber(templateInfo.getNumber());
        _tmpInfo.setDescription(templateInfo.getDescription());
        _tmpInfo.setBgType(templateInfo.getBgType());
        _tmpInfo.setDefaultMeasureUnit(templateInfo.getDefaultMeasureUnit());
        _tmpInfo.getBgMeasureUnit().addCollection(templateInfo.getBgMeasureUnit());
        _tmpInfo.setIsAllowChange(templateInfo.getIsAllowChange());
        _tmpInfo.setCanModify(templateInfo.getCanModify());
        if (_tmpInfo.getCanModify() == null) {
            _tmpInfo.setCanModify(BgTemModifyEnum.CANMODIFY);
        }
        try {
            _tmpInfo.setBook(book);
        }
        catch (IOException ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgNTemplateHelper.updateSheetName((Context)ctx, (Connection)conn, (String)pk.toString(), (Book)book);
        }
        catch (Exception e) {
            throw new BOSException(e.toString());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        super._update(ctx, pk, (IObjectValue)_tmpInfo);
        this.addBGSheetParam(ctx, templateInfo);
        this.updatePostil(ctx, templateInfo);
    }

    protected Book createNewBook(Context ctx) {
        Book book = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        book = Book.Manager.getNewBook(null, (int)1);
        Sheet sheet = null;
        int n = book.getSheetCount();
        for (int i = 0; i < n; ++i) {
            sheet = book.getSheet(i);
            sheet.setUserObject("SHEET_CREATER_ID", (Object)userInfo.getId().toString());
            BgNFSHelper.setSheetSign((Sheet)sheet);
        }
        return book;
    }

    protected Book transAndCheckBook(Context ctx, BgTemplateInfo model, Book book) throws BOSException, EASBizException {
        if (ctx == null || model == null || book == null) {
            return book;
        }
        boolean isAssignTemplate = Boolean.TRUE.equals(ctx.get((Object)BgNFSHelper.getTemplateKey((Context)ctx, (BgTemplateInfo)model)));
        Sheet sheet = null;
        Cell cell = null;
        String formulaStr = null;
        String expression = null;
        String _tmpStr = null;
        String[] formula = null;
        String[] _tmpStrs = null;
        String[] bgItemNums = null;
        ArrayList<String[]> checkList = new ArrayList<String[]>();
        ArrayList<String> formulaList = new ArrayList<String>();
        ArrayList<String> bgItemNumList = new ArrayList<String>();
        HashSet<String> bgPeriodVariable = new HashSet<String>();
        HashSet<String> bgItemSet = new HashSet<String>();
        HashSet<String> bgPeriodSet = new HashSet<String>();
        HashSet<String> bgElementSet = new HashSet<String>();
        HashSet<String> currencySet = new HashSet<String>();
        String orgUnitId = model.getOrgUnit() == null ? ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString() : model.getOrgUnit().getId().toString();
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        boolean isAnalyseSheet = false;
        if (model.getBgType() != null && "BV/FQwEUEADgABtLwKgSXv9s2OA=".equals(model.getBgType().getId().toString())) {
            isAnalyseSheet = true;
        }
        int sheetCount = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            int maxRowCount = sheet.getMaxRowIndex();
            int maxColCount = sheet.getMaxColIndex();
            for (int i = 0; i <= maxRowCount; ++i) {
                for (int j = 0; j <= maxColCount; ++j) {
                    cell = sheet.getCell(i, j, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
                    formulaList.add(formulaStr);
                    if (isAnalyseSheet) {
                        throw new BgTemplateException(BgTemplateException.SELF_ANA_TEM_NOT_ALLOW_ITEMFORMUL);
                    }
                    formula = new String[]{sheet.getSheetName(), formulaStr, String.valueOf(i), String.valueOf(j)};
                    checkList.add(formula);
                    _tmpStrs = BgNFSHelper.parseFormulaPara((String)formulaStr);
                    if (_tmpStrs == null || _tmpStrs.length != 6) {
                        throw new BgException(BgException.BGITEMPARSEERROR, new String[]{formulaStr});
                    }
                    _tmpStr = _tmpStrs[0];
                    if (StringUtils.isEmpty((String)_tmpStr)) {
                        String msg = sheet.getSheetName() + "," + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"item.formula.not.exit", (Locale)ctx.getLocale());
                        throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, new String[]{msg});
                    }
                    bgItemSet.add(_tmpStr.replaceAll(",", "_"));
                    bgItemNums = _tmpStr.split(",");
                    for (int x = 0; x < bgItemNums.length; ++x) {
                        if (bgItemNumList.contains(bgItemNums[x])) continue;
                        bgItemNumList.add(bgItemNums[x]);
                    }
                    _tmpStr = _tmpStrs[2];
                    if (StringUtils.isEmpty((String)_tmpStr)) {
                        String msg = sheet.getSheetName() + "," + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"element.formula.not.exit", (Locale)ctx.getLocale());
                        throw new BgSchemeException(BgSchemeException.COMMONEXCEPTION, new String[]{msg});
                    }
                    bgElementSet.add(_tmpStr);
                    _tmpStr = _tmpStrs[1];
                    if (!StringUtils.isEmpty((String)_tmpStr) && !bgPeriodVariable.contains(_tmpStr)) {
                        boolean isRelativeBgPeriod = false;
                        int relativeValue = 0;
                        try {
                            relativeValue = Integer.parseInt(_tmpStr);
                            isRelativeBgPeriod = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (isRelativeBgPeriod) {
                            if (Math.abs(relativeValue) > 100) {
                                String msg = sheet.getSheetName() + "," + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"itemformula.to.100.to100", (Locale)ctx.getLocale());
                                throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, (Object[])new String[]{msg});
                            }
                        } else if (BgPeriodNVariableHelper.checkCanConvert(_tmpStr)) {
                            bgPeriodVariable.add(_tmpStr);
                        } else {
                            bgPeriodSet.add(_tmpStr);
                        }
                    }
                    if (!StringUtils.isEmpty((String)(_tmpStr = _tmpStrs[5]))) {
                        currencySet.add(_tmpStr);
                    }
                    if (!StringUtils.isEmpty((String)(expression = (String)BgNFSHelper.getCellData((Cell)cell, (String)"BG_BUDGET_EXPRESSIONS"))) && !isAssignTemplate) {
                        try {
                            ExcelFormulaPaserHelper.parse((String)expression);
                        }
                        catch (Exception e) {
                            String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"inDataFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                            throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, (Object[])new String[]{msg});
                        }
                    }
                    if (!StringUtils.isEmpty((String)(expression = (String)BgNFSHelper.getCellData((Cell)cell, (String)"BG_ACTUAL_EXPRESSIONS"))) && !isAssignTemplate) {
                        try {
                            ExcelFormulaPaserHelper.parse((String)expression);
                        }
                        catch (Exception e) {
                            String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"inActualFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                            throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, (Object[])new String[]{msg});
                        }
                    }
                    if (StringUtils.isEmpty((String)(expression = (String)BgNFSHelper.getCellData((Cell)cell, (String)"BG_ADD_EXPRESSIONS"))) || isAssignTemplate) continue;
                    try {
                        ExcelFormulaPaserHelper.parse((String)expression);
                        continue;
                    }
                    catch (Exception e) {
                        String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"inADDFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                        throw new BgNTemplateException(BgNTemplateException.ITEMFORMUL_RE_EXIT, (Object[])new String[]{msg});
                    }
                }
            }
        }
        try {
            BgItemHelper.checkBgItemExist(ctx, orgUnitId, bgItemNumList);
            BgNTemplateHelper.checkFormulaIsEctype(checkList, (Locale)ctx.getLocale());
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            checkList.clear();
        }
        Connection conn = null;
        Map bgItemMap = null;
        Map bgPeriodMap = null;
        Map bgElementMap = null;
        Map currencyMap = null;
        ArrayList<String> bgItemList = new ArrayList<String>();
        ArrayList<String> bgPeriodList = new ArrayList<String>();
        ArrayList<String> bgElementList = new ArrayList<String>();
        ArrayList<String> currencyList = new ArrayList<String>();
        bgItemList.addAll(bgItemSet);
        bgPeriodList.addAll(bgPeriodSet);
        bgElementList.addAll(bgElementSet);
        currencyList.addAll(currencySet);
        try {
            conn = this.getConnection(ctx);
            bgItemMap = BgFacadeHelper.getBgItemMap((Connection)conn, null, bgItemList);
            bgItemMap = BgFacadeHelper.createBgItemMap((Context)ctx, (Map)bgItemMap, bgItemList, (String)orgUnitId);
            bgPeriodMap = BgFacadeHelper.getBgPeriodMap((Connection)conn, null, bgPeriodList);
            bgElementMap = BgFacadeHelper.getBgElementMap((Connection)conn, null, bgElementList);
            currencyMap = BgFacadeHelper.getCurrencyMap((Connection)conn, null, currencyList);
            BgTemplateFacade.clearRefBgItem((Connection)conn, (BOSUuid)model.getId());
            if (bgItemSet != null && bgItemSet.size() > 0) {
                BgTemplateFacade.dealRefBgItem((Connection)conn, (BOSUuid)model.getId(), bgItemSet, (Map)bgItemMap);
            }
            BgTemplateFacade.clearRefBgPeriod((Connection)conn, (BOSUuid)model.getId());
            if (bgPeriodSet != null && bgPeriodSet.size() > 0) {
                BgTemplateFacade.dealRefBgPeriod((Connection)conn, (BOSUuid)model.getId(), bgPeriodSet, (Map)bgPeriodMap);
            }
            BgTemplateFacade.clearRefBgElement((Connection)conn, (BOSUuid)model.getId());
            if (bgElementSet != null && bgElementSet.size() > 0) {
                BgTemplateFacade.dealRefBgElement((Connection)conn, (BOSUuid)model.getId(), bgElementSet, (Map)bgElementMap);
            }
            BgTemplateFacade.clearRefCurrency((Connection)conn, (BOSUuid)model.getId());
            if (currencySet != null && currencySet.size() > 0) {
                BgTemplateFacade.dealRefCurrency((Connection)conn, (BOSUuid)model.getId(), currencySet, (Map)currencyMap);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        if (!formulaList.isEmpty()) {
            Hashtable newCtrlModeMap = new Hashtable();
            Hashtable temp = null;
            IBgCtrSettingFacade ibgCtrl = BgCtrSettingFacadeFactory.getLocalInstance(ctx);
            Map ctrlModeMap = ibgCtrl.getBgTemplateCtrlModeMap(model.getId());
            Hashtable defCtrlModep = ibgCtrl.getDefCtrlSetByTemplateID(model.getId().toString());
            int in = formulaList.size();
            for (int i = 0; i < in; ++i) {
                formulaStr = (String)formulaList.get(i);
                if (!ctrlModeMap.containsKey(formulaStr)) {
                    temp = new Hashtable();
                    if (defCtrlModep != null && !defCtrlModep.isEmpty()) {
                        temp.put("isCtrl", defCtrlModep.get("isCtrl"));
                        temp.put("isFlexCtrl", defCtrlModep.get("isFlexCtrl"));
                        temp.put("flexCtrlParam", defCtrlModep.get("flexCtrlParam"));
                        temp.put("periodCtrlPolicy", defCtrlModep.get("periodCtrlPolicy"));
                        temp.put("isGroupCtrl", defCtrlModep.get("isGroupCtrl"));
                        temp.put("groupCtrlNo", defCtrlModep.get("groupCtrlNo"));
                        temp.put("isFromSuper", Boolean.FALSE);
                        temp.put("isCtrlAllowChange", Boolean.TRUE);
                        temp.put("isAllowAccess", defCtrlModep.get("isAllowAccess"));
                        temp.put("ctrlModeFrom", new Integer(-1));
                    } else {
                        temp = BgCtrlSetHelper.getNoCtrlMap(formulaStr);
                    }
                    newCtrlModeMap.put(formulaStr, temp);
                    continue;
                }
                newCtrlModeMap.put(formulaStr, ctrlModeMap.get(formulaStr));
            }
            if (!newCtrlModeMap.isEmpty()) {
                ibgCtrl.insertTemplateCtrl(model.getOrgUnit().getId().toString(), model.getId().toString(), newCtrlModeMap);
            }
        } else {
            String deleteSql = "DELETE T_BG_BgTemplateCtrlSetting WHERE FBgTemplateID = ? ";
            DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new Object[]{String.valueOf(model.getId())});
        }
        return book;
    }

    private void addBGSheetParam(Context ctx, VirtualSheetParamInfo virtualSheetParamInfo) throws BOSException, EASBizException {
        String sql1 = "DELETE FROM T_RPT_RptPostil WHERE FREPORTID=?";
        DbUtil.execute((Context)ctx, (String)sql1, (Object[])new Object[]{virtualSheetParamInfo.getId().toString()});
        IRptSheetParam isheet = RptSheetParamFactory.getLocalInstance((Context)ctx);
        RptSheetParamCollection rptSheetParamCollection = virtualSheetParamInfo.getSheetParam();
        ReportBaseInfo info = new ReportBaseInfo();
        info.setId(virtualSheetParamInfo.getId());
        if (rptSheetParamCollection != null && rptSheetParamCollection.size() > 0) {
            BOSUuid id = virtualSheetParamInfo.getId();
            if (id != null) {
                String sql = "DELETE FROM T_RPT_RptSheetPara WHERE FREPORTID=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id.toString()});
            }
            int rptSheetParamInfoSize = rptSheetParamCollection.size();
            for (int i = 0; i < rptSheetParamInfoSize; ++i) {
                BOSUuid spid;
                RptSheetParamInfo rptSheetParamInfo = rptSheetParamCollection.get(i);
                if (rptSheetParamInfo == null) continue;
                if (rptSheetParamInfo.getId() != null && (spid = rptSheetParamInfo.getId()) != null) {
                    String sql = "DELETE FROM T_RPT_RptPostil WHERE FSHEETID=?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{spid.toString()});
                }
                rptSheetParamInfo.setId(null);
                rptSheetParamInfo.setReport((VirtualSheetParamInfo)info);
                isheet.addnew((CoreBaseInfo)rptSheetParamInfo);
            }
        }
    }

    private void updatePostil(Context ctx, BgTemplateInfo info) throws BOSException {
        if (info == null) {
            return;
        }
        String pk = info.getId().toString();
        try {
            String sql = "DELETE FROM T_BG_BgTempaltePostil WHERE ftemplateid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
            BgTemplatePostilCollection postils = (BgTemplatePostilCollection)((Object)info.get("postils"));
            IBgTemplatePostil ip = BgTemplatePostilFactory.getLocalInstance(ctx);
            if (postils != null) {
                for (int i = 0; i < postils.size(); ++i) {
                    BgTemplatePostilInfo p = postils.get(i);
                    if (!p.getTemplate().getId().toString().equals(pk)) continue;
                    p.setId(null);
                    if (!p.getPostilType().equals((Object)PostilTypeEnum.REPORT)) {
                        ip.addnew((CoreBaseInfo)p);
                        continue;
                    }
                    if (p.getStatus() != 1 && p.getStatus() != 2) continue;
                    ip.addnew((CoreBaseInfo)p);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _deleteCombinItemByKey(Context ctx, Map combinMap) throws BOSException, EASBizException {
        if (combinMap == null) return;
        if (combinMap.isEmpty()) {
            return;
        }
        HashMap removeMap = new HashMap();
        String bgItemCombinId = null;
        String bgItemCombinNumber = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstdel = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer remove = new StringBuffer();
        Set keySet = combinMap.keySet();
        String[] array = keySet.toArray(new String[0]);
        sql.append("select FID, FKey from T_Bg_BgItemCombination where FKey in ");
        sql.append(BgHelper.tranArray2String4Pre(array));
        sql.append(" and (FID not in (select distinct FBgItemCombinId from T_BG_BgTemrefBgItemCombin)) and (FID not in (select distinct FBgItemCombinId from T_BG_BgrefBgItemCombin)) and (FID not in (select distinct FBgItemCombinId from t_bg_bgcontrolitemmap))");
        remove.append("delete from T_Bg_BgItemCombination where FID = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            BgHelper.setParamString4Pre(0, array, pstmt);
            pstdel = conn.prepareStatement(remove.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgItemCombinId = rst.getString(1);
                bgItemCombinNumber = rst.getString(2);
                pstdel.setString(1, bgItemCombinId);
                pstdel.addBatch();
            }
            pstdel.executeBatch();
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstdel);
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstdel);
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    private void checkBgItemHasField(Map bgItemMap) throws BgTemplateException {
        for (Object key : bgItemMap.keySet()) {
            String value = (String)bgItemMap.get(key);
            if (!value.equals("")) continue;
            throw new BgTemplateException(BgTemplateException.EXISTERRORBGITEM, new Object[]{key});
        }
    }

    private Hashtable insertNewCombin(Context ctx, Map keyMap, Map bgItemMap) throws BOSException {
        PreparedStatement ps = null;
        Connection connection = null;
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            int i;
            String field;
            String combinStr2 = "";
            connection = this.getConnection(ctx);
            Vector<String> fieldVec = new Vector<String>();
            for (Object obj : bgItemMap.keySet()) {
                field = (String)bgItemMap.get(obj);
                if (fieldVec.contains(field)) continue;
                fieldVec.add(field);
            }
            String sql = " insert into t_bg_bgItemCombination( fid ,";
            for (i = 0; i < fieldVec.size(); ++i) {
                field = fieldVec.get(i);
                sql = sql + field + " , ";
            }
            sql = sql + " fkey ) ";
            sql = sql + " values( ? , ";
            for (i = 0; i < fieldVec.size(); ++i) {
                sql = sql + " ? , ";
            }
            sql = sql + " ? ) ";
            ps = connection.prepareStatement(sql);
            for (String combinStr2 : keyMap.keySet()) {
                String[] strs = combinStr2.split(",");
                String fid = Uuid.create().toString() + "ABCDEFGH";
                result.put(combinStr2, fid);
                String key = combinStr2.replaceAll(",", "_");
                ps.setString(1, fid);
                int k = 2;
                for (int j = 0; j < fieldVec.size(); ++j) {
                    String _refField = (String)fieldVec.get(j);
                    int pot = -1;
                    for (int i2 = 0; i2 < strs.length; ++i2) {
                        String refField = (String)bgItemMap.get(strs[i2]);
                        if (!_refField.equals(refField)) continue;
                        pot = i2;
                        break;
                    }
                    if (pot == -1) {
                        ps.setString(k, null);
                    } else {
                        ps.setString(k, strs[pot]);
                    }
                    ++k;
                }
                ps.setString(k, key);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
        return result;
    }

    private void getExistCombin(Context ctx, String keys, Hashtable result, int maxKeySize) throws BOSException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        if (result == null) {
            result = new Hashtable<String, String>();
        }
        try {
            keys = keys.replaceAll("\\(", "");
            keys = keys.replaceAll("\\)", "");
            String sql = "select fid ,fkey from t_bg_bgItemCombination where fkey = ? ";
            for (int i = 1; i < maxKeySize; ++i) {
                sql = sql + " or fkey = ? ";
            }
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            String[] strs = keys.split(",");
            int index = 1;
            for (int i = 0; i < strs.length; ++i) {
                ps.setString(index, strs[i].replaceAll("'", "").trim());
                ++index;
            }
            while (index <= maxKeySize) {
                ps.setString(index, "");
                ++index;
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                result.put(rs.getString(2).replaceAll("_", ","), rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
    }

    private String getCombinKey(String combinStr) {
        if (combinStr == null) {
            return "";
        }
        return combinStr.replaceAll(",", "_");
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isAllowChange"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("mapData"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("rootId"));
        sic.add(new SelectorItemInfo("defaultMeasureUnit"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("templateStatus"));
        sic.add(new SelectorItemInfo("formType"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.*"));
        sic.add(new SelectorItemInfo("bgType.*"));
        return sic;
    }

    @Override
    protected void _clone(Context ctx, IObjectPK bgTemplatePK) throws BOSException, EASBizException {
        SelectorItemCollection sic = this.getSelectors();
        BgTemplateInfo info = this.getBgTemplateInfo(ctx, bgTemplatePK, sic);
        BgTemplateInfo cloneInfo = info.deepClone();
        if (ContextUtil.getCurrentUserInfo((Context)ctx) != null) {
            cloneInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        cloneInfo.setNumber("clone_" + cloneInfo.getNumber());
        cloneInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BgSchemeResource", (String)"clone", (Locale)ctx.getLocale()) + "_" + cloneInfo.getName());
        if (cloneInfo.getNumber().length() > 80) {
            throw new BgTemplateException(BgTemplateException.NUMBERTOOLONG);
        }
        if (cloneInfo.getName().length() > 80) {
            throw new BgTemplateException(BgTemplateException.NAMETOOLONG);
        }
        if (this.checkDupNumber(ctx, cloneInfo.getNumber(), "", cloneInfo.getOrgUnit().getId().toString())) {
            throw new BgTemplateException(BgTemplateException.NUMBERDUP);
        }
        String newBgTemplateId = cloneInfo.getId().toString();
        String sql1 = "insert into t_bg_bgtemrefbgitemcombin(fid,fbgitemcombinid,fbgtemplateid)  select newbosid('0536ABF1'),fbgitemcombinid,'" + newBgTemplateId + "'  from t_bg_bgtemrefbgitemcombin where fbgtemplateid = ?";
        String sql2 = "insert into t_bg_bgtemrefbgperiod(fid,fbgperiodid,fbgtemplateid)  select newbosid('F051E0D9'),fbgperiodid,'" + newBgTemplateId + "'  from t_bg_bgtemrefbgperiod where fbgtemplateid = ?";
        String sql3 = "insert into t_bg_bgtemrefbgelement(fid,fbgelementid,fbgtemplateid)  select newbosid('DF4216E4'),fbgelementid,'" + newBgTemplateId + "'  from t_bg_bgtemrefbgelement where fbgtemplateid = ?";
        String sql4 = "insert into t_bg_bgtemrefcurrency(fid,fcurrencyid,fbgtemplateid)  select newbosid('0536ABF1'),fcurrencyid,'" + newBgTemplateId + "'  from t_bg_bgtemrefcurrency where fbgtemplateid = ?";
        DbUtil.execute((Context)ctx, (String)sql1, (Object[])new String[]{bgTemplatePK.toString()});
        DbUtil.execute((Context)ctx, (String)sql2, (Object[])new String[]{bgTemplatePK.toString()});
        DbUtil.execute((Context)ctx, (String)sql3, (Object[])new String[]{bgTemplatePK.toString()});
        DbUtil.execute((Context)ctx, (String)sql4, (Object[])new String[]{bgTemplatePK.toString()});
        try {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            Book book = cloneInfo.getBook();
            Sheet sheet = null;
            int n = book.getSheetCount();
            for (int i = 0; i < n; ++i) {
                sheet = book.getSheet(i);
                sheet.setUserObject("SHEET_CREATER_ID", (Object)userInfo.getId().toString());
                BgNFSHelper.setSheetSign((Sheet)sheet);
            }
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
            }
            catch (Exception e) {
                throw new BOSException(e.toString());
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
            cloneInfo.setData(IOHelper.packBook((Book)book));
        }
        catch (IOException e) {
            throw new BgNTemplateException(BgNTemplateException.OPENBOOKFAIL, (Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException(e.toString());
        }
        super._save(ctx, (IObjectValue)cloneInfo);
        IBgCtrSettingFacade ibgCtrl = BgCtrSettingFacadeFactory.getLocalInstance(ctx);
        Map ctrlModeMap = ibgCtrl.getBgTemplateCtrlModeMap(info.getId());
        ibgCtrl.insertTemplateCtrl(cloneInfo.getOrgUnit().getId().toString(), cloneInfo.getId().toString(), (Hashtable)ctrlModeMap);
    }

    @Override
    protected void _saveSimpleInfo(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement sm = null;
        StringBuffer sql = new StringBuffer(60);
        BgTemplateInfo bgTemInfo = (BgTemplateInfo)info;
        String id = bgTemInfo.getId().toString();
        String name = bgTemInfo.getName();
        String number = bgTemInfo.getNumber();
        String description = bgTemInfo.getDescription();
        String orgUnitId = bgTemInfo.getOrgUnit().getId().toString();
        String bgTypeId = bgTemInfo.getBgType() == null ? null : bgTemInfo.getBgType().getId().toString();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        if (bgTemInfo.getDefaultMeasureUnit() == null) {
            throw new BgTemplateException(BgTemplateException.HAVENOTSETDEFAULTMEASUREUNIT);
        }
        String measureId = bgTemInfo.getDefaultMeasureUnit().getId().toString();
        int modifyType = bgTemInfo.getIsAllowChange().getValue();
        BgTemModifyEnum canModifyEnum = bgTemInfo.getCanModify();
        int canModify = 1;
        if (canModifyEnum != null) {
            canModify = canModifyEnum.getValue();
        }
        if (this.checkDupNumber(ctx, number, id, orgUnitId)) {
            throw new BgTemplateException(BgTemplateException.NUMBERDUP);
        }
        if (this.isSelfAny(bgTemInfo)) {
            bgTemInfo = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateInfo((IObjectPK)new ObjectUuidPK(bgTemInfo.getId()));
            Book book = null;
            try {
                book = bgTemInfo.getBook();
            }
            catch (Exception e) {
                throw new BgSchemeAssignException(BgSchemeAssignException.OPEN_KDF_ERROR);
            }
            int sheetCount = book.getSheetCount();
            for (int k = 0; k < sheetCount; ++k) {
                Sheet sheet = book.getSheet(k);
                int maxRowIndex = sheet.getMaxRowIndex();
                for (int i = 0; i <= maxRowIndex; ++i) {
                    int maxColIndex = sheet.getMaxColIndex();
                    for (int j = 0; j <= maxColIndex; ++j) {
                        Cell cell = sheet.getCell(i, j, false);
                        if (cell == null || !BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) continue;
                        throw new BgTemplateException(BgTemplateException.SELF_ANA_TEM_NOT_ALLOW_ITEMFORMUL);
                    }
                }
            }
        }
        sql.append(" update t_bg_bgtemplate set fname = ? ,fnumber = ? ,fdescription = ? , fbgtypeid = ? ,fDefaultMeasureUnitId = ? ,fisallowchange = ?,FCanModify=?,FLastUpdateTime=? where fid = ? ");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, name);
            sm.setString(2, number);
            sm.setString(3, description);
            sm.setString(4, bgTypeId);
            sm.setString(5, measureId);
            sm.setInt(6, modifyType);
            sm.setInt(7, canModify);
            sm.setString(9, id);
            sm.setTimestamp(8, time);
            sm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)connection);
    }

    @Override
    protected boolean _checkRefByScheme(Context ctx, String id) throws BOSException, EASBizException {
        boolean result = false;
        Connection connection = null;
        PreparedStatement sm = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" select count(fid) cnt from T_Bg_BgSchemeNode where FBgTemplateID = ? ");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, id);
            rs = sm.executeQuery();
            int cnt = 0;
            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)connection);
        return result;
    }

    @Override
    protected boolean _checkRefByForm(Context ctx, String id) throws BOSException, EASBizException {
        boolean result = false;
        Connection connection = null;
        PreparedStatement sm = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" select count(fid) cnt from T_Bg_BgForm where FBgTemplateID = ? ");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, id);
            rs = sm.executeQuery();
            int cnt = 0;
            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)connection);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected boolean _hasChildTemplate(Context ctx, String templateId) throws BOSException, EASBizException {
        boolean hasChild;
        block8: {
            hasChild = false;
            if (templateId == null) {
                hasChild = false;
            }
            PreparedStatement ps = null;
            ResultSet rs = null;
            Connection connection = null;
            try {
                connection = this.getConnection(ctx);
                StringBuffer strBuffer = new StringBuffer(200);
                strBuffer.append("select FID from T_BG_BgTemplate where FParentID=? and fid <> ?");
                ps = connection.prepareStatement(strBuffer.toString());
                ps.setString(1, templateId);
                ps.setString(2, templateId);
                rs = ps.executeQuery();
                hasChild = rs.next();
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            catch (SQLException e2) {
                logger.error((Object)"budget error:", (Throwable)e2);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
            }
        }
        return hasChild;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("mapData"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("formType"));
        BgTemplateInfo info = this.getBgTemplateInfo(ctx, pk, sic);
        BgHelper.recycleNumber(ctx, (CoreBaseInfo)info, info.getOrgUnit().getId().toString());
        Vector combinIdVec = this.getBudgetItemMap(ctx, info.getId().toString());
        String sql1 = " delete from t_bg_bgtemrefbgitemcombin where fbgtemplateid = ? ";
        String sql2 = " delete from t_bg_bgtemrefcurrency where fbgtemplateid = ? ";
        String sql3 = " delete from t_bg_bgtemrefbgelement where fbgtemplateid = ? ";
        String sql4 = " delete from t_bg_bgtemrefbgperiod where fbgtemplateid = ? ";
        String sql5 = " delete from T_BG_BgTemplateCtrlSetting where fbgtemplateid = ? ";
        DbUtil.execute((Context)ctx, (String)sql1, (Object[])new String[]{pk.toString()});
        DbUtil.execute((Context)ctx, (String)sql2, (Object[])new String[]{pk.toString()});
        DbUtil.execute((Context)ctx, (String)sql3, (Object[])new String[]{pk.toString()});
        DbUtil.execute((Context)ctx, (String)sql4, (Object[])new String[]{pk.toString()});
        DbUtil.execute((Context)ctx, (String)sql5, (Object[])new String[]{pk.toString()});
        super._delete(ctx, pk);
        BgTemplateFacade.clearRefBgItem((Connection)this.getConnection(ctx), (BOSUuid)BOSUuid.read((String)pk.toString()));
        BgTemFormTypeEnum bgEnum = info.getFormType();
        if (bgEnum.getValue() == BgTemFormTypeEnum.VIEWFORM.getValue()) {
            BgViewDimensionFactory.getLocalInstance((Context)ctx).deleteDimension(pk.toString());
        }
        BgTemplateHelper.deleteCombinItem(ctx, combinIdVec);
        String sql6 = " delete from t_bg_bgTemSheet where FBgTemplateID = ? ";
        DbUtil.execute((Context)ctx, (String)sql6, (Object[])new String[]{pk.toString()});
        boolean isHadScriptTem = this.isHadScriptTem(ctx);
        if (!isHadScriptTem) {
            String sql = " update t_bas_paramitem set FIsModify = 0 where fid = 'JI9vazRdSxCLiiaqKVJJGe0ql5o=' ";
            try {
                DbUtil.execute((Context)ctx, (String)sql);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isHadScriptTem(Context ctx) {
        String sql1 = " select fid  from t_bg_bgtemplate where FFormType = ? ";
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new Object[]{new Integer(2)});
            return row.next();
        }
        catch (Exception e) {
            return true;
        }
    }

    private Vector getBudgetItemMap(Context ctx, String id) throws BgSchemeAssignException {
        String sql1 = " select FBgItemCombinId  from t_bg_bgtemrefbgitemcombin where fbgtemplateid = ? ";
        Vector<String> idVec = new Vector<String>();
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{id});
            while (row.next()) {
                idVec.add(row.getString("FBgItemCombinId"));
            }
        }
        catch (BOSException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        catch (SQLException e) {
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR, e);
        }
        return idVec;
    }

    @Override
    protected Hashtable _getItemCombinIds(Context ctx, List itemCombinList) throws BOSException, EASBizException {
        Hashtable result = new Hashtable();
        Hashtable<String, String> keyMap = new Hashtable<String, String>();
        Vector<String> vecBgItemCombinNumber = new Vector<String>();
        for (int i = 0; i < itemCombinList.size(); ++i) {
            String combinStr = (String)itemCombinList.get(i);
            String key = this.getCombinKey(combinStr);
            keyMap.put(combinStr, key);
            vecBgItemCombinNumber.add(combinStr);
        }
        Vector<String> keysVec = new Vector<String>();
        int h = 1;
        int GROUPSIZE = 50;
        String keys = " ( ''";
        for (Object obj : keyMap.keySet()) {
            String key = (String)keyMap.get(obj);
            keys = keys + ",'" + key + "'";
            if (++h != GROUPSIZE) continue;
            h = 1;
            keys = keys + " )";
            keysVec.add(keys);
            keys = " ( ''";
        }
        if (h < GROUPSIZE && h != 1) {
            keys = keys + " )";
            keysVec.add(keys);
        }
        Hashtable existCombinMap = new Hashtable();
        for (h = 0; h < keysVec.size(); ++h) {
            keys = (String)keysVec.get(h);
            this.getExistCombin(ctx, keys, existCombinMap, GROUPSIZE);
        }
        for (Object obj : existCombinMap.keySet()) {
            if (!keyMap.containsKey(obj)) continue;
            keyMap.remove(obj);
        }
        if (!keyMap.isEmpty()) {
            HashMap<String, String> bgItemMap = new HashMap<String, String>();
            for (String obj : keyMap.keySet()) {
                String[] strs = obj.split(",");
                for (int i = 0; i < strs.length; ++i) {
                    if (bgItemMap.containsKey(strs[i])) continue;
                    bgItemMap.put(strs[i], "");
                }
            }
            FullOrgUnitInfo curOU = ctx.get((Object)"CurOU") == null ? null : (FullOrgUnitInfo)ctx.get((Object)"CurOU");
            BgNFSHelper.getRefField((Context)ctx, bgItemMap, (String)(curOU == null ? "00000000-0000-0000-0000-000000000000CCE7AED4" : curOU.getId().toString()));
            this.checkBgItemHasField(bgItemMap);
            Hashtable newCombinMap = this.insertNewCombin(ctx, keyMap, bgItemMap);
            for (int i = 0; i < vecBgItemCombinNumber.size(); ++i) {
                if (existCombinMap.containsKey(vecBgItemCombinNumber.get(i))) {
                    result.put(vecBgItemCombinNumber.get(i), existCombinMap.get(vecBgItemCombinNumber.get(i)));
                    continue;
                }
                if (!newCombinMap.containsKey(vecBgItemCombinNumber.get(i))) continue;
                result.put(vecBgItemCombinNumber.get(i), newCombinMap.get(vecBgItemCombinNumber.get(i)));
            }
        } else {
            for (int i = 0; i < vecBgItemCombinNumber.size(); ++i) {
                if (!existCombinMap.containsKey(vecBgItemCombinNumber.get(i))) continue;
                result.put(vecBgItemCombinNumber.get(i), existCombinMap.get(vecBgItemCombinNumber.get(i)));
            }
        }
        return result;
    }

    @Override
    protected Hashtable _getItemCombinIds(Context ctx, List itemCombinList, String orgUnitId) throws BOSException, EASBizException {
        Hashtable result = new Hashtable();
        Hashtable<String, String> keyMap = new Hashtable<String, String>();
        Vector<String> vecBgItemCombinNumber = new Vector<String>();
        for (int i = 0; i < itemCombinList.size(); ++i) {
            String combinStr = (String)itemCombinList.get(i);
            String key = this.getCombinKey(combinStr);
            keyMap.put(combinStr, key);
            vecBgItemCombinNumber.add(combinStr);
        }
        Vector<String> keysVec = new Vector<String>();
        int h = 1;
        int GROUPSIZE = 50;
        String keys = " ( ''";
        for (Object obj : keyMap.keySet()) {
            String key = (String)keyMap.get(obj);
            keys = keys + ",'" + key + "'";
            if (++h != GROUPSIZE) continue;
            h = 1;
            keys = keys + " )";
            keysVec.add(keys);
            keys = " ( ''";
        }
        if (h < GROUPSIZE && h != 1) {
            keys = keys + " )";
            keysVec.add(keys);
        }
        Hashtable existCombinMap = new Hashtable();
        for (h = 0; h < keysVec.size(); ++h) {
            keys = (String)keysVec.get(h);
            this.getExistCombin(ctx, keys, existCombinMap, GROUPSIZE);
        }
        for (Object obj : existCombinMap.keySet()) {
            if (!keyMap.containsKey(obj)) continue;
            keyMap.remove(obj);
        }
        if (!keyMap.isEmpty()) {
            HashMap<String, String> bgItemMap = new HashMap<String, String>();
            for (String obj : keyMap.keySet()) {
                String[] strs = obj.split(",");
                for (int i = 0; i < strs.length; ++i) {
                    if (bgItemMap.containsKey(strs[i])) continue;
                    bgItemMap.put(strs[i], "");
                }
            }
            BgNFSHelper.getRefField((Context)ctx, bgItemMap, (String)orgUnitId);
            this.checkBgItemHasField(bgItemMap);
            Hashtable newCombinMap = this.insertNewCombin(ctx, keyMap, bgItemMap);
            for (int i = 0; i < vecBgItemCombinNumber.size(); ++i) {
                if (existCombinMap.containsKey(vecBgItemCombinNumber.get(i))) {
                    result.put(vecBgItemCombinNumber.get(i), existCombinMap.get(vecBgItemCombinNumber.get(i)));
                    continue;
                }
                if (!newCombinMap.containsKey(vecBgItemCombinNumber.get(i))) continue;
                result.put(vecBgItemCombinNumber.get(i), newCombinMap.get(vecBgItemCombinNumber.get(i)));
            }
        } else {
            for (int i = 0; i < vecBgItemCombinNumber.size(); ++i) {
                if (!existCombinMap.containsKey(vecBgItemCombinNumber.get(i))) continue;
                result.put(vecBgItemCombinNumber.get(i), existCombinMap.get(vecBgItemCombinNumber.get(i)));
            }
        }
        return result;
    }

    @Override
    protected void _saveMeasure(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        BgTemplateInfo bgTem = (BgTemplateInfo)info;
        String id = bgTem.getId().toString();
        PreparedStatement ps = null;
        Connection connection = null;
        BOSObjectType type = new BgMeasureUnitInfo().getBOSType();
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(80);
            strBuffer.append("delete t_bg_bgtemmeasureunit where fbgtemplateid = ? ");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, id);
            ps.executeUpdate();
            if (bgTem.getBgMeasureUnit() != null && bgTem.getBgMeasureUnit().size() != 0) {
                strBuffer = new StringBuffer(80);
                strBuffer.append("insert into t_bg_bgtemmeasureunit(fid,fbgtemplateid,fbgelementid,fmeasureunitid) values(?,?,?,?)");
                ps = connection.prepareStatement(strBuffer.toString());
                for (int i = 0; i < bgTem.getBgMeasureUnit().size(); ++i) {
                    ps.setString(1, BOSUuid.create((BOSObjectType)type).toString());
                    ps.setString(2, id);
                    ps.setString(3, bgTem.getBgMeasureUnit().get(i).getBgElement().getId().toString());
                    ps.setString(4, bgTem.getBgMeasureUnit().get(i).getMeasureUnit().getId().toString());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    @Override
    protected void _updateCheckRelation(Context ctx, String id, HashMap chkRelation) throws BOSException, EASBizException {
        BgTemplateInfo info = this.getBgTemplateInfo(ctx, "select id ,data where id = '" + id + "'");
        byte[] bytesData = null;
        try {
            if (info.getData() == null) {
                return;
            }
            Book book = info.getBook();
            if (book == null || book.getSheetCount() <= 0) {
                return;
            }
            for (Object key : chkRelation.keySet()) {
                Object value = chkRelation.get(key);
                book.setUserObject(key.toString(), value);
            }
            if (book == null) {
                return;
            }
            bytesData = IOHelper.packBook((Book)book);
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"58_BgTemplateControllerBean", (Locale)ctx.getLocale()), (Throwable)e);
        }
        this.insertMapData(ctx, id, bytesData);
    }

    private boolean isSelfAny(BgTemplateInfo templateInfo) {
        boolean isSelAny = false;
        if (templateInfo.getBgType() != null && templateInfo.getBgType().getId().toString().equals("BV/FQwEUEADgABtLwKgSXv9s2OA=")) {
            isSelAny = true;
        }
        return isSelAny;
    }

    @Override
    protected Map _verifyTemplate(Context ctx, Map idNum) throws BOSException, EASBizException {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String listRefByScheme = null;
        String listRefByForm = null;
        String listHasChild = null;
        String id2 = null;
        String number = null;
        for (String id2 : idNum.keySet()) {
            number = (String)idNum.get(id2);
            if (this._checkRefByScheme(ctx, id2)) {
                listRefByScheme = listRefByScheme == null ? number : listRefByScheme + "," + number;
            }
            if (this._checkRefByForm(ctx, id2)) {
                listRefByForm = listRefByForm == null ? number : listRefByForm + "," + number;
            }
            if (!this._hasChildTemplate(ctx, id2)) continue;
            if (listHasChild == null) {
                listHasChild = number;
                continue;
            }
            listHasChild = listHasChild + "," + number;
        }
        returnMap.put("listRefByScheme", listRefByScheme);
        returnMap.put("listRefByForm", listRefByForm);
        returnMap.put("listHasChild", listHasChild);
        return returnMap;
    }

    @Override
    protected Object _insertSheetName(Context ctx, Object obj) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Object _delSheetName(Context ctx, Object obj) throws BOSException, EASBizException {
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object _getSheetName(Context ctx, Object obj) throws BOSException, EASBizException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        String temId = (String)obj;
        if (StringUtils.isEmpty((String)temId)) {
            return result;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String[] sheetInfo = null;
        String sheetId = null;
        String sheetName = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FSheetId, FSheetName from T_BG_BgTemSheet where FbgTemplateID = ? order by FSheetIndex");
            pstmt.setString(1, temId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                sheetId = rst.getString(1);
                sheetName = rst.getString(2);
                sheetInfo = new String[]{sheetId, sheetName};
                result.add(sheetInfo);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return result;
    }

    protected IObjectPK[] _addnewBatchData(Context arg0, IObjectCollection arg1) throws BOSException, EASBizException {
        for (int i = 0; i < arg1.size(); ++i) {
            BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)arg1.getObject(i);
            this._addnew(arg0, (IObjectValue)bgTemplateInfo);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _updateDataInfo(Context ctx, IObjectValue templateInfo) throws BOSException, EASBizException {
        if (templateInfo == null) return;
        if (templateInfo.getString("id") == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_BG_BgTemplate set FData = ? where FID = ?");
            byte[] bytes = templateInfo.getBytes("data");
            if (bytes != null && bytes.length > 0) {
                pstmt.setBinaryStream(1, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
            } else {
                pstmt.setBytes(1, null);
            }
            pstmt.setString(2, templateInfo.getString("id"));
            pstmt.executeUpdate();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

