/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.cache.CacheEngine;
import com.kingdee.bos.cache.CacheObject;
import com.kingdee.bos.cache.CacheRegion;
import com.kingdee.bos.cache.DefaultObjectMonitor;
import com.kingdee.bos.cache.ObjectAttributes;
import com.kingdee.bos.cache.ObjectMonitor;
import com.kingdee.bos.cache.RegionAttributes;

public final class BudgetCtrlCache {
    private static final String BUDGET_CTRL_CACHE_NAME = "budgetAppBudgetCtrlCache";
    private static final int IDLE_TIME_OUT = 1800000;
    private CacheRegion region = null;
    private static final BudgetCtrlCache INSTANCE = new BudgetCtrlCache();

    private BudgetCtrlCache() {
        this.initCacheRegion();
    }

    private void initCacheRegion() {
        CacheRegion rootRegion = CacheEngine.getLocalRootRegion();
        RegionAttributes regionAttrs = new RegionAttributes();
        regionAttrs.setMonitor((ObjectMonitor)new DefaultObjectMonitor());
        ObjectAttributes objAttrs = new ObjectAttributes();
        objAttrs.setLong(6, 1800000L);
        objAttrs.setMonitor((ObjectMonitor)new DefaultObjectMonitor());
        this.region = rootRegion.createSubRegion((Object)BUDGET_CTRL_CACHE_NAME, regionAttrs, objAttrs);
    }

    public static BudgetCtrlCache getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(Object name, Object value) {
        if (this.region.exists(name)) {
            this.destroyObject(name);
        }
        this.region.putObject(name, value, this.getDefaultObjectAttributes());
        CacheObject cacheObject = null;
        try {
            cacheObject = this.region.getObject(name);
        }
        catch (Throwable throwable) {
            BudgetCtrlCache.releaseCacheObject(cacheObject);
            throw throwable;
        }
        BudgetCtrlCache.releaseCacheObject(cacheObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Object name) {
        CacheObject cacheObject;
        block3: {
            Object object;
            cacheObject = null;
            try {
                cacheObject = this.region.getObject(name);
                if (cacheObject == null || !cacheObject.isAvailable() || cacheObject.isDestroyed() || !cacheObject.isObject()) break block3;
                object = cacheObject.get();
            }
            catch (Throwable throwable) {
                BudgetCtrlCache.releaseCacheObject(cacheObject);
                throw throwable;
            }
            BudgetCtrlCache.releaseCacheObject(cacheObject);
            return object;
        }
        Object var3_4 = null;
        BudgetCtrlCache.releaseCacheObject(cacheObject);
        return var3_4;
    }

    public boolean exists(Object name) {
        return this.region.exists(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(Object name) {
        CacheRegion cacheRegion = this.region;
        synchronized (cacheRegion) {
            CacheObject cacheObject = null;
            try {
                cacheObject = this.region.getObject(name);
                if (cacheObject != null) {
                    cacheObject.destroy();
                }
            }
            catch (Throwable throwable) {
                BudgetCtrlCache.releaseCacheObject(cacheObject);
                throw throwable;
            }
            BudgetCtrlCache.releaseCacheObject(cacheObject);
        }
    }

    private static void releaseCacheObject(CacheObject cacheObject) {
        if (cacheObject != null) {
            cacheObject.release();
        }
    }

    private ObjectAttributes getDefaultObjectAttributes() {
        ObjectAttributes regionAttrs = new ObjectAttributes();
        regionAttrs.setLong(6, 1800000L);
        regionAttrs.setMonitor((ObjectMonitor)new DefaultObjectMonitor());
        return regionAttrs;
    }
}

