/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormulaFacadeFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BudgetCtrlUtil;
import com.kingdee.eas.ma.budget.app.BudgetCtrlCache;
import com.kingdee.eas.ma.budget.app.BudgetCtrlHelper;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BudgetCtrlCacheHelper {
    private static Logger logger = Logger.getLogger(BudgetCtrlCacheHelper.class);
    public static final String SPLITER = "###";
    public static final String COSTCENTER = "costCenter";
    public static final String BGSCHEME = "bgScheme";
    public static final String BGITEMCOMBINATION_KEY = "bgItemCombinationKey";
    public static final String BGITEMCOMBINATION_NAME = "bgItemCombinationName";
    public static final String BGPERIOD = "bgPeriod";
    public static final String BGELEMENT = "bgElement";
    public static final String CURRENCY = "currency";
    public static final String SUPER_BGITEMCOMBINATION_KEYS = "superBgItemCombinationKeys";

    public static synchronized CostCenterOrgUnitInfo getCostCenter(Context ctx, String costCenterNumber) throws EASBizException {
        String ais;
        String _key;
        if (BudgetCtrlUtil.isEmpty(costCenterNumber)) {
            return null;
        }
        BudgetCtrlCache cache = BudgetCtrlCache.getInstance();
        Object value = cache.getObject(_key = (ais = ctx.getAIS()) + SPLITER + COSTCENTER + SPLITER + costCenterNumber);
        if (value != null) {
            return (CostCenterOrgUnitInfo)value;
        }
        CostCenterOrgUnitInfo costCenter = BudgetCtrlHelper.getCostCenterOrgUnit(ctx, costCenterNumber);
        if (costCenter == null) {
            return null;
        }
        if (cache.exists(_key)) {
            cache.destroyObject(_key);
        }
        cache.putObject(_key, costCenter);
        return costCenter;
    }

    public static synchronized BgElementInfo getBgElement(Context ctx, String bgElementNumber) throws EASBizException {
        String ais;
        String _key;
        if (BudgetCtrlUtil.isEmpty(bgElementNumber)) {
            return null;
        }
        BudgetCtrlCache cache = BudgetCtrlCache.getInstance();
        Object value = cache.getObject(_key = (ais = ctx.getAIS()) + SPLITER + BGELEMENT + SPLITER + bgElementNumber);
        if (value != null) {
            return (BgElementInfo)value;
        }
        BgElementInfo bgElement = BudgetCtrlHelper.getBgElement(ctx, bgElementNumber);
        if (bgElement == null) {
            return null;
        }
        if (cache.exists(_key)) {
            cache.destroyObject(_key);
        }
        cache.putObject(_key, bgElement);
        return bgElement;
    }

    public static synchronized CurrencyInfo getCurrency(Context ctx, String currencyNumber) throws EASBizException {
        String ais;
        String _key;
        if (BudgetCtrlUtil.isEmpty(currencyNumber)) {
            return null;
        }
        BudgetCtrlCache cache = BudgetCtrlCache.getInstance();
        Object value = cache.getObject(_key = (ais = ctx.getAIS()) + SPLITER + CURRENCY + SPLITER + currencyNumber);
        if (value != null) {
            return (CurrencyInfo)value;
        }
        CurrencyInfo currency = BudgetCtrlHelper.getCurrency(ctx, currencyNumber);
        if (currency == null) {
            return null;
        }
        if (cache.exists(_key)) {
            cache.destroyObject(_key);
        }
        cache.putObject(_key, currency);
        return currency;
    }

    public static String getBgItemCombinationKey(Context ctx, String bgItemCombinationKey, String orgUnitId) throws EASBizException, BOSException {
        String ais;
        if (BudgetCtrlUtil.isEmpty(bgItemCombinationKey)) {
            return null;
        }
        BudgetCtrlCache cache = BudgetCtrlCache.getInstance();
        Object value = cache.getObject((ais = ctx.getAIS()) + SPLITER + BGITEMCOMBINATION_KEY + SPLITER + bgItemCombinationKey);
        if (value != null) {
            return (String)value;
        }
        String retBgItemCombinationKey = BgFormulaFacadeFactory.getLocalInstance(ctx).parseBgItemCombi_ctrl(bgItemCombinationKey, orgUnitId);
        if (retBgItemCombinationKey == null) {
            return bgItemCombinationKey;
        }
        cache.putObject(ais + SPLITER + BGITEMCOMBINATION_KEY + SPLITER + bgItemCombinationKey, retBgItemCombinationKey);
        return retBgItemCombinationKey;
    }

    public static String getBgItemCombinationName(Context ctx, String bgItemCombinationKey, String orgUnitId) throws EASBizException, BOSException {
        String ais;
        if (BudgetCtrlUtil.isEmpty(bgItemCombinationKey)) {
            return null;
        }
        BudgetCtrlCache cache = BudgetCtrlCache.getInstance();
        Object value = cache.getObject((ais = ctx.getAIS()) + SPLITER + BGITEMCOMBINATION_NAME + SPLITER + orgUnitId + SPLITER + bgItemCombinationKey);
        if (value != null) {
            return (String)value;
        }
        String itemCombinationName = BudgetCtrlHelper.getItemCombinName(ctx, bgItemCombinationKey, orgUnitId);
        if (itemCombinationName == null) {
            return bgItemCombinationKey;
        }
        cache.putObject(ais + SPLITER + BGITEMCOMBINATION_NAME + SPLITER + orgUnitId + SPLITER + bgItemCombinationKey, itemCombinationName);
        return itemCombinationName;
    }

    public static synchronized Set getSuperiorBgItemCombinationKeys(Context ctx, String bgItemCombintionKey, Map bgItemSupInfo) throws BOSException, EASBizException {
        String ais;
        String _key;
        HashSet<String> superiorItemKeys = new HashSet<String>();
        if (BudgetCtrlUtil.isEmpty(bgItemCombintionKey)) {
            return superiorItemKeys;
        }
        if (bgItemSupInfo == null || bgItemSupInfo.isEmpty()) {
            return superiorItemKeys;
        }
        BudgetCtrlCache cache = BudgetCtrlCache.getInstance();
        Object value = cache.getObject(_key = (ais = ctx.getAIS()) + SPLITER + SUPER_BGITEMCOMBINATION_KEYS + SPLITER + bgItemCombintionKey);
        if (value != null) {
            return (Set)value;
        }
        HashMap keyMap = new HashMap();
        Map<String, Object> tmpMap = null;
        String keyString = null;
        for (String number : bgItemSupInfo.keySet()) {
            BgItemInfo bgItemInfo = (BgItemInfo)bgItemSupInfo.get(number);
            if (keyMap.containsKey(bgItemInfo.getBgItemGroup().getRefField())) {
                tmpMap = (Map)keyMap.get(bgItemInfo.getBgItemGroup().getRefField());
            } else {
                tmpMap = new HashMap();
                keyMap.put(bgItemInfo.getBgItemGroup().getRefField(), tmpMap);
            }
            tmpMap.put(bgItemInfo.getNumber(), null);
        }
        StringBuffer kSql = new StringBuffer(2048);
        kSql.append("select FKey from T_BG_BgItemCombination where ");
        for (int i = 1; i <= 250; ++i) {
            keyString = "F" + i;
            if (keyMap.containsKey(keyString)) {
                tmpMap = (Map)keyMap.get(keyString);
                kSql.append("(" + keyString + " in (");
                Iterator iter = tmpMap.keySet().iterator();
                while (iter.hasNext()) {
                    kSql.append("'" + iter.next() + "',");
                }
                kSql.delete(kSql.length() - 1, kSql.length());
                kSql.append(") or " + keyString + " is null) and ");
                continue;
            }
            kSql.append("(" + keyString + " is null) and ");
        }
        kSql.append("(FKey <> ?)");
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rst = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(kSql.toString());
            statement.setString(1, bgItemCombintionKey.replaceAll(",", "_"));
            rst = statement.executeQuery();
            while (rst.next()) {
                superiorItemKeys.add(rst.getString(1).replaceAll("_", ","));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)statement, (Connection)conn);
        if (cache.exists(_key)) {
            cache.destroyObject(_key);
        }
        cache.putObject(_key, superiorItemKeys);
        return superiorItemKeys;
    }
}

