/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BudgetRequestType;
import com.kingdee.eas.ma.budget.app.BudgetCtrlHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BudgetCtrlLogger {
    protected static final Logger logger = Logger.getLogger(BudgetCtrlLogger.class);
    protected static final SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    public static void logRequestBudget(Context ctx, BudgetRequestType type, BgCtrlResultCollection ctrlResultCol) {
        if (ctrlResultCol == null || ctrlResultCol.size() == 0) {
            return;
        }
        if (BudgetRequestType.LOCAL_APPROVE != type && BudgetRequestType.WF_APPROVE != type && BudgetRequestType.SPECIAL_APPROVE != type) {
            return;
        }
        String billAlias = BudgetCtrlLogger.getStringValue(ctrlResultCol.get(0).getBillType());
        StringBuffer logMsg = new StringBuffer();
        logMsg.append("---requestBudgetLog---\n");
        logMsg.append("REQUEST_BUDGET_TYPE is " + type + "\n");
        logMsg.append(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"74_BudgetCtrlLogger", (Locale)ctx.getLocale()) + billAlias + "\n");
        logMsg.append(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"75_BudgetCtrlLogger", (Locale)ctx.getLocale()) + dateFormater.format(new Date()) + "\n");
        for (int i = 0; i < ctrlResultCol.size(); ++i) {
            BgCtrlResultInfo ctrlResultInfo = ctrlResultCol.get(i);
            if (ctrlResultInfo.getBgDataId() == null || ctrlResultInfo.getReqAmount() == null || ctrlResultInfo.getReqAmount().floatValue() == 0.0f) continue;
            logMsg.append("billId = " + BudgetCtrlLogger.getStringValue(ctrlResultInfo.getBillId()) + "\n");
            logMsg.append("BgDataId = " + BudgetCtrlLogger.getStringValue(ctrlResultInfo.getBgDataId()) + "\n");
            logMsg.append("orgUnitId = " + BudgetCtrlLogger.getStringValue(ctrlResultInfo.getOrgUnitId()) + "\n");
            logMsg.append("BgSchemeId = " + BudgetCtrlLogger.getStringValue(ctrlResultInfo.getBgSchemeId()) + "\n");
            logMsg.append("formula = " + BudgetCtrlLogger.getStringValue(ctrlResultInfo.getBgItemFormula()) + "\n");
            logMsg.append("reqAmount = " + BudgetCtrlLogger.getStringValue(ctrlResultInfo.getReqAmount()) + "\n");
        }
        logMsg.append(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"77_BudgetCtrlLogger", (Locale)ctx.getLocale()));
        logger.info((Object)logMsg.toString());
    }

    public static void logReturnBudget(Context ctx, BudgetRequestType type, String boId) {
        if (boId == null) {
            return;
        }
        if (BudgetRequestType.BATCH_REPAIR == type) {
            return;
        }
        StringBuffer logMsg = new StringBuffer();
        logMsg.append("---returnBudgetLog---\n");
        logMsg.append("REQUEST_BUDGET_TYPE is " + type + "\n");
        logMsg.append(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"78_BudgetCtrlLogger", (Locale)ctx.getLocale()));
        logMsg.append(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"75_BudgetCtrlLogger", (Locale)ctx.getLocale()) + dateFormater.format(new Date()) + "\n");
        logMsg.append(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"76_BudgetCtrlLogger", (Locale)ctx.getLocale()) + BudgetCtrlLogger.getOperatorName(ctx) + "\n");
        logMsg.append(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"79_BudgetCtrlLogger", (Locale)ctx.getLocale()) + boId + "\n");
        logMsg.append(ResourceBase.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"80_BudgetCtrlLogger", (Locale)ctx.getLocale()));
        logger.info((Object)logMsg.toString());
    }

    public static void logBillInfo(Context ctx, String opName, String boName, BOSUuid billId) {
        if (billId == null) {
            return;
        }
        if (StringUtils.isEmpty((String)boName)) {
            boName = BudgetCtrlHelper.getBOName(ctx, billId);
        }
        if ("com.kingdee.eas.cp.bc.app.BizAccountBill".equalsIgnoreCase(boName)) {
            String sql = "select fbudgetdo from t_bc_bizaccountbillentry where fbillid = ?";
            StringBuffer msg = new StringBuffer();
            msg.append("---logBillInfo---\n");
            msg.append(opName).append("\n");
            msg.append("BillName:").append(boName).append("\n");
            msg.append("billId:").append(billId).append("\n");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId.toString()});
                while (rs != null && rs.next()) {
                    msg.append(rs.getObject(1)).append("\n");
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
            logger.info((Object)msg.toString());
        }
    }

    public static void logBillInfo(Context ctx, String opName, IObjectValue bill) {
    }

    private static String getOperatorName(Context ctx) {
        if (ctx == null) {
            return "";
        }
        if (ContextUtil.getCurrentUserInfo((Context)ctx) == null) {
            return "";
        }
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getName() == null) {
            return "";
        }
        return ContextUtil.getCurrentUserInfo((Context)ctx).getName();
    }

    private static String getStringValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

