/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.qing.preparedata.handler.controller.IQingDataProvider;
import com.kingdee.bos.qing.preparedata.handler.controller.model.Field;
import com.kingdee.bos.qing.web.etl.model.budget.Field;
import com.kingdee.bos.qing.web.etl.model.budget.IDataProvider;
import com.kingdee.bos.qing.web.etl.model.budget.Meta;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.ParentChildDimension;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingData;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingFieldType;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingMeta;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.AnalyseDataProvider;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.IBgDimensionFacade;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionManagerImpl;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.member.Member;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseIntegUtils;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AnalyseDataFacade
extends Thread
implements IQingDataProvider {
    private static Logger logger = Logger.getLogger(AnalyseDataFacade.class);
    private Map<String, String> versionMap = new HashMap<String, String>();
    private Map<String, String> scenarioMap = new HashMap<String, String>();
    protected Context ctx = null;
    private IDimensionParameter parameter = null;
    private Map mbgDataMap = null;
    public static final int scale = 6;
    protected static final String FIELD_NUM = "NUM";
    protected static final String FIELD_PNUM = "PNUM";
    protected static final String FIELD_ALIAS = "ALIAS";
    protected static final String FIELD_VALUE = "value";

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public AnalyseDataFacade() {
    }

    public AnalyseDataFacade(Context ctx) {
        this.ctx = ctx;
    }

    public AnalyseDataFacade(Context ctx, IDimensionParameter parameter, Map mbgDataMap) {
        this.ctx = ctx;
        this.parameter = parameter;
        this.mbgDataMap = mbgDataMap;
    }

    @Override
    public void run() {
        IDataProvider provider = this.getDataProvider(this.ctx, null, this.parameter, this.mbgDataMap);
        this.setProviderByCache(this.ctx, this.parameter.getBillId(), provider);
    }

    public Object getProviderByCache(Context ctx, BOSUuid billId) {
        return BgDimCacheUtils.getObject((Context)ctx, (String)("MbgAanalyseCacheData-" + billId));
    }

    public void setProviderByCache(Context ctx, BOSUuid billId, IDataProvider provider) {
        if (ctx == null || billId == null || provider == null) {
            return;
        }
        BgDimCacheUtils.putObject((Context)ctx, (String)("MbgAanalyseCacheData-" + billId), (Object)provider);
    }

    public IDataProvider getDataProvider(String analyseId, Context ctx) {
        if (ctx == null || analyseId == null) {
            return null;
        }
        logger.error((Object)("getDataProvider parameter[2],analyseId :" + analyseId));
        BOSUuid billId = BOSUuid.read((String)analyseId);
        BgFormInfo bgForm = null;
        BgSchemeInfo bgScheme = null;
        IDataProvider provider = null;
        try {
            if (billId == null || !"3BA5F027".equals(billId.getType().toString())) {
                throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{"analyse Data error: error id! " + analyseId});
            }
            Object obj = this.getProviderByCache(ctx, billId);
            if (obj instanceof IDataProvider) {
                provider = (IDataProvider)obj;
                Timestamp timestamp = new Timestamp(System.currentTimeMillis());
                if (timestamp.getTime() - provider.getTime().getTime() >= 60000L) {
                    logger.error((Object)"timestamp cost time 60*10000");
                    provider = null;
                }
            }
            if (provider == null) {
                provider = new AnalyseDataProvider();
                bgForm = BgFormFactory.getLocalInstance((Context)ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(billId), BgNFSHelper.getFormBaseSelectors((boolean)false));
                bgScheme = BgViewServerHelper.getBgSchemeCubeInfo((Context)ctx, (BOSUuid)bgForm.getBgScheme().getId());
                IBgDimensionManagerBase manager = null;
                IMbgViewBase view = null;
                IDimensionParameter parameter = null;
                view = DimensionCommonHelper.getBgFormView((Context)ctx, (BgFormInfo)bgForm);
                if (BgTemFormTypeEnum.VIEWFORM.equals((Object)bgForm.getBgTemplate().getFormType())) {
                    view = MBGFormFacadeFactory.getLocalInstance((Context)ctx).loadViewManager(billId.toString(), null, (IMbgViewManager)view, null, bgForm.getOrgUnit().getId().toString(), true, false);
                } else if (BgTemFormTypeEnum.VIEWLIST.equals((Object)bgForm.getBgTemplate().getFormType())) {
                    Map result = MBGViewListFormFacadeFactory.getLocalInstance((Context)ctx).initViewListData(bgForm, null, bgScheme.getEditOrgViewId().toString(), (MbgViewListManager)view, null);
                    view = (IMbgViewBase)result.get("dimensino.member");
                }
                Map tmpMap = null;
                HashMap bgDataMap = new HashMap();
                if (view != null && view.getSheetManagers() != null) {
                    IBgDimensionFacade dimensionFacade = BgDimensionFacadeFactory.getLocalInstance((Context)ctx);
                    ArrayList<IBgDimensionManagerBase> dimensionManager = new ArrayList<IBgDimensionManagerBase>();
                    int in = view.getSheetManagers().size();
                    for (int i = 0; i < in; ++i) {
                        manager = ((IMbgSheetBase)view.getSheetManagers().get(i)).getDimensionManager();
                        dimensionManager.add(manager);
                    }
                    parameter = DimUtils.transDimParameter((Context)ctx, dimensionManager, (BgFormInfo)bgForm, (BOSUuid)bgScheme.getEditOrgViewId());
                    if (parameter != null) {
                        parameter.setValueType(1);
                        parameter.getControlManager().setHasQueryDataState(false);
                        tmpMap = (Map)dimensionFacade.dimensionQuery(parameter);
                        if (tmpMap != null) {
                            bgDataMap.putAll(tmpMap);
                        }
                    }
                }
                logger.error((Object)("getDataProvider parameter[2],dataMap :" + bgDataMap.values() + " ,size:" + bgDataMap.values().size()));
                provider = this.getDataProvider(ctx, provider, parameter, bgDataMap);
                logger.error((Object)("getDataProvider parameter[2],provider " + provider.getData() + ",provider size :" + provider.getData().size()));
                this.setProviderByCache(ctx, billId, provider);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"analyse Data error:", (Throwable)ex);
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDataProvider getDataProvider(Context ctx, IDataProvider provider, IDimensionParameter parameter, Map mbgDataMap) {
        if (ctx == null || parameter == null || mbgDataMap == null) {
            return null;
        }
        if (provider == null) {
            provider = new AnalyseDataProvider();
        }
        HashSet<String> mbgDimNums = new HashSet<String>();
        HashMap<String, Map<String, com.kingdee.eas.ma.mbg.dimension.face.IMember>> dimMemberMap = new HashMap<String, Map<String, com.kingdee.eas.ma.mbg.dimension.face.IMember>>();
        Map<String, com.kingdee.eas.ma.mbg.dimension.face.IMember> memberMap = null;
        Object _dimension = null;
        List mbgDims = null;
        mbgDims = MbgQingAnalyseIntegUtils.getSchemeMbgDim((MbgDimCollection)parameter.getDataManager().getDimensions(), (BgSchemeInfo)parameter.getDataManager().getBgScheme());
        if (mbgDims == null || mbgDims.isEmpty()) {
            return null;
        }
        List dims = parameter.getDims();
        for (com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension : dims) {
            mbgDimNums.add(dimension.getNumber());
            if (dimMemberMap.containsKey(dimension.getField())) {
                memberMap = (Map)dimMemberMap.get(dimension.getField());
            } else {
                memberMap = new HashMap();
                dimMemberMap.put(dimension.getField(), memberMap);
            }
            for (com.kingdee.eas.ma.mbg.dimension.face.IMember member : dimension.getDimensionMember()) {
                memberMap.put(member.getNumber(), member);
            }
        }
        Map standbyMap = parameter.getDataManager().getStandbyMap();
        if (standbyMap != null && !standbyMap.isEmpty()) {
            Set<IMember> members = null;
            for (Map.Entry entry : standbyMap.entrySet()) {
                String field = (String)entry.getKey();
                members = this.createDimensionMember((Set)entry.getValue());
                if (dimMemberMap.containsKey(field)) {
                    memberMap = (Map)dimMemberMap.get(field);
                } else {
                    memberMap = new HashMap();
                    dimMemberMap.put(field, memberMap);
                }
                for (IMember member : members) {
                    memberMap.put(member.getNumber(), member.toMember());
                }
            }
        }
        if (!parameter.getQuerys().isEmpty()) {
            IQueryData query = null;
            IDimension mbgDim = null;
            IMember mbgMember = null;
            int in = parameter.getQuerys().size();
            for (int i = 0; i < in; ++i) {
                query = (IQueryData)parameter.getQuerys().get(i);
                Map mbgDimMap = query.getMbgDimMap();
                for (Map.Entry entry : mbgDimMap.entrySet()) {
                    String mbgDimField = (String)entry.getKey();
                    mbgDim = (IDimension)entry.getValue();
                    mbgDimNums.add(mbgDim.getNumber());
                    if (dimMemberMap.containsKey(mbgDim.getField())) {
                        memberMap = (Map)dimMemberMap.get(mbgDim.getField());
                    } else {
                        memberMap = new HashMap();
                        dimMemberMap.put(mbgDim.getField(), memberMap);
                    }
                    int xn = mbgDim.getMembers().size();
                    for (int x = 0; x < xn; ++x) {
                        mbgMember = (IMember)mbgDim.getMembers().get(x);
                        memberMap.put(mbgMember.getNumber(), mbgMember.toMember());
                    }
                }
            }
        }
        HashMap<String, Map<String, BgDimensionMember>> queryMemberMap = new HashMap<String, Map<String, BgDimensionMember>>();
        try {
            for (MbgDimInfo mbgDim : mbgDims) {
                if (dimMemberMap == null || !dimMemberMap.containsKey(mbgDim.getRefField()) || DimUtils.checkBaseDimension((String)mbgDim.getNumber())) continue;
                memberMap = (Map)dimMemberMap.get(mbgDim.getRefField());
                Set numbers = memberMap.keySet();
                Map queryMembers = DimensionFormulaFacadeFactory.getLocalInstance((Context)ctx).queryMembers(parameter.getOrgUnitId().toString(), parameter.getBgSchemeId().toString(), mbgDim.getNumber(), numbers);
                queryMemberMap.put(mbgDim.getRefField(), queryMembers);
            }
        }
        catch (Exception e) {
            logger.error((Object)"AnalyseDataFacade getDataProvider query error: ", (Throwable)e);
        }
        Collections.sort(mbgDims, new Comparator<MbgDimInfo>(){

            @Override
            public int compare(MbgDimInfo o1, MbgDimInfo o2) {
                return o1.getRefField().compareTo(o2.getRefField());
            }
        });
        Meta meta = provider.getMeta();
        com.kingdee.bos.qing.web.etl.model.budget.Field num = null;
        com.kingdee.bos.qing.web.etl.model.budget.Field pnum = null;
        com.kingdee.bos.qing.web.etl.model.budget.Field alias = null;
        com.kingdee.bos.qing.web.etl.model.budget.Field value = null;
        for (MbgDimInfo mbgDim : mbgDims) {
            if (DimensionConstants.DEF_STATE_NUMBER.equals(mbgDim.getNumber())) continue;
            num = new com.kingdee.bos.qing.web.etl.model.budget.Field(mbgDim.getNumber() + "_" + FIELD_NUM, mbgDim.getName() + EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysenum", (Locale)ctx.getLocale()), Field.FieldType.String);
            pnum = new com.kingdee.bos.qing.web.etl.model.budget.Field(mbgDim.getNumber() + "_" + FIELD_PNUM, mbgDim.getName() + EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysepnum", (Locale)ctx.getLocale()), Field.FieldType.String);
            alias = new com.kingdee.bos.qing.web.etl.model.budget.Field(mbgDim.getNumber() + "_" + FIELD_ALIAS, mbgDim.getName(), Field.FieldType.String);
            meta.addField(num);
            meta.addField(pnum);
            meta.addField(alias);
            com.kingdee.bos.qing.web.etl.model.budget.ParentChildDimension pcDimension = new com.kingdee.bos.qing.web.etl.model.budget.ParentChildDimension(mbgDim.getNumber(), mbgDim.getName(), num, pnum);
            pcDimension.setDefaultDisplayName(alias);
            pcDimension.setSortAccording(num);
            meta.addParentChildDimension(pcDimension);
            pnum.setHide(true);
        }
        value = new com.kingdee.bos.qing.web.etl.model.budget.Field(FIELD_VALUE, EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysevalue", (Locale)ctx.getLocale()), Field.FieldType.Number);
        meta.addField(value);
        BgNDataInfo mbgData2 = null;
        Object[] objs = null;
        Map.Entry entry2 = null;
        Map dataMap = null;
        Connection conn = null;
        List bgOrgUnits = null;
        BgOrgUnitInfo bgOrgUnitInfo = null;
        HashMap<String, BgOrgUnitInfo> bgOrgUnitMap = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            HashSet orgUnitIds = new HashSet();
            Iterator<Object> iter = mbgDataMap.keySet().iterator();
            while (iter.hasNext()) {
                orgUnitIds.add(iter.next());
            }
            bgOrgUnits = MbgDataHelper.getBgOrgUnits((Context)ctx, (Connection)conn, (BOSUuid)parameter.getBgOrgViewId(), orgUnitIds);
            if (bgOrgUnits == null || bgOrgUnits.isEmpty()) {
                iter = null;
                return iter;
            }
            bgOrgUnitMap = new HashMap<String, BgOrgUnitInfo>();
            for (BgOrgUnitInfo info : bgOrgUnits) {
                bgOrgUnitMap.put(info.getOrgUnitID(), info);
            }
        }
        catch (Exception e) {
            logger.error((Object)"sql error:", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        for (Map.Entry entry2 : mbgDataMap.entrySet()) {
            bgOrgUnitInfo = (BgOrgUnitInfo)bgOrgUnitMap.get(entry2.getKey());
            if (!(entry2.getValue() instanceof Map)) continue;
            dataMap = (Map)entry2.getValue();
            for (BgNDataInfo mbgData2 : dataMap.values()) {
                objs = this.updataAnalyseData((String)entry2.getKey(), mbgData2, mbgDims, dimMemberMap, parameter, bgOrgUnitInfo, queryMemberMap);
                if (objs == null) continue;
                provider.getData().add(objs);
            }
        }
        provider.setTime(new Timestamp(System.currentTimeMillis()));
        return provider;
    }

    private Set<IMember> createDimensionMember(Set<String> values) {
        Member member = null;
        HashSet<IMember> members = new HashSet<IMember>();
        for (String value : values) {
            member = new Member();
            member.setNumber(value.split(":")[1]);
            member.setDimNumber(value);
            member.setMdxNumber(value.split(":")[1]);
            member.setSrcNumber(value.split(":")[0]);
            members.add((IMember)member);
        }
        return members;
    }

    private Object[] updataAnalyseData(String orgUnitNum, BgNDataInfo mbgData, List<MbgDimInfo> mbgDims, Map<String, Map<String, com.kingdee.eas.ma.mbg.dimension.face.IMember>> dimMemberMap, IDimensionParameter parameter, BgOrgUnitInfo bgOrgUnitInfo, Map<String, Map<String, BgDimensionMember>> queryMemberMap) {
        if (mbgData == null || mbgDims == null || dimMemberMap == null || parameter == null || bgOrgUnitInfo == null) {
            return null;
        }
        Map<String, BgDimensionMember> bgMemberMap = null;
        BgDimensionMember bgMember = null;
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        Map<String, com.kingdee.eas.ma.mbg.dimension.face.IMember> memberMap = null;
        ArrayList<Object> values = new ArrayList<Object>();
        HashMap fieldMap = new HashMap();
        Map srcFieldMap = parameter.getDataManager().getSrcFieldMap();
        String srcNumber = null;
        String number = null;
        String dimNumber2 = null;
        String pNumber = null;
        String[] tmpNums = null;
        for (String dimNumber2 : mbgData.getBgItemNumber().split(",")) {
            tmpNums = dimNumber2.split(":");
            srcNumber = tmpNums[0];
            number = tmpNums[1];
            fieldMap.put(srcFieldMap.get(srcNumber), dimNumber2);
        }
        for (MbgDimInfo mbgDim : mbgDims) {
            if (DimensionConstants.DEF_STATE_NUMBER.equals(mbgDim.getNumber())) continue;
            member = null;
            if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(mbgDim.getNumber())) {
                values.add(bgOrgUnitInfo.getNumber());
                values.add(bgOrgUnitInfo.getLongNumber());
                values.add(bgOrgUnitInfo.getName());
                continue;
            }
            if (DimensionBaseConstants.DEF_CURRENCY_NUMBER.equals(mbgDim.getNumber())) {
                memberMap = dimMemberMap.get(mbgDim.getRefField());
                if (memberMap != null && memberMap.containsKey(mbgData.getCurrencyNumber())) {
                    member = memberMap.get(mbgData.getCurrencyNumber());
                }
                if (member != null) {
                    values.add(member.getNumber());
                    values.add(null);
                    values.add(member.getName());
                    continue;
                }
                if (parameter.getDataManager().getDefCurrency() != null) {
                    values.add(mbgData.getCurrencyNumber());
                    values.add(null);
                    values.add(parameter.getDataManager().getDefCurrency()[1]);
                    continue;
                }
                values.add(mbgData.getCurrencyNumber());
                values.add(null);
                values.add(mbgData.getCurrencyNumber());
                continue;
            }
            if (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(mbgDim.getNumber())) {
                memberMap = dimMemberMap.get(mbgDim.getRefField());
                if (memberMap != null && memberMap.containsKey(mbgData.getBgPeriodNumber())) {
                    member = memberMap.get(mbgData.getBgPeriodNumber());
                }
                if (member != null) {
                    values.add(member.getNumber());
                    values.add(this.getParentNumber(member.getMdxNumber()));
                    values.add(member.getName());
                    continue;
                }
                values.add(mbgData.getBgPeriodNumber());
                values.add(null);
                values.add(mbgData.getBgPeriodNumber());
                continue;
            }
            if (DimensionBaseConstants.DEF_ELEMENT_NUMBER.equals(mbgDim.getNumber())) {
                memberMap = dimMemberMap.get(mbgDim.getRefField());
                if (memberMap != null && memberMap.containsKey(mbgData.getBgElementNumber())) {
                    member = memberMap.get(mbgData.getBgElementNumber());
                }
                if (member != null) {
                    values.add(member.getNumber());
                    values.add(null);
                    values.add(member.getName());
                    continue;
                }
                if (parameter.getDataManager().getDefElement() != null) {
                    values.add(parameter.getDataManager().getDefElement()[0]);
                    values.add(null);
                    values.add(parameter.getDataManager().getDefElement()[1]);
                    continue;
                }
                values.add(mbgData.getBgElementNumber());
                values.add(null);
                values.add(mbgData.getBgElementNumber());
                continue;
            }
            if (DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(mbgDim.getNumber())) {
                memberMap = dimMemberMap.get(mbgDim.getRefField());
                if (memberMap != null && memberMap.containsKey(mbgData.getBgScenario())) {
                    member = memberMap.get(mbgData.getBgScenario());
                }
                if (member != null) {
                    values.add(mbgData.getBgScenario());
                    values.add(null);
                    values.add(member.getName());
                    continue;
                }
                if (parameter.getDataManager().getDefScenario() != null) {
                    values.add(mbgData.getBgScenario());
                    values.add(null);
                    values.add(parameter.getDataManager().getDefScenario()[1]);
                    continue;
                }
                values.add(mbgData.getBgScenario());
                values.add(null);
                values.add(mbgData.getBgScenario());
                continue;
            }
            if (DimensionBaseConstants.DEF_VERSION_NUMBER.equals(mbgDim.getNumber())) {
                memberMap = dimMemberMap.get(mbgDim.getRefField());
                if (memberMap != null && memberMap.containsKey(mbgData.getBgVersion())) {
                    member = memberMap.get(mbgData.getBgVersion());
                }
                if (member != null) {
                    values.add(mbgData.getBgVersion());
                    values.add(null);
                    values.add(member.getName());
                    continue;
                }
                if (parameter.getDataManager().getDefVersion() != null) {
                    values.add(mbgData.getBgVersion());
                    values.add(null);
                    values.add(parameter.getDataManager().getDefVersion()[1]);
                    continue;
                }
                values.add(mbgData.getBgVersion());
                values.add(null);
                values.add(mbgData.getBgVersion());
                continue;
            }
            number = ((String)fieldMap.get(mbgDim.getRefField())).split(":")[1];
            bgMemberMap = queryMemberMap.get(mbgDim.getRefField());
            if (number != null && bgMemberMap != null && bgMemberMap.containsKey(number)) {
                bgMember = bgMemberMap.get(number);
            }
            if (bgMember != null) {
                pNumber = this.getParentNumber((String)((Object)bgMember.getSortValue()));
                values.add(bgMember.getCombNumber());
                values.add(pNumber == null ? null : bgMember.getSrcNumber() + ":" + this.getParentNumber((String)((Object)bgMember.getSortValue())));
                values.add(bgMember.getName());
                continue;
            }
            values.add(number);
            values.add(null);
            values.add(number);
        }
        BigDecimal value = BigDecimal.ZERO;
        if (mbgData.getBudgetValueNoDef() != null) {
            value = mbgData.getBudgetValueNoDef();
        } else if (mbgData.getBizActualNoDef() != null) {
            value = mbgData.getBizActualNoDef();
        } else if (mbgData.getAddActualNoDef() != null) {
            value = mbgData.getAddActualNoDef();
        }
        values.add(value.setScale(6, 4));
        return values.toArray();
    }

    protected String getParentNumber(String longNumber) {
        if (longNumber == null) {
            return null;
        }
        String[] tmpNums = longNumber.split("!");
        if (tmpNums != null && tmpNums.length > 1) {
            return tmpNums[tmpNums.length - 2];
        }
        return null;
    }

    public void dispose(String s) throws EASBizException, BOSException {
    }

    public QingData getData(String analyseId, int startRow, int limit) throws EASBizException, BOSException {
        QingData qingData = new QingData();
        if (analyseId == null) {
            return qingData;
        }
        BOSUuid billId = BOSUuid.read((String)analyseId);
        String[] keys = new String[]{FIELD_NUM, FIELD_PNUM, FIELD_ALIAS};
        HashMap<String, Integer> dataIndex = new HashMap<String, Integer>();
        IDimensionParameter parameter = this.getDimParameterByBillId(this.ctx, analyseId);
        List dims = parameter.getDims();
        logger.error((Object)(" class name :[analyseDataFacade],  method:[getData], size: " + dims.size()));
        this.sortDims(dims);
        int index = 0;
        int in = dims.size();
        for (int i = 0; i < in; ++i) {
            int jn = keys.length;
            for (int j = 0; j < jn; ++j) {
                dataIndex.put(((com.kingdee.eas.ma.mbg.dimension.face.IDimension)dims.get(i)).getNumber() + "_" + keys[j], index);
                ++index;
            }
        }
        dataIndex.put(FIELD_VALUE, index);
        qingData.setDataindex(dataIndex);
        Object obj = this.getProviderByCache(this.ctx, billId);
        IDataProvider provider = null;
        if (obj != null && obj instanceof IDataProvider) {
            provider = (IDataProvider)obj;
            qingData.setRows(provider.getData());
        } else {
            IBgDimensionFacade dimensionFacade = BgDimensionFacadeFactory.getLocalInstance((Context)this.ctx);
            Map tmpMap = null;
            HashMap bgDataMap = new HashMap();
            if (parameter != null) {
                parameter.setValueType(1);
                parameter.getControlManager().setHasQueryDataState(false);
                tmpMap = (Map)dimensionFacade.dimensionQuery(parameter);
                logger.error((Object)("class name :[analyseDataFacade],  method:[getData] query tmpMap :" + tmpMap));
                if (tmpMap != null) {
                    bgDataMap.putAll(tmpMap);
                }
            }
            provider = this.getDataProvider(this.ctx, provider, parameter, bgDataMap);
            qingData.setRows(provider.getData());
        }
        return qingData;
    }

    public String getFilterParameter(String analyseId) throws EASBizException, BOSException {
        return null;
    }

    public QingMeta getMeta(String analyseId) throws EASBizException, BOSException {
        QingMeta qingMeta = new QingMeta();
        if (analyseId == null) {
            return qingMeta;
        }
        IDimensionParameter parameter = this.getDimParameterByBillId(this.ctx, analyseId);
        List dims = parameter.getDims();
        this.sortDims(dims);
        com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field num = null;
        com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field pnum = null;
        com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field alias = null;
        for (com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension : dims) {
            num = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field(dimension.getNumber() + "_" + FIELD_NUM, dimension.getAlias() + EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysenum", (Locale)this.ctx.getLocale()), QingFieldType.String.toNumber(), null, null, false, null);
            pnum = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field(dimension.getNumber() + "_" + FIELD_PNUM, dimension.getAlias() + EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysepnum", (Locale)this.ctx.getLocale()), QingFieldType.String.toNumber(), null, null, true, null);
            alias = new com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.Field(dimension.getNumber() + "_" + FIELD_ALIAS, dimension.getAlias(), QingFieldType.String.toNumber(), null, null, false, null);
            qingMeta.addColumn((Field)num);
            qingMeta.addColumn((Field)pnum);
            qingMeta.addColumn((Field)alias);
            ParentChildDimension pcDimension = new ParentChildDimension(num.getName(), dimension.getAlias(), (Field)num, (Field)pnum);
            pcDimension.setDefaultDisplayName((Field)alias);
            pcDimension.setSortAccording((Field)num);
            qingMeta.addParentChildDimension((com.kingdee.bos.qing.preparedata.handler.controller.model.ParentChildDimension)pcDimension);
        }
        qingMeta.addColumn(new Field(FIELD_VALUE, EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysevalue", (Locale)this.ctx.getLocale()), QingFieldType.Number.toNumber(), null, null, false, null));
        return qingMeta;
    }

    private void sortDims(List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims) {
        Collections.sort(dims, new Comparator<com.kingdee.eas.ma.mbg.dimension.face.IDimension>(){

            @Override
            public int compare(com.kingdee.eas.ma.mbg.dimension.face.IDimension o1, com.kingdee.eas.ma.mbg.dimension.face.IDimension o2) {
                return o1.getField().compareTo(o2.getField());
            }
        });
    }

    public String setFilterParameter(String bizTag, String filterParameter) {
        return null;
    }

    public IDimensionParameter getDimParameterByBillId(Context ctx, String analyseId) throws EASBizException, BOSException {
        if (ctx == null || analyseId == null) {
            return null;
        }
        BOSUuid billId = BOSUuid.read((String)analyseId);
        BgFormInfo bgForm = null;
        BgSchemeInfo bgScheme = null;
        IBgDimensionManagerBase manager = null;
        IMbgViewBase view = null;
        IDimensionParameter parameter = null;
        if (billId == null || !"3BA5F027".equals(billId.getType().toString())) {
            throw new BgFormException(BgFormException.SHOWEXCEPTION, (Object[])new String[]{"analyse Data error: error id! " + analyseId});
        }
        bgForm = BgFormFactory.getLocalInstance((Context)ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(billId), BgNFSHelper.getFormBaseSelectors((boolean)false));
        bgScheme = BgViewServerHelper.getBgSchemeCubeInfo((Context)ctx, (BOSUuid)bgForm.getBgScheme().getId());
        view = DimensionCommonHelper.getBgFormView((Context)ctx, (BgFormInfo)bgForm);
        if (BgTemFormTypeEnum.VIEWFORM.equals((Object)bgForm.getBgTemplate().getFormType())) {
            view = MBGFormFacadeFactory.getLocalInstance((Context)ctx).loadViewManager(billId.toString(), null, (IMbgViewManager)view, null, bgForm.getOrgUnit().getId().toString(), true, false);
        } else if (BgTemFormTypeEnum.VIEWLIST.equals((Object)bgForm.getBgTemplate().getFormType())) {
            Map result = MBGViewListFormFacadeFactory.getLocalInstance((Context)ctx).initViewListData(bgForm, null, bgScheme.getEditOrgViewId().toString(), (MbgViewListManager)view, null);
            view = (IMbgViewBase)result.get("dimensino.member");
        }
        if (view != null && view.getSheetManagers() != null) {
            ArrayList<IBgDimensionManagerBase> dimensionManager = new ArrayList<IBgDimensionManagerBase>();
            int in = view.getSheetManagers().size();
            for (int i = 0; i < in; ++i) {
                manager = ((IMbgSheetBase)view.getSheetManagers().get(i)).getDimensionManager();
                if (manager != null && manager instanceof MbgViewListDimensionManager) {
                    MbgViewListDimensionManager viewListmanager = (MbgViewListDimensionManager)manager;
                    if (viewListmanager.getPageDimension() != null && !viewListmanager.getPageDimension().isEmpty()) {
                        List rows = viewListmanager.getRows();
                        for (IMbgViewListObject row : rows) {
                            if (!(row instanceof MbgViewListRowCol)) continue;
                            MbgViewListRowCol viewListCol = (MbgViewListRowCol)row;
                            viewListCol.getDimensions().addAll(viewListmanager.getPageDimension());
                        }
                        viewListmanager.getPageDimension().clear();
                    }
                } else if (manager != null && manager instanceof BgDimensionManagerImpl) {
                    BgDimensionManagerImpl formManager = (BgDimensionManagerImpl)manager;
                    if (formManager.getPageDimension() != null && !formManager.getPageDimension().isEmpty()) {
                        formManager.getRowDimension().addAll(formManager.getPageDimension());
                        formManager.getRowDisplayDimension().addAll(formManager.getPageDisplayDimension());
                    }
                    formManager.getPageDimension().clear();
                    formManager.getPageDisplayDimension().clear();
                }
                dimensionManager.add(manager);
            }
            try {
                parameter = DimUtils.transDimParameter((Context)ctx, dimensionManager, (BgFormInfo)bgForm, (BOSUuid)bgScheme.getEditOrgViewId());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return parameter;
    }
}

