/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingData;
import com.kingdee.bos.qingReport.server.dataProvider.modelWrapper.QingMeta;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgPropertyCollection;
import com.kingdee.eas.ma.base.BgPropertyFactory;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.AnalyseDataFacade;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgUtilsHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;

public class PropertiesAnalyseDataFacade
extends AnalyseDataFacade {
    public static final String PROPERTIES_DIMENSION = "propertiesDimension";
    public static final String DIMENSIONS = "dimensions";
    public static final String BGPROPERTYSORTINFO = "bgPropertySortInfo";
    private static final int DIM_MEMBER_NUM_INDEX = 3;
    int i = 0;

    public Object getPropertiesDimensionByCache(Context ctx, String billId, Properties properties) {
        return BgUtilsHelper.decodeObject((String)((String)properties.get("MbgPropertiesAnalyseCache-propertiesDimension" + billId)));
    }

    public void setPropertiesDimensionByCache(Context ctx, Map<String, List<BgDimensionMember>> propertiesDimension, String billId, Properties properties) {
        if (ctx == null || propertiesDimension == null) {
            return;
        }
        String encode = BgUtilsHelper.encodeObject(propertiesDimension);
        properties.setProperty("MbgPropertiesAnalyseCache-propertiesDimension" + billId, encode);
    }

    public Object getBgDimensionsByCache(Context ctx, String billId, Properties properties) {
        return BgUtilsHelper.decodeObject((String)((String)properties.get("MbgPropertiesAnalyseCache-dimensions" + billId)));
    }

    public void setBgDimensionsByCache(Context ctx, Map<String, BgDimensionInfo> dimensions, String billId, Properties properties) {
        if (ctx == null || dimensions == null) {
            return;
        }
        String encode = BgUtilsHelper.encodeObject(dimensions);
        properties.setProperty("MbgPropertiesAnalyseCache-dimensions" + billId, encode);
    }

    public Object getBgPropertySortInfoByCache(Context ctx, String billId, Properties properties) {
        return BgUtilsHelper.decodeObject((String)((String)properties.get("MbgPropertiesAnalyseCache-bgPropertySortInfo" + billId)));
    }

    public void setBgPropertySortInfoByCache(Context ctx, BgPropertySortInfo bgPropertySortInfo, String billId, Properties properties) {
        if (ctx == null || bgPropertySortInfo == null) {
            return;
        }
        String encode = BgUtilsHelper.encodeObject((Object)bgPropertySortInfo);
        properties.setProperty("MbgPropertiesAnalyseCache-bgPropertySortInfo" + billId, encode);
    }

    public PropertiesAnalyseDataFacade(Context ctx) {
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesAnalyseDataFacade(Context ctx, BgPropertySortInfo bgPropertySortInfo, Map<String, List<BgDimensionMember>> propertiesDimension, Map<String, BgDimensionInfo> dimensions, String billId) throws IOException {
        this(ctx);
        String normalize = FilenameUtils.normalize((String)(System.getProperty("user.dir") + File.separator + "MbgPropertyAnalyse.properties"));
        File propertityFile = new File(normalize);
        if (!propertityFile.exists()) {
            propertityFile.createNewFile();
        }
        Object in = null;
        try (FileOutputStream os = null;){
            Properties properties = new Properties();
            this.setPropertiesDimensionByCache(ctx, propertiesDimension, billId, properties);
            this.setBgPropertySortInfoByCache(ctx, bgPropertySortInfo, billId, properties);
            this.setBgDimensionsByCache(ctx, dimensions, billId, properties);
            os = new FileOutputStream(propertityFile);
            properties.store(os, "");
            os.flush();
        }
    }

    @Override
    public QingData getData(String analyseId, int startRow, int limit) throws EASBizException, BOSException {
        int i;
        int in;
        analyseId = analyseId.split(",")[0];
        QingData data = super.getData(analyseId, startRow, limit);
        ArrayList<Object[]> rows = new ArrayList<Object[]>(Arrays.asList((Object[])new Object[data.getRows().size()]));
        Collections.copy(rows, data.getRows());
        HashMap<String, Object[]> replaceData = new HashMap<String, Object[]>();
        Properties properties = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(FilenameUtils.normalize((String)(System.getProperty("user.dir") + File.separator + "MbgPropertyAnalyse.properties")));
            properties.load(inputStream);
        }
        catch (FileNotFoundException e) {
            throw new BOSException();
        }
        catch (IOException e) {
            throw new BOSException();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new BOSException();
                }
            }
        }
        Map propertiesDimension = (Map)this.getPropertiesDimensionByCache(this.ctx, analyseId, properties);
        BgPropertySortInfo bgPropertySortInfo = (BgPropertySortInfo)this.getBgPropertySortInfoByCache(this.ctx, analyseId, properties);
        Map dimensions = (Map)this.getBgDimensionsByCache(this.ctx, analyseId, properties);
        String sourceType = bgPropertySortInfo.getSourceType();
        HashMap<String, BgAccountInfo> memberMap = new HashMap<String, BgAccountInfo>();
        BgAccountInfo baseInfo = null;
        String viewId = null;
        if ("E68E9293".equals(sourceType)) {
            viewId = ((BgDimensionInfo)dimensions.get(DimensionConstants.DEF_ACCOUNT_NUMBER)).getViewId();
            BgAccountCollection bgAccounts = BgAccountFactory.getRemoteInstance().getBgAccountCollection("select id,number,name,longNumber where bgAccountView.id = '" + viewId + "'");
            if (bgAccounts != null && !bgAccounts.isEmpty()) {
                in = bgAccounts.size();
                for (i = 0; i < in; ++i) {
                    baseInfo = bgAccounts.get(i);
                    memberMap.put(baseInfo.getNumber(), baseInfo);
                }
            }
        } else if ("D177852B".equals(sourceType)) {
            viewId = ((BgDimensionInfo)dimensions.get(bgPropertySortInfo.get(BgBaseConstants.DIMENSION_NUMBER))).getViewId();
            MbgMemberCollection mbgMembers = MbgMemberFactory.getRemoteInstance().getMbgMemberCollection("select id,number,name,longNumber where viewId = '" + viewId + "'");
            if (mbgMembers != null && !mbgMembers.isEmpty()) {
                in = mbgMembers.size();
                for (i = 0; i < in; ++i) {
                    baseInfo = mbgMembers.get(i);
                    memberMap.put(baseInfo.getNumber(), baseInfo);
                }
            }
        }
        HashMap numberRefIds = new HashMap();
        HashSet proIds = new HashSet();
        List propertyList = (List)propertiesDimension.get(bgPropertySortInfo.getId().toString());
        String dimSrcNum = null;
        int in2 = propertyList.size();
        for (int i2 = 0; i2 < in2; ++i2) {
            Map maps = (Map)propertyList.get(i2);
            for (Map.Entry entry : maps.entrySet()) {
                proIds.add(entry.getKey());
                List list = (List)entry.getValue();
                for (BgDimensionMember member1 : list) {
                    numberRefIds.put(member1.getSrcNumber() + ":" + member1.getNumber(), entry.getKey());
                    dimSrcNum = member1.getSrcNumber();
                }
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("name");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", proIds, CompareType.INCLUDE));
        view.setFilter(filter);
        BgPropertyInfo info = null;
        HashMap<String, BgPropertyInfo> bgPropertyMap = new HashMap<String, BgPropertyInfo>();
        BgPropertyCollection bgPropertyColl = BgPropertyFactory.getLocalInstance((Context)this.ctx).getBgPropertyCollection(view);
        if (bgPropertyColl != null && !bgPropertyColl.isEmpty()) {
            int in3 = bgPropertyColl.size();
            for (int i3 = 0; i3 < in3; ++i3) {
                info = bgPropertyColl.get(i3);
                bgPropertyMap.put(info.getId().toString(), info);
            }
        }
        StringBuffer key = null;
        String field = null;
        String parentNumber = null;
        String srcNumber = null;
        BgPropertyInfo propertyInfo = null;
        BigDecimal value = null;
        Object[] param2 = null;
        Object[] tempRow = null;
        for (Object[] row : rows) {
            key = new StringBuffer();
            tempRow = Arrays.copyOf((Object[])row, (int)row.length);
            boolean flag = false;
            int in4 = row.length;
            for (int i4 = 0; i4 < in4; ++i4) {
                if (row[i4] != null && row[i4] instanceof String) {
                    field = (String)row[i4];
                    if (field.contains(dimSrcNum) && numberRefIds.keySet().contains(field)) {
                        flag = true;
                    } else if (!field.contains(dimSrcNum) && i4 % 3 == 0) {
                        key.append(row[i4]).append("_");
                    }
                    if (!flag) continue;
                    if (field.contains(":") && i4 % 3 == 0) {
                        parentNumber = this.getParentNumber(((TreeBaseInfo)memberMap.get(field.split(":")[1])).getLongNumber());
                        parentNumber = parentNumber != null ? parentNumber : ((TreeBaseInfo)memberMap.get(field.split(":")[1])).getLongNumber();
                        baseInfo = (TreeBaseInfo)memberMap.get(parentNumber);
                    }
                    if (i4 % 3 == 0) {
                        if (baseInfo != null) {
                            srcNumber = dimSrcNum + ":" + baseInfo.getNumber();
                        }
                        if ((propertyInfo = (BgPropertyInfo)bgPropertyMap.get(numberRefIds.get(field))) == null) continue;
                        tempRow[i4] = srcNumber + "_" + propertyInfo.getNumber();
                        continue;
                    }
                    if (i4 % 3 == 1) {
                        row[i4] = tempRow[i4 - 1];
                        key.append(row[i4]).append("_").append("!").append("_");
                        continue;
                    }
                    if (i4 % 3 != 2) continue;
                    if (baseInfo != null && propertyInfo != null) {
                        tempRow[i4] = baseInfo.getName() + "_" + propertyInfo.getName();
                    }
                    flag = false;
                    continue;
                }
                if (row[i4] == null || !(row[i4] instanceof BigDecimal)) continue;
                value = (BigDecimal)row[i4];
                if (replaceData.containsKey(key.toString()) && value != null) {
                    BigDecimal tmpValue = (BigDecimal)((Object[])replaceData.get(key.toString()))[1];
                    BigDecimal sum = tmpValue.add(value);
                    ((Object[])replaceData.get((Object)key.toString()))[1] = sum;
                    continue;
                }
                if (!key.toString().contains("!")) continue;
                param2 = new Object[]{tempRow, value};
                replaceData.put(key.toString(), param2);
            }
        }
        for (Object[] param2 : replaceData.values()) {
            tempRow = (Object[])param2[0];
            tempRow[tempRow.length - 1] = param2[1];
            rows.add(tempRow);
        }
        data.setRows(rows);
        return data;
    }

    @Override
    public QingMeta getMeta(String analyseId) throws EASBizException, BOSException {
        analyseId = analyseId.split(",")[0];
        return super.getMeta(analyseId);
    }
}

