/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.ma.budget.BgCtrlManualDecisionException;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BgCtrlResultInfo;
import com.kingdee.eas.ma.budget.BgCtrlTypeEnum;
import com.kingdee.eas.ma.budget.BudgetCtrlFacadeFactory;
import com.kingdee.eas.ma.budget.IBudgetCtrlFacade;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.BgControlNotNullBudgetEnum;
import com.kingdee.eas.ma.control.BgControlNullBudgetEnum;
import com.kingdee.eas.ma.control.impl.models.BgControlParam;
import com.kingdee.eas.ma.control.utils.BgControlConstants;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.BgCellRenderHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.face.IBalance;
import com.kingdee.eas.ma.nbudget.face.IBudgetBalance;
import com.kingdee.eas.ma.nbudget.face.IControlResult;
import com.kingdee.eas.ma.nbudget.impl.BalanceApi;
import com.kingdee.eas.ma.nbudget.impl.BudgetBalanceApi;
import com.kingdee.eas.ma.nbudget.impl.ControlResult;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractBgControlCaller {
    protected IControlResult requestOldBudget(BOSUuid billId) {
        return this.requestOldBudget(null, billId);
    }

    protected IControlResult requestOldBudget(Context ctx, BOSUuid billId) {
        if (billId == null) {
            return null;
        }
        ControlResult result = new ControlResult();
        IBudgetCtrlFacade facade = null;
        boolean re = false;
        try {
            facade = ctx != null ? BudgetCtrlFacadeFactory.getLocalInstance((Context)ctx) : BudgetCtrlFacadeFactory.getRemoteInstance();
            facade.checkBillInfo(billId.toString());
            re = facade.requestBudgetLocal(billId);
        }
        catch (BgCtrlException ex) {
            result.setResult(7);
            result.getCause().add(ex.getMessage());
        }
        catch (BgCtrlManualDecisionException ex) {
            result.setResult(5);
            result.getCause().add(ex.getMessage());
        }
        catch (EASBizException ex) {
            result.setResult(3);
            result.getCause().add(ex.getMessage());
        }
        catch (BOSException ex) {
            result.setResult(3);
            result.getCause().add(ex.getMessage());
        }
        if (re) {
            result.setResult(1);
        } else {
            result.setResult(3);
        }
        return result;
    }

    protected IControlResult requestOldOccupation(BOSUuid billId) throws BOSException, EASBizException {
        return this.requestOldOccupation(null, billId);
    }

    protected IControlResult specialOldOccupation(BOSUuid billId) throws BOSException, EASBizException {
        return this.specialOldOccupation(null, billId);
    }

    protected IControlResult requestOldOccupation(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return null;
        }
        ControlResult result = new ControlResult();
        IBudgetCtrlFacade facade = null;
        boolean re = false;
        try {
            facade = ctx != null ? BudgetCtrlFacadeFactory.getLocalInstance((Context)ctx) : BudgetCtrlFacadeFactory.getRemoteInstance();
            facade.checkBillInfo(billId.toString());
            re = facade.requestBudgetLocalForOccupation(billId, true);
        }
        catch (BgCtrlException ex) {
            result.setResult(7);
            result.getCause().add(ex.getMessage());
        }
        catch (BgCtrlManualDecisionException ex) {
            result.setResult(5);
            result.getCause().add(ex.getMessage());
        }
        catch (EASBizException ex) {
            result.setResult(3);
            result.getCause().add(ex.getMessage());
        }
        catch (BOSException ex) {
            result.setResult(3);
            result.getCause().add(ex.getMessage());
        }
        if (re) {
            result.setResult(1);
        } else {
            result.setResult(3);
        }
        return result;
    }

    protected IControlResult specialOldOccupation(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return null;
        }
        ControlResult result = new ControlResult();
        boolean re = false;
        try {
            re = ctx != null ? BudgetCtrlFacadeFactory.getLocalInstance((Context)ctx).specialApproveLocalForOccupation(billId) : BudgetCtrlFacadeFactory.getRemoteInstance().specialApproveLocalForOccupation(billId);
        }
        catch (BgCtrlException ex) {
            result.setResult(7);
            result.getCause().add(ex.getMessage());
        }
        catch (BgCtrlManualDecisionException ex) {
            result.setResult(5);
            result.getCause().add(ex.getMessage());
        }
        catch (EASBizException ex) {
            result.setResult(3);
            result.getCause().add(ex.getMessage());
        }
        catch (BOSException ex) {
            result.setResult(3);
            result.getCause().add(ex.getMessage());
        }
        if (re) {
            result.setResult(1);
        } else {
            result.setResult(3);
        }
        return result;
    }

    protected IControlResult specialOldBudget(BOSUuid billId) {
        return this.specialOldBudget(null, billId);
    }

    protected IControlResult specialOldBudget(Context ctx, BOSUuid billId) {
        if (billId == null) {
            return null;
        }
        ControlResult result = new ControlResult();
        result.setResult(1);
        try {
            if (ctx != null) {
                BudgetCtrlFacadeFactory.getLocalInstance((Context)ctx).specialApproveLocal(billId);
            } else {
                BudgetCtrlFacadeFactory.getRemoteInstance().specialApproveLocal(billId);
            }
        }
        catch (EASBizException ex) {
            result.setResult(3);
            result.getCause().add(ex.getMessage());
        }
        catch (BOSException ex) {
            result.setResult(3);
            result.getCause().add(ex.getMessage());
        }
        return result;
    }

    protected IControlResult returnOldBudget(BOSUuid billId) {
        return this.returnOldBudget(null, billId);
    }

    protected IControlResult returnOldBudget(Context ctx, BOSUuid billId) {
        if (billId == null) {
            return null;
        }
        ControlResult result = new ControlResult();
        result.setResult(1);
        try {
            if (ctx != null) {
                BudgetCtrlFacadeFactory.getLocalInstance((Context)ctx).returnBudgetLocal(billId);
            } else {
                BudgetCtrlFacadeFactory.getRemoteInstance().returnBudgetLocal(billId);
            }
        }
        catch (EASBizException ex) {
            result.setResult(3);
            result.getCause().add(ex.getMessage());
        }
        catch (BOSException ex) {
            result.setResult(3);
            result.getCause().add(ex.getMessage());
        }
        return result;
    }

    protected static boolean checkControl(String OUID) {
        return AbstractBgControlCaller.checkHasDimControl() && AbstractBgControlCaller.checkStartDimControl(OUID);
    }

    public static boolean checkControl(Context ctx, String OUID) {
        return AbstractBgControlCaller.checkHasDimControl() && AbstractBgControlCaller.checkStartDimControl(ctx, OUID);
    }

    protected static boolean checkHasDimControl() {
        boolean hasDimControl = false;
        try {
            Class.forName("com.kingdee.eas.ma.control.utils.BgControlConstants");
            hasDimControl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return hasDimControl;
    }

    protected static boolean checkStartDimControl(String OUID) {
        return AbstractBgControlCaller.checkStartDimControl(null, OUID);
    }

    protected static boolean checkStartDimControl(Context ctx, String OUID) {
        boolean re = false;
        re = ctx != null ? BgParamNHelper.isStartupDimControl((Context)ctx, (String)OUID) : BgParamCHelper.isStartupDimControl((String)OUID);
        return re;
    }

    protected IControlResult transResult(com.kingdee.eas.ma.control.face.IControlResult result) throws EASBizException {
        return this.transResult(null, result);
    }

    protected IControlResult transResult(Context ctx, com.kingdee.eas.ma.control.face.IControlResult result) throws EASBizException {
        if (result == null) {
            return null;
        }
        ControlResult _result = new ControlResult();
        _result.setResult(result.getResult());
        if (!result.getCause().isEmpty()) {
            int i;
            String msg = null;
            String[] causes = null;
            String[] tmpStr = null;
            MessageFormat mf = null;
            Locale locale = ctx != null ? ctx.getLocale() : SysContext.getSysContext().getLocale();
            String param = ctx != null ? BgParamNHelper.getBgOrgShowStyle((Context)ctx) : BgParamCHelper.getBgOrgShowStyle();
            HashSet<String> combins = new HashSet<String>();
            Object schemeHelper = null;
            Map combinNames = new HashMap();
            int in = result.getCause().size();
            for (i = 0; i < in; ++i) {
                causes = (String[])result.getCause().get(i);
                combins.add(causes[2]);
            }
            try {
                combinNames = ctx != null ? DimensionFormulaFacadeFactory.getLocalInstance((Context)ctx).getDimensionCombName(((String[])result.getCause().get(0))[14], combins, ((String[])result.getCause().get(0))[15]) : DimensionFormulaFacadeFactory.getRemoteInstance().getDimensionCombName(((String[])result.getCause().get(0))[14], combins, ((String[])result.getCause().get(0))[15]);
            }
            catch (Exception e) {
                throw new BgControlException(BgControlException.NOFOUNDBGSCHEME, new Object[]{((String[])result.getCause().get(0))[1], null});
            }
            in = result.getCause().size();
            for (i = 0; i < in; ++i) {
                causes = (String[])result.getCause().get(i);
                if (causes == null) continue;
                msg = EASCommonResource.getString((String)BgControlConstants.CONTROL_RES, (String)causes[11], (Locale)locale);
                tmpStr = new String[2];
                tmpStr[0] = param != null && param.equals("0") ? causes[0] + "(" + causes[1] + ")" : (param != null && param.equals("1") ? causes[1] : (param != null && param.equals("2") ? causes[13] : causes[1]));
                tmpStr[1] = combinNames.containsKey(causes[2]) ? (combinNames.get(causes[2]) == null || ((String)combinNames.get(causes[2])).isEmpty() ? causes[2] + "(" + causes[3] + ")" : causes[2] + "(" + (String)combinNames.get(causes[2]) + ")") : causes[3];
                mf = new MessageFormat(msg);
                _result.getCause().add(mf.format(tmpStr));
            }
        }
        return _result;
    }

    protected IBudgetBalance transBudgetBalance(com.kingdee.eas.ma.control.face.IBudgetBalance bugetBalance, Context ctx) {
        BudgetBalanceApi bgBalanceApi = new BudgetBalanceApi();
        if (bugetBalance == null) {
            return bgBalanceApi;
        }
        BgControlParam param = null;
        IBalance balance = null;
        int in = bugetBalance.getBalance().size();
        for (int i = 0; i < in; ++i) {
            param = (BgControlParam)bugetBalance.getBalance().get(i);
            if (!param.getNoMembers().isEmpty() || param.getOrgUnit() == null || (balance = this.transBudgetBalance((BgControlParam)bugetBalance.getBalance().get(i), ctx)) == null) continue;
            bgBalanceApi.getBalance().add(balance);
        }
        return bgBalanceApi;
    }

    protected IBalance transBudgetBalance(BgControlParam param, Context ctx) {
        if (param == null) {
            return null;
        }
        BalanceApi balanceApi = new BalanceApi();
        String[] orgUnit = new String[]{param.getOrgUnit().getId().toString(), param.getOrgUnit().getNumber(), param.getOrgUnit().getName(), param.getOrgUnit().getDisplayName()};
        balanceApi.setOrgUnit(orgUnit);
        String[] reqOrgUnit = new String[]{param.getReqOrgUnit().getId().toString(), param.getReqOrgUnit().getNumber(), param.getReqOrgUnit().getName()};
        balanceApi.setReqOrgUnit(reqOrgUnit);
        String[] reqItem = new String[]{param.getBgIndexNumber(), param.getDimItemName(), param.getDimItemNumber()};
        balanceApi.setReqItem(reqItem);
        String[] bgPeirod = new String[]{param.getBgPeriodId(), param.getBgPeriodNumber(), param.getBgPeriodName()};
        balanceApi.setPeriod(bgPeirod);
        String[] bgElement = new String[]{param.getBgElement().getId().toString(), param.getBgElement().getNumber(), param.getBgElement().getName()};
        balanceApi.setElement(bgElement);
        String[] currency = new String[]{param.getCurrency().getId().toString(), param.getCurrency().getNumber(), param.getCurrency().getName()};
        balanceApi.setCurrency(currency);
        String[] bgScheme = new String[]{param.getBgSchemeInfo().getId().toString(), param.getBgSchemeInfo().getNumber(), param.getBgSchemeInfo().getName()};
        balanceApi.setBgScheme(bgScheme);
        String[] bgScenario = new String[]{param.getBgScenario().getId().toString(), param.getBgScenario().getNumber(), param.getBgScenario().getName()};
        balanceApi.setBgScenario(bgScenario);
        String[] priodType = new String[3];
        BgPeriodTypeInfo bgPeriodType = param.getBgPeriodGroup();
        priodType[0] = bgPeriodType.getId().toString();
        priodType[1] = bgPeriodType.getNumber();
        priodType[2] = bgPeriodType.getName();
        balanceApi.setPeriodType(priodType);
        balanceApi.setBudget(BgControlUtils.getBudgetValue((BgControlParam)param));
        balanceApi.setActual(BgControlUtils.getActualValue((BgControlParam)param));
        balanceApi.setBalance(param.getExtBalance() != null ? param.getExtBalance() : param.getBalance());
        balanceApi.setReqAmount(param.getReqAmount());
        balanceApi.setOverBudget(param.isOverBudget());
        balanceApi.setControl(param.isAllowAccess());
        balanceApi.setNotBudget(param.isNotBudget());
        balanceApi.setFlexParam(param.getControlSetting().getFlexParam());
        boolean isZero = false;
        isZero = ctx != null ? BgParamNHelper.isZeroIsNull((Context)ctx) : BgParamCHelper.isZeroIsNull();
        this.dealWithBudgetState(balanceApi, param, isZero);
        return balanceApi;
    }

    private void dealWithBudgetState(IBalance balanceApi, BgControlParam param, boolean isZero) {
        if (balanceApi.getBudget() == null || balanceApi.getBudget() != null && balanceApi.getBudget().compareTo(BigDecimal.ZERO) == 0 && isZero) {
            if (param.getNullBudget().equals((Object)BgControlNullBudgetEnum.PassWithNoCtrlSet)) {
                if (param.getControlSetting().getCtrlType().getValue() == -1) {
                    balanceApi.setNotBudget(false);
                    balanceApi.setOverBudget(false);
                } else if (param.getControlSetting().getCtrlType().getValue() != -1 && param.getControlSetting().isIsAllowAccess() && param.isAllowAccessOfBgScheme()) {
                    balanceApi.setNotBudget(false);
                    balanceApi.setOverBudget(false);
                } else if (!(param.getControlSetting().getCtrlType().getValue() == -1 || param.getControlSetting().isIsAllowAccess() && param.isAllowAccessOfBgScheme())) {
                    if (balanceApi.getBalance().subtract(param.getReqAmount()).compareTo(BigDecimal.ZERO) < 0) {
                        balanceApi.setNotBudget(true);
                        balanceApi.setOverBudget(true);
                    } else {
                        balanceApi.setNotBudget(false);
                        balanceApi.setOverBudget(false);
                    }
                }
            } else if (param.getNullBudget().equals((Object)BgControlNullBudgetEnum.NoPass)) {
                if (param.getExtBalance() != null && param.getExtBalance().compareTo(param.getReqExtAmount()) >= 0) {
                    balanceApi.setNotBudget(false);
                    balanceApi.setOverBudget(false);
                } else if (param.getBalance() != null && param.getBalance().compareTo(param.getReqAmount()) >= 0) {
                    balanceApi.setNotBudget(false);
                    balanceApi.setOverBudget(false);
                } else {
                    balanceApi.setNotBudget(true);
                    balanceApi.setOverBudget(true);
                }
            } else if (param.getNullBudget().equals((Object)BgControlNullBudgetEnum.Pass)) {
                balanceApi.setNotBudget(false);
                balanceApi.setOverBudget(false);
            } else if (param.getNullBudget().equals((Object)BgControlNullBudgetEnum.NoPassWithNoCtrlSet)) {
                if (param.getControlSetting().getCtrlType().getValue() == -1) {
                    balanceApi.setNotBudget(true);
                    balanceApi.setOverBudget(true);
                } else if (param.getControlSetting().getCtrlType().getValue() != -1 && param.getControlSetting().isIsAllowAccess() && param.isAllowAccessOfBgScheme()) {
                    balanceApi.setNotBudget(false);
                    balanceApi.setOverBudget(false);
                } else if (!(param.getControlSetting().getCtrlType().getValue() == -1 || param.getControlSetting().isIsAllowAccess() && param.isAllowAccessOfBgScheme())) {
                    if (balanceApi.getBalance().subtract(param.getReqAmount()).compareTo(BigDecimal.ZERO) < 0) {
                        balanceApi.setNotBudget(true);
                        balanceApi.setOverBudget(true);
                    } else {
                        balanceApi.setNotBudget(false);
                        balanceApi.setOverBudget(false);
                    }
                }
            }
        } else if (param.getControlSetting().getCtrlType().getValue() == -1) {
            if (param.getNotNullBudget().equals((Object)BgControlNotNullBudgetEnum.AsCurrentPeriod)) {
                if (balanceApi.getBalance().subtract(param.getReqAmount()).compareTo(BigDecimal.ZERO) < 0) {
                    balanceApi.setNotBudget(true);
                    balanceApi.setOverBudget(true);
                }
            } else if (param.getNotNullBudget().equals((Object)BgControlNotNullBudgetEnum.Pass)) {
                balanceApi.setNotBudget(false);
                balanceApi.setOverBudget(false);
            } else if (param.getNotNullBudget().equals((Object)BgControlNotNullBudgetEnum.NoPassWithNoCtrlSet)) {
                balanceApi.setNotBudget(true);
                balanceApi.setOverBudget(true);
            }
        }
    }

    protected IBudgetBalance transBudgetBalance(BgCtrlResultCollection colls, boolean hasZeroIsNull) {
        BudgetBalanceApi bgBalanceApi = new BudgetBalanceApi();
        if (colls == null || colls.isEmpty()) {
            return bgBalanceApi;
        }
        IBalance balance = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            balance = this.transBudgetBalance(colls.get(i), hasZeroIsNull);
            if (balance == null) continue;
            bgBalanceApi.getBalance().add(balance);
        }
        return bgBalanceApi;
    }

    protected IBalance transBudgetBalance(BgCtrlResultInfo result, boolean hasZeroIsNull) {
        if (result == null) {
            return null;
        }
        BalanceApi balanceApi = new BalanceApi();
        String[] orgUnit = new String[]{result.getOrgUnitId(), null, result.getOrgUnitName(), result.getOrgUnitName()};
        balanceApi.setOrgUnit(orgUnit);
        balanceApi.setReqOrgUnit(null);
        String[] reqItem = new String[]{result.getItemCombinNumber(), !StringUtils.isEmpty((String)result.getItemCombinName()) ? result.getItemCombinName() : result.getBillItemName()};
        balanceApi.setReqItem(reqItem);
        String[] bgPeirod = new String[]{null, result.getBgPeriodNumber(), result.getPeriodName()};
        balanceApi.setPeriod(bgPeirod);
        String[] bgElement = new String[]{null, null, result.getElementName()};
        balanceApi.setElement(bgElement);
        balanceApi.setCurrency(null);
        if ((result.getBgValue() == null || BgNConstants.ZERO.compareTo(result.getBgValue()) == 0 && hasZeroIsNull) && !result.isCanControlWithoutBudget()) {
            balanceApi.setNotBudget(true);
        }
        balanceApi.setBudget(result.getBgValue());
        balanceApi.setActual(result.getBizActual());
        balanceApi.setBalance(result.getBalance());
        balanceApi.setReqAmount(result.getReqAmount());
        if (result.getMultiRuleCtrlResult() != null) {
            balanceApi.setExtBalance(result.getMultiRuleCtrlResult().getBalance());
        }
        if (balanceApi.getBalance() != null && balanceApi.getReqAmount() != null && balanceApi.getBalance().compareTo(balanceApi.getReqAmount()) < 0) {
            balanceApi.setOverBudget(true);
        }
        if (result.getCtrlType() == null && result.isCanControlWithoutBudget()) {
            balanceApi.setControl(false);
        } else if (result.getCtrlType() != null && result.getCtrlType().getValue() == BgCtrlTypeEnum.NoCtrl.getValue()) {
            balanceApi.setControl(true);
        } else {
            balanceApi.setControl(result.isIsAllowAccess() && result.isSchemeAllowAccess());
        }
        return balanceApi;
    }

    public void checkBudget(IBudgetBalance bgBalance) throws EASBizException {
        this.checkBudget(null, bgBalance);
    }

    public void checkBudget(Context ctx, IBudgetBalance bgBalance) throws EASBizException {
        if (bgBalance == null || bgBalance.getBalance().isEmpty()) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        IBalance balanceApi = null;
        ArrayList<IBalance> balanceList = new ArrayList<IBalance>();
        int in = bgBalance.getBalance().size();
        for (int i = 0; i < in; ++i) {
            balanceApi = bgBalance.getBalance().get(i);
            if (balanceApi.isNotBudget()) {
                balanceList.add(balanceApi);
                continue;
            }
            if (!balanceApi.isOverBudget() || balanceApi.isControl()) continue;
            balanceList.add(balanceApi);
        }
        msg = this.getControlMsg(ctx, balanceList);
        if (msg.length() > 0) {
            throw new BgControlException(BgControlException.ISOVERBUDGET, (Object[])new String[]{msg.toString()});
        }
    }

    protected StringBuffer getControlMsg(Context ctx, IBalance balance) throws EASBizException {
        ArrayList<IBalance> balanceList = new ArrayList<IBalance>();
        balanceList.add(balance);
        return this.getControlMsg(ctx, balanceList);
    }

    protected StringBuffer getControlMsg(Context ctx, List<IBalance> balanceList) throws EASBizException {
        int i;
        if (balanceList == null || balanceList.size() == 0) {
            return new StringBuffer();
        }
        Locale locale = ctx != null ? ctx.getLocale() : SysContext.getSysContext().getLocale();
        String msg = null;
        String param = null;
        StringBuffer msgBuffer = new StringBuffer();
        IBalance balance = null;
        Map combinNames = new HashMap();
        if (ctx != null) {
            param = BgParamNHelper.getBgOrgShowStyle((Context)ctx);
            msg = ResourceBase.getString((String)BgControlConstants.CONTROL_RES, (String)"isOverBudget", (Locale)locale);
        } else {
            param = BgParamCHelper.getBgOrgShowStyle();
            msg = EASCommonResource.getString((String)BgControlConstants.CONTROL_RES, (String)"isOverBudget", (Locale)locale);
        }
        MessageFormat mf = new MessageFormat(msg);
        String result = null;
        HashSet<String> combins = new HashSet<String>();
        Object schemeHelper = null;
        for (i = 0; i < balanceList.size(); ++i) {
            if (balanceList.get(i).getReqItem().length < 3) continue;
            combins.add(balanceList.get(i).getReqItem()[2]);
        }
        try {
            if (!combins.isEmpty()) {
                combinNames = ctx != null ? DimensionFormulaFacadeFactory.getLocalInstance((Context)ctx).getDimensionCombName(balanceList.get(0).getBgScheme()[0], combins, balanceList.get(0).getOrgUnit()[0]) : DimensionFormulaFacadeFactory.getRemoteInstance().getDimensionCombName(balanceList.get(0).getBgScheme()[0], combins, balanceList.get(0).getOrgUnit()[0]);
            }
        }
        catch (Exception e) {
            throw new BgControlException(BgControlException.NOFOUNDBGSCHEME, new Object[]{balanceList.get(0).getOrgUnit()[1], null});
        }
        for (i = 0; i < balanceList.size(); ++i) {
            balance = balanceList.get(i);
            String reqItemString = null;
            reqItemString = !combinNames.isEmpty() ? balance.getReqItem()[2] + "(" + (combinNames.get(balance.getReqItem()[2]) != null ? (String)combinNames.get(balance.getReqItem()[2]) : balance.getReqItem()[1]) + ")" : balance.getReqItem()[1];
            result = param != null && param.equals("0") ? mf.format(new String[]{balance.getOrgUnit()[1] + "(" + balance.getOrgUnit()[2] + ")", reqItemString}) : (param != null && param.equals("1") ? mf.format(new String[]{balance.getOrgUnit()[2], reqItemString}) : (param != null && param.equals("2") ? mf.format(new String[]{balance.getOrgUnit()[3], reqItemString}) : mf.format(new String[]{balance.getOrgUnit()[2], reqItemString})));
            msgBuffer.append(result).append("\n");
        }
        return msgBuffer;
    }

    protected String transBudgetBalanceToJson(Context ctx, com.kingdee.eas.ma.control.face.IBudgetBalance balance, int type) throws EASBizException, BOSException {
        if (balance == null || balance.getBalance().isEmpty()) {
            return "";
        }
        String json = "";
        BgCellRenderHelper cellHelper = new BgCellRenderHelper();
        cellHelper.init(ctx);
        Map combinNames = DimensionFormulaHelper.queryCombinNames((Context)ctx, (com.kingdee.eas.ma.control.face.IBudgetBalance)balance);
        JSONObject data = new JSONObject();
        HashMap<String, String> companyMap = new HashMap<String, String>();
        String orgUnitId = null;
        String companyId = null;
        String bgSchemeId = null;
        BgControlParam param = null;
        if (type == 0) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("orgUnit", this.getRecourseStr(ctx, "bizOrgunit"));
            map.put("scheme", this.getRecourseStr(ctx, "bgScheme"));
            map.put("index", this.getRecourseStr(ctx, "bgAccount"));
            map.put("member", this.getRecourseStr(ctx, "bgDim"));
            map.put("bgScenario", this.getRecourseStr(ctx, "bgScenario"));
            map.put("acScenario", this.getRecourseStr(ctx, "actScenario"));
            map.put("bgPeriodType", this.getRecourseStr(ctx, "periodType"));
            map.put("bgPeriod", this.getRecourseStr(ctx, "period"));
            map.put("bgElement", this.getRecourseStr(ctx, "bgElement"));
            map.put("type", this.getRecourseStr(ctx, "controlSetting"));
            map.put("budget", this.getRecourseStr(ctx, "bgData"));
            map.put("actual", this.getRecourseStr(ctx, "actData"));
            map.put("apply", this.getRecourseStr(ctx, "aplData"));
            map.put("balance", this.getRecourseStr(ctx, "balance"));
            map.put("currency", this.getRecourseStr(ctx, "currency"));
            JSONObject nameObject = new JSONObject(map);
            data.put("dimensiondata", (Object)nameObject);
            JSONArray budgetdata = new JSONArray();
            for (int i = 0; i < balance.getBalance().size(); ++i) {
                param = (BgControlParam)balance.getBalance().get(i);
                JSONObject budgetList = new JSONObject();
                if (!param.getNoMembers().isEmpty() || param.getOrgUnit() == null) continue;
                bgSchemeId = param.getBgSchemeInfo().getId().toString();
                if (param.getControlSetting() == null || param.getControlSetting().getCtrlType() == null || param.getControlSetting().getCtrlType().getValue() == -1) {
                    // empty if block
                }
                budgetList.put("orgUnit", (Object)param.getOrgUnit().getName());
                budgetList.put("scheme", (Object)param.getBgSchemeInfo().getName());
                String bgIndexNumber = param.getBgIndexNumber();
                String indexName = BgControlParam.getName((String)bgSchemeId, (Map)combinNames, (String)bgIndexNumber, (BgControlParam)param);
                orgUnitId = param.getOrgUnit().getId().toString();
                companyId = this.getCompanyId(ctx, companyMap, orgUnitId);
                String accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme((Context)ctx, (BgSchemeInfo)param.getBgSchemeInfo());
                if (accountViewId != null) {
                    budgetList.put("index", (Object)cellHelper.getIndexDisplayName(ctx, accountViewId, bgIndexNumber, indexName));
                } else {
                    budgetList.put("index", (Object)(bgIndexNumber + "(" + indexName + ")"));
                }
                BgDimensionMember bgIndex = new BgDimensionMember(null, "F2", indexName, bgIndexNumber.split(":")[1]);
                String srcNumber = bgIndexNumber.split(":")[0];
                bgIndex.setSrcNumber(srcNumber);
                String extName = BgControlParam.getExtName((String)bgSchemeId, (Map)combinNames, (BgControlParam)param);
                String extRefField = BgControlParam.getExtRefField((BgControlParam)param);
                String extNumber = BgControlParam.getExtNumber((BgControlParam)param);
                if (!StringUtils.isEmpty((String)extNumber)) {
                    String[] numbers = extNumber.split(",");
                    StringBuilder srcnumbers = new StringBuilder();
                    StringBuilder elementNumbers = new StringBuilder();
                    for (int j = 0; j < numbers.length; ++j) {
                        String[] split = numbers[j].split(":");
                        if (split.length != 2) continue;
                        srcnumbers.append(split[0]).append(",");
                        elementNumbers.append(split[1]).append(",");
                    }
                    String memberSrcNumber = srcnumbers.deleteCharAt(srcnumbers.lastIndexOf(",")).toString();
                    String memberNumbers = elementNumbers.deleteCharAt(elementNumbers.lastIndexOf(",")).toString();
                    BgDimensionMember combinNumbers = new BgDimensionMember(null, extRefField, extName, memberNumbers);
                    combinNumbers.setSrcNumber(memberSrcNumber);
                    budgetList.put("member", (Object)cellHelper.getIndexDisplayName(ctx, companyId, extNumber, extName));
                } else {
                    budgetList.put("member", (Object)"");
                }
                budgetList.put("bgScenario", (Object)param.getBgScenario().getName());
                budgetList.put("acScenario", (Object)param.getAcScenario().getName());
                budgetList.put("bgPeriodType", (Object)param.getBgPeriodGroup().getName());
                budgetList.put("bgPeriod", (Object)param.getBgPeriodName());
                budgetList.put("bgElement", (Object)param.getBgElement().getName());
                budgetList.put("type", (Object)param.getControlSetting().getCtrlType().getAlias());
                budgetList.put("budget", (Object)BgControlUtils.getBudgetValue((BgControlParam)param));
                budgetList.put("actual", (Object)BgControlUtils.getActualValue((BgControlParam)param));
                budgetList.put("apply", (Object)BgControlUtils.getRequestValue((BgControlParam)param));
                if (param.getExtBalance() != null) {
                    budgetList.put("balance", (Object)param.getExtBalance());
                } else {
                    budgetList.put("balance", (Object)param.getBalance());
                }
                budgetList.put("currency", (Object)(param.getCurrency().getName() + "_" + param.getCurrency().getNumber()));
                budgetdata.add((Object)budgetList);
            }
            data.put("budgetdata", (Object)budgetdata);
            json = data.toString();
        } else if (type == 1) {
            JSONArray budgetdata = new JSONArray();
            for (int i = 0; i < balance.getBalance().size(); ++i) {
                param = (BgControlParam)balance.getBalance().get(i);
                JSONObject budgetList = new JSONObject();
                if (!param.getNoMembers().isEmpty() || param.getOrgUnit() == null) continue;
                bgSchemeId = param.getBgSchemeInfo().getId().toString();
                if (param.getControlSetting() == null || param.getControlSetting().getCtrlType() == null || param.getControlSetting().getCtrlType().getValue() == -1) {
                    // empty if block
                }
                budgetList.put("orgUnit", (Object)param.getOrgUnit().getName());
                budgetList.put("scheme", (Object)param.getBgSchemeInfo().getName());
                String bgIndexNumber = param.getBgIndexNumber();
                String indexName = BgControlParam.getName((String)bgSchemeId, (Map)combinNames, (String)bgIndexNumber, (BgControlParam)param);
                orgUnitId = param.getOrgUnit().getId().toString();
                companyId = this.getCompanyId(ctx, companyMap, orgUnitId);
                String accountViewId = BgCellRenderHelper.getAccountViewIdByBgScheme((Context)ctx, (BgSchemeInfo)param.getBgSchemeInfo());
                if (accountViewId != null) {
                    budgetList.put("index", (Object)cellHelper.getIndexDisplayName(ctx, accountViewId, bgIndexNumber, indexName));
                } else {
                    budgetList.put("index", (Object)(bgIndexNumber + "(" + indexName + ")"));
                }
                BgDimensionMember bgIndex = new BgDimensionMember(null, "F2", indexName, bgIndexNumber.split(":")[1]);
                String srcNumber = bgIndexNumber.split(":")[0];
                bgIndex.setSrcNumber(srcNumber);
                String extName = BgControlParam.getExtName((String)bgSchemeId, (Map)combinNames, (BgControlParam)param);
                String extRefField = BgControlParam.getExtRefField((BgControlParam)param);
                String extNumber = BgControlParam.getExtNumber((BgControlParam)param);
                if (!StringUtils.isEmpty((String)extNumber)) {
                    String[] numbers = extNumber.split(",");
                    StringBuilder srcnumbers = new StringBuilder();
                    StringBuilder elementNumbers = new StringBuilder();
                    for (int j = 0; j < numbers.length; ++j) {
                        String[] split = numbers[j].split(":");
                        if (split.length != 2) continue;
                        srcnumbers.append(split[0]).append(",");
                        elementNumbers.append(split[1]).append(",");
                    }
                    String memberSrcNumber = srcnumbers.deleteCharAt(srcnumbers.lastIndexOf(",")).toString();
                    String memberNumbers = elementNumbers.deleteCharAt(elementNumbers.lastIndexOf(",")).toString();
                    BgDimensionMember combinNumbers = new BgDimensionMember(null, extRefField, extName, memberNumbers);
                    combinNumbers.setSrcNumber(memberSrcNumber);
                    budgetList.put("member", (Object)cellHelper.getIndexDisplayName(ctx, companyId, extNumber, extName));
                } else {
                    budgetList.put("member", (Object)"");
                }
                budgetList.put("bgScenario", (Object)param.getBgScenario().getName());
                budgetList.put("acScenario", (Object)param.getAcScenario().getName());
                budgetList.put("bgPeriodType", (Object)param.getBgPeriodGroup().getName());
                budgetList.put("bgPeriod", (Object)param.getBgPeriodName());
                budgetList.put("bgElement", (Object)param.getBgElement().getName());
                budgetList.put("type", (Object)param.getControlSetting().getCtrlType().getAlias());
                budgetList.put("budget", (Object)BgControlUtils.getBudgetValue((BgControlParam)param));
                budgetList.put("actual", (Object)BgControlUtils.getActualValue((BgControlParam)param));
                budgetList.put("apply", (Object)BgControlUtils.getRequestValue((BgControlParam)param));
                if (param.getExtBalance() != null) {
                    budgetList.put("balance", (Object)param.getExtBalance());
                } else {
                    budgetList.put("balance", (Object)param.getBalance());
                }
                budgetList.put("currency", (Object)(param.getCurrency().getName() + "_" + param.getCurrency().getNumber()));
                budgetList.put("success", (Object)true);
                budgetList.put("seq", (Object)(i + 1));
                budgetList.put("currencyName", (Object)param.getCurrency().getName());
                budgetList.put("currencyNumber", (Object)param.getCurrency().getNumber());
                if (param.getExtBalance() != null) {
                    budgetList.put("budgetamount", (Object)param.getExtBalance());
                } else {
                    budgetList.put("budgetamount", (Object)param.getBalance());
                }
                budgetList.put("errormsg", (Object)"");
                budgetdata.add((Object)budgetList);
            }
            data.put("budgetdata", (Object)budgetdata);
            json = data.toString();
        }
        return json;
    }

    private String getCompanyId(Context ctx, Map<String, String> companyMap, String orgUnitId) {
        String companyId = null;
        if (companyMap.containsKey(orgUnitId)) {
            companyId = companyMap.get(orgUnitId);
        } else {
            try {
                CompanyOrgUnitInfo company = BgNFSHelper.getCompanyByOrgUnit((Context)ctx, (BOSUuid)BOSUuid.read((String)orgUnitId));
                if (company != null) {
                    companyId = company.getId().toString();
                    companyMap.put(orgUnitId, companyId);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return companyId;
    }

    private String getRecourseStr(Context ctx, String resKey) {
        if (ctx != null) {
            return ResourceBase.getString((String)BgControlConstants.CONTROL_RES, (String)resKey, (Locale)ctx.getLocale());
        }
        return EASResource.getString((String)BgControlConstants.CONTROL_RES, (String)resKey);
    }
}

