/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgControlFacadeFactory;
import com.kingdee.eas.ma.budget.BgCtrlResultCollection;
import com.kingdee.eas.ma.budget.BudgetCtrlFacadeFactory;
import com.kingdee.eas.ma.budget.client.BudgetCtrlClientCaller;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.control.client.utils.MbgControlClientCaller;
import com.kingdee.eas.ma.control.utils.BgControlUtils;
import com.kingdee.eas.ma.nbudget.AbstractBgControlCaller;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.face.IBgControl;
import com.kingdee.eas.ma.nbudget.face.IBudgetBalance;
import com.kingdee.eas.ma.nbudget.face.IControlResult;
import com.kingdee.eas.ma.nbudget.face.IExtBillCheck;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.List;

public class BgControlCaller
extends AbstractBgControlCaller
implements IBgControl {
    @Override
    public IControlResult requestBudget(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (ctx == null || billId == null) {
            return null;
        }
        IControlResult result = null;
        if (BgControlCaller.checkControl(ctx, BgControlCaller.getOUID(ctx, billId))) {
            com.kingdee.eas.ma.control.face.IControlResult _result = com.kingdee.eas.ma.control.BgControlFacadeFactory.getLocalInstance((Context)ctx).requestBudget(billId);
            result = this.transResult(ctx, _result);
        } else {
            result = this.requestOldBudget(ctx, billId);
        }
        return result;
    }

    @Override
    public IControlResult requestBudget(BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return null;
        }
        IControlResult result = null;
        if (BgControlCaller.checkControl(BgControlCaller.getOUID(null, billId))) {
            com.kingdee.eas.ma.control.face.IControlResult _result = com.kingdee.eas.ma.control.BgControlFacadeFactory.getRemoteInstance().requestBudget(billId);
            result = this.transResult(_result);
        } else {
            result = this.requestOldBudget(billId);
        }
        return result;
    }

    @Override
    public IControlResult specialBudget(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (ctx == null || billId == null) {
            return null;
        }
        IControlResult result = null;
        if (BgControlCaller.checkControl(ctx, BgControlCaller.getOUID(ctx, billId))) {
            com.kingdee.eas.ma.control.face.IControlResult _result = com.kingdee.eas.ma.control.BgControlFacadeFactory.getLocalInstance((Context)ctx).specialBudget(billId);
            result = this.transResult(ctx, _result);
        } else {
            result = this.specialOldBudget(ctx, billId);
        }
        return result;
    }

    @Override
    public IControlResult specialBudget(BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return null;
        }
        IControlResult result = null;
        if (BgControlCaller.checkControl(BgControlCaller.getOUID(null, billId))) {
            com.kingdee.eas.ma.control.face.IControlResult _result = com.kingdee.eas.ma.control.BgControlFacadeFactory.getRemoteInstance().specialBudget(billId);
            result = this.transResult(_result);
        } else {
            result = this.specialOldBudget(billId);
        }
        return result;
    }

    @Override
    public IControlResult requestOccupation(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (ctx == null || billId == null) {
            return null;
        }
        IControlResult result = null;
        if (!BgControlCaller.checkControl(ctx, BgControlCaller.getOUID(ctx, billId))) {
            result = this.requestOldOccupation(ctx, billId);
        }
        return result;
    }

    @Override
    public IControlResult requestOccupation(BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return null;
        }
        IControlResult result = null;
        if (!BgControlCaller.checkControl(BgControlCaller.getOUID(null, billId))) {
            result = this.requestOldOccupation(billId);
        }
        return result;
    }

    @Override
    public IControlResult specialOccupation(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (ctx == null || billId == null) {
            return null;
        }
        IControlResult result = null;
        if (!BgControlCaller.checkControl(ctx, BgControlCaller.getOUID(ctx, billId))) {
            result = this.specialOldOccupation(ctx, billId);
        }
        return result;
    }

    @Override
    public IControlResult specialOccupation(BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return null;
        }
        IControlResult result = null;
        if (!BgControlCaller.checkControl(BgControlCaller.getOUID(null, billId))) {
            result = this.specialOldOccupation(billId);
        }
        return result;
    }

    @Override
    public IControlResult returnBudget(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (ctx == null || billId == null) {
            return null;
        }
        IControlResult result = null;
        if (BgControlCaller.checkControl(ctx, BgControlCaller.getOUID(ctx, billId))) {
            com.kingdee.eas.ma.control.face.IControlResult _result = com.kingdee.eas.ma.control.BgControlFacadeFactory.getLocalInstance((Context)ctx).returnBudget(billId);
            result = this.transResult(ctx, _result);
        } else {
            result = this.returnOldBudget(ctx, billId);
        }
        return result;
    }

    @Override
    public IControlResult returnBudget(BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return null;
        }
        IControlResult result = null;
        if (BgControlCaller.checkControl(BgControlCaller.getOUID(null, billId))) {
            com.kingdee.eas.ma.control.face.IControlResult _result = com.kingdee.eas.ma.control.BgControlFacadeFactory.getRemoteInstance().returnBudget(billId);
            result = this.transResult(_result);
        } else {
            result = this.returnOldBudget(billId);
        }
        return result;
    }

    @Override
    public IBudgetBalance queryBalance(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (ctx == null || billId == null) {
            return null;
        }
        IBudgetBalance balance = null;
        if (BgControlCaller.checkControl(ctx, BgControlCaller.getOUID(ctx, billId))) {
            com.kingdee.eas.ma.control.face.IBudgetBalance _balance = com.kingdee.eas.ma.control.BgControlFacadeFactory.getLocalInstance((Context)ctx).queryBalance(billId);
            balance = this.transBudgetBalance(_balance, ctx);
        } else {
            boolean hasZeroIsNull = BgNSHelper.isZeroDealtoNull((Context)ctx);
            BgCtrlResultCollection colls = BudgetCtrlFacadeFactory.getLocalInstance((Context)ctx).getBudget(billId.toString());
            balance = this.transBudgetBalance(colls, hasZeroIsNull);
        }
        return balance;
    }

    @Override
    public IBudgetBalance queryBalance(BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return null;
        }
        IBudgetBalance balance = null;
        if (BgControlCaller.checkControl(BgControlCaller.getOUID(null, billId))) {
            com.kingdee.eas.ma.control.face.IBudgetBalance _balance = com.kingdee.eas.ma.control.BgControlFacadeFactory.getRemoteInstance().queryBalance(billId);
            balance = this.transBudgetBalance(_balance, null);
        } else {
            boolean hasZeroIsNull = BgNSHelper.isZeroDealtoNull();
            BgCtrlResultCollection colls = BudgetCtrlFacadeFactory.getRemoteInstance().getBudget(billId.toString());
            balance = this.transBudgetBalance(colls, hasZeroIsNull);
        }
        return balance;
    }

    @Override
    public IBudgetBalance queryBalance(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            return null;
        }
        IBudgetBalance balance = null;
        if (BgControlCaller.checkControl(ctx, BgControlCaller.getOUID(ctx, model))) {
            com.kingdee.eas.ma.control.face.IBudgetBalance _balance = com.kingdee.eas.ma.control.BgControlFacadeFactory.getLocalInstance((Context)ctx).queryBalance(model);
            balance = this.transBudgetBalance(_balance, ctx);
        } else {
            boolean hasZeroIsNull = BgNSHelper.isZeroDealtoNull((Context)ctx);
            BgCtrlResultCollection colls = BudgetCtrlFacadeFactory.getLocalInstance((Context)ctx).getBudget(model);
            balance = this.transBudgetBalance(colls, hasZeroIsNull);
        }
        return balance;
    }

    @Override
    public IBudgetBalance queryBalance(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return null;
        }
        IBudgetBalance balance = null;
        if (BgControlCaller.checkControl(BgControlCaller.getOUID(null, model))) {
            com.kingdee.eas.ma.control.face.IBudgetBalance _balance = com.kingdee.eas.ma.control.BgControlFacadeFactory.getRemoteInstance().queryBalance(model);
            balance = this.transBudgetBalance(_balance, null);
        } else {
            boolean hasZeroIsNull = BgNSHelper.isZeroDealtoNull();
            BgCtrlResultCollection colls = BudgetCtrlFacadeFactory.getRemoteInstance().getBudget(model);
            balance = this.transBudgetBalance(colls, hasZeroIsNull);
        }
        return balance;
    }

    public void checkBudget(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (BgControlCaller.checkControl(ctx, BgControlCaller.getOUID(ctx, billId))) {
            IBudgetBalance balance = this.queryBalance(ctx, billId);
            this.checkBudget(ctx, balance);
        } else {
            BudgetCtrlFacadeFactory.getLocalInstance((Context)ctx).checkBudget(billId, null);
        }
    }

    public void checkBudget(BOSUuid billId) throws BOSException, EASBizException {
        if (BgControlCaller.checkControl(BgControlCaller.getOUID(null, billId))) {
            IBudgetBalance balance = this.queryBalance(billId);
            this.checkBudget(balance);
        } else {
            BudgetCtrlFacadeFactory.getRemoteInstance().checkBudget(billId, null);
        }
    }

    public void checkBudget(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (BgControlCaller.checkControl(ctx, BgControlCaller.getOUID(ctx, model))) {
            IBudgetBalance balance = this.queryBalance(ctx, model);
            this.checkBudget(ctx, balance);
        } else {
            BudgetCtrlFacadeFactory.getLocalInstance((Context)ctx).checkBudgetLocal(model);
        }
    }

    public void checkBudget(IObjectValue model) throws BOSException, EASBizException {
        if (BgControlCaller.checkControl(BgControlCaller.getOUID(null, model))) {
            IBudgetBalance balance = this.queryBalance(model);
            this.checkBudget(balance);
        } else {
            BudgetCtrlFacadeFactory.getRemoteInstance().checkBudgetLocal(model);
        }
    }

    @Override
    public boolean checkBizUnitInfo(Context ctx, BOSUuid billId, IExtBillCheck check) throws BOSException, EASBizException {
        if (ctx == null || billId == null) {
            return false;
        }
        if (BgControlCaller.checkControl(ctx, BgControlCaller.getOUID(ctx, billId))) {
            String className = null;
            if (check != null) {
                className = check.getClass().getName();
            }
            com.kingdee.eas.ma.control.BgControlFacadeFactory.getLocalInstance((Context)ctx).checkBizUnitInfo(billId, className);
        } else {
            BudgetCtrlFacadeFactory.getLocalInstance((Context)ctx).checkBillInfo(billId.toString());
        }
        return true;
    }

    @Override
    public boolean checkBizUnitInfo(BOSUuid billId, IExtBillCheck check) throws BOSException, EASBizException {
        if (billId == null) {
            return false;
        }
        if (BgControlCaller.checkControl(BgControlCaller.getOUID(null, billId))) {
            String className = null;
            if (check != null) {
                className = check.getClass().getName();
            }
            com.kingdee.eas.ma.control.BgControlFacadeFactory.getRemoteInstance().checkBizUnitInfo(billId, className);
        } else {
            BudgetCtrlFacadeFactory.getRemoteInstance().checkBillInfo(billId.toString());
        }
        return true;
    }

    @Override
    public boolean checkBizUnitInfo(Context ctx, IObjectValue model, IExtBillCheck check) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            return false;
        }
        if (BgControlCaller.checkControl(ctx, BgControlCaller.getOUID(ctx, model))) {
            String className = null;
            if (check != null) {
                className = check.getClass().getName();
            }
            com.kingdee.eas.ma.control.BgControlFacadeFactory.getLocalInstance((Context)ctx).checkBizUnitInfo(model, className);
        } else {
            BudgetCtrlFacadeFactory.getLocalInstance((Context)ctx).checkBillInfo(model);
        }
        return true;
    }

    @Override
    public boolean checkBizUnitInfo(IObjectValue model, IExtBillCheck check) throws BOSException, EASBizException {
        if (model == null) {
            return false;
        }
        if (BgControlCaller.checkControl(BgControlCaller.getOUID(null, model))) {
            String className = null;
            if (check != null) {
                className = check.getClass().getName();
            }
            com.kingdee.eas.ma.control.BgControlFacadeFactory.getRemoteInstance().checkBizUnitInfo(model, className);
        } else {
            BudgetCtrlFacadeFactory.getRemoteInstance().checkBillInfo(model);
        }
        return true;
    }

    @Override
    public List<String> getRequestFields(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (ctx == null || billId == null) {
            return null;
        }
        List fields = null;
        if (BgControlCaller.checkControl(ctx, BgControlCaller.getOUID(ctx, billId))) {
            fields = com.kingdee.eas.ma.control.BgControlFacadeFactory.getLocalInstance((Context)ctx).getRequestFields(billId);
        } else {
            BOSObjectType bosType = billId.getType();
            String bizUnit = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)bosType).getFullName();
            String OUID = BgControlUtils.getBillOUID((Context)ctx, (String)bizUnit, (BOSUuid)billId);
            fields = BgControlFacadeFactory.getLocalInstance((Context)ctx).checkRequireFields(bizUnit, OUID);
        }
        return fields;
    }

    @Override
    public List<String> getRequestFields(BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return null;
        }
        List fields = null;
        if (BgControlCaller.checkControl(BgControlCaller.getOUID(null, billId))) {
            fields = com.kingdee.eas.ma.control.BgControlFacadeFactory.getRemoteInstance().getRequestFields(billId);
        } else {
            BOSObjectType bosType = billId.getType();
            String bizUnit = MetaDataLoader.getEntity(null, (BOSObjectType)bosType).getFullName();
            String OUID = BgControlUtils.getBillOUID(null, (String)bizUnit, (BOSUuid)billId);
            fields = BgControlFacadeFactory.getRemoteInstance().checkRequireFields(bizUnit, OUID);
        }
        return fields;
    }

    @Override
    public List<String> getRequestFields(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            return null;
        }
        List fields = null;
        if (BgControlCaller.checkControl(ctx, BgControlCaller.getOUID(ctx, model))) {
            fields = com.kingdee.eas.ma.control.BgControlFacadeFactory.getLocalInstance((Context)ctx).getRequestFields(model);
        }
        return fields;
    }

    @Override
    public List<String> getRequestFields(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return null;
        }
        List fields = null;
        if (BgControlCaller.checkControl(BgControlCaller.getOUID(null, model))) {
            fields = com.kingdee.eas.ma.control.BgControlFacadeFactory.getRemoteInstance().getRequestFields(model);
        } else {
            String billId = model.getString(model.getPKField());
            if (!StringUtils.isEmpty((String)billId)) {
                BOSObjectType bosType = model.getBOSType();
                String bizUnit = MetaDataLoader.getEntity(null, (BOSObjectType)bosType).getFullName();
                String OUID = BgControlUtils.getBillOUID(null, (String)bizUnit, (BOSUuid)BOSUuid.read((String)billId));
                fields = BgControlFacadeFactory.getRemoteInstance().checkRequireFields(bizUnit, OUID);
            }
        }
        return fields;
    }

    public static void showBudget(Component owner, IObjectValue model) throws BOSException, EASBizException {
        if (owner == null || model == null) {
            return;
        }
        if (BgControlCaller.checkControl(BgControlCaller.getOUID(null, model))) {
            MbgControlClientCaller.showBudget((Component)owner, (IObjectValue)model);
        } else {
            BudgetCtrlClientCaller.showBalanceViewUI((IObjectValue)model, (Object)owner);
        }
    }

    public static void showBudget(Component owner, BOSUuid billId) throws BOSException, EASBizException {
        if (owner == null || billId == null) {
            return;
        }
        if (BgControlCaller.checkControl(BgControlCaller.getOUID(null, billId))) {
            MbgControlClientCaller.showBudget((Component)owner, (BOSUuid)billId);
        } else {
            BudgetCtrlClientCaller.showBalanceViewUI((BOSUuid)billId, (Object)owner);
        }
    }

    public static String getOUID(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        String bizUnit = BgControlUtils.getBizUnit((Context)ctx, (BOSUuid)billId);
        String OUID = BgControlUtils.getBillOUID((Context)ctx, (String)bizUnit, (BOSUuid)billId);
        if (OUID == null) {
            throw new BgControlException(BgControlException.NOFOUNDORGUNIT);
        }
        return OUID;
    }

    public static String getOUID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            throw new BgControlException(BgControlException.CONTROLPARAMETERERROR);
        }
        String bizUnit = BgControlUtils.getBizUnit((Context)ctx, (IObjectValue)model);
        String OUID = BgControlUtils.getBillOUID((Context)ctx, (String)bizUnit, (IObjectValue)model);
        if (OUID == null) {
            throw new BgControlException(BgControlException.NOFOUNDORGUNIT);
        }
        return OUID;
    }

    public String queryBalanceToCQ(Context ctx, IObjectValue model, int type) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            return null;
        }
        com.kingdee.eas.ma.control.face.IBudgetBalance _balance = com.kingdee.eas.ma.control.BgControlFacadeFactory.getLocalInstance((Context)ctx).queryBalance(model);
        return this.transBudgetBalanceToJson(ctx, _balance, type);
    }
}

