/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.nbudget.check;

import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.nbudget.check.ICheck;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class BgCheckRefImpl
implements ICheck,
com.kingdee.eas.basedata.assistant.ICheck {
    private static Logger logger = Logger.getLogger(BgCheckRefImpl.class);
    private static final String PROJECT_UUID_TYPE = "DADE05EE";
    private static final String EXPENSETYPE_UUID_TYPE = "78E4BC94";

    @Override
    public boolean check(Context ctx, BOSUuid uuid) throws EASBizException {
        boolean re = false;
        if (ctx == null || uuid == null) {
            return false;
        }
        String _type = uuid.getType().toString();
        if (_type.equals(PROJECT_UUID_TYPE)) {
            re = this.checkProject(ctx, uuid);
        } else if (_type.equals(EXPENSETYPE_UUID_TYPE)) {
            re = this.checkExpenseType(ctx, uuid);
        }
        if (re) {
            throw new DimensionException(DimensionException.BUDGETREFERENCE);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkProject(Context ctx, BOSUuid uuid) {
        boolean re = false;
        if (ctx == null || uuid == null) {
            return re;
        }
        Connection conn = null;
        IRowSet rst = null;
        String[] dimStrs = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            dimStrs = this.checkRefDim(conn, PROJECT_UUID_TYPE);
            if (dimStrs != null && !StringUtils.isEmpty((String)dimStrs[0]) && (rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FNumber from T_BD_Project where FID = ?", (Object[])new Object[]{uuid.toString()})).next()) {
                re = this.checkRefBgData(conn, rst.getString("FNumber"), dimStrs);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"checkProject sql error:", (Throwable)ex);
        }
        catch (SQLDataException ex) {
            logger.error((Object)"checkProject sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst, null, (Connection)conn);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkExpenseType(Context ctx, BOSUuid uuid) {
        boolean re = false;
        if (ctx == null || uuid == null) {
            return re;
        }
        Connection conn = null;
        IRowSet rst = null;
        String[] dimStrs = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            dimStrs = this.checkRefDim(conn, EXPENSETYPE_UUID_TYPE);
            if (dimStrs != null && !StringUtils.isEmpty((String)dimStrs[0]) && (rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FNumber from T_BC_ExpenseType where FID = ?", (Object[])new Object[]{uuid.toString()})).next()) {
                re = this.checkRefBgData(conn, rst.getString("FNumber"), dimStrs);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"checkProject sql error:", (Throwable)ex);
        }
        catch (SQLDataException ex) {
            logger.error((Object)"checkProject sql error:", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst, null, (Connection)conn);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] checkRefDim(Connection conn, String srcId) throws SQLException {
        String[] dimStrs = null;
        if (conn == null || srcId == null) {
            return dimStrs;
        }
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select t.FRefField, s.FSrcNumber from T_MBG_DIM t join T_MBG_DimSrc s on t.FID = s.FDIMID where s.FSrcId = ?", (Object[])new Object[]{srcId});
            if (rst.next()) {
                dimStrs = new String[]{rst.getString("FRefField"), rst.getString("FSrcNumber")};
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return dimStrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkRefBgData(Connection conn, String number, String[] dimStrs) throws SQLException {
        boolean re = false;
        if (conn == null || number == null || dimStrs == null) {
            return re;
        }
        String refField = dimStrs[0];
        String dimNumber = dimStrs[1] + ":" + number;
        String refMbgItemId = null;
        ArrayList<String> cubes = new ArrayList<String>();
        ResultSet rst = null;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("select FID from T_MBG_BgItemCombination where FKey like ? and FDimkey like ? and " + dimStrs[0] + " = ?");
            if (refField.equals("F2")) {
                pstmt.setString(1, dimNumber + "%");
                pstmt.setString(2, refField + "%");
                pstmt.setString(3, dimNumber);
            } else {
                pstmt.setString(1, "%" + dimNumber + "%");
                pstmt.setString(2, "%" + refField + "%");
                pstmt.setString(3, dimNumber);
            }
            rst = pstmt.executeQuery();
            if (rst.next()) {
                refMbgItemId = rst.getString("FID");
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!StringUtils.isEmpty((String)refMbgItemId)) {
                pstmt = conn.prepareStatement("select t.FREFCUBE from T_MBG_BgScheme t join T_MBG_BgSchemeRefDim r on t.fid = r.FBGSCHEMEID  where r.FBGDIMNUMBER  like ?");
                if (refField.equals("F2")) {
                    pstmt.setString(1, refField + "%");
                } else {
                    pstmt.setString(1, "%" + refField + "%");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    cubes.add(rst.getString("FREFCUBE"));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                for (String cubeName : cubes) {
                    rst = BgDBUtils.executeQuery((Connection)conn, (String)("select TOP 1 FBgItemCombinID from " + cubeName + " where FBgItemCombinID = ?"), (Object[])new Object[]{refMbgItemId});
                    if (rst.next()) {
                        re = true;
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    if (re) break;
                    rst = BgDBUtils.executeQuery((Connection)conn, (String)("select TOP 1 FBgItemCombinID from " + BgCubeUtils.getActualCubeName((String)cubeName) + " where FBgItemCombinID = ?"), (Object[])new Object[]{refMbgItemId});
                    if (rst.next()) {
                        re = true;
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    if (!re) continue;
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return re;
    }
}

