/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.ma.cal.CostingMethodConfigException;
import com.kingdee.eas.ma.cal.app.AbstractCostingMethodConfigControllerBean;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import com.kingdee.eas.ma.scmcommon.tools.Utils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class CostingMethodConfigControllerBean
extends AbstractCostingMethodConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.cal.app.CostingMethodConfigControllerBean");

    @Override
    protected void _sync(Context ctx, String currentOrgUnits) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        Object[] parameter = new Object[]{this.getUserID(ctx), currentOrgUnits, currentOrgUnits, currentOrgUnits};
        sql.append(" insert into T_CAL_CostingMethodConfig (fid,FAccountType, ");
        sql.append(" FProfitCenterOrgUnitID,FMaterialGroupID,FMaterialGroupStandardID, ");
        sql.append(" FStatus,FCreatorID,FCreateTime,FControlUnitID) ");
        sql.append(" (select newbosid('A4F86EB6') as fid,3 as FAccountType, ");
        sql.append(" org.fid as FProfitCenterOrgUnitID,materialg.fid as FMaterialGroupID, ");
        sql.append(" materialg.FGroupStandard as FMaterialGroupStandardID,0 as FStatus, ");
        sql.append(" ? as FCreatorID, ");
        sql.append(" now() as FCreateTime,? as FControlUnitID");
        sql.append(" from T_ORG_ProfitCenter as org ");
        sql.append(" inner join T_BD_MaterialGroup as materialg ");
        sql.append(" on 1=1 ");
        sql.append(" left join T_CAL_CostingMethodConfig as cost ");
        sql.append(" on cost.FProfitCenterOrgUnitID = org.fid ");
        sql.append(" and cost.FMaterialGroupID = materialg.fid ");
        sql.append(" where ((cost.FProfitCenterOrgUnitID is null or cost.FMaterialGroupID is null) ");
        sql.append(" and org.FControlUnitID = ? and materialg.FControlUnitID in ");
        sql.append(" (select org.FID from T_ORG_CTRLUNIT as org where  ");
        sql.append(" charindex('!'||org.FNumber||'!','!'||(select FLongNumber from T_ORG_CTRLUNIT where FID =?)||'!')>0)");
        sql.append(" and org.FIsBizUnit = 1))");
        SQLUtils.execute((Context)ctx, (String)sql.toString(), (Object[])parameter);
    }

    @Override
    protected void _updateAccountType(Context ctx, int AccountTypeValue, String filterItems, String queryPK) throws BOSException, EASBizException {
        filterItems = this.structureFilter(ctx, filterItems, queryPK);
        StringBuffer sql = new StringBuffer();
        Object[] parameter = new Object[]{AccountTypeValue, this.getUserID(ctx)};
        sql.append(" update T_CAL_CostingMethodConfig ");
        sql.append(" set FAccountType =?,FLastUpdateTime = now(), ");
        sql.append(" FLastUpdateUserID = ? ");
        sql.append(" where FID in (").append(filterItems).append(") and FStatus = 0 ");
        SQLUtils.execute((Context)ctx, (String)sql.toString(), (Object[])parameter);
    }

    @Override
    protected void _updateMaterialDemension(Context ctx, String materialDemension, String filterItems, String queryPK) throws BOSException, EASBizException {
        filterItems = this.structureFilter(ctx, filterItems, queryPK);
        StringBuffer sql = new StringBuffer();
        Object[] parameter = new Object[]{materialDemension == null ? "" : materialDemension, this.getUserID(ctx)};
        sql.append(" update T_CAL_CostingMethodConfig ");
        sql.append(" set FMaterialDemension = ?,");
        sql.append(" FLastUpdateTime = now(), ");
        sql.append(" FLastUpdateUserID = ? ");
        sql.append(" where FID in (").append(filterItems).append(") and FStatus = 0 ");
        SQLUtils.execute((Context)ctx, (String)sql.toString(), (Object[])parameter);
    }

    @Override
    protected void _save(Context ctx, Map map) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        Object[] parameter = new Object[]{Integer.parseInt(map.get("accountType").toString()), map.get("materialDemension") == null ? "" : map.get("materialDemension"), this.getUserID(ctx), map.get("id")};
        sql.append(" update T_CAL_CostingMethodConfig ");
        sql.append(" set FAccountType = ?,");
        sql.append(" FMaterialDemension = ?,");
        sql.append(" FLastUpdateTime = now(), ");
        sql.append(" FLastUpdateUserID = ? ");
        sql.append(" where FID = ? ");
        SQLUtils.execute((Context)ctx, (String)sql.toString(), (Object[])parameter);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchDelete(ctx, Utils.buildBatchParam((Context)ctx, (IObjectPK)pk));
    }

    @Override
    protected void _enable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchEnable(ctx, Utils.buildBatchParam((Context)ctx, (IObjectPK)pk));
    }

    @Override
    protected void _disable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchActionResults result = this.batchDisable(ctx, Utils.buildBatchParam((Context)ctx, (IObjectPK)pk));
    }

    public BatchActionResults batchEnable(Context ctx, BatchExecuteParamsEntry[] params) throws BOSException, EASBizException {
        String pks = this.structurePKCol(params);
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_CAL_CostingMethodConfig where FStatus = 1 and fid in").append(pks);
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        BatchActionResults actionResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])params);
        try {
            while (rs.next()) {
                actionResults.addError(rs.getString("fid"), new CostingMethodConfigException(CostingMethodConfigException.CANNOTENABLE).getMessage());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        Object[] parameter = new Object[]{this.getUserID(ctx)};
        sql.append(" update T_CAL_CostingMethodConfig ");
        sql.append(" set FStatus = 1, ");
        sql.append(" FLastUpdateTime = now(), ");
        sql.append(" FLastUpdateUserID = ? ");
        sql.append(" where FID in ").append(pks);
        SQLUtils.execute((Context)ctx, (String)sql.toString(), (Object[])parameter);
        return actionResults;
    }

    public BatchActionResults batchDisable(Context ctx, BatchExecuteParamsEntry[] params) throws BOSException, EASBizException {
        String pks = this.structurePKCol(params);
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_CAL_CostingMethodConfig where FStatus = 0 and fid in").append(pks);
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        BatchActionResults actionResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])params);
        try {
            while (rs.next()) {
                actionResults.addError(rs.getString("fid"), new CostingMethodConfigException(CostingMethodConfigException.CANNOTDISABLE).getMessage());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        Object[] parameter = new Object[]{this.getUserID(ctx)};
        sql.append(" update T_CAL_CostingMethodConfig ");
        sql.append(" set FStatus = 0, ");
        sql.append(" FLastUpdateTime = now(), ");
        sql.append(" FLastUpdateUserID = ? ");
        sql.append(" where FID in ").append(pks);
        SQLUtils.execute((Context)ctx, (String)sql.toString(), (Object[])parameter);
        return actionResults;
    }

    public BatchActionResults batchDelete(Context ctx, BatchExecuteParamsEntry[] params) throws BOSException, EASBizException {
        String pks = this.structurePKCol(params);
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_CAL_CostingMethodConfig where FStatus = 1 and fid in").append(pks);
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        BatchActionResults actionResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])params);
        try {
            while (rs.next()) {
                actionResults.addError(rs.getString("fid"), new CostingMethodConfigException(CostingMethodConfigException.CANNOTDELETE).getMessage());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append(" delete from T_CAL_CostingMethodConfig ");
        sql.append(" where FID in ").append(pks);
        sql.append(" and FStatus = 0 ");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        return actionResults;
    }

    private String structurePKCol(BatchExecuteParamsEntry[] params) {
        StringBuffer pks = new StringBuffer();
        int size = params.length;
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                pks.append("('").append(params[i].get(0)).append("'");
                continue;
            }
            pks.append(",'").append(params[i].get(0)).append("'");
        }
        pks.append(")");
        return pks.toString();
    }

    private String structureFilter(Context ctx, String filterItems, String queryPK) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(queryPK));
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        if (filterItems != null && filterItems.length() > 0) {
            try {
                view.setFilter(new FilterInfo(filterItems));
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        exec.setObjectView(view);
        String sql = exec.getSQL();
        return sql;
    }

    private String getUserID(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo.getId().toString();
        return userId;
    }
}

