/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.cal.app.AbstractDispatchSummaryFacadeControllerBean;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DispatchSummaryFacadeControllerBean
extends AbstractDispatchSummaryFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.cal.app.DispatchSummaryFacadeControllerBean");

    @Override
    protected Map _query(Context ctx, Map condition) throws BOSException, EASBizException {
        String queryId = (String)condition.get("queryid");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("page", 0);
        map.put("total", 0);
        map.put("records", 0);
        map.put("rows", new ArrayList());
        try {
            int records = this.getRecords(ctx, condition);
            if (records <= 0) {
                return map;
            }
            int page = Integer.parseInt(condition.get("page").toString());
            int rows = Integer.parseInt(condition.get("rows").toString());
            int total = records / rows;
            if (total * rows < records) {
                ++total;
            }
            int from = (page - 1) * rows;
            IRowSet rowSet = this.executeQuery(ctx, condition, from, rows);
            rowSet.toCollection();
            ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(rowSet.size());
            while (rowSet.next()) {
                Map<String, Object> row = this.wrapRow(condition, rowSet);
                if (row == null) continue;
                datas.add(row);
            }
            map.put("page", page);
            map.put("total", total);
            map.put("records", records);
            map.put("rows", datas);
            map.put("uuid", queryId);
            return map;
        }
        catch (SQLException e) {
            throw new BOSException();
        }
    }

    protected Map<String, Object> wrapRow(Map<String, Object> condition, IRowSet rowSet) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        String sumType = (String)condition.get("sumType");
        int materialGroupLevel = 0;
        if (condition.get("materialGroupLevel") != null) {
            materialGroupLevel = new BigDecimal(condition.get("materialGroupLevel").toString()).intValue();
        }
        row.put("profitCenterid", rowSet.getString("FprofitCenterID"));
        row.put("year", rowSet.getString("FYear"));
        row.put("period", rowSet.getString("FPeriod"));
        row.put("materialid", rowSet.getString("FMaterialID"));
        row.put("materialname", rowSet.getString("FMATERIALNAME"));
        row.put("materialnumber", rowSet.getString("FMaterialNumber"));
        row.put("materialmodel", rowSet.getString("FMaterialModel"));
        row.put("unit", rowSet.getString("FBASEUNITNAME"));
        row.put("sumTypeName", rowSet.getString("FSumTypeName"));
        row.put("beginqty", rowSet.getBigDecimal("FBEGINQTY"));
        row.put("beginprice", rowSet.getBigDecimal("FBEGINPrice"));
        row.put("beginamount", rowSet.getBigDecimal("FBEGINAMOUNT"));
        row.put("inQty", rowSet.getBigDecimal("FINQTY"));
        row.put("inUnitPrice", rowSet.getBigDecimal("FINprice"));
        row.put("inAmount", rowSet.getBigDecimal("FINAMOUNT"));
        row.put("outQty", rowSet.getBigDecimal("FOUTQTY"));
        row.put("outUnitPrice", rowSet.getBigDecimal("FOUTprice"));
        row.put("outAmount", rowSet.getBigDecimal("FOUTAMOUNT"));
        row.put("remainQty", rowSet.getBigDecimal("FREMAINQTY"));
        row.put("remainUnitPrice", rowSet.getBigDecimal("FREMAINPRICE"));
        row.put("remainAmount", rowSet.getBigDecimal("FREMAINAMOUNT"));
        if ("materialGroup".equals(sumType)) {
            for (int i = 1; i <= materialGroupLevel; ++i) {
                row.put("materialGroup" + i, rowSet.getString("FMATERIALGROUPNAME" + i));
            }
        }
        return row;
    }

    protected IRowSet executeQuery(Context ctx, Map<String, Object> condition, int from, int rows) throws EASBizException, BOSException {
        String queryId = (String)condition.get("queryid");
        String sumType = (String)condition.get("sumType");
        int materialGroupLevel = 0;
        if (condition.get("materialGroupLevel") != null) {
            materialGroupLevel = new BigDecimal(condition.get("materialGroupLevel").toString()).intValue();
        }
        int pricePrecision = 6;
        int qtyPrecision = 4;
        int amountPrecision = 2;
        if (condition.get("qtyPrecision") != null) {
            qtyPrecision = Integer.parseInt(condition.get("qtyPrecision").toString());
        }
        if (condition.get("pricePrecision") != null) {
            pricePrecision = Integer.parseInt(condition.get("pricePrecision").toString());
        }
        if (condition.get("amountPrecision") != null) {
            amountPrecision = Integer.parseInt(condition.get("amountPrecision").toString());
        }
        boolean onlyViewSumRow = false;
        if (condition.get("check_isOnlyTotal") != null) {
            onlyViewSumRow = Boolean.parseBoolean(condition.get("check_isOnlyTotal").toString());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FprofitCenterID,FYear,FPeriod,FMaterialID,FMATERIALNAME,FMaterialNumber,FMaterialModel,FBASEUNITNAME,");
        if ("materialGroup".equals(sumType)) {
            for (int i = 1; i <= materialGroupLevel; ++i) {
                sql.append("FMATERIALGROUPNAME" + i + " ,");
            }
        }
        sql.append("FSumTypeName,");
        sql.append("round(FBEGINQTY,").append(qtyPrecision).append(") as FBEGINQTY,");
        sql.append("round(FBEGINPrice,").append(pricePrecision).append(") as FBEGINPrice,");
        sql.append("round(FBEGINAMOUNT,").append(amountPrecision).append(") as FBEGINAMOUNT,");
        sql.append("round(FINQTY,").append(qtyPrecision).append(") as FINQTY,");
        sql.append("round(FINprice,").append(pricePrecision).append(") as FINprice,");
        sql.append("round(FINAMOUNT,").append(amountPrecision).append(") as FINAMOUNT,");
        sql.append("round(FOUTQTY,").append(qtyPrecision).append(") as FOUTQTY ,");
        sql.append("round(FOUTprice,").append(pricePrecision).append(") as FOUTprice,");
        sql.append("round(FOUTAMOUNT,").append(amountPrecision).append(") as FOUTAMOUNT,");
        sql.append("round(FREMAINQTY,").append(qtyPrecision).append(") as FREMAINQTY,");
        sql.append("round(FREMAINPRICE,").append(pricePrecision).append(") as FREMAINPRICE,");
        sql.append("round(FREMAINAMOUNT,").append(amountPrecision).append(") as FREMAINAMOUNT  ");
        sql.append(" from ").append(queryId);
        if (onlyViewSumRow) {
            sql.append(" Where Findex<>0 ");
        }
        String SumTypeFieldName = null;
        if (sumType != null) {
            SumTypeFieldName = sumType;
            if ("materialGroup".equals(sumType)) {
                sql.append(" Order By isnull(FYear,2099) ,isnull(FPeriod,99)");
                for (int i = 1; i <= materialGroupLevel; ++i) {
                    sql.append(",FMATERIALGROUPID" + i + ",FMATERIALGROUPNAME" + i);
                }
                sql.append(",FIndex,FMaterialNumber");
            } else {
                sql.append(" Order By isnull(FYear,2099) ,isnull(FPeriod,99),FIndex,FMaterialNumber");
            }
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (int)from, (int)rows);
        return rs;
    }

    protected int getRecords(Context ctx, Map<String, Object> condition) throws EASBizException, BOSException, SQLException {
        boolean onlyViewSumRow = false;
        if (condition.get("check_isOnlyTotal") != null) {
            onlyViewSumRow = Boolean.parseBoolean(condition.get("check_isOnlyTotal").toString());
        }
        String queryId = (String)condition.get("queryid");
        String countSql = "select count(1) as count from " + queryId;
        if (onlyViewSumRow) {
            countSql = countSql + " Where Findex<>0 ";
        }
        IRowSet rsCount = SQLUtils.executeQuery((Context)ctx, (String)countSql);
        rsCount.next();
        int count = rsCount.getInt("count");
        return count;
    }

    private String getfilterids(Map params, String key) {
        if (params.get(key) != null && ((List)params.get(key)).size() > 0) {
            StringBuffer ids = new StringBuffer();
            List list = (List)params.get(key);
            Map map = null;
            ids.append(" '");
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                map = (Map)list.get(i);
                ids.append(map.get("id").toString()).append("','");
            }
            ids.append("'");
            return ids.toString();
        }
        return null;
    }

    @Override
    protected String _createTable(Context ctx, Map params) throws BOSException, EASBizException {
        String profitCenterid = null;
        if (params.get("uuid") != null) {
            String uuid = params.get("uuid").toString();
            this.releaseTable(ctx, uuid);
        }
        if (params.get("f7_profitCenter") != null) {
            profitCenterid = ((Map)params.get("f7_profitCenter")).get("id").toString();
        }
        String sumTypeFieldName = null;
        if (params.get("sumType") != null) {
            sumTypeFieldName = params.get("sumType").toString();
        }
        int materialGroupLevel = 1;
        if (params.get("materialGroupLevel") != null) {
            materialGroupLevel = new BigDecimal(params.get("materialGroupLevel").toString()).intValue();
        }
        String tmpTable = this.createTmpTable(ctx, sumTypeFieldName, materialGroupLevel);
        String storageOrgUnitid = null;
        if (params.get("f7_storageOrgUnit") != null) {
            Map map = (Map)params.get("f7_storageOrgUnit");
            storageOrgUnitid = map.get("id").toString();
        }
        String warehouse = this.getfilterids(params, "f7_warehouse");
        String material = this.getfilterids(params, "f7_material");
        int beginPeriod = Integer.parseInt(params.get("combo_periodFrom").toString());
        int beginYear = beginPeriod / 100;
        int beginPeriodNumber = beginPeriod % 100;
        int endPeriod = Integer.parseInt(params.get("combo_periodTo").toString());
        int endYear = endPeriod / 100;
        int endPeriodNumber = endPeriod % 100;
        int system = 1007;
        PeriodInfo currentPeriodInfo = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getProfitCurrentPeriod(system, profitCenterid);
        params.put("currPeriod", currentPeriodInfo);
        int currentPeriod = currentPeriodInfo.getPeriodYear() * 100 + currentPeriodInfo.getPeriodNumber();
        PeriodInfo nextPeriodInfo = null;
        nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriodInfo);
        int nextPeriod = -1;
        if (nextPeriodInfo != null) {
            nextPeriod = nextPeriodInfo.getPeriodYear() * 100 + nextPeriodInfo.getPeriodNumber();
        }
        String amountBalanceSql = null;
        String billSql = null;
        Object[] sqlparams = null;
        if (beginPeriod <= currentPeriod) {
            amountBalanceSql = this.getAmountBalanceSql(storageOrgUnitid, warehouse, material);
        }
        if (currentPeriod <= endPeriod) {
            billSql = this.getBillSql(storageOrgUnitid, warehouse, material);
        }
        String insertsql = this.getInsertTableSql(ctx, tmpTable, amountBalanceSql, billSql);
        sqlparams = billSql == null ? new Object[]{profitCenterid, beginPeriod, endPeriod} : (amountBalanceSql == null ? new Object[]{profitCenterid, beginPeriod, endPeriod} : new Object[]{profitCenterid, beginPeriod, currentPeriod, profitCenterid, currentPeriod, endPeriod});
        SQLUtils.execute((Context)ctx, (String)insertsql, (Object[])sqlparams);
        this.updatePeriodLast(ctx, tmpTable, currentPeriodInfo.getPeriodYear(), currentPeriodInfo.getPeriodNumber());
        String sql = this.getPeriodHappenTotal(ctx, tmpTable);
        SQLUtils.execute((Context)ctx, (String)sql);
        sql = this.getPeriodTotal(ctx, tmpTable);
        SQLUtils.execute((Context)ctx, (String)sql);
        try {
            this.getYearTotal(ctx, tmpTable, beginYear, beginPeriodNumber, endYear, endPeriod);
            this.getAllTotal(ctx, tmpTable, beginYear, beginPeriodNumber, sumTypeFieldName);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.materialGroup(ctx, tmpTable, sumTypeFieldName, materialGroupLevel);
        StringBuffer updatesql = new StringBuffer();
        updatesql.append(" update ").append(tmpTable).append(" set FYear = null  where fyear = 0 ");
        SQLUtils.execute((Context)ctx, (String)updatesql.toString());
        updatesql.setLength(0);
        updatesql.append(" update ").append(tmpTable).append(" set FPeriod = null  where FPeriod = 0 ");
        SQLUtils.execute((Context)ctx, (String)updatesql.toString());
        updatesql.setLength(0);
        updatesql.append(" update ").append(tmpTable).append(" set FSumTypeName = null  where findex = 0 ");
        SQLUtils.execute((Context)ctx, (String)updatesql.toString());
        updatesql.setLength(0);
        updatesql.append("Update " + tmpTable + " Set ");
        updatesql.append(" FREMAINPRICE =  (round(to_decimal(FREMAINAMOUNT/FREMAINQTY, 21, 8),FPricePrecision)) ");
        updatesql.append(" Where  FREMAINQTY  <>  0 ");
        SQLUtils.execute((Context)ctx, (String)updatesql.toString());
        updatesql.setLength(0);
        updatesql.append("Update " + tmpTable + " Set ");
        updatesql.append(" FINprice =  (round(to_decimal(FINAMOUNT/FINQTY, 21, 8),FPricePrecision)) ");
        updatesql.append(" Where  FINQTY  <>  0 ");
        SQLUtils.execute((Context)ctx, (String)updatesql.toString());
        updatesql.setLength(0);
        updatesql.append("Update " + tmpTable + " Set ");
        updatesql.append(" FOUTprice =  (round(to_decimal(FOUTAMOUNT/FOUTQTY, 21, 8),FPricePrecision)) ");
        updatesql.append(" Where  FOUTQTY  <>  0 ");
        SQLUtils.execute((Context)ctx, (String)updatesql.toString());
        updatesql.append("Update " + tmpTable + " Set ");
        updatesql.append(" FBEGINPrice =  (round(to_decimal(FBEGINAMOUNT/FBEGINQTY, 21, 8),FPricePrecision)) ");
        updatesql.append(" Where  FBEGINQTY  <>  0 ");
        SQLUtils.execute((Context)ctx, (String)updatesql.toString());
        return tmpTable;
    }

    private void materialGroup(Context ctx, String tempTable, String SumTypeFieldName, int materialGroupLevel) throws BOSException {
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String sql = null;
        if ("materialGroup".equals(SumTypeFieldName)) {
            sql = "update " + tempTable + " as  t2 set FSUMTYPEID=";
            sql = sql + "(select t3.flongnumber from t_bd_material t1,t_bd_materialgroup t3 where  t2.fmaterialid=t1.fid and t3.fid=t1.fmaterialgroupid and t3.fgroupstandard = 'dR8lnQEPEADgAAWKwKgSxZeb4R8=') where findex=0";
            SQLUtils.execute((Context)ctx, (String)sql);
            sql = "update " + tempTable + " as  t2 set FMATERIALGROUPID1=";
            sql = sql + "(select CASE CHARINDEX('!', t3.flongnumber) WHEN 0 THEN t3.flongnumber ELSE LEFT(t3.flongnumber,CHARINDEX('!', t3.flongnumber)-1) END from t_bd_material t1,t_bd_materialgroup t3 where  t2.fmaterialid=t1.fid and t3.fid=t1.fmaterialgroupid and t3.fgroupstandard = 'dR8lnQEPEADgAAWKwKgSxZeb4R8=') ";
            SQLUtils.execute((Context)ctx, (String)sql);
            sql = "update " + tempTable + " as  t1 set FMATERIALGROUPNAME1=";
            sql = sql + "(select t2.fname_" + loc + " from t_bd_materialgroup t2 ,t_bd_material t10  where t10.fid = t1.fmaterialid  and t1.FMATERIALGROUPID1=t2.flongnumber  and t2.fgroupstandard = 'dR8lnQEPEADgAAWKwKgSxZeb4R8=' )  ";
            SQLUtils.execute((Context)ctx, (String)sql);
            for (int i = 2; i <= materialGroupLevel; ++i) {
                sql = "update " + tempTable + " set FMATERIALGROUPID" + i + "=CASE LENGTH(FSUMTYPEID)-LENGTH(FMATERIALGROUPID" + (i - 1) + "||'') when 0 then '' when -1 then '' else SUBSTRING(FSUMTYPEID,length(FMATERIALGROUPID" + (i - 1) + ")+2,length(FSUMTYPEID)-length(FMATERIALGROUPID" + (i - 1) + ")) END";
                SQLUtils.execute((Context)ctx, (String)sql);
                sql = "update " + tempTable + " set FMATERIALGROUPID" + i + "=CASE CHARINDEX('!', FMATERIALGROUPID" + i + " ) WHEN 0 THEN FMATERIALGROUPID" + i + "  ELSE LEFT(FMATERIALGROUPID" + i + " ,CHARINDEX('!',FMATERIALGROUPID" + i + " )-1) END";
                SQLUtils.execute((Context)ctx, (String)sql);
                sql = "update " + tempTable + " set FMATERIALGROUPID" + i + "=case  FMATERIALGROUPID" + i + " WHEN '' then '' else FMATERIALGROUPID" + (i - 1) + "||'!'||FMATERIALGROUPID" + i + " END";
                SQLUtils.execute((Context)ctx, (String)sql);
                sql = "update " + tempTable + " as  t1 set FMATERIALGROUPNAME" + i;
                sql = sql + "=(select t2.fname_" + loc + " from t_bd_materialgroup t2 where t1.FMATERIALGROUPID" + i + "=t2.flongnumber and t2.fgroupstandard = 'dR8lnQEPEADgAAWKwKgSxZeb4R8=' ) ";
                SQLUtils.execute((Context)ctx, (String)sql);
            }
            sql = "delete from " + tempTable + " where findex=1";
            SQLUtils.execute((Context)ctx, (String)sql);
            sql = "update  " + tempTable + " set FMATERIALGROUPNAME1=FSUMTYPEID where findex<>0";
            SQLUtils.execute((Context)ctx, (String)sql);
            StringBuffer sqlbuff = new StringBuffer();
            for (int i = 1; i <= materialGroupLevel; ++i) {
                int j;
                sqlbuff.setLength(0);
                sqlbuff.append("Insert Into " + tempTable + "(FINDEX,FprofitCenterID,FYear,FPeriod,FMaterialID ,FMATERIALNAME ,FMaterialNumber ,FMaterialModel,FBASEUNITNAME,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT   ,FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT");
                for (j = 1; j <= i; ++j) {
                    sqlbuff.append(",FMATERIALGROUPID" + j + ",FMATERIALGROUPNAME" + j);
                }
                sqlbuff.append(")\r\n");
                sqlbuff.append(" Select 0.5 as FIndex,FprofitCenterID as FprofitCenterID,\r\n");
                sqlbuff.append("FYear,FPeriod,\r\n");
                sqlbuff.append("null as FMaterialID,null as FMaterialName,\r\n");
                sqlbuff.append("null as FMaterialNumber,null as FMaterialModel,");
                sqlbuff.append("null as FBaseUnitName,\r\n");
                sqlbuff.append("'' FSumTypeName,\r\n");
                sqlbuff.append("sum(FBeginQty) as FBeginQty,sum(FBeginAmount) as FBeginAmount,\r\n");
                sqlbuff.append("sum(FInQty) as FInQty,Sum(FInAmount)as FInAmount,\r\n");
                sqlbuff.append("Sum(FOutQty) as FOutQty,Sum(FOutAmount) as FOutAmount,\r\n");
                sqlbuff.append("sum(FRemainQty) as FRemainQty,sum(FRemainAmount) as FRemainAmount \r\n");
                for (j = 1; j <= i; ++j) {
                    sqlbuff.append(",FMATERIALGROUPID" + j + ",FMATERIALGROUPNAME" + j);
                }
                sqlbuff.append("||'").append("\u5408\u8ba1");
                sqlbuff.append("' From " + tempTable + "\r\n");
                sqlbuff.append("Where FIndex=0 \r\n");
                sqlbuff.append(" and length(FMATERIALGROUPNAME").append(i).append(")>0 ");
                sqlbuff.append("Group By FprofitCenterID,FYear,FPeriod \r\n");
                for (j = 1; j <= i; ++j) {
                    sqlbuff.append(",FMATERIALGROUPID" + j + ",FMATERIALGROUPNAME" + j);
                }
                SQLUtils.execute((Context)ctx, (String)sqlbuff.toString());
            }
        }
    }

    private void getYearTotal(Context ctx, String tempTable, int beginYear, int beginPeriod, int endYear, int endPeroid) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        StringBuffer checkSql = new StringBuffer();
        checkSql.append("Select top 1 * \r\n");
        checkSql.append("From " + tempTable + "\r\n");
        checkSql.append("Where FIndex=2 And FYear=" + String.valueOf(beginYear) + " And FPeriod=" + String.valueOf(beginPeriod) + "\r\n");
        IRowSet rsCount = SQLUtils.executeQuery((Context)ctx, (String)checkSql.toString());
        if (rsCount.next()) {
            sql.append("Insert Into " + tempTable + " (FINDEX,FprofitCenterID,FYear,FPeriod,FMaterialID ,FMATERIALNAME, \r\n");
            sql.append(" FMaterialNumber,FMaterialModel,FBASEUNITNAME,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT, \r\n");
            sql.append(" FINQTY,FINAMOUNT,FOUTQTY ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT ) \r\n");
            sql.append("Select 3 as FIndex,' ' as FprofitCenterID,\r\n");
            sql.append("FYear, 0 as FPeriod, \r\n");
            sql.append("null as FMaterialID,null as FMaterialName, \r\n");
            sql.append("null as FMaterialNumber,null as FMaterialModel,");
            sql.append("null as FBaseUnitName, \r\n");
            sql.append("'\u672c\u5e74\u5408\u8ba1' FSumTypeName,\r\n");
            sql.append("FBeginQty,FBeginAmount,\r\n");
            sql.append("0 as FInQty,0 as FInAmount,\r\n");
            sql.append("0 as FOutQty,0 as FOutAmount,\r\n");
            sql.append("0 as FRemainQty,0 as FRemainAmount \r\n");
            sql.append("From " + tempTable + "\r\n");
            sql.append("Where FIndex=2 And FYear=" + String.valueOf(beginYear) + " And FPeriod=" + String.valueOf(beginPeriod) + "\r\n");
            SQLUtils.execute((Context)ctx, (String)sql.toString());
        } else {
            sql.append("Insert Into " + tempTable + " (FINDEX,FprofitCenterID,FYear,FPeriod,FMaterialID ,FMATERIALNAME, \r\n");
            sql.append(" FMaterialNumber,FMaterialModel,FBASEUNITNAME,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT, \r\n");
            sql.append(" FINQTY,FINAMOUNT,FOUTQTY ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT ) values ( \r\n");
            sql.append(" 3,' ', " + String.valueOf(beginYear) + ",0,\r\n");
            sql.append("null,null,null,null,null, \r\n");
            sql.append("'\u672c\u5e74\u5408\u8ba1',\r\n");
            sql.append("0,0,0,0,0,0,0,0) ");
            SQLUtils.execute((Context)ctx, (String)sql.toString());
        }
        if (endYear > beginYear) {
            sql = new StringBuffer();
            sql.append(" Insert Into " + tempTable + " (FINDEX,FprofitCenterID,FYear,FPeriod,FMaterialID ,FMATERIALNAME,");
            sql.append(" FMaterialNumber ,FMaterialModel,FBASEUNITNAME,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT ,");
            sql.append(" FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT)\r\n");
            sql.append(" Select top 1 3 as FIndex,' ' as FprofitCenterID,\r\n");
            sql.append(" FYear, 0 as FPeriod,\r\n");
            sql.append("null as FMaterialID,null as FMaterialName,\r\n");
            sql.append("null as FMaterialNumber,null as FMaterialModel,");
            sql.append("null as FBaseUnitName,\r\n");
            sql.append("'\u672c\u5e74\u5408\u8ba1' FSumTypeName,\r\n");
            sql.append("FBeginQty,FBeginAmount,\r\n");
            sql.append("0 as FInQty,0 as FInAmount,\r\n");
            sql.append("0 as FOutQty,0 as FOutAmount,\r\n");
            sql.append("0 as FRemainQty,0 as FRemainAmount \r\n");
            sql.append("From " + tempTable + "\r\n");
            sql.append("Where FIndex=2 And FYear>" + String.valueOf(beginYear) + "\r\n");
            SQLUtils.execute((Context)ctx, (String)sql.toString());
        }
        sql = new StringBuffer();
        sql.append("Update " + tempTable + " Set(FInQty,FInAmount,FOutQty,FOutAmount)=\r\n");
        sql.append(" (Select FInTotalQty,FInTotalAmount,FOutTotalQty,FOutTotalAmount From \r\n");
        sql.append(" (Select FYear as FYear, \r\n");
        sql.append(" Sum(T1.FInQty) as FInTotalQty ,Sum(T1.FInAmount) as FInTotalAmount,\r\n");
        sql.append(" Sum(T1.FOutQty) as FOutTotalQty,Sum(T1.FOutAmount) as\t FOutTotalAmount\r\n");
        sql.append(" From " + tempTable + " T1 \r\n");
        sql.append(" Where T1.FIndex=2 \r\n");
        sql.append(" Group By T1.FYear) as i \r\n");
        sql.append(" Where i.FYear = " + tempTable + ".FYear and " + tempTable + ".FIndex=3 )");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("Update " + tempTable + " Set ");
        sql.append("FRemainQty = isnull(FBeginQty,0)+isnull(FInQty,0)-isnull(FOutQty,0),");
        sql.append("FRemainAmount=isnull(FBeginAmount,0)+isnull(FInAmount,0)-isnull(FOutAmount,0) ");
        sql.append("Where FIndex=3  \r\n");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    private void getAllTotal(Context ctx, String tempTable, int beginYear, int beginPeriod, String SumTypeFieldName) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        StringBuffer checkSql = new StringBuffer();
        checkSql.append("Select top 1 * \r\n");
        checkSql.append("From " + tempTable + "\r\n");
        checkSql.append("Where FIndex=2 And FYear=" + String.valueOf(beginYear) + " And FPeriod=" + String.valueOf(beginPeriod) + "\r\n");
        IRowSet rsCount = SQLUtils.executeQuery((Context)ctx, (String)checkSql.toString());
        if (rsCount.next()) {
            sql.append("Insert Into " + tempTable + " (FINDEX,FprofitCenterID,FYear,FPeriod,FMaterialID ,FMATERIALNAME ,FMaterialNumber ,FMaterialModel,FBASEUNITNAME,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT   ,FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT)\r\n");
            sql.append("Select 4 as FIndex,' ' as FprofitCenterID, \r\n");
            sql.append("0 as FYear, 0 FPeriod,\r\n");
            sql.append("null as FMaterialID,null as FMaterialName,\r\n");
            sql.append("null as FMaterialNumber,null as FMaterialModel,");
            sql.append("null as FBaseUnitName,\r\n");
            sql.append("'\u603b\u8ba1' FSumTypeName,\r\n");
            sql.append("FBeginQty,FBeginAmount,\r\n");
            sql.append("0 as FInQty,0 as FInAmount,\r\n");
            sql.append("0 as FOutQty,0 as FOutAmount,\r\n");
            sql.append("0 as FRemainQty,0 as FRemainAmount \r\n");
            sql.append("From " + tempTable + "\r\n");
            sql.append("Where FIndex=2 And FYear=" + String.valueOf(beginYear) + " And FPeriod=" + String.valueOf(beginPeriod) + "\r\n");
            SQLUtils.execute((Context)ctx, (String)sql.toString());
        } else {
            sql.setLength(0);
            sql.append("Insert Into " + tempTable + " (FINDEX,FprofitCenterID,FYear,FPeriod,FMaterialID ,FMATERIALNAME ,FMaterialNumber ,");
            sql.append(" FMaterialModel,FBASEUNITNAME,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT ,");
            sql.append(" FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT) values \r\n");
            sql.append(" ( 4,' ',0,0,null,null,null,null,null, ");
            sql.append("'\u603b\u8ba1',\r\n");
            sql.append(" 0,0,0,0,0,0,0,0 ) ");
            SQLUtils.execute((Context)ctx, (String)sql.toString());
        }
        sql.setLength(0);
        sql.append("Update " + tempTable + " AS T3 Set(FInQty,FInAmount,FOutQty,FOutAmount)=\r\n");
        sql.append("    (Select FInTotalQty,FInTotalAmount,FOutTotalQty,FOutTotalAmount From \r\n");
        sql.append("       (Select Sum(T1.FInQty) as FInTotalQty ,Sum(T1.FInAmount) as FInTotalAmount, \r\n");
        sql.append("       Sum(T1.FOutQty) as FOutTotalQty,Sum(T1.FOutAmount) as FOutTotalAmount \r\n");
        sql.append("        From " + tempTable + " T1 \r\n");
        sql.append("        Where T1.FIndex=3 )\r\n");
        sql.append("    i," + tempTable + " T2 \r\n");
        sql.append("    Where T2.FIndex=4) Where T3.FIndex=4\r\n");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("Update " + tempTable + " Set ");
        sql.append("FRemainQty=isnull(FBeginQty,0)+isnull(FInQty,0)-isnull(FOutQty,0),");
        sql.append("FRemainAmount=isnull(FBeginAmount,0)+isnull(FInAmount,0)-isnull(FOutAmount,0) ");
        sql.append("Where FIndex=4 ");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    private String getPeriodHappenTotal(Context ctx, String tempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tempTable + "(FINDEX,FprofitCenterID,FYear,FPeriod,FMaterialID ,");
        sql.append(" FMATERIALNAME ,FMaterialNumber ,FMaterialModel,FBASEUNITNAME,FSUMTYPENAME,");
        sql.append(" FBEGINQTY ,FBEGINAMOUNT   ,FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT) \r\n");
        sql.append("Select 1,null,FYear,FPeriod,null,null,null,null,null,FSumTypeName || '\u5c0f\u8ba1',");
        sql.append("sum(FBeginQty),sum(FBeginAmount),sum(FInQty),sum(FInAmount),sum(FOutQty),sum(FOutAmount),sum(FRemainQty),Sum(FRemainAmount) ");
        sql.append("From " + tempTable + " \r\n");
        sql.append("Group By FYear,FPeriod,FSumTypeName");
        return sql.toString();
    }

    private String getPeriodTotal(Context ctx, String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tempTable + "(FINDEX,FprofitCenterID,FYear,FPeriod,");
        sql.append(" FMaterialID ,FMATERIALNAME ,FMaterialNumber ,FMaterialModel,FBASEUNITNAME,");
        sql.append(" FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT   ,FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT)\r\n");
        sql.append(" Select 2 as FIndex,' ' as FCompanyOrgUnitID,\r\n");
        sql.append("FYear,FPeriod,\r\n");
        sql.append("null as FMaterialID,null as FMaterialName,\r\n");
        sql.append("null as FMaterialNumber,null as FMaterialModel,");
        sql.append("null as FBaseUnitName,\r\n");
        sql.append("'\u672c\u671f\u5408\u8ba1' FSumTypeName,\r\n");
        sql.append("sum(FBeginQty) as FBeginQty,sum(FBeginAmount) as FBeginAmount,\r\n");
        sql.append("sum(FInQty) as FInQty,Sum(FInAmount)as FInAmount,\r\n");
        sql.append("Sum(FOutQty) as FOutQty,Sum(FOutAmount) as FOutAmount,\r\n");
        sql.append("sum(FRemainQty) as FRemainQty,sum(FRemainAmount) as FRemainAmount \r\n");
        sql.append("From " + tempTable + "\r\n");
        sql.append("Where FIndex=1 \r\n");
        sql.append("Group By FYear,FPeriod \r\n");
        return sql.toString();
    }

    private String updatePeriodLast(Context ctx, String tempTable, int pYear, int pMonth) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + tempTable + " Set FRemainQty=Isnull(FBeginQty,0)+Isnull(FInQty,0)-Isnull(FOutQty,0),");
        sql.append("FRemainAmount=Isnull(FBeginAmount,0)+Isnull(FInAmount,0)-Isnull(FOutAmount,0) \r\n");
        sql.append(" Where FYear=" + String.valueOf(pYear) + " And FPeriod=" + String.valueOf(pMonth) + "\r\n");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("Update " + tempTable + " Set ");
        sql.append(" FREMAINPRICE =  round(to_decimal(FREMAINAMOUNT/FREMAINQTY, 21, 8),8) ");
        sql.append(" Where  FREMAINQTY  <>  0 and FYear=" + String.valueOf(pYear) + " And FPeriod=" + String.valueOf(pMonth) + "\r\n");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        return sql.toString();
    }

    private String getInsertTableSql(Context ctx, String tmpTable, String amountBalanceSql, String billSql) {
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" insert ").append(tmpTable);
        sql.append(" ( FINDEX,FprofitCenterID,FYear,FPeriod,FMaterialID,FMATERIALNAME,");
        sql.append(" FMaterialNumber,FMaterialModel,FBASEUNITNAME,");
        sql.append(" FBEGINQTY,FBEGINPrice,FBEGINAMOUNT,FINQTY,FINprice,FINAMOUNT,");
        sql.append(" FOUTQTY,FOUTprice,FOUTAMOUNT,FREMAINQTY,FREMAINPRICE,FREMAINAMOUNT,FPricePrecision ) \r\n ");
        sql.append("( select 0,t.FProfitCenterID,t.FYear,t.FPeriod,t.FMaterialID,m.FNAME_").append(loc).append(",");
        sql.append(" m.FNumber,m.FModel,unit.fname_").append(loc).append(",sum(t.FBEGINQTY),");
        sql.append(" (case when sum(t.FBEGINQTY)= 0 then 0 else round(to_decimal(sum(t.FBEGINAMOUNT)/sum(t.FBEGINQTY), 21, 8),8) end ) as FBEGINPrice,");
        sql.append(" sum(t.FBEGINAMOUNT), sum(t.FINQTY), ");
        sql.append(" (case when sum(t.FINQTY)= 0 then 0 else round(to_decimal(sum(t.FINAMOUNT)/sum(t.FINQTY), 21, 8),8) end ) as FINprice,");
        sql.append(" sum(t.FINAMOUNT), sum(t.FOUTQTY),");
        sql.append(" (case when sum(t.FOUTQTY)= 0 then 0 else round(to_decimal(sum(t.FOUTAMOUNT)/sum(t.FOUTQTY), 21, 8),8) end ) as FOUTprice,");
        sql.append(" sum(t.FOUTAMOUNT),sum(t.FREMAINQTY),");
        sql.append(" (case when sum(t.FREMAINQTY)= 0 then 0 else round(to_decimal(sum(t.FREMAINAMOUNT)/sum(t.FREMAINQTY), 21, 8),8) end ) as FREMAINPRICE,");
        sql.append(" sum(t.FREMAINAMOUNT),");
        sql.append(" MAX(m.FPricePrecision) as FPricePrecision");
        sql.append(" from (");
        if (amountBalanceSql == null) {
            sql.append(billSql).append(" ) as t \r\n ");
        } else if (billSql == null) {
            sql.append(amountBalanceSql).append(" ) as t \r\n ");
        } else {
            sql.append(amountBalanceSql).append("\r\n UNION ALL \r\n ").append(billSql).append(" ) as t \r\n ");
        }
        sql.append(" inner join t_bd_material as m on m.fid = t.FMaterialID \r\n ");
        sql.append(" inner join T_BD_MEASUREUNIT as unit on unit.fid = t.FBaseUnitID \r\n ");
        sql.append(" group by t.FProfitCenterID,t.FYear,t.FPeriod,t.FMaterialID,m.FNAME_").append(loc).append(",");
        sql.append(" m.fnumber,m.FModel,unit.fname_").append(loc).append(" )");
        return sql.toString();
    }

    private String getAmountBalanceSql(String storageOrgUnitid, String warehouse, String material) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select inv.FProfitCenterID,inv.FYear,inv.FPeriod,inv.FMaterialID,m.FBaseUnit as FBaseUnitID ,");
        sql.append(" inv.FPeriodBeginQty as FBEGINQTY ,inv.FPeriodBeginBalance as FBEGINAMOUNT,inv.FPeriodReceiptQty as FINQTY,inv.FPeriodReceiptAmount as FINAMOUNT,");
        sql.append(" inv.FPeriodIssueQty as FOUTQTY,inv.FPeriodIssueAmount as FOUTAMOUNT ,inv.FPeriodEndQty as FREMAINQTY ,inv.FPeriodEndBalance as FREMAINAMOUNT ");
        sql.append(" from T_CAL_InventoryBalance inv");
        sql.append(" inner join t_bd_material m on m.fid = inv.FMaterialID");
        sql.append(" where FProfitCenterID = ? ");
        sql.append(" and fyear * 100 + fperiod >= ? and fyear * 100 + fperiod <= ? ");
        if (storageOrgUnitid != null) {
            sql.append(" and FStorageOrgUnitID = '").append(storageOrgUnitid).append("'");
        }
        if (warehouse != null) {
            sql.append(" and FWarehouseID in (").append(warehouse).append(")");
        }
        if (material != null) {
            sql.append(" and FMaterialID in (").append(material).append(")");
        }
        return sql.toString();
    }

    private String getBillSql(String storageOrgUnitid, String warehouse, String material) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select bill.FProfitCenterID,period.FPeriodYear as FYear, period.fperiodNumber as FPeriod,bill.FMaterialID,bill.FBaseUnitID ,");
        sql.append(" 0 as FBEGINQTY ,0 as FBEGINAMOUNT,");
        sql.append(" (case  bill.FOutOrInWareHouse when 20 then bill.FBaseQty else 0 end )  as FINQTY,");
        sql.append(" (case  bill.FOutOrInWareHouse when 20 then bill.FCost else 0 end )  as FINAMOUNT, ");
        sql.append(" (case  bill.FOutOrInWareHouse when 10 then bill.FBaseQty else 0 end )  as FOUTQTY,");
        sql.append(" (case  bill.FOutOrInWareHouse when 10 then bill.FCost else 0 end )  as FOUTAMOUNT , ");
        sql.append(" 0 as FREMAINQTY ,0 as FREMAINAMOUNT ");
        sql.append(" from T_CAL_InvAccountBill as bill ");
        sql.append(" inner join T_BD_Period as period on period.fid = bill.FPeriodID ");
        sql.append(" where bill.FProfitCenterID = ? ");
        sql.append(" and period.FPeriodYear * 100 + period.fperiodNumber >= ?  ");
        sql.append(" and period.FPeriodYear * 100 + period.fperiodNumber <= ? ");
        if (storageOrgUnitid != null) {
            sql.append(" and bill.FStorageOrgUnitID = '").append(storageOrgUnitid).append("'");
        }
        if (warehouse != null) {
            sql.append(" and bill.FWarehouseID in (").append(warehouse).append(")");
        }
        if (material != null) {
            sql.append(" and bill.FMaterialID in (").append(material).append(")");
        }
        return sql.toString();
    }

    @Override
    protected void _releaseTable(Context ctx, String tmpName) throws BOSException, EASBizException {
        if (tmpName == null) {
            return;
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            pool.releaseTable(tmpName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String createTmpTable(Context ctx, String SumTypeFieldName, int materialGroupLevel) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TempReportTable \r\n");
        sql.append("( Fid int identity(1,1),");
        sql.append("FINDEX Int NOT NULL , \r\n");
        sql.append("FprofitCenterID Varchar(44), \r\n");
        sql.append("FYear int, \r\n");
        sql.append("FPeriod int, \r\n");
        sql.append("FMaterialID Varchar(44), \r\n");
        sql.append("FMATERIALNAME NVarchar(255),\r\n");
        sql.append("FMaterialNumber NVarchar(80),\r\n");
        sql.append("FMaterialModel NVarchar(300),\r\n");
        sql.append("FBASEUNITNAME NVarchar(255),\r\n");
        sql.append("FSUMTYPEID Varchar(44),\r\n");
        sql.append("FSUMTYPENAME Varchar(100),\r\n");
        if (SumTypeFieldName != null && SumTypeFieldName.equals("materialGroup")) {
            for (int i = 1; i <= materialGroupLevel; ++i) {
                sql.append("FMATERIALGROUPID" + i + " Varchar(100),\r\n");
                sql.append("FMATERIALGROUPNAME" + i + " NVarchar(100),\r\n");
            }
        }
        sql.append("FPricePrecision INT,\r\n");
        sql.append("FBEGINQTY NUMERIC(21, 8) ,\r\n");
        sql.append("FBEGINPrice NUMERIC(21, 8) ,\r\n");
        sql.append("FBEGINAMOUNT NUMERIC(17, 4)  ,\r\n");
        sql.append("FINQTY NUMERIC(21, 8) ,\r\n");
        sql.append("FINprice NUMERIC(21, 8) ,\r\n");
        sql.append("FINAMOUNT NUMERIC(17, 4)  ,\r\n");
        sql.append("FOUTQTY NUMERIC(21, 8) ,\r\n");
        sql.append("FOUTprice NUMERIC(21, 8) ,\r\n");
        sql.append("FOUTAMOUNT NUMERIC(17, 4)  ,\r\n");
        sql.append("FREMAINQTY NUMERIC(21, 8)  ,\r\n");
        sql.append("FREMAINPRICE NUMERIC(21, 8)  ,\r\n");
        sql.append("FREMAINAMOUNT NUMERIC(17, 4) );\r\n");
        String tempTable = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tempTable = pool.createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }
}

