/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IProfitCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHCollection;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.cal.InventoryBalanceCollection;
import com.kingdee.eas.ma.cal.InventoryBalanceException;
import com.kingdee.eas.ma.cal.InventoryBalanceInfo;
import com.kingdee.eas.ma.cal.app.AbstractInventoryBalanceControllerBean;
import com.kingdee.eas.ma.cal.app.utils.CalUtils;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import com.kingdee.eas.ma.scmcommon.tools.Utils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InventoryBalanceControllerBean
extends AbstractInventoryBalanceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.cal.app.InventoryBalanceControllerBean");
    private static int systemEnum = SystemEnum.PROFIT_CENTER_STORAGE.getValue();

    @Override
    protected void _batchUpdatePartial(Context ctx, InventoryBalanceCollection col, SelectorItemCollection sic) throws BOSException, EASBizException {
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            InventoryBalanceInfo info = col.get(i);
            this.changeInventoryBalanceInfo(ctx, info);
            super.updatePartial(ctx, (CoreBaseInfo)info, sic);
        }
    }

    private void changeInventoryBalanceInfo(Context ctx, InventoryBalanceInfo info) throws BOSException, EASBizException {
        ProfitCenterOrgUnitInfo profitCenterOrg = info.getProfitCenter();
        CtrlUnitInfo ctrlUnit = null;
        try {
            ctrlUnit = this.getCU(ctx, profitCenterOrg);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        info.setCU(ctrlUnit);
        if (info.getPeriodBeginBalance() == null) {
            info.setPeriodBeginBalance(new BigDecimal(0));
        }
        if (info.getPeriodBeginQty() == null) {
            info.setPeriodBeginQty(new BigDecimal(0));
        }
        if (info.getPeriodIssueAmount() == null) {
            info.setPeriodIssueAmount(new BigDecimal(0));
        }
        if (info.getPeriodIssueQty() == null) {
            info.setPeriodIssueQty(new BigDecimal(0));
        }
        if (info.getPeriodReceiptAmount() == null) {
            info.setPeriodReceiptAmount(new BigDecimal(0));
        }
        if (info.getPeriodReceiptQty() == null) {
            info.setPeriodReceiptQty(new BigDecimal(0));
        }
        if (info.getYearPeriodIssueQty() == null) {
            info.setYearPeriodIssueQty(new BigDecimal(0));
        }
        if (info.getYearPeriodReceiptAmount() == null) {
            info.setYearPeriodReceiptAmount(new BigDecimal(0));
        }
        if (info.getYearReceiptQty() == null) {
            info.setYearReceiptQty(new BigDecimal(0));
        }
    }

    @Override
    protected void _batchAddnew(Context ctx, InventoryBalanceCollection addCol) throws BOSException, EASBizException {
        int size = addCol.size();
        for (int i = 0; i < size; ++i) {
            InventoryBalanceInfo info = addCol.get(i);
            this.changeInventoryBalanceInfo(ctx, info);
            super.addnew(ctx, (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _batchDelete(Context ctx, List delList) throws BOSException, EASBizException {
        StringBuilder idSB = new StringBuilder();
        int size = delList.size();
        for (int i = 0; i < size; ++i) {
            if (idSB.length() <= 0) {
                idSB.append("'").append(delList.get(i)).append("'");
                continue;
            }
            idSB.append(",'").append(delList.get(i)).append("'");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("delete from t_cal_inventorybalance where fid in(").append(idSB.toString()).append(")");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _closeInit(Context ctx, String[] profitCenterIds) throws BOSException, EASBizException {
        String pks = this.getSqlIDs(profitCenterIds);
        if (StringUtils.isEmpty((String)pks)) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update t_Bd_Systemstatusctrol").append(" set FCurrentPeriodID = FStartPeriodID,").append(" FIsStart = 1").append(" where").append(" FProfitCenterID in (").append(pks).append(")").append(" and fsystemstatusid = (select top 1 fid from T_BD_SystemStatus where fname = '").append(systemEnum).append("')");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _cancelInit(Context ctx, String[] profitCenterIds) throws BOSException, EASBizException {
        String pks = this.getSqlIDs(profitCenterIds);
        if (StringUtils.isEmpty((String)pks)) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update t_Bd_Systemstatusctrol").append(" set ").append(" FIsStart = 0").append(" where").append(" FProfitCenterID in (").append(pks).append(")").append(" and fsystemstatusid = (select top 1 fid from T_BD_SystemStatus where fname = '").append(systemEnum).append("')");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    private String getSqlIDs(String[] pks) {
        StringBuilder sb = new StringBuilder();
        if (pks == null || "".equals(pks)) {
            return "";
        }
        for (String pk : pks) {
            if (pk == null) continue;
            if (sb.length() > 0) {
                sb.append(",'").append(pk).append("'");
                continue;
            }
            sb.append("'").append(pk).append("'");
        }
        return sb.toString();
    }

    @Override
    protected Map _getMaterialMmuPrecisions(Context ctx, List ids) throws BOSException, EASBizException {
        return Utils.getMaterialMmuPrecisions((Context)ctx, (List)ids);
    }

    private String getFieldUniqueHasCode(InventoryBalanceCollection col, Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < col.size(); ++i) {
            InventoryBalanceInfo info = col.get(i);
            sb.delete(0, sb.length());
            if (info.getCU() != null && info.getCU().getId() != null) {
                sb.append(info.getCU().getId().toString());
            }
            if (info.getCompanyOrgUnit() != null && info.getCompanyOrgUnit().getId() != null) {
                sb.append(info.getCompanyOrgUnit().getId().toString());
            }
            if (info.getProfitCenter() != null && info.getProfitCenter().getId() != null) {
                sb.append(info.getProfitCenter().getId().toString());
            }
            if (info.getStorageOrgUnit() != null && info.getStorageOrgUnit().getId() != null) {
                sb.append(info.getStorageOrgUnit().getId().toString());
            }
            if (info.getWarehouse() != null && info.getWarehouse().getId() != null) {
                sb.append(info.getWarehouse().getId().toString());
            }
            if (info.getLocation() != null && info.getLocation().getId() != null) {
                sb.append(info.getLocation().getId().toString());
            }
            if (info.getMaterial() != null && info.getMaterial().getId() != null) {
                sb.append(info.getMaterial().getId().toString());
            }
            if (info.getLot() != null) {
                sb.append(info.getLot());
            }
            if (info.getAssistProperty() != null && info.getAssistProperty().getId() != null) {
                sb.append(info.getAssistProperty().getId().toString());
            }
            if (info.getProject() != null && info.getProject().getId() != null) {
                sb.append(info.getProject().getId().toString());
            }
            if (info.getTrackNumber() != null && info.getTrackNumber().getId() != null) {
                sb.append(info.getTrackNumber().getId().toString());
            }
            if (info.getStoreType() != null && info.getStoreType().getId() != null) {
                sb.append(info.getProject().getId().toString());
            }
            if (info.getAccount() != null && info.getAccount().getId() != null) {
                sb.append(info.getAccount().getId().toString());
            }
            map.put(sb.toString(), info.getId().toString());
        }
        return sb.toString();
    }

    @Override
    protected void _importBalance(Context ctx, Map params) throws BOSException, EASBizException {
        String profitCenter = (String)params.get("profitCenterid");
        Map storageMap = CalUtils.getStorageOrgUnits(ctx, new String[]{profitCenter});
        Set orgidSet = (Set)storageMap.get(profitCenter);
        String storageids = CalUtils.arrayToString(orgidSet.toArray());
        Map<String, PeriodInfo> periodMap = CalUtils.getPeriod(ctx, new String[]{profitCenter}, systemEnum);
        PeriodInfo curPeriod = periodMap.get(profitCenter);
        PeriodInfo startPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getProfitStartPeriod(systemEnum, profitCenter);
        if (startPeriod == null) {
            throw new InventoryBalanceException(InventoryBalanceException.PROFITNOTINITEXCEPTION);
        }
        boolean isStart = curPeriod.getId().toString().equals(startPeriod.getId().toString());
        if (isStart) {
            return;
        }
        Set warehouseSet = null;
        String warehouseids = null;
        if (!isStart) {
            warehouseSet = this.getWarehouse(ctx, curPeriod.getId().toString(), storageids);
            if (warehouseSet.size() <= 0) {
                return;
            }
            warehouseids = CalUtils.arrayToString(warehouseSet.toArray());
        }
        this.deleteBalanceData(ctx, curPeriod, profitCenter, warehouseids, isStart);
        this.insertBalanceData(ctx, curPeriod, profitCenter, warehouseids, storageids, isStart);
    }

    private void deleteBalanceData(Context ctx, PeriodInfo period, String profitCenter, String warehouseids, boolean isStart) throws BOSException {
        StringBuffer sql = new StringBuffer();
        int periodNumber = period.getPeriodNumber();
        int year = period.getPeriodYear();
        sql.append("delete T_CAL_InventoryBalance ");
        sql.append(" where FProfitCenterID = '").append(profitCenter).append("'");
        if (!isStart) {
            sql.append(" and FWarehouseID in (").append(warehouseids).append(")");
            sql.append(" and FYear = ").append(year);
            sql.append(" and FPeriod = ").append(periodNumber);
        }
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    private void insertBalanceData(Context ctx, PeriodInfo period, String profitCenter, String warehouseids, String storageids, boolean isStart) throws BOSException, EASBizException {
        int periodNumber = period.getPeriodNumber();
        int year = period.getPeriodYear();
        String periodid = period.getId().toString();
        ProfitCenterOrgUnitInfo orgInfo = new ProfitCenterOrgUnitInfo();
        orgInfo.setId(BOSUuid.read((String)profitCenter));
        String cuid = CalUtils.getCUID(ctx, orgInfo);
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert T_CAL_InventoryBalance (");
        sql.append(" fid,FPeriodID,FProfitCenterID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FBaseUnitID,");
        sql.append(" FAssistPropertyID,FAccountID,FStoreTypeID,FYear,FPeriod,");
        sql.append(" FMaterialID,flot,FProjectID,FTrackNumberID,FcontrolUnitid,");
        sql.append(" FPeriodBeginQty,FPeriodEndQty,FPeriodBeginBalance,FPeriodEndBalance,");
        sql.append(" FYearPeriodIssueAmount,FYearPeriodReceiptAmount,FYearReceiptQty,FYearPeriodIssueQty )");
        sql.append(" ( select ");
        sql.append(" newbosid('3CDC2D02'),'").append(periodid).append("','").append(profitCenter).append("',");
        sql.append(" b.FCompanyOrgUnitID,b.FStorageOrgUnitID,b.FWarehouseID,b.FLocationID,m.FBaseUnit,");
        sql.append(" b.FAssistPropertyID, null, b.FStoreTypeId, b.FYear, b.FPeriod,");
        sql.append(" b.FMaterialID, b.FLot, b.FProjectID,b.FTrackNumberID,'").append(cuid).append("',");
        sql.append(" b.FPeriodBeginQty,  b.FPeriodEndQty, b.FPeriodBeginBalance, b.FPeriodEndBalance,");
        sql.append(" (b.FYearIssueAmount -b.FPeriodReceiptAmount) as FYearIssueAmount,");
        sql.append(" (b.FYearReceiptAmount - b.FPeriodIssueAmount ) as FYearReceiptAmount,");
        sql.append(" (b.FYearReceiptQty - b.FPeriodReceiptQty ) as FYearReceiptQty ,");
        sql.append(" (b.FYearIssueQty - b.FPeriodIssueQty) as FYearIssueQty ");
        sql.append(" from T_IM_InventoryBalance as b inner join ");
        sql.append(" T_bd_material as m  on m.fid = b.FMaterialID ");
        sql.append(" where b.FStorageOrgUnitID in (").append(storageids).append(")");
        if (!isStart) {
            sql.append(" and b.FWarehouseID in (").append(warehouseids).append(")");
            sql.append(" and b.FYear = ").append(year);
            sql.append(" and b.FPeriod = ").append(periodNumber);
        }
        sql.append(" )");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    private Set getWarehouse(Context ctx, String periodid, String storageids) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FWarehouseID from T_DB_SOAccreditWH where FPeriodID = '").append(periodid).append("'");
        sql.append(" and FIsStarted = 1 and FStorageOrgID in (").append(storageids).append(")");
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> warehouseSet = new HashSet<String>();
        try {
            while (rs.next()) {
                warehouseSet.add(rs.getString("FWarehouseID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return warehouseSet;
    }

    private Map getNewWarehouse(Context ctx, String periodid, String storageids) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringBuffer name = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append(" select s.FWarehouseID, w.fname_").append(ctx.getLocale()).append(" as fname from T_DB_SOAccreditWH as s");
        sql.append(" inner join T_DB_WAREHOUSE as w on w.fid = s.FWarehouseID");
        sql.append(" where s.FPeriodID = '").append(periodid).append("'");
        sql.append(" and s.FIsStarted = 1 and s.FStorageOrgID in (").append(storageids).append(")");
        int size = 0;
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                name.append(rs.getString("fname")).append(",");
                ++size;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        map.put("size", size);
        map.put("warehouse", name.toString());
        return map;
    }

    @Override
    protected Map _getNewWarehouse(Context ctx, Map params) throws BOSException, EASBizException {
        String profitCenter = (String)params.get("profitCenterid");
        Map storageMap = CalUtils.getStorageOrgUnits(ctx, new String[]{profitCenter});
        Set orgidSet = (Set)storageMap.get(profitCenter);
        String storageids = CalUtils.arrayToString(orgidSet.toArray());
        PeriodInfo curPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getProfitCurrentPeriod(systemEnum, profitCenter);
        PeriodInfo startPeriod = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getProfitStartPeriod(systemEnum, profitCenter);
        if (curPeriod == null || startPeriod == null) {
            return null;
        }
        boolean isStart = curPeriod.getId().toString().equals(startPeriod.getId().toString());
        Object warehouseSet = null;
        Object warehouseids = null;
        if (!isStart) {
            return this.getNewWarehouse(ctx, curPeriod.getId().toString(), storageids);
        }
        return null;
    }

    @Override
    protected String[] _verifyDataUnique(Context ctx, InventoryBalanceCollection col) throws BOSException, EASBizException {
        String[] result = null;
        result = this.verifyLocalUnique(col);
        if (result != null && result.length > 0) {
            return result;
        }
        for (int i = 0; i < col.size(); ++i) {
            InventoryBalanceInfo info = col.get(i);
            String tempId = super.verifyDataUnique(ctx, info);
            if ("".equals(tempId)) continue;
            result = new String[]{info.getRowid(), tempId};
            return result;
        }
        return result;
    }

    private String[] verifyLocalUnique(InventoryBalanceCollection col) throws BOSException, EASBizException {
        HashMap<String, String> uniqueMap = new HashMap<String, String>();
        StringBuilder uniqueSB = new StringBuilder();
        String[] result = null;
        for (int i = 0; i < col.size(); ++i) {
            InventoryBalanceInfo info = col.get(i);
            uniqueSB.append(info.getProfitCenter().getId().toString());
            uniqueSB.append(info.getStorageOrgUnit().getId().toString());
            uniqueSB.append(info.getWarehouse().getId().toString());
            if (info.getLocation() != null && info.getLocation().getId() != null) {
                uniqueSB.append(info.getLocation().getId().toString());
            }
            uniqueSB.append(info.getMaterial().getId().toString());
            if (info.getLot() != null) {
                uniqueSB.append(info.getLot());
            }
            if (info.getAssistProperty() != null && info.getAssistProperty().getId() != null) {
                uniqueSB.append(info.getAssistProperty().getId().toString());
            }
            if (info.getProject() != null && info.getProject().getId() != null) {
                uniqueSB.append(info.getProject().getId().toString());
            }
            if (info.getTrackNumber() != null && info.getTrackNumber().getId() != null) {
                uniqueSB.append(info.getTrackNumber().getId().toString());
            }
            if (info.getStoreType() != null && info.getStoreType().getId() != null) {
                uniqueSB.append(info.getStoreType().getId().toString());
            }
            if (info.getAccount() != null && info.getAccount().getId() != null) {
                uniqueSB.append(info.getAccount().getId().toString());
            }
            if (uniqueMap.get(uniqueSB.toString()) != null) {
                result = new String[]{(String)uniqueMap.get(uniqueSB.toString()), info.getRowid()};
                break;
            }
            uniqueMap.put(uniqueSB.toString(), info.getRowid());
        }
        return result;
    }

    @Override
    protected String _verifyDataUnique(Context ctx, InventoryBalanceInfo info) throws BOSException, EASBizException {
        StringBuilder sqlBuilder = new StringBuilder();
        StringBuilder filterSB = new StringBuilder();
        if (info.getId() != null && !"".equals(info.getId().toString())) {
            filterSB.append(" fid <> '").append(info.getId().toString()).append("' ");
        }
        if (!"".equals(filterSB.toString())) {
            filterSB.append(" and ");
        }
        filterSB.append(" fprofitCenterid = '").append(info.getProfitCenter().getId().toString()).append("' ");
        filterSB.append(" and fstorageOrgUnitid = '").append(info.getStorageOrgUnit().getId().toString()).append("'");
        filterSB.append(" and fwarehouseid = '").append(info.getWarehouse().getId().toString()).append("'");
        if (info.getLocation() != null && info.getLocation().getId() != null) {
            filterSB.append(" and flocationid = '").append(info.getLocation().getId().toString()).append("'");
        }
        filterSB.append(" and fmaterialid = '").append(info.getMaterial().getId().toString()).append("'");
        if (info.getLot() != null) {
            filterSB.append(" and flot = '").append(info.getLot()).append("'");
        }
        if (info.getAssistProperty() != null && info.getAssistProperty().getId() != null) {
            filterSB.append(" and fassistPropertyid = '").append(info.getAssistProperty().getId().toString()).append("'");
        }
        if (info.getProject() != null && info.getProject().getId() != null) {
            filterSB.append(" and fprojectid = '").append(info.getProject().getId().toString()).append("'");
        }
        if (info.getTrackNumber() != null && info.getTrackNumber().getId() != null) {
            filterSB.append(" and ftrackNumberid = '").append(info.getTrackNumber().getId().toString()).append("'");
        }
        if (info.getStoreType() != null && info.getStoreType().getId() != null) {
            filterSB.append(" and fstoreTypeid = '").append(info.getStoreType().getId().toString()).append("'");
        }
        if (info.getAccount() != null && info.getAccount().getId() != null) {
            filterSB.append(" and faccountid = '").append(info.getAccount().getId().toString()).append("'");
        }
        sqlBuilder.append("select fid from t_cal_inventoryBalance where ").append((CharSequence)filterSB);
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString());
        try {
            if (rowset != null && rowset.next()) {
                String rowid = rowset.getString("fid");
                return rowid;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return "";
    }

    @Override
    protected Map _getInitData(Context ctx, Map map) throws BOSException, EASBizException {
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        HashMap<String, Boolean> closedMap = new HashMap<String, Boolean>();
        HashMap<String, CompanyOrgUnitInfo> profitCenterRelateCompany = new HashMap<String, CompanyOrgUnitInfo>();
        boolean isClosedInit = true;
        PeriodInfo[] periods = new PeriodInfo[3];
        String firstProfitCenterId2 = null;
        CompanyOrgUnitInfo companyInfo = null;
        Set set = (Set)map.get("profitCenterIds");
        ArrayList<ProfitCenterOrgUnitInfo> profitCenterList = new ArrayList<ProfitCenterOrgUnitInfo>();
        for (String firstProfitCenterId2 : set) {
            if (firstProfitCenterId2 != null) {
                boolean isStart = SystemStatusCtrolFactory.getRemoteInstance().isProfitStart(systemEnum, firstProfitCenterId2);
                if (!isStart) {
                    isClosedInit = false;
                    closedMap.put(firstProfitCenterId2, false);
                } else {
                    closedMap.put(firstProfitCenterId2, true);
                }
            }
            String companyId = CalUtils.getRelatedCompanyId(ctx, firstProfitCenterId2);
            ProfitCenterOrgUnitInfo profitCenterInfo = this.getProfitCenter(firstProfitCenterId2, new String[]{"name"});
            profitCenterList.add(profitCenterInfo);
            if (companyId == null) {
                throw new BOSException(this.getStrResource("profitCenter_companyId_null", new String[]{profitCenterInfo.getName()}, ctx.getOriginLocale()));
            }
            companyInfo = this.getCompanyInfoById(companyId);
            profitCenterRelateCompany.put(firstProfitCenterId2, companyInfo);
        }
        if (set.size() == 1) {
            periods = this.getPeriods(ctx, firstProfitCenterId2);
        }
        resultMap.put("isClosedInit", Boolean.valueOf(isClosedInit));
        if (periods[0] != null) {
            resultMap.put("startPeriod", (Serializable)periods[0]);
        }
        resultMap.put("profitClosedMap", closedMap);
        resultMap.put("profitCenterRelateCompany", profitCenterRelateCompany);
        resultMap.put("profitCenterList", profitCenterList);
        Object[] objectArray = new Object[set.size()];
        String[] strArray = new String[set.size()];
        set.toArray(strArray);
        Map storageMap = CalUtils.getStorageOrgUnits(ctx, strArray);
        HashMap<String, String> storageIdMap = new HashMap<String, String>();
        HashSet<String> storageIdsSet = new HashSet<String>();
        for (Object key : storageMap.keySet()) {
            Set storageIdSet = (Set)storageMap.get((String)key);
            Iterator storageIter = storageIdSet.iterator();
            while (storageIter.hasNext()) {
                storageIdsSet.add((String)storageIter.next());
            }
            storageIdMap.put((String)key, CalUtils.getSqlIDs(storageIdSet));
        }
        strArray = new String[storageIdsSet.size()];
        storageIdsSet.toArray(strArray);
        String[] storageIds = strArray;
        resultMap.put("storageIdMap", storageIdMap);
        ISOAccreditWH iSOAccreditWH = SOAccreditWHFactory.getLocalInstance((Context)ctx);
        HashMap<String, String> sOAccreditwhMap = new HashMap<String, String>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        for (int i = 0; i < storageIds.length; ++i) {
            fi.getFilterItems().add(new FilterItemInfo("STORAGEORG", (Object)storageIds[i]));
            viewInfo.setFilter(fi);
            viewInfo.getSelector().add(new SelectorItemInfo("warehouse"));
            SOAccreditWHCollection col = iSOAccreditWH.getSOAccreditWHCollection(viewInfo);
            if (col.size() <= 0) continue;
            String[] sOAccreditWHArr = new String[col.size()];
            for (int j = 0; j < col.size(); ++j) {
                SOAccreditWHInfo sOAccreditWHInfo = col.get(j);
                sOAccreditWHArr[j] = sOAccreditWHInfo.getWarehouse();
            }
            if (col.size() > 0) {
                sOAccreditwhMap.put(storageIds[i], CalUtils.getSqlIDs(sOAccreditWHArr));
            }
            fi.getFilterItems().clear();
            viewInfo.getSelector().clear();
        }
        resultMap.put("sOAccreditwhMap", sOAccreditwhMap);
        return resultMap;
    }

    public CompanyOrgUnitInfo getCompanyInfoById(String id) throws EASBizException, BOSException {
        CompanyOrgUnitInfo info = null;
        if (id != null && id.length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.number"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
            info = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        return info;
    }

    private ProfitCenterOrgUnitInfo getProfitCenter(String id, String[] fields) throws EASBizException, BOSException {
        ProfitCenterOrgUnitInfo info = null;
        if (id != null && id.length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            for (String field : fields) {
                sic.add(new SelectorItemInfo(field));
            }
            IProfitCenterOrgUnit iProfitCenter = ProfitCenterOrgUnitFactory.getRemoteInstance();
            info = iProfitCenter.getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        return info;
    }

    private PeriodInfo[] getPeriods(Context ctx, String profitCenterID) throws BOSException, EASBizException {
        PeriodInfo[] periods = new PeriodInfo[3];
        periods[0] = SystemStatusCtrolFactory.getRemoteInstance().getProfitStartPeriod(systemEnum, profitCenterID);
        periods[2] = SystemStatusCtrolFactory.getRemoteInstance().getProfitCurrentPeriod(systemEnum, profitCenterID);
        return periods;
    }

    private CtrlUnitInfo getCU(Context ctx, ProfitCenterOrgUnitInfo profitCenter) throws Exception {
        String cuid = CalUtils.getCUID(ctx, profitCenter);
        CtrlUnitInfo ctrlUnit = new CtrlUnitInfo();
        ctrlUnit.setId(BOSUuid.read((String)cuid));
        return ctrlUnit;
    }

    @Override
    protected List _getProfitCenterList(Context ctx) throws BOSException, EASBizException {
        FullOrgUnitCollection mainOrgs = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(ctx.getCaller().toString()), OrgType.ProfitCenter, null, "ma_cal_InventoryBalance_View");
        String orgIds = "";
        if (mainOrgs != null && mainOrgs.size() > 0) {
            for (int i = 0; i < mainOrgs.size(); ++i) {
                orgIds = orgIds + "'" + mainOrgs.get(i).getId().toString() + "',";
            }
            orgIds = orgIds.substring(0, orgIds.length() - 1);
        } else {
            orgIds = "'888888'";
        }
        ArrayList resultList = new ArrayList();
        StringBuffer sql = new StringBuffer();
        sql.append("select sys.FProfitCenterID,pc.fnumber,pc.flongnumber,pc.fname_" + ctx.getLocale().toString() + " as fname,sys.FIsStart,sys.fstartperiodid,startP.fdescription_" + ctx.getLocale().toString() + " as fstartperiod,sys.fcurrentperiodid,currP.fdescription_" + ctx.getLocale().toString() + " as fcurrentperiod  from t_Bd_Systemstatusctrol sys ");
        sql.append(" left join t_org_profitcenter pc on pc.fid = sys.FProfitCenterID");
        sql.append(" left join t_bd_period startP on startP.fid = sys.fstartperiodid");
        sql.append(" left join t_bd_period currP on currP.fid = sys.fcurrentperiodid");
        sql.append(" where sys.fsystemstatusid = (select top 1 fid from T_BD_SystemStatus where fname = '" + SystemEnum.PROFIT_CENTER_STORAGE.getValue() + "')");
        sql.append(" and sys.FProfitCenterID in (").append(orgIds).append(")");
        sql.append(" order by pc.FNumber");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("profitCenterID", rs.getString("FProfitCenterID"));
                map.put("profitCenterName", rs.getString("fname"));
                map.put("profitCenterNumber", rs.getString("fnumber"));
                map.put("profitCenterLongNumber", rs.getString("flongnumber"));
                map.put("isStart", rs.getString("FIsStart"));
                map.put("startperiod", rs.getString("fstartperiod"));
                map.put("currentperiod", rs.getString("fcurrentperiod"));
                resultList.add(map);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return resultList;
    }

    private String getStrResource(String resKey, Locale local) {
        return EASResource.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)resKey);
    }

    private String getStrResource(String resKey, String[] params, Locale local) {
        String s = this.getStrResource(resKey, local);
        MessageFormat mf = new MessageFormat(s);
        String result = mf.format(params);
        return result;
    }
}

