/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app.closeAccount;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.cal.BizCloseAccountException;
import com.kingdee.eas.ma.cal.app.utils.CalUtils;
import com.kingdee.eas.ma.scmcommon.tools.BizCommand;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceModelCache;
import com.kingdee.eas.scm.framework.balance.app.engine.ProfitCenterBalanceCalculator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CloseAccountService
extends BizCommand {
    public static final String NEWLINE = "\r\n";

    public CloseAccountService(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAccount(String profitCenterId) throws BOSException, EASBizException {
        Map prams = this.getSystemParams(profitCenterId);
        PeriodInfo curPeriodInfo = (PeriodInfo)prams.get("period");
        PeriodInfo nextPeriodInfo = (PeriodInfo)prams.get("nextPeriod");
        PeriodInfo prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (PeriodInfo)curPeriodInfo);
        PeriodInfo startPeriodInfo = (PeriodInfo)prams.get("startPeriodInfo");
        boolean isStartPeriod = false;
        boolean isSameYear = false;
        if (curPeriodInfo.getId().equals((Object)startPeriodInfo.getId())) {
            isStartPeriod = true;
        }
        if (curPeriodInfo.getPeriodYear() == prePeriodInfo.getPeriodYear()) {
            isSameYear = true;
        }
        String tmpTableName = null;
        String tmpTableName2 = null;
        try {
            tmpTableName = this.createTmpTable();
            tmpTableName2 = this.createTmpTable();
            String insertsql = this.getInsertDataSQL(tmpTableName, isStartPeriod);
            this.insertBalanceData(tmpTableName, insertsql, profitCenterId, prePeriodInfo, curPeriodInfo, isStartPeriod, isSameYear);
            this.insertBillData(tmpTableName, insertsql, profitCenterId, curPeriodInfo, isStartPeriod);
            this.insertCurPeriodData(insertsql, tmpTableName, tmpTableName2);
            if (isStartPeriod) {
                this.updateBalanceData(tmpTableName2, startPeriodInfo, profitCenterId);
                this.insertBalanceData4Start(tmpTableName2, startPeriodInfo);
            } else {
                this.deleteBalanceData(curPeriodInfo, profitCenterId);
                this.insertBalanceData(tmpTableName2);
            }
            this.insertNextBalanceData(tmpTableName2, nextPeriodInfo);
        }
        finally {
            if (tmpTableName != null) {
                this.releasTempTable(tmpTableName);
            }
            if (tmpTableName2 != null) {
                this.releasTempTable(tmpTableName);
            }
        }
        ProfitCenterOrgUnitInfo orgInfo = ProfitCenterOrgUnitFactory.getLocalInstance((Context)this.ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterId));
        boolean isAdjustPeriod = Boolean.parseBoolean(prams.get("isAdjustPeriod").toString());
        this.updatePeriod(true, (OrgUnitInfo)orgInfo, isAdjustPeriod);
    }

    private void closeAccount(Context ctx, String profitCenterId) throws BOSException, EASBizException {
        Map prams = this.getSystemParams(profitCenterId);
        PeriodInfo curPeriodInfo = (PeriodInfo)prams.get("period");
        PeriodInfo startPeriodInfo = (PeriodInfo)prams.get("startPeriodInfo");
        ProfitCenterBalanceCalculator calculator = null;
        BalanceModelInfo balanceModelInfo = BalanceModelCache.getBalanceModelInfo((Context)ctx, (String)"c6oAAABdahQj1GIy");
        calculator = new ProfitCenterBalanceCalculator(ctx, balanceModelInfo);
        calculator.calculate(profitCenterId, curPeriodInfo, OperationTypeEnum.Positive, startPeriodInfo);
        ProfitCenterOrgUnitInfo orgInfo = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterId));
        boolean isAdjustPeriod = Boolean.parseBoolean(prams.get("isAdjustPeriod").toString());
        this.updatePeriod(true, (OrgUnitInfo)orgInfo, isAdjustPeriod);
    }

    private void insertNextBalanceData(String tmpTableName, PeriodInfo nextPeriodInfo) throws BOSException {
        int year = nextPeriodInfo.getPeriodYear();
        int periodNumber = nextPeriodInfo.getPeriodNumber();
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert T_CAL_InventoryBalance (");
        sql.append(" fid,FPeriodID,FProfitCenterID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FBaseUnitID,");
        sql.append("  FAssistPropertyID,FAccountID,FStoreTypeID,FYear,FPeriod,");
        sql.append(" FMaterialID,flot,FProjectID,FTrackNumberID,FcontrolUnitid,");
        sql.append(" FPeriodBeginQty,FPeriodEndQty,FPeriodReceiptQty,FPeriodIssueQty,FPeriodBeginBalance,FPeriodEndBalance,");
        sql.append(" FPeriodReceiptAmount,FPeriodIssueAmount,FYearPeriodIssueAmount,FYearPeriodReceiptAmount,FYearReceiptQty,FYearPeriodIssueQty )");
        sql.append(" ( select ");
        sql.append("  newbosid('3CDC2D02'),FPeriodID,FProfitCenterID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FBaseUnitID,").append(NEWLINE);
        sql.append(" FAssistPropertyID,FAccountID,FStoreTypeId,").append(year).append(",").append(periodNumber).append(",");
        sql.append(" FMaterialID,FLot,FProjectID,FTrackNumberID,FcontrolUnitid,").append(NEWLINE);
        sql.append(" FPeriodEndQty,0,0,0,FPeriodEndBalance,0,0,0,0,0,0,0").append(NEWLINE);
        sql.append(" from ").append(tmpTableName);
        sql.append(" where FPeriodEndQty <> 0 and FPeriodEndBalance <>0 )");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString());
    }

    private void insertBalanceData4Start(String tmpTableName, PeriodInfo curPeriodInfo) throws BOSException {
        int year = curPeriodInfo.getPeriodYear();
        int periodNumber = curPeriodInfo.getPeriodNumber();
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert T_CAL_InventoryBalance (");
        sql.append(" fid,FPeriodID,FProfitCenterID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FBaseUnitID,");
        sql.append("  FAssistPropertyID,FAccountID,FStoreTypeID,FYear,FPeriod,");
        sql.append(" FMaterialID,flot,FProjectID,FTrackNumberID,FcontrolUnitid,");
        sql.append(" FPeriodBeginQty,FPeriodEndQty,FPeriodReceiptQty,FPeriodIssueQty,FPeriodBeginBalance,FPeriodEndBalance,");
        sql.append(" FPeriodReceiptAmount,FPeriodIssueAmount,FYearPeriodIssueAmount,FYearPeriodReceiptAmount,FYearReceiptQty,FYearPeriodIssueQty )");
        sql.append(" ( select ");
        sql.append("  newbosid('3CDC2D02'),t.FPeriodID,t.FProfitCenterID,t.FCompanyOrgUnitID,t.FStorageOrgUnitID,t.FWarehouseID,t.FLocationID,").append(NEWLINE);
        sql.append(" t.FBaseUnitID,t.FAssistPropertyID,t.FAccountID,t.FStoreTypeId,t.FYear,t.FPeriod,").append(NEWLINE);
        sql.append(" t.FMaterialID,t.FLot,t.FProjectID,t.FTrackNumberID,t.FcontrolUnitid,").append(NEWLINE);
        sql.append(" t.FPeriodBeginQty,t.FPeriodEndQty,t.FPeriodReceiptQty,t.FPeriodIssueQty,").append(NEWLINE);
        sql.append(" t.FPeriodBeginBalance,t.FPeriodEndBalance,t.FPeriodReceiptAmount,t.FPeriodIssueAmount,").append(NEWLINE);
        sql.append(" t.FYearIssueAmount,t.FYearReceiptAmount,t.FYearReceiptQty,t.FYearIssueQty ");
        sql.append(" from ").append(tmpTableName).append(" as t ");
        sql.append(" left join T_CAL_InventoryBalance as balance on ");
        sql.append(" t.fbalanceid = balance.fid  ");
        sql.append(" where balance.fid is null  ");
        sql.append(" )");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString());
    }

    private void updateBalanceData(String tmpTableName, PeriodInfo curPeriodInfo, String profitCenterId) throws BOSException {
        int year = curPeriodInfo.getPeriodYear();
        int periodNumber = curPeriodInfo.getPeriodNumber();
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(tmpTableName).append("  as t ");
        sql.append(" set( fbalanceid ) = ");
        sql.append(" ( select  ");
        sql.append("  balance.fid ");
        sql.append(" from T_CAL_InventoryBalance as balance ");
        sql.append(" where balance.FYear = ? and balance.FPeriod = ? and   FInitFlag = 1");
        sql.append(" and t.FProfitCenterID = balance.FProfitCenterID and t.FCompanyOrgUnitID = balance.FCompanyOrgUnitID ");
        sql.append(" and t.FStorageOrgUnitID = balance.FStorageOrgUnitID  ");
        sql.append(" and (t.FWarehouseID = balance.FWarehouseID or (t.FWarehouseID is null and balance.FWarehouseID is null ))");
        sql.append(" and (t.FLocationID = balance.FLocationID or (t.FLocationID is null and balance.FLocationID is null ))");
        sql.append(" and (t.FAssistPropertyID = balance.FAssistPropertyID or (t.FAssistPropertyID is null and balance.FAssistPropertyID is null ))");
        sql.append(" and (t.flot = balance.flot or (t.flot is null and balance.flot is null ))");
        sql.append(" and (t.FProjectID = balance.FProjectID or (t.FProjectID is null and balance.FProjectID is null ))");
        sql.append(" and (t.FTrackNumberID = balance.FTrackNumberID or (t.FTrackNumberID is null and balance.FTrackNumberID is null ))");
        sql.append(" and (t.FStoreTypeID = balance.FStoreTypeID or (t.FStoreTypeID is null and balance.FStoreTypeID is null ))");
        sql.append(" and (t.FAccountID = balance.FAccountID or (t.FAccountID is null and balance.FAccountID is null ))");
        sql.append(" and (t.FAssistPropertyID = balance.FAssistPropertyID or (t.FAssistPropertyID is null and balance.FAssistPropertyID is null ))");
        sql.append(" and (t.FMaterialID = balance.FMaterialID )");
        sql.append(")");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{year, periodNumber});
        sql.setLength(0);
        sql.append(" update T_CAL_InventoryBalance as balance");
        sql.append(" set( FPeriodReceiptQty ,FPeriodReceiptAmount ,FPeriodIssueQty ,FPeriodIssueAmount ,");
        sql.append(" FPeriodEndQty , FPeriodEndBalance , FYearPeriodIssueAmount , FYearPeriodReceiptAmount ,");
        sql.append(" FYearReceiptQty  ,FYearPeriodIssueQty ) = ");
        sql.append(" ( select  ");
        sql.append("  t.FPeriodReceiptQty,t.FPeriodReceiptAmount,t.FPeriodIssueQty,t.FPeriodIssueAmount, ");
        sql.append(" t.FPeriodEndQty,t.FPeriodEndBalance,t.FYearIssueAmount,t.FYearReceiptAmount,");
        sql.append(" t.FYearReceiptQty,t.FYearIssueQty ");
        sql.append(" from ").append(tmpTableName).append(" as t ");
        sql.append(" where t.fbalanceid = balance.fid )");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString());
    }

    private void insertBalanceData(String tmpTableName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert T_CAL_InventoryBalance (");
        sql.append(" fid,FPeriodID,FProfitCenterID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FBaseUnitID,");
        sql.append("  FAssistPropertyID,FAccountID,FStoreTypeID,FYear,FPeriod,");
        sql.append(" FMaterialID,flot,FProjectID,FTrackNumberID,FcontrolUnitid,");
        sql.append(" FPeriodBeginQty,FPeriodEndQty,FPeriodReceiptQty,FPeriodIssueQty,FPeriodBeginBalance,FPeriodEndBalance,");
        sql.append(" FPeriodReceiptAmount,FPeriodIssueAmount,FYearPeriodIssueAmount,FYearPeriodReceiptAmount,FYearReceiptQty,FYearPeriodIssueQty )");
        sql.append(" ( select ");
        sql.append("  newbosid('3CDC2D02'),FPeriodID,FProfitCenterID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FBaseUnitID,").append(NEWLINE);
        sql.append(" FAssistPropertyID,FAccountID,FStoreTypeId,FYear,FPeriod,").append(NEWLINE);
        sql.append(" FMaterialID,FLot,FProjectID,FTrackNumberID,FcontrolUnitid,").append(NEWLINE);
        sql.append(" FPeriodBeginQty,FPeriodEndQty,FPeriodReceiptQty,FPeriodIssueQty,").append(NEWLINE);
        sql.append(" FPeriodBeginBalance,FPeriodEndBalance,FPeriodReceiptAmount,FPeriodIssueAmount,").append(NEWLINE);
        sql.append(" FYearIssueAmount,FYearReceiptAmount,FYearReceiptQty,FYearIssueQty ");
        sql.append(" from ").append(tmpTableName).append(" )");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString());
    }

    private void insertCurPeriodData(String insertsql, String tmpTableName, String tmpTableName2) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert  ").append(tmpTableName2).append("(");
        sql.append(insertsql).append(")");
        sql.append(" ( select FPeriodID,");
        sql.append("  FProfitCenterID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FBaseUnitID,").append(NEWLINE);
        sql.append(" FAssistPropertyID,FAccountID,FStoreTypeId,FYear,FPeriod,").append(NEWLINE);
        sql.append(" FMaterialID,FLot,FProjectID,FTrackNumberID,FcontrolUnitid,").append(NEWLINE);
        sql.append(" sum(FPeriodBeginQty),sum(FPeriodBeginQty+FPeriodReceiptQty-FPeriodIssueQty),sum(FPeriodReceiptQty),sum(FPeriodIssueQty),").append(NEWLINE);
        sql.append(" sum(FPeriodBeginBalance),sum(FPeriodBeginBalance+FPeriodReceiptAmount-FPeriodIssueAmount),sum(FPeriodReceiptAmount),sum(FPeriodIssueAmount),").append(NEWLINE);
        sql.append(" sum(FYearIssueAmount+FPeriodIssueAmount),sum(FYearReceiptAmount+FPeriodReceiptAmount),");
        sql.append(" sum(FYearReceiptQty+FPeriodReceiptQty),sum(FYearIssueQty+FPeriodIssueQty)  ");
        sql.append(" from ").append(tmpTableName);
        sql.append("  group by FPeriodID,FProfitCenterID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FMaterialID,");
        sql.append("  FAssistPropertyID,flot,FProjectID,FTrackNumberID,FStoreTypeID,FAccountID ,FYear,FPeriod,FBaseUnitID,FcontrolUnitid)");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString());
    }

    private void deleteBalanceData(PeriodInfo curPeriodInfo, String profitCenterId) throws BOSException {
        int year = curPeriodInfo.getPeriodYear();
        int periodNumber = curPeriodInfo.getPeriodNumber();
        StringBuffer sql = new StringBuffer();
        sql.append(" delete T_CAL_InventoryBalance ");
        sql.append(" where FYear = ? and FPeriod = ? ");
        sql.append(" and FProfitCenterID = ? and FInitFlag = 0");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{year, periodNumber, profitCenterId});
    }

    private void insertBalanceData(String detailTableName, String insertsql, String profitCenterId, PeriodInfo prePeriodInfo, PeriodInfo curPeriodInfo, boolean isStartPeriod, boolean isSameYear) throws EASBizException, BOSException {
        int year = curPeriodInfo.getPeriodYear();
        int periodNumber = curPeriodInfo.getPeriodNumber();
        int preYear = prePeriodInfo.getPeriodYear();
        int prePeriodNumber = prePeriodInfo.getPeriodNumber();
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert  ").append(detailTableName).append("(");
        sql.append(insertsql).append(")");
        sql.append(" ( select FPeriodID,FProfitCenterID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FBaseUnitID,");
        sql.append("  FAssistPropertyID,FAccountID,FStoreTypeID,").append(year).append(" as FYear ,").append(periodNumber).append(" as FPeriod,");
        sql.append(" FMaterialID,flot,FProjectID,FTrackNumberID,FcontrolUnitid,");
        if (isStartPeriod) {
            sql.append(" FPeriodBeginQty as FPeriodBeginQty,0 as FPeriodEndQty,0 as FPeriodReceiptQty ,0 as FPeriodIssueQty,");
            sql.append(" FPeriodBeginBalance as FPeriodBeginBalance,0 as FPeriodEndBalance,0 as FPeriodReceiptAmount,0 as FPeriodIssueAmount,");
            sql.append(" FYearPeriodIssueAmount,FYearPeriodReceiptAmount,FYearReceiptQty,FYearPeriodIssueQty ");
        } else if (isSameYear) {
            sql.append(" FPeriodEndQty as FPeriodBeginQty,0 as FPeriodEndQty,0 as FPeriodReceiptQty ,0 as FPeriodIssueQty,");
            sql.append(" FPeriodEndBalance as FPeriodBeginBalance,0 as FPeriodEndBalance,0 as FPeriodReceiptAmount,0 as FPeriodIssueAmount,");
            sql.append(" FYearPeriodIssueAmount,FYearPeriodReceiptAmount,FYearReceiptQty,FYearPeriodIssueQty ");
        } else {
            sql.append(" FPeriodEndQty as FPeriodBeginQty,0 as FPeriodEndQty,0 as FPeriodReceiptQty ,0 as FPeriodIssueQty,");
            sql.append(" FPeriodEndBalance as FPeriodBeginBalance,0 as FPeriodEndBalance,0 as FPeriodReceiptAmount,0 as FPeriodIssueAmount,");
            sql.append(" 0 as FYearIssueAmount,0 as FYearReceiptAmount,0 as FYearReceiptQty,0 as FYearIssueQty ");
        }
        sql.append(" from T_CAL_InventoryBalance  ");
        sql.append("  where FProfitCenterID = ? and FYear = ? and FPeriod = ? ");
        sql.append("  )");
        if (isStartPeriod) {
            SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{profitCenterId, year, periodNumber});
        } else {
            SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{profitCenterId, preYear, prePeriodNumber});
        }
    }

    private String getInsertDataSQL(String detailTableName, boolean isStartPeriod) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append(" KSQL_SEQ,FPeriodID,FProfitCenterID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FLocationID,FBaseUnitID,").append(NEWLINE);
        sSQL.append(" FAssistPropertyID,FAccountID,FStoreTypeId,FYear,FPeriod,").append(NEWLINE);
        sSQL.append(" FMaterialID,FLot,FProjectID,FTrackNumberID,FcontrolUnitid,").append(NEWLINE);
        sSQL.append(" FPeriodBeginQty,FPeriodEndQty,FPeriodReceiptQty,FPeriodIssueQty,FPeriodBeginBalance,FPeriodEndBalance,").append(NEWLINE);
        sSQL.append(" FPeriodReceiptAmount,FPeriodIssueAmount,FYearIssueAmount,FYearReceiptAmount,FYearReceiptQty,FYearIssueQty  ");
        return sSQL.toString();
    }

    private void insertBillData(String detailTableName, String insertsql, String profitCenterId, PeriodInfo curPeriodInfo, boolean isStartPeriod) throws EASBizException, BOSException {
        Date beginData = curPeriodInfo.getBeginDate();
        Date endData = CalUtils.getDate(curPeriodInfo.getEndDate(), 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        int year = curPeriodInfo.getPeriodYear();
        int periodNumber = curPeriodInfo.getPeriodNumber();
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert  ").append(detailTableName).append("(");
        sql.append(insertsql).append(")");
        sql.append(" ( select FPeriodID, FProfitCenterID,FCompanyID,FStorageOrgUnitID,FWarehouseID,FLocationID,FBaseUnitID,");
        sql.append("  FAssistPropertyID,FAccountID,FStoreTypeID,").append(year).append(" as FYear,").append(periodNumber).append(" as FPeriod,");
        sql.append("FMaterialID,flot,FProjectID,FTrackNumberID,FcontrolUnitid,");
        sql.append("  0 as FPeriodBeginQty,0 as FPeriodEndQty,(case  FOutOrInWareHouse when 20 then sum(FBaseQty) else 0 end ) as FPeriodReceiptQty ,");
        sql.append(" (case  FOutOrInWareHouse when 10 then sum(FBaseQty) else 0 end ) as FPeriodIssueQty, ");
        sql.append("  0 as FPeriodBeginBalance,0 as FPeriodEndBalance,(case  FOutOrInWareHouse when 20 then sum(FCost) else 0 end ) as FPeriodReceiptAmount ,");
        sql.append(" (case  FOutOrInWareHouse when 10 then sum(FCost) else 0 end ) as FPeriodIssueAmount,");
        sql.append(" 0 as FYearIssueAmount,0 as FYearReceiptAmount,0 as FYearReceiptQty,0 as FYearIssueQty ");
        sql.append(" from T_CAL_InvAccountBill  ");
        sql.append("  where FProfitCenterID = ? and FBizDate > to_date(?) and FBizDate < to_date(?) ");
        sql.append("  group by FPeriodID,FProfitCenterID,FCompanyID,FStorageOrgUnitID,FWarehouseID,FLocationID,");
        sql.append("  FAssistPropertyID,flot,FProjectID,FTrackNumberID,FStoreTypeID,FAccountID ");
        sql.append("  ,FMaterialID ,FcontrolUnitid,FOutOrInWareHouse,FBaseUnitID");
        sql.append("  )");
        SQLUtils.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{profitCenterId, sdf.format(beginData), sdf.format(endData)});
    }

    private String createTmpTable() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" create TABLE TEML_KSQL_0 ( ");
        sql.append(" KSQL_SEQ int identity(1,1) NOT NULL ,");
        sql.append(" FPeriodID varchar(44),");
        sql.append(" fbalanceid varchar(44),");
        sql.append(" FProfitCenterID varchar(44),");
        sql.append(" FCompanyOrgUnitID varchar(44),");
        sql.append(" FStorageOrgUnitID varchar(44),");
        sql.append(" FWarehouseID varchar(44),");
        sql.append(" FLocationID varchar(44),");
        sql.append(" FBaseUnitID varchar(44),");
        sql.append(" FAssistPropertyID varchar(44),");
        sql.append(" FAccountID varchar(44),");
        sql.append(" FStoreTypeId varchar(44),");
        sql.append(" FMaterialID varchar(44),");
        sql.append(" FLot nvarchar(255) NULL,");
        sql.append(" FProjectID varchar(44),");
        sql.append(" FTrackNumberID varchar(44),");
        sql.append(" FcontrolUnitid varchar(44),");
        sql.append(" FPeriod int ,");
        sql.append(" FYear int,");
        sql.append(" FPeriodBeginQty  numeric(21, 8) DEFAULT 0,");
        sql.append(" FPeriodEndQty numeric(21, 8) DEFAULT 0,");
        sql.append(" FPeriodReceiptQty numeric(21, 8) DEFAULT 0,");
        sql.append(" FPeriodIssueQty numeric(21, 8) DEFAULT 0,");
        sql.append(" FPeriodBeginBalance numeric(17, 4) DEFAULT 0,");
        sql.append(" FPeriodEndBalance numeric(17, 4) DEFAULT 0,");
        sql.append(" FPeriodReceiptAmount numeric(17, 4) DEFAULT 0,");
        sql.append(" FPeriodIssueAmount numeric(17, 4) DEFAULT 0,");
        sql.append(" FYearIssueAmount  numeric(17, 4) DEFAULT 0,");
        sql.append(" FYearReceiptAmount  numeric(17, 4) DEFAULT 0, ");
        sql.append(" FYearReceiptQty numeric(21, 8) DEFAULT 0,");
        sql.append(" FYearIssueQty numeric(21, 8) DEFAULT 0 ");
        sql.append(")");
        String tempTable = null;
        try {
            tempTable = SQLUtils.createTempTableWithNewTx((Context)this.ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }

    private Map getSystemParams(String profitCenterId) throws EASBizException, BOSException {
        int precision;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        PeriodInfo curPeriodInfo = null;
        PeriodInfo nextPeriodInfo = null;
        PeriodInfo startPeriodInfo = null;
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx);
        curPeriodInfo = iSystemStatusCtrol.getProfitCurrentPeriod(1007, profitCenterId);
        startPeriodInfo = iSystemStatusCtrol.getProfitStartPeriod(1007, profitCenterId);
        if (curPeriodInfo == null) {
            throw new BizCloseAccountException(BizCloseAccountException.NOTSTARTPERIOD);
        }
        nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)this.ctx, (PeriodInfo)curPeriodInfo);
        String isAdjustPeriod = "false";
        if (nextPeriodInfo.isIsAdjustPeriod()) {
            nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)this.ctx, (PeriodInfo)nextPeriodInfo);
            isAdjustPeriod = "true";
        }
        if (nextPeriodInfo.getId() == null) {
            throw new BizCloseAccountException(BizCloseAccountException.NEXTPERIODISNULL);
        }
        paramMap.put("period", curPeriodInfo);
        paramMap.put("nextPeriod", nextPeriodInfo);
        paramMap.put("startPeriodInfo", startPeriodInfo);
        String companyid = CalUtils.getRelatedCompanyId(this.ctx, profitCenterId);
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        if (companyInfo.getBaseCurrency().getId() == null) {
            precision = 2;
        } else {
            ICurrency ic = CurrencyFactory.getLocalInstance((Context)this.ctx);
            CurrencyInfo ci = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyInfo.getBaseCurrency().getId()), CloseAccountService.getCurrencySelector());
            precision = ci.getPrecision();
        }
        paramMap.put("precision", new Integer(precision));
        paramMap.put("companyOrgUnitID", companyInfo.getId().toString());
        paramMap.put("isAdjustPeriod", isAdjustPeriod);
        return paramMap;
    }

    public static SelectorItemCollection getCurrencySelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("sign"));
        selector.add(new SelectorItemInfo("baseUnit"));
        selector.add(new SelectorItemInfo("precision"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        return selector;
    }

    public void unCloseAccount() {
    }

    private void updatePeriod(boolean isforword, OrgUnitInfo orgInfo, boolean isAdjustPeriod) throws EASBizException, BOSException {
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx);
        if (isforword) {
            iSystemStatusCtrol.nextPeriod(SystemEnum.PROFIT_CENTER_STORAGE, orgInfo);
            if (isAdjustPeriod) {
                iSystemStatusCtrol.nextPeriod(SystemEnum.PROFIT_CENTER_STORAGE, orgInfo);
            }
        } else {
            iSystemStatusCtrol.prePeriod(SystemEnum.PROFIT_CENTER_STORAGE, orgInfo);
        }
    }

    public String getTaskID() {
        return null;
    }

    protected Object doing(Object profitCenterId) throws BOSException, EASBizException {
        this.closeAccount(this.ctx, profitCenterId.toString());
        return null;
    }

    private void releasTempTable(String tmpTableName) throws BOSException {
        if (tmpTableName == null || tmpTableName.trim().length() == 0) {
            return;
        }
        TempTablePool tmpTblPool = TempTablePool.getInstance((Context)this.ctx);
        try {
            tmpTblPool.releaseTable(tmpTableName);
        }
        catch (Exception e) {
            throw new BOSException("cannot release tempTable", (Throwable)e);
        }
    }
}

