/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app.issueCalculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.cal.app.issueCalculate.CalculateCommon;
import com.kingdee.eas.ma.cal.app.issueCalculate.Calculater;
import com.kingdee.eas.ma.cal.app.issueCalculate.IAccountTypeCalculate;
import com.kingdee.eas.ma.cal.app.issueCalculate.MaterialDimension;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AverageCalculater
implements IAccountTypeCalculate {
    private Calculater pCmd = null;
    private String materialId = null;
    private MaterialDimension dim = null;
    private AccountType accountType = null;
    private CalculateCommon calCommon = null;
    private int pricePrecision = 8;
    private int qtyPrecision = 8;

    public AverageCalculater(Map<String, Object> params) {
        this.pCmd = (Calculater)((Object)params.get("bizCommand"));
        this.dim = (MaterialDimension)params.get("materialDemension");
        this.materialId = (String)params.get("materialId");
        this.pricePrecision = (Integer)params.get("pricePrecision");
        this.qtyPrecision = (Integer)params.get("qtyPrecision");
        this.accountType = (AccountType)params.get("accountType");
        this.calCommon = new CalculateCommon(this.pCmd, this.materialId, this.dim, this.accountType);
    }

    @Override
    public void calculate() throws Exception {
        Map<String, BigDecimal[]> calMap = this.calCommon.sumBalance();
        calMap = this.sumInware(calMap);
        calMap = this.sumOutware(calMap);
        this.calculateOutCost(calMap);
    }

    private void calculateOutCost(Map<String, BigDecimal[]> calMap) throws Exception {
        Iterator<String> iter = calMap.keySet().iterator();
        String key = null;
        BigDecimal[] data = null;
        BigDecimal unitCost = null;
        BigDecimal qty = null;
        while (iter.hasNext()) {
            key = iter.next();
            data = calMap.get(key);
            BigDecimal beginCost = data[1] == null ? BigDecimal.ZERO : data[1];
            BigDecimal inCost = data[3] == null ? BigDecimal.ZERO : data[3];
            BigDecimal beginQty = data[0] == null ? BigDecimal.ZERO : data[0];
            BigDecimal inQty = data[2] == null ? BigDecimal.ZERO : data[2];
            qty = beginQty.add(inQty);
            unitCost = qty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : beginCost.add(inCost).divide(qty, 8, 4);
            this.calculateOutCostByDim(data, key, unitCost);
        }
    }

    private void calculateOutCostByDim(BigDecimal[] data, String key, BigDecimal unitCost) throws Exception {
        boolean isPriceExcep = false;
        if (unitCost.compareTo(BigDecimal.ZERO) < 0) {
            isPriceExcep = true;
        }
        if (!isPriceExcep) {
            this.updateBillCost(data, key, unitCost);
            this.diffCost(data, key);
        }
        this.report(key, data, unitCost, isPriceExcep);
    }

    private void updateBillCost(BigDecimal[] data, String key, BigDecimal unitCost) throws Exception {
        Map<String, Object> retMap = this.dim.keyToWhere(key, 1, null);
        String keyWhere = (String)retMap.get("where");
        List paramsList = (List)retMap.get("params");
        StringBuffer sbWhere = new StringBuffer();
        StringBuffer sbSql = new StringBuffer();
        sbSql.append(" update T_CAL_InvAccountBill ").append(" set FUnitCost = ?, ").append(" FCost = round(FBaseQty*").append(unitCost.toPlainString()).append(",").append(this.pCmd.currencyPrecision).append(") ");
        sbWhere.append(" where FProfitCenterID = ? ").append(" and FPeriodID = ? ").append(" and FOutOrInWareHouse = 10 ").append(" and FFiVouchered = 0 ").append(keyWhere);
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        BigDecimal unitCost2 = unitCost.setScale(this.pricePrecision, 4);
        sqlParams.add(unitCost2);
        sqlParams.add(this.pCmd.profitCenterOrgId);
        sqlParams.add(this.pCmd.periodId);
        sqlParams.addAll(paramsList);
        sbSql.append(sbWhere);
        this.pCmd.execute(sbSql.toString(), sqlParams.toArray());
    }

    private void diffCost(BigDecimal[] data, String key) throws Exception {
        BigDecimal beginQty = data[0] == null ? BigDecimal.ZERO : data[0];
        BigDecimal inQty = data[2] == null ? BigDecimal.ZERO : data[2];
        BigDecimal outQty = data[4] == null ? BigDecimal.ZERO : data[4];
        BigDecimal beginCost = data[1] == null ? BigDecimal.ZERO : data[1];
        BigDecimal inCost = data[3] == null ? BigDecimal.ZERO : data[3];
        BigDecimal outCost = null;
        BigDecimal diffQty = beginQty.add(inQty).subtract(outQty);
        if (diffQty.compareTo(BigDecimal.ZERO) == 0) {
            Map<String, Object> bill;
            outCost = this.sumOutwareCost(key);
            BigDecimal minCostVal = BigDecimal.ONE.movePointLeft(this.pCmd.currencyPrecision);
            BigDecimal diffCost = beginCost.add(inCost).subtract(outCost);
            if (diffCost.compareTo(BigDecimal.ZERO) > 0 && diffCost.compareTo(minCostVal) > 0 && (bill = this.getLastBill(key)) != null) {
                String diffBillId = (String)bill.get("ID");
                BigDecimal cost = diffCost.add((BigDecimal)bill.get("Cost"));
                BigDecimal unitCost = cost.divide((BigDecimal)bill.get("BaseQty"), this.pricePrecision, 4);
                cost = cost.setScale(this.pCmd.currencyPrecision, 4);
                String sql = "update T_CAL_InvAccountBill set FUnitCost = ?,FCost = ? where FID = ?";
                this.pCmd.execute(sql, new Object[]{unitCost, cost, diffBillId});
            }
        }
    }

    private Map<String, BigDecimal[]> sumInware(Map<String, BigDecimal[]> calMap) throws Exception {
        StringBuffer sbSql = new StringBuffer();
        String groupCols = this.dim.getSelect(null, 1);
        sbSql.append("select ").append(groupCols).append(" ,sum(FBaseQty) sumQty, ").append(" sum(FCost) sumCost ").append(" from T_CAL_InvAccountBill ").append(" where FProfitCenterID = ? ").append(" and FPeriodID = ? ").append(" and FMaterialID = ? ").append(" and FOutOrInWareHouse = 20 ").append(" group by ").append(groupCols);
        String key = null;
        Object[] sqlParams = new Object[]{this.pCmd.profitCenterOrgId, this.pCmd.periodId, this.materialId};
        IRowSet rsIn = this.pCmd.executeQuery(sbSql.toString(), sqlParams);
        while (rsIn.next()) {
            BigDecimal[] data;
            key = this.dim.buildKey(rsIn, 1);
            if (calMap.containsKey(key)) {
                data = calMap.get(key);
                if (data[2] != null) {
                    throw new Exception("inware data error! val:" + key);
                }
                data[2] = rsIn.getBigDecimal("sumQty");
                data[3] = rsIn.getBigDecimal("sumCost");
                continue;
            }
            data = new BigDecimal[5];
            data[2] = rsIn.getBigDecimal("sumQty");
            data[3] = rsIn.getBigDecimal("sumCost");
            calMap.put(key, data);
        }
        return calMap;
    }

    private Map<String, BigDecimal[]> sumOutware(Map<String, BigDecimal[]> calMap) throws Exception {
        StringBuffer sbSql = new StringBuffer();
        String groupCols = this.dim.getSelect(null, 1);
        sbSql.append("select ").append(groupCols).append(" ,sum(FBaseQty) sumQty ").append(" from T_CAL_InvAccountBill ").append(" where FProfitCenterID = ? ").append(" and FPeriodID = ? ").append(" and FMaterialID = ? ").append(" and FOutOrInWareHouse = 10 ").append(" group by ").append(groupCols);
        String key = null;
        Object[] sqlParams = new Object[]{this.pCmd.profitCenterOrgId, this.pCmd.periodId, this.materialId};
        IRowSet rsOut = this.pCmd.executeQuery(sbSql.toString(), sqlParams);
        while (rsOut.next()) {
            BigDecimal[] data;
            key = this.dim.buildKey(rsOut, 1);
            if (calMap.containsKey(key)) {
                data = calMap.get(key);
                if (data[4] != null) {
                    throw new Exception("outware data error! val:" + key);
                }
                data[4] = rsOut.getBigDecimal("sumQty");
                continue;
            }
            data = new BigDecimal[5];
            data[4] = rsOut.getBigDecimal("sumQty");
            calMap.put(key, data);
        }
        return calMap;
    }

    private BigDecimal sumOutwareCost(String key) throws Exception {
        String groupCols = this.dim.getSelect(null, 1);
        Map<String, Object> retMap = this.dim.keyToWhere(key, 1, null);
        String keyWhere = (String)retMap.get("where");
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select sum(FCost) sumCost ").append(" from T_CAL_InvAccountBill ").append(" where FProfitCenterID = ? ").append(" and FPeriodID = ? ").append(" and FOutOrInWareHouse = 10 ").append(keyWhere).append(" group by ").append(groupCols);
        ArrayList<String> sqlParams = new ArrayList<String>();
        sqlParams.add(this.pCmd.profitCenterOrgId);
        sqlParams.add(this.pCmd.periodId);
        sqlParams.addAll((List)retMap.get("params"));
        BigDecimal sumOutCost = BigDecimal.ZERO;
        IRowSet rsOut = this.pCmd.executeQuery(sbSql.toString(), sqlParams.toArray());
        if (rsOut.next()) {
            if (rsOut.size() == 1) {
                sumOutCost = rsOut.getBigDecimal("sumCost");
            } else {
                throw new Exception("sumary outware cost error.key :" + key);
            }
        }
        return sumOutCost;
    }

    private Map<String, Object> getLastBill(String key) throws Exception {
        Map<String, Object> retMap = this.dim.keyToWhere(key, 1, null);
        String keyWhere = (String)retMap.get("where");
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select top 1 FID,FBaseQty,FCost ").append(" from T_CAL_InvAccountBill ").append(" where FProfitCenterID = ? ").append(" and FPeriodID = ? ").append(" and FOutOrInWareHouse = 10 ").append(keyWhere).append(" order by FBilldate desc,FauditTime desc ");
        ArrayList<String> sqlParams = new ArrayList<String>();
        sqlParams.add(this.pCmd.profitCenterOrgId);
        sqlParams.add(this.pCmd.periodId);
        sqlParams.addAll((List)retMap.get("params"));
        HashMap<String, Object> billMap = null;
        IRowSet rsOut = this.pCmd.executeQuery(sbSql.toString(), sqlParams.toArray());
        if (rsOut.next()) {
            if (rsOut.size() == 1) {
                billMap = new HashMap<String, Object>();
                billMap.put("ID", rsOut.getString("FID"));
                billMap.put("BaseQty", rsOut.getBigDecimal("FBaseQty"));
                billMap.put("Cost", rsOut.getBigDecimal("FCost"));
            } else {
                throw new Exception("getLastBill error.key :" + key);
            }
        }
        return billMap;
    }

    private void reportError(String key, String result) throws Exception {
        if (this.pCmd.isReportError()) {
            this.calCommon.reportHead(key, false, result);
        }
    }

    private void report(String key, BigDecimal[] data, BigDecimal unitCost, boolean isPriceExcep) throws Exception {
        if (!this.pCmd.isReport()) {
            return;
        }
        String reportId = this.calCommon.reportHead(key, !isPriceExcep, "");
        this.reportPeriodStart(reportId, data);
        this.reportPeriodDetail(reportId, key, isPriceExcep);
        this.reportPeriodEnd(reportId, data, key, isPriceExcep);
    }

    private void reportPeriodEnd(String reportId, BigDecimal[] data, String key, boolean isPriceExcep) throws Exception {
        String result = null;
        if (isPriceExcep) {
            result = EASResource.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"NegativeBalance");
        } else {
            BigDecimal beginQty = data[0] == null ? BigDecimal.ZERO : data[0];
            BigDecimal beginCost = data[1] == null ? BigDecimal.ZERO : data[1];
            BigDecimal inQty = data[2] == null ? BigDecimal.ZERO : data[2];
            BigDecimal inCost = data[3] == null ? BigDecimal.ZERO : data[3];
            BigDecimal outQty = data[4] == null ? BigDecimal.ZERO : data[4];
            BigDecimal endCost = null;
            BigDecimal endQty = beginQty.add(inQty).subtract(outQty);
            BigDecimal endUnitCost = null;
            if (BigDecimal.ZERO.compareTo(endQty) == 0) {
                endUnitCost = BigDecimal.ZERO;
                endCost = BigDecimal.ZERO;
            } else {
                endCost = beginCost.add(inCost).subtract(this.sumOutwareCost(key));
                endUnitCost = endCost.divide(endQty, this.pricePrecision, 4);
            }
            result = endQty.setScale(this.qtyPrecision, 4).toPlainString() + " * " + endUnitCost.setScale(this.pricePrecision, 4).toPlainString() + " = " + endCost.setScale(this.pCmd.currencyPrecision, 4).toPlainString();
        }
        this.calCommon.reportEnd(reportId, result);
    }

    private void reportPeriodDetail(String reportId, String key, boolean isPriceExcep) throws BOSException, EASBizException {
        Map<String, Object> retMap = this.dim.keyToWhere(key, 1, null);
        String keyWhere = (String)retMap.get("where");
        List paramsList = (List)retMap.get("params");
        StringBuffer sbReport = new StringBuffer();
        sbReport.append("insert into T_CAL_IssueCalRepDetail (").append("FID,FSEQ,FProfitCenOrgId,FPeriodId,FParentID,FBillNumber,FBillId,FIncome,FIssue) ").append(" select newbosid('").append("98AE2674").append("'),1,").append(" FProfitCenterID,FPeriodID,'").append(reportId).append("',FSourcebillnumber,FID,").append(" case FOutOrInWareHouse when 20 then ").append(" TO_CHAR(FBaseQty, 'NUMBER', ").append(this.qtyPrecision).append(") || '*' || TO_CHAR(FUnitCost, 'NUMBER', ").append(this.pricePrecision).append(") || ' = ' || TO_CHAR(FCost, 'NUMBER', ").append(this.pCmd.currencyPrecision).append(") ").append(" else '' end,").append(" case FOutOrInWareHouse when 10 then ").append(" TO_CHAR(FBaseQty, 'NUMBER', ").append(this.qtyPrecision).append(") ||  '*' || TO_CHAR(FUnitCost, 'NUMBER', ").append(this.pricePrecision).append(") || ' = ' || TO_CHAR(FCost, 'NUMBER', ").append(this.pCmd.currencyPrecision).append(") ").append(" else '' end ").append(" FROM T_CAL_InvAccountBill ").append(" where FProfitCenterID = ? ").append(" and FPeriodID = ? ").append(keyWhere);
        ArrayList<String> sqlParams = new ArrayList<String>();
        sqlParams.add(this.pCmd.profitCenterOrgId);
        sqlParams.add(this.pCmd.periodId);
        sqlParams.addAll(paramsList);
        this.pCmd.execute(sbReport.toString(), sqlParams.toArray());
    }

    private void reportPeriodStart(String reportId, BigDecimal[] data) throws BOSException, EASBizException {
        StringBuffer sbReport = new StringBuffer();
        String entryId = BOSUuid.create((String)"98AE2674").toString();
        BigDecimal beginQty = data[0];
        BigDecimal beginCost = data[1];
        if (beginQty == null) {
            beginQty = BigDecimal.ZERO;
        }
        if (beginCost == null) {
            beginCost = BigDecimal.ZERO;
        }
        BigDecimal beginUnitCost = null;
        beginUnitCost = beginQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : beginCost.divide(beginQty, 8, 4);
        String periodStart = EASResource.getString((String)"com.kingdee.eas.ma.cal.CalBillResource", (String)"periodStart");
        sbReport.append("insert into T_CAL_IssueCalRepDetail (").append("FID,FSEQ,FBillNumber,FProfitCenOrgId,FPeriodId,FParentID,FBalance) ").append("values ('").append(entryId).append("',0,'").append(periodStart).append("','").append(this.pCmd.profitCenterOrgId).append("','").append(this.pCmd.periodId).append("','").append(reportId).append("','").append(beginQty.setScale(this.qtyPrecision, 4).toPlainString()).append(" * ").append(beginUnitCost.setScale(this.pricePrecision, 4).toPlainString()).append(" = ").append(beginCost.setScale(this.pCmd.currencyPrecision, 4).toPlainString()).append("')");
        this.pCmd.execute(sbReport.toString());
    }
}

