/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app.issueCalculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Map;

public final class BillChecker {
    private BillChecker() {
    }

    public static int checkZeroBill(Context ctx, Map<String, String> params) throws BOSException, EASBizException {
        String profitCenterOrgId = params.get("profitCenterOrgId");
        String periodId = params.get("periodId");
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select count(FID) errNum ").append(" from T_CAL_InvAccountBill ").append(" where FProfitCenterID = ? ").append(" and FPeriodID = ? ").append(" and FOutOrInWareHouse = 20 ").append(" and FCost = 0 ").append(" and FSourceBillTypeID != '").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'").append(" and fisPresent !=1");
        String materialFilter = params.get("materialFilter");
        if (materialFilter != null) {
            sbSql.append("and FmaterialId in (").append(materialFilter).append(")");
        }
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])new Object[]{profitCenterOrgId, periodId});
        int errorNum = 0;
        try {
            if (rs.next()) {
                errorNum = rs.getInt("errNum");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return errorNum;
    }

    public static int checkVoucherBill(Context ctx, Map<String, String> params) throws BOSException, EASBizException {
        String profitCenterOrgId = params.get("profitCenterOrgId");
        String periodId = params.get("periodId");
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select count(FID) errNum ").append(" from T_CAL_InvAccountBill ").append(" where FProfitCenterID = ? ").append(" and FPeriodID = ? ").append(" and FOutOrInWareHouse = 10 ").append(" and FFiVouchered = 1 ");
        String materialFilter = params.get("materialFilter");
        if (materialFilter != null) {
            sbSql.append("and FmaterialId in (").append(materialFilter).append(")");
        }
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])new Object[]{profitCenterOrgId, periodId});
        int errorNum = 0;
        try {
            if (rs.next()) {
                errorNum = rs.getInt("errNum");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return errorNum;
    }

    public static int checkUnAuditBill(Context ctx, Map<String, String> params) throws BOSException, EASBizException {
        String profitCenterOrgId = params.get("profitCenterOrgId");
        String periodId = params.get("periodId");
        StringBuffer sbSql = new StringBuffer();
        sbSql.append(" select count(inv.FID) errNum ");
        sbSql.append(" from T_CAL_InvAccountBill  as inv ");
        sbSql.append(" left join T_BD_MATERIALPROFITCENTERINFO mp on inv.FMaterialID = mp.FMaterialID and inv.fprofitCenterId = mp.FPROFITCENTERID ");
        sbSql.append(" where inv.FProfitCenterID = ? ");
        sbSql.append(" and inv.FPeriodID = ? ");
        sbSql.append(" and mp.fstatus != 1");
        String materialFilter = params.get("materialFilter");
        if (materialFilter != null) {
            sbSql.append("and inv.FmaterialId in (").append(materialFilter).append(")");
        }
        IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])new Object[]{profitCenterOrgId, periodId});
        int errorNum = 0;
        try {
            if (rs.next()) {
                errorNum = rs.getInt("errNum");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return errorNum;
    }
}

