/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app.transferbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.cal.BillTransferFacadeFactory;
import com.kingdee.eas.ma.cal.TransferRuleCollection;
import com.kingdee.eas.ma.cal.TransferRuleFactory;
import com.kingdee.eas.ma.cal.TransferRuleInfo;
import com.kingdee.eas.ma.cal.app.transferbill.TransferRuleSqlBuilder;
import com.kingdee.eas.ma.cal.app.utils.CalUtils;
import com.kingdee.eas.ma.scmcommon.app.thread.SyncLock;
import com.kingdee.eas.ma.scmcommon.app.thread.SyncTask;
import com.kingdee.eas.ma.scmcommon.app.thread.ThreadPool;
import com.kingdee.eas.ma.scmcommon.tools.BizCommand;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BillTransfer
extends BizCommand {
    private String taskid = null;

    public String getTaskID() {
        return this.taskid;
    }

    public BillTransfer(Context ctx) {
        super(ctx);
    }

    protected Object doing(Object params) throws BOSException, EASBizException {
        this.transfer((Map)params);
        return null;
    }

    private void transfer(Map params) throws EASBizException, BOSException {
        this.taskid = (String)params.get("parentTaskid");
        String transferType = (String)params.get("transferType");
        List rows = (List)params.get("rows");
        ArrayList<Map> transferList = new ArrayList<Map>();
        ArrayList<String> profitCenteridsList = new ArrayList<String>();
        ArrayList<String> sourceBillTypeidsList = new ArrayList<String>();
        Map row = null;
        int size = rows.size();
        for (int i = 0; i < size; ++i) {
            row = (Map)rows.get(i);
            if (row.get("profitCenterid") == null || row.get("sourceBillTypeid") == null) continue;
            transferList.add(row);
            profitCenteridsList.add(row.get("profitCenterid").toString());
            sourceBillTypeidsList.add(row.get("sourceBillTypeid").toString());
        }
        String[] profitCenterids = new String[profitCenteridsList.size()];
        String[] sourceBillTypeids = new String[sourceBillTypeidsList.size()];
        profitCenteridsList.toArray(profitCenterids);
        sourceBillTypeidsList.toArray(sourceBillTypeids);
        Map<String, TransferRuleSqlBuilder> ruleMap = this.getTransferRuleSqlBuilder(sourceBillTypeids);
        Map<String, PeriodInfo> periodMap = CalUtils.getPeriod(this.ctx, profitCenterids, 1007);
        Map storageOrgUnitsMap = CalUtils.getStorageOrgUnits(this.ctx, profitCenterids);
        String sourcebilltypeid = null;
        String profitCenterid = null;
        PeriodInfo periodInfo = null;
        TransferRuleSqlBuilder ruleSql = null;
        HashMap<String, Object> transferParams = null;
        String subtaskid = null;
        ThreadPool threadPool = ThreadPool.getInstance();
        SyncLock lock = new SyncLock();
        Map rowData = null;
        String key = null;
        int size2 = transferList.size();
        for (int i = 0; i < size2; ++i) {
            rowData = (Map)transferList.get(i);
            profitCenterid = (String)rowData.get("profitCenterid");
            sourcebilltypeid = (String)rowData.get("sourceBillTypeid");
            subtaskid = (String)rowData.get("taskid");
            key = profitCenterid + sourcebilltypeid;
            ruleSql = ruleMap.get(sourcebilltypeid);
            periodInfo = periodMap.get(profitCenterid);
            transferParams = new HashMap<String, Object>();
            transferParams.put("periodInfo", periodInfo);
            transferParams.put("ruleSql", ruleSql);
            transferParams.put("profitCenterid", profitCenterid);
            transferParams.put("sourceBillTypeid", sourcebilltypeid);
            transferParams.put("storageOrgUnitidset", storageOrgUnitsMap.get(profitCenterid));
            transferParams.put("parantTask", this.taskid);
            transferParams.put("taskId", subtaskid);
            transferParams.put("transferType", transferType);
            BillTransferTask billTransferTask = new BillTransferTask(this.ctx, subtaskid, lock, key, transferParams);
            lock.addLock(key);
            threadPool.addTask((Runnable)((Object)billTransferTask));
        }
        lock.waitFinish();
    }

    public Map<String, TransferRuleSqlBuilder> getTransferRuleSqlBuilder(String[] sourceBillTypeids) throws BOSException {
        TransferRuleCollection tCol = null;
        HashMap<String, TransferRuleSqlBuilder> transferRuleSQLMap = new HashMap<String, TransferRuleSqlBuilder>();
        TransferRuleSqlBuilder builder = null;
        tCol = TransferRuleFactory.getLocalInstance(this.ctx).getTransferRuleCollection(" select *,entrys.*,transactionTypeentrys.*,sourcebillType.bosType where sourcebillType in (" + CalUtils.arrayToString(sourceBillTypeids) + ") and status =1 ");
        TransferRuleInfo rule = null;
        int size = tCol.size();
        for (int i = 0; i < size; ++i) {
            rule = tCol.get(i);
            builder = new TransferRuleSqlBuilder(this.ctx, rule);
            builder.createSql();
            transferRuleSQLMap.put(rule.getSourcebillType().getId().toString(), builder);
        }
        return transferRuleSQLMap;
    }

    public Map<String, PeriodInfo> getPeriod(Context ctx, String[] orgids) throws BOSException, EASBizException {
        int systemEnum = 1006;
        String profitCenterid2 = null;
        PeriodInfo periodInfo = null;
        HashMap<String, PeriodInfo> periodMap = new HashMap<String, PeriodInfo>();
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        for (String profitCenterid2 : orgids) {
            if (StringUtils.isEmpty((String)profitCenterid2)) continue;
            periodInfo = iSystemStatusCtrol.getProfitCurrentPeriod(systemEnum, profitCenterid2);
            periodMap.put(profitCenterid2, periodInfo);
        }
        return periodMap;
    }

    class BillTransferTask
    extends SyncTask {
        public BillTransferTask(Context ctx, String taskid, SyncLock lock, String lockType, Object inParam) {
            super(ctx, taskid, lock, lockType, inParam);
        }

        protected Object doing(Object inParam) throws BOSException, EASBizException {
            BillTransferFacadeFactory.getLocalInstance(BillTransfer.this.ctx).transfer((Map)inParam);
            return null;
        }
    }
}

