/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app.transferbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.cal.app.transferbill.BillTransferCommon;
import com.kingdee.eas.ma.cal.app.transferbill.DeleteBill;
import com.kingdee.eas.ma.cal.app.transferbill.TransferBillSQLBuilder;
import com.kingdee.eas.ma.cal.app.transferbill.TransferRuleSqlBuilder;
import com.kingdee.eas.ma.cal.app.utils.CalUtils;
import com.kingdee.eas.ma.scmcommon.tools.SQLUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BillTransferService {
    private BillTransferCommon common = new BillTransferCommon();

    public int createBill(Context ctx, String billId, String storageOrgUnitid, String sourceBillTypeid, int year, int period) throws BOSException, EASBizException {
        String[] sourceBillTypeids = new String[]{sourceBillTypeid};
        Map<String, TransferRuleSqlBuilder> ruleMap = this.common.getTransferRuleSqlBuilder(ctx, sourceBillTypeids);
        Object[] storageOrgUnitids = new String[]{storageOrgUnitid};
        Map profitCenteridMap = CalUtils.getProfitCenterids(ctx, (String[])storageOrgUnitids);
        String profitCenterid = (String)profitCenteridMap.get(storageOrgUnitid);
        ProfitCenterOrgUnitInfo profitCenter = ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(profitCenterid));
        String cuid = profitCenter.getCU().getId().toString();
        String[] profitCenterids = new String[]{profitCenterid};
        Map<String, PeriodInfo> periodMap = CalUtils.getPeriod(ctx, profitCenterids, 1007);
        PeriodInfo currentPeriod = periodMap.get(profitCenterid);
        CompanyOrgUnitInfo companyOrgUnit = CalUtils.getCompanyOrgUnit(ctx, storageOrgUnitid, 4);
        PeriodInfo bizPeriod = CalUtils.getPeriod(ctx, companyOrgUnit.getAccountPeriodType().getId().toString(), year, period);
        if (bizPeriod.getPeriodYear() < currentPeriod.getPeriodYear() || bizPeriod.getPeriodYear() == currentPeriod.getPeriodYear() && bizPeriod.getPeriodNumber() < currentPeriod.getPeriodNumber()) {
            return 0;
        }
        TransferRuleSqlBuilder ruleSql = ruleMap.get(sourceBillTypeid);
        String transferType = "bill";
        CompanyOrgUnitInfo company = CalUtils.getCompanyOrgUnit(ctx, storageOrgUnitid, 4);
        String baseCurrencyID = "";
        if (company != null) {
            baseCurrencyID = company.getBaseCurrency().getId().toString();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date beginData = bizPeriod.getBeginDate();
        Date endData = CalUtils.getDate(bizPeriod.getEndDate(), 1);
        String storageOrgIds = CalUtils.arrayToString(storageOrgUnitids);
        HashMap<String, Object> sqlBuilderParams = new HashMap<String, Object>();
        sqlBuilderParams.put("ruleSql", ruleSql);
        sqlBuilderParams.put("sourcebilltypeid", sourceBillTypeid);
        sqlBuilderParams.put("profitCenterid", profitCenterid);
        sqlBuilderParams.put("cuid", cuid);
        sqlBuilderParams.put("baseCurrencyID", baseCurrencyID);
        sqlBuilderParams.put("storageOrgIds", storageOrgIds);
        sqlBuilderParams.put("beginData", sdf.format(beginData));
        sqlBuilderParams.put("endData", sdf.format(endData));
        sqlBuilderParams.put("periodID", bizPeriod.getId().toString());
        sqlBuilderParams.put("transferType", transferType);
        sqlBuilderParams.put("billId", billId);
        TransferBillSQLBuilder sqlBuilder = new TransferBillSQLBuilder(ctx, sqlBuilderParams);
        this.deleteBill(ctx, billId);
        StringBuffer batchSQL = new StringBuffer();
        String sql = sqlBuilder.getImportIssueBillSQL();
        batchSQL.append(sql).append(";");
        sql = sqlBuilder.getImportInWarehsBillSQL();
        batchSQL.append(sql).append(";");
        int[] resultNum = SQLUtils.executeBatch((Context)ctx, (String[])batchSQL.toString().split(";"));
        int updateCount = 0;
        int size = resultNum.length;
        for (int i = 0; i < size; ++i) {
            updateCount += resultNum[i];
        }
        return updateCount;
    }

    public int deleteBill(Context ctx, String billId) throws BOSException, EASBizException {
        DeleteBill deleteBill = new DeleteBill();
        return deleteBill.deleteData(ctx, billId);
    }
}

