/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.cal.app.transferbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ma.cal.BillTransferConstant;
import com.kingdee.eas.ma.cal.InvAccountBillInfo;
import com.kingdee.eas.ma.cal.TransferRuleEntryCollection;
import com.kingdee.eas.ma.cal.TransferRuleEntryInfo;
import com.kingdee.eas.ma.cal.TransferRuleInfo;
import com.kingdee.eas.ma.cal.app.utils.CalUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class TransferRuleSqlBuilder {
    private String wheresql = null;
    private String insertsql = null;
    private String fromsql = null;
    private String selectsql = null;
    private String srcBosType = null;
    private Context ctx = null;
    private String tableName = null;
    private String entryTableName = null;
    private String entryAliasName = null;
    private TransferRuleInfo ruleInfo = null;
    private String updateColumn = null;
    private String updateSelectColumn = null;

    public TransferRuleSqlBuilder(Context ctx, TransferRuleInfo ruleInfo) {
        this.ctx = ctx;
        this.ruleInfo = ruleInfo;
    }

    public void createSql() throws BOSException {
        this.setSrcBosType();
        this.setFilter();
        this.setInsertSql();
        this.setSelectSql();
    }

    private void setSrcBosType() {
        this.srcBosType = this.ruleInfo.getSourcebillType().getBosType() == null ? BillTransferConstant.BILLTYPE_BOSTYPE_MAP.get(this.ruleInfo.getSourcebillType().getId().toString()) : this.ruleInfo.getSourcebillType().getBosType();
    }

    private void setFilter() throws BOSException {
        String queryPK = CalUtils.getEntityQueryPK(this.ctx, this.srcBosType);
        if (this.ruleInfo.getFilter() == null) {
            return;
        }
        String idFilter = CalUtils.structureFilter(this.ctx, this.ruleInfo.getFilter(), queryPK);
        StringBuffer where = new StringBuffer();
        where.append(" and bill.FID not in ( ").append(idFilter).append(" ) ");
        this.wheresql = where.toString();
    }

    private void setSelectSql() {
        int index;
        int i;
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entityInfo = loader.getEntity(BOSObjectType.create((String)this.srcBosType));
        TransferRuleEntryCollection entrys = this.ruleInfo.getEntrys();
        StringBuffer select = new StringBuffer();
        StringBuffer from = new StringBuffer();
        ArrayList<String> entryList = new ArrayList<String>();
        this.setTableName(entityInfo.getTable().getName());
        from.append(this.getTableName()).append(" as bill ");
        TransferRuleEntryInfo entry = null;
        String filed = null;
        PropertyInfo propertyInfo = null;
        String entryName = null;
        String entryFiled = null;
        EntityObjectInfo entryBO = null;
        RelationshipInfo relationshipInfo = null;
        String baseQtyField = "baseQty";
        String actualCost = "cost";
        String targetfield = null;
        StringBuffer updateColumnStr = new StringBuffer();
        StringBuffer updateSelectColumnStr = new StringBuffer();
        String sourcebilltypeid = this.ruleInfo.getSourcebillType().getId().toString();
        HashMap<String, String> fieldmapping = new HashMap<String, String>();
        int size = entrys.size();
        for (i = 0; i < size; ++i) {
            entry = entrys.get(i);
            filed = entry.getSrcfield();
            targetfield = entry.getTargetField();
            index = filed.indexOf(".");
            if (index > 0) {
                fieldmapping.put(targetfield, filed.substring(index + 1));
                continue;
            }
            fieldmapping.put(targetfield, filed);
        }
        size = entrys.size();
        for (i = 0; i < size; ++i) {
            entry = entrys.get(i);
            filed = entry.getSrcfield();
            targetfield = entry.getTargetField();
            if (filed == null) continue;
            index = filed.indexOf(".");
            if (index > 0) {
                entryName = filed.substring(0, index);
                entryFiled = filed.substring(index + 1);
                if (this.getEntryTableName() == null && (propertyInfo = entityInfo.getPropertyByNameRuntime(entryName)) instanceof LinkPropertyInfo) {
                    relationshipInfo = ((LinkPropertyInfo)propertyInfo).getRelationship();
                    entryBO = relationshipInfo.getSupplierObject();
                    this.setEntryTableName(entryBO.getTable().getName());
                }
                if (!entryList.contains(entryName)) {
                    from.append(" inner join ").append(this.getEntryTableName()).append(" as ").append(entryName);
                    from.append(" on ").append(" bill.fid = ").append(entryName).append(".");
                    from.append(relationshipInfo.getSupplierProperty().getMappingField().getName());
                    this.setEntryAliasName(entryName);
                    entryList.add(entryName);
                }
                if (!BillTransferConstant.STANDARD_BILLTYPE_LIST.contains(sourcebilltypeid)) continue;
                if (BillTransferConstant.NEED_UPDATE_COLUMNS.contains(targetfield)) {
                    updateColumnStr.append("F").append(targetfield).append(",");
                    if ("innerPrice".equals(targetfield)) {
                        updateSelectColumnStr.append(" case when ").append(entryName).append(".");
                        updateSelectColumnStr.append(entryBO.getPropertyByNameRuntime((String)fieldmapping.get("baseQty")).getMappingField().getName()).append(" = 0 then 0");
                        updateSelectColumnStr.append(" else ").append(entryName).append(".");
                        updateSelectColumnStr.append(entryBO.getPropertyByNameRuntime((String)fieldmapping.get("innerAmount")).getMappingField().getName()).append("/");
                        updateSelectColumnStr.append(entryName).append(".");
                        updateSelectColumnStr.append(entryBO.getPropertyByNameRuntime((String)fieldmapping.get("baseQty")).getMappingField().getName()).append(" end,");
                    } else {
                        updateSelectColumnStr.append(entryName).append(".").append(entryBO.getPropertyByNameRuntime(entryFiled).getMappingField().getName()).append(" ,");
                    }
                }
                if ((targetfield.equals(baseQtyField) || targetfield.equals(actualCost)) && this.ruleInfo.getReturnBizDirection() != null && this.ruleInfo.getReturnBizDirection().getValue() == -1) {
                    select.append(" case when recIssueType.FBizDirection= -1 then 0-");
                    select.append(entryName).append(".").append(entryBO.getPropertyByNameRuntime(entryFiled).getMappingField().getName());
                    select.append(" else ");
                    select.append(entryName).append(".").append(entryBO.getPropertyByNameRuntime(entryFiled).getMappingField().getName()).append(" end,");
                    continue;
                }
                if ("innerPrice".equals(targetfield)) {
                    select.append(" case when ").append(entryName).append(".");
                    select.append(entryBO.getPropertyByNameRuntime((String)fieldmapping.get("baseQty")).getMappingField().getName()).append(" = 0 then 0");
                    select.append(" else ").append(entryName).append(".");
                    select.append(entryBO.getPropertyByNameRuntime((String)fieldmapping.get("innerAmount")).getMappingField().getName()).append("/");
                    select.append(entryName).append(".");
                    select.append(entryBO.getPropertyByNameRuntime((String)fieldmapping.get("baseQty")).getMappingField().getName()).append(" end,");
                    continue;
                }
                if ("unitCost".equals(targetfield)) {
                    select.append(" case when ").append(entryName).append(".");
                    select.append(entryBO.getPropertyByNameRuntime((String)fieldmapping.get("baseQty")).getMappingField().getName()).append(" = 0 then 0");
                    select.append(" else ").append(entryName).append(".");
                    select.append(entryBO.getPropertyByNameRuntime((String)fieldmapping.get("cost")).getMappingField().getName()).append("/");
                    select.append(entryName).append(".");
                    select.append(entryBO.getPropertyByNameRuntime((String)fieldmapping.get("baseQty")).getMappingField().getName()).append(" end,");
                    continue;
                }
                select.append(entryName).append(".").append(entryBO.getPropertyByNameRuntime(entryFiled).getMappingField().getName()).append(" ,");
                continue;
            }
            propertyInfo = entityInfo.getPropertyByNameRuntime(filed);
            select.append(" bill.").append(propertyInfo.getMappingField().getName()).append(", ");
        }
        if (updateColumnStr.length() > 0) {
            this.setUpdateColumn(updateColumnStr.substring(0, updateColumnStr.length() - 1));
        }
        if (updateSelectColumnStr.length() > 0) {
            this.setUpdateSelectColumn(updateSelectColumnStr.substring(0, updateSelectColumnStr.length() - 1));
        }
        this.fromsql = from.toString();
        this.selectsql = select.toString();
    }

    private void setInsertSql() {
        InvAccountBillInfo iInfo = new InvAccountBillInfo();
        TransferRuleEntryCollection entrys = this.ruleInfo.getEntrys();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entityInfo = loader.getEntity(iInfo.getBOSType());
        StringBuffer insert = new StringBuffer();
        TransferRuleEntryInfo entry = null;
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            entry = entrys.get(i);
            if (entry.getSrcfield() == null) continue;
            String colName = entityInfo.getPropertyByName(entry.getTargetField()).getMappingField().getName();
            insert.append(colName).append(",");
        }
        this.insertsql = insert.toString();
    }

    public String getCountSql() throws BOSException {
        return "";
    }

    public String getWheresql() {
        return this.wheresql;
    }

    public String getInsertsql() {
        return this.insertsql;
    }

    public String getFromsql() {
        return this.fromsql;
    }

    public String getSrcBosType() {
        return this.srcBosType;
    }

    public void setSrcBosType(String srcBosType) {
        this.srcBosType = srcBosType;
    }

    public String getSelectsql() {
        return this.selectsql;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getEntryTableName() {
        return this.entryTableName;
    }

    public void setEntryTableName(String entryTableName) {
        this.entryTableName = entryTableName;
    }

    public TransferRuleInfo getRuleInfo() {
        return this.ruleInfo;
    }

    public void setRuleInfo(TransferRuleInfo ruleInfo) {
        this.ruleInfo = ruleInfo;
    }

    public String getEntryAliasName() {
        return this.entryAliasName;
    }

    public void setEntryAliasName(String entryAliasName) {
        this.entryAliasName = entryAliasName;
    }

    public String getUpdateColumn() {
        return this.updateColumn;
    }

    public void setUpdateColumn(String updateColumn) {
        this.updateColumn = updateColumn;
    }

    public String getUpdateSelectColumn() {
        return this.updateSelectColumn;
    }

    public void setUpdateSelectColumn(String updateSelectColumn) {
        this.updateSelectColumn = updateSelectColumn;
    }
}

